/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JFrame;
import jline.SimpleCompletor;

public class ClassNameCompletor
extends SimpleCompletor {
    public ClassNameCompletor() throws IOException {
        this((SimpleCompletor.SimpleCompletorFilter)null);
    }

    public ClassNameCompletor(SimpleCompletor.SimpleCompletorFilter filter) throws IOException {
        super(ClassNameCompletor.getClassNames(), filter);
        this.setDelimiter(".");
    }

    public static String[] getClassNames() throws IOException {
        HashSet<URL> urls = new HashSet<URL>();
        for (ClassLoader loader = ClassNameCompletor.class.getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            urls.addAll(Arrays.asList(((URLClassLoader)loader).getURLs()));
        }
        Class[] systemClasses = new Class[]{String.class, JFrame.class};
        for (int i = 0; i < systemClasses.length; ++i) {
            URLConnection uc;
            URL classURL = systemClasses[i].getResource("/" + systemClasses[i].getName().replace('.', '/') + ".class");
            if (classURL == null || !((uc = classURL.openConnection()) instanceof JarURLConnection)) continue;
            urls.add(((JarURLConnection)uc).getJarFileURL());
        }
        HashSet<String> classes = new HashSet<String>();
        for (URL url : urls) {
            File file = new File(url.getFile());
            if (file.isDirectory()) {
                Set files = ClassNameCompletor.getClassFiles(file.getAbsolutePath(), new HashSet(), file, new int[]{200});
                classes.addAll(files);
                continue;
            }
            if (file == null || !file.isFile() || !file.toString().endsWith(".jar")) continue;
            JarFile jf = new JarFile(file);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                String name;
                JarEntry entry = e.nextElement();
                if (entry == null || !(name = entry.getName()).endsWith(".class")) continue;
                classes.add(name);
            }
        }
        TreeSet<String> classNames = new TreeSet<String>();
        for (String name : classes) {
            classNames.add(name.replace('/', '.').substring(0, name.length() - 6));
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    private static Set getClassFiles(String root, Set holder, File directory, int[] maxDirectories) {
        int n = maxDirectories[0];
        maxDirectories[0] = n - 1;
        if (n < 0) {
            return holder;
        }
        File[] files = directory.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            String name = files[i].getAbsolutePath();
            if (!name.startsWith(root)) continue;
            if (files[i].isDirectory()) {
                ClassNameCompletor.getClassFiles(root, holder, files[i], maxDirectories);
                continue;
            }
            if (!files[i].getName().endsWith(".class")) continue;
            holder.add(files[i].getAbsolutePath().substring(root.length() + 1));
        }
        return holder;
    }
}

