/*======================================================================================================================
 * trees/NamedEntityTreeView.cpp is part of Brewtarget, and is copyright the following authors 2024-2026:
 *   • Matt Young <mfsy@yahoo.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Brewtarget is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 =====================================================================================================================*/
#include "trees/NamedEntityTreeView.h"

#include "model/RecipeAdditionFermentable.h"
#include "model/RecipeAdditionHop.h"
#include "model/RecipeAdditionMisc.h"
#include "model/RecipeAdditionYeast.h"
#include "model/RecipeAdjustmentSalt.h"
#include "model/RecipeUseOfWater.h"

TREE_VIEW_COMMON_CODE(Boil                , BoilStep                  )
TREE_VIEW_COMMON_CODE(Equipment           )
TREE_VIEW_COMMON_CODE(Fermentable         )
TREE_VIEW_COMMON_CODE(Fermentation        , FermentationStep          )
TREE_VIEW_COMMON_CODE(Hop                 )
TREE_VIEW_COMMON_CODE(StockPurchaseFermentable, StockUseFermentable)
TREE_VIEW_COMMON_CODE(StockPurchaseHop        , StockUseHop        )
TREE_VIEW_COMMON_CODE(StockPurchaseMisc       , StockUseMisc       )
TREE_VIEW_COMMON_CODE(StockPurchaseSalt       , StockUseSalt       )
TREE_VIEW_COMMON_CODE(StockPurchaseYeast      , StockUseYeast      )
TREE_VIEW_COMMON_CODE(Mash                , MashStep                  )
TREE_VIEW_COMMON_CODE(Misc                )
TREE_VIEW_COMMON_CODE(Salt                )
TREE_VIEW_COMMON_CODE(Style               )
TREE_VIEW_COMMON_CODE(Water               )
TREE_VIEW_COMMON_CODE(Yeast               )
