//autogenerated:yes
//nolint:revive,misspell,govet,lll
package common

// Acknowledgment message during waypoint handling. The type field states if this message is a positive ack (type=0) or if an error happened (type=non-zero).
type MessageMissionAck struct {
	// System ID
	TargetSystem uint8
	// Component ID
	TargetComponent uint8
	// Mission result.
	Type MAV_MISSION_RESULT `mavenum:"uint8"`
	// Mission type.
	MissionType MAV_MISSION_TYPE `mavenum:"uint8" mavext:"true"`
	// Id of new on-vehicle mission, fence, or rally point plan (on upload to vehicle).
	// The id is calculated and returned by a vehicle when a new plan is uploaded by a GCS.
	// The only requirement on the id is that it must change when there is any change to the on-vehicle plan type (there is no requirement that the id be globally unique).
	// 0 on download from the vehicle to the GCS (on download the ID is set in MISSION_COUNT).
	// 0 if plan ids are not supported.
	// The current on-vehicle plan ids are streamed in `MISSION_CURRENT`, allowing a GCS to determine if any part of the plan has changed and needs to be re-uploaded.
	OpaqueId uint32 `mavext:"true"`
}

// GetID implements the message.Message interface.
func (*MessageMissionAck) GetID() uint32 {
	return 47
}
