//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package development

import (
	"fmt"
	"strconv"
)

// Actuator groups to test in MAV_CMD_ACTUATOR_GROUP_TEST.
type ACTUATOR_TEST_GROUP uint64

const (
	// Actuators that contribute to roll torque.
	ACTUATOR_TEST_GROUP_ROLL_TORQUE ACTUATOR_TEST_GROUP = 0
	// Actuators that contribute to pitch torque.
	ACTUATOR_TEST_GROUP_PITCH_TORQUE ACTUATOR_TEST_GROUP = 1
	// Actuators that contribute to yaw torque.
	ACTUATOR_TEST_GROUP_YAW_TORQUE ACTUATOR_TEST_GROUP = 2
	// Actuators that affect collective tilt.
	ACTUATOR_TEST_GROUP_COLLECTIVE_TILT ACTUATOR_TEST_GROUP = 3
)

var value_to_label_ACTUATOR_TEST_GROUP = map[ACTUATOR_TEST_GROUP]string{
	ACTUATOR_TEST_GROUP_ROLL_TORQUE:     "ACTUATOR_TEST_GROUP_ROLL_TORQUE",
	ACTUATOR_TEST_GROUP_PITCH_TORQUE:    "ACTUATOR_TEST_GROUP_PITCH_TORQUE",
	ACTUATOR_TEST_GROUP_YAW_TORQUE:      "ACTUATOR_TEST_GROUP_YAW_TORQUE",
	ACTUATOR_TEST_GROUP_COLLECTIVE_TILT: "ACTUATOR_TEST_GROUP_COLLECTIVE_TILT",
}

var label_to_value_ACTUATOR_TEST_GROUP = map[string]ACTUATOR_TEST_GROUP{
	"ACTUATOR_TEST_GROUP_ROLL_TORQUE":     ACTUATOR_TEST_GROUP_ROLL_TORQUE,
	"ACTUATOR_TEST_GROUP_PITCH_TORQUE":    ACTUATOR_TEST_GROUP_PITCH_TORQUE,
	"ACTUATOR_TEST_GROUP_YAW_TORQUE":      ACTUATOR_TEST_GROUP_YAW_TORQUE,
	"ACTUATOR_TEST_GROUP_COLLECTIVE_TILT": ACTUATOR_TEST_GROUP_COLLECTIVE_TILT,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e ACTUATOR_TEST_GROUP) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_ACTUATOR_TEST_GROUP[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *ACTUATOR_TEST_GROUP) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_ACTUATOR_TEST_GROUP[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = ACTUATOR_TEST_GROUP(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e ACTUATOR_TEST_GROUP) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
