//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package development

import (
	"fmt"
	"strconv"
	"strings"
)

// Status flags for GLOBAL_POSITION
type GLOBAL_POSITION_FLAGS uint64

const (
	// Unhealthy sensor/estimator.
	GLOBAL_POSITION_UNHEALTHY GLOBAL_POSITION_FLAGS = 1
	// True if the data originates from or is consumed by the primary estimator.
	GLOBAL_POSITION_PRIMARY GLOBAL_POSITION_FLAGS = 2
)

var values_GLOBAL_POSITION_FLAGS = []GLOBAL_POSITION_FLAGS{
	GLOBAL_POSITION_UNHEALTHY,
	GLOBAL_POSITION_PRIMARY,
}

var value_to_label_GLOBAL_POSITION_FLAGS = map[GLOBAL_POSITION_FLAGS]string{
	GLOBAL_POSITION_UNHEALTHY: "GLOBAL_POSITION_UNHEALTHY",
	GLOBAL_POSITION_PRIMARY:   "GLOBAL_POSITION_PRIMARY",
}

var label_to_value_GLOBAL_POSITION_FLAGS = map[string]GLOBAL_POSITION_FLAGS{
	"GLOBAL_POSITION_UNHEALTHY": GLOBAL_POSITION_UNHEALTHY,
	"GLOBAL_POSITION_PRIMARY":   GLOBAL_POSITION_PRIMARY,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GLOBAL_POSITION_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_GLOBAL_POSITION_FLAGS {
		if e&val == val {
			names = append(names, value_to_label_GLOBAL_POSITION_FLAGS[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GLOBAL_POSITION_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask GLOBAL_POSITION_FLAGS
	for _, label := range labels {
		if value, ok := label_to_value_GLOBAL_POSITION_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= GLOBAL_POSITION_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e GLOBAL_POSITION_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
