// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/ai/generativelanguage/v1beta2/discuss_service.proto

package generativelanguagepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DiscussService_GenerateMessage_FullMethodName    = "/google.ai.generativelanguage.v1beta2.DiscussService/GenerateMessage"
	DiscussService_CountMessageTokens_FullMethodName = "/google.ai.generativelanguage.v1beta2.DiscussService/CountMessageTokens"
)

// DiscussServiceClient is the client API for DiscussService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DiscussServiceClient interface {
	// Generates a response from the model given an input `MessagePrompt`.
	GenerateMessage(ctx context.Context, in *GenerateMessageRequest, opts ...grpc.CallOption) (*GenerateMessageResponse, error)
	// Runs a model's tokenizer on a string and returns the token count.
	CountMessageTokens(ctx context.Context, in *CountMessageTokensRequest, opts ...grpc.CallOption) (*CountMessageTokensResponse, error)
}

type discussServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDiscussServiceClient(cc grpc.ClientConnInterface) DiscussServiceClient {
	return &discussServiceClient{cc}
}

func (c *discussServiceClient) GenerateMessage(ctx context.Context, in *GenerateMessageRequest, opts ...grpc.CallOption) (*GenerateMessageResponse, error) {
	out := new(GenerateMessageResponse)
	err := c.cc.Invoke(ctx, DiscussService_GenerateMessage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *discussServiceClient) CountMessageTokens(ctx context.Context, in *CountMessageTokensRequest, opts ...grpc.CallOption) (*CountMessageTokensResponse, error) {
	out := new(CountMessageTokensResponse)
	err := c.cc.Invoke(ctx, DiscussService_CountMessageTokens_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DiscussServiceServer is the server API for DiscussService service.
// All implementations should embed UnimplementedDiscussServiceServer
// for forward compatibility
type DiscussServiceServer interface {
	// Generates a response from the model given an input `MessagePrompt`.
	GenerateMessage(context.Context, *GenerateMessageRequest) (*GenerateMessageResponse, error)
	// Runs a model's tokenizer on a string and returns the token count.
	CountMessageTokens(context.Context, *CountMessageTokensRequest) (*CountMessageTokensResponse, error)
}

// UnimplementedDiscussServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDiscussServiceServer struct {
}

func (UnimplementedDiscussServiceServer) GenerateMessage(context.Context, *GenerateMessageRequest) (*GenerateMessageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateMessage not implemented")
}
func (UnimplementedDiscussServiceServer) CountMessageTokens(context.Context, *CountMessageTokensRequest) (*CountMessageTokensResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountMessageTokens not implemented")
}

// UnsafeDiscussServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DiscussServiceServer will
// result in compilation errors.
type UnsafeDiscussServiceServer interface {
	mustEmbedUnimplementedDiscussServiceServer()
}

func RegisterDiscussServiceServer(s grpc.ServiceRegistrar, srv DiscussServiceServer) {
	s.RegisterService(&DiscussService_ServiceDesc, srv)
}

func _DiscussService_GenerateMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiscussServiceServer).GenerateMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DiscussService_GenerateMessage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiscussServiceServer).GenerateMessage(ctx, req.(*GenerateMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DiscussService_CountMessageTokens_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountMessageTokensRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiscussServiceServer).CountMessageTokens(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DiscussService_CountMessageTokens_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiscussServiceServer).CountMessageTokens(ctx, req.(*CountMessageTokensRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DiscussService_ServiceDesc is the grpc.ServiceDesc for DiscussService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DiscussService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.ai.generativelanguage.v1beta2.DiscussService",
	HandlerType: (*DiscussServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GenerateMessage",
			Handler:    _DiscussService_GenerateMessage_Handler,
		},
		{
			MethodName: "CountMessageTokens",
			Handler:    _DiscussService_CountMessageTokens_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ai/generativelanguage/v1beta2/discuss_service.proto",
}
