/*╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌
 * editors/MashStepEditor.h is part of Brewtarget, and is copyright the following authors 2009-2024:
 *   • Jeff Bailey <skydvr38@verizon.net>
 *   • Matt Young <mfsy@yahoo.com>
 *   • Mik Firestone <mikfire@gmail.com>
 *   • Philip Greggory Lee <rocketman768@gmail.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Brewtarget is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌*/
#ifndef EDITORS_MASHSTEPEDITOR_H
#define EDITORS_MASHSTEPEDITOR_H
#pragma once

#include <QDialog>

#include "ui_mashStepEditor.h"

#include "editors/EditorBase.h"
#include "model/MashStep.h"

#define MashStepEditorOptions EditorBaseOptions{ }
/*!
 * \class MashStepEditor
 *
 * \brief View/controller dialog for editing mash steps.
 */
class MashStepEditor : public QDialog,
                       public Ui::mashStepEditor,
                       public EnumeratedItemEditorBase<MashStepEditor, MashStep>,
                       public EditorBase<MashStepEditor, MashStep, MashStepEditorOptions> {
   Q_OBJECT

   EDITOR_COMMON_DECL(MashStep, MashStepEditorOptions)

public slots:
   /*!
    * Grays out irrelevant portions of the dialog.
    * \param text - one of {"Infusion", "Decoction", "Temperature"} describing the mash step.
    */
   void grayOutStuff(QString const & text);
};

#endif
