/*╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌
 * qtModels/tableModels/RecipeAdditionHopTableModel.cpp is part of Brewtarget, and is copyright the following authors 2009-2024:
 *   • Brian Rower <brian.rower@gmail.com>
 *   • Daniel Pettersson <pettson81@gmail.com>
 *   • Luke Vincent <luke.r.vincent@gmail.com>
 *   • Markus Mårtensson <mackan.90@gmail.com>
 *   • Mattias Måhl <mattias@kejsarsten.com>
 *   • Matt Young <mfsy@yahoo.com>
 *   • Mik Firestone <mikfire@gmail.com>
 *   • Philip Greggory Lee <rocketman768@gmail.com>
 *   • Samuel Östling <MrOstling@gmail.com>
 *   • Tim Payne <swstim@gmail.com>
 *   • Théophane Martin <theophane.m@gmail.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Brewtarget is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌*/
#include "qtModels/tableModels/RecipeAdditionHopTableModel.h"

#include <QHeaderView>
#include <QModelIndex>
#include <QString>
#include <QVariant>
#include <QWidget>

#include "measurement/Measurement.h"
#include "measurement/Unit.h"
#include "model/StockPurchase.h"
#include "model/Recipe.h"

#ifdef BUILDING_WITH_CMAKE
   // Explicitly doing this include reduces potential problems with AUTOMOC when compiling with CMake
   #include "moc_RecipeAdditionHopTableModel.cpp"
#endif

COLUMN_INFOS(
   RecipeAdditionHopTableModel,
   //
   // Note that for Name, we want the name of the contained Hop, not the name of the RecipeAdditionHop
   //
   TABLE_MODEL_HEADER(RecipeAdditionHop, Name          , PropertyPath{{PropertyNames::RecipeAdditionHop::hop,          // "Name"
                                                                       PropertyNames::NamedEntity::name     }, 1}),
   TABLE_MODEL_HEADER(RecipeAdditionHop, Form          , PropertyPath{{PropertyNames::RecipeAdditionHop::hop,          // "Form"
                                                                       PropertyNames::Hop::form             }, 1}),
   TABLE_MODEL_HEADER(RecipeAdditionHop, Alpha         , PropertyPath{{PropertyNames::RecipeAdditionHop::hop,          // "Alpha %"
                                                                       PropertyNames::Hop::alpha_pct        }, 1}),
   TABLE_MODEL_HEADER(RecipeAdditionHop, Year          , PropertyPath{{PropertyNames::RecipeAdditionHop::hop,          // "Year"
                                                                       PropertyNames::Hop::year             }, 1}),
   TABLE_MODEL_HEADER(RecipeAdditionHop, Amount        , PropertyNames::IngredientAmount::amount),                     // "Amount"
   TABLE_MODEL_HEADER(RecipeAdditionHop, AmountType    , PropertyNames::IngredientAmount::amount, Hop::validMeasures), // "Amount Type"
   // Total inventory is read-only, so there is intentionally no TotalInventoryType column
   TABLE_MODEL_HEADER(RecipeAdditionHop, TotalInventory, PropertyPath{{PropertyNames::RecipeAdditionHop::hop,           // "Inventory"
                                                                       PropertyNames::Ingredient::totalInventory}, 1}),
   TABLE_MODEL_HEADER(RecipeAdditionHop, Stage         , PropertyNames::RecipeAddition::stage                     ),    // "Stage"
   TABLE_MODEL_HEADER(RecipeAdditionHop, Time          , PropertyNames::RecipeAddition::addAtTime_mins            ),    // "Time"
)

RecipeAdditionHopTableModel::RecipeAdditionHopTableModel(QTableView * parent, bool editable) :
   BtTableModelRecipeObserver{parent, editable},
   TableModelBase<RecipeAdditionHopTableModel, RecipeAdditionHop>{},
   showIBUs(false) {
   this->m_rows.clear();

   QHeaderView * headerView = m_parentTableWidget->horizontalHeader();
   connect(headerView, &QWidget::customContextMenuRequested, this, &RecipeAdditionHopTableModel::contextMenu);
   connect(&ObjectStoreTyped<StockPurchaseHop>::getInstance(), &ObjectStoreTyped<StockPurchaseHop>::signalPropertyChanged, this,
           &RecipeAdditionHopTableModel::changedInventory);
   return;
}

RecipeAdditionHopTableModel::~RecipeAdditionHopTableModel() = default;

void RecipeAdditionHopTableModel::added  ([[maybe_unused]] std::shared_ptr<RecipeAdditionHop> item) { return; }
void RecipeAdditionHopTableModel::removed([[maybe_unused]] std::shared_ptr<RecipeAdditionHop> item) { return; }
void RecipeAdditionHopTableModel::updateTotals()                                                    { return; }

void RecipeAdditionHopTableModel::setShowIBUs(bool var) {
   showIBUs = var;
   return;
}

QVariant RecipeAdditionHopTableModel::data(QModelIndex const & index, int role) const {
   return this->doDataDefault(index, role);
}

QVariant RecipeAdditionHopTableModel::headerData(int section, Qt::Orientation orientation, int role) const {
   if (orientation == Qt::Horizontal && role == Qt::DisplayRole) {
      return ColumnOwnerTraits<RecipeAdditionHopTableModel>::getColumnLabel(section);
   }
   if (showIBUs && recObs && orientation == Qt::Vertical && role == Qt::DisplayRole) {
      QList<double> ibus = recObs->IBUs();

      if (ibus.size() > section) {
         return QVariant(QString("%L1 IBU").arg(ibus.at(section), 0, 'f', 1));
      }
   }
   return QVariant();
}

bool RecipeAdditionHopTableModel::setData(QModelIndex const & index, QVariant const & value, int role) {
   // Template parameter is true as we might need to re-show header IBUs
   return this->doSetDataDefault<true>(index, value, role);
}

// Insert the boiler-plate stuff that we cannot do in TableModelBase
TABLE_MODEL_COMMON_CODE(RecipeAdditionHop, recipeAdditionHop, PropertyNames::Recipe::hopAdditions)
//=============================================== CLASS RecipeAdditionHopItemDelegate ================================================

// Insert the boiler-plate stuff that we cannot do in ItemDelegate
ITEM_DELEGATE_COMMON_CODE(RecipeAdditionHop)
