# Code of Conduct

We believe in creating a diverse, inclusive, and accessible environment for
contributors in order to create the best software.  To achieve this we expect
everyone who participates in the project to observe the following guidelines.

## Guidelines

These guidelines are not exhaustive or complete.

### Be open

We invite anyone to participate in our community.  We prefer to use public methods of communication only.  We are patient in discussion and know that
people come from various time zones and may not be able to respond immediately.
We know that significant decisions should not occur on fast-paced
communication channels like Slack.

We do not hide our intentions.  We have many reasons to work on this project
and many of us are paid for our work and will profit from the success of the
project.  We are transparent with our goals and our reasoning.

We are honest and we promptly admit to our mistakes while being understanding that others may also make mistakes.

### Be respectful

We show respect for others in all of our communications.  We practice empathy
and we always try to understand what the other person is telling us.  We are
willing to challenge our own understanding and adapt it when needed.

We always assume good faith unless there is clear evidence to the contrary.
We assume that others working on this project have the same goal in mind and
that their intentions are genuine.

We respect the way that contributors name and describe themselves.  When
others express a preference for particular names or pronouns then we are
mindful of this fact and use these words when communicating with or about
the person.

### Be collaborative

We understand that this project is created for everyone and not just ourselves.
We explain our work to others and encourage others to expand on our work.  We
recognize that decisions we make will affect others and we take those
consequences seriously when making these decisions.

We help newcomers integrate into the project, mentor them, and point them
towards appropriate resources.  We do our best to learn answers before we ask questions.  We recognize and credit the work done by contributors.  We thank
others for their hard work and give credit where it is due.

## Unacceptable Behavior

The following specific behaviors are unacceptable and will not be tolerated.

* Insults: This includes name calling, using slurs or stereotypes, and any attacks based on personal characteristics
* Sexual harassment: Sexual attention or advances of any kind towards others where the person knows or reasonably should know that the attention is unwelcome or in situations where consent cannot be communicated.
* Sexist, racist, or otherwise discriminatory jokes and language.
* Posting sexually explicit or violent material.
* Posting (or threatening to post) other people's personally identifying information ("doxing") or private content.
* Excessive or unnecessary profanity.
* Repeated harassment of others. In general, if someone asks you to stop, then stop.
* Trolling: Deliberately disrupting conversations or posting in bad-faith to intentionally provoke.
* Advocating for, or encouraging, any of the above behaviour.

## Reporting Guidelines

We all work together to help others identify and call out instances where
our code of conduct is not being observed.  We remember to assume good faith
and recognize that contributors may be having a bad day or may not be aware
their behavior violates the code of conduct.  Often, calling attention to
negative behavior is sufficient to resolve the issue.

When a situation becomes difficult to resolve or we feel that the conversation
is getting out of control we can email the SMC at substrait-harassment@googlegroups.com.

## Acknowledgements

This statement draws on the following for content and inspiration:

 * [The Apache Software Foundation code of conduct](https://www.apache.org/foundation/policies/conduct.html)
 * [Wikimedia's Universal Code of Conduct](https://meta.wikimedia.org/wiki/Universal_Code_of_Conduct)
 
