//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package uavionix

import (
	"fmt"
	"strconv"
	"strings"
)

// State flags for X-Bit and reserved fields.
type UAVIONIX_ADSB_XBIT uint64

const (
	UAVIONIX_ADSB_XBIT_ENABLED UAVIONIX_ADSB_XBIT = 128
)

var values_UAVIONIX_ADSB_XBIT = []UAVIONIX_ADSB_XBIT{
	UAVIONIX_ADSB_XBIT_ENABLED,
}

var value_to_label_UAVIONIX_ADSB_XBIT = map[UAVIONIX_ADSB_XBIT]string{
	UAVIONIX_ADSB_XBIT_ENABLED: "UAVIONIX_ADSB_XBIT_ENABLED",
}

var label_to_value_UAVIONIX_ADSB_XBIT = map[string]UAVIONIX_ADSB_XBIT{
	"UAVIONIX_ADSB_XBIT_ENABLED": UAVIONIX_ADSB_XBIT_ENABLED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e UAVIONIX_ADSB_XBIT) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_UAVIONIX_ADSB_XBIT {
		if e&val == val {
			names = append(names, value_to_label_UAVIONIX_ADSB_XBIT[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *UAVIONIX_ADSB_XBIT) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask UAVIONIX_ADSB_XBIT
	for _, label := range labels {
		if value, ok := label_to_value_UAVIONIX_ADSB_XBIT[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= UAVIONIX_ADSB_XBIT(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e UAVIONIX_ADSB_XBIT) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
