//-------------------------------------------------------------------------
/*
Copyright (C) 2010 EDuke32 developers and contributors

This file is part of EDuke32.

EDuke32 is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License version 2
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
//-------------------------------------------------------------------------

#ifndef namesdyn_h__
#define namesdyn_h__


#define DYNTILEREMAP_ENABLE


#define SECTOREFFECTOR__      1
#define ACTIVATOR__           2
#define TOUCHPLATE__          3
#define ACTIVATORLOCKED__     4
#define MUSICANDSFX__         5
#define LOCATORS__            6
#define CYCLER__              7
#define MASTERSWITCH__        8
#define RESPAWN__             9
#define GPSPEED__             10
#define FOF__                 13
#define ARROW__               20
#define FIRSTGUNSPRITE__      21
#define CHAINGUNSPRITE__      22
#define RPGSPRITE__           23
#define FREEZESPRITE__        24
#define SHRINKERSPRITE__      25
#define HEAVYHBOMB__          26
#define TRIPBOMBSPRITE__      27
#define SHOTGUNSPRITE__       28
#define DEVISTATORSPRITE__    29
#define HEALTHBOX__           30
#define AMMOBOX__             31
#define GROWSPRITEICON__      32
#define INVENTORYBOX__        33
#define FREEZEAMMO__          37
#define AMMO__                40
#define BATTERYAMMO__         41
#define DEVISTATORAMMO__      42
#define RPGAMMO__             44
#define GROWAMMO__            45
#define CRYSTALAMMO__         46
#define HBOMBAMMO__           47
#define AMMOLOTS__            48
#define SHOTGUNAMMO__         49
#define COLA__                51
#define SIXPAK__              52
#define FIRSTAID__            53
#define SHIELD__              54
#define STEROIDS__            55
#define AIRTANK__             56
#define JETPACK__             57
#define HEATSENSOR__          59
#define ACCESSCARD__          60
#define BOOTS__               61
#define MIRRORBROKE__         70
#define CLOUDYOCEAN__         78
#define CLOUDYSKIES__         79
#define MOONSKY1__            80
#define BIGORBIT1__           84
#define LA__                  89
#define ATOMICHEALTH__        100
#define TECHLIGHT2__          120
#define TECHLIGHTBUST2__      121
#define TECHLIGHT4__          122
#define TECHLIGHTBUST4__      123
#define WALLLIGHT4__          124
#define WALLLIGHTBUST4__      125
#define ACCESSSWITCH__        130
#define SLOTDOOR__            132
#define LIGHTSWITCH__         134
#define SPACEDOORSWITCH__     136
#define SPACELIGHTSWITCH__    138
#define FRANKENSTINESWITCH__  140
#define NUKEBUTTON__          142
#define MULTISWITCH__         146
#define DOORTILE5__           150
#define DOORTILE6__           151
#define DOORTILE1__           152
#define DOORTILE2__           153
#define DOORTILE3__           154
#define DOORTILE4__           155
#define DOORTILE7__           156
#define DOORTILE8__           157
#define DOORTILE9__           158
#define DOORTILE10__          159
#define DOORSHOCK__           160
#define DIPSWITCH__           162
#define DIPSWITCH2__          164
#define TECHSWITCH__          166
#define DIPSWITCH3__          168
#define ACCESSSWITCH2__       170
#define FLOORSLIME__          200
#define BIGFORCE__            230
#define MASKWALL9__           255
#define SCREENBREAK1__        263
#define SCREENBREAK2__        264
#define SCREENBREAK3__        265
#define SCREENBREAK4__        266
#define SCREENBREAK5__        267
#define SCREENBREAK6__        268
#define SCREENBREAK7__        269
#define SCREENBREAK8__        270
#define SCREENBREAK9__        271
#define SCREENBREAK10__       272
#define SCREENBREAK11__       273
#define SCREENBREAK12__       274
#define SCREENBREAK13__       275
#define MASKWALL1__           285
#define W_TECHWALL1__         293
#define W_TECHWALL2__         297
#define W_TECHWALL15__        299
#define W_TECHWALL3__         301
#define W_TECHWALL4__         305
#define W_TECHWALL10__        306
#define W_TECHWALL16__        307
#define WATERTILE2__          336
#define BPANNEL1__            341
#define PANNEL1__             342
#define PANNEL2__             343
#define STATIC__              351
#define W_SCREENBREAK__       357
#define W_HITTECHWALL3__      360
#define W_HITTECHWALL4__      361
#define W_HITTECHWALL2__      362
#define W_HITTECHWALL1__      363
#define MASKWALL10__          387
#define MASKWALL11__          391
#define DOORTILE22__          395
#define FANSPRITE__           407
#define FANSPRITEBROKE__      411
#define FANSHADOW__           412
#define FANSHADOWBROKE__      416
#define DOORTILE18__          447
#define DOORTILE19__          448
#define DOORTILE20__          449
#define VIEWSCREEN2__         499
#define VIEWSCREEN__          502
#define GLASS__               503
#define GLASS2__              504
#define STAINGLASS1__         510
#define MASKWALL5__           514
#define SATELITE__            516
#define FUELPOD__             517
#define CRACK1__              546
#define CRACK2__              547
#define CRACK3__              548
#define CRACK4__              549
#define FOOTPRINTS__          550
#define DOMELITE__            551
#define CAMERAPOLE__          554
#define CHAIR1__              556
#define CHAIR2__              557
#define BROKENCHAIR__         559
#define MIRROR__              560
#define WATERFOUNTAIN__       563
#define WATERFOUNTAINBROKE__  567
#define FEMMAG1__             568
#define TOILET__              569
#define STALL__               571
#define STALLBROKE__          573
#define FEMMAG2__             577
#define REACTOR2__            578
#define REACTOR2BURNT__       579
#define REACTOR2SPARK__       580
#define GRATE1__              595
#define BGRATE1__             596
#define SOLARPANNEL__         602
#define NAKED1__              603
#define ANTENNA__             607
#define MASKWALL12__          609
#define TOILETBROKE__         615
#define PIPE2__               616
#define PIPE1B__              617
#define PIPE3__               618
#define PIPE1__               619
#define CAMERA1__             621
#define PIPE2B__              633
#define BOLT1__               634
#define W_NUMBERS__           640
#define WATERDRIP__           660
#define WATERBUBBLE__         661
#define WATERBUBBLEMAKER__    662
#define W_FORCEFIELD__        663
#define VACUUM__              669
#define FOOTPRINTS2__         672
#define FOOTPRINTS3__         673
#define FOOTPRINTS4__         674
#define EGG__                 675
#define SCALE__               678
#define CHAIR3__              680
#define CAMERALIGHT__         685
#define MOVIECAMERA__         686
#define IVUNIT__              689
#define POT1__                694
#define POT2__                695
#define POT3__                697
#define PIPE3B__              700
#define WALLLIGHT3__          701
#define WALLLIGHTBUST3__      702
#define WALLLIGHT1__          703
#define WALLLIGHTBUST1__      704
#define WALLLIGHT2__          705
#define WALLLIGHTBUST2__      706
#define LIGHTSWITCH2__        712
#define WAITTOBESEATED__      716
#define DOORTILE14__          717
#define STATUE__              753
#define MIKE__                762
#define VASE__                765
#define SUSHIPLATE1__         768
#define SUSHIPLATE2__         769
#define SUSHIPLATE3__         774
#define SUSHIPLATE4__         779
#define DOORTILE16__          781
#define SUSHIPLATE5__         792
#define OJ__                  806
#define MASKWALL13__          830
#define HURTRAIL__            859
#define POWERSWITCH1__        860
#define LOCKSWITCH1__         862
#define POWERSWITCH2__        864
#define ATM__                 867
#define STATUEFLASH__         869
#define ATMBROKE__            888
#define STRIPEBALL__          901
#define QUEBALL__             902
#define POCKET__              903
#define WOODENHORSE__         904
#define TREE1__               908
#define TREE2__               910
#define CACTUS__              911
#define MASKWALL2__           913
#define MASKWALL3__           914
#define MASKWALL4__           915
#define FIREEXT__             916
#define TOILETWATER__         921
#define NEON1__               925
#define NEON2__               926
#define CACTUSBROKE__         939
#define BOUNCEMINE__          940
#define BROKEFIREHYDRENT__    950
#define BOX__                 951
#define BULLETHOLE__          952
#define BOTTLE1__             954
#define BOTTLE2__             955
#define BOTTLE3__             956
#define BOTTLE4__             957
#define FEMPIC5__             963
#define FEMPIC6__             964
#define FEMPIC7__             965
#define HYDROPLANT__          969
#define OCEANSPRITE1__        971
#define OCEANSPRITE2__        972
#define OCEANSPRITE3__        973
#define OCEANSPRITE4__        974
#define OCEANSPRITE5__        975
#define GENERICPOLE__         977
#define CONE__                978
#define HANGLIGHT__           979
#define HYDRENT__             981
#define MASKWALL14__          988
#define TIRE__                990
#define PIPE5__               994
#define PIPE6__               995
#define PIPE4__               996
#define PIPE4B__              997
#define BROKEHYDROPLANT__     1003
#define PIPE5B__              1005
#define NEON3__               1007
#define NEON4__               1008
#define NEON5__               1009
#define BOTTLE5__             1012
#define BOTTLE6__             1013
#define BOTTLE8__             1014
#define SPOTLITE__            1020
#define MASKWALL15__          1024
#define BOTTLE7__             1025
#define HORSEONSIDE__         1026
#define GLASSPIECES__         1031
#define NEON6__               1046
#define MASKWALL6__           1059
#define RUBBERCAN__           1062
#define PLUG__                1069
#define OOZFILTER__           1079
#define FLOORPLASMA__         1082
#define REACTOR__             1088
#define REACTORSPARK__        1092
#define REACTORBURNT__        1096
#define DOORTILE15__          1102
#define HANDSWITCH__          1111
#define CIRCLEPANNEL__        1113
#define CIRCLEPANNELBROKE__   1114
#define PULLSWITCH__          1122
#define MASKWALL8__           1124
#define BIGHOLE__             1141
#define ALIENSWITCH__         1142
#define DOORTILE21__          1144
#define HANDPRINTSWITCH__     1155
#define BOTTLE10__            1157
#define BOTTLE11__            1158
#define BOTTLE12__            1159
#define BOTTLE13__            1160
#define BOTTLE14__            1161
#define BOTTLE15__            1162
#define BOTTLE16__            1163
#define BOTTLE17__            1164
#define BOTTLE18__            1165
#define BOTTLE19__            1166
#define DOORTILE17__          1169
#define MASKWALL7__           1174
#define DOORTILE11__          1178
#define DOORTILE12__          1179
#define VENDMACHINE__         1212
#define COLAMACHINE__         1215
#define CRANEPOLE__           1221
#define CRANE__               1222
#define BARBROKE__            1225
#define BLOODPOOL__           1226
#define NUKEBARREL__          1227
#define NUKEBARRELDENTED__    1228
#define NUKEBARRELLEAKED__    1229
#define CANWITHSOMETHING__    1232
#define MONEY__               1233
#define BANNER__              1236
#define EXPLODINGBARREL__     1238
#define EXPLODINGBARREL2__    1239
#define FIREBARREL__          1240
#define SEENINE__             1247
#define SEENINEDEAD__         1248
#define STEAM__               1250
#define CEILINGSTEAM__        1255
#define PIPE6B__              1260
#define TRANSPORTERBEAM__     1261
#define RAT__                 1267
#define TRASH__               1272
#define FEMPIC1__             1280
#define FEMPIC2__             1289
#define BLANKSCREEN__         1293
#define PODFEM1__             1294
#define FEMPIC3__             1298
#define FEMPIC4__             1306
#define FEM1__                1312
#define FEM2__                1317
#define FEM3__                1321
#define FEM5__                1323
#define BLOODYPOLE__          1324
#define FEM4__                1325
#define FEM6__                1334
#define FEM6PAD__             1335
#define FEM8__                1336
#define HELECOPT__            1346
#define FETUSJIB__            1347
#define HOLODUKE__            1348
#define SPACEMARINE__         1353
#define INDY__                1355
#define FETUS__               1358
#define FETUSBROKE__          1359
#define MONK__                1352
#define LUKE__                1354
#define COOLEXPLOSION1__      1360
#define WATERSPLASH2__        1380
#define FIREVASE__            1390
#define FEM7__                1395
#define APLAYERTOP__          1400
#define APLAYER__             1405
#define PLAYERONWATER__       1420
#define DUKELYINGDEAD__       1518
#define DUKETORSO__           1520
#define DUKEGUN__             1528
#define DUKELEG__             1536
#define SHARK__               1550
#define BLOOD__               1620
#define FIRELASER__           1625
#define TRANSPORTERSTAR__     1630
#define SPIT__                1636
#define LOOGIE__              1637
#define FIST__                1640
#define FREEZEBLAST__         1641
#define SHRINKSPARK__         1646
#define TONGUE__              1647
#define MORTER__              1650
#define SHRINKEREXPLOSION__   1656
#define RADIUSEXPLOSION__     1670
#define FORCERIPPLE__         1671
#define LIZTROOP__            1680
#define LIZTROOPRUNNING__     1681
#define LIZTROOPSTAYPUT__     1682
#define LIZTROOPSHOOT__       1715
#define LIZTROOPJETPACK__     1725
#define LIZTROOPONTOILET__    1741
#define LIZTROOPJUSTSIT__     1742
#define LIZTROOPDUCKING__     1744
#define HEADJIB1__            1768
#define ARMJIB1__             1772
#define LEGJIB1__             1776
#define OCTABRAIN__           1820
#define OCTABRAINSTAYPUT__    1821
#define INNERJAW__            1860
#define DRONE__               1880
#define EXPLOSION2__          1890
#define COMMANDER__           1920
#define COMMANDERSTAYPUT__    1921
#define RECON__               1960
#define TANK__                1975
#define PIGCOP__              2000
#define PIGCOPSTAYPUT__       2001
#define PIGCOPDIVE__          2045
#define LIZMAN__              2120
#define LIZMANSTAYPUT__       2121
#define LIZMANSPITTING__      2150
#define LIZMANFEEDING__       2160
#define LIZMANJUMP__          2165
#define FECES__               2200
#define LIZMANHEAD1__         2201
#define LIZMANARM1__          2205
#define LIZMANLEG1__          2209
#define EXPLOSION2BOT__       2219
#define JIBS1__               2245
#define JIBS2__               2250
#define JIBS3__               2255
#define JIBS4__               2260
#define JIBS5__               2265
#define BURNING__             2270
#define FIRE__                2271
#define JIBS6__               2286
#define BLOODSPLAT1__         2296
#define BLOODSPLAT3__         2297
#define BLOODSPLAT2__         2298
#define BLOODSPLAT4__         2299
#define OOZ__                 2300
#define OOZ2__                2309
#define WALLBLOOD1__          2301
#define WALLBLOOD2__          2302
#define WALLBLOOD3__          2303
#define WALLBLOOD4__          2304
#define WALLBLOOD5__          2305
#define WALLBLOOD7__          2307
#define WALLBLOOD8__          2308
#define BURNING2__            2310
#define FIRE2__               2311
#define CRACKKNUCKLES__       2324
#define SMALLSMOKE__          2329
#define FLOORFLAME__          2333
#define ROTATEGUN__           2360
#define GREENSLIME__          2370
#define WATERDRIPSPLASH__     2380
#define SCRAP6__              2390
#define SCRAP1__              2400
#define SCRAP2__              2404
#define SCRAP3__              2408
#define SCRAP4__              2412
#define SCRAP5__              2416
#define ORGANTIC__            2420
#define BETAVERSION__         2440
#define SELECTDIR__           2444
#define F1HELP__              2445
#define GROWSPARK__           2448
#define MENUSCREEN__          2456
#define MENUBAR__             2457
#define KILLSICON__           2458
#define FIRSTAID_ICON__       2460
#define HEAT_ICON__           2461
#define BOTTOMSTATUSBAR__     2462
#define BOOT_ICON__           2463
#define FRAGBAR__             2465
#define JETPACK_ICON__        2467
#define AIRTANK_ICON__        2468
#define STEROIDS_ICON__       2469
#define HOLODUKE_ICON__       2470
#define ACCESS_ICON__         2471
#define DIGITALNUM__          2472
#define DUKECAR__             2491
#define CAMCORNER__           2482
#define CAMLIGHT__            2484
#define SLIDEBAR__            2489
#define DREALMS__             2492
#define BETASCREEN__          2493
#define WINDOWBORDER1__       2494
#define TEXTBOX__             2495
#define WINDOWBORDER2__       2496
#define DUKENUKEM__           2497
#define THREEDEE__            2498
#define INGAMEDUKETHREEDEE__  2499
#define TENSCREEN__           2500
#define PLUTOPAKSPRITE__      2501
#define DEVISTATOR__          2510
#define KNEE__                2521
#define CROSSHAIR__           2523
#define FIRSTGUN__            2524
#define FIRSTGUNRELOAD__      2528
#define SHELL__               2533
#define SHOTGUNSHELL__        2535
#define CHAINGUN__            2536
#define RPGGUN__              2544
#define FREEZE__              2548
#define SHRINKER__            2556
#define HANDHOLDINGLASER__    2563
#define TRIPBOMB__            2566
#define LASERLINE__           2567
#define HANDHOLDINGACCESS__   2568
#define HANDREMOTE__          2570
#define HANDTHROW__           2573
#define TIP__                 2576
#define SCUBAMASK__           2581
#define FORCESPHERE__         2590
#define SHOTSPARK1__          2595
#define RPG__                 2605
#define LASERSITE__           2612
#define SHOTGUN__             2613
#define BOSS1__               2630
#define BOSS1STAYPUT__        2631
#define BOSS1SHOOT__          2660
#define BOSS1LOB__            2670
#define BOSSTOP__             2696
#define BOSS2__               2710
#define BOSS3__               2760
#define SPINNINGNUKEICON__    2813
#define SMALLFNTCURSOR__      2821
#define STARTALPHANUM__       2822
#define ENDALPHANUM__         2915
#define BIGALPHANUM__         2940
#define BIGPERIOD__           3002
#define BIGCOMMA__            3003
#define BIGX__                3004
#define BIGQ__                3005
#define BIGSEMI__             3006
#define BIGCOLIN__            3007
#define THREEBYFIVE__         3010
#define BIGAPPOS__            3022
#define MINIFONT__            3072
#define RESPAWNMARKERRED__    3190
#define RESPAWNMARKERYELLOW__ 3200
#define RESPAWNMARKERGREEN__  3210
#define BONUSSCREEN__         3240
#define VIEWBORDER__          3250
#define VICTORY1__            3260
#define ORDERING__            3270
#define TEXTSTORY__           3280
#define LOADSCREEN__          3281
#define BORNTOBEWILDSCREEN__  3370
#define BLIMP__               3400
#define FEM9__                3450
#define FRAMEEFFECT1_13__     3999
#define FRAMEEFFECT1__        4095
#define PANNEL3__             4099
#define SCREENBREAK14__       4120
#define SCREENBREAK15__       4123
#define SCREENBREAK19__       4125
#define SCREENBREAK16__       4127
#define SCREENBREAK17__       4128
#define SCREENBREAK18__       4129
#define W_TECHWALL11__        4130
#define W_TECHWALL12__        4131
#define W_TECHWALL13__        4132
#define W_TECHWALL14__        4133
#define W_TECHWALL5__         4134
#define W_TECHWALL6__         4136
#define W_TECHWALL7__         4138
#define W_TECHWALL8__         4140
#define W_TECHWALL9__         4142
#define BPANNEL3__            4100
#define W_HITTECHWALL16__     4144
#define W_HITTECHWALL10__     4145
#define W_HITTECHWALL15__     4147
#define W_MILKSHELF__         4181
#define W_MILKSHELFBROKE__    4203
#define PURPLELAVA__          4240
#define TARGET__              4359
#define DUCK__                4361
#define PUKE__                4389
#define DOORTILE23__          4391
#define SPEAKER__             4397
#define MAIL__                4410
#define HOTMEAT__             4427
#define TRIPODCAMERA__        4444
#define PAPER__               4460
#define GENERICPOLE2__        4465
#define XXXSTACY__            4470
#define LETTER__              4502
#define SIDEBOLT1__           4525
#define FOODOBJECT16__        4545
#define TAMPON__              4557
#define CANWITHSOMETHING2__   4580
#define CANWITHSOMETHING3__   4581
#define CANWITHSOMETHING4__   4582
#define DOLPHIN1__            4591
#define DOLPHIN2__            4592
#define NEWBEAST__            4610
#define NEWBEASTSTAYPUT__     4611
#define BOSS4__               4740
#define BOSS4STAYPUT__        4741
#define FEM10__               4864
#define TOUGHGAL__            4866
#define MAN__                 4871
#define MAN2__                4872
#define WOMAN__               4874
#define NATURALLIGHTNING__    4890
#define WEATHERWARN__         4893
#define DUKETAG__             4900
#define SIGN1__               4909
#define SIGN2__               4912
#define JURYGUY__             4943
#define WIDESCREENSTATUSBAR__ 5120
#define RPGGUNWIDE__          5121
#define FIRSTGUNRELOADWIDE__  5122
#define FREEZEWIDE__          5123
#define FREEZEFIREWIDE__      5124
#define SHRINKERWIDE__        5127
#define CRACKKNUCKLESWIDE__   5129
#define FLAMETHROWERSPRITE__  5134
#define FLAMETHROWERAMMO__    5135
#define FLAMETHROWER__        5138
#define FLAMETHROWERFIRE__    5139
#define FLAMETHROWERFLAME__   1891
#define FLAMETHROWERPILOT__   5174
#define FIREBALL__            5163
#define ONFIRE__              5152
#define ONFIRESMOKE__         5143
#define BURNEDCORPSE__        5173
#define WHISPYSMOKE__         5268
#define FIREFLY__             5180
#define FIREFLYSHRINKEFFECT__ 5360
#define FIREFLYGROWEFFECT__   5367
#define FIREFLYFLYINGEFFECT__ 5296
#define BOSS5__               5310
#define BOSS5STAYPUT__        5311
#define LAVAPOOL__            5304
#define LAVASPLASH__          5371
#define LAVAPOOLBUBBLE__      5207
#define BOSS2STAYPUT__        2711
#define BOSS3STAYPUT__        2761
#define E32_TILE5736__        5736
#define E32_TILE5737__        5737
#define E32_TILE5846__        5846

#define TILEMAPSIZE 6144

extern inthashtable_t h_dynamictilemap;

void G_InitDynamicTiles(void);

#ifdef DYNTILEREMAP_ENABLE

void G_ProcessDynamicTileMapping(const char *szLabel, int32_t lValue);

void inithashnames(void);
void freehashnames(void);

extern int32_t ACCESS_ICON;
extern int32_t ACCESSCARD;
extern int32_t ACCESSSWITCH;
extern int32_t ACCESSSWITCH2;
extern int32_t ACTIVATOR;
extern int32_t ACTIVATORLOCKED;
extern int32_t AIRTANK;
extern int32_t AIRTANK_ICON;
extern int32_t ALIENSWITCH;
extern int32_t AMMO;
extern int32_t AMMOBOX;
extern int32_t AMMOLOTS;
extern int32_t ANTENNA;
extern int32_t APLAYER;
extern int32_t APLAYERTOP;
extern int32_t ARMJIB1;
extern int32_t ARROW;
extern int32_t ATM;
extern int32_t ATMBROKE;
extern int32_t ATOMICHEALTH;
extern int32_t BANNER;
extern int32_t BARBROKE;
extern int32_t BATTERYAMMO;
extern int32_t BETASCREEN;
extern int32_t BETAVERSION;
extern int32_t BGRATE1;
extern int32_t BIGALPHANUM;
extern int32_t BIGAPPOS;
extern int32_t BIGCOLIN;
extern int32_t BIGCOMMA;
extern int32_t BIGFORCE;
extern int32_t BIGHOLE;
extern int32_t BIGORBIT1;
extern int32_t BIGPERIOD;
extern int32_t BIGQ;
extern int32_t BIGSEMI;
extern int32_t BIGX_;
extern int32_t BLANKSCREEN;
extern int32_t BLIMP;
extern int32_t BLOOD;
extern int32_t BLOODPOOL;
extern int32_t BLOODSPLAT1;
extern int32_t BLOODSPLAT2;
extern int32_t BLOODSPLAT3;
extern int32_t BLOODSPLAT4;
extern int32_t BLOODYPOLE;
extern int32_t BOLT1;
extern int32_t BONUSSCREEN;
extern int32_t BOOT_ICON;
extern int32_t BOOTS;
extern int32_t BORNTOBEWILDSCREEN;
extern int32_t BOSS1;
extern int32_t BOSS1LOB;
extern int32_t BOSS1SHOOT;
extern int32_t BOSS1STAYPUT;
extern int32_t BOSS2;
extern int32_t BOSS3;
extern int32_t BOSS4;
extern int32_t BOSS4STAYPUT;
extern int32_t BOSSTOP;
extern int32_t BOTTLE1;
extern int32_t BOTTLE10;
extern int32_t BOTTLE11;
extern int32_t BOTTLE12;
extern int32_t BOTTLE13;
extern int32_t BOTTLE14;
extern int32_t BOTTLE15;
extern int32_t BOTTLE16;
extern int32_t BOTTLE17;
extern int32_t BOTTLE18;
extern int32_t BOTTLE19;
extern int32_t BOTTLE2;
extern int32_t BOTTLE3;
extern int32_t BOTTLE4;
extern int32_t BOTTLE5;
extern int32_t BOTTLE6;
extern int32_t BOTTLE7;
extern int32_t BOTTLE8;
extern int32_t BOTTOMSTATUSBAR;
extern int32_t BOUNCEMINE;
extern int32_t BOX;
extern int32_t BPANNEL1;
extern int32_t BPANNEL3;
extern int32_t BROKEFIREHYDRENT;
extern int32_t BROKEHYDROPLANT;
extern int32_t BROKENCHAIR;
extern int32_t BULLETHOLE;
extern int32_t BURNING;
extern int32_t BURNING2;
extern int32_t CACTUS;
extern int32_t CACTUSBROKE;
extern int32_t CAMCORNER;
extern int32_t CAMERA1;
extern int32_t CAMERALIGHT;
extern int32_t CAMERAPOLE;
extern int32_t CAMLIGHT;
extern int32_t CANWITHSOMETHING;
extern int32_t CANWITHSOMETHING2;
extern int32_t CANWITHSOMETHING3;
extern int32_t CANWITHSOMETHING4;
extern int32_t CEILINGSTEAM;
extern int32_t CHAINGUN;
extern int32_t CHAINGUNSPRITE;
extern int32_t CHAIR1;
extern int32_t CHAIR2;
extern int32_t CHAIR3;
extern int32_t CIRCLEPANNEL;
extern int32_t CIRCLEPANNELBROKE;
extern int32_t CLOUDYOCEAN;
extern int32_t CLOUDYSKIES;
extern int32_t COLA;
extern int32_t COLAMACHINE;
extern int32_t COMMANDER;
extern int32_t COMMANDERSTAYPUT;
extern int32_t CONE;
extern int32_t COOLEXPLOSION1;
extern int32_t CRACK1;
extern int32_t CRACK2;
extern int32_t CRACK3;
extern int32_t CRACK4;
extern int32_t CRACKKNUCKLES;
extern int32_t CRANE;
extern int32_t CRANEPOLE;
extern int32_t CROSSHAIR;
extern int32_t CRYSTALAMMO;
extern int32_t CYCLER;
extern int32_t DEVISTATOR;
extern int32_t DEVISTATORAMMO;
extern int32_t DEVISTATORSPRITE;
extern int32_t DIGITALNUM;
extern int32_t DIPSWITCH;
extern int32_t DIPSWITCH2;
extern int32_t DIPSWITCH3;
extern int32_t DOLPHIN1;
extern int32_t DOLPHIN2;
extern int32_t DOMELITE;
extern int32_t DOORSHOCK;
extern int32_t DOORTILE1;
extern int32_t DOORTILE10;
extern int32_t DOORTILE11;
extern int32_t DOORTILE12;
extern int32_t DOORTILE14;
extern int32_t DOORTILE15;
extern int32_t DOORTILE16;
extern int32_t DOORTILE17;
extern int32_t DOORTILE18;
extern int32_t DOORTILE19;
extern int32_t DOORTILE2;
extern int32_t DOORTILE20;
extern int32_t DOORTILE21;
extern int32_t DOORTILE22;
extern int32_t DOORTILE23;
extern int32_t DOORTILE3;
extern int32_t DOORTILE4;
extern int32_t DOORTILE5;
extern int32_t DOORTILE6;
extern int32_t DOORTILE7;
extern int32_t DOORTILE8;
extern int32_t DOORTILE9;
extern int32_t DREALMS;
extern int32_t DRONE;
extern int32_t DUCK;
extern int32_t DUKECAR;
extern int32_t DUKEGUN;
extern int32_t DUKELEG;
extern int32_t DUKELYINGDEAD;
extern int32_t DUKENUKEM;
extern int32_t DUKETAG;
extern int32_t DUKETORSO;
extern int32_t EGG;
extern int32_t ENDALPHANUM;
extern int32_t EXPLODINGBARREL;
extern int32_t EXPLODINGBARREL2;
extern int32_t EXPLOSION2;
extern int32_t EXPLOSION2BOT;
extern int32_t F1HELP;
extern int32_t FANSHADOW;
extern int32_t FANSHADOWBROKE;
extern int32_t FANSPRITE;
extern int32_t FANSPRITEBROKE;
extern int32_t FECES;
extern int32_t FEM1;
extern int32_t FEM10;
extern int32_t FEM2;
extern int32_t FEM3;
extern int32_t FEM4;
extern int32_t FEM5;
extern int32_t FEM6;
extern int32_t FEM6PAD;
extern int32_t FEM7;
extern int32_t FEM8;
extern int32_t FEM9;
extern int32_t FEMMAG1;
extern int32_t FEMMAG2;
extern int32_t FEMPIC1;
extern int32_t FEMPIC2;
extern int32_t FEMPIC3;
extern int32_t FEMPIC4;
extern int32_t FEMPIC5;
extern int32_t FEMPIC6;
extern int32_t FEMPIC7;
extern int32_t FETUS;
extern int32_t FETUSBROKE;
extern int32_t FETUSJIB;
extern int32_t FIRE;
extern int32_t FIRE2;
extern int32_t FIREBARREL;
extern int32_t FIREEXT;
extern int32_t FIRELASER;
extern int32_t FIREVASE;
extern int32_t FIRSTAID;
extern int32_t FIRSTAID_ICON;
extern int32_t FIRSTGUN;
extern int32_t FIRSTGUNRELOAD;
extern int32_t FIRSTGUNSPRITE;
extern int32_t FIST;
extern int32_t FLOORFLAME;
extern int32_t FLOORPLASMA;
extern int32_t FLOORSLIME;
extern int32_t FOF;
extern int32_t FOODOBJECT16;
extern int32_t FOOTPRINTS;
extern int32_t FOOTPRINTS2;
extern int32_t FOOTPRINTS3;
extern int32_t FOOTPRINTS4;
extern int32_t FORCERIPPLE;
extern int32_t FORCESPHERE;
extern int32_t FRAGBAR;
extern int32_t FRAMEEFFECT1;
extern int32_t FRAMEEFFECT1_13;
extern int32_t FRANKENSTINESWITCH;
extern int32_t FREEZE;
extern int32_t FREEZEAMMO;
extern int32_t FREEZEBLAST;
extern int32_t FREEZESPRITE;
extern int32_t FUELPOD;
extern int32_t GENERICPOLE;
extern int32_t GENERICPOLE2;
extern int32_t GLASS;
extern int32_t GLASS2;
extern int32_t GLASSPIECES;
extern int32_t GPSPEED;
extern int32_t GRATE1;
extern int32_t GREENSLIME;
extern int32_t GROWAMMO;
extern int32_t GROWSPARK;
extern int32_t GROWSPRITEICON;
extern int32_t HANDHOLDINGACCESS;
extern int32_t HANDHOLDINGLASER;
extern int32_t HANDPRINTSWITCH;
extern int32_t HANDREMOTE;
extern int32_t HANDSWITCH;
extern int32_t HANDTHROW;
extern int32_t HANGLIGHT;
extern int32_t HBOMBAMMO;
extern int32_t HEADJIB1;
extern int32_t HEALTHBOX;
extern int32_t HEAT_ICON;
extern int32_t HEATSENSOR;
extern int32_t HEAVYHBOMB;
extern int32_t HELECOPT;
extern int32_t HOLODUKE;
extern int32_t HOLODUKE_ICON;
extern int32_t HORSEONSIDE;
extern int32_t HOTMEAT;
extern int32_t HURTRAIL;
extern int32_t HYDRENT;
extern int32_t HYDROPLANT;
extern int32_t INDY;
extern int32_t INGAMEDUKETHREEDEE;
extern int32_t INNERJAW;
extern int32_t INVENTORYBOX;
extern int32_t IVUNIT;
extern int32_t JETPACK;
extern int32_t JETPACK_ICON;
extern int32_t JIBS1;
extern int32_t JIBS2;
extern int32_t JIBS3;
extern int32_t JIBS4;
extern int32_t JIBS5;
extern int32_t JIBS6;
extern int32_t JURYGUY;
extern int32_t KILLSICON;
extern int32_t KNEE;
extern int32_t LA;
extern int32_t LASERLINE;
extern int32_t LASERSITE;
extern int32_t LEGJIB1;
extern int32_t LETTER;
extern int32_t LIGHTSWITCH;
extern int32_t LIGHTSWITCH2;
extern int32_t LIZMAN;
extern int32_t LIZMANARM1;
extern int32_t LIZMANFEEDING;
extern int32_t LIZMANHEAD1;
extern int32_t LIZMANJUMP;
extern int32_t LIZMANLEG1;
extern int32_t LIZMANSPITTING;
extern int32_t LIZMANSTAYPUT;
extern int32_t LIZTROOP;
extern int32_t LIZTROOPDUCKING;
extern int32_t LIZTROOPJETPACK;
extern int32_t LIZTROOPJUSTSIT;
extern int32_t LIZTROOPONTOILET;
extern int32_t LIZTROOPRUNNING;
extern int32_t LIZTROOPSHOOT;
extern int32_t LIZTROOPSTAYPUT;
extern int32_t LOADSCREEN;
extern int32_t LOCATORS;
extern int32_t LOCKSWITCH1;
extern int32_t LOOGIE;
extern int32_t LUKE;
extern int32_t MAIL;
extern int32_t MAN;
extern int32_t MAN2;
extern int32_t MASKWALL1;
extern int32_t MASKWALL10;
extern int32_t MASKWALL11;
extern int32_t MASKWALL12;
extern int32_t MASKWALL13;
extern int32_t MASKWALL14;
extern int32_t MASKWALL15;
extern int32_t MASKWALL2;
extern int32_t MASKWALL3;
extern int32_t MASKWALL4;
extern int32_t MASKWALL5;
extern int32_t MASKWALL6;
extern int32_t MASKWALL7;
extern int32_t MASKWALL8;
extern int32_t MASKWALL9;
extern int32_t MASTERSWITCH;
extern int32_t MENUBAR;
extern int32_t MENUSCREEN;
extern int32_t MIKE;
extern int32_t MINIFONT;
extern int32_t MIRROR;
extern int32_t MIRRORBROKE;
extern int32_t MONEY;
extern int32_t MONK;
extern int32_t MOONSKY1;
extern int32_t MORTER;
extern int32_t MOVIECAMERA;
extern int32_t MULTISWITCH;
extern int32_t MUSICANDSFX;
extern int32_t NAKED1;
extern int32_t NATURALLIGHTNING;
extern int32_t NEON1;
extern int32_t NEON2;
extern int32_t NEON3;
extern int32_t NEON4;
extern int32_t NEON5;
extern int32_t NEON6;
extern int32_t NEWBEAST;
extern int32_t NEWBEASTSTAYPUT;
extern int32_t NUKEBARREL;
extern int32_t NUKEBARRELDENTED;
extern int32_t NUKEBARRELLEAKED;
extern int32_t NUKEBUTTON;
extern int32_t OCEANSPRITE1;
extern int32_t OCEANSPRITE2;
extern int32_t OCEANSPRITE3;
extern int32_t OCEANSPRITE4;
extern int32_t OCEANSPRITE5;
extern int32_t OCTABRAIN;
extern int32_t OCTABRAINSTAYPUT;
extern int32_t OJ;
extern int32_t OOZ;
extern int32_t OOZ2;
extern int32_t OOZFILTER;
extern int32_t ORDERING;
extern int32_t ORGANTIC;
extern int32_t PANNEL1;
extern int32_t PANNEL2;
extern int32_t PANNEL3;
extern int32_t PAPER;
extern int32_t PIGCOP;
extern int32_t PIGCOPDIVE;
extern int32_t PIGCOPSTAYPUT;
extern int32_t PIPE1;
extern int32_t PIPE1B;
extern int32_t PIPE2;
extern int32_t PIPE2B;
extern int32_t PIPE3;
extern int32_t PIPE3B;
extern int32_t PIPE4;
extern int32_t PIPE4B;
extern int32_t PIPE5;
extern int32_t PIPE5B;
extern int32_t PIPE6;
extern int32_t PIPE6B;
extern int32_t PLAYERONWATER;
extern int32_t PLUG;
extern int32_t PLUTOPAKSPRITE;
extern int32_t POCKET;
extern int32_t PODFEM1;
extern int32_t POT1;
extern int32_t POT2;
extern int32_t POT3;
extern int32_t POWERSWITCH1;
extern int32_t POWERSWITCH2;
extern int32_t PUKE;
extern int32_t PULLSWITCH;
extern int32_t PURPLELAVA;
extern int32_t QUEBALL;
extern int32_t RADIUSEXPLOSION;
extern int32_t RAT;
extern int32_t REACTOR;
extern int32_t REACTOR2;
extern int32_t REACTOR2BURNT;
extern int32_t REACTOR2SPARK;
extern int32_t REACTORBURNT;
extern int32_t REACTORSPARK;
extern int32_t RECON;
extern int32_t RESPAWN;
extern int32_t RESPAWNMARKERGREEN;
extern int32_t RESPAWNMARKERRED;
extern int32_t RESPAWNMARKERYELLOW;
extern int32_t ROTATEGUN;
extern int32_t RPG;
extern int32_t RPGAMMO;
extern int32_t RPGGUN;
extern int32_t RPGSPRITE;
extern int32_t RUBBERCAN;
extern int32_t SATELITE;
extern int32_t SCALE;
extern int32_t SCRAP1;
extern int32_t SCRAP2;
extern int32_t SCRAP3;
extern int32_t SCRAP4;
extern int32_t SCRAP5;
extern int32_t SCRAP6;
extern int32_t SCREENBREAK1;
extern int32_t SCREENBREAK10;
extern int32_t SCREENBREAK11;
extern int32_t SCREENBREAK12;
extern int32_t SCREENBREAK13;
extern int32_t SCREENBREAK14;
extern int32_t SCREENBREAK15;
extern int32_t SCREENBREAK16;
extern int32_t SCREENBREAK17;
extern int32_t SCREENBREAK18;
extern int32_t SCREENBREAK19;
extern int32_t SCREENBREAK2;
extern int32_t SCREENBREAK3;
extern int32_t SCREENBREAK4;
extern int32_t SCREENBREAK5;
extern int32_t SCREENBREAK6;
extern int32_t SCREENBREAK7;
extern int32_t SCREENBREAK8;
extern int32_t SCREENBREAK9;
extern int32_t SCUBAMASK;
extern int32_t SECTOREFFECTOR;
extern int32_t SEENINE;
extern int32_t SEENINEDEAD;
extern int32_t SELECTDIR;
extern int32_t SHARK;
extern int32_t SHELL;
extern int32_t SHIELD;
extern int32_t SHOTGUN;
extern int32_t SHOTGUNAMMO;
extern int32_t SHOTGUNSHELL;
extern int32_t SHOTGUNSPRITE;
extern int32_t SHOTSPARK1;
extern int32_t SHRINKER;
extern int32_t SHRINKEREXPLOSION;
extern int32_t SHRINKERSPRITE;
extern int32_t SHRINKSPARK;
extern int32_t SIDEBOLT1;
extern int32_t SIGN1;
extern int32_t SIGN2;
extern int32_t SIXPAK;
extern int32_t SLIDEBAR;
extern int32_t SLOTDOOR;
extern int32_t SMALLFNTCURSOR;
extern int32_t SMALLSMOKE;
extern int32_t SOLARPANNEL;
extern int32_t SPACEDOORSWITCH;
extern int32_t SPACELIGHTSWITCH;
extern int32_t SPACEMARINE;
extern int32_t SPEAKER;
extern int32_t SPINNINGNUKEICON;
extern int32_t SPIT;
extern int32_t SPOTLITE;
extern int32_t STAINGLASS1;
extern int32_t STALL;
extern int32_t STALLBROKE;
extern int32_t STARTALPHANUM;
extern int32_t STATIC;
extern int32_t STATUE;
extern int32_t STATUEFLASH;
extern int32_t STEAM;
extern int32_t STEROIDS;
extern int32_t STEROIDS_ICON;
extern int32_t STRIPEBALL;
extern int32_t SUSHIPLATE1;
extern int32_t SUSHIPLATE2;
extern int32_t SUSHIPLATE3;
extern int32_t SUSHIPLATE4;
extern int32_t SUSHIPLATE5;
extern int32_t TAMPON;
extern int32_t TANK;
extern int32_t TARGET;
extern int32_t TECHLIGHT2;
extern int32_t TECHLIGHT4;
extern int32_t TECHLIGHTBUST2;
extern int32_t TECHLIGHTBUST4;
extern int32_t TECHSWITCH;
extern int32_t TENSCREEN;
extern int32_t TEXTBOX;
extern int32_t TEXTSTORY;
extern int32_t THREEBYFIVE;
extern int32_t THREEDEE;
extern int32_t TIP;
extern int32_t TIRE;
extern int32_t TOILET;
extern int32_t TOILETBROKE;
extern int32_t TOILETWATER;
extern int32_t TONGUE;
extern int32_t TOUCHPLATE;
extern int32_t TOUGHGAL;
extern int32_t TRANSPORTERBEAM;
extern int32_t TRANSPORTERSTAR;
extern int32_t TRASH;
extern int32_t TREE1;
extern int32_t TREE2;
extern int32_t TRIPBOMB;
extern int32_t TRIPBOMBSPRITE;
extern int32_t TRIPODCAMERA;
extern int32_t VACUUM;
extern int32_t VASE;
extern int32_t VENDMACHINE;
extern int32_t VICTORY1;
extern int32_t VIEWBORDER;
extern int32_t VIEWSCREEN;
extern int32_t VIEWSCREEN2;
extern int32_t W_FORCEFIELD;
extern int32_t W_HITTECHWALL1;
extern int32_t W_HITTECHWALL10;
extern int32_t W_HITTECHWALL15;
extern int32_t W_HITTECHWALL16;
extern int32_t W_HITTECHWALL2;
extern int32_t W_HITTECHWALL3;
extern int32_t W_HITTECHWALL4;
extern int32_t W_MILKSHELF;
extern int32_t W_MILKSHELFBROKE;
extern int32_t W_NUMBERS;
extern int32_t W_SCREENBREAK;
extern int32_t W_TECHWALL1;
extern int32_t W_TECHWALL10;
extern int32_t W_TECHWALL11;
extern int32_t W_TECHWALL12;
extern int32_t W_TECHWALL13;
extern int32_t W_TECHWALL14;
extern int32_t W_TECHWALL15;
extern int32_t W_TECHWALL16;
extern int32_t W_TECHWALL2;
extern int32_t W_TECHWALL3;
extern int32_t W_TECHWALL4;
extern int32_t W_TECHWALL5;
extern int32_t W_TECHWALL6;
extern int32_t W_TECHWALL7;
extern int32_t W_TECHWALL8;
extern int32_t W_TECHWALL9;
extern int32_t WAITTOBESEATED;
extern int32_t WALLBLOOD1;
extern int32_t WALLBLOOD2;
extern int32_t WALLBLOOD3;
extern int32_t WALLBLOOD4;
extern int32_t WALLBLOOD5;
extern int32_t WALLBLOOD7;
extern int32_t WALLBLOOD8;
extern int32_t WALLLIGHT1;
extern int32_t WALLLIGHT2;
extern int32_t WALLLIGHT3;
extern int32_t WALLLIGHT4;
extern int32_t WALLLIGHTBUST1;
extern int32_t WALLLIGHTBUST2;
extern int32_t WALLLIGHTBUST3;
extern int32_t WALLLIGHTBUST4;
extern int32_t WATERBUBBLE;
extern int32_t WATERBUBBLEMAKER;
extern int32_t WATERDRIP;
extern int32_t WATERDRIPSPLASH;
extern int32_t WATERFOUNTAIN;
extern int32_t WATERFOUNTAINBROKE;
extern int32_t WATERSPLASH2;
extern int32_t WATERTILE2;
extern int32_t WEATHERWARN;
extern int32_t WINDOWBORDER1;
extern int32_t WINDOWBORDER2;
extern int32_t WOMAN;
extern int32_t WOODENHORSE;
extern int32_t XXXSTACY;
extern int32_t WIDESCREENSTATUSBAR;
extern int32_t RPGGUNWIDE;
extern int32_t FIRSTGUNRELOADWIDE;
extern int32_t FREEZEWIDE;
extern int32_t FREEZEFIREWIDE;
extern int32_t SHRINKERWIDE;
extern int32_t CRACKKNUCKLESWIDE;
extern int32_t FLAMETHROWERSPRITE;
extern int32_t FLAMETHROWERAMMO;
extern int32_t FLAMETHROWER;
extern int32_t FLAMETHROWERFIRE;
extern int32_t FLAMETHROWERFLAME;
extern int32_t FLAMETHROWERPILOT;
extern int32_t FIREBALL;
extern int32_t ONFIRE;
extern int32_t ONFIRESMOKE;
extern int32_t BURNEDCORPSE;
extern int32_t WHISPYSMOKE;
extern int32_t FIREFLY;
extern int32_t FIREFLYSHRINKEFFECT;
extern int32_t FIREFLYGROWEFFECT;
extern int32_t FIREFLYFLYINGEFFECT;
extern int32_t BOSS5;
extern int32_t BOSS5STAYPUT;
extern int32_t LAVAPOOL;
extern int32_t LAVASPLASH;
extern int32_t LAVAPOOLBUBBLE;
extern int32_t BOSS2STAYPUT;
extern int32_t BOSS3STAYPUT;
extern int32_t E32_TILE5736;
extern int32_t E32_TILE5737;
extern int32_t E32_TILE5846;

static FORCE_INLINE int tileGetMapping(int const tile)
{
    int const found = inthash_find(&h_dynamictilemap, tile);
    return found != -1 ? found : tile;
}

static FORCE_INLINE void tileSetMapping(int const tile1, int const tile2)
{
    inthash_add(&h_dynamictilemap, tile1, tile2, true);
}

#else  /* if !defined DYNTILEREMAP_ENABLE */

#define G_ProcessDynamicTileMapping(x, y) ((void)(0))

#define inithashnames() ((void)0)
#define freehashnames() ((void)0)

#include "names.h"
#undef SPACESHUTTLE
#undef CANNON
#undef CANNONBALLS

#define tileGetMapping(Tilenum) (Tilenum)

#endif
#endif // namesdyn_h__
