package main

import (
	"encoding/json"
	"fmt"

	v2 "github.com/baidubce/bce-sdk-go/services/cce/v2"
	"github.com/baidubce/bce-sdk-go/services/cce/v2/model"
)

// ListBackupTasks 获取备份任务
func ListBackupTasks() {
	// 用户的Access Key ID和Secret Access Key
	AK, SK := "", ""

	// 用户指定的endpoint
	ENDPOINT := ""

	// 初始化一个CCEClient
	client, err := v2.NewClient(AK, SK, ENDPOINT)
	if err != nil {
		panic(err)
	}

	args := &model.ListTasksRequest{
		ClusterID: "集群ID",
		PageNo:    1,
		PageSize:  10,

		// 获取指定备份任务
		KeywordType: "taskName",
		Keyword:     "备份任务名称",
	}

	resp, err := client.ListBackupTasks(args)
	if err != nil {
		fmt.Println(err.Error())
		return
	}
	s, _ := json.MarshalIndent(resp, "", "\t")
	fmt.Println("Response:" + string(s))
}
