package page

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"
	"strings"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/network"
	"github.com/chromedp/cdproto/runtime"
)

// AdScriptID identifies the bottom-most script which caused the frame to be
// labelled as an ad.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-AdScriptId
type AdScriptID struct {
	ScriptID   runtime.ScriptID         `json:"scriptId"`   // Script Id of the bottom-most script which caused the frame to be labelled as an ad.
	DebuggerID runtime.UniqueDebuggerID `json:"debuggerId"` // Id of adScriptId's debugger.
}

// PermissionsPolicyFeature all Permissions Policy features. This enum should
// match the one defined in
// services/network/public/cpp/permissions_policy/permissions_policy_features.json5.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-PermissionsPolicyFeature
type PermissionsPolicyFeature string

// String returns the PermissionsPolicyFeature as string value.
func (t PermissionsPolicyFeature) String() string {
	return string(t)
}

// PermissionsPolicyFeature values.
const (
	PermissionsPolicyFeatureAccelerometer                  PermissionsPolicyFeature = "accelerometer"
	PermissionsPolicyFeatureAllScreensCapture              PermissionsPolicyFeature = "all-screens-capture"
	PermissionsPolicyFeatureAmbientLightSensor             PermissionsPolicyFeature = "ambient-light-sensor"
	PermissionsPolicyFeatureAttributionReporting           PermissionsPolicyFeature = "attribution-reporting"
	PermissionsPolicyFeatureAutoplay                       PermissionsPolicyFeature = "autoplay"
	PermissionsPolicyFeatureBluetooth                      PermissionsPolicyFeature = "bluetooth"
	PermissionsPolicyFeatureBrowsingTopics                 PermissionsPolicyFeature = "browsing-topics"
	PermissionsPolicyFeatureCamera                         PermissionsPolicyFeature = "camera"
	PermissionsPolicyFeatureCapturedSurfaceControl         PermissionsPolicyFeature = "captured-surface-control"
	PermissionsPolicyFeatureChDpr                          PermissionsPolicyFeature = "ch-dpr"
	PermissionsPolicyFeatureChDeviceMemory                 PermissionsPolicyFeature = "ch-device-memory"
	PermissionsPolicyFeatureChDownlink                     PermissionsPolicyFeature = "ch-downlink"
	PermissionsPolicyFeatureChEct                          PermissionsPolicyFeature = "ch-ect"
	PermissionsPolicyFeatureChPrefersColorScheme           PermissionsPolicyFeature = "ch-prefers-color-scheme"
	PermissionsPolicyFeatureChPrefersReducedMotion         PermissionsPolicyFeature = "ch-prefers-reduced-motion"
	PermissionsPolicyFeatureChPrefersReducedTransparency   PermissionsPolicyFeature = "ch-prefers-reduced-transparency"
	PermissionsPolicyFeatureChRtt                          PermissionsPolicyFeature = "ch-rtt"
	PermissionsPolicyFeatureChSaveData                     PermissionsPolicyFeature = "ch-save-data"
	PermissionsPolicyFeatureChUa                           PermissionsPolicyFeature = "ch-ua"
	PermissionsPolicyFeatureChUaArch                       PermissionsPolicyFeature = "ch-ua-arch"
	PermissionsPolicyFeatureChUaBitness                    PermissionsPolicyFeature = "ch-ua-bitness"
	PermissionsPolicyFeatureChUaHighEntropyValues          PermissionsPolicyFeature = "ch-ua-high-entropy-values"
	PermissionsPolicyFeatureChUaPlatform                   PermissionsPolicyFeature = "ch-ua-platform"
	PermissionsPolicyFeatureChUaModel                      PermissionsPolicyFeature = "ch-ua-model"
	PermissionsPolicyFeatureChUaMobile                     PermissionsPolicyFeature = "ch-ua-mobile"
	PermissionsPolicyFeatureChUaFormFactors                PermissionsPolicyFeature = "ch-ua-form-factors"
	PermissionsPolicyFeatureChUaFullVersion                PermissionsPolicyFeature = "ch-ua-full-version"
	PermissionsPolicyFeatureChUaFullVersionList            PermissionsPolicyFeature = "ch-ua-full-version-list"
	PermissionsPolicyFeatureChUaPlatformVersion            PermissionsPolicyFeature = "ch-ua-platform-version"
	PermissionsPolicyFeatureChUaWow64                      PermissionsPolicyFeature = "ch-ua-wow64"
	PermissionsPolicyFeatureChViewportHeight               PermissionsPolicyFeature = "ch-viewport-height"
	PermissionsPolicyFeatureChViewportWidth                PermissionsPolicyFeature = "ch-viewport-width"
	PermissionsPolicyFeatureChWidth                        PermissionsPolicyFeature = "ch-width"
	PermissionsPolicyFeatureClipboardRead                  PermissionsPolicyFeature = "clipboard-read"
	PermissionsPolicyFeatureClipboardWrite                 PermissionsPolicyFeature = "clipboard-write"
	PermissionsPolicyFeatureComputePressure                PermissionsPolicyFeature = "compute-pressure"
	PermissionsPolicyFeatureControlledFrame                PermissionsPolicyFeature = "controlled-frame"
	PermissionsPolicyFeatureCrossOriginIsolated            PermissionsPolicyFeature = "cross-origin-isolated"
	PermissionsPolicyFeatureDeferredFetch                  PermissionsPolicyFeature = "deferred-fetch"
	PermissionsPolicyFeatureDeferredFetchMinimal           PermissionsPolicyFeature = "deferred-fetch-minimal"
	PermissionsPolicyFeatureDigitalCredentialsGet          PermissionsPolicyFeature = "digital-credentials-get"
	PermissionsPolicyFeatureDirectSockets                  PermissionsPolicyFeature = "direct-sockets"
	PermissionsPolicyFeatureDirectSocketsPrivate           PermissionsPolicyFeature = "direct-sockets-private"
	PermissionsPolicyFeatureDisplayCapture                 PermissionsPolicyFeature = "display-capture"
	PermissionsPolicyFeatureDocumentDomain                 PermissionsPolicyFeature = "document-domain"
	PermissionsPolicyFeatureEncryptedMedia                 PermissionsPolicyFeature = "encrypted-media"
	PermissionsPolicyFeatureExecutionWhileOutOfViewport    PermissionsPolicyFeature = "execution-while-out-of-viewport"
	PermissionsPolicyFeatureExecutionWhileNotRendered      PermissionsPolicyFeature = "execution-while-not-rendered"
	PermissionsPolicyFeatureFencedUnpartitionedStorageRead PermissionsPolicyFeature = "fenced-unpartitioned-storage-read"
	PermissionsPolicyFeatureFocusWithoutUserActivation     PermissionsPolicyFeature = "focus-without-user-activation"
	PermissionsPolicyFeatureFullscreen                     PermissionsPolicyFeature = "fullscreen"
	PermissionsPolicyFeatureFrobulate                      PermissionsPolicyFeature = "frobulate"
	PermissionsPolicyFeatureGamepad                        PermissionsPolicyFeature = "gamepad"
	PermissionsPolicyFeatureGeolocation                    PermissionsPolicyFeature = "geolocation"
	PermissionsPolicyFeatureGyroscope                      PermissionsPolicyFeature = "gyroscope"
	PermissionsPolicyFeatureHid                            PermissionsPolicyFeature = "hid"
	PermissionsPolicyFeatureIdentityCredentialsGet         PermissionsPolicyFeature = "identity-credentials-get"
	PermissionsPolicyFeatureIdleDetection                  PermissionsPolicyFeature = "idle-detection"
	PermissionsPolicyFeatureInterestCohort                 PermissionsPolicyFeature = "interest-cohort"
	PermissionsPolicyFeatureJoinAdInterestGroup            PermissionsPolicyFeature = "join-ad-interest-group"
	PermissionsPolicyFeatureKeyboardMap                    PermissionsPolicyFeature = "keyboard-map"
	PermissionsPolicyFeatureLanguageDetector               PermissionsPolicyFeature = "language-detector"
	PermissionsPolicyFeatureLocalFonts                     PermissionsPolicyFeature = "local-fonts"
	PermissionsPolicyFeatureMagnetometer                   PermissionsPolicyFeature = "magnetometer"
	PermissionsPolicyFeatureMediaPlaybackWhileNotVisible   PermissionsPolicyFeature = "media-playback-while-not-visible"
	PermissionsPolicyFeatureMicrophone                     PermissionsPolicyFeature = "microphone"
	PermissionsPolicyFeatureMidi                           PermissionsPolicyFeature = "midi"
	PermissionsPolicyFeatureOtpCredentials                 PermissionsPolicyFeature = "otp-credentials"
	PermissionsPolicyFeaturePayment                        PermissionsPolicyFeature = "payment"
	PermissionsPolicyFeaturePictureInPicture               PermissionsPolicyFeature = "picture-in-picture"
	PermissionsPolicyFeaturePopins                         PermissionsPolicyFeature = "popins"
	PermissionsPolicyFeaturePrivateAggregation             PermissionsPolicyFeature = "private-aggregation"
	PermissionsPolicyFeaturePrivateStateTokenIssuance      PermissionsPolicyFeature = "private-state-token-issuance"
	PermissionsPolicyFeaturePrivateStateTokenRedemption    PermissionsPolicyFeature = "private-state-token-redemption"
	PermissionsPolicyFeaturePublickeyCredentialsCreate     PermissionsPolicyFeature = "publickey-credentials-create"
	PermissionsPolicyFeaturePublickeyCredentialsGet        PermissionsPolicyFeature = "publickey-credentials-get"
	PermissionsPolicyFeatureRewriter                       PermissionsPolicyFeature = "rewriter"
	PermissionsPolicyFeatureRunAdAuction                   PermissionsPolicyFeature = "run-ad-auction"
	PermissionsPolicyFeatureScreenWakeLock                 PermissionsPolicyFeature = "screen-wake-lock"
	PermissionsPolicyFeatureSerial                         PermissionsPolicyFeature = "serial"
	PermissionsPolicyFeatureSharedAutofill                 PermissionsPolicyFeature = "shared-autofill"
	PermissionsPolicyFeatureSharedStorage                  PermissionsPolicyFeature = "shared-storage"
	PermissionsPolicyFeatureSharedStorageSelectURL         PermissionsPolicyFeature = "shared-storage-select-url"
	PermissionsPolicyFeatureSmartCard                      PermissionsPolicyFeature = "smart-card"
	PermissionsPolicyFeatureSpeakerSelection               PermissionsPolicyFeature = "speaker-selection"
	PermissionsPolicyFeatureStorageAccess                  PermissionsPolicyFeature = "storage-access"
	PermissionsPolicyFeatureSubApps                        PermissionsPolicyFeature = "sub-apps"
	PermissionsPolicyFeatureSummarizer                     PermissionsPolicyFeature = "summarizer"
	PermissionsPolicyFeatureSyncXhr                        PermissionsPolicyFeature = "sync-xhr"
	PermissionsPolicyFeatureTranslator                     PermissionsPolicyFeature = "translator"
	PermissionsPolicyFeatureUnload                         PermissionsPolicyFeature = "unload"
	PermissionsPolicyFeatureUsb                            PermissionsPolicyFeature = "usb"
	PermissionsPolicyFeatureUsbUnrestricted                PermissionsPolicyFeature = "usb-unrestricted"
	PermissionsPolicyFeatureVerticalScroll                 PermissionsPolicyFeature = "vertical-scroll"
	PermissionsPolicyFeatureWebAppInstallation             PermissionsPolicyFeature = "web-app-installation"
	PermissionsPolicyFeatureWebPrinting                    PermissionsPolicyFeature = "web-printing"
	PermissionsPolicyFeatureWebShare                       PermissionsPolicyFeature = "web-share"
	PermissionsPolicyFeatureWindowManagement               PermissionsPolicyFeature = "window-management"
	PermissionsPolicyFeatureWriter                         PermissionsPolicyFeature = "writer"
	PermissionsPolicyFeatureXrSpatialTracking              PermissionsPolicyFeature = "xr-spatial-tracking"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *PermissionsPolicyFeature) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch PermissionsPolicyFeature(s) {
	case PermissionsPolicyFeatureAccelerometer:
		*t = PermissionsPolicyFeatureAccelerometer
	case PermissionsPolicyFeatureAllScreensCapture:
		*t = PermissionsPolicyFeatureAllScreensCapture
	case PermissionsPolicyFeatureAmbientLightSensor:
		*t = PermissionsPolicyFeatureAmbientLightSensor
	case PermissionsPolicyFeatureAttributionReporting:
		*t = PermissionsPolicyFeatureAttributionReporting
	case PermissionsPolicyFeatureAutoplay:
		*t = PermissionsPolicyFeatureAutoplay
	case PermissionsPolicyFeatureBluetooth:
		*t = PermissionsPolicyFeatureBluetooth
	case PermissionsPolicyFeatureBrowsingTopics:
		*t = PermissionsPolicyFeatureBrowsingTopics
	case PermissionsPolicyFeatureCamera:
		*t = PermissionsPolicyFeatureCamera
	case PermissionsPolicyFeatureCapturedSurfaceControl:
		*t = PermissionsPolicyFeatureCapturedSurfaceControl
	case PermissionsPolicyFeatureChDpr:
		*t = PermissionsPolicyFeatureChDpr
	case PermissionsPolicyFeatureChDeviceMemory:
		*t = PermissionsPolicyFeatureChDeviceMemory
	case PermissionsPolicyFeatureChDownlink:
		*t = PermissionsPolicyFeatureChDownlink
	case PermissionsPolicyFeatureChEct:
		*t = PermissionsPolicyFeatureChEct
	case PermissionsPolicyFeatureChPrefersColorScheme:
		*t = PermissionsPolicyFeatureChPrefersColorScheme
	case PermissionsPolicyFeatureChPrefersReducedMotion:
		*t = PermissionsPolicyFeatureChPrefersReducedMotion
	case PermissionsPolicyFeatureChPrefersReducedTransparency:
		*t = PermissionsPolicyFeatureChPrefersReducedTransparency
	case PermissionsPolicyFeatureChRtt:
		*t = PermissionsPolicyFeatureChRtt
	case PermissionsPolicyFeatureChSaveData:
		*t = PermissionsPolicyFeatureChSaveData
	case PermissionsPolicyFeatureChUa:
		*t = PermissionsPolicyFeatureChUa
	case PermissionsPolicyFeatureChUaArch:
		*t = PermissionsPolicyFeatureChUaArch
	case PermissionsPolicyFeatureChUaBitness:
		*t = PermissionsPolicyFeatureChUaBitness
	case PermissionsPolicyFeatureChUaHighEntropyValues:
		*t = PermissionsPolicyFeatureChUaHighEntropyValues
	case PermissionsPolicyFeatureChUaPlatform:
		*t = PermissionsPolicyFeatureChUaPlatform
	case PermissionsPolicyFeatureChUaModel:
		*t = PermissionsPolicyFeatureChUaModel
	case PermissionsPolicyFeatureChUaMobile:
		*t = PermissionsPolicyFeatureChUaMobile
	case PermissionsPolicyFeatureChUaFormFactors:
		*t = PermissionsPolicyFeatureChUaFormFactors
	case PermissionsPolicyFeatureChUaFullVersion:
		*t = PermissionsPolicyFeatureChUaFullVersion
	case PermissionsPolicyFeatureChUaFullVersionList:
		*t = PermissionsPolicyFeatureChUaFullVersionList
	case PermissionsPolicyFeatureChUaPlatformVersion:
		*t = PermissionsPolicyFeatureChUaPlatformVersion
	case PermissionsPolicyFeatureChUaWow64:
		*t = PermissionsPolicyFeatureChUaWow64
	case PermissionsPolicyFeatureChViewportHeight:
		*t = PermissionsPolicyFeatureChViewportHeight
	case PermissionsPolicyFeatureChViewportWidth:
		*t = PermissionsPolicyFeatureChViewportWidth
	case PermissionsPolicyFeatureChWidth:
		*t = PermissionsPolicyFeatureChWidth
	case PermissionsPolicyFeatureClipboardRead:
		*t = PermissionsPolicyFeatureClipboardRead
	case PermissionsPolicyFeatureClipboardWrite:
		*t = PermissionsPolicyFeatureClipboardWrite
	case PermissionsPolicyFeatureComputePressure:
		*t = PermissionsPolicyFeatureComputePressure
	case PermissionsPolicyFeatureControlledFrame:
		*t = PermissionsPolicyFeatureControlledFrame
	case PermissionsPolicyFeatureCrossOriginIsolated:
		*t = PermissionsPolicyFeatureCrossOriginIsolated
	case PermissionsPolicyFeatureDeferredFetch:
		*t = PermissionsPolicyFeatureDeferredFetch
	case PermissionsPolicyFeatureDeferredFetchMinimal:
		*t = PermissionsPolicyFeatureDeferredFetchMinimal
	case PermissionsPolicyFeatureDigitalCredentialsGet:
		*t = PermissionsPolicyFeatureDigitalCredentialsGet
	case PermissionsPolicyFeatureDirectSockets:
		*t = PermissionsPolicyFeatureDirectSockets
	case PermissionsPolicyFeatureDirectSocketsPrivate:
		*t = PermissionsPolicyFeatureDirectSocketsPrivate
	case PermissionsPolicyFeatureDisplayCapture:
		*t = PermissionsPolicyFeatureDisplayCapture
	case PermissionsPolicyFeatureDocumentDomain:
		*t = PermissionsPolicyFeatureDocumentDomain
	case PermissionsPolicyFeatureEncryptedMedia:
		*t = PermissionsPolicyFeatureEncryptedMedia
	case PermissionsPolicyFeatureExecutionWhileOutOfViewport:
		*t = PermissionsPolicyFeatureExecutionWhileOutOfViewport
	case PermissionsPolicyFeatureExecutionWhileNotRendered:
		*t = PermissionsPolicyFeatureExecutionWhileNotRendered
	case PermissionsPolicyFeatureFencedUnpartitionedStorageRead:
		*t = PermissionsPolicyFeatureFencedUnpartitionedStorageRead
	case PermissionsPolicyFeatureFocusWithoutUserActivation:
		*t = PermissionsPolicyFeatureFocusWithoutUserActivation
	case PermissionsPolicyFeatureFullscreen:
		*t = PermissionsPolicyFeatureFullscreen
	case PermissionsPolicyFeatureFrobulate:
		*t = PermissionsPolicyFeatureFrobulate
	case PermissionsPolicyFeatureGamepad:
		*t = PermissionsPolicyFeatureGamepad
	case PermissionsPolicyFeatureGeolocation:
		*t = PermissionsPolicyFeatureGeolocation
	case PermissionsPolicyFeatureGyroscope:
		*t = PermissionsPolicyFeatureGyroscope
	case PermissionsPolicyFeatureHid:
		*t = PermissionsPolicyFeatureHid
	case PermissionsPolicyFeatureIdentityCredentialsGet:
		*t = PermissionsPolicyFeatureIdentityCredentialsGet
	case PermissionsPolicyFeatureIdleDetection:
		*t = PermissionsPolicyFeatureIdleDetection
	case PermissionsPolicyFeatureInterestCohort:
		*t = PermissionsPolicyFeatureInterestCohort
	case PermissionsPolicyFeatureJoinAdInterestGroup:
		*t = PermissionsPolicyFeatureJoinAdInterestGroup
	case PermissionsPolicyFeatureKeyboardMap:
		*t = PermissionsPolicyFeatureKeyboardMap
	case PermissionsPolicyFeatureLanguageDetector:
		*t = PermissionsPolicyFeatureLanguageDetector
	case PermissionsPolicyFeatureLocalFonts:
		*t = PermissionsPolicyFeatureLocalFonts
	case PermissionsPolicyFeatureMagnetometer:
		*t = PermissionsPolicyFeatureMagnetometer
	case PermissionsPolicyFeatureMediaPlaybackWhileNotVisible:
		*t = PermissionsPolicyFeatureMediaPlaybackWhileNotVisible
	case PermissionsPolicyFeatureMicrophone:
		*t = PermissionsPolicyFeatureMicrophone
	case PermissionsPolicyFeatureMidi:
		*t = PermissionsPolicyFeatureMidi
	case PermissionsPolicyFeatureOtpCredentials:
		*t = PermissionsPolicyFeatureOtpCredentials
	case PermissionsPolicyFeaturePayment:
		*t = PermissionsPolicyFeaturePayment
	case PermissionsPolicyFeaturePictureInPicture:
		*t = PermissionsPolicyFeaturePictureInPicture
	case PermissionsPolicyFeaturePopins:
		*t = PermissionsPolicyFeaturePopins
	case PermissionsPolicyFeaturePrivateAggregation:
		*t = PermissionsPolicyFeaturePrivateAggregation
	case PermissionsPolicyFeaturePrivateStateTokenIssuance:
		*t = PermissionsPolicyFeaturePrivateStateTokenIssuance
	case PermissionsPolicyFeaturePrivateStateTokenRedemption:
		*t = PermissionsPolicyFeaturePrivateStateTokenRedemption
	case PermissionsPolicyFeaturePublickeyCredentialsCreate:
		*t = PermissionsPolicyFeaturePublickeyCredentialsCreate
	case PermissionsPolicyFeaturePublickeyCredentialsGet:
		*t = PermissionsPolicyFeaturePublickeyCredentialsGet
	case PermissionsPolicyFeatureRewriter:
		*t = PermissionsPolicyFeatureRewriter
	case PermissionsPolicyFeatureRunAdAuction:
		*t = PermissionsPolicyFeatureRunAdAuction
	case PermissionsPolicyFeatureScreenWakeLock:
		*t = PermissionsPolicyFeatureScreenWakeLock
	case PermissionsPolicyFeatureSerial:
		*t = PermissionsPolicyFeatureSerial
	case PermissionsPolicyFeatureSharedAutofill:
		*t = PermissionsPolicyFeatureSharedAutofill
	case PermissionsPolicyFeatureSharedStorage:
		*t = PermissionsPolicyFeatureSharedStorage
	case PermissionsPolicyFeatureSharedStorageSelectURL:
		*t = PermissionsPolicyFeatureSharedStorageSelectURL
	case PermissionsPolicyFeatureSmartCard:
		*t = PermissionsPolicyFeatureSmartCard
	case PermissionsPolicyFeatureSpeakerSelection:
		*t = PermissionsPolicyFeatureSpeakerSelection
	case PermissionsPolicyFeatureStorageAccess:
		*t = PermissionsPolicyFeatureStorageAccess
	case PermissionsPolicyFeatureSubApps:
		*t = PermissionsPolicyFeatureSubApps
	case PermissionsPolicyFeatureSummarizer:
		*t = PermissionsPolicyFeatureSummarizer
	case PermissionsPolicyFeatureSyncXhr:
		*t = PermissionsPolicyFeatureSyncXhr
	case PermissionsPolicyFeatureTranslator:
		*t = PermissionsPolicyFeatureTranslator
	case PermissionsPolicyFeatureUnload:
		*t = PermissionsPolicyFeatureUnload
	case PermissionsPolicyFeatureUsb:
		*t = PermissionsPolicyFeatureUsb
	case PermissionsPolicyFeatureUsbUnrestricted:
		*t = PermissionsPolicyFeatureUsbUnrestricted
	case PermissionsPolicyFeatureVerticalScroll:
		*t = PermissionsPolicyFeatureVerticalScroll
	case PermissionsPolicyFeatureWebAppInstallation:
		*t = PermissionsPolicyFeatureWebAppInstallation
	case PermissionsPolicyFeatureWebPrinting:
		*t = PermissionsPolicyFeatureWebPrinting
	case PermissionsPolicyFeatureWebShare:
		*t = PermissionsPolicyFeatureWebShare
	case PermissionsPolicyFeatureWindowManagement:
		*t = PermissionsPolicyFeatureWindowManagement
	case PermissionsPolicyFeatureWriter:
		*t = PermissionsPolicyFeatureWriter
	case PermissionsPolicyFeatureXrSpatialTracking:
		*t = PermissionsPolicyFeatureXrSpatialTracking
	default:
		return fmt.Errorf("unknown PermissionsPolicyFeature value: %v", s)
	}
	return nil
}

// PermissionsPolicyBlockReason reason for a permissions policy feature to be
// disabled.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-PermissionsPolicyBlockReason
type PermissionsPolicyBlockReason string

// String returns the PermissionsPolicyBlockReason as string value.
func (t PermissionsPolicyBlockReason) String() string {
	return string(t)
}

// PermissionsPolicyBlockReason values.
const (
	PermissionsPolicyBlockReasonHeader            PermissionsPolicyBlockReason = "Header"
	PermissionsPolicyBlockReasonIframeAttribute   PermissionsPolicyBlockReason = "IframeAttribute"
	PermissionsPolicyBlockReasonInFencedFrameTree PermissionsPolicyBlockReason = "InFencedFrameTree"
	PermissionsPolicyBlockReasonInIsolatedApp     PermissionsPolicyBlockReason = "InIsolatedApp"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *PermissionsPolicyBlockReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch PermissionsPolicyBlockReason(s) {
	case PermissionsPolicyBlockReasonHeader:
		*t = PermissionsPolicyBlockReasonHeader
	case PermissionsPolicyBlockReasonIframeAttribute:
		*t = PermissionsPolicyBlockReasonIframeAttribute
	case PermissionsPolicyBlockReasonInFencedFrameTree:
		*t = PermissionsPolicyBlockReasonInFencedFrameTree
	case PermissionsPolicyBlockReasonInIsolatedApp:
		*t = PermissionsPolicyBlockReasonInIsolatedApp
	default:
		return fmt.Errorf("unknown PermissionsPolicyBlockReason value: %v", s)
	}
	return nil
}

// PermissionsPolicyBlockLocator [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-PermissionsPolicyBlockLocator
type PermissionsPolicyBlockLocator struct {
	FrameID     cdp.FrameID                  `json:"frameId"`
	BlockReason PermissionsPolicyBlockReason `json:"blockReason"`
}

// PermissionsPolicyFeatureState [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-PermissionsPolicyFeatureState
type PermissionsPolicyFeatureState struct {
	Feature PermissionsPolicyFeature       `json:"feature"`
	Allowed bool                           `json:"allowed"`
	Locator *PermissionsPolicyBlockLocator `json:"locator,omitempty,omitzero"`
}

// FrameResource information about the Resource on the page.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FrameResource
type FrameResource struct {
	URL          string               `json:"url"`                             // Resource URL.
	Type         network.ResourceType `json:"type"`                            // Type of this resource.
	MimeType     string               `json:"mimeType"`                        // Resource mimeType as determined by the browser.
	LastModified *cdp.TimeSinceEpoch  `json:"lastModified,omitempty,omitzero"` // last-modified timestamp as reported by server.
	ContentSize  float64              `json:"contentSize,omitempty,omitzero"`  // Resource content size.
	Failed       bool                 `json:"failed"`                          // True if the resource failed to load.
	Canceled     bool                 `json:"canceled"`                        // True if the resource was canceled during loading.
}

// FrameResourceTree information about the Frame hierarchy along with their
// cached resources.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FrameResourceTree
type FrameResourceTree struct {
	Frame       *cdp.Frame           `json:"frame"`                          // Frame information for this tree item.
	ChildFrames []*FrameResourceTree `json:"childFrames,omitempty,omitzero"` // Child frames.
	Resources   []*FrameResource     `json:"resources"`                      // Information about frame resources.
}

// FrameTree information about the Frame hierarchy.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FrameTree
type FrameTree struct {
	Frame       *cdp.Frame   `json:"frame"`                          // Frame information for this tree item.
	ChildFrames []*FrameTree `json:"childFrames,omitempty,omitzero"` // Child frames.
}

// ScriptIdentifier unique script identifier.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ScriptIdentifier
type ScriptIdentifier string

// String returns the ScriptIdentifier as string value.
func (t ScriptIdentifier) String() string {
	return string(t)
}

// TransitionType transition type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-TransitionType
type TransitionType string

// String returns the TransitionType as string value.
func (t TransitionType) String() string {
	return string(t)
}

// TransitionType values.
const (
	TransitionTypeLink             TransitionType = "link"
	TransitionTypeTyped            TransitionType = "typed"
	TransitionTypeAddressBar       TransitionType = "address_bar"
	TransitionTypeAutoBookmark     TransitionType = "auto_bookmark"
	TransitionTypeAutoSubframe     TransitionType = "auto_subframe"
	TransitionTypeManualSubframe   TransitionType = "manual_subframe"
	TransitionTypeGenerated        TransitionType = "generated"
	TransitionTypeAutoToplevel     TransitionType = "auto_toplevel"
	TransitionTypeFormSubmit       TransitionType = "form_submit"
	TransitionTypeReload           TransitionType = "reload"
	TransitionTypeKeyword          TransitionType = "keyword"
	TransitionTypeKeywordGenerated TransitionType = "keyword_generated"
	TransitionTypeOther            TransitionType = "other"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *TransitionType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch TransitionType(s) {
	case TransitionTypeLink:
		*t = TransitionTypeLink
	case TransitionTypeTyped:
		*t = TransitionTypeTyped
	case TransitionTypeAddressBar:
		*t = TransitionTypeAddressBar
	case TransitionTypeAutoBookmark:
		*t = TransitionTypeAutoBookmark
	case TransitionTypeAutoSubframe:
		*t = TransitionTypeAutoSubframe
	case TransitionTypeManualSubframe:
		*t = TransitionTypeManualSubframe
	case TransitionTypeGenerated:
		*t = TransitionTypeGenerated
	case TransitionTypeAutoToplevel:
		*t = TransitionTypeAutoToplevel
	case TransitionTypeFormSubmit:
		*t = TransitionTypeFormSubmit
	case TransitionTypeReload:
		*t = TransitionTypeReload
	case TransitionTypeKeyword:
		*t = TransitionTypeKeyword
	case TransitionTypeKeywordGenerated:
		*t = TransitionTypeKeywordGenerated
	case TransitionTypeOther:
		*t = TransitionTypeOther
	default:
		return fmt.Errorf("unknown TransitionType value: %v", s)
	}
	return nil
}

// NavigationEntry navigation history entry.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-NavigationEntry
type NavigationEntry struct {
	ID             int64          `json:"id"`             // Unique id of the navigation history entry.
	URL            string         `json:"url"`            // URL of the navigation history entry.
	UserTypedURL   string         `json:"userTypedURL"`   // URL that the user typed in the url bar.
	Title          string         `json:"title"`          // Title of the navigation history entry.
	TransitionType TransitionType `json:"transitionType"` // Transition type.
}

// ScreencastFrameMetadata screencast frame metadata.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ScreencastFrameMetadata
type ScreencastFrameMetadata struct {
	OffsetTop       float64             `json:"offsetTop"`                    // Top offset in DIP.
	PageScaleFactor float64             `json:"pageScaleFactor"`              // Page scale factor.
	DeviceWidth     float64             `json:"deviceWidth"`                  // Device screen width in DIP.
	DeviceHeight    float64             `json:"deviceHeight"`                 // Device screen height in DIP.
	ScrollOffsetX   float64             `json:"scrollOffsetX"`                // Position of horizontal scroll in CSS pixels.
	ScrollOffsetY   float64             `json:"scrollOffsetY"`                // Position of vertical scroll in CSS pixels.
	Timestamp       *cdp.TimeSinceEpoch `json:"timestamp,omitempty,omitzero"` // Frame swap timestamp.
}

// DialogType javascript dialog type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-DialogType
type DialogType string

// String returns the DialogType as string value.
func (t DialogType) String() string {
	return string(t)
}

// DialogType values.
const (
	DialogTypeAlert        DialogType = "alert"
	DialogTypeConfirm      DialogType = "confirm"
	DialogTypePrompt       DialogType = "prompt"
	DialogTypeBeforeunload DialogType = "beforeunload"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *DialogType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch DialogType(s) {
	case DialogTypeAlert:
		*t = DialogTypeAlert
	case DialogTypeConfirm:
		*t = DialogTypeConfirm
	case DialogTypePrompt:
		*t = DialogTypePrompt
	case DialogTypeBeforeunload:
		*t = DialogTypeBeforeunload
	default:
		return fmt.Errorf("unknown DialogType value: %v", s)
	}
	return nil
}

// AppManifestError error while paring app manifest.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-AppManifestError
type AppManifestError struct {
	Message  string `json:"message"`  // Error message.
	Critical int64  `json:"critical"` // If critical, this is a non-recoverable parse error.
	Line     int64  `json:"line"`     // Error line.
	Column   int64  `json:"column"`   // Error column.
}

// AppManifestParsedProperties parsed app manifest properties.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-AppManifestParsedProperties
type AppManifestParsedProperties struct {
	Scope string `json:"scope"` // Computed scope value
}

// LayoutViewport layout viewport position and dimensions.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-LayoutViewport
type LayoutViewport struct {
	PageX        int64 `json:"pageX"`        // Horizontal offset relative to the document (CSS pixels).
	PageY        int64 `json:"pageY"`        // Vertical offset relative to the document (CSS pixels).
	ClientWidth  int64 `json:"clientWidth"`  // Width (CSS pixels), excludes scrollbar if present.
	ClientHeight int64 `json:"clientHeight"` // Height (CSS pixels), excludes scrollbar if present.
}

// VisualViewport visual viewport position, dimensions, and scale.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-VisualViewport
type VisualViewport struct {
	OffsetX      float64 `json:"offsetX"`                 // Horizontal offset relative to the layout viewport (CSS pixels).
	OffsetY      float64 `json:"offsetY"`                 // Vertical offset relative to the layout viewport (CSS pixels).
	PageX        float64 `json:"pageX"`                   // Horizontal offset relative to the document (CSS pixels).
	PageY        float64 `json:"pageY"`                   // Vertical offset relative to the document (CSS pixels).
	ClientWidth  float64 `json:"clientWidth"`             // Width (CSS pixels), excludes scrollbar if present.
	ClientHeight float64 `json:"clientHeight"`            // Height (CSS pixels), excludes scrollbar if present.
	Scale        float64 `json:"scale"`                   // Scale relative to the ideal viewport (size at width=device-width).
	Zoom         float64 `json:"zoom,omitempty,omitzero"` // Page zoom factor (CSS to device independent pixels ratio).
}

// Viewport viewport for capturing screenshot.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-Viewport
type Viewport struct {
	X      float64 `json:"x"`      // X offset in device independent pixels (dip).
	Y      float64 `json:"y"`      // Y offset in device independent pixels (dip).
	Width  float64 `json:"width"`  // Rectangle width in device independent pixels (dip).
	Height float64 `json:"height"` // Rectangle height in device independent pixels (dip).
	Scale  float64 `json:"scale"`  // Page scale factor.
}

// FontFamilies generic font families collection.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FontFamilies
type FontFamilies struct {
	Standard  string `json:"standard,omitempty,omitzero"`  // The standard font-family.
	Fixed     string `json:"fixed,omitempty,omitzero"`     // The fixed font-family.
	Serif     string `json:"serif,omitempty,omitzero"`     // The serif font-family.
	SansSerif string `json:"sansSerif,omitempty,omitzero"` // The sansSerif font-family.
	Cursive   string `json:"cursive,omitempty,omitzero"`   // The cursive font-family.
	Fantasy   string `json:"fantasy,omitempty,omitzero"`   // The fantasy font-family.
	Math      string `json:"math,omitempty,omitzero"`      // The math font-family.
}

// ScriptFontFamilies font families collection for a script.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ScriptFontFamilies
type ScriptFontFamilies struct {
	Script       string        `json:"script"`       // Name of the script which these font families are defined for.
	FontFamilies *FontFamilies `json:"fontFamilies"` // Generic font families collection for the script.
}

// FontSizes default font sizes.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FontSizes
type FontSizes struct {
	Standard int64 `json:"standard,omitempty,omitzero"` // Default standard font size.
	Fixed    int64 `json:"fixed,omitempty,omitzero"`    // Default fixed font size.
}

// ClientNavigationReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ClientNavigationReason
type ClientNavigationReason string

// String returns the ClientNavigationReason as string value.
func (t ClientNavigationReason) String() string {
	return string(t)
}

// ClientNavigationReason values.
const (
	ClientNavigationReasonAnchorClick            ClientNavigationReason = "anchorClick"
	ClientNavigationReasonFormSubmissionGet      ClientNavigationReason = "formSubmissionGet"
	ClientNavigationReasonFormSubmissionPost     ClientNavigationReason = "formSubmissionPost"
	ClientNavigationReasonHTTPHeaderRefresh      ClientNavigationReason = "httpHeaderRefresh"
	ClientNavigationReasonInitialFrameNavigation ClientNavigationReason = "initialFrameNavigation"
	ClientNavigationReasonMetaTagRefresh         ClientNavigationReason = "metaTagRefresh"
	ClientNavigationReasonOther                  ClientNavigationReason = "other"
	ClientNavigationReasonPageBlockInterstitial  ClientNavigationReason = "pageBlockInterstitial"
	ClientNavigationReasonReload                 ClientNavigationReason = "reload"
	ClientNavigationReasonScriptInitiated        ClientNavigationReason = "scriptInitiated"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ClientNavigationReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ClientNavigationReason(s) {
	case ClientNavigationReasonAnchorClick:
		*t = ClientNavigationReasonAnchorClick
	case ClientNavigationReasonFormSubmissionGet:
		*t = ClientNavigationReasonFormSubmissionGet
	case ClientNavigationReasonFormSubmissionPost:
		*t = ClientNavigationReasonFormSubmissionPost
	case ClientNavigationReasonHTTPHeaderRefresh:
		*t = ClientNavigationReasonHTTPHeaderRefresh
	case ClientNavigationReasonInitialFrameNavigation:
		*t = ClientNavigationReasonInitialFrameNavigation
	case ClientNavigationReasonMetaTagRefresh:
		*t = ClientNavigationReasonMetaTagRefresh
	case ClientNavigationReasonOther:
		*t = ClientNavigationReasonOther
	case ClientNavigationReasonPageBlockInterstitial:
		*t = ClientNavigationReasonPageBlockInterstitial
	case ClientNavigationReasonReload:
		*t = ClientNavigationReasonReload
	case ClientNavigationReasonScriptInitiated:
		*t = ClientNavigationReasonScriptInitiated
	default:
		return fmt.Errorf("unknown ClientNavigationReason value: %v", s)
	}
	return nil
}

// ClientNavigationDisposition [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ClientNavigationDisposition
type ClientNavigationDisposition string

// String returns the ClientNavigationDisposition as string value.
func (t ClientNavigationDisposition) String() string {
	return string(t)
}

// ClientNavigationDisposition values.
const (
	ClientNavigationDispositionCurrentTab ClientNavigationDisposition = "currentTab"
	ClientNavigationDispositionNewTab     ClientNavigationDisposition = "newTab"
	ClientNavigationDispositionNewWindow  ClientNavigationDisposition = "newWindow"
	ClientNavigationDispositionDownload   ClientNavigationDisposition = "download"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ClientNavigationDisposition) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ClientNavigationDisposition(s) {
	case ClientNavigationDispositionCurrentTab:
		*t = ClientNavigationDispositionCurrentTab
	case ClientNavigationDispositionNewTab:
		*t = ClientNavigationDispositionNewTab
	case ClientNavigationDispositionNewWindow:
		*t = ClientNavigationDispositionNewWindow
	case ClientNavigationDispositionDownload:
		*t = ClientNavigationDispositionDownload
	default:
		return fmt.Errorf("unknown ClientNavigationDisposition value: %v", s)
	}
	return nil
}

// InstallabilityErrorArgument [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-InstallabilityErrorArgument
type InstallabilityErrorArgument struct {
	Name  string `json:"name"`  // Argument name (e.g. name:'minimum-icon-size-in-pixels').
	Value string `json:"value"` // Argument value (e.g. value:'64').
}

// InstallabilityError the installability error.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-InstallabilityError
type InstallabilityError struct {
	ErrorID        string                         `json:"errorId"`        // The error id (e.g. 'manifest-missing-suitable-icon').
	ErrorArguments []*InstallabilityErrorArgument `json:"errorArguments"` // The list of error arguments (e.g. {name:'minimum-icon-size-in-pixels', value:'64'}).
}

// ReferrerPolicy the referring-policy used for the navigation.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ReferrerPolicy
type ReferrerPolicy string

// String returns the ReferrerPolicy as string value.
func (t ReferrerPolicy) String() string {
	return string(t)
}

// ReferrerPolicy values.
const (
	ReferrerPolicyNoReferrer                  ReferrerPolicy = "noReferrer"
	ReferrerPolicyNoReferrerWhenDowngrade     ReferrerPolicy = "noReferrerWhenDowngrade"
	ReferrerPolicyOrigin                      ReferrerPolicy = "origin"
	ReferrerPolicyOriginWhenCrossOrigin       ReferrerPolicy = "originWhenCrossOrigin"
	ReferrerPolicySameOrigin                  ReferrerPolicy = "sameOrigin"
	ReferrerPolicyStrictOrigin                ReferrerPolicy = "strictOrigin"
	ReferrerPolicyStrictOriginWhenCrossOrigin ReferrerPolicy = "strictOriginWhenCrossOrigin"
	ReferrerPolicyUnsafeURL                   ReferrerPolicy = "unsafeUrl"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ReferrerPolicy) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ReferrerPolicy(s) {
	case ReferrerPolicyNoReferrer:
		*t = ReferrerPolicyNoReferrer
	case ReferrerPolicyNoReferrerWhenDowngrade:
		*t = ReferrerPolicyNoReferrerWhenDowngrade
	case ReferrerPolicyOrigin:
		*t = ReferrerPolicyOrigin
	case ReferrerPolicyOriginWhenCrossOrigin:
		*t = ReferrerPolicyOriginWhenCrossOrigin
	case ReferrerPolicySameOrigin:
		*t = ReferrerPolicySameOrigin
	case ReferrerPolicyStrictOrigin:
		*t = ReferrerPolicyStrictOrigin
	case ReferrerPolicyStrictOriginWhenCrossOrigin:
		*t = ReferrerPolicyStrictOriginWhenCrossOrigin
	case ReferrerPolicyUnsafeURL:
		*t = ReferrerPolicyUnsafeURL
	default:
		return fmt.Errorf("unknown ReferrerPolicy value: %v", s)
	}
	return nil
}

// CompilationCacheParams per-script compilation cache parameters for
// Page.produceCompilationCache.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-CompilationCacheParams
type CompilationCacheParams struct {
	URL   string `json:"url"`   // The URL of the script to produce a compilation cache entry for.
	Eager bool   `json:"eager"` // A hint to the backend whether eager compilation is recommended. (the actual compilation mode used is upon backend discretion).
}

// FileFilter [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FileFilter
type FileFilter struct {
	Name    string   `json:"name,omitempty,omitzero"`
	Accepts []string `json:"accepts,omitempty,omitzero"`
}

// FileHandler [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FileHandler
type FileHandler struct {
	Action     string           `json:"action"`
	Name       string           `json:"name"`
	Icons      []*ImageResource `json:"icons,omitempty,omitzero"`
	Accepts    []*FileFilter    `json:"accepts,omitempty,omitzero"` // Mimic a map, name is the key, accepts is the value.
	LaunchType string           `json:"launchType"`                 // Won't repeat the enums, using string for easy comparison. Same as the other enums below.
}

// ImageResource the image definition used in both icon and screenshot.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ImageResource
type ImageResource struct {
	URL   string `json:"url"` // The src field in the definition, but changing to url in favor of consistency.
	Sizes string `json:"sizes,omitempty,omitzero"`
	Type  string `json:"type,omitempty,omitzero"`
}

// LaunchHandler [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-LaunchHandler
type LaunchHandler struct {
	ClientMode string `json:"clientMode"`
}

// ProtocolHandler [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ProtocolHandler
type ProtocolHandler struct {
	Protocol string `json:"protocol"`
	URL      string `json:"url"`
}

// RelatedApplication [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-RelatedApplication
type RelatedApplication struct {
	ID  string `json:"id,omitempty,omitzero"`
	URL string `json:"url"`
}

// ScopeExtension [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ScopeExtension
type ScopeExtension struct {
	Origin            string `json:"origin"` // Instead of using tuple, this field always returns the serialized string for easy understanding and comparison.
	HasOriginWildcard bool   `json:"hasOriginWildcard"`
}

// Screenshot [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-Screenshot
type Screenshot struct {
	Image      *ImageResource `json:"image"`
	FormFactor string         `json:"formFactor"`
	Label      string         `json:"label,omitempty,omitzero"`
}

// ShareTarget [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ShareTarget
type ShareTarget struct {
	Action  string        `json:"action"`
	Method  string        `json:"method"`
	Enctype string        `json:"enctype"`
	Title   string        `json:"title,omitempty,omitzero"` // Embed the ShareTargetParams
	Text    string        `json:"text,omitempty,omitzero"`
	URL     string        `json:"url,omitempty,omitzero"`
	Files   []*FileFilter `json:"files,omitempty,omitzero"`
}

// Shortcut [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-Shortcut
type Shortcut struct {
	Name string `json:"name"`
	URL  string `json:"url"`
}

// WebAppManifest [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-WebAppManifest
type WebAppManifest struct {
	BackgroundColor           string                `json:"backgroundColor,omitempty,omitzero"`
	Description               string                `json:"description,omitempty,omitzero"` // The extra description provided by the manifest.
	Dir                       string                `json:"dir,omitempty,omitzero"`
	Display                   string                `json:"display,omitempty,omitzero"`
	DisplayOverrides          []string              `json:"displayOverrides,omitempty,omitzero"` // The overrided display mode controlled by the user.
	FileHandlers              []*FileHandler        `json:"fileHandlers,omitempty,omitzero"`     // The handlers to open files.
	Icons                     []*ImageResource      `json:"icons,omitempty,omitzero"`
	ID                        string                `json:"id,omitempty,omitzero"`
	Lang                      string                `json:"lang,omitempty,omitzero"`
	LaunchHandler             *LaunchHandler        `json:"launchHandler,omitempty,omitzero"` // TODO(crbug.com/1231886): This field is non-standard and part of a Chrome experiment. See: https://github.com/WICG/web-app-launch/blob/main/launch_handler.md
	Name                      string                `json:"name,omitempty,omitzero"`
	Orientation               string                `json:"orientation,omitempty,omitzero"`
	PreferRelatedApplications bool                  `json:"preferRelatedApplications"`
	ProtocolHandlers          []*ProtocolHandler    `json:"protocolHandlers,omitempty,omitzero"` // The handlers to open protocols.
	RelatedApplications       []*RelatedApplication `json:"relatedApplications,omitempty,omitzero"`
	Scope                     string                `json:"scope,omitempty,omitzero"`
	ScopeExtensions           []*ScopeExtension     `json:"scopeExtensions,omitempty,omitzero"` // Non-standard, see https://github.com/WICG/manifest-incubations/blob/gh-pages/scope_extensions-explainer.md
	Screenshots               []*Screenshot         `json:"screenshots,omitempty,omitzero"`     // The screenshots used by chromium.
	ShareTarget               *ShareTarget          `json:"shareTarget,omitempty,omitzero"`
	ShortName                 string                `json:"shortName,omitempty,omitzero"`
	Shortcuts                 []*Shortcut           `json:"shortcuts,omitempty,omitzero"`
	StartURL                  string                `json:"startUrl,omitempty,omitzero"`
	ThemeColor                string                `json:"themeColor,omitempty,omitzero"`
}

// AutoResponseMode enum of possible auto-response for permission / prompt
// dialogs.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-AutoResponseMode
type AutoResponseMode string

// String returns the AutoResponseMode as string value.
func (t AutoResponseMode) String() string {
	return string(t)
}

// AutoResponseMode values.
const (
	AutoResponseModeNone       AutoResponseMode = "none"
	AutoResponseModeAutoAccept AutoResponseMode = "autoAccept"
	AutoResponseModeAutoReject AutoResponseMode = "autoReject"
	AutoResponseModeAutoOptOut AutoResponseMode = "autoOptOut"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AutoResponseMode) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AutoResponseMode(s) {
	case AutoResponseModeNone:
		*t = AutoResponseModeNone
	case AutoResponseModeAutoAccept:
		*t = AutoResponseModeAutoAccept
	case AutoResponseModeAutoReject:
		*t = AutoResponseModeAutoReject
	case AutoResponseModeAutoOptOut:
		*t = AutoResponseModeAutoOptOut
	default:
		return fmt.Errorf("unknown AutoResponseMode value: %v", s)
	}
	return nil
}

// NavigationType the type of a frameNavigated event.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-NavigationType
type NavigationType string

// String returns the NavigationType as string value.
func (t NavigationType) String() string {
	return string(t)
}

// NavigationType values.
const (
	NavigationTypeNavigation              NavigationType = "Navigation"
	NavigationTypeBackForwardCacheRestore NavigationType = "BackForwardCacheRestore"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *NavigationType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch NavigationType(s) {
	case NavigationTypeNavigation:
		*t = NavigationTypeNavigation
	case NavigationTypeBackForwardCacheRestore:
		*t = NavigationTypeBackForwardCacheRestore
	default:
		return fmt.Errorf("unknown NavigationType value: %v", s)
	}
	return nil
}

// BackForwardCacheNotRestoredReason list of not restored reasons for
// back-forward cache.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-BackForwardCacheNotRestoredReason
type BackForwardCacheNotRestoredReason string

// String returns the BackForwardCacheNotRestoredReason as string value.
func (t BackForwardCacheNotRestoredReason) String() string {
	return string(t)
}

// BackForwardCacheNotRestoredReason values.
const (
	BackForwardCacheNotRestoredReasonNotPrimaryMainFrame                                      BackForwardCacheNotRestoredReason = "NotPrimaryMainFrame"
	BackForwardCacheNotRestoredReasonBackForwardCacheDisabled                                 BackForwardCacheNotRestoredReason = "BackForwardCacheDisabled"
	BackForwardCacheNotRestoredReasonRelatedActiveContentsExist                               BackForwardCacheNotRestoredReason = "RelatedActiveContentsExist"
	BackForwardCacheNotRestoredReasonHTTPSTatusNotOK                                          BackForwardCacheNotRestoredReason = "HTTPStatusNotOK"
	BackForwardCacheNotRestoredReasonSchemeNotHTTPOrHTTPS                                     BackForwardCacheNotRestoredReason = "SchemeNotHTTPOrHTTPS"
	BackForwardCacheNotRestoredReasonLoading                                                  BackForwardCacheNotRestoredReason = "Loading"
	BackForwardCacheNotRestoredReasonWasGrantedMediaAccess                                    BackForwardCacheNotRestoredReason = "WasGrantedMediaAccess"
	BackForwardCacheNotRestoredReasonDisableForRenderFrameHostCalled                          BackForwardCacheNotRestoredReason = "DisableForRenderFrameHostCalled"
	BackForwardCacheNotRestoredReasonDomainNotAllowed                                         BackForwardCacheNotRestoredReason = "DomainNotAllowed"
	BackForwardCacheNotRestoredReasonHTTPMethodNotGET                                         BackForwardCacheNotRestoredReason = "HTTPMethodNotGET"
	BackForwardCacheNotRestoredReasonSubframeIsNavigating                                     BackForwardCacheNotRestoredReason = "SubframeIsNavigating"
	BackForwardCacheNotRestoredReasonTimeout                                                  BackForwardCacheNotRestoredReason = "Timeout"
	BackForwardCacheNotRestoredReasonCacheLimit                                               BackForwardCacheNotRestoredReason = "CacheLimit"
	BackForwardCacheNotRestoredReasonJavaScriptExecution                                      BackForwardCacheNotRestoredReason = "JavaScriptExecution"
	BackForwardCacheNotRestoredReasonRendererProcessKilled                                    BackForwardCacheNotRestoredReason = "RendererProcessKilled"
	BackForwardCacheNotRestoredReasonRendererProcessCrashed                                   BackForwardCacheNotRestoredReason = "RendererProcessCrashed"
	BackForwardCacheNotRestoredReasonSchedulerTrackedFeatureUsed                              BackForwardCacheNotRestoredReason = "SchedulerTrackedFeatureUsed"
	BackForwardCacheNotRestoredReasonConflictingBrowsingInstance                              BackForwardCacheNotRestoredReason = "ConflictingBrowsingInstance"
	BackForwardCacheNotRestoredReasonCacheFlushed                                             BackForwardCacheNotRestoredReason = "CacheFlushed"
	BackForwardCacheNotRestoredReasonServiceWorkerVersionActivation                           BackForwardCacheNotRestoredReason = "ServiceWorkerVersionActivation"
	BackForwardCacheNotRestoredReasonSessionRestored                                          BackForwardCacheNotRestoredReason = "SessionRestored"
	BackForwardCacheNotRestoredReasonServiceWorkerPostMessage                                 BackForwardCacheNotRestoredReason = "ServiceWorkerPostMessage"
	BackForwardCacheNotRestoredReasonEnteredBackForwardCacheBeforeServiceWorkerHostAdded      BackForwardCacheNotRestoredReason = "EnteredBackForwardCacheBeforeServiceWorkerHostAdded"
	BackForwardCacheNotRestoredReasonRenderFrameHostReusedSameSite                            BackForwardCacheNotRestoredReason = "RenderFrameHostReused_SameSite"
	BackForwardCacheNotRestoredReasonRenderFrameHostReusedCrossSite                           BackForwardCacheNotRestoredReason = "RenderFrameHostReused_CrossSite"
	BackForwardCacheNotRestoredReasonServiceWorkerClaim                                       BackForwardCacheNotRestoredReason = "ServiceWorkerClaim"
	BackForwardCacheNotRestoredReasonIgnoreEventAndEvict                                      BackForwardCacheNotRestoredReason = "IgnoreEventAndEvict"
	BackForwardCacheNotRestoredReasonHaveInnerContents                                        BackForwardCacheNotRestoredReason = "HaveInnerContents"
	BackForwardCacheNotRestoredReasonTimeoutPuttingInCache                                    BackForwardCacheNotRestoredReason = "TimeoutPuttingInCache"
	BackForwardCacheNotRestoredReasonBackForwardCacheDisabledByLowMemory                      BackForwardCacheNotRestoredReason = "BackForwardCacheDisabledByLowMemory"
	BackForwardCacheNotRestoredReasonBackForwardCacheDisabledByCommandLine                    BackForwardCacheNotRestoredReason = "BackForwardCacheDisabledByCommandLine"
	BackForwardCacheNotRestoredReasonNetworkRequestDatapipeDrainedAsBytesConsumer             BackForwardCacheNotRestoredReason = "NetworkRequestDatapipeDrainedAsBytesConsumer"
	BackForwardCacheNotRestoredReasonNetworkRequestRedirected                                 BackForwardCacheNotRestoredReason = "NetworkRequestRedirected"
	BackForwardCacheNotRestoredReasonNetworkRequestTimeout                                    BackForwardCacheNotRestoredReason = "NetworkRequestTimeout"
	BackForwardCacheNotRestoredReasonNetworkExceedsBufferLimit                                BackForwardCacheNotRestoredReason = "NetworkExceedsBufferLimit"
	BackForwardCacheNotRestoredReasonNavigationCancelledWhileRestoring                        BackForwardCacheNotRestoredReason = "NavigationCancelledWhileRestoring"
	BackForwardCacheNotRestoredReasonNotMostRecentNavigationEntry                             BackForwardCacheNotRestoredReason = "NotMostRecentNavigationEntry"
	BackForwardCacheNotRestoredReasonBackForwardCacheDisabledForPrerender                     BackForwardCacheNotRestoredReason = "BackForwardCacheDisabledForPrerender"
	BackForwardCacheNotRestoredReasonUserAgentOverrideDiffers                                 BackForwardCacheNotRestoredReason = "UserAgentOverrideDiffers"
	BackForwardCacheNotRestoredReasonForegroundCacheLimit                                     BackForwardCacheNotRestoredReason = "ForegroundCacheLimit"
	BackForwardCacheNotRestoredReasonBrowsingInstanceNotSwapped                               BackForwardCacheNotRestoredReason = "BrowsingInstanceNotSwapped"
	BackForwardCacheNotRestoredReasonBackForwardCacheDisabledForDelegate                      BackForwardCacheNotRestoredReason = "BackForwardCacheDisabledForDelegate"
	BackForwardCacheNotRestoredReasonUnloadHandlerExistsInMainFrame                           BackForwardCacheNotRestoredReason = "UnloadHandlerExistsInMainFrame"
	BackForwardCacheNotRestoredReasonUnloadHandlerExistsInSubFrame                            BackForwardCacheNotRestoredReason = "UnloadHandlerExistsInSubFrame"
	BackForwardCacheNotRestoredReasonServiceWorkerUnregistration                              BackForwardCacheNotRestoredReason = "ServiceWorkerUnregistration"
	BackForwardCacheNotRestoredReasonCacheControlNoStore                                      BackForwardCacheNotRestoredReason = "CacheControlNoStore"
	BackForwardCacheNotRestoredReasonCacheControlNoStoreCookieModified                        BackForwardCacheNotRestoredReason = "CacheControlNoStoreCookieModified"
	BackForwardCacheNotRestoredReasonCacheControlNoStoreHTTPOnlyCookieModified                BackForwardCacheNotRestoredReason = "CacheControlNoStoreHTTPOnlyCookieModified"
	BackForwardCacheNotRestoredReasonNoResponseHead                                           BackForwardCacheNotRestoredReason = "NoResponseHead"
	BackForwardCacheNotRestoredReasonUnknown                                                  BackForwardCacheNotRestoredReason = "Unknown"
	BackForwardCacheNotRestoredReasonActivationNavigationsDisallowedForBug1234857             BackForwardCacheNotRestoredReason = "ActivationNavigationsDisallowedForBug1234857"
	BackForwardCacheNotRestoredReasonErrorDocument                                            BackForwardCacheNotRestoredReason = "ErrorDocument"
	BackForwardCacheNotRestoredReasonFencedFramesEmbedder                                     BackForwardCacheNotRestoredReason = "FencedFramesEmbedder"
	BackForwardCacheNotRestoredReasonCookieDisabled                                           BackForwardCacheNotRestoredReason = "CookieDisabled"
	BackForwardCacheNotRestoredReasonHTTPAuthRequired                                         BackForwardCacheNotRestoredReason = "HTTPAuthRequired"
	BackForwardCacheNotRestoredReasonCookieFlushed                                            BackForwardCacheNotRestoredReason = "CookieFlushed"
	BackForwardCacheNotRestoredReasonBroadcastChannelOnMessage                                BackForwardCacheNotRestoredReason = "BroadcastChannelOnMessage"
	BackForwardCacheNotRestoredReasonWebViewSettingsChanged                                   BackForwardCacheNotRestoredReason = "WebViewSettingsChanged"
	BackForwardCacheNotRestoredReasonWebViewJavaScriptObjectChanged                           BackForwardCacheNotRestoredReason = "WebViewJavaScriptObjectChanged"
	BackForwardCacheNotRestoredReasonWebViewMessageListenerInjected                           BackForwardCacheNotRestoredReason = "WebViewMessageListenerInjected"
	BackForwardCacheNotRestoredReasonWebViewSafeBrowsingAllowlistChanged                      BackForwardCacheNotRestoredReason = "WebViewSafeBrowsingAllowlistChanged"
	BackForwardCacheNotRestoredReasonWebViewDocumentStartJavascriptChanged                    BackForwardCacheNotRestoredReason = "WebViewDocumentStartJavascriptChanged"
	BackForwardCacheNotRestoredReasonWebSocket                                                BackForwardCacheNotRestoredReason = "WebSocket"
	BackForwardCacheNotRestoredReasonWebTransport                                             BackForwardCacheNotRestoredReason = "WebTransport"
	BackForwardCacheNotRestoredReasonWebRTC                                                   BackForwardCacheNotRestoredReason = "WebRTC"
	BackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoStore                       BackForwardCacheNotRestoredReason = "MainResourceHasCacheControlNoStore"
	BackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoCache                       BackForwardCacheNotRestoredReason = "MainResourceHasCacheControlNoCache"
	BackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoStore                        BackForwardCacheNotRestoredReason = "SubresourceHasCacheControlNoStore"
	BackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoCache                        BackForwardCacheNotRestoredReason = "SubresourceHasCacheControlNoCache"
	BackForwardCacheNotRestoredReasonContainsPlugins                                          BackForwardCacheNotRestoredReason = "ContainsPlugins"
	BackForwardCacheNotRestoredReasonDocumentLoaded                                           BackForwardCacheNotRestoredReason = "DocumentLoaded"
	BackForwardCacheNotRestoredReasonOutstandingNetworkRequestOthers                          BackForwardCacheNotRestoredReason = "OutstandingNetworkRequestOthers"
	BackForwardCacheNotRestoredReasonRequestedMIDIPermission                                  BackForwardCacheNotRestoredReason = "RequestedMIDIPermission"
	BackForwardCacheNotRestoredReasonRequestedAudioCapturePermission                          BackForwardCacheNotRestoredReason = "RequestedAudioCapturePermission"
	BackForwardCacheNotRestoredReasonRequestedVideoCapturePermission                          BackForwardCacheNotRestoredReason = "RequestedVideoCapturePermission"
	BackForwardCacheNotRestoredReasonRequestedBackForwardCacheBlockedSensors                  BackForwardCacheNotRestoredReason = "RequestedBackForwardCacheBlockedSensors"
	BackForwardCacheNotRestoredReasonRequestedBackgroundWorkPermission                        BackForwardCacheNotRestoredReason = "RequestedBackgroundWorkPermission"
	BackForwardCacheNotRestoredReasonBroadcastChannel                                         BackForwardCacheNotRestoredReason = "BroadcastChannel"
	BackForwardCacheNotRestoredReasonWebXR                                                    BackForwardCacheNotRestoredReason = "WebXR"
	BackForwardCacheNotRestoredReasonSharedWorker                                             BackForwardCacheNotRestoredReason = "SharedWorker"
	BackForwardCacheNotRestoredReasonWebLocks                                                 BackForwardCacheNotRestoredReason = "WebLocks"
	BackForwardCacheNotRestoredReasonWebHID                                                   BackForwardCacheNotRestoredReason = "WebHID"
	BackForwardCacheNotRestoredReasonWebShare                                                 BackForwardCacheNotRestoredReason = "WebShare"
	BackForwardCacheNotRestoredReasonRequestedStorageAccessGrant                              BackForwardCacheNotRestoredReason = "RequestedStorageAccessGrant"
	BackForwardCacheNotRestoredReasonWebNfc                                                   BackForwardCacheNotRestoredReason = "WebNfc"
	BackForwardCacheNotRestoredReasonOutstandingNetworkRequestFetch                           BackForwardCacheNotRestoredReason = "OutstandingNetworkRequestFetch"
	BackForwardCacheNotRestoredReasonOutstandingNetworkRequestXHR                             BackForwardCacheNotRestoredReason = "OutstandingNetworkRequestXHR"
	BackForwardCacheNotRestoredReasonAppBanner                                                BackForwardCacheNotRestoredReason = "AppBanner"
	BackForwardCacheNotRestoredReasonPrinting                                                 BackForwardCacheNotRestoredReason = "Printing"
	BackForwardCacheNotRestoredReasonWebDatabase                                              BackForwardCacheNotRestoredReason = "WebDatabase"
	BackForwardCacheNotRestoredReasonPictureInPicture                                         BackForwardCacheNotRestoredReason = "PictureInPicture"
	BackForwardCacheNotRestoredReasonSpeechRecognizer                                         BackForwardCacheNotRestoredReason = "SpeechRecognizer"
	BackForwardCacheNotRestoredReasonIdleManager                                              BackForwardCacheNotRestoredReason = "IdleManager"
	BackForwardCacheNotRestoredReasonPaymentManager                                           BackForwardCacheNotRestoredReason = "PaymentManager"
	BackForwardCacheNotRestoredReasonSpeechSynthesis                                          BackForwardCacheNotRestoredReason = "SpeechSynthesis"
	BackForwardCacheNotRestoredReasonKeyboardLock                                             BackForwardCacheNotRestoredReason = "KeyboardLock"
	BackForwardCacheNotRestoredReasonWebOTPService                                            BackForwardCacheNotRestoredReason = "WebOTPService"
	BackForwardCacheNotRestoredReasonOutstandingNetworkRequestDirectSocket                    BackForwardCacheNotRestoredReason = "OutstandingNetworkRequestDirectSocket"
	BackForwardCacheNotRestoredReasonInjectedJavascript                                       BackForwardCacheNotRestoredReason = "InjectedJavascript"
	BackForwardCacheNotRestoredReasonInjectedStyleSheet                                       BackForwardCacheNotRestoredReason = "InjectedStyleSheet"
	BackForwardCacheNotRestoredReasonKeepaliveRequest                                         BackForwardCacheNotRestoredReason = "KeepaliveRequest"
	BackForwardCacheNotRestoredReasonIndexedDBEvent                                           BackForwardCacheNotRestoredReason = "IndexedDBEvent"
	BackForwardCacheNotRestoredReasonDummy                                                    BackForwardCacheNotRestoredReason = "Dummy"
	BackForwardCacheNotRestoredReasonJsNetworkRequestReceivedCacheControlNoStoreResource      BackForwardCacheNotRestoredReason = "JsNetworkRequestReceivedCacheControlNoStoreResource"
	BackForwardCacheNotRestoredReasonWebRTCSticky                                             BackForwardCacheNotRestoredReason = "WebRTCSticky"
	BackForwardCacheNotRestoredReasonWebTransportSticky                                       BackForwardCacheNotRestoredReason = "WebTransportSticky"
	BackForwardCacheNotRestoredReasonWebSocketSticky                                          BackForwardCacheNotRestoredReason = "WebSocketSticky"
	BackForwardCacheNotRestoredReasonSmartCard                                                BackForwardCacheNotRestoredReason = "SmartCard"
	BackForwardCacheNotRestoredReasonLiveMediaStreamTrack                                     BackForwardCacheNotRestoredReason = "LiveMediaStreamTrack"
	BackForwardCacheNotRestoredReasonUnloadHandler                                            BackForwardCacheNotRestoredReason = "UnloadHandler"
	BackForwardCacheNotRestoredReasonParserAborted                                            BackForwardCacheNotRestoredReason = "ParserAborted"
	BackForwardCacheNotRestoredReasonContentSecurityHandler                                   BackForwardCacheNotRestoredReason = "ContentSecurityHandler"
	BackForwardCacheNotRestoredReasonContentWebAuthenticationAPI                              BackForwardCacheNotRestoredReason = "ContentWebAuthenticationAPI"
	BackForwardCacheNotRestoredReasonContentFileChooser                                       BackForwardCacheNotRestoredReason = "ContentFileChooser"
	BackForwardCacheNotRestoredReasonContentSerial                                            BackForwardCacheNotRestoredReason = "ContentSerial"
	BackForwardCacheNotRestoredReasonContentFileSystemAccess                                  BackForwardCacheNotRestoredReason = "ContentFileSystemAccess"
	BackForwardCacheNotRestoredReasonContentMediaDevicesDispatcherHost                        BackForwardCacheNotRestoredReason = "ContentMediaDevicesDispatcherHost"
	BackForwardCacheNotRestoredReasonContentWebBluetooth                                      BackForwardCacheNotRestoredReason = "ContentWebBluetooth"
	BackForwardCacheNotRestoredReasonContentWebUSB                                            BackForwardCacheNotRestoredReason = "ContentWebUSB"
	BackForwardCacheNotRestoredReasonContentMediaSessionService                               BackForwardCacheNotRestoredReason = "ContentMediaSessionService"
	BackForwardCacheNotRestoredReasonContentScreenReader                                      BackForwardCacheNotRestoredReason = "ContentScreenReader"
	BackForwardCacheNotRestoredReasonContentDiscarded                                         BackForwardCacheNotRestoredReason = "ContentDiscarded"
	BackForwardCacheNotRestoredReasonEmbedderPopupBlockerTabHelper                            BackForwardCacheNotRestoredReason = "EmbedderPopupBlockerTabHelper"
	BackForwardCacheNotRestoredReasonEmbedderSafeBrowsingTriggeredPopupBlocker                BackForwardCacheNotRestoredReason = "EmbedderSafeBrowsingTriggeredPopupBlocker"
	BackForwardCacheNotRestoredReasonEmbedderSafeBrowsingThreatDetails                        BackForwardCacheNotRestoredReason = "EmbedderSafeBrowsingThreatDetails"
	BackForwardCacheNotRestoredReasonEmbedderAppBannerManager                                 BackForwardCacheNotRestoredReason = "EmbedderAppBannerManager"
	BackForwardCacheNotRestoredReasonEmbedderDomDistillerViewerSource                         BackForwardCacheNotRestoredReason = "EmbedderDomDistillerViewerSource"
	BackForwardCacheNotRestoredReasonEmbedderDomDistillerSelfDeletingRequestDelegate          BackForwardCacheNotRestoredReason = "EmbedderDomDistillerSelfDeletingRequestDelegate"
	BackForwardCacheNotRestoredReasonEmbedderOomInterventionTabHelper                         BackForwardCacheNotRestoredReason = "EmbedderOomInterventionTabHelper"
	BackForwardCacheNotRestoredReasonEmbedderOfflinePage                                      BackForwardCacheNotRestoredReason = "EmbedderOfflinePage"
	BackForwardCacheNotRestoredReasonEmbedderChromePasswordManagerClientBindCredentialManager BackForwardCacheNotRestoredReason = "EmbedderChromePasswordManagerClientBindCredentialManager"
	BackForwardCacheNotRestoredReasonEmbedderPermissionRequestManager                         BackForwardCacheNotRestoredReason = "EmbedderPermissionRequestManager"
	BackForwardCacheNotRestoredReasonEmbedderModalDialog                                      BackForwardCacheNotRestoredReason = "EmbedderModalDialog"
	BackForwardCacheNotRestoredReasonEmbedderExtensions                                       BackForwardCacheNotRestoredReason = "EmbedderExtensions"
	BackForwardCacheNotRestoredReasonEmbedderExtensionMessaging                               BackForwardCacheNotRestoredReason = "EmbedderExtensionMessaging"
	BackForwardCacheNotRestoredReasonEmbedderExtensionMessagingForOpenPort                    BackForwardCacheNotRestoredReason = "EmbedderExtensionMessagingForOpenPort"
	BackForwardCacheNotRestoredReasonEmbedderExtensionSentMessageToCachedFrame                BackForwardCacheNotRestoredReason = "EmbedderExtensionSentMessageToCachedFrame"
	BackForwardCacheNotRestoredReasonRequestedByWebViewClient                                 BackForwardCacheNotRestoredReason = "RequestedByWebViewClient"
	BackForwardCacheNotRestoredReasonPostMessageByWebViewClient                               BackForwardCacheNotRestoredReason = "PostMessageByWebViewClient"
	BackForwardCacheNotRestoredReasonCacheControlNoStoreDeviceBoundSessionTerminated          BackForwardCacheNotRestoredReason = "CacheControlNoStoreDeviceBoundSessionTerminated"
	BackForwardCacheNotRestoredReasonCacheLimitPruned                                         BackForwardCacheNotRestoredReason = "CacheLimitPruned"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *BackForwardCacheNotRestoredReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch BackForwardCacheNotRestoredReason(s) {
	case BackForwardCacheNotRestoredReasonNotPrimaryMainFrame:
		*t = BackForwardCacheNotRestoredReasonNotPrimaryMainFrame
	case BackForwardCacheNotRestoredReasonBackForwardCacheDisabled:
		*t = BackForwardCacheNotRestoredReasonBackForwardCacheDisabled
	case BackForwardCacheNotRestoredReasonRelatedActiveContentsExist:
		*t = BackForwardCacheNotRestoredReasonRelatedActiveContentsExist
	case BackForwardCacheNotRestoredReasonHTTPSTatusNotOK:
		*t = BackForwardCacheNotRestoredReasonHTTPSTatusNotOK
	case BackForwardCacheNotRestoredReasonSchemeNotHTTPOrHTTPS:
		*t = BackForwardCacheNotRestoredReasonSchemeNotHTTPOrHTTPS
	case BackForwardCacheNotRestoredReasonLoading:
		*t = BackForwardCacheNotRestoredReasonLoading
	case BackForwardCacheNotRestoredReasonWasGrantedMediaAccess:
		*t = BackForwardCacheNotRestoredReasonWasGrantedMediaAccess
	case BackForwardCacheNotRestoredReasonDisableForRenderFrameHostCalled:
		*t = BackForwardCacheNotRestoredReasonDisableForRenderFrameHostCalled
	case BackForwardCacheNotRestoredReasonDomainNotAllowed:
		*t = BackForwardCacheNotRestoredReasonDomainNotAllowed
	case BackForwardCacheNotRestoredReasonHTTPMethodNotGET:
		*t = BackForwardCacheNotRestoredReasonHTTPMethodNotGET
	case BackForwardCacheNotRestoredReasonSubframeIsNavigating:
		*t = BackForwardCacheNotRestoredReasonSubframeIsNavigating
	case BackForwardCacheNotRestoredReasonTimeout:
		*t = BackForwardCacheNotRestoredReasonTimeout
	case BackForwardCacheNotRestoredReasonCacheLimit:
		*t = BackForwardCacheNotRestoredReasonCacheLimit
	case BackForwardCacheNotRestoredReasonJavaScriptExecution:
		*t = BackForwardCacheNotRestoredReasonJavaScriptExecution
	case BackForwardCacheNotRestoredReasonRendererProcessKilled:
		*t = BackForwardCacheNotRestoredReasonRendererProcessKilled
	case BackForwardCacheNotRestoredReasonRendererProcessCrashed:
		*t = BackForwardCacheNotRestoredReasonRendererProcessCrashed
	case BackForwardCacheNotRestoredReasonSchedulerTrackedFeatureUsed:
		*t = BackForwardCacheNotRestoredReasonSchedulerTrackedFeatureUsed
	case BackForwardCacheNotRestoredReasonConflictingBrowsingInstance:
		*t = BackForwardCacheNotRestoredReasonConflictingBrowsingInstance
	case BackForwardCacheNotRestoredReasonCacheFlushed:
		*t = BackForwardCacheNotRestoredReasonCacheFlushed
	case BackForwardCacheNotRestoredReasonServiceWorkerVersionActivation:
		*t = BackForwardCacheNotRestoredReasonServiceWorkerVersionActivation
	case BackForwardCacheNotRestoredReasonSessionRestored:
		*t = BackForwardCacheNotRestoredReasonSessionRestored
	case BackForwardCacheNotRestoredReasonServiceWorkerPostMessage:
		*t = BackForwardCacheNotRestoredReasonServiceWorkerPostMessage
	case BackForwardCacheNotRestoredReasonEnteredBackForwardCacheBeforeServiceWorkerHostAdded:
		*t = BackForwardCacheNotRestoredReasonEnteredBackForwardCacheBeforeServiceWorkerHostAdded
	case BackForwardCacheNotRestoredReasonRenderFrameHostReusedSameSite:
		*t = BackForwardCacheNotRestoredReasonRenderFrameHostReusedSameSite
	case BackForwardCacheNotRestoredReasonRenderFrameHostReusedCrossSite:
		*t = BackForwardCacheNotRestoredReasonRenderFrameHostReusedCrossSite
	case BackForwardCacheNotRestoredReasonServiceWorkerClaim:
		*t = BackForwardCacheNotRestoredReasonServiceWorkerClaim
	case BackForwardCacheNotRestoredReasonIgnoreEventAndEvict:
		*t = BackForwardCacheNotRestoredReasonIgnoreEventAndEvict
	case BackForwardCacheNotRestoredReasonHaveInnerContents:
		*t = BackForwardCacheNotRestoredReasonHaveInnerContents
	case BackForwardCacheNotRestoredReasonTimeoutPuttingInCache:
		*t = BackForwardCacheNotRestoredReasonTimeoutPuttingInCache
	case BackForwardCacheNotRestoredReasonBackForwardCacheDisabledByLowMemory:
		*t = BackForwardCacheNotRestoredReasonBackForwardCacheDisabledByLowMemory
	case BackForwardCacheNotRestoredReasonBackForwardCacheDisabledByCommandLine:
		*t = BackForwardCacheNotRestoredReasonBackForwardCacheDisabledByCommandLine
	case BackForwardCacheNotRestoredReasonNetworkRequestDatapipeDrainedAsBytesConsumer:
		*t = BackForwardCacheNotRestoredReasonNetworkRequestDatapipeDrainedAsBytesConsumer
	case BackForwardCacheNotRestoredReasonNetworkRequestRedirected:
		*t = BackForwardCacheNotRestoredReasonNetworkRequestRedirected
	case BackForwardCacheNotRestoredReasonNetworkRequestTimeout:
		*t = BackForwardCacheNotRestoredReasonNetworkRequestTimeout
	case BackForwardCacheNotRestoredReasonNetworkExceedsBufferLimit:
		*t = BackForwardCacheNotRestoredReasonNetworkExceedsBufferLimit
	case BackForwardCacheNotRestoredReasonNavigationCancelledWhileRestoring:
		*t = BackForwardCacheNotRestoredReasonNavigationCancelledWhileRestoring
	case BackForwardCacheNotRestoredReasonNotMostRecentNavigationEntry:
		*t = BackForwardCacheNotRestoredReasonNotMostRecentNavigationEntry
	case BackForwardCacheNotRestoredReasonBackForwardCacheDisabledForPrerender:
		*t = BackForwardCacheNotRestoredReasonBackForwardCacheDisabledForPrerender
	case BackForwardCacheNotRestoredReasonUserAgentOverrideDiffers:
		*t = BackForwardCacheNotRestoredReasonUserAgentOverrideDiffers
	case BackForwardCacheNotRestoredReasonForegroundCacheLimit:
		*t = BackForwardCacheNotRestoredReasonForegroundCacheLimit
	case BackForwardCacheNotRestoredReasonBrowsingInstanceNotSwapped:
		*t = BackForwardCacheNotRestoredReasonBrowsingInstanceNotSwapped
	case BackForwardCacheNotRestoredReasonBackForwardCacheDisabledForDelegate:
		*t = BackForwardCacheNotRestoredReasonBackForwardCacheDisabledForDelegate
	case BackForwardCacheNotRestoredReasonUnloadHandlerExistsInMainFrame:
		*t = BackForwardCacheNotRestoredReasonUnloadHandlerExistsInMainFrame
	case BackForwardCacheNotRestoredReasonUnloadHandlerExistsInSubFrame:
		*t = BackForwardCacheNotRestoredReasonUnloadHandlerExistsInSubFrame
	case BackForwardCacheNotRestoredReasonServiceWorkerUnregistration:
		*t = BackForwardCacheNotRestoredReasonServiceWorkerUnregistration
	case BackForwardCacheNotRestoredReasonCacheControlNoStore:
		*t = BackForwardCacheNotRestoredReasonCacheControlNoStore
	case BackForwardCacheNotRestoredReasonCacheControlNoStoreCookieModified:
		*t = BackForwardCacheNotRestoredReasonCacheControlNoStoreCookieModified
	case BackForwardCacheNotRestoredReasonCacheControlNoStoreHTTPOnlyCookieModified:
		*t = BackForwardCacheNotRestoredReasonCacheControlNoStoreHTTPOnlyCookieModified
	case BackForwardCacheNotRestoredReasonNoResponseHead:
		*t = BackForwardCacheNotRestoredReasonNoResponseHead
	case BackForwardCacheNotRestoredReasonUnknown:
		*t = BackForwardCacheNotRestoredReasonUnknown
	case BackForwardCacheNotRestoredReasonActivationNavigationsDisallowedForBug1234857:
		*t = BackForwardCacheNotRestoredReasonActivationNavigationsDisallowedForBug1234857
	case BackForwardCacheNotRestoredReasonErrorDocument:
		*t = BackForwardCacheNotRestoredReasonErrorDocument
	case BackForwardCacheNotRestoredReasonFencedFramesEmbedder:
		*t = BackForwardCacheNotRestoredReasonFencedFramesEmbedder
	case BackForwardCacheNotRestoredReasonCookieDisabled:
		*t = BackForwardCacheNotRestoredReasonCookieDisabled
	case BackForwardCacheNotRestoredReasonHTTPAuthRequired:
		*t = BackForwardCacheNotRestoredReasonHTTPAuthRequired
	case BackForwardCacheNotRestoredReasonCookieFlushed:
		*t = BackForwardCacheNotRestoredReasonCookieFlushed
	case BackForwardCacheNotRestoredReasonBroadcastChannelOnMessage:
		*t = BackForwardCacheNotRestoredReasonBroadcastChannelOnMessage
	case BackForwardCacheNotRestoredReasonWebViewSettingsChanged:
		*t = BackForwardCacheNotRestoredReasonWebViewSettingsChanged
	case BackForwardCacheNotRestoredReasonWebViewJavaScriptObjectChanged:
		*t = BackForwardCacheNotRestoredReasonWebViewJavaScriptObjectChanged
	case BackForwardCacheNotRestoredReasonWebViewMessageListenerInjected:
		*t = BackForwardCacheNotRestoredReasonWebViewMessageListenerInjected
	case BackForwardCacheNotRestoredReasonWebViewSafeBrowsingAllowlistChanged:
		*t = BackForwardCacheNotRestoredReasonWebViewSafeBrowsingAllowlistChanged
	case BackForwardCacheNotRestoredReasonWebViewDocumentStartJavascriptChanged:
		*t = BackForwardCacheNotRestoredReasonWebViewDocumentStartJavascriptChanged
	case BackForwardCacheNotRestoredReasonWebSocket:
		*t = BackForwardCacheNotRestoredReasonWebSocket
	case BackForwardCacheNotRestoredReasonWebTransport:
		*t = BackForwardCacheNotRestoredReasonWebTransport
	case BackForwardCacheNotRestoredReasonWebRTC:
		*t = BackForwardCacheNotRestoredReasonWebRTC
	case BackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoStore:
		*t = BackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoStore
	case BackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoCache:
		*t = BackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoCache
	case BackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoStore:
		*t = BackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoStore
	case BackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoCache:
		*t = BackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoCache
	case BackForwardCacheNotRestoredReasonContainsPlugins:
		*t = BackForwardCacheNotRestoredReasonContainsPlugins
	case BackForwardCacheNotRestoredReasonDocumentLoaded:
		*t = BackForwardCacheNotRestoredReasonDocumentLoaded
	case BackForwardCacheNotRestoredReasonOutstandingNetworkRequestOthers:
		*t = BackForwardCacheNotRestoredReasonOutstandingNetworkRequestOthers
	case BackForwardCacheNotRestoredReasonRequestedMIDIPermission:
		*t = BackForwardCacheNotRestoredReasonRequestedMIDIPermission
	case BackForwardCacheNotRestoredReasonRequestedAudioCapturePermission:
		*t = BackForwardCacheNotRestoredReasonRequestedAudioCapturePermission
	case BackForwardCacheNotRestoredReasonRequestedVideoCapturePermission:
		*t = BackForwardCacheNotRestoredReasonRequestedVideoCapturePermission
	case BackForwardCacheNotRestoredReasonRequestedBackForwardCacheBlockedSensors:
		*t = BackForwardCacheNotRestoredReasonRequestedBackForwardCacheBlockedSensors
	case BackForwardCacheNotRestoredReasonRequestedBackgroundWorkPermission:
		*t = BackForwardCacheNotRestoredReasonRequestedBackgroundWorkPermission
	case BackForwardCacheNotRestoredReasonBroadcastChannel:
		*t = BackForwardCacheNotRestoredReasonBroadcastChannel
	case BackForwardCacheNotRestoredReasonWebXR:
		*t = BackForwardCacheNotRestoredReasonWebXR
	case BackForwardCacheNotRestoredReasonSharedWorker:
		*t = BackForwardCacheNotRestoredReasonSharedWorker
	case BackForwardCacheNotRestoredReasonWebLocks:
		*t = BackForwardCacheNotRestoredReasonWebLocks
	case BackForwardCacheNotRestoredReasonWebHID:
		*t = BackForwardCacheNotRestoredReasonWebHID
	case BackForwardCacheNotRestoredReasonWebShare:
		*t = BackForwardCacheNotRestoredReasonWebShare
	case BackForwardCacheNotRestoredReasonRequestedStorageAccessGrant:
		*t = BackForwardCacheNotRestoredReasonRequestedStorageAccessGrant
	case BackForwardCacheNotRestoredReasonWebNfc:
		*t = BackForwardCacheNotRestoredReasonWebNfc
	case BackForwardCacheNotRestoredReasonOutstandingNetworkRequestFetch:
		*t = BackForwardCacheNotRestoredReasonOutstandingNetworkRequestFetch
	case BackForwardCacheNotRestoredReasonOutstandingNetworkRequestXHR:
		*t = BackForwardCacheNotRestoredReasonOutstandingNetworkRequestXHR
	case BackForwardCacheNotRestoredReasonAppBanner:
		*t = BackForwardCacheNotRestoredReasonAppBanner
	case BackForwardCacheNotRestoredReasonPrinting:
		*t = BackForwardCacheNotRestoredReasonPrinting
	case BackForwardCacheNotRestoredReasonWebDatabase:
		*t = BackForwardCacheNotRestoredReasonWebDatabase
	case BackForwardCacheNotRestoredReasonPictureInPicture:
		*t = BackForwardCacheNotRestoredReasonPictureInPicture
	case BackForwardCacheNotRestoredReasonSpeechRecognizer:
		*t = BackForwardCacheNotRestoredReasonSpeechRecognizer
	case BackForwardCacheNotRestoredReasonIdleManager:
		*t = BackForwardCacheNotRestoredReasonIdleManager
	case BackForwardCacheNotRestoredReasonPaymentManager:
		*t = BackForwardCacheNotRestoredReasonPaymentManager
	case BackForwardCacheNotRestoredReasonSpeechSynthesis:
		*t = BackForwardCacheNotRestoredReasonSpeechSynthesis
	case BackForwardCacheNotRestoredReasonKeyboardLock:
		*t = BackForwardCacheNotRestoredReasonKeyboardLock
	case BackForwardCacheNotRestoredReasonWebOTPService:
		*t = BackForwardCacheNotRestoredReasonWebOTPService
	case BackForwardCacheNotRestoredReasonOutstandingNetworkRequestDirectSocket:
		*t = BackForwardCacheNotRestoredReasonOutstandingNetworkRequestDirectSocket
	case BackForwardCacheNotRestoredReasonInjectedJavascript:
		*t = BackForwardCacheNotRestoredReasonInjectedJavascript
	case BackForwardCacheNotRestoredReasonInjectedStyleSheet:
		*t = BackForwardCacheNotRestoredReasonInjectedStyleSheet
	case BackForwardCacheNotRestoredReasonKeepaliveRequest:
		*t = BackForwardCacheNotRestoredReasonKeepaliveRequest
	case BackForwardCacheNotRestoredReasonIndexedDBEvent:
		*t = BackForwardCacheNotRestoredReasonIndexedDBEvent
	case BackForwardCacheNotRestoredReasonDummy:
		*t = BackForwardCacheNotRestoredReasonDummy
	case BackForwardCacheNotRestoredReasonJsNetworkRequestReceivedCacheControlNoStoreResource:
		*t = BackForwardCacheNotRestoredReasonJsNetworkRequestReceivedCacheControlNoStoreResource
	case BackForwardCacheNotRestoredReasonWebRTCSticky:
		*t = BackForwardCacheNotRestoredReasonWebRTCSticky
	case BackForwardCacheNotRestoredReasonWebTransportSticky:
		*t = BackForwardCacheNotRestoredReasonWebTransportSticky
	case BackForwardCacheNotRestoredReasonWebSocketSticky:
		*t = BackForwardCacheNotRestoredReasonWebSocketSticky
	case BackForwardCacheNotRestoredReasonSmartCard:
		*t = BackForwardCacheNotRestoredReasonSmartCard
	case BackForwardCacheNotRestoredReasonLiveMediaStreamTrack:
		*t = BackForwardCacheNotRestoredReasonLiveMediaStreamTrack
	case BackForwardCacheNotRestoredReasonUnloadHandler:
		*t = BackForwardCacheNotRestoredReasonUnloadHandler
	case BackForwardCacheNotRestoredReasonParserAborted:
		*t = BackForwardCacheNotRestoredReasonParserAborted
	case BackForwardCacheNotRestoredReasonContentSecurityHandler:
		*t = BackForwardCacheNotRestoredReasonContentSecurityHandler
	case BackForwardCacheNotRestoredReasonContentWebAuthenticationAPI:
		*t = BackForwardCacheNotRestoredReasonContentWebAuthenticationAPI
	case BackForwardCacheNotRestoredReasonContentFileChooser:
		*t = BackForwardCacheNotRestoredReasonContentFileChooser
	case BackForwardCacheNotRestoredReasonContentSerial:
		*t = BackForwardCacheNotRestoredReasonContentSerial
	case BackForwardCacheNotRestoredReasonContentFileSystemAccess:
		*t = BackForwardCacheNotRestoredReasonContentFileSystemAccess
	case BackForwardCacheNotRestoredReasonContentMediaDevicesDispatcherHost:
		*t = BackForwardCacheNotRestoredReasonContentMediaDevicesDispatcherHost
	case BackForwardCacheNotRestoredReasonContentWebBluetooth:
		*t = BackForwardCacheNotRestoredReasonContentWebBluetooth
	case BackForwardCacheNotRestoredReasonContentWebUSB:
		*t = BackForwardCacheNotRestoredReasonContentWebUSB
	case BackForwardCacheNotRestoredReasonContentMediaSessionService:
		*t = BackForwardCacheNotRestoredReasonContentMediaSessionService
	case BackForwardCacheNotRestoredReasonContentScreenReader:
		*t = BackForwardCacheNotRestoredReasonContentScreenReader
	case BackForwardCacheNotRestoredReasonContentDiscarded:
		*t = BackForwardCacheNotRestoredReasonContentDiscarded
	case BackForwardCacheNotRestoredReasonEmbedderPopupBlockerTabHelper:
		*t = BackForwardCacheNotRestoredReasonEmbedderPopupBlockerTabHelper
	case BackForwardCacheNotRestoredReasonEmbedderSafeBrowsingTriggeredPopupBlocker:
		*t = BackForwardCacheNotRestoredReasonEmbedderSafeBrowsingTriggeredPopupBlocker
	case BackForwardCacheNotRestoredReasonEmbedderSafeBrowsingThreatDetails:
		*t = BackForwardCacheNotRestoredReasonEmbedderSafeBrowsingThreatDetails
	case BackForwardCacheNotRestoredReasonEmbedderAppBannerManager:
		*t = BackForwardCacheNotRestoredReasonEmbedderAppBannerManager
	case BackForwardCacheNotRestoredReasonEmbedderDomDistillerViewerSource:
		*t = BackForwardCacheNotRestoredReasonEmbedderDomDistillerViewerSource
	case BackForwardCacheNotRestoredReasonEmbedderDomDistillerSelfDeletingRequestDelegate:
		*t = BackForwardCacheNotRestoredReasonEmbedderDomDistillerSelfDeletingRequestDelegate
	case BackForwardCacheNotRestoredReasonEmbedderOomInterventionTabHelper:
		*t = BackForwardCacheNotRestoredReasonEmbedderOomInterventionTabHelper
	case BackForwardCacheNotRestoredReasonEmbedderOfflinePage:
		*t = BackForwardCacheNotRestoredReasonEmbedderOfflinePage
	case BackForwardCacheNotRestoredReasonEmbedderChromePasswordManagerClientBindCredentialManager:
		*t = BackForwardCacheNotRestoredReasonEmbedderChromePasswordManagerClientBindCredentialManager
	case BackForwardCacheNotRestoredReasonEmbedderPermissionRequestManager:
		*t = BackForwardCacheNotRestoredReasonEmbedderPermissionRequestManager
	case BackForwardCacheNotRestoredReasonEmbedderModalDialog:
		*t = BackForwardCacheNotRestoredReasonEmbedderModalDialog
	case BackForwardCacheNotRestoredReasonEmbedderExtensions:
		*t = BackForwardCacheNotRestoredReasonEmbedderExtensions
	case BackForwardCacheNotRestoredReasonEmbedderExtensionMessaging:
		*t = BackForwardCacheNotRestoredReasonEmbedderExtensionMessaging
	case BackForwardCacheNotRestoredReasonEmbedderExtensionMessagingForOpenPort:
		*t = BackForwardCacheNotRestoredReasonEmbedderExtensionMessagingForOpenPort
	case BackForwardCacheNotRestoredReasonEmbedderExtensionSentMessageToCachedFrame:
		*t = BackForwardCacheNotRestoredReasonEmbedderExtensionSentMessageToCachedFrame
	case BackForwardCacheNotRestoredReasonRequestedByWebViewClient:
		*t = BackForwardCacheNotRestoredReasonRequestedByWebViewClient
	case BackForwardCacheNotRestoredReasonPostMessageByWebViewClient:
		*t = BackForwardCacheNotRestoredReasonPostMessageByWebViewClient
	case BackForwardCacheNotRestoredReasonCacheControlNoStoreDeviceBoundSessionTerminated:
		*t = BackForwardCacheNotRestoredReasonCacheControlNoStoreDeviceBoundSessionTerminated
	case BackForwardCacheNotRestoredReasonCacheLimitPruned:
		*t = BackForwardCacheNotRestoredReasonCacheLimitPruned
	default:
		return fmt.Errorf("unknown BackForwardCacheNotRestoredReason value: %v", s)
	}
	return nil
}

// BackForwardCacheNotRestoredReasonType types of not restored reasons for
// back-forward cache.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-BackForwardCacheNotRestoredReasonType
type BackForwardCacheNotRestoredReasonType string

// String returns the BackForwardCacheNotRestoredReasonType as string value.
func (t BackForwardCacheNotRestoredReasonType) String() string {
	return string(t)
}

// BackForwardCacheNotRestoredReasonType values.
const (
	BackForwardCacheNotRestoredReasonTypeSupportPending    BackForwardCacheNotRestoredReasonType = "SupportPending"
	BackForwardCacheNotRestoredReasonTypePageSupportNeeded BackForwardCacheNotRestoredReasonType = "PageSupportNeeded"
	BackForwardCacheNotRestoredReasonTypeCircumstantial    BackForwardCacheNotRestoredReasonType = "Circumstantial"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *BackForwardCacheNotRestoredReasonType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch BackForwardCacheNotRestoredReasonType(s) {
	case BackForwardCacheNotRestoredReasonTypeSupportPending:
		*t = BackForwardCacheNotRestoredReasonTypeSupportPending
	case BackForwardCacheNotRestoredReasonTypePageSupportNeeded:
		*t = BackForwardCacheNotRestoredReasonTypePageSupportNeeded
	case BackForwardCacheNotRestoredReasonTypeCircumstantial:
		*t = BackForwardCacheNotRestoredReasonTypeCircumstantial
	default:
		return fmt.Errorf("unknown BackForwardCacheNotRestoredReasonType value: %v", s)
	}
	return nil
}

// BackForwardCacheBlockingDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-BackForwardCacheBlockingDetails
type BackForwardCacheBlockingDetails struct {
	URL          string `json:"url,omitempty,omitzero"`      // Url of the file where blockage happened. Optional because of tests.
	Function     string `json:"function,omitempty,omitzero"` // Function name where blockage happened. Optional because of anonymous functions and tests.
	LineNumber   int64  `json:"lineNumber"`                  // Line number in the script (0-based).
	ColumnNumber int64  `json:"columnNumber"`                // Column number in the script (0-based).
}

// BackForwardCacheNotRestoredExplanation [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-BackForwardCacheNotRestoredExplanation
type BackForwardCacheNotRestoredExplanation struct {
	Type    BackForwardCacheNotRestoredReasonType `json:"type"`                       // Type of the reason
	Reason  BackForwardCacheNotRestoredReason     `json:"reason"`                     // Not restored reason
	Context string                                `json:"context,omitempty,omitzero"` // Context associated with the reason. The meaning of this context is dependent on the reason: - EmbedderExtensionSentMessageToCachedFrame: the extension ID.
	Details []*BackForwardCacheBlockingDetails    `json:"details,omitempty,omitzero"`
}

// BackForwardCacheNotRestoredExplanationTree [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-BackForwardCacheNotRestoredExplanationTree
type BackForwardCacheNotRestoredExplanationTree struct {
	URL          string                                        `json:"url"`          // URL of each frame
	Explanations []*BackForwardCacheNotRestoredExplanation     `json:"explanations"` // Not restored reasons of each frame
	Children     []*BackForwardCacheNotRestoredExplanationTree `json:"children"`     // Array of children frame
}

// FileChooserOpenedMode input mode.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#event-fileChooserOpened
type FileChooserOpenedMode string

// String returns the FileChooserOpenedMode as string value.
func (t FileChooserOpenedMode) String() string {
	return string(t)
}

// FileChooserOpenedMode values.
const (
	FileChooserOpenedModeSelectSingle   FileChooserOpenedMode = "selectSingle"
	FileChooserOpenedModeSelectMultiple FileChooserOpenedMode = "selectMultiple"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *FileChooserOpenedMode) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch FileChooserOpenedMode(s) {
	case FileChooserOpenedModeSelectSingle:
		*t = FileChooserOpenedModeSelectSingle
	case FileChooserOpenedModeSelectMultiple:
		*t = FileChooserOpenedModeSelectMultiple
	default:
		return fmt.Errorf("unknown FileChooserOpenedMode value: %v", s)
	}
	return nil
}

// FrameDetachedReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#event-frameDetached
type FrameDetachedReason string

// String returns the FrameDetachedReason as string value.
func (t FrameDetachedReason) String() string {
	return string(t)
}

// FrameDetachedReason values.
const (
	FrameDetachedReasonRemove FrameDetachedReason = "remove"
	FrameDetachedReasonSwap   FrameDetachedReason = "swap"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *FrameDetachedReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch FrameDetachedReason(s) {
	case FrameDetachedReasonRemove:
		*t = FrameDetachedReasonRemove
	case FrameDetachedReasonSwap:
		*t = FrameDetachedReasonSwap
	default:
		return fmt.Errorf("unknown FrameDetachedReason value: %v", s)
	}
	return nil
}

// FrameStartedNavigatingNavigationType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#event-frameStartedNavigating
type FrameStartedNavigatingNavigationType string

// String returns the FrameStartedNavigatingNavigationType as string value.
func (t FrameStartedNavigatingNavigationType) String() string {
	return string(t)
}

// FrameStartedNavigatingNavigationType values.
const (
	FrameStartedNavigatingNavigationTypeReload                   FrameStartedNavigatingNavigationType = "reload"
	FrameStartedNavigatingNavigationTypeReloadBypassingCache     FrameStartedNavigatingNavigationType = "reloadBypassingCache"
	FrameStartedNavigatingNavigationTypeRestore                  FrameStartedNavigatingNavigationType = "restore"
	FrameStartedNavigatingNavigationTypeRestoreWithPost          FrameStartedNavigatingNavigationType = "restoreWithPost"
	FrameStartedNavigatingNavigationTypeHistorySameDocument      FrameStartedNavigatingNavigationType = "historySameDocument"
	FrameStartedNavigatingNavigationTypeHistoryDifferentDocument FrameStartedNavigatingNavigationType = "historyDifferentDocument"
	FrameStartedNavigatingNavigationTypeSameDocument             FrameStartedNavigatingNavigationType = "sameDocument"
	FrameStartedNavigatingNavigationTypeDifferentDocument        FrameStartedNavigatingNavigationType = "differentDocument"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *FrameStartedNavigatingNavigationType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch FrameStartedNavigatingNavigationType(s) {
	case FrameStartedNavigatingNavigationTypeReload:
		*t = FrameStartedNavigatingNavigationTypeReload
	case FrameStartedNavigatingNavigationTypeReloadBypassingCache:
		*t = FrameStartedNavigatingNavigationTypeReloadBypassingCache
	case FrameStartedNavigatingNavigationTypeRestore:
		*t = FrameStartedNavigatingNavigationTypeRestore
	case FrameStartedNavigatingNavigationTypeRestoreWithPost:
		*t = FrameStartedNavigatingNavigationTypeRestoreWithPost
	case FrameStartedNavigatingNavigationTypeHistorySameDocument:
		*t = FrameStartedNavigatingNavigationTypeHistorySameDocument
	case FrameStartedNavigatingNavigationTypeHistoryDifferentDocument:
		*t = FrameStartedNavigatingNavigationTypeHistoryDifferentDocument
	case FrameStartedNavigatingNavigationTypeSameDocument:
		*t = FrameStartedNavigatingNavigationTypeSameDocument
	case FrameStartedNavigatingNavigationTypeDifferentDocument:
		*t = FrameStartedNavigatingNavigationTypeDifferentDocument
	default:
		return fmt.Errorf("unknown FrameStartedNavigatingNavigationType value: %v", s)
	}
	return nil
}

// NavigatedWithinDocumentNavigationType navigation type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#event-navigatedWithinDocument
type NavigatedWithinDocumentNavigationType string

// String returns the NavigatedWithinDocumentNavigationType as string value.
func (t NavigatedWithinDocumentNavigationType) String() string {
	return string(t)
}

// NavigatedWithinDocumentNavigationType values.
const (
	NavigatedWithinDocumentNavigationTypeFragment   NavigatedWithinDocumentNavigationType = "fragment"
	NavigatedWithinDocumentNavigationTypeHistoryAPI NavigatedWithinDocumentNavigationType = "historyApi"
	NavigatedWithinDocumentNavigationTypeOther      NavigatedWithinDocumentNavigationType = "other"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *NavigatedWithinDocumentNavigationType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch NavigatedWithinDocumentNavigationType(s) {
	case NavigatedWithinDocumentNavigationTypeFragment:
		*t = NavigatedWithinDocumentNavigationTypeFragment
	case NavigatedWithinDocumentNavigationTypeHistoryAPI:
		*t = NavigatedWithinDocumentNavigationTypeHistoryAPI
	case NavigatedWithinDocumentNavigationTypeOther:
		*t = NavigatedWithinDocumentNavigationTypeOther
	default:
		return fmt.Errorf("unknown NavigatedWithinDocumentNavigationType value: %v", s)
	}
	return nil
}

// CaptureScreenshotFormat image compression format (defaults to png).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-captureScreenshot
type CaptureScreenshotFormat string

// String returns the CaptureScreenshotFormat as string value.
func (t CaptureScreenshotFormat) String() string {
	return string(t)
}

// CaptureScreenshotFormat values.
const (
	CaptureScreenshotFormatJpeg CaptureScreenshotFormat = "jpeg"
	CaptureScreenshotFormatPng  CaptureScreenshotFormat = "png"
	CaptureScreenshotFormatWebp CaptureScreenshotFormat = "webp"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CaptureScreenshotFormat) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CaptureScreenshotFormat(s) {
	case CaptureScreenshotFormatJpeg:
		*t = CaptureScreenshotFormatJpeg
	case CaptureScreenshotFormatPng:
		*t = CaptureScreenshotFormatPng
	case CaptureScreenshotFormatWebp:
		*t = CaptureScreenshotFormatWebp
	default:
		return fmt.Errorf("unknown CaptureScreenshotFormat value: %v", s)
	}
	return nil
}

// CaptureSnapshotFormat format (defaults to mhtml).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-captureSnapshot
type CaptureSnapshotFormat string

// String returns the CaptureSnapshotFormat as string value.
func (t CaptureSnapshotFormat) String() string {
	return string(t)
}

// CaptureSnapshotFormat values.
const (
	CaptureSnapshotFormatMhtml CaptureSnapshotFormat = "mhtml"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CaptureSnapshotFormat) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CaptureSnapshotFormat(s) {
	case CaptureSnapshotFormatMhtml:
		*t = CaptureSnapshotFormatMhtml
	default:
		return fmt.Errorf("unknown CaptureSnapshotFormat value: %v", s)
	}
	return nil
}

// PrintToPDFTransferMode return as stream.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-printToPDF
type PrintToPDFTransferMode string

// String returns the PrintToPDFTransferMode as string value.
func (t PrintToPDFTransferMode) String() string {
	return string(t)
}

// PrintToPDFTransferMode values.
const (
	PrintToPDFTransferModeReturnAsBase64 PrintToPDFTransferMode = "ReturnAsBase64"
	PrintToPDFTransferModeReturnAsStream PrintToPDFTransferMode = "ReturnAsStream"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *PrintToPDFTransferMode) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch PrintToPDFTransferMode(s) {
	case PrintToPDFTransferModeReturnAsBase64:
		*t = PrintToPDFTransferModeReturnAsBase64
	case PrintToPDFTransferModeReturnAsStream:
		*t = PrintToPDFTransferModeReturnAsStream
	default:
		return fmt.Errorf("unknown PrintToPDFTransferMode value: %v", s)
	}
	return nil
}

// ScreencastFormat image compression format.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-startScreencast
type ScreencastFormat string

// String returns the ScreencastFormat as string value.
func (t ScreencastFormat) String() string {
	return string(t)
}

// ScreencastFormat values.
const (
	ScreencastFormatJpeg ScreencastFormat = "jpeg"
	ScreencastFormatPng  ScreencastFormat = "png"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ScreencastFormat) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ScreencastFormat(s) {
	case ScreencastFormatJpeg:
		*t = ScreencastFormatJpeg
	case ScreencastFormatPng:
		*t = ScreencastFormatPng
	default:
		return fmt.Errorf("unknown ScreencastFormat value: %v", s)
	}
	return nil
}

// SetWebLifecycleStateState target lifecycle state.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setWebLifecycleState
type SetWebLifecycleStateState string

// String returns the SetWebLifecycleStateState as string value.
func (t SetWebLifecycleStateState) String() string {
	return string(t)
}

// SetWebLifecycleStateState values.
const (
	SetWebLifecycleStateStateFrozen SetWebLifecycleStateState = "frozen"
	SetWebLifecycleStateStateActive SetWebLifecycleStateState = "active"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *SetWebLifecycleStateState) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch SetWebLifecycleStateState(s) {
	case SetWebLifecycleStateStateFrozen:
		*t = SetWebLifecycleStateStateFrozen
	case SetWebLifecycleStateStateActive:
		*t = SetWebLifecycleStateStateActive
	default:
		return fmt.Errorf("unknown SetWebLifecycleStateState value: %v", s)
	}
	return nil
}
