package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

type MalwareCount struct {

	// **参数解释**: 高危恶意代码文件数。 **取值范围**: 不涉及。
	High *int32 `json:"high,omitempty"`

	// **参数解释**: 中危恶意代码文件数。 **取值范围**: 不涉及。
	Medium *int32 `json:"medium,omitempty"`

	// **参数解释**: 低危恶意代码文件数。 **取值范围**: 不涉及。
	Low *int32 `json:"low,omitempty"`
}

func (o MalwareCount) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "MalwareCount struct{}"
	}

	return strings.Join([]string{"MalwareCount", string(data)}, " ")
}
