package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ListProjectProtectedBranchesRequest Request Object
type ListProjectProtectedBranchesRequest struct {

	// **参数解释：** 项目的32位uuid，项目唯一标识，通过[[查询项目列表](https://support.huaweicloud.com/api-projectman/ListProjectsV4.html)](tag:hws)[[查询项目列表](https://support.huaweicloud.com/intl/en-us/api-projectman/ListProjectsV4.html)](tag:hws_hk)[[查询项目列表](https://support.huaweicloud.com/eu/api-projectman/ListProjectsV4.html)](tag:hws_eu)[查询项目列表](tag:hcs,hcs_sm)接口查询项目列表获取。 **取值范围：** 字符串长度32。
	ProjectId string `json:"project_id"`

	// **参数解释：** 偏移量，从0开始。
	Offset *int32 `json:"offset,omitempty"`

	// **参数解释：** 返回数量。
	Limit *int32 `json:"limit,omitempty"`

	// **参数解释：** 保护分支名称。 **取值范围：** 字符串长度不少于1，不超过2000。
	Search *string `json:"search,omitempty"`

	// **参数解释：** 是否使用actions权限点的返回内容。 **取值范围：** 字符串长度不少于1，不超过2000。
	UserActions *bool `json:"user_actions,omitempty"`

	// **参数解释：** 参数值只有simple ，意为使用简单模式，只返回名称。 **取值范围：** 字符串长度不少于1，不超过2000。
	View *string `json:"view,omitempty"`
}

func (o ListProjectProtectedBranchesRequest) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ListProjectProtectedBranchesRequest struct{}"
	}

	return strings.Join([]string{"ListProjectProtectedBranchesRequest", string(data)}, " ")
}
