// SPDX-FileCopyrightText: 2024 Olivier Charvin <git@olivier.pfad.fr>
// SPDX-License-Identifier: CC0-1.0
package check_test

import (
	"testing"

	"code.pfad.fr/check"
)

func testExample(t *testing.T) {
	check.Equal(t, 2, 1+1) // simple equality check. Continues execution on inequality (test will fail)

	obj, err := newObj()
	check.Equal(t, nil, err).Fatal() // Fatal will stop the test on inequality (by calling t.FailNow)
	check.Equal(t, 1, len(obj.Answers)).
		Log("wrong answer size") // Log argument will only be printed on inequality

	// EqualSlice will print a unified diff on inequality
	check.EqualSlice(t, []int{42}, obj.Answers).
		Logf("question: %q", "Ultimate Question"). // Printf syntax also is also supported for Log
		Fatal()                                    // Methods can be chained

	// EqualDeep allows to compare complex structure.
	// To print a unified diff, you can use the output of go-cmp as a Log argument:
	// import "github.com/google/go-cmp/cmp"
	expectedObj := o{}
	check.EqualDeep(t, expectedObj, obj).
		Log(cmp.Diff(expectedObj, obj))
}

// ✂ -- ignore anything below this line (tricks to show the test in the documentation as an example) -- ✂
func newObj() (o, error) { return o{}, nil }
func Example()           { _ = testExample }

type o struct{ Answers []int }

var cmp = struct{ Diff func(x, y any) string }{Diff: func(x, y any) string { return "" }}
