// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateCapacityProvider = "CreateCapacityProvider"

// CreateCapacityProviderRequest generates a "aws/request.Request" representing the
// client's request for the CreateCapacityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCapacityProvider for more information on using the CreateCapacityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCapacityProviderRequest method.
//	req, resp := client.CreateCapacityProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateCapacityProvider
func (c *ECS) CreateCapacityProviderRequest(input *CreateCapacityProviderInput) (req *request.Request, output *CreateCapacityProviderOutput) {
	op := &request.Operation{
		Name:       opCreateCapacityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCapacityProviderInput{}
	}

	output = &CreateCapacityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCapacityProvider API operation for Amazon EC2 Container Service.
//
// Creates a new capacity provider. Capacity providers are associated with an
// Amazon ECS cluster and are used in capacity provider strategies to facilitate
// cluster auto scaling.
//
// Only capacity providers that use an Auto Scaling group can be created. Amazon
// ECS tasks on Fargate use the FARGATE and FARGATE_SPOT capacity providers.
// These providers are available to all accounts in the Amazon Web Services
// Regions that Fargate supports.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation CreateCapacityProvider for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - LimitExceededException
//     The limit for the resource was exceeded.
//
//   - UpdateInProgressException
//     There's already a current Amazon ECS container agent update in progress on
//     the container instance that's specified. If the container agent becomes disconnected
//     while it's in a transitional stage, such as PENDING or STAGING, the update
//     process can get stuck in that state. However, when the agent reconnects,
//     it resumes where it stopped previously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateCapacityProvider
func (c *ECS) CreateCapacityProvider(input *CreateCapacityProviderInput) (*CreateCapacityProviderOutput, error) {
	req, out := c.CreateCapacityProviderRequest(input)
	return out, req.Send()
}

// CreateCapacityProviderWithContext is the same as CreateCapacityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCapacityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) CreateCapacityProviderWithContext(ctx aws.Context, input *CreateCapacityProviderInput, opts ...request.Option) (*CreateCapacityProviderOutput, error) {
	req, out := c.CreateCapacityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateClusterRequest method.
//	req, resp := client.CreateClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateCluster
func (c *ECS) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Amazon EC2 Container Service.
//
// Creates a new Amazon ECS cluster. By default, your account receives a default
// cluster when you launch your first container instance. However, you can create
// your own cluster with a unique name with the CreateCluster action.
//
// When you call the CreateCluster API operation, Amazon ECS attempts to create
// the Amazon ECS service-linked role for your account. This is so that it can
// manage required resources in other Amazon Web Services services on your behalf.
// However, if the IAM user that makes the call doesn't have permissions to
// create the service-linked role, it isn't created. For more information, see
// Using service-linked roles for Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation CreateCluster for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateCluster
func (c *ECS) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateService = "CreateService"

// CreateServiceRequest generates a "aws/request.Request" representing the
// client's request for the CreateService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateService for more information on using the CreateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateServiceRequest method.
//	req, resp := client.CreateServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateService
func (c *ECS) CreateServiceRequest(input *CreateServiceInput) (req *request.Request, output *CreateServiceOutput) {
	op := &request.Operation{
		Name:       opCreateService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServiceInput{}
	}

	output = &CreateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateService API operation for Amazon EC2 Container Service.
//
// Runs and maintains your desired number of tasks from a specified task definition.
// If the number of tasks running in a service drops below the desiredCount,
// Amazon ECS runs another copy of the task in the specified cluster. To update
// an existing service, see the UpdateService action.
//
// In addition to maintaining the desired count of tasks in your service, you
// can optionally run your service behind one or more load balancers. The load
// balancers distribute traffic across the tasks that are associated with the
// service. For more information, see Service load balancing (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Tasks for services that don't use a load balancer are considered healthy
// if they're in the RUNNING state. Tasks for services that use a load balancer
// are considered healthy if they're in the RUNNING state and are reported as
// healthy by the load balancer.
//
// There are two service scheduler strategies available:
//
//   - REPLICA - The replica scheduling strategy places and maintains your
//     desired number of tasks across your cluster. By default, the service scheduler
//     spreads tasks across Availability Zones. You can use task placement strategies
//     and constraints to customize task placement decisions. For more information,
//     see Service scheduler concepts (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html)
//     in the Amazon Elastic Container Service Developer Guide.
//
//   - DAEMON - The daemon scheduling strategy deploys exactly one task on
//     each active container instance that meets all of the task placement constraints
//     that you specify in your cluster. The service scheduler also evaluates
//     the task placement constraints for running tasks. It also stops tasks
//     that don't meet the placement constraints. When using this strategy, you
//     don't need to specify a desired number of tasks, a task placement strategy,
//     or use Service Auto Scaling policies. For more information, see Service
//     scheduler concepts (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html)
//     in the Amazon Elastic Container Service Developer Guide.
//
// You can optionally specify a deployment configuration for your service. The
// deployment is initiated by changing properties. For example, the deployment
// might be initiated by the task definition or by your desired count of a service.
// This is done with an UpdateService operation. The default value for a replica
// service for minimumHealthyPercent is 100%. The default value for a daemon
// service for minimumHealthyPercent is 0%.
//
// If a service uses the ECS deployment controller, the minimum healthy percent
// represents a lower limit on the number of tasks in a service that must remain
// in the RUNNING state during a deployment. Specifically, it represents it
// as a percentage of your desired number of tasks (rounded up to the nearest
// integer). This happens when any of your container instances are in the DRAINING
// state if the service contains tasks using the EC2 launch type. Using this
// parameter, you can deploy without using additional cluster capacity. For
// example, if you set your service to have desired number of four tasks and
// a minimum healthy percent of 50%, the scheduler might stop two existing tasks
// to free up cluster capacity before starting two new tasks. If they're in
// the RUNNING state, tasks for services that don't use a load balancer are
// considered healthy . If they're in the RUNNING state and reported as healthy
// by the load balancer, tasks for services that do use a load balancer are
// considered healthy . The default value for minimum healthy percent is 100%.
//
// If a service uses the ECS deployment controller, the maximum percent parameter
// represents an upper limit on the number of tasks in a service that are allowed
// in the RUNNING or PENDING state during a deployment. Specifically, it represents
// it as a percentage of the desired number of tasks (rounded down to the nearest
// integer). This happens when any of your container instances are in the DRAINING
// state if the service contains tasks using the EC2 launch type. Using this
// parameter, you can define the deployment batch size. For example, if your
// service has a desired number of four tasks and a maximum percent value of
// 200%, the scheduler may start four new tasks before stopping the four older
// tasks (provided that the cluster resources required to do this are available).
// The default value for maximum percent is 200%.
//
// If a service uses either the CODE_DEPLOY or EXTERNAL deployment controller
// types and tasks that use the EC2 launch type, the minimum healthy percent
// and maximum percent values are used only to define the lower and upper limit
// on the number of the tasks in the service that remain in the RUNNING state.
// This is while the container instances are in the DRAINING state. If the tasks
// in the service use the Fargate launch type, the minimum healthy percent and
// maximum percent values aren't used. This is the case even if they're currently
// visible when describing your service.
//
// When creating a service that uses the EXTERNAL deployment controller, you
// can specify only parameters that aren't controlled at the task set level.
// The only required parameter is the service name. You control your services
// using the CreateTaskSet operation. For more information, see Amazon ECS deployment
// types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// When the service scheduler launches new tasks, it determines task placement
// in your cluster using the following logic:
//
//   - Determine which of the container instances in your cluster can support
//     the task definition of your service. For example, they have the required
//     CPU, memory, ports, and container instance attributes.
//
//   - By default, the service scheduler attempts to balance tasks across Availability
//     Zones in this manner. This is the case even if you can choose a different
//     placement strategy with the placementStrategy parameter. Sort the valid
//     container instances, giving priority to instances that have the fewest
//     number of running tasks for this service in their respective Availability
//     Zone. For example, if zone A has one running service task and zones B
//     and C each have zero, valid container instances in either zone B or C
//     are considered optimal for placement. Place the new service task on a
//     valid container instance in an optimal Availability Zone based on the
//     previous steps, favoring container instances with the fewest number of
//     running tasks for this service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation CreateService for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - UnsupportedFeatureException
//     The specified task isn't supported in this Region.
//
//   - PlatformUnknownException
//     The specified platform version doesn't exist.
//
//   - PlatformTaskDefinitionIncompatibilityException
//     The specified platform version doesn't satisfy the required capabilities
//     of the task definition.
//
//   - AccessDeniedException
//     You don't have authorization to perform the requested action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateService
func (c *ECS) CreateService(input *CreateServiceInput) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	return out, req.Send()
}

// CreateServiceWithContext is the same as CreateService with the addition of
// the ability to pass a context and additional request options.
//
// See CreateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) CreateServiceWithContext(ctx aws.Context, input *CreateServiceInput, opts ...request.Option) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTaskSet = "CreateTaskSet"

// CreateTaskSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateTaskSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTaskSet for more information on using the CreateTaskSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTaskSetRequest method.
//	req, resp := client.CreateTaskSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateTaskSet
func (c *ECS) CreateTaskSetRequest(input *CreateTaskSetInput) (req *request.Request, output *CreateTaskSetOutput) {
	op := &request.Operation{
		Name:       opCreateTaskSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTaskSetInput{}
	}

	output = &CreateTaskSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTaskSet API operation for Amazon EC2 Container Service.
//
// Create a task set in the specified cluster and service. This is used when
// a service uses the EXTERNAL deployment controller type. For more information,
// see Amazon ECS deployment types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation CreateTaskSet for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - UnsupportedFeatureException
//     The specified task isn't supported in this Region.
//
//   - PlatformUnknownException
//     The specified platform version doesn't exist.
//
//   - PlatformTaskDefinitionIncompatibilityException
//     The specified platform version doesn't satisfy the required capabilities
//     of the task definition.
//
//   - AccessDeniedException
//     You don't have authorization to perform the requested action.
//
//   - ServiceNotFoundException
//     The specified service wasn't found. You can view your available services
//     with ListServices. Amazon ECS services are cluster specific and Region specific.
//
//   - ServiceNotActiveException
//     The specified service isn't active. You can't update a service that's inactive.
//     If you have previously deleted a service, you can re-create it with CreateService.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateTaskSet
func (c *ECS) CreateTaskSet(input *CreateTaskSetInput) (*CreateTaskSetOutput, error) {
	req, out := c.CreateTaskSetRequest(input)
	return out, req.Send()
}

// CreateTaskSetWithContext is the same as CreateTaskSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTaskSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) CreateTaskSetWithContext(ctx aws.Context, input *CreateTaskSetInput, opts ...request.Option) (*CreateTaskSetOutput, error) {
	req, out := c.CreateTaskSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccountSetting = "DeleteAccountSetting"

// DeleteAccountSettingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountSetting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccountSetting for more information on using the DeleteAccountSetting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccountSettingRequest method.
//	req, resp := client.DeleteAccountSettingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAccountSetting
func (c *ECS) DeleteAccountSettingRequest(input *DeleteAccountSettingInput) (req *request.Request, output *DeleteAccountSettingOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountSetting,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccountSettingInput{}
	}

	output = &DeleteAccountSettingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAccountSetting API operation for Amazon EC2 Container Service.
//
// Disables an account setting for a specified IAM user, IAM role, or the root
// user for an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DeleteAccountSetting for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAccountSetting
func (c *ECS) DeleteAccountSetting(input *DeleteAccountSettingInput) (*DeleteAccountSettingOutput, error) {
	req, out := c.DeleteAccountSettingRequest(input)
	return out, req.Send()
}

// DeleteAccountSettingWithContext is the same as DeleteAccountSetting with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccountSetting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DeleteAccountSettingWithContext(ctx aws.Context, input *DeleteAccountSettingInput, opts ...request.Option) (*DeleteAccountSettingOutput, error) {
	req, out := c.DeleteAccountSettingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAttributes = "DeleteAttributes"

// DeleteAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAttributes for more information on using the DeleteAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAttributesRequest method.
//	req, resp := client.DeleteAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAttributes
func (c *ECS) DeleteAttributesRequest(input *DeleteAttributesInput) (req *request.Request, output *DeleteAttributesOutput) {
	op := &request.Operation{
		Name:       opDeleteAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAttributesInput{}
	}

	output = &DeleteAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAttributes API operation for Amazon EC2 Container Service.
//
// Deletes one or more custom attributes from an Amazon ECS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DeleteAttributes for usage and error information.
//
// Returned Error Types:
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - TargetNotFoundException
//     The specified target wasn't found. You can view your available container
//     instances with ListContainerInstances. Amazon ECS container instances are
//     cluster-specific and Region-specific.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAttributes
func (c *ECS) DeleteAttributes(input *DeleteAttributesInput) (*DeleteAttributesOutput, error) {
	req, out := c.DeleteAttributesRequest(input)
	return out, req.Send()
}

// DeleteAttributesWithContext is the same as DeleteAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DeleteAttributesWithContext(ctx aws.Context, input *DeleteAttributesInput, opts ...request.Option) (*DeleteAttributesOutput, error) {
	req, out := c.DeleteAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCapacityProvider = "DeleteCapacityProvider"

// DeleteCapacityProviderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCapacityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCapacityProvider for more information on using the DeleteCapacityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCapacityProviderRequest method.
//	req, resp := client.DeleteCapacityProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteCapacityProvider
func (c *ECS) DeleteCapacityProviderRequest(input *DeleteCapacityProviderInput) (req *request.Request, output *DeleteCapacityProviderOutput) {
	op := &request.Operation{
		Name:       opDeleteCapacityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCapacityProviderInput{}
	}

	output = &DeleteCapacityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCapacityProvider API operation for Amazon EC2 Container Service.
//
// Deletes the specified capacity provider.
//
// The FARGATE and FARGATE_SPOT capacity providers are reserved and can't be
// deleted. You can disassociate them from a cluster using either the PutClusterCapacityProviders
// API or by deleting the cluster.
//
// Prior to a capacity provider being deleted, the capacity provider must be
// removed from the capacity provider strategy from all services. The UpdateService
// API can be used to remove a capacity provider from a service's capacity provider
// strategy. When updating a service, the forceNewDeployment option can be used
// to ensure that any tasks using the Amazon EC2 instance capacity provided
// by the capacity provider are transitioned to use the capacity from the remaining
// capacity providers. Only capacity providers that aren't associated with a
// cluster can be deleted. To remove a capacity provider from a cluster, you
// can either use PutClusterCapacityProviders or delete the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DeleteCapacityProvider for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteCapacityProvider
func (c *ECS) DeleteCapacityProvider(input *DeleteCapacityProviderInput) (*DeleteCapacityProviderOutput, error) {
	req, out := c.DeleteCapacityProviderRequest(input)
	return out, req.Send()
}

// DeleteCapacityProviderWithContext is the same as DeleteCapacityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCapacityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DeleteCapacityProviderWithContext(ctx aws.Context, input *DeleteCapacityProviderInput, opts ...request.Option) (*DeleteCapacityProviderOutput, error) {
	req, out := c.DeleteCapacityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteClusterRequest method.
//	req, resp := client.DeleteClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteCluster
func (c *ECS) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for Amazon EC2 Container Service.
//
// Deletes the specified cluster. The cluster transitions to the INACTIVE state.
// Clusters with an INACTIVE status might remain discoverable in your account
// for a period of time. However, this behavior is subject to change in the
// future. We don't recommend that you rely on INACTIVE clusters persisting.
//
// You must deregister all container instances from this cluster before you
// may delete it. You can list the container instances in a cluster with ListContainerInstances
// and deregister them with DeregisterContainerInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - ClusterContainsContainerInstancesException
//     You can't delete a cluster that has registered container instances. First,
//     deregister the container instances before you can delete the cluster. For
//     more information, see DeregisterContainerInstance.
//
//   - ClusterContainsServicesException
//     You can't delete a cluster that contains services. First, update the service
//     to reduce its desired task count to 0, and then delete the service. For more
//     information, see UpdateService and DeleteService.
//
//   - ClusterContainsTasksException
//     You can't delete a cluster that has active tasks.
//
//   - UpdateInProgressException
//     There's already a current Amazon ECS container agent update in progress on
//     the container instance that's specified. If the container agent becomes disconnected
//     while it's in a transitional stage, such as PENDING or STAGING, the update
//     process can get stuck in that state. However, when the agent reconnects,
//     it resumes where it stopped previously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteCluster
func (c *ECS) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteService = "DeleteService"

// DeleteServiceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteService for more information on using the DeleteService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteServiceRequest method.
//	req, resp := client.DeleteServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteService
func (c *ECS) DeleteServiceRequest(input *DeleteServiceInput) (req *request.Request, output *DeleteServiceOutput) {
	op := &request.Operation{
		Name:       opDeleteService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServiceInput{}
	}

	output = &DeleteServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteService API operation for Amazon EC2 Container Service.
//
// Deletes a specified service within a cluster. You can delete a service if
// you have no running tasks in it and the desired task count is zero. If the
// service is actively maintaining tasks, you can't delete it, and you must
// update the service to a desired task count of zero. For more information,
// see UpdateService.
//
// When you delete a service, if there are still running tasks that require
// cleanup, the service status moves from ACTIVE to DRAINING, and the service
// is no longer visible in the console or in the ListServices API operation.
// After all tasks have transitioned to either STOPPING or STOPPED status, the
// service status moves from DRAINING to INACTIVE. Services in the DRAINING
// or INACTIVE status can still be viewed with the DescribeServices API operation.
// However, in the future, INACTIVE services may be cleaned up and purged from
// Amazon ECS record keeping, and DescribeServices calls on those services return
// a ServiceNotFoundException error.
//
// If you attempt to create a new service with the same name as an existing
// service in either ACTIVE or DRAINING status, you receive an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DeleteService for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - ServiceNotFoundException
//     The specified service wasn't found. You can view your available services
//     with ListServices. Amazon ECS services are cluster specific and Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteService
func (c *ECS) DeleteService(input *DeleteServiceInput) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	return out, req.Send()
}

// DeleteServiceWithContext is the same as DeleteService with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DeleteServiceWithContext(ctx aws.Context, input *DeleteServiceInput, opts ...request.Option) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTaskSet = "DeleteTaskSet"

// DeleteTaskSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTaskSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTaskSet for more information on using the DeleteTaskSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTaskSetRequest method.
//	req, resp := client.DeleteTaskSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteTaskSet
func (c *ECS) DeleteTaskSetRequest(input *DeleteTaskSetInput) (req *request.Request, output *DeleteTaskSetOutput) {
	op := &request.Operation{
		Name:       opDeleteTaskSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTaskSetInput{}
	}

	output = &DeleteTaskSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTaskSet API operation for Amazon EC2 Container Service.
//
// Deletes a specified task set within a service. This is used when a service
// uses the EXTERNAL deployment controller type. For more information, see Amazon
// ECS deployment types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DeleteTaskSet for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - UnsupportedFeatureException
//     The specified task isn't supported in this Region.
//
//   - AccessDeniedException
//     You don't have authorization to perform the requested action.
//
//   - ServiceNotFoundException
//     The specified service wasn't found. You can view your available services
//     with ListServices. Amazon ECS services are cluster specific and Region specific.
//
//   - ServiceNotActiveException
//     The specified service isn't active. You can't update a service that's inactive.
//     If you have previously deleted a service, you can re-create it with CreateService.
//
//   - TaskSetNotFoundException
//     The specified task set wasn't found. You can view your available task sets
//     with DescribeTaskSets. Task sets are specific to each cluster, service and
//     Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteTaskSet
func (c *ECS) DeleteTaskSet(input *DeleteTaskSetInput) (*DeleteTaskSetOutput, error) {
	req, out := c.DeleteTaskSetRequest(input)
	return out, req.Send()
}

// DeleteTaskSetWithContext is the same as DeleteTaskSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTaskSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DeleteTaskSetWithContext(ctx aws.Context, input *DeleteTaskSetInput, opts ...request.Option) (*DeleteTaskSetOutput, error) {
	req, out := c.DeleteTaskSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterContainerInstance = "DeregisterContainerInstance"

// DeregisterContainerInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterContainerInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterContainerInstance for more information on using the DeregisterContainerInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterContainerInstanceRequest method.
//	req, resp := client.DeregisterContainerInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeregisterContainerInstance
func (c *ECS) DeregisterContainerInstanceRequest(input *DeregisterContainerInstanceInput) (req *request.Request, output *DeregisterContainerInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterContainerInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterContainerInstanceInput{}
	}

	output = &DeregisterContainerInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterContainerInstance API operation for Amazon EC2 Container Service.
//
// Deregisters an Amazon ECS container instance from the specified cluster.
// This instance is no longer available to run tasks.
//
// If you intend to use the container instance for some other purpose after
// deregistration, we recommend that you stop all of the tasks running on the
// container instance before deregistration. That prevents any orphaned tasks
// from consuming resources.
//
// Deregistering a container instance removes the instance from a cluster, but
// it doesn't terminate the EC2 instance. If you are finished using the instance,
// be sure to terminate it in the Amazon EC2 console to stop billing.
//
// If you terminate a running container instance, Amazon ECS automatically deregisters
// the instance from your cluster (stopped container instances or instances
// with disconnected agents aren't automatically deregistered when terminated).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DeregisterContainerInstance for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeregisterContainerInstance
func (c *ECS) DeregisterContainerInstance(input *DeregisterContainerInstanceInput) (*DeregisterContainerInstanceOutput, error) {
	req, out := c.DeregisterContainerInstanceRequest(input)
	return out, req.Send()
}

// DeregisterContainerInstanceWithContext is the same as DeregisterContainerInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterContainerInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DeregisterContainerInstanceWithContext(ctx aws.Context, input *DeregisterContainerInstanceInput, opts ...request.Option) (*DeregisterContainerInstanceOutput, error) {
	req, out := c.DeregisterContainerInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterTaskDefinition = "DeregisterTaskDefinition"

// DeregisterTaskDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterTaskDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterTaskDefinition for more information on using the DeregisterTaskDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterTaskDefinitionRequest method.
//	req, resp := client.DeregisterTaskDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeregisterTaskDefinition
func (c *ECS) DeregisterTaskDefinitionRequest(input *DeregisterTaskDefinitionInput) (req *request.Request, output *DeregisterTaskDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeregisterTaskDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTaskDefinitionInput{}
	}

	output = &DeregisterTaskDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterTaskDefinition API operation for Amazon EC2 Container Service.
//
// Deregisters the specified task definition by family and revision. Upon deregistration,
// the task definition is marked as INACTIVE. Existing tasks and services that
// reference an INACTIVE task definition continue to run without disruption.
// Existing services that reference an INACTIVE task definition can still scale
// up or down by modifying the service's desired count.
//
// You can't use an INACTIVE task definition to run new tasks or create new
// services, and you can't update an existing service to reference an INACTIVE
// task definition. However, there may be up to a 10-minute window following
// deregistration where these restrictions have not yet taken effect.
//
// At this time, INACTIVE task definitions remain discoverable in your account
// indefinitely. However, this behavior is subject to change in the future.
// We don't recommend that you rely on INACTIVE task definitions persisting
// beyond the lifecycle of any associated tasks and services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DeregisterTaskDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeregisterTaskDefinition
func (c *ECS) DeregisterTaskDefinition(input *DeregisterTaskDefinitionInput) (*DeregisterTaskDefinitionOutput, error) {
	req, out := c.DeregisterTaskDefinitionRequest(input)
	return out, req.Send()
}

// DeregisterTaskDefinitionWithContext is the same as DeregisterTaskDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterTaskDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DeregisterTaskDefinitionWithContext(ctx aws.Context, input *DeregisterTaskDefinitionInput, opts ...request.Option) (*DeregisterTaskDefinitionOutput, error) {
	req, out := c.DeregisterTaskDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCapacityProviders = "DescribeCapacityProviders"

// DescribeCapacityProvidersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCapacityProviders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCapacityProviders for more information on using the DescribeCapacityProviders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCapacityProvidersRequest method.
//	req, resp := client.DescribeCapacityProvidersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeCapacityProviders
func (c *ECS) DescribeCapacityProvidersRequest(input *DescribeCapacityProvidersInput) (req *request.Request, output *DescribeCapacityProvidersOutput) {
	op := &request.Operation{
		Name:       opDescribeCapacityProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCapacityProvidersInput{}
	}

	output = &DescribeCapacityProvidersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCapacityProviders API operation for Amazon EC2 Container Service.
//
// Describes one or more of your capacity providers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DescribeCapacityProviders for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeCapacityProviders
func (c *ECS) DescribeCapacityProviders(input *DescribeCapacityProvidersInput) (*DescribeCapacityProvidersOutput, error) {
	req, out := c.DescribeCapacityProvidersRequest(input)
	return out, req.Send()
}

// DescribeCapacityProvidersWithContext is the same as DescribeCapacityProviders with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCapacityProviders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DescribeCapacityProvidersWithContext(ctx aws.Context, input *DescribeCapacityProvidersInput, opts ...request.Option) (*DescribeCapacityProvidersOutput, error) {
	req, out := c.DescribeCapacityProvidersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClusters = "DescribeClusters"

// DescribeClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusters for more information on using the DescribeClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClustersRequest method.
//	req, resp := client.DescribeClustersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeClusters
func (c *ECS) DescribeClustersRequest(input *DescribeClustersInput) (req *request.Request, output *DescribeClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClustersInput{}
	}

	output = &DescribeClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusters API operation for Amazon EC2 Container Service.
//
// Describes one or more of your clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DescribeClusters for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeClusters
func (c *ECS) DescribeClusters(input *DescribeClustersInput) (*DescribeClustersOutput, error) {
	req, out := c.DescribeClustersRequest(input)
	return out, req.Send()
}

// DescribeClustersWithContext is the same as DescribeClusters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DescribeClustersWithContext(ctx aws.Context, input *DescribeClustersInput, opts ...request.Option) (*DescribeClustersOutput, error) {
	req, out := c.DescribeClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContainerInstances = "DescribeContainerInstances"

// DescribeContainerInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeContainerInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeContainerInstances for more information on using the DescribeContainerInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeContainerInstancesRequest method.
//	req, resp := client.DescribeContainerInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeContainerInstances
func (c *ECS) DescribeContainerInstancesRequest(input *DescribeContainerInstancesInput) (req *request.Request, output *DescribeContainerInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeContainerInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeContainerInstancesInput{}
	}

	output = &DescribeContainerInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeContainerInstances API operation for Amazon EC2 Container Service.
//
// Describes one or more container instances. Returns metadata about each container
// instance requested.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DescribeContainerInstances for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeContainerInstances
func (c *ECS) DescribeContainerInstances(input *DescribeContainerInstancesInput) (*DescribeContainerInstancesOutput, error) {
	req, out := c.DescribeContainerInstancesRequest(input)
	return out, req.Send()
}

// DescribeContainerInstancesWithContext is the same as DescribeContainerInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContainerInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DescribeContainerInstancesWithContext(ctx aws.Context, input *DescribeContainerInstancesInput, opts ...request.Option) (*DescribeContainerInstancesOutput, error) {
	req, out := c.DescribeContainerInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeServices = "DescribeServices"

// DescribeServicesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeServices for more information on using the DescribeServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeServicesRequest method.
//	req, resp := client.DescribeServicesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeServices
func (c *ECS) DescribeServicesRequest(input *DescribeServicesInput) (req *request.Request, output *DescribeServicesOutput) {
	op := &request.Operation{
		Name:       opDescribeServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServicesInput{}
	}

	output = &DescribeServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeServices API operation for Amazon EC2 Container Service.
//
// Describes the specified services running in your cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DescribeServices for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeServices
func (c *ECS) DescribeServices(input *DescribeServicesInput) (*DescribeServicesOutput, error) {
	req, out := c.DescribeServicesRequest(input)
	return out, req.Send()
}

// DescribeServicesWithContext is the same as DescribeServices with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DescribeServicesWithContext(ctx aws.Context, input *DescribeServicesInput, opts ...request.Option) (*DescribeServicesOutput, error) {
	req, out := c.DescribeServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTaskDefinition = "DescribeTaskDefinition"

// DescribeTaskDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTaskDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTaskDefinition for more information on using the DescribeTaskDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTaskDefinitionRequest method.
//	req, resp := client.DescribeTaskDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTaskDefinition
func (c *ECS) DescribeTaskDefinitionRequest(input *DescribeTaskDefinitionInput) (req *request.Request, output *DescribeTaskDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeTaskDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTaskDefinitionInput{}
	}

	output = &DescribeTaskDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTaskDefinition API operation for Amazon EC2 Container Service.
//
// Describes a task definition. You can specify a family and revision to find
// information about a specific task definition, or you can simply specify the
// family to find the latest ACTIVE revision in that family.
//
// You can only describe INACTIVE task definitions while an active task or service
// references them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DescribeTaskDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTaskDefinition
func (c *ECS) DescribeTaskDefinition(input *DescribeTaskDefinitionInput) (*DescribeTaskDefinitionOutput, error) {
	req, out := c.DescribeTaskDefinitionRequest(input)
	return out, req.Send()
}

// DescribeTaskDefinitionWithContext is the same as DescribeTaskDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTaskDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DescribeTaskDefinitionWithContext(ctx aws.Context, input *DescribeTaskDefinitionInput, opts ...request.Option) (*DescribeTaskDefinitionOutput, error) {
	req, out := c.DescribeTaskDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTaskSets = "DescribeTaskSets"

// DescribeTaskSetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTaskSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTaskSets for more information on using the DescribeTaskSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTaskSetsRequest method.
//	req, resp := client.DescribeTaskSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTaskSets
func (c *ECS) DescribeTaskSetsRequest(input *DescribeTaskSetsInput) (req *request.Request, output *DescribeTaskSetsOutput) {
	op := &request.Operation{
		Name:       opDescribeTaskSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTaskSetsInput{}
	}

	output = &DescribeTaskSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTaskSets API operation for Amazon EC2 Container Service.
//
// Describes the task sets in the specified cluster and service. This is used
// when a service uses the EXTERNAL deployment controller type. For more information,
// see Amazon ECS Deployment Types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DescribeTaskSets for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - UnsupportedFeatureException
//     The specified task isn't supported in this Region.
//
//   - AccessDeniedException
//     You don't have authorization to perform the requested action.
//
//   - ServiceNotFoundException
//     The specified service wasn't found. You can view your available services
//     with ListServices. Amazon ECS services are cluster specific and Region specific.
//
//   - ServiceNotActiveException
//     The specified service isn't active. You can't update a service that's inactive.
//     If you have previously deleted a service, you can re-create it with CreateService.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTaskSets
func (c *ECS) DescribeTaskSets(input *DescribeTaskSetsInput) (*DescribeTaskSetsOutput, error) {
	req, out := c.DescribeTaskSetsRequest(input)
	return out, req.Send()
}

// DescribeTaskSetsWithContext is the same as DescribeTaskSets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTaskSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DescribeTaskSetsWithContext(ctx aws.Context, input *DescribeTaskSetsInput, opts ...request.Option) (*DescribeTaskSetsOutput, error) {
	req, out := c.DescribeTaskSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTasks = "DescribeTasks"

// DescribeTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTasks for more information on using the DescribeTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTasksRequest method.
//	req, resp := client.DescribeTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTasks
func (c *ECS) DescribeTasksRequest(input *DescribeTasksInput) (req *request.Request, output *DescribeTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTasksInput{}
	}

	output = &DescribeTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTasks API operation for Amazon EC2 Container Service.
//
// Describes a specified task or tasks.
//
// Currently, stopped tasks appear in the returned results for at least one
// hour.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DescribeTasks for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTasks
func (c *ECS) DescribeTasks(input *DescribeTasksInput) (*DescribeTasksOutput, error) {
	req, out := c.DescribeTasksRequest(input)
	return out, req.Send()
}

// DescribeTasksWithContext is the same as DescribeTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DescribeTasksWithContext(ctx aws.Context, input *DescribeTasksInput, opts ...request.Option) (*DescribeTasksOutput, error) {
	req, out := c.DescribeTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDiscoverPollEndpoint = "DiscoverPollEndpoint"

// DiscoverPollEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DiscoverPollEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DiscoverPollEndpoint for more information on using the DiscoverPollEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DiscoverPollEndpointRequest method.
//	req, resp := client.DiscoverPollEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DiscoverPollEndpoint
func (c *ECS) DiscoverPollEndpointRequest(input *DiscoverPollEndpointInput) (req *request.Request, output *DiscoverPollEndpointOutput) {
	op := &request.Operation{
		Name:       opDiscoverPollEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DiscoverPollEndpointInput{}
	}

	output = &DiscoverPollEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DiscoverPollEndpoint API operation for Amazon EC2 Container Service.
//
// This action is only used by the Amazon ECS agent, and it is not intended
// for use outside of the agent.
//
// Returns an endpoint for the Amazon ECS agent to poll for updates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation DiscoverPollEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DiscoverPollEndpoint
func (c *ECS) DiscoverPollEndpoint(input *DiscoverPollEndpointInput) (*DiscoverPollEndpointOutput, error) {
	req, out := c.DiscoverPollEndpointRequest(input)
	return out, req.Send()
}

// DiscoverPollEndpointWithContext is the same as DiscoverPollEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DiscoverPollEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) DiscoverPollEndpointWithContext(ctx aws.Context, input *DiscoverPollEndpointInput, opts ...request.Option) (*DiscoverPollEndpointOutput, error) {
	req, out := c.DiscoverPollEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteCommand = "ExecuteCommand"

// ExecuteCommandRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteCommand operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteCommand for more information on using the ExecuteCommand
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExecuteCommandRequest method.
//	req, resp := client.ExecuteCommandRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ExecuteCommand
func (c *ECS) ExecuteCommandRequest(input *ExecuteCommandInput) (req *request.Request, output *ExecuteCommandOutput) {
	op := &request.Operation{
		Name:       opExecuteCommand,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExecuteCommandInput{}
	}

	output = &ExecuteCommandOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExecuteCommand API operation for Amazon EC2 Container Service.
//
// Runs a command remotely on a container within a task.
//
// If you use a condition key in your IAM policy to refine the conditions for
// the policy statement, for example limit the actions to a specific cluster,
// you recevie an AccessDeniedException when there is a mismatch between the
// condition key value and the corresponding parameter value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation ExecuteCommand for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - AccessDeniedException
//     You don't have authorization to perform the requested action.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - TargetNotConnectedException
//     The execute command cannot run. This error can be caused by any of the following
//     configuration issues:
//
//   - Incorrect IAM permissions
//
//   - The SSM agent is not installed or is not running
//
//   - There is an interface Amazon VPC endpoint for Amazon ECS, but there
//     is not one for for Systems Manager Session Manager
//
//     For information about how to troubleshoot the issues, see Troubleshooting
//     issues with ECS Exec (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html)
//     in the Amazon Elastic Container Service Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ExecuteCommand
func (c *ECS) ExecuteCommand(input *ExecuteCommandInput) (*ExecuteCommandOutput, error) {
	req, out := c.ExecuteCommandRequest(input)
	return out, req.Send()
}

// ExecuteCommandWithContext is the same as ExecuteCommand with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteCommand for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ExecuteCommandWithContext(ctx aws.Context, input *ExecuteCommandInput, opts ...request.Option) (*ExecuteCommandOutput, error) {
	req, out := c.ExecuteCommandRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccountSettings = "ListAccountSettings"

// ListAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountSettings for more information on using the ListAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccountSettingsRequest method.
//	req, resp := client.ListAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAccountSettings
func (c *ECS) ListAccountSettingsRequest(input *ListAccountSettingsInput) (req *request.Request, output *ListAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opListAccountSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountSettingsInput{}
	}

	output = &ListAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountSettings API operation for Amazon EC2 Container Service.
//
// Lists the account settings for a specified principal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation ListAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAccountSettings
func (c *ECS) ListAccountSettings(input *ListAccountSettingsInput) (*ListAccountSettingsOutput, error) {
	req, out := c.ListAccountSettingsRequest(input)
	return out, req.Send()
}

// ListAccountSettingsWithContext is the same as ListAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListAccountSettingsWithContext(ctx aws.Context, input *ListAccountSettingsInput, opts ...request.Option) (*ListAccountSettingsOutput, error) {
	req, out := c.ListAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountSettingsPages iterates over the pages of a ListAccountSettings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountSettings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccountSettings operation.
//	pageNum := 0
//	err := client.ListAccountSettingsPages(params,
//	    func(page *ecs.ListAccountSettingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ECS) ListAccountSettingsPages(input *ListAccountSettingsInput, fn func(*ListAccountSettingsOutput, bool) bool) error {
	return c.ListAccountSettingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountSettingsPagesWithContext same as ListAccountSettingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListAccountSettingsPagesWithContext(ctx aws.Context, input *ListAccountSettingsInput, fn func(*ListAccountSettingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountSettingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountSettingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountSettingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAttributes = "ListAttributes"

// ListAttributesRequest generates a "aws/request.Request" representing the
// client's request for the ListAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAttributes for more information on using the ListAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAttributesRequest method.
//	req, resp := client.ListAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAttributes
func (c *ECS) ListAttributesRequest(input *ListAttributesInput) (req *request.Request, output *ListAttributesOutput) {
	op := &request.Operation{
		Name:       opListAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAttributesInput{}
	}

	output = &ListAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttributes API operation for Amazon EC2 Container Service.
//
// Lists the attributes for Amazon ECS resources within a specified target type
// and cluster. When you specify a target type and cluster, ListAttributes returns
// a list of attribute objects, one for each attribute on each resource. You
// can filter the list of results to a single attribute name to only return
// results that have that name. You can also filter the results by attribute
// name and value. You can do this, for example, to see which container instances
// in a cluster are running a Linux AMI (ecs.os-type=linux).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation ListAttributes for usage and error information.
//
// Returned Error Types:
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAttributes
func (c *ECS) ListAttributes(input *ListAttributesInput) (*ListAttributesOutput, error) {
	req, out := c.ListAttributesRequest(input)
	return out, req.Send()
}

// ListAttributesWithContext is the same as ListAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See ListAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListAttributesWithContext(ctx aws.Context, input *ListAttributesInput, opts ...request.Option) (*ListAttributesOutput, error) {
	req, out := c.ListAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAttributesPages iterates over the pages of a ListAttributes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAttributes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAttributes operation.
//	pageNum := 0
//	err := client.ListAttributesPages(params,
//	    func(page *ecs.ListAttributesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ECS) ListAttributesPages(input *ListAttributesInput, fn func(*ListAttributesOutput, bool) bool) error {
	return c.ListAttributesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAttributesPagesWithContext same as ListAttributesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListAttributesPagesWithContext(ctx aws.Context, input *ListAttributesInput, fn func(*ListAttributesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAttributesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAttributesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAttributesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListClustersRequest method.
//	req, resp := client.ListClustersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListClusters
func (c *ECS) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusters API operation for Amazon EC2 Container Service.
//
// Returns a list of existing clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation ListClusters for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListClusters
func (c *ECS) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListClustersWithContext(ctx aws.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClustersPages iterates over the pages of a ListClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListClusters operation.
//	pageNum := 0
//	err := client.ListClustersPages(params,
//	    func(page *ecs.ListClustersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ECS) ListClustersPages(input *ListClustersInput, fn func(*ListClustersOutput, bool) bool) error {
	return c.ListClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClustersPagesWithContext same as ListClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListClustersPagesWithContext(ctx aws.Context, input *ListClustersInput, fn func(*ListClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListContainerInstances = "ListContainerInstances"

// ListContainerInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListContainerInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContainerInstances for more information on using the ListContainerInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListContainerInstancesRequest method.
//	req, resp := client.ListContainerInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListContainerInstances
func (c *ECS) ListContainerInstancesRequest(input *ListContainerInstancesInput) (req *request.Request, output *ListContainerInstancesOutput) {
	op := &request.Operation{
		Name:       opListContainerInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContainerInstancesInput{}
	}

	output = &ListContainerInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContainerInstances API operation for Amazon EC2 Container Service.
//
// Returns a list of container instances in a specified cluster. You can filter
// the results of a ListContainerInstances operation with cluster query language
// statements inside the filter parameter. For more information, see Cluster
// Query Language (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation ListContainerInstances for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListContainerInstances
func (c *ECS) ListContainerInstances(input *ListContainerInstancesInput) (*ListContainerInstancesOutput, error) {
	req, out := c.ListContainerInstancesRequest(input)
	return out, req.Send()
}

// ListContainerInstancesWithContext is the same as ListContainerInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListContainerInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListContainerInstancesWithContext(ctx aws.Context, input *ListContainerInstancesInput, opts ...request.Option) (*ListContainerInstancesOutput, error) {
	req, out := c.ListContainerInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContainerInstancesPages iterates over the pages of a ListContainerInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContainerInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListContainerInstances operation.
//	pageNum := 0
//	err := client.ListContainerInstancesPages(params,
//	    func(page *ecs.ListContainerInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ECS) ListContainerInstancesPages(input *ListContainerInstancesInput, fn func(*ListContainerInstancesOutput, bool) bool) error {
	return c.ListContainerInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContainerInstancesPagesWithContext same as ListContainerInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListContainerInstancesPagesWithContext(ctx aws.Context, input *ListContainerInstancesInput, fn func(*ListContainerInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContainerInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContainerInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContainerInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServices = "ListServices"

// ListServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServices for more information on using the ListServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServicesRequest method.
//	req, resp := client.ListServicesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServices
func (c *ECS) ListServicesRequest(input *ListServicesInput) (req *request.Request, output *ListServicesOutput) {
	op := &request.Operation{
		Name:       opListServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicesInput{}
	}

	output = &ListServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServices API operation for Amazon EC2 Container Service.
//
// Returns a list of services. You can filter the results by cluster, launch
// type, and scheduling strategy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation ListServices for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServices
func (c *ECS) ListServices(input *ListServicesInput) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	return out, req.Send()
}

// ListServicesWithContext is the same as ListServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListServicesWithContext(ctx aws.Context, input *ListServicesInput, opts ...request.Option) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicesPages iterates over the pages of a ListServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServices operation.
//	pageNum := 0
//	err := client.ListServicesPages(params,
//	    func(page *ecs.ListServicesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ECS) ListServicesPages(input *ListServicesInput, fn func(*ListServicesOutput, bool) bool) error {
	return c.ListServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicesPagesWithContext same as ListServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListServicesPagesWithContext(ctx aws.Context, input *ListServicesInput, fn func(*ListServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTagsForResource
func (c *ECS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon EC2 Container Service.
//
// List the tags for an Amazon ECS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTagsForResource
func (c *ECS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTaskDefinitionFamilies = "ListTaskDefinitionFamilies"

// ListTaskDefinitionFamiliesRequest generates a "aws/request.Request" representing the
// client's request for the ListTaskDefinitionFamilies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTaskDefinitionFamilies for more information on using the ListTaskDefinitionFamilies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTaskDefinitionFamiliesRequest method.
//	req, resp := client.ListTaskDefinitionFamiliesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitionFamilies
func (c *ECS) ListTaskDefinitionFamiliesRequest(input *ListTaskDefinitionFamiliesInput) (req *request.Request, output *ListTaskDefinitionFamiliesOutput) {
	op := &request.Operation{
		Name:       opListTaskDefinitionFamilies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTaskDefinitionFamiliesInput{}
	}

	output = &ListTaskDefinitionFamiliesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTaskDefinitionFamilies API operation for Amazon EC2 Container Service.
//
// Returns a list of task definition families that are registered to your account.
// This list includes task definition families that no longer have any ACTIVE
// task definition revisions.
//
// You can filter out task definition families that don't contain any ACTIVE
// task definition revisions by setting the status parameter to ACTIVE. You
// can also filter the results with the familyPrefix parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation ListTaskDefinitionFamilies for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitionFamilies
func (c *ECS) ListTaskDefinitionFamilies(input *ListTaskDefinitionFamiliesInput) (*ListTaskDefinitionFamiliesOutput, error) {
	req, out := c.ListTaskDefinitionFamiliesRequest(input)
	return out, req.Send()
}

// ListTaskDefinitionFamiliesWithContext is the same as ListTaskDefinitionFamilies with the addition of
// the ability to pass a context and additional request options.
//
// See ListTaskDefinitionFamilies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListTaskDefinitionFamiliesWithContext(ctx aws.Context, input *ListTaskDefinitionFamiliesInput, opts ...request.Option) (*ListTaskDefinitionFamiliesOutput, error) {
	req, out := c.ListTaskDefinitionFamiliesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTaskDefinitionFamiliesPages iterates over the pages of a ListTaskDefinitionFamilies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTaskDefinitionFamilies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTaskDefinitionFamilies operation.
//	pageNum := 0
//	err := client.ListTaskDefinitionFamiliesPages(params,
//	    func(page *ecs.ListTaskDefinitionFamiliesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ECS) ListTaskDefinitionFamiliesPages(input *ListTaskDefinitionFamiliesInput, fn func(*ListTaskDefinitionFamiliesOutput, bool) bool) error {
	return c.ListTaskDefinitionFamiliesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTaskDefinitionFamiliesPagesWithContext same as ListTaskDefinitionFamiliesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListTaskDefinitionFamiliesPagesWithContext(ctx aws.Context, input *ListTaskDefinitionFamiliesInput, fn func(*ListTaskDefinitionFamiliesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTaskDefinitionFamiliesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTaskDefinitionFamiliesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTaskDefinitionFamiliesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTaskDefinitions = "ListTaskDefinitions"

// ListTaskDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTaskDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTaskDefinitions for more information on using the ListTaskDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTaskDefinitionsRequest method.
//	req, resp := client.ListTaskDefinitionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitions
func (c *ECS) ListTaskDefinitionsRequest(input *ListTaskDefinitionsInput) (req *request.Request, output *ListTaskDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListTaskDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTaskDefinitionsInput{}
	}

	output = &ListTaskDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTaskDefinitions API operation for Amazon EC2 Container Service.
//
// Returns a list of task definitions that are registered to your account. You
// can filter the results by family name with the familyPrefix parameter or
// by status with the status parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation ListTaskDefinitions for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitions
func (c *ECS) ListTaskDefinitions(input *ListTaskDefinitionsInput) (*ListTaskDefinitionsOutput, error) {
	req, out := c.ListTaskDefinitionsRequest(input)
	return out, req.Send()
}

// ListTaskDefinitionsWithContext is the same as ListTaskDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTaskDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListTaskDefinitionsWithContext(ctx aws.Context, input *ListTaskDefinitionsInput, opts ...request.Option) (*ListTaskDefinitionsOutput, error) {
	req, out := c.ListTaskDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTaskDefinitionsPages iterates over the pages of a ListTaskDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTaskDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTaskDefinitions operation.
//	pageNum := 0
//	err := client.ListTaskDefinitionsPages(params,
//	    func(page *ecs.ListTaskDefinitionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ECS) ListTaskDefinitionsPages(input *ListTaskDefinitionsInput, fn func(*ListTaskDefinitionsOutput, bool) bool) error {
	return c.ListTaskDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTaskDefinitionsPagesWithContext same as ListTaskDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListTaskDefinitionsPagesWithContext(ctx aws.Context, input *ListTaskDefinitionsInput, fn func(*ListTaskDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTaskDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTaskDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTaskDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTasks = "ListTasks"

// ListTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTasks for more information on using the ListTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTasksRequest method.
//	req, resp := client.ListTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTasks
func (c *ECS) ListTasksRequest(input *ListTasksInput) (req *request.Request, output *ListTasksOutput) {
	op := &request.Operation{
		Name:       opListTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTasksInput{}
	}

	output = &ListTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTasks API operation for Amazon EC2 Container Service.
//
// Returns a list of tasks. You can filter the results by cluster, task definition
// family, container instance, launch type, what IAM principal started the task,
// or by the desired status of the task.
//
// Recently stopped tasks might appear in the returned results. Currently, stopped
// tasks appear in the returned results for at least one hour.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation ListTasks for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - ServiceNotFoundException
//     The specified service wasn't found. You can view your available services
//     with ListServices. Amazon ECS services are cluster specific and Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTasks
func (c *ECS) ListTasks(input *ListTasksInput) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	return out, req.Send()
}

// ListTasksWithContext is the same as ListTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListTasksWithContext(ctx aws.Context, input *ListTasksInput, opts ...request.Option) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTasksPages iterates over the pages of a ListTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTasks operation.
//	pageNum := 0
//	err := client.ListTasksPages(params,
//	    func(page *ecs.ListTasksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ECS) ListTasksPages(input *ListTasksInput, fn func(*ListTasksOutput, bool) bool) error {
	return c.ListTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTasksPagesWithContext same as ListTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ListTasksPagesWithContext(ctx aws.Context, input *ListTasksInput, fn func(*ListTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutAccountSetting = "PutAccountSetting"

// PutAccountSettingRequest generates a "aws/request.Request" representing the
// client's request for the PutAccountSetting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccountSetting for more information on using the PutAccountSetting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAccountSettingRequest method.
//	req, resp := client.PutAccountSettingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAccountSetting
func (c *ECS) PutAccountSettingRequest(input *PutAccountSettingInput) (req *request.Request, output *PutAccountSettingOutput) {
	op := &request.Operation{
		Name:       opPutAccountSetting,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAccountSettingInput{}
	}

	output = &PutAccountSettingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAccountSetting API operation for Amazon EC2 Container Service.
//
// Modifies an account setting. Account settings are set on a per-Region basis.
//
// If you change the account setting for the root user, the default settings
// for all of the IAM users and roles that no individual account setting was
// specified are reset for. For more information, see Account Settings (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// When serviceLongArnFormat, taskLongArnFormat, or containerInstanceLongArnFormat
// are specified, the Amazon Resource Name (ARN) and resource ID format of the
// resource type for a specified IAM user, IAM role, or the root user for an
// account is affected. The opt-in and opt-out account setting must be set for
// each Amazon ECS resource separately. The ARN and resource ID format of a
// resource is defined by the opt-in status of the IAM user or role that created
// the resource. You must turn on this setting to use Amazon ECS features such
// as resource tagging.
//
// When awsvpcTrunking is specified, the elastic network interface (ENI) limit
// for any new container instances that support the feature is changed. If awsvpcTrunking
// is enabled, any new container instances that support the feature are launched
// have the increased ENI limits available to them. For more information, see
// Elastic Network Interface Trunking (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// When containerInsights is specified, the default setting indicating whether
// CloudWatch Container Insights is enabled for your clusters is changed. If
// containerInsights is enabled, any new clusters that are created will have
// Container Insights enabled unless you disable it during cluster creation.
// For more information, see CloudWatch Container Insights (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation PutAccountSetting for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAccountSetting
func (c *ECS) PutAccountSetting(input *PutAccountSettingInput) (*PutAccountSettingOutput, error) {
	req, out := c.PutAccountSettingRequest(input)
	return out, req.Send()
}

// PutAccountSettingWithContext is the same as PutAccountSetting with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccountSetting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) PutAccountSettingWithContext(ctx aws.Context, input *PutAccountSettingInput, opts ...request.Option) (*PutAccountSettingOutput, error) {
	req, out := c.PutAccountSettingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccountSettingDefault = "PutAccountSettingDefault"

// PutAccountSettingDefaultRequest generates a "aws/request.Request" representing the
// client's request for the PutAccountSettingDefault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccountSettingDefault for more information on using the PutAccountSettingDefault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAccountSettingDefaultRequest method.
//	req, resp := client.PutAccountSettingDefaultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAccountSettingDefault
func (c *ECS) PutAccountSettingDefaultRequest(input *PutAccountSettingDefaultInput) (req *request.Request, output *PutAccountSettingDefaultOutput) {
	op := &request.Operation{
		Name:       opPutAccountSettingDefault,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAccountSettingDefaultInput{}
	}

	output = &PutAccountSettingDefaultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAccountSettingDefault API operation for Amazon EC2 Container Service.
//
// Modifies an account setting for all IAM users on an account for whom no individual
// account setting has been specified. Account settings are set on a per-Region
// basis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation PutAccountSettingDefault for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAccountSettingDefault
func (c *ECS) PutAccountSettingDefault(input *PutAccountSettingDefaultInput) (*PutAccountSettingDefaultOutput, error) {
	req, out := c.PutAccountSettingDefaultRequest(input)
	return out, req.Send()
}

// PutAccountSettingDefaultWithContext is the same as PutAccountSettingDefault with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccountSettingDefault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) PutAccountSettingDefaultWithContext(ctx aws.Context, input *PutAccountSettingDefaultInput, opts ...request.Option) (*PutAccountSettingDefaultOutput, error) {
	req, out := c.PutAccountSettingDefaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAttributes = "PutAttributes"

// PutAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAttributes for more information on using the PutAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAttributesRequest method.
//	req, resp := client.PutAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAttributes
func (c *ECS) PutAttributesRequest(input *PutAttributesInput) (req *request.Request, output *PutAttributesOutput) {
	op := &request.Operation{
		Name:       opPutAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAttributesInput{}
	}

	output = &PutAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAttributes API operation for Amazon EC2 Container Service.
//
// Create or update an attribute on an Amazon ECS resource. If the attribute
// doesn't exist, it's created. If the attribute exists, its value is replaced
// with the specified value. To delete an attribute, use DeleteAttributes. For
// more information, see Attributes (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation PutAttributes for usage and error information.
//
// Returned Error Types:
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - TargetNotFoundException
//     The specified target wasn't found. You can view your available container
//     instances with ListContainerInstances. Amazon ECS container instances are
//     cluster-specific and Region-specific.
//
//   - AttributeLimitExceededException
//     You can apply up to 10 custom attributes for each resource. You can view
//     the attributes of a resource with ListAttributes. You can remove existing
//     attributes on a resource with DeleteAttributes.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAttributes
func (c *ECS) PutAttributes(input *PutAttributesInput) (*PutAttributesOutput, error) {
	req, out := c.PutAttributesRequest(input)
	return out, req.Send()
}

// PutAttributesWithContext is the same as PutAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) PutAttributesWithContext(ctx aws.Context, input *PutAttributesInput, opts ...request.Option) (*PutAttributesOutput, error) {
	req, out := c.PutAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutClusterCapacityProviders = "PutClusterCapacityProviders"

// PutClusterCapacityProvidersRequest generates a "aws/request.Request" representing the
// client's request for the PutClusterCapacityProviders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutClusterCapacityProviders for more information on using the PutClusterCapacityProviders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutClusterCapacityProvidersRequest method.
//	req, resp := client.PutClusterCapacityProvidersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutClusterCapacityProviders
func (c *ECS) PutClusterCapacityProvidersRequest(input *PutClusterCapacityProvidersInput) (req *request.Request, output *PutClusterCapacityProvidersOutput) {
	op := &request.Operation{
		Name:       opPutClusterCapacityProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutClusterCapacityProvidersInput{}
	}

	output = &PutClusterCapacityProvidersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutClusterCapacityProviders API operation for Amazon EC2 Container Service.
//
// Modifies the available capacity providers and the default capacity provider
// strategy for a cluster.
//
// You must specify both the available capacity providers and a default capacity
// provider strategy for the cluster. If the specified cluster has existing
// capacity providers associated with it, you must specify all existing capacity
// providers in addition to any new ones you want to add. Any existing capacity
// providers that are associated with a cluster that are omitted from a PutClusterCapacityProviders
// API call will be disassociated with the cluster. You can only disassociate
// an existing capacity provider from a cluster if it's not being used by any
// existing tasks.
//
// When creating a service or running a task on a cluster, if no capacity provider
// or launch type is specified, then the cluster's default capacity provider
// strategy is used. We recommend that you define a default capacity provider
// strategy for your cluster. However, you must specify an empty array ([])
// to bypass defining a default strategy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation PutClusterCapacityProviders for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - ResourceInUseException
//     The specified resource is in-use and can't be removed.
//
//   - UpdateInProgressException
//     There's already a current Amazon ECS container agent update in progress on
//     the container instance that's specified. If the container agent becomes disconnected
//     while it's in a transitional stage, such as PENDING or STAGING, the update
//     process can get stuck in that state. However, when the agent reconnects,
//     it resumes where it stopped previously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutClusterCapacityProviders
func (c *ECS) PutClusterCapacityProviders(input *PutClusterCapacityProvidersInput) (*PutClusterCapacityProvidersOutput, error) {
	req, out := c.PutClusterCapacityProvidersRequest(input)
	return out, req.Send()
}

// PutClusterCapacityProvidersWithContext is the same as PutClusterCapacityProviders with the addition of
// the ability to pass a context and additional request options.
//
// See PutClusterCapacityProviders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) PutClusterCapacityProvidersWithContext(ctx aws.Context, input *PutClusterCapacityProvidersInput, opts ...request.Option) (*PutClusterCapacityProvidersOutput, error) {
	req, out := c.PutClusterCapacityProvidersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterContainerInstance = "RegisterContainerInstance"

// RegisterContainerInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterContainerInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterContainerInstance for more information on using the RegisterContainerInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterContainerInstanceRequest method.
//	req, resp := client.RegisterContainerInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RegisterContainerInstance
func (c *ECS) RegisterContainerInstanceRequest(input *RegisterContainerInstanceInput) (req *request.Request, output *RegisterContainerInstanceOutput) {
	op := &request.Operation{
		Name:       opRegisterContainerInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterContainerInstanceInput{}
	}

	output = &RegisterContainerInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterContainerInstance API operation for Amazon EC2 Container Service.
//
// This action is only used by the Amazon ECS agent, and it is not intended
// for use outside of the agent.
//
// Registers an EC2 instance into the specified cluster. This instance becomes
// available to place containers on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation RegisterContainerInstance for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RegisterContainerInstance
func (c *ECS) RegisterContainerInstance(input *RegisterContainerInstanceInput) (*RegisterContainerInstanceOutput, error) {
	req, out := c.RegisterContainerInstanceRequest(input)
	return out, req.Send()
}

// RegisterContainerInstanceWithContext is the same as RegisterContainerInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterContainerInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) RegisterContainerInstanceWithContext(ctx aws.Context, input *RegisterContainerInstanceInput, opts ...request.Option) (*RegisterContainerInstanceOutput, error) {
	req, out := c.RegisterContainerInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterTaskDefinition = "RegisterTaskDefinition"

// RegisterTaskDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the RegisterTaskDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterTaskDefinition for more information on using the RegisterTaskDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterTaskDefinitionRequest method.
//	req, resp := client.RegisterTaskDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RegisterTaskDefinition
func (c *ECS) RegisterTaskDefinitionRequest(input *RegisterTaskDefinitionInput) (req *request.Request, output *RegisterTaskDefinitionOutput) {
	op := &request.Operation{
		Name:       opRegisterTaskDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterTaskDefinitionInput{}
	}

	output = &RegisterTaskDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterTaskDefinition API operation for Amazon EC2 Container Service.
//
// Registers a new task definition from the supplied family and containerDefinitions.
// Optionally, you can add data volumes to your containers with the volumes
// parameter. For more information about task definition parameters and defaults,
// see Amazon ECS Task Definitions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// You can specify an IAM role for your task with the taskRoleArn parameter.
// When you specify an IAM role for a task, its containers can then use the
// latest versions of the CLI or SDKs to make API requests to the Amazon Web
// Services services that are specified in the IAM policy that's associated
// with the role. For more information, see IAM Roles for Tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// You can specify a Docker networking mode for the containers in your task
// definition with the networkMode parameter. The available network modes correspond
// to those described in Network settings (https://docs.docker.com/engine/reference/run/#/network-settings)
// in the Docker run reference. If you specify the awsvpc network mode, the
// task is allocated an elastic network interface, and you must specify a NetworkConfiguration
// when you create a service or run a task with the task definition. For more
// information, see Task Networking (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation RegisterTaskDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RegisterTaskDefinition
func (c *ECS) RegisterTaskDefinition(input *RegisterTaskDefinitionInput) (*RegisterTaskDefinitionOutput, error) {
	req, out := c.RegisterTaskDefinitionRequest(input)
	return out, req.Send()
}

// RegisterTaskDefinitionWithContext is the same as RegisterTaskDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterTaskDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) RegisterTaskDefinitionWithContext(ctx aws.Context, input *RegisterTaskDefinitionInput, opts ...request.Option) (*RegisterTaskDefinitionOutput, error) {
	req, out := c.RegisterTaskDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRunTask = "RunTask"

// RunTaskRequest generates a "aws/request.Request" representing the
// client's request for the RunTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RunTask for more information on using the RunTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RunTaskRequest method.
//	req, resp := client.RunTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RunTask
func (c *ECS) RunTaskRequest(input *RunTaskInput) (req *request.Request, output *RunTaskOutput) {
	op := &request.Operation{
		Name:       opRunTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunTaskInput{}
	}

	output = &RunTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RunTask API operation for Amazon EC2 Container Service.
//
// Starts a new task using the specified task definition.
//
// You can allow Amazon ECS to place tasks for you, or you can customize how
// Amazon ECS places tasks using placement constraints and placement strategies.
// For more information, see Scheduling Tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Alternatively, you can use StartTask to use your own scheduler or place tasks
// manually on specific container instances.
//
// The Amazon ECS API follows an eventual consistency model. This is because
// of the distributed nature of the system supporting the API. This means that
// the result of an API command you run that affects your Amazon ECS resources
// might not be immediately visible to all subsequent commands you run. Keep
// this in mind when you carry out an API command that immediately follows a
// previous API command.
//
// To manage eventual consistency, you can do the following:
//
//   - Confirm the state of the resource before you run a command to modify
//     it. Run the DescribeTasks command using an exponential backoff algorithm
//     to ensure that you allow enough time for the previous command to propagate
//     through the system. To do this, run the DescribeTasks command repeatedly,
//     starting with a couple of seconds of wait time and increasing gradually
//     up to five minutes of wait time.
//
//   - Add wait time between subsequent commands, even if the DescribeTasks
//     command returns an accurate response. Apply an exponential backoff algorithm
//     starting with a couple of seconds of wait time, and increase gradually
//     up to about five minutes of wait time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation RunTask for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - UnsupportedFeatureException
//     The specified task isn't supported in this Region.
//
//   - PlatformUnknownException
//     The specified platform version doesn't exist.
//
//   - PlatformTaskDefinitionIncompatibilityException
//     The specified platform version doesn't satisfy the required capabilities
//     of the task definition.
//
//   - AccessDeniedException
//     You don't have authorization to perform the requested action.
//
//   - BlockedException
//     Your Amazon Web Services account was blocked. For more information, contact
//     Amazon Web Services Support (http://aws.amazon.com/contact-us/).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RunTask
func (c *ECS) RunTask(input *RunTaskInput) (*RunTaskOutput, error) {
	req, out := c.RunTaskRequest(input)
	return out, req.Send()
}

// RunTaskWithContext is the same as RunTask with the addition of
// the ability to pass a context and additional request options.
//
// See RunTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) RunTaskWithContext(ctx aws.Context, input *RunTaskInput, opts ...request.Option) (*RunTaskOutput, error) {
	req, out := c.RunTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTask = "StartTask"

// StartTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTask for more information on using the StartTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTaskRequest method.
//	req, resp := client.StartTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/StartTask
func (c *ECS) StartTaskRequest(input *StartTaskInput) (req *request.Request, output *StartTaskOutput) {
	op := &request.Operation{
		Name:       opStartTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTaskInput{}
	}

	output = &StartTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTask API operation for Amazon EC2 Container Service.
//
// Starts a new task from the specified task definition on the specified container
// instance or instances.
//
// Alternatively, you can use RunTask to place tasks for you. For more information,
// see Scheduling Tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation StartTask for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/StartTask
func (c *ECS) StartTask(input *StartTaskInput) (*StartTaskOutput, error) {
	req, out := c.StartTaskRequest(input)
	return out, req.Send()
}

// StartTaskWithContext is the same as StartTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) StartTaskWithContext(ctx aws.Context, input *StartTaskInput, opts ...request.Option) (*StartTaskOutput, error) {
	req, out := c.StartTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTask = "StopTask"

// StopTaskRequest generates a "aws/request.Request" representing the
// client's request for the StopTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTask for more information on using the StopTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopTaskRequest method.
//	req, resp := client.StopTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/StopTask
func (c *ECS) StopTaskRequest(input *StopTaskInput) (req *request.Request, output *StopTaskOutput) {
	op := &request.Operation{
		Name:       opStopTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTaskInput{}
	}

	output = &StopTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopTask API operation for Amazon EC2 Container Service.
//
// Stops a running task. Any tags associated with the task will be deleted.
//
// When StopTask is called on a task, the equivalent of docker stop is issued
// to the containers running in the task. This results in a SIGTERM value and
// a default 30-second timeout, after which the SIGKILL value is sent and the
// containers are forcibly stopped. If the container handles the SIGTERM value
// gracefully and exits within 30 seconds from receiving it, no SIGKILL value
// is sent.
//
// The default 30-second timeout can be configured on the Amazon ECS container
// agent with the ECS_CONTAINER_STOP_TIMEOUT variable. For more information,
// see Amazon ECS Container Agent Configuration (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation StopTask for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/StopTask
func (c *ECS) StopTask(input *StopTaskInput) (*StopTaskOutput, error) {
	req, out := c.StopTaskRequest(input)
	return out, req.Send()
}

// StopTaskWithContext is the same as StopTask with the addition of
// the ability to pass a context and additional request options.
//
// See StopTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) StopTaskWithContext(ctx aws.Context, input *StopTaskInput, opts ...request.Option) (*StopTaskOutput, error) {
	req, out := c.StopTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSubmitAttachmentStateChanges = "SubmitAttachmentStateChanges"

// SubmitAttachmentStateChangesRequest generates a "aws/request.Request" representing the
// client's request for the SubmitAttachmentStateChanges operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SubmitAttachmentStateChanges for more information on using the SubmitAttachmentStateChanges
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SubmitAttachmentStateChangesRequest method.
//	req, resp := client.SubmitAttachmentStateChangesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitAttachmentStateChanges
func (c *ECS) SubmitAttachmentStateChangesRequest(input *SubmitAttachmentStateChangesInput) (req *request.Request, output *SubmitAttachmentStateChangesOutput) {
	op := &request.Operation{
		Name:       opSubmitAttachmentStateChanges,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SubmitAttachmentStateChangesInput{}
	}

	output = &SubmitAttachmentStateChangesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SubmitAttachmentStateChanges API operation for Amazon EC2 Container Service.
//
// This action is only used by the Amazon ECS agent, and it is not intended
// for use outside of the agent.
//
// Sent to acknowledge that an attachment changed states.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation SubmitAttachmentStateChanges for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - AccessDeniedException
//     You don't have authorization to perform the requested action.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitAttachmentStateChanges
func (c *ECS) SubmitAttachmentStateChanges(input *SubmitAttachmentStateChangesInput) (*SubmitAttachmentStateChangesOutput, error) {
	req, out := c.SubmitAttachmentStateChangesRequest(input)
	return out, req.Send()
}

// SubmitAttachmentStateChangesWithContext is the same as SubmitAttachmentStateChanges with the addition of
// the ability to pass a context and additional request options.
//
// See SubmitAttachmentStateChanges for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) SubmitAttachmentStateChangesWithContext(ctx aws.Context, input *SubmitAttachmentStateChangesInput, opts ...request.Option) (*SubmitAttachmentStateChangesOutput, error) {
	req, out := c.SubmitAttachmentStateChangesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSubmitContainerStateChange = "SubmitContainerStateChange"

// SubmitContainerStateChangeRequest generates a "aws/request.Request" representing the
// client's request for the SubmitContainerStateChange operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SubmitContainerStateChange for more information on using the SubmitContainerStateChange
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SubmitContainerStateChangeRequest method.
//	req, resp := client.SubmitContainerStateChangeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitContainerStateChange
func (c *ECS) SubmitContainerStateChangeRequest(input *SubmitContainerStateChangeInput) (req *request.Request, output *SubmitContainerStateChangeOutput) {
	op := &request.Operation{
		Name:       opSubmitContainerStateChange,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SubmitContainerStateChangeInput{}
	}

	output = &SubmitContainerStateChangeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SubmitContainerStateChange API operation for Amazon EC2 Container Service.
//
// This action is only used by the Amazon ECS agent, and it is not intended
// for use outside of the agent.
//
// Sent to acknowledge that a container changed states.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation SubmitContainerStateChange for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - AccessDeniedException
//     You don't have authorization to perform the requested action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitContainerStateChange
func (c *ECS) SubmitContainerStateChange(input *SubmitContainerStateChangeInput) (*SubmitContainerStateChangeOutput, error) {
	req, out := c.SubmitContainerStateChangeRequest(input)
	return out, req.Send()
}

// SubmitContainerStateChangeWithContext is the same as SubmitContainerStateChange with the addition of
// the ability to pass a context and additional request options.
//
// See SubmitContainerStateChange for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) SubmitContainerStateChangeWithContext(ctx aws.Context, input *SubmitContainerStateChangeInput, opts ...request.Option) (*SubmitContainerStateChangeOutput, error) {
	req, out := c.SubmitContainerStateChangeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSubmitTaskStateChange = "SubmitTaskStateChange"

// SubmitTaskStateChangeRequest generates a "aws/request.Request" representing the
// client's request for the SubmitTaskStateChange operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SubmitTaskStateChange for more information on using the SubmitTaskStateChange
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SubmitTaskStateChangeRequest method.
//	req, resp := client.SubmitTaskStateChangeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitTaskStateChange
func (c *ECS) SubmitTaskStateChangeRequest(input *SubmitTaskStateChangeInput) (req *request.Request, output *SubmitTaskStateChangeOutput) {
	op := &request.Operation{
		Name:       opSubmitTaskStateChange,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SubmitTaskStateChangeInput{}
	}

	output = &SubmitTaskStateChangeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SubmitTaskStateChange API operation for Amazon EC2 Container Service.
//
// This action is only used by the Amazon ECS agent, and it is not intended
// for use outside of the agent.
//
// Sent to acknowledge that a task changed states.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation SubmitTaskStateChange for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - AccessDeniedException
//     You don't have authorization to perform the requested action.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitTaskStateChange
func (c *ECS) SubmitTaskStateChange(input *SubmitTaskStateChangeInput) (*SubmitTaskStateChangeOutput, error) {
	req, out := c.SubmitTaskStateChangeRequest(input)
	return out, req.Send()
}

// SubmitTaskStateChangeWithContext is the same as SubmitTaskStateChange with the addition of
// the ability to pass a context and additional request options.
//
// See SubmitTaskStateChange for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) SubmitTaskStateChangeWithContext(ctx aws.Context, input *SubmitTaskStateChangeInput, opts ...request.Option) (*SubmitTaskStateChangeOutput, error) {
	req, out := c.SubmitTaskStateChangeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/TagResource
func (c *ECS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon EC2 Container Service.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource aren't specified in the request parameters,
// they aren't changed. When a resource is deleted, the tags that are associated
// with that resource are deleted as well.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/TagResource
func (c *ECS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UntagResource
func (c *ECS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon EC2 Container Service.
//
// Deletes specified tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UntagResource
func (c *ECS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCapacityProvider = "UpdateCapacityProvider"

// UpdateCapacityProviderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCapacityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCapacityProvider for more information on using the UpdateCapacityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCapacityProviderRequest method.
//	req, resp := client.UpdateCapacityProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateCapacityProvider
func (c *ECS) UpdateCapacityProviderRequest(input *UpdateCapacityProviderInput) (req *request.Request, output *UpdateCapacityProviderOutput) {
	op := &request.Operation{
		Name:       opUpdateCapacityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCapacityProviderInput{}
	}

	output = &UpdateCapacityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCapacityProvider API operation for Amazon EC2 Container Service.
//
// Modifies the parameters for a capacity provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation UpdateCapacityProvider for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateCapacityProvider
func (c *ECS) UpdateCapacityProvider(input *UpdateCapacityProviderInput) (*UpdateCapacityProviderOutput, error) {
	req, out := c.UpdateCapacityProviderRequest(input)
	return out, req.Send()
}

// UpdateCapacityProviderWithContext is the same as UpdateCapacityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCapacityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) UpdateCapacityProviderWithContext(ctx aws.Context, input *UpdateCapacityProviderInput, opts ...request.Option) (*UpdateCapacityProviderOutput, error) {
	req, out := c.UpdateCapacityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCluster = "UpdateCluster"

// UpdateClusterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCluster for more information on using the UpdateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateClusterRequest method.
//	req, resp := client.UpdateClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateCluster
func (c *ECS) UpdateClusterRequest(input *UpdateClusterInput) (req *request.Request, output *UpdateClusterOutput) {
	op := &request.Operation{
		Name:       opUpdateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateClusterInput{}
	}

	output = &UpdateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCluster API operation for Amazon EC2 Container Service.
//
// Updates the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation UpdateCluster for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateCluster
func (c *ECS) UpdateCluster(input *UpdateClusterInput) (*UpdateClusterOutput, error) {
	req, out := c.UpdateClusterRequest(input)
	return out, req.Send()
}

// UpdateClusterWithContext is the same as UpdateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) UpdateClusterWithContext(ctx aws.Context, input *UpdateClusterInput, opts ...request.Option) (*UpdateClusterOutput, error) {
	req, out := c.UpdateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClusterSettings = "UpdateClusterSettings"

// UpdateClusterSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClusterSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClusterSettings for more information on using the UpdateClusterSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateClusterSettingsRequest method.
//	req, resp := client.UpdateClusterSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateClusterSettings
func (c *ECS) UpdateClusterSettingsRequest(input *UpdateClusterSettingsInput) (req *request.Request, output *UpdateClusterSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateClusterSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateClusterSettingsInput{}
	}

	output = &UpdateClusterSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClusterSettings API operation for Amazon EC2 Container Service.
//
// Modifies the settings to use for a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation UpdateClusterSettings for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateClusterSettings
func (c *ECS) UpdateClusterSettings(input *UpdateClusterSettingsInput) (*UpdateClusterSettingsOutput, error) {
	req, out := c.UpdateClusterSettingsRequest(input)
	return out, req.Send()
}

// UpdateClusterSettingsWithContext is the same as UpdateClusterSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClusterSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) UpdateClusterSettingsWithContext(ctx aws.Context, input *UpdateClusterSettingsInput, opts ...request.Option) (*UpdateClusterSettingsOutput, error) {
	req, out := c.UpdateClusterSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContainerAgent = "UpdateContainerAgent"

// UpdateContainerAgentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContainerAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContainerAgent for more information on using the UpdateContainerAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContainerAgentRequest method.
//	req, resp := client.UpdateContainerAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateContainerAgent
func (c *ECS) UpdateContainerAgentRequest(input *UpdateContainerAgentInput) (req *request.Request, output *UpdateContainerAgentOutput) {
	op := &request.Operation{
		Name:       opUpdateContainerAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContainerAgentInput{}
	}

	output = &UpdateContainerAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateContainerAgent API operation for Amazon EC2 Container Service.
//
// Updates the Amazon ECS container agent on a specified container instance.
// Updating the Amazon ECS container agent doesn't interrupt running tasks or
// services on the container instance. The process for updating the agent differs
// depending on whether your container instance was launched with the Amazon
// ECS-optimized AMI or another operating system.
//
// The UpdateContainerAgent API isn't supported for container instances using
// the Amazon ECS-optimized Amazon Linux 2 (arm64) AMI. To update the container
// agent, you can update the ecs-init package. This updates the agent. For more
// information, see Updating the Amazon ECS container agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/agent-update-ecs-ami.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// The UpdateContainerAgent API requires an Amazon ECS-optimized AMI or Amazon
// Linux AMI with the ecs-init service installed and running. For help updating
// the Amazon ECS container agent on other operating systems, see Manually updating
// the Amazon ECS container agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html#manually_update_agent)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation UpdateContainerAgent for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - UpdateInProgressException
//     There's already a current Amazon ECS container agent update in progress on
//     the container instance that's specified. If the container agent becomes disconnected
//     while it's in a transitional stage, such as PENDING or STAGING, the update
//     process can get stuck in that state. However, when the agent reconnects,
//     it resumes where it stopped previously.
//
//   - NoUpdateAvailableException
//     There's no update available for this Amazon ECS container agent. This might
//     be because the agent is already running the latest version or because it's
//     so old that there's no update path to the current version.
//
//   - MissingVersionException
//     Amazon ECS can't determine the current version of the Amazon ECS container
//     agent on the container instance and doesn't have enough information to proceed
//     with an update. This could be because the agent running on the container
//     instance is a previous or custom version that doesn't use our version information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateContainerAgent
func (c *ECS) UpdateContainerAgent(input *UpdateContainerAgentInput) (*UpdateContainerAgentOutput, error) {
	req, out := c.UpdateContainerAgentRequest(input)
	return out, req.Send()
}

// UpdateContainerAgentWithContext is the same as UpdateContainerAgent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContainerAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) UpdateContainerAgentWithContext(ctx aws.Context, input *UpdateContainerAgentInput, opts ...request.Option) (*UpdateContainerAgentOutput, error) {
	req, out := c.UpdateContainerAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContainerInstancesState = "UpdateContainerInstancesState"

// UpdateContainerInstancesStateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContainerInstancesState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContainerInstancesState for more information on using the UpdateContainerInstancesState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContainerInstancesStateRequest method.
//	req, resp := client.UpdateContainerInstancesStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateContainerInstancesState
func (c *ECS) UpdateContainerInstancesStateRequest(input *UpdateContainerInstancesStateInput) (req *request.Request, output *UpdateContainerInstancesStateOutput) {
	op := &request.Operation{
		Name:       opUpdateContainerInstancesState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContainerInstancesStateInput{}
	}

	output = &UpdateContainerInstancesStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateContainerInstancesState API operation for Amazon EC2 Container Service.
//
// Modifies the status of an Amazon ECS container instance.
//
// Once a container instance has reached an ACTIVE state, you can change the
// status of a container instance to DRAINING to manually remove an instance
// from a cluster, for example to perform system updates, update the Docker
// daemon, or scale down the cluster size.
//
// A container instance can't be changed to DRAINING until it has reached an
// ACTIVE status. If the instance is in any other status, an error will be received.
//
// When you set a container instance to DRAINING, Amazon ECS prevents new tasks
// from being scheduled for placement on the container instance and replacement
// service tasks are started on other container instances in the cluster if
// the resources are available. Service tasks on the container instance that
// are in the PENDING state are stopped immediately.
//
// Service tasks on the container instance that are in the RUNNING state are
// stopped and replaced according to the service's deployment configuration
// parameters, minimumHealthyPercent and maximumPercent. You can change the
// deployment configuration of your service using UpdateService.
//
//   - If minimumHealthyPercent is below 100%, the scheduler can ignore desiredCount
//     temporarily during task replacement. For example, desiredCount is four
//     tasks, a minimum of 50% allows the scheduler to stop two existing tasks
//     before starting two new tasks. If the minimum is 100%, the service scheduler
//     can't remove existing tasks until the replacement tasks are considered
//     healthy. Tasks for services that do not use a load balancer are considered
//     healthy if they're in the RUNNING state. Tasks for services that use a
//     load balancer are considered healthy if they're in the RUNNING state and
//     are reported as healthy by the load balancer.
//
//   - The maximumPercent parameter represents an upper limit on the number
//     of running tasks during task replacement. You can use this to define the
//     replacement batch size. For example, if desiredCount is four tasks, a
//     maximum of 200% starts four new tasks before stopping the four tasks to
//     be drained, provided that the cluster resources required to do this are
//     available. If the maximum is 100%, then replacement tasks can't start
//     until the draining tasks have stopped.
//
// Any PENDING or RUNNING tasks that do not belong to a service aren't affected.
// You must wait for them to finish or stop them manually.
//
// A container instance has completed draining when it has no more RUNNING tasks.
// You can verify this using ListTasks.
//
// When a container instance has been drained, you can set a container instance
// to ACTIVE status and once it has reached that status the Amazon ECS scheduler
// can begin scheduling tasks on the instance again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation UpdateContainerInstancesState for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateContainerInstancesState
func (c *ECS) UpdateContainerInstancesState(input *UpdateContainerInstancesStateInput) (*UpdateContainerInstancesStateOutput, error) {
	req, out := c.UpdateContainerInstancesStateRequest(input)
	return out, req.Send()
}

// UpdateContainerInstancesStateWithContext is the same as UpdateContainerInstancesState with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContainerInstancesState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) UpdateContainerInstancesStateWithContext(ctx aws.Context, input *UpdateContainerInstancesStateInput, opts ...request.Option) (*UpdateContainerInstancesStateOutput, error) {
	req, out := c.UpdateContainerInstancesStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateService = "UpdateService"

// UpdateServiceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateService for more information on using the UpdateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceRequest method.
//	req, resp := client.UpdateServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateService
func (c *ECS) UpdateServiceRequest(input *UpdateServiceInput) (req *request.Request, output *UpdateServiceOutput) {
	op := &request.Operation{
		Name:       opUpdateService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceInput{}
	}

	output = &UpdateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateService API operation for Amazon EC2 Container Service.
//
// Modifies the parameters of a service.
//
// For services using the rolling update (ECS) you can update the desired count,
// deployment configuration, network configuration, load balancers, service
// registries, enable ECS managed tags option, propagate tags option, task placement
// constraints and strategies, and task definition. When you update any of these
// parameters, Amazon ECS starts new tasks with the new configuration.
//
// For services using the blue/green (CODE_DEPLOY) deployment controller, only
// the desired count, deployment configuration, health check grace period, task
// placement constraints and strategies, enable ECS managed tags option, and
// propagate tags can be updated using this API. If the network configuration,
// platform version, task definition, or load balancer need to be updated, create
// a new CodeDeploy deployment. For more information, see CreateDeployment (https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html)
// in the CodeDeploy API Reference.
//
// For services using an external deployment controller, you can update only
// the desired count, task placement constraints and strategies, health check
// grace period, enable ECS managed tags option, and propagate tags option,
// using this API. If the launch type, load balancer, network configuration,
// platform version, or task definition need to be updated, create a new task
// set For more information, see CreateTaskSet.
//
// You can add to or subtract from the number of instantiations of a task definition
// in a service by specifying the cluster that the service is running in and
// a new desiredCount parameter.
//
// If you have updated the Docker image of your application, you can create
// a new task definition with that image and deploy it to your service. The
// service scheduler uses the minimum healthy percent and maximum percent parameters
// (in the service's deployment configuration) to determine the deployment strategy.
//
// If your updated Docker image uses the same tag as what is in the existing
// task definition for your service (for example, my_image:latest), you don't
// need to create a new revision of your task definition. You can update the
// service using the forceNewDeployment option. The new tasks launched by the
// deployment pull the current image/tag combination from your repository when
// they start.
//
// You can also update the deployment configuration of a service. When a deployment
// is triggered by updating the task definition of a service, the service scheduler
// uses the deployment configuration parameters, minimumHealthyPercent and maximumPercent,
// to determine the deployment strategy.
//
//   - If minimumHealthyPercent is below 100%, the scheduler can ignore desiredCount
//     temporarily during a deployment. For example, if desiredCount is four
//     tasks, a minimum of 50% allows the scheduler to stop two existing tasks
//     before starting two new tasks. Tasks for services that don't use a load
//     balancer are considered healthy if they're in the RUNNING state. Tasks
//     for services that use a load balancer are considered healthy if they're
//     in the RUNNING state and are reported as healthy by the load balancer.
//
//   - The maximumPercent parameter represents an upper limit on the number
//     of running tasks during a deployment. You can use it to define the deployment
//     batch size. For example, if desiredCount is four tasks, a maximum of 200%
//     starts four new tasks before stopping the four older tasks (provided that
//     the cluster resources required to do this are available).
//
// When UpdateService stops a task during a deployment, the equivalent of docker
// stop is issued to the containers running in the task. This results in a SIGTERM
// and a 30-second timeout. After this, SIGKILL is sent and the containers are
// forcibly stopped. If the container handles the SIGTERM gracefully and exits
// within 30 seconds from receiving it, no SIGKILL is sent.
//
// When the service scheduler launches new tasks, it determines task placement
// in your cluster with the following logic.
//
//   - Determine which of the container instances in your cluster can support
//     your service's task definition. For example, they have the required CPU,
//     memory, ports, and container instance attributes.
//
//   - By default, the service scheduler attempts to balance tasks across Availability
//     Zones in this manner even though you can choose a different placement
//     strategy. Sort the valid container instances by the fewest number of running
//     tasks for this service in the same Availability Zone as the instance.
//     For example, if zone A has one running service task and zones B and C
//     each have zero, valid container instances in either zone B or C are considered
//     optimal for placement. Place the new service task on a valid container
//     instance in an optimal Availability Zone (based on the previous steps),
//     favoring container instances with the fewest number of running tasks for
//     this service.
//
// When the service scheduler stops running tasks, it attempts to maintain balance
// across the Availability Zones in your cluster using the following logic:
//
//   - Sort the container instances by the largest number of running tasks
//     for this service in the same Availability Zone as the instance. For example,
//     if zone A has one running service task and zones B and C each have two,
//     container instances in either zone B or C are considered optimal for termination.
//
//   - Stop the task on a container instance in an optimal Availability Zone
//     (based on the previous steps), favoring container instances with the largest
//     number of running tasks for this service.
//
// You must have a service-linked role when you update any of the following
// service properties. If you specified a custom IAM role when you created the
// service, Amazon ECS automatically replaces the roleARN (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Service.html#ECS-Type-Service-roleArn)
// associated with the service with the ARN of your service-linked role. For
// more information, see Service-linked roles (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html)
// in the Amazon Elastic Container Service Developer Guide.
//
//   - loadBalancers,
//
//   - serviceRegistries
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation UpdateService for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - ServiceNotFoundException
//     The specified service wasn't found. You can view your available services
//     with ListServices. Amazon ECS services are cluster specific and Region specific.
//
//   - ServiceNotActiveException
//     The specified service isn't active. You can't update a service that's inactive.
//     If you have previously deleted a service, you can re-create it with CreateService.
//
//   - PlatformUnknownException
//     The specified platform version doesn't exist.
//
//   - PlatformTaskDefinitionIncompatibilityException
//     The specified platform version doesn't satisfy the required capabilities
//     of the task definition.
//
//   - AccessDeniedException
//     You don't have authorization to perform the requested action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateService
func (c *ECS) UpdateService(input *UpdateServiceInput) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	return out, req.Send()
}

// UpdateServiceWithContext is the same as UpdateService with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) UpdateServiceWithContext(ctx aws.Context, input *UpdateServiceInput, opts ...request.Option) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServicePrimaryTaskSet = "UpdateServicePrimaryTaskSet"

// UpdateServicePrimaryTaskSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServicePrimaryTaskSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServicePrimaryTaskSet for more information on using the UpdateServicePrimaryTaskSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServicePrimaryTaskSetRequest method.
//	req, resp := client.UpdateServicePrimaryTaskSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateServicePrimaryTaskSet
func (c *ECS) UpdateServicePrimaryTaskSetRequest(input *UpdateServicePrimaryTaskSetInput) (req *request.Request, output *UpdateServicePrimaryTaskSetOutput) {
	op := &request.Operation{
		Name:       opUpdateServicePrimaryTaskSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServicePrimaryTaskSetInput{}
	}

	output = &UpdateServicePrimaryTaskSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServicePrimaryTaskSet API operation for Amazon EC2 Container Service.
//
// Modifies which task set in a service is the primary task set. Any parameters
// that are updated on the primary task set in a service will transition to
// the service. This is used when a service uses the EXTERNAL deployment controller
// type. For more information, see Amazon ECS Deployment Types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation UpdateServicePrimaryTaskSet for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - UnsupportedFeatureException
//     The specified task isn't supported in this Region.
//
//   - ServiceNotFoundException
//     The specified service wasn't found. You can view your available services
//     with ListServices. Amazon ECS services are cluster specific and Region specific.
//
//   - ServiceNotActiveException
//     The specified service isn't active. You can't update a service that's inactive.
//     If you have previously deleted a service, you can re-create it with CreateService.
//
//   - TaskSetNotFoundException
//     The specified task set wasn't found. You can view your available task sets
//     with DescribeTaskSets. Task sets are specific to each cluster, service and
//     Region.
//
//   - AccessDeniedException
//     You don't have authorization to perform the requested action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateServicePrimaryTaskSet
func (c *ECS) UpdateServicePrimaryTaskSet(input *UpdateServicePrimaryTaskSetInput) (*UpdateServicePrimaryTaskSetOutput, error) {
	req, out := c.UpdateServicePrimaryTaskSetRequest(input)
	return out, req.Send()
}

// UpdateServicePrimaryTaskSetWithContext is the same as UpdateServicePrimaryTaskSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServicePrimaryTaskSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) UpdateServicePrimaryTaskSetWithContext(ctx aws.Context, input *UpdateServicePrimaryTaskSetInput, opts ...request.Option) (*UpdateServicePrimaryTaskSetOutput, error) {
	req, out := c.UpdateServicePrimaryTaskSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTaskSet = "UpdateTaskSet"

// UpdateTaskSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTaskSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTaskSet for more information on using the UpdateTaskSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTaskSetRequest method.
//	req, resp := client.UpdateTaskSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateTaskSet
func (c *ECS) UpdateTaskSetRequest(input *UpdateTaskSetInput) (req *request.Request, output *UpdateTaskSetOutput) {
	op := &request.Operation{
		Name:       opUpdateTaskSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTaskSetInput{}
	}

	output = &UpdateTaskSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTaskSet API operation for Amazon EC2 Container Service.
//
// Modifies a task set. This is used when a service uses the EXTERNAL deployment
// controller type. For more information, see Amazon ECS Deployment Types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Service's
// API operation UpdateTaskSet for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
//   - ClientException
//     These errors are usually caused by a client action. This client action might
//     be using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource,. Or, it might be specifying an identifier
//     that isn't valid.
//
//   - InvalidParameterException
//     The specified parameter isn't valid. Review the available parameters for
//     the API request.
//
//   - ClusterNotFoundException
//     The specified cluster wasn't found. You can view your available clusters
//     with ListClusters. Amazon ECS clusters are Region specific.
//
//   - UnsupportedFeatureException
//     The specified task isn't supported in this Region.
//
//   - AccessDeniedException
//     You don't have authorization to perform the requested action.
//
//   - ServiceNotFoundException
//     The specified service wasn't found. You can view your available services
//     with ListServices. Amazon ECS services are cluster specific and Region specific.
//
//   - ServiceNotActiveException
//     The specified service isn't active. You can't update a service that's inactive.
//     If you have previously deleted a service, you can re-create it with CreateService.
//
//   - TaskSetNotFoundException
//     The specified task set wasn't found. You can view your available task sets
//     with DescribeTaskSets. Task sets are specific to each cluster, service and
//     Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateTaskSet
func (c *ECS) UpdateTaskSet(input *UpdateTaskSetInput) (*UpdateTaskSetOutput, error) {
	req, out := c.UpdateTaskSetRequest(input)
	return out, req.Send()
}

// UpdateTaskSetWithContext is the same as UpdateTaskSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTaskSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) UpdateTaskSetWithContext(ctx aws.Context, input *UpdateTaskSetInput, opts ...request.Option) (*UpdateTaskSetOutput, error) {
	req, out := c.UpdateTaskSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have authorization to perform the requested action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing a container instance or task attachment.
type Attachment struct {
	_ struct{} `type:"structure"`

	// Details of the attachment. For elastic network interfaces, this includes
	// the network interface ID, the MAC address, the subnet ID, and the private
	// IPv4 address.
	Details []*KeyValuePair `locationName:"details" type:"list"`

	// The unique identifier for the attachment.
	Id *string `locationName:"id" type:"string"`

	// The status of the attachment. Valid values are PRECREATED, CREATED, ATTACHING,
	// ATTACHED, DETACHING, DETACHED, DELETED, and FAILED.
	Status *string `locationName:"status" type:"string"`

	// The type of the attachment, such as ElasticNetworkInterface.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attachment) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *Attachment) SetDetails(v []*KeyValuePair) *Attachment {
	s.Details = v
	return s
}

// SetId sets the Id field's value.
func (s *Attachment) SetId(v string) *Attachment {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Attachment) SetStatus(v string) *Attachment {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Attachment) SetType(v string) *Attachment {
	s.Type = &v
	return s
}

// An object representing a change in state for a task attachment.
type AttachmentStateChange struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the attachment.
	//
	// AttachmentArn is a required field
	AttachmentArn *string `locationName:"attachmentArn" type:"string" required:"true"`

	// The status of the attachment.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentStateChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentStateChange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachmentStateChange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachmentStateChange"}
	if s.AttachmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AttachmentArn"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentArn sets the AttachmentArn field's value.
func (s *AttachmentStateChange) SetAttachmentArn(v string) *AttachmentStateChange {
	s.AttachmentArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AttachmentStateChange) SetStatus(v string) *AttachmentStateChange {
	s.Status = &v
	return s
}

// An attribute is a name-value pair that's associated with an Amazon ECS object.
// Use attributes to extend the Amazon ECS data model by adding custom metadata
// to your resources. For more information, see Attributes (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes)
// in the Amazon Elastic Container Service Developer Guide.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute. The name must contain between 1 and 128 characters.
	// The name may contain letters (uppercase and lowercase), numbers, hyphens
	// (-), underscores (_), forward slashes (/), back slashes (\), or periods (.).
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ID of the target. You can specify the short form ID for a resource or
	// the full Amazon Resource Name (ARN).
	TargetId *string `locationName:"targetId" type:"string"`

	// The type of the target to attach the attribute with. This parameter is required
	// if you use the short form ID for a resource instead of the full ARN.
	TargetType *string `locationName:"targetType" type:"string" enum:"TargetType"`

	// The value of the attribute. The value must contain between 1 and 128 characters.
	// It can contain letters (uppercase and lowercase), numbers, hyphens (-), underscores
	// (_), periods (.), at signs (@), forward slashes (/), back slashes (\), colons
	// (:), or spaces. The value can't can't start or end with a space.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Attribute"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Attribute) SetName(v string) *Attribute {
	s.Name = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *Attribute) SetTargetId(v string) *Attribute {
	s.TargetId = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *Attribute) SetTargetType(v string) *Attribute {
	s.TargetType = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Attribute) SetValue(v string) *Attribute {
	s.Value = &v
	return s
}

// You can apply up to 10 custom attributes for each resource. You can view
// the attributes of a resource with ListAttributes. You can remove existing
// attributes on a resource with DeleteAttributes.
type AttributeLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeLimitExceededException) GoString() string {
	return s.String()
}

func newErrorAttributeLimitExceededException(v protocol.ResponseMetadata) error {
	return &AttributeLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AttributeLimitExceededException) Code() string {
	return "AttributeLimitExceededException"
}

// Message returns the exception's message.
func (s *AttributeLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AttributeLimitExceededException) OrigErr() error {
	return nil
}

func (s *AttributeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AttributeLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AttributeLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details of the Auto Scaling group for the capacity provider.
type AutoScalingGroupProvider struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the Auto Scaling group.
	//
	// AutoScalingGroupArn is a required field
	AutoScalingGroupArn *string `locationName:"autoScalingGroupArn" type:"string" required:"true"`

	// The managed scaling settings for the Auto Scaling group capacity provider.
	ManagedScaling *ManagedScaling `locationName:"managedScaling" type:"structure"`

	// The managed termination protection setting to use for the Auto Scaling group
	// capacity provider. This determines whether the Auto Scaling group has managed
	// termination protection. The default is disabled.
	//
	// When using managed termination protection, managed scaling must also be used
	// otherwise managed termination protection doesn't work.
	//
	// When managed termination protection is enabled, Amazon ECS prevents the Amazon
	// EC2 instances in an Auto Scaling group that contain tasks from being terminated
	// during a scale-in action. The Auto Scaling group and each instance in the
	// Auto Scaling group must have instance protection from scale-in actions enabled
	// as well. For more information, see Instance Protection (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection)
	// in the Auto Scaling User Guide.
	//
	// When managed termination protection is disabled, your Amazon EC2 instances
	// aren't protected from termination when the Auto Scaling group scales in.
	ManagedTerminationProtection *string `locationName:"managedTerminationProtection" type:"string" enum:"ManagedTerminationProtection"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingGroupProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingGroupProvider) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingGroupProvider) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoScalingGroupProvider"}
	if s.AutoScalingGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupArn"))
	}
	if s.ManagedScaling != nil {
		if err := s.ManagedScaling.Validate(); err != nil {
			invalidParams.AddNested("ManagedScaling", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupArn sets the AutoScalingGroupArn field's value.
func (s *AutoScalingGroupProvider) SetAutoScalingGroupArn(v string) *AutoScalingGroupProvider {
	s.AutoScalingGroupArn = &v
	return s
}

// SetManagedScaling sets the ManagedScaling field's value.
func (s *AutoScalingGroupProvider) SetManagedScaling(v *ManagedScaling) *AutoScalingGroupProvider {
	s.ManagedScaling = v
	return s
}

// SetManagedTerminationProtection sets the ManagedTerminationProtection field's value.
func (s *AutoScalingGroupProvider) SetManagedTerminationProtection(v string) *AutoScalingGroupProvider {
	s.ManagedTerminationProtection = &v
	return s
}

// The details of the Auto Scaling group capacity provider to update.
type AutoScalingGroupProviderUpdate struct {
	_ struct{} `type:"structure"`

	// The managed scaling settings for the Auto Scaling group capacity provider.
	ManagedScaling *ManagedScaling `locationName:"managedScaling" type:"structure"`

	// The managed termination protection setting to use for the Auto Scaling group
	// capacity provider. This determines whether the Auto Scaling group has managed
	// termination protection.
	//
	// When using managed termination protection, managed scaling must also be used
	// otherwise managed termination protection doesn't work.
	//
	// When managed termination protection is enabled, Amazon ECS prevents the Amazon
	// EC2 instances in an Auto Scaling group that contain tasks from being terminated
	// during a scale-in action. The Auto Scaling group and each instance in the
	// Auto Scaling group must have instance protection from scale-in actions enabled.
	// For more information, see Instance Protection (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection)
	// in the Auto Scaling User Guide.
	//
	// When managed termination protection is disabled, your Amazon EC2 instances
	// aren't protected from termination when the Auto Scaling group scales in.
	ManagedTerminationProtection *string `locationName:"managedTerminationProtection" type:"string" enum:"ManagedTerminationProtection"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingGroupProviderUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingGroupProviderUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingGroupProviderUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoScalingGroupProviderUpdate"}
	if s.ManagedScaling != nil {
		if err := s.ManagedScaling.Validate(); err != nil {
			invalidParams.AddNested("ManagedScaling", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagedScaling sets the ManagedScaling field's value.
func (s *AutoScalingGroupProviderUpdate) SetManagedScaling(v *ManagedScaling) *AutoScalingGroupProviderUpdate {
	s.ManagedScaling = v
	return s
}

// SetManagedTerminationProtection sets the ManagedTerminationProtection field's value.
func (s *AutoScalingGroupProviderUpdate) SetManagedTerminationProtection(v string) *AutoScalingGroupProviderUpdate {
	s.ManagedTerminationProtection = &v
	return s
}

// An object representing the networking details for a task or service.
type AwsVpcConfiguration struct {
	_ struct{} `type:"structure"`

	// Whether the task's elastic network interface receives a public IP address.
	// The default value is DISABLED.
	AssignPublicIp *string `locationName:"assignPublicIp" type:"string" enum:"AssignPublicIp"`

	// The IDs of the security groups associated with the task or service. If you
	// don't specify a security group, the default security group for the VPC is
	// used. There's a limit of 5 security groups that can be specified per AwsVpcConfiguration.
	//
	// All specified security groups must be from the same VPC.
	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// The IDs of the subnets associated with the task or service. There's a limit
	// of 16 subnets that can be specified per AwsVpcConfiguration.
	//
	// All specified subnets must be from the same VPC.
	//
	// Subnets is a required field
	Subnets []*string `locationName:"subnets" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsVpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsVpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsVpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsVpcConfiguration"}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignPublicIp sets the AssignPublicIp field's value.
func (s *AwsVpcConfiguration) SetAssignPublicIp(v string) *AwsVpcConfiguration {
	s.AssignPublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsVpcConfiguration) SetSecurityGroups(v []*string) *AwsVpcConfiguration {
	s.SecurityGroups = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsVpcConfiguration) SetSubnets(v []*string) *AwsVpcConfiguration {
	s.Subnets = v
	return s
}

// Your Amazon Web Services account was blocked. For more information, contact
// Amazon Web Services Support (http://aws.amazon.com/contact-us/).
type BlockedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockedException) GoString() string {
	return s.String()
}

func newErrorBlockedException(v protocol.ResponseMetadata) error {
	return &BlockedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BlockedException) Code() string {
	return "BlockedException"
}

// Message returns the exception's message.
func (s *BlockedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BlockedException) OrigErr() error {
	return nil
}

func (s *BlockedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BlockedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BlockedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details for a capacity provider.
type CapacityProvider struct {
	_ struct{} `type:"structure"`

	// The Auto Scaling group settings for the capacity provider.
	AutoScalingGroupProvider *AutoScalingGroupProvider `locationName:"autoScalingGroupProvider" type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the capacity provider.
	CapacityProviderArn *string `locationName:"capacityProviderArn" type:"string"`

	// The name of the capacity provider.
	Name *string `locationName:"name" type:"string"`

	// The current status of the capacity provider. Only capacity providers in an
	// ACTIVE state can be used in a cluster. When a capacity provider is successfully
	// deleted, it has an INACTIVE status.
	Status *string `locationName:"status" type:"string" enum:"CapacityProviderStatus"`

	// The metadata that you apply to the capacity provider to help you categorize
	// and organize it. Each tag consists of a key and an optional value. You define
	// both.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The update status of the capacity provider. The following are the possible
	// states that is returned.
	//
	// DELETE_IN_PROGRESS
	//
	// The capacity provider is in the process of being deleted.
	//
	// DELETE_COMPLETE
	//
	// The capacity provider was successfully deleted and has an INACTIVE status.
	//
	// DELETE_FAILED
	//
	// The capacity provider can't be deleted. The update status reason provides
	// further details about why the delete failed.
	UpdateStatus *string `locationName:"updateStatus" type:"string" enum:"CapacityProviderUpdateStatus"`

	// The update status reason. This provides further details about the update
	// status for the capacity provider.
	UpdateStatusReason *string `locationName:"updateStatusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityProvider) GoString() string {
	return s.String()
}

// SetAutoScalingGroupProvider sets the AutoScalingGroupProvider field's value.
func (s *CapacityProvider) SetAutoScalingGroupProvider(v *AutoScalingGroupProvider) *CapacityProvider {
	s.AutoScalingGroupProvider = v
	return s
}

// SetCapacityProviderArn sets the CapacityProviderArn field's value.
func (s *CapacityProvider) SetCapacityProviderArn(v string) *CapacityProvider {
	s.CapacityProviderArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CapacityProvider) SetName(v string) *CapacityProvider {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CapacityProvider) SetStatus(v string) *CapacityProvider {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CapacityProvider) SetTags(v []*Tag) *CapacityProvider {
	s.Tags = v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *CapacityProvider) SetUpdateStatus(v string) *CapacityProvider {
	s.UpdateStatus = &v
	return s
}

// SetUpdateStatusReason sets the UpdateStatusReason field's value.
func (s *CapacityProvider) SetUpdateStatusReason(v string) *CapacityProvider {
	s.UpdateStatusReason = &v
	return s
}

// The details of a capacity provider strategy. A capacity provider strategy
// can be set when using the RunTask or CreateCluster APIs or as the default
// capacity provider strategy for a cluster with the CreateCluster API.
//
// Only capacity providers that are already associated with a cluster and have
// an ACTIVE or UPDATING status can be used in a capacity provider strategy.
// The PutClusterCapacityProviders API is used to associate a capacity provider
// with a cluster.
//
// If specifying a capacity provider that uses an Auto Scaling group, the capacity
// provider must already be created. New Auto Scaling group capacity providers
// can be created with the CreateCapacityProvider API operation.
//
// To use a Fargate capacity provider, specify either the FARGATE or FARGATE_SPOT
// capacity providers. The Fargate capacity providers are available to all accounts
// and only need to be associated with a cluster to be used in a capacity provider
// strategy.
//
// A capacity provider strategy may contain a maximum of 6 capacity providers.
type CapacityProviderStrategyItem struct {
	_ struct{} `type:"structure"`

	// The base value designates how many tasks, at a minimum, to run on the specified
	// capacity provider. Only one capacity provider in a capacity provider strategy
	// can have a base defined. If no value is specified, the default value of 0
	// is used.
	Base *int64 `locationName:"base" type:"integer"`

	// The short name of the capacity provider.
	//
	// CapacityProvider is a required field
	CapacityProvider *string `locationName:"capacityProvider" type:"string" required:"true"`

	// The weight value designates the relative percentage of the total number of
	// tasks launched that should use the specified capacity provider. The weight
	// value is taken into consideration after the base value, if defined, is satisfied.
	//
	// If no weight value is specified, the default value of 0 is used. When multiple
	// capacity providers are specified within a capacity provider strategy, at
	// least one of the capacity providers must have a weight value greater than
	// zero and any capacity providers with a weight of 0 can't be used to place
	// tasks. If you specify multiple capacity providers in a strategy that all
	// have a weight of 0, any RunTask or CreateService actions using the capacity
	// provider strategy will fail.
	//
	// An example scenario for using weights is defining a strategy that contains
	// two capacity providers and both have a weight of 1, then when the base is
	// satisfied, the tasks will be split evenly across the two capacity providers.
	// Using that same logic, if you specify a weight of 1 for capacityProviderA
	// and a weight of 4 for capacityProviderB, then for every one task that's run
	// using capacityProviderA, four tasks would use capacityProviderB.
	Weight *int64 `locationName:"weight" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityProviderStrategyItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityProviderStrategyItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapacityProviderStrategyItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CapacityProviderStrategyItem"}
	if s.CapacityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("CapacityProvider"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBase sets the Base field's value.
func (s *CapacityProviderStrategyItem) SetBase(v int64) *CapacityProviderStrategyItem {
	s.Base = &v
	return s
}

// SetCapacityProvider sets the CapacityProvider field's value.
func (s *CapacityProviderStrategyItem) SetCapacityProvider(v string) *CapacityProviderStrategyItem {
	s.CapacityProvider = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *CapacityProviderStrategyItem) SetWeight(v int64) *CapacityProviderStrategyItem {
	s.Weight = &v
	return s
}

// These errors are usually caused by a client action. This client action might
// be using an action or resource on behalf of a user that doesn't have permissions
// to use the action or resource,. Or, it might be specifying an identifier
// that isn't valid.
type ClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientException) GoString() string {
	return s.String()
}

func newErrorClientException(v protocol.ResponseMetadata) error {
	return &ClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClientException) Code() string {
	return "ClientException"
}

// Message returns the exception's message.
func (s *ClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClientException) OrigErr() error {
	return nil
}

func (s *ClientException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A regional grouping of one or more container instances where you can run
// task requests. Each account receives a default cluster the first time you
// use the Amazon ECS service, but you may also create other clusters. Clusters
// may contain more than one instance type simultaneously.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The number of services that are running on the cluster in an ACTIVE state.
	// You can view these services with ListServices.
	ActiveServicesCount *int64 `locationName:"activeServicesCount" type:"integer"`

	// The resources attached to a cluster. When using a capacity provider with
	// a cluster, the capacity provider and associated resources are returned as
	// cluster attachments.
	Attachments []*Attachment `locationName:"attachments" type:"list"`

	// The status of the capacity providers associated with the cluster. The following
	// are the states that are returned.
	//
	// UPDATE_IN_PROGRESS
	//
	// The available capacity providers for the cluster are updating.
	//
	// UPDATE_COMPLETE
	//
	// The capacity providers have successfully updated.
	//
	// UPDATE_FAILED
	//
	// The capacity provider updates failed.
	AttachmentsStatus *string `locationName:"attachmentsStatus" type:"string"`

	// The capacity providers associated with the cluster.
	CapacityProviders []*string `locationName:"capacityProviders" type:"list"`

	// The Amazon Resource Name (ARN) that identifies the cluster. For more information
	// about the ARN format, see Amazon Resource Name (ARN) (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids)
	// in the Amazon ECS Developer Guide.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// A user-generated string that you use to identify your cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The execute command configuration for the cluster.
	Configuration *ClusterConfiguration `locationName:"configuration" type:"structure"`

	// The default capacity provider strategy for the cluster. When services or
	// tasks are run in the cluster with no launch type or capacity provider strategy
	// specified, the default capacity provider strategy is used.
	DefaultCapacityProviderStrategy []*CapacityProviderStrategyItem `locationName:"defaultCapacityProviderStrategy" type:"list"`

	// The number of tasks in the cluster that are in the PENDING state.
	PendingTasksCount *int64 `locationName:"pendingTasksCount" type:"integer"`

	// The number of container instances registered into the cluster. This includes
	// container instances in both ACTIVE and DRAINING status.
	RegisteredContainerInstancesCount *int64 `locationName:"registeredContainerInstancesCount" type:"integer"`

	// The number of tasks in the cluster that are in the RUNNING state.
	RunningTasksCount *int64 `locationName:"runningTasksCount" type:"integer"`

	// The settings for the cluster. This parameter indicates whether CloudWatch
	// Container Insights is enabled or disabled for a cluster.
	Settings []*ClusterSetting `locationName:"settings" type:"list"`

	// Additional information about your clusters that are separated by launch type.
	// They include the following:
	//
	//    * runningEC2TasksCount
	//
	//    * RunningFargateTasksCount
	//
	//    * pendingEC2TasksCount
	//
	//    * pendingFargateTasksCount
	//
	//    * activeEC2ServiceCount
	//
	//    * activeFargateServiceCount
	//
	//    * drainingEC2ServiceCount
	//
	//    * drainingFargateServiceCount
	Statistics []*KeyValuePair `locationName:"statistics" type:"list"`

	// The status of the cluster. The following are the possible states that are
	// returned.
	//
	// ACTIVE
	//
	// The cluster is ready to accept tasks and if applicable you can register container
	// instances with the cluster.
	//
	// PROVISIONING
	//
	// The cluster has capacity providers that are associated with it and the resources
	// needed for the capacity provider are being created.
	//
	// DEPROVISIONING
	//
	// The cluster has capacity providers that are associated with it and the resources
	// needed for the capacity provider are being deleted.
	//
	// FAILED
	//
	// The cluster has capacity providers that are associated with it and the resources
	// needed for the capacity provider have failed to create.
	//
	// INACTIVE
	//
	// The cluster has been deleted. Clusters with an INACTIVE status may remain
	// discoverable in your account for a period of time. However, this behavior
	// is subject to change in the future. We don't recommend that you rely on INACTIVE
	// clusters persisting.
	Status *string `locationName:"status" type:"string"`

	// The metadata that you apply to the cluster to help you categorize and organize
	// them. Each tag consists of a key and an optional value. You define both.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) GoString() string {
	return s.String()
}

// SetActiveServicesCount sets the ActiveServicesCount field's value.
func (s *Cluster) SetActiveServicesCount(v int64) *Cluster {
	s.ActiveServicesCount = &v
	return s
}

// SetAttachments sets the Attachments field's value.
func (s *Cluster) SetAttachments(v []*Attachment) *Cluster {
	s.Attachments = v
	return s
}

// SetAttachmentsStatus sets the AttachmentsStatus field's value.
func (s *Cluster) SetAttachmentsStatus(v string) *Cluster {
	s.AttachmentsStatus = &v
	return s
}

// SetCapacityProviders sets the CapacityProviders field's value.
func (s *Cluster) SetCapacityProviders(v []*string) *Cluster {
	s.CapacityProviders = v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *Cluster) SetClusterArn(v string) *Cluster {
	s.ClusterArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *Cluster) SetClusterName(v string) *Cluster {
	s.ClusterName = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *Cluster) SetConfiguration(v *ClusterConfiguration) *Cluster {
	s.Configuration = v
	return s
}

// SetDefaultCapacityProviderStrategy sets the DefaultCapacityProviderStrategy field's value.
func (s *Cluster) SetDefaultCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *Cluster {
	s.DefaultCapacityProviderStrategy = v
	return s
}

// SetPendingTasksCount sets the PendingTasksCount field's value.
func (s *Cluster) SetPendingTasksCount(v int64) *Cluster {
	s.PendingTasksCount = &v
	return s
}

// SetRegisteredContainerInstancesCount sets the RegisteredContainerInstancesCount field's value.
func (s *Cluster) SetRegisteredContainerInstancesCount(v int64) *Cluster {
	s.RegisteredContainerInstancesCount = &v
	return s
}

// SetRunningTasksCount sets the RunningTasksCount field's value.
func (s *Cluster) SetRunningTasksCount(v int64) *Cluster {
	s.RunningTasksCount = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *Cluster) SetSettings(v []*ClusterSetting) *Cluster {
	s.Settings = v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *Cluster) SetStatistics(v []*KeyValuePair) *Cluster {
	s.Statistics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Cluster) SetStatus(v string) *Cluster {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Cluster) SetTags(v []*Tag) *Cluster {
	s.Tags = v
	return s
}

// The execute command configuration for the cluster.
type ClusterConfiguration struct {
	_ struct{} `type:"structure"`

	// The details of the execute command configuration.
	ExecuteCommandConfiguration *ExecuteCommandConfiguration `locationName:"executeCommandConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterConfiguration) GoString() string {
	return s.String()
}

// SetExecuteCommandConfiguration sets the ExecuteCommandConfiguration field's value.
func (s *ClusterConfiguration) SetExecuteCommandConfiguration(v *ExecuteCommandConfiguration) *ClusterConfiguration {
	s.ExecuteCommandConfiguration = v
	return s
}

// You can't delete a cluster that has registered container instances. First,
// deregister the container instances before you can delete the cluster. For
// more information, see DeregisterContainerInstance.
type ClusterContainsContainerInstancesException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterContainsContainerInstancesException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterContainsContainerInstancesException) GoString() string {
	return s.String()
}

func newErrorClusterContainsContainerInstancesException(v protocol.ResponseMetadata) error {
	return &ClusterContainsContainerInstancesException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClusterContainsContainerInstancesException) Code() string {
	return "ClusterContainsContainerInstancesException"
}

// Message returns the exception's message.
func (s *ClusterContainsContainerInstancesException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClusterContainsContainerInstancesException) OrigErr() error {
	return nil
}

func (s *ClusterContainsContainerInstancesException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClusterContainsContainerInstancesException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClusterContainsContainerInstancesException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You can't delete a cluster that contains services. First, update the service
// to reduce its desired task count to 0, and then delete the service. For more
// information, see UpdateService and DeleteService.
type ClusterContainsServicesException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterContainsServicesException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterContainsServicesException) GoString() string {
	return s.String()
}

func newErrorClusterContainsServicesException(v protocol.ResponseMetadata) error {
	return &ClusterContainsServicesException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClusterContainsServicesException) Code() string {
	return "ClusterContainsServicesException"
}

// Message returns the exception's message.
func (s *ClusterContainsServicesException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClusterContainsServicesException) OrigErr() error {
	return nil
}

func (s *ClusterContainsServicesException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClusterContainsServicesException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClusterContainsServicesException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You can't delete a cluster that has active tasks.
type ClusterContainsTasksException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterContainsTasksException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterContainsTasksException) GoString() string {
	return s.String()
}

func newErrorClusterContainsTasksException(v protocol.ResponseMetadata) error {
	return &ClusterContainsTasksException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClusterContainsTasksException) Code() string {
	return "ClusterContainsTasksException"
}

// Message returns the exception's message.
func (s *ClusterContainsTasksException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClusterContainsTasksException) OrigErr() error {
	return nil
}

func (s *ClusterContainsTasksException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClusterContainsTasksException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClusterContainsTasksException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified cluster wasn't found. You can view your available clusters
// with ListClusters. Amazon ECS clusters are Region specific.
type ClusterNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterNotFoundException) GoString() string {
	return s.String()
}

func newErrorClusterNotFoundException(v protocol.ResponseMetadata) error {
	return &ClusterNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClusterNotFoundException) Code() string {
	return "ClusterNotFoundException"
}

// Message returns the exception's message.
func (s *ClusterNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClusterNotFoundException) OrigErr() error {
	return nil
}

func (s *ClusterNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClusterNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClusterNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The settings to use when creating a cluster. This parameter is used to turn
// on CloudWatch Container Insights for a cluster.
type ClusterSetting struct {
	_ struct{} `type:"structure"`

	// The name of the cluster setting. The only supported value is containerInsights.
	Name *string `locationName:"name" type:"string" enum:"ClusterSettingName"`

	// The value to set for the cluster setting. The supported values are enabled
	// and disabled. If enabled is specified, CloudWatch Container Insights will
	// be enabled for the cluster, otherwise it will be disabled unless the containerInsights
	// account setting is enabled. If a cluster value is specified, it will override
	// the containerInsights value set with PutAccountSetting or PutAccountSettingDefault.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterSetting) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ClusterSetting) SetName(v string) *ClusterSetting {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ClusterSetting) SetValue(v string) *ClusterSetting {
	s.Value = &v
	return s
}

// A Docker container that's part of a task.
type Container struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the container.
	ContainerArn *string `locationName:"containerArn" type:"string"`

	// The number of CPU units set for the container. The value is 0 if no value
	// was specified in the container definition when the task definition was registered.
	Cpu *string `locationName:"cpu" type:"string"`

	// The exit code returned from the container.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The IDs of each GPU assigned to the container.
	GpuIds []*string `locationName:"gpuIds" type:"list"`

	// The health status of the container. If health checks aren't configured for
	// this container in its task definition, then it reports the health status
	// as UNKNOWN.
	HealthStatus *string `locationName:"healthStatus" type:"string" enum:"HealthStatus"`

	// The image used for the container.
	Image *string `locationName:"image" type:"string"`

	// The container image manifest digest.
	//
	// The imageDigest is only returned if the container is using an image hosted
	// in Amazon ECR, otherwise it is omitted.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// The last known status of the container.
	LastStatus *string `locationName:"lastStatus" type:"string"`

	// The details of any Amazon ECS managed agents associated with the container.
	ManagedAgents []*ManagedAgent `locationName:"managedAgents" type:"list"`

	// The hard limit (in MiB) of memory set for the container.
	Memory *string `locationName:"memory" type:"string"`

	// The soft limit (in MiB) of memory set for the container.
	MemoryReservation *string `locationName:"memoryReservation" type:"string"`

	// The name of the container.
	Name *string `locationName:"name" type:"string"`

	// The network bindings associated with the container.
	NetworkBindings []*NetworkBinding `locationName:"networkBindings" type:"list"`

	// The network interfaces associated with the container.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// A short (255 max characters) human-readable string to provide additional
	// details about a running or stopped container.
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the Docker container.
	RuntimeId *string `locationName:"runtimeId" type:"string"`

	// The ARN of the task.
	TaskArn *string `locationName:"taskArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Container) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Container) GoString() string {
	return s.String()
}

// SetContainerArn sets the ContainerArn field's value.
func (s *Container) SetContainerArn(v string) *Container {
	s.ContainerArn = &v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *Container) SetCpu(v string) *Container {
	s.Cpu = &v
	return s
}

// SetExitCode sets the ExitCode field's value.
func (s *Container) SetExitCode(v int64) *Container {
	s.ExitCode = &v
	return s
}

// SetGpuIds sets the GpuIds field's value.
func (s *Container) SetGpuIds(v []*string) *Container {
	s.GpuIds = v
	return s
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *Container) SetHealthStatus(v string) *Container {
	s.HealthStatus = &v
	return s
}

// SetImage sets the Image field's value.
func (s *Container) SetImage(v string) *Container {
	s.Image = &v
	return s
}

// SetImageDigest sets the ImageDigest field's value.
func (s *Container) SetImageDigest(v string) *Container {
	s.ImageDigest = &v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *Container) SetLastStatus(v string) *Container {
	s.LastStatus = &v
	return s
}

// SetManagedAgents sets the ManagedAgents field's value.
func (s *Container) SetManagedAgents(v []*ManagedAgent) *Container {
	s.ManagedAgents = v
	return s
}

// SetMemory sets the Memory field's value.
func (s *Container) SetMemory(v string) *Container {
	s.Memory = &v
	return s
}

// SetMemoryReservation sets the MemoryReservation field's value.
func (s *Container) SetMemoryReservation(v string) *Container {
	s.MemoryReservation = &v
	return s
}

// SetName sets the Name field's value.
func (s *Container) SetName(v string) *Container {
	s.Name = &v
	return s
}

// SetNetworkBindings sets the NetworkBindings field's value.
func (s *Container) SetNetworkBindings(v []*NetworkBinding) *Container {
	s.NetworkBindings = v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *Container) SetNetworkInterfaces(v []*NetworkInterface) *Container {
	s.NetworkInterfaces = v
	return s
}

// SetReason sets the Reason field's value.
func (s *Container) SetReason(v string) *Container {
	s.Reason = &v
	return s
}

// SetRuntimeId sets the RuntimeId field's value.
func (s *Container) SetRuntimeId(v string) *Container {
	s.RuntimeId = &v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *Container) SetTaskArn(v string) *Container {
	s.TaskArn = &v
	return s
}

// Container definitions are used in task definitions to describe the different
// containers that are launched as part of a task.
type ContainerDefinition struct {
	_ struct{} `type:"structure"`

	// The command that's passed to the container. This parameter maps to Cmd in
	// the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the COMMAND parameter to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	// For more information, see https://docs.docker.com/engine/reference/builder/#cmd
	// (https://docs.docker.com/engine/reference/builder/#cmd). If there are multiple
	// arguments, each argument is a separated string in the array.
	Command []*string `locationName:"command" type:"list"`

	// The number of cpu units reserved for the container. This parameter maps to
	// CpuShares in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --cpu-shares option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// This field is optional for tasks using the Fargate launch type, and the only
	// requirement is that the total amount of CPU reserved for all containers within
	// a task be lower than the task-level cpu value.
	//
	// You can determine the number of CPU units that are available per EC2 instance
	// type by multiplying the vCPUs listed for that instance type on the Amazon
	// EC2 Instances (http://aws.amazon.com/ec2/instance-types/) detail page by
	// 1,024.
	//
	// Linux containers share unallocated CPU units with other containers on the
	// container instance with the same ratio as their allocated amount. For example,
	// if you run a single-container task on a single-core instance type with 512
	// CPU units specified for that container, and that's the only task running
	// on the container instance, that container could use the full 1,024 CPU unit
	// share at any given time. However, if you launched another copy of the same
	// task on that container instance, each task is guaranteed a minimum of 512
	// CPU units when needed. Moreover, each container could float to higher CPU
	// usage if the other container was not using it. If both tasks were 100% active
	// all of the time, they would be limited to 512 CPU units.
	//
	// On Linux container instances, the Docker daemon on the container instance
	// uses the CPU value to calculate the relative CPU share ratios for running
	// containers. For more information, see CPU share constraint (https://docs.docker.com/engine/reference/run/#cpu-share-constraint)
	// in the Docker documentation. The minimum valid CPU share value that the Linux
	// kernel allows is 2. However, the CPU parameter isn't required, and you can
	// use CPU values below 2 in your container definitions. For CPU values below
	// 2 (including null), the behavior varies based on your Amazon ECS container
	// agent version:
	//
	//    * Agent versions less than or equal to 1.1.0: Null and zero CPU values
	//    are passed to Docker as 0, which Docker then converts to 1,024 CPU shares.
	//    CPU values of 1 are passed to Docker as 1, which the Linux kernel converts
	//    to two CPU shares.
	//
	//    * Agent versions greater than or equal to 1.2.0: Null, zero, and CPU values
	//    of 1 are passed to Docker as 2.
	//
	// On Windows container instances, the CPU limit is enforced as an absolute
	// limit, or a quota. Windows containers only have access to the specified amount
	// of CPU that's described in the task definition. A null or zero CPU value
	// is passed to Docker as 0, which Windows interprets as 1% of one CPU.
	Cpu *int64 `locationName:"cpu" type:"integer"`

	// The dependencies defined for container startup and shutdown. A container
	// can contain multiple dependencies. When a dependency is defined for container
	// startup, for container shutdown it is reversed.
	//
	// For tasks using the EC2 launch type, the container instances require at least
	// version 1.26.0 of the container agent to turn on container dependencies.
	// However, we recommend using the latest container agent version. For information
	// about checking your agent version and updating to the latest version, see
	// Updating the Amazon ECS Container Agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html)
	// in the Amazon Elastic Container Service Developer Guide. If you're using
	// an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1
	// of the ecs-init package. If your container instances are launched from version
	// 20190301 or later, then they contain the required versions of the container
	// agent and ecs-init. For more information, see Amazon ECS-optimized Linux
	// AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// For tasks using the Fargate launch type, the task or service requires the
	// following platforms:
	//
	//    * Linux platform version 1.3.0 or later.
	//
	//    * Windows platform version 1.0.0 or later.
	DependsOn []*ContainerDependency `locationName:"dependsOn" type:"list"`

	// When this parameter is true, networking is disabled within the container.
	// This parameter maps to NetworkDisabled in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/).
	//
	// This parameter is not supported for Windows containers.
	DisableNetworking *bool `locationName:"disableNetworking" type:"boolean"`

	// A list of DNS search domains that are presented to the container. This parameter
	// maps to DnsSearch in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --dns-search option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// This parameter is not supported for Windows containers.
	DnsSearchDomains []*string `locationName:"dnsSearchDomains" type:"list"`

	// A list of DNS servers that are presented to the container. This parameter
	// maps to Dns in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --dns option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// This parameter is not supported for Windows containers.
	DnsServers []*string `locationName:"dnsServers" type:"list"`

	// A key/value map of labels to add to the container. This parameter maps to
	// Labels in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --label option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	DockerLabels map[string]*string `locationName:"dockerLabels" type:"map"`

	// A list of strings to provide custom labels for SELinux and AppArmor multi-level
	// security systems. This field isn't valid for containers in tasks using the
	// Fargate launch type.
	//
	// With Windows containers, this parameter can be used to reference a credential
	// spec file when configuring a container for Active Directory authentication.
	// For more information, see Using gMSAs for Windows Containers (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// This parameter maps to SecurityOpt in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --security-opt option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// The Amazon ECS container agent running on a container instance must register
	// with the ECS_SELINUX_CAPABLE=true or ECS_APPARMOR_CAPABLE=true environment
	// variables before containers placed on that instance can use these security
	// options. For more information, see Amazon ECS Container Agent Configuration
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// For more information about valid values, see Docker Run Security Configuration
	// (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// Valid values: "no-new-privileges" | "apparmor:PROFILE" | "label:value" |
	// "credentialspec:CredentialSpecFilePath"
	DockerSecurityOptions []*string `locationName:"dockerSecurityOptions" type:"list"`

	//
	// Early versions of the Amazon ECS container agent don't properly handle entryPoint
	// parameters. If you have problems using entryPoint, update your container
	// agent or enter your commands and arguments as command array items instead.
	//
	// The entry point that's passed to the container. This parameter maps to Entrypoint
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --entrypoint option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	// For more information, see https://docs.docker.com/engine/reference/builder/#entrypoint
	// (https://docs.docker.com/engine/reference/builder/#entrypoint).
	EntryPoint []*string `locationName:"entryPoint" type:"list"`

	// The environment variables to pass to a container. This parameter maps to
	// Env in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --env option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// We don't recommend that you use plaintext environment variables for sensitive
	// information, such as credential data.
	Environment []*KeyValuePair `locationName:"environment" type:"list"`

	// A list of files containing the environment variables to pass to a container.
	// This parameter maps to the --env-file option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// You can specify up to ten environment files. The file must have a .env file
	// extension. Each line in an environment file contains an environment variable
	// in VARIABLE=VALUE format. Lines beginning with # are treated as comments
	// and are ignored. For more information about the environment variable file
	// syntax, see Declare default environment variables in file (https://docs.docker.com/compose/env-file/).
	//
	// If there are environment variables specified using the environment parameter
	// in a container definition, they take precedence over the variables contained
	// within an environment file. If multiple environment files are specified that
	// contain the same variable, they're processed from the top down. We recommend
	// that you use unique variable names. For more information, see Specifying
	// Environment Variables (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	EnvironmentFiles []*EnvironmentFile `locationName:"environmentFiles" type:"list"`

	// If the essential parameter of a container is marked as true, and that container
	// fails or stops for any reason, all other containers that are part of the
	// task are stopped. If the essential parameter of a container is marked as
	// false, its failure doesn't affect the rest of the containers in a task. If
	// this parameter is omitted, a container is assumed to be essential.
	//
	// All tasks must have at least one essential container. If you have an application
	// that's composed of multiple containers, group containers that are used for
	// a common purpose into components, and separate the different components into
	// multiple task definitions. For more information, see Application Architecture
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Essential *bool `locationName:"essential" type:"boolean"`

	// A list of hostnames and IP address mappings to append to the /etc/hosts file
	// on the container. This parameter maps to ExtraHosts in the Create a container
	// (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section
	// of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/) and
	// the --add-host option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// This parameter isn't supported for Windows containers or tasks that use the
	// awsvpc network mode.
	ExtraHosts []*HostEntry `locationName:"extraHosts" type:"list"`

	// The FireLens configuration for the container. This is used to specify and
	// configure a log router for container logs. For more information, see Custom
	// Log Routing (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html)
	// in the Amazon Elastic Container Service Developer Guide.
	FirelensConfiguration *FirelensConfiguration `locationName:"firelensConfiguration" type:"structure"`

	// The container health check command and associated configuration parameters
	// for the container. This parameter maps to HealthCheck in the Create a container
	// (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section
	// of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/) and
	// the HEALTHCHECK parameter of docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	HealthCheck *HealthCheck `locationName:"healthCheck" type:"structure"`

	// The hostname to use for your container. This parameter maps to Hostname in
	// the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --hostname option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// The hostname parameter is not supported if you're using the awsvpc network
	// mode.
	Hostname *string `locationName:"hostname" type:"string"`

	// The image used to start a container. This string is passed directly to the
	// Docker daemon. By default, images in the Docker Hub registry are available.
	// Other repositories are specified with either repository-url/image:tag or
	// repository-url/image@digest . Up to 255 letters (uppercase and lowercase),
	// numbers, hyphens, underscores, colons, periods, forward slashes, and number
	// signs are allowed. This parameter maps to Image in the Create a container
	// (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section
	// of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/) and
	// the IMAGE parameter of docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	//    * When a new task starts, the Amazon ECS container agent pulls the latest
	//    version of the specified image and tag for the container to use. However,
	//    subsequent updates to a repository image aren't propagated to already
	//    running tasks.
	//
	//    * Images in Amazon ECR repositories can be specified by either using the
	//    full registry/repository:tag or registry/repository@digest. For example,
	//    012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest
	//    or 012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE.
	//
	//    * Images in official repositories on Docker Hub use a single name (for
	//    example, ubuntu or mongo).
	//
	//    * Images in other repositories on Docker Hub are qualified with an organization
	//    name (for example, amazon/amazon-ecs-agent).
	//
	//    * Images in other online repositories are qualified further by a domain
	//    name (for example, quay.io/assemblyline/ubuntu).
	Image *string `locationName:"image" type:"string"`

	// When this parameter is true, you can deploy containerized applications that
	// require stdin or a tty to be allocated. This parameter maps to OpenStdin
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --interactive option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	Interactive *bool `locationName:"interactive" type:"boolean"`

	// The links parameter allows containers to communicate with each other without
	// the need for port mappings. This parameter is only supported if the network
	// mode of a task definition is bridge. The name:internalName construct is analogous
	// to name:alias in Docker links. Up to 255 letters (uppercase and lowercase),
	// numbers, underscores, and hyphens are allowed. For more information about
	// linking Docker containers, go to Legacy container links (https://docs.docker.com/network/links/)
	// in the Docker documentation. This parameter maps to Links in the Create a
	// container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --link option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// This parameter is not supported for Windows containers.
	//
	// Containers that are collocated on a single container instance may be able
	// to communicate with each other without requiring links or host port mappings.
	// Network isolation is achieved on the container instance using security groups
	// and VPC settings.
	Links []*string `locationName:"links" type:"list"`

	// Linux-specific modifications that are applied to the container, such as Linux
	// kernel capabilities. For more information see KernelCapabilities.
	//
	// This parameter is not supported for Windows containers.
	LinuxParameters *LinuxParameters `locationName:"linuxParameters" type:"structure"`

	// The log configuration specification for the container.
	//
	// This parameter maps to LogConfig in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --log-driver option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	// By default, containers use the same logging driver that the Docker daemon
	// uses. However the container can use a different logging driver than the Docker
	// daemon by specifying a log driver with this parameter in the container definition.
	// To use a different logging driver for a container, the log system must be
	// configured properly on the container instance (or on a different log server
	// for remote logging options). For more information about the options for different
	// supported log drivers, see Configure logging drivers (https://docs.docker.com/engine/admin/logging/overview/)
	// in the Docker documentation.
	//
	// Amazon ECS currently supports a subset of the logging drivers available to
	// the Docker daemon (shown in the LogConfiguration data type). Additional log
	// drivers may be available in future releases of the Amazon ECS container agent.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	//
	// The Amazon ECS container agent running on a container instance must register
	// the logging drivers available on that instance with the ECS_AVAILABLE_LOGGING_DRIVERS
	// environment variable before containers placed on that instance can use these
	// log configuration options. For more information, see Amazon ECS Container
	// Agent Configuration (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LogConfiguration *LogConfiguration `locationName:"logConfiguration" type:"structure"`

	// The amount (in MiB) of memory to present to the container. If your container
	// attempts to exceed the memory specified here, the container is killed. The
	// total amount of memory reserved for all containers within a task must be
	// lower than the task memory value, if one is specified. This parameter maps
	// to Memory in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --memory option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// If using the Fargate launch type, this parameter is optional.
	//
	// If using the EC2 launch type, you must specify either a task-level memory
	// value or a container-level memory value. If you specify both a container-level
	// memory and memoryReservation value, memory must be greater than memoryReservation.
	// If you specify memoryReservation, then that value is subtracted from the
	// available memory resources for the container instance where the container
	// is placed. Otherwise, the value of memory is used.
	//
	// The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory
	// for a container. So, don't specify less than 6 MiB of memory for your containers.
	//
	// The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory
	// for a container. So, don't specify less than 4 MiB of memory for your containers.
	Memory *int64 `locationName:"memory" type:"integer"`

	// The soft limit (in MiB) of memory to reserve for the container. When system
	// memory is under heavy contention, Docker attempts to keep the container memory
	// to this soft limit. However, your container can consume more memory when
	// it needs to, up to either the hard limit specified with the memory parameter
	// (if applicable), or all of the available memory on the container instance,
	// whichever comes first. This parameter maps to MemoryReservation in the Create
	// a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --memory-reservation option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// If a task-level memory value is not specified, you must specify a non-zero
	// integer for one or both of memory or memoryReservation in a container definition.
	// If you specify both, memory must be greater than memoryReservation. If you
	// specify memoryReservation, then that value is subtracted from the available
	// memory resources for the container instance where the container is placed.
	// Otherwise, the value of memory is used.
	//
	// For example, if your container normally uses 128 MiB of memory, but occasionally
	// bursts to 256 MiB of memory for short periods of time, you can set a memoryReservation
	// of 128 MiB, and a memory hard limit of 300 MiB. This configuration would
	// allow the container to only reserve 128 MiB of memory from the remaining
	// resources on the container instance, but also allow the container to consume
	// more memory resources when needed.
	//
	// The Docker daemon reserves a minimum of 4 MiB of memory for a container.
	// Therefore, we recommend that you specify fewer than 4 MiB of memory for your
	// containers.
	MemoryReservation *int64 `locationName:"memoryReservation" type:"integer"`

	// The mount points for data volumes in your container.
	//
	// This parameter maps to Volumes in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --volume option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// Windows containers can mount whole directories on the same drive as $env:ProgramData.
	// Windows containers can't mount directories on a different drive, and mount
	// point can't be across drives.
	MountPoints []*MountPoint `locationName:"mountPoints" type:"list"`

	// The name of a container. If you're linking multiple containers together in
	// a task definition, the name of one container can be entered in the links
	// of another container to connect the containers. Up to 255 letters (uppercase
	// and lowercase), numbers, underscores, and hyphens are allowed. This parameter
	// maps to name in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --name option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	Name *string `locationName:"name" type:"string"`

	// The list of port mappings for the container. Port mappings allow containers
	// to access ports on the host container instance to send or receive traffic.
	//
	// For task definitions that use the awsvpc network mode, only specify the containerPort.
	// The hostPort can be left blank or it must be the same value as the containerPort.
	//
	// Port mappings on Windows use the NetNAT gateway address rather than localhost.
	// There's no loopback for port mappings on Windows, so you can't access a container's
	// mapped port from the host itself.
	//
	// This parameter maps to PortBindings in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --publish option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	// If the network mode of a task definition is set to none, then you can't specify
	// port mappings. If the network mode of a task definition is set to host, then
	// host ports must either be undefined or they must match the container port
	// in the port mapping.
	//
	// After a task reaches the RUNNING status, manual and automatic host and container
	// port assignments are visible in the Network Bindings section of a container
	// description for a selected task in the Amazon ECS console. The assignments
	// are also visible in the networkBindings section DescribeTasks responses.
	PortMappings []*PortMapping `locationName:"portMappings" type:"list"`

	// When this parameter is true, the container is given elevated privileges on
	// the host container instance (similar to the root user). This parameter maps
	// to Privileged in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --privileged option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// This parameter is not supported for Windows containers or tasks run on Fargate.
	Privileged *bool `locationName:"privileged" type:"boolean"`

	// When this parameter is true, a TTY is allocated. This parameter maps to Tty
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --tty option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	PseudoTerminal *bool `locationName:"pseudoTerminal" type:"boolean"`

	// When this parameter is true, the container is given read-only access to its
	// root file system. This parameter maps to ReadonlyRootfs in the Create a container
	// (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section
	// of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/) and
	// the --read-only option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// This parameter is not supported for Windows containers.
	ReadonlyRootFilesystem *bool `locationName:"readonlyRootFilesystem" type:"boolean"`

	// The private repository authentication credentials to use.
	RepositoryCredentials *RepositoryCredentials `locationName:"repositoryCredentials" type:"structure"`

	// The type and amount of a resource to assign to a container. The only supported
	// resource is a GPU.
	ResourceRequirements []*ResourceRequirement `locationName:"resourceRequirements" type:"list"`

	// The secrets to pass to the container. For more information, see Specifying
	// Sensitive Data (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Secrets []*Secret `locationName:"secrets" type:"list"`

	// Time duration (in seconds) to wait before giving up on resolving dependencies
	// for a container. For example, you specify two containers in a task definition
	// with containerA having a dependency on containerB reaching a COMPLETE, SUCCESS,
	// or HEALTHY status. If a startTimeout value is specified for containerB and
	// it doesn't reach the desired status within that time then containerA gives
	// up and not start. This results in the task transitioning to a STOPPED state.
	//
	// When the ECS_CONTAINER_START_TIMEOUT container agent configuration variable
	// is used, it's enforced independently from this start timeout value.
	//
	// For tasks using the Fargate launch type, the task or service requires the
	// following platforms:
	//
	//    * Linux platform version 1.3.0 or later.
	//
	//    * Windows platform version 1.0.0 or later.
	//
	// For tasks using the EC2 launch type, your container instances require at
	// least version 1.26.0 of the container agent to use a container start timeout
	// value. However, we recommend using the latest container agent version. For
	// information about checking your agent version and updating to the latest
	// version, see Updating the Amazon ECS Container Agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html)
	// in the Amazon Elastic Container Service Developer Guide. If you're using
	// an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1
	// of the ecs-init package. If your container instances are launched from version
	// 20190301 or later, then they contain the required versions of the container
	// agent and ecs-init. For more information, see Amazon ECS-optimized Linux
	// AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
	// in the Amazon Elastic Container Service Developer Guide.
	StartTimeout *int64 `locationName:"startTimeout" type:"integer"`

	// Time duration (in seconds) to wait before the container is forcefully killed
	// if it doesn't exit normally on its own.
	//
	// For tasks using the Fargate launch type, the task or service requires the
	// following platforms:
	//
	//    * Linux platform version 1.3.0 or later.
	//
	//    * Windows platform version 1.0.0 or later.
	//
	// The max stop timeout value is 120 seconds and if the parameter is not specified,
	// the default value of 30 seconds is used.
	//
	// For tasks that use the EC2 launch type, if the stopTimeout parameter isn't
	// specified, the value set for the Amazon ECS container agent configuration
	// variable ECS_CONTAINER_STOP_TIMEOUT is used. If neither the stopTimeout parameter
	// or the ECS_CONTAINER_STOP_TIMEOUT agent configuration variable are set, then
	// the default values of 30 seconds for Linux containers and 30 seconds on Windows
	// containers are used. Your container instances require at least version 1.26.0
	// of the container agent to use a container stop timeout value. However, we
	// recommend using the latest container agent version. For information about
	// checking your agent version and updating to the latest version, see Updating
	// the Amazon ECS Container Agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html)
	// in the Amazon Elastic Container Service Developer Guide. If you're using
	// an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1
	// of the ecs-init package. If your container instances are launched from version
	// 20190301 or later, then they contain the required versions of the container
	// agent and ecs-init. For more information, see Amazon ECS-optimized Linux
	// AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
	// in the Amazon Elastic Container Service Developer Guide.
	StopTimeout *int64 `locationName:"stopTimeout" type:"integer"`

	// A list of namespaced kernel parameters to set in the container. This parameter
	// maps to Sysctls in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --sysctl option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// We don't recommended that you specify network-related systemControls parameters
	// for multiple containers in a single task that also uses either the awsvpc
	// or host network modes. For tasks that use the awsvpc network mode, the container
	// that's started last determines which systemControls parameters take effect.
	// For tasks that use the host network mode, it changes the container instance's
	// namespaced kernel parameters as well as the containers.
	SystemControls []*SystemControl `locationName:"systemControls" type:"list"`

	// A list of ulimits to set in the container. If a ulimit value is specified
	// in a task definition, it overrides the default values set by Docker. This
	// parameter maps to Ulimits in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --ulimit option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	// Valid naming values are displayed in the Ulimit data type.
	//
	// Amazon ECS tasks hosted on Fargate use the default resource limit values
	// set by the operating system with the exception of the nofile resource limit
	// parameter which Fargate overrides. The nofile resource limit sets a restriction
	// on the number of open files that a container can use. The default nofile
	// soft limit is 1024 and hard limit is 4096.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	//
	// This parameter is not supported for Windows containers.
	Ulimits []*Ulimit `locationName:"ulimits" type:"list"`

	// The user to use inside the container. This parameter maps to User in the
	// Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --user option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// When running tasks using the host network mode, don't run containers using
	// the root user (UID 0). We recommend using a non-root user for better security.
	//
	// You can specify the user using the following formats. If specifying a UID
	// or GID, you must specify it as a positive integer.
	//
	//    * user
	//
	//    * user:group
	//
	//    * uid
	//
	//    * uid:gid
	//
	//    * user:gid
	//
	//    * uid:group
	//
	// This parameter is not supported for Windows containers.
	User *string `locationName:"user" type:"string"`

	// Data volumes to mount from another container. This parameter maps to VolumesFrom
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --volumes-from option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	VolumesFrom []*VolumeFrom `locationName:"volumesFrom" type:"list"`

	// The working directory to run commands inside the container in. This parameter
	// maps to WorkingDir in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --workdir option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	WorkingDirectory *string `locationName:"workingDirectory" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerDefinition"}
	if s.DependsOn != nil {
		for i, v := range s.DependsOn {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DependsOn", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EnvironmentFiles != nil {
		for i, v := range s.EnvironmentFiles {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EnvironmentFiles", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ExtraHosts != nil {
		for i, v := range s.ExtraHosts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExtraHosts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FirelensConfiguration != nil {
		if err := s.FirelensConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FirelensConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.HealthCheck != nil {
		if err := s.HealthCheck.Validate(); err != nil {
			invalidParams.AddNested("HealthCheck", err.(request.ErrInvalidParams))
		}
	}
	if s.LinuxParameters != nil {
		if err := s.LinuxParameters.Validate(); err != nil {
			invalidParams.AddNested("LinuxParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.LogConfiguration != nil {
		if err := s.LogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LogConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RepositoryCredentials != nil {
		if err := s.RepositoryCredentials.Validate(); err != nil {
			invalidParams.AddNested("RepositoryCredentials", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceRequirements != nil {
		for i, v := range s.ResourceRequirements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRequirements", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Secrets != nil {
		for i, v := range s.Secrets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Secrets", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Ulimits != nil {
		for i, v := range s.Ulimits {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ulimits", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *ContainerDefinition) SetCommand(v []*string) *ContainerDefinition {
	s.Command = v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *ContainerDefinition) SetCpu(v int64) *ContainerDefinition {
	s.Cpu = &v
	return s
}

// SetDependsOn sets the DependsOn field's value.
func (s *ContainerDefinition) SetDependsOn(v []*ContainerDependency) *ContainerDefinition {
	s.DependsOn = v
	return s
}

// SetDisableNetworking sets the DisableNetworking field's value.
func (s *ContainerDefinition) SetDisableNetworking(v bool) *ContainerDefinition {
	s.DisableNetworking = &v
	return s
}

// SetDnsSearchDomains sets the DnsSearchDomains field's value.
func (s *ContainerDefinition) SetDnsSearchDomains(v []*string) *ContainerDefinition {
	s.DnsSearchDomains = v
	return s
}

// SetDnsServers sets the DnsServers field's value.
func (s *ContainerDefinition) SetDnsServers(v []*string) *ContainerDefinition {
	s.DnsServers = v
	return s
}

// SetDockerLabels sets the DockerLabels field's value.
func (s *ContainerDefinition) SetDockerLabels(v map[string]*string) *ContainerDefinition {
	s.DockerLabels = v
	return s
}

// SetDockerSecurityOptions sets the DockerSecurityOptions field's value.
func (s *ContainerDefinition) SetDockerSecurityOptions(v []*string) *ContainerDefinition {
	s.DockerSecurityOptions = v
	return s
}

// SetEntryPoint sets the EntryPoint field's value.
func (s *ContainerDefinition) SetEntryPoint(v []*string) *ContainerDefinition {
	s.EntryPoint = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *ContainerDefinition) SetEnvironment(v []*KeyValuePair) *ContainerDefinition {
	s.Environment = v
	return s
}

// SetEnvironmentFiles sets the EnvironmentFiles field's value.
func (s *ContainerDefinition) SetEnvironmentFiles(v []*EnvironmentFile) *ContainerDefinition {
	s.EnvironmentFiles = v
	return s
}

// SetEssential sets the Essential field's value.
func (s *ContainerDefinition) SetEssential(v bool) *ContainerDefinition {
	s.Essential = &v
	return s
}

// SetExtraHosts sets the ExtraHosts field's value.
func (s *ContainerDefinition) SetExtraHosts(v []*HostEntry) *ContainerDefinition {
	s.ExtraHosts = v
	return s
}

// SetFirelensConfiguration sets the FirelensConfiguration field's value.
func (s *ContainerDefinition) SetFirelensConfiguration(v *FirelensConfiguration) *ContainerDefinition {
	s.FirelensConfiguration = v
	return s
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *ContainerDefinition) SetHealthCheck(v *HealthCheck) *ContainerDefinition {
	s.HealthCheck = v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *ContainerDefinition) SetHostname(v string) *ContainerDefinition {
	s.Hostname = &v
	return s
}

// SetImage sets the Image field's value.
func (s *ContainerDefinition) SetImage(v string) *ContainerDefinition {
	s.Image = &v
	return s
}

// SetInteractive sets the Interactive field's value.
func (s *ContainerDefinition) SetInteractive(v bool) *ContainerDefinition {
	s.Interactive = &v
	return s
}

// SetLinks sets the Links field's value.
func (s *ContainerDefinition) SetLinks(v []*string) *ContainerDefinition {
	s.Links = v
	return s
}

// SetLinuxParameters sets the LinuxParameters field's value.
func (s *ContainerDefinition) SetLinuxParameters(v *LinuxParameters) *ContainerDefinition {
	s.LinuxParameters = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *ContainerDefinition) SetLogConfiguration(v *LogConfiguration) *ContainerDefinition {
	s.LogConfiguration = v
	return s
}

// SetMemory sets the Memory field's value.
func (s *ContainerDefinition) SetMemory(v int64) *ContainerDefinition {
	s.Memory = &v
	return s
}

// SetMemoryReservation sets the MemoryReservation field's value.
func (s *ContainerDefinition) SetMemoryReservation(v int64) *ContainerDefinition {
	s.MemoryReservation = &v
	return s
}

// SetMountPoints sets the MountPoints field's value.
func (s *ContainerDefinition) SetMountPoints(v []*MountPoint) *ContainerDefinition {
	s.MountPoints = v
	return s
}

// SetName sets the Name field's value.
func (s *ContainerDefinition) SetName(v string) *ContainerDefinition {
	s.Name = &v
	return s
}

// SetPortMappings sets the PortMappings field's value.
func (s *ContainerDefinition) SetPortMappings(v []*PortMapping) *ContainerDefinition {
	s.PortMappings = v
	return s
}

// SetPrivileged sets the Privileged field's value.
func (s *ContainerDefinition) SetPrivileged(v bool) *ContainerDefinition {
	s.Privileged = &v
	return s
}

// SetPseudoTerminal sets the PseudoTerminal field's value.
func (s *ContainerDefinition) SetPseudoTerminal(v bool) *ContainerDefinition {
	s.PseudoTerminal = &v
	return s
}

// SetReadonlyRootFilesystem sets the ReadonlyRootFilesystem field's value.
func (s *ContainerDefinition) SetReadonlyRootFilesystem(v bool) *ContainerDefinition {
	s.ReadonlyRootFilesystem = &v
	return s
}

// SetRepositoryCredentials sets the RepositoryCredentials field's value.
func (s *ContainerDefinition) SetRepositoryCredentials(v *RepositoryCredentials) *ContainerDefinition {
	s.RepositoryCredentials = v
	return s
}

// SetResourceRequirements sets the ResourceRequirements field's value.
func (s *ContainerDefinition) SetResourceRequirements(v []*ResourceRequirement) *ContainerDefinition {
	s.ResourceRequirements = v
	return s
}

// SetSecrets sets the Secrets field's value.
func (s *ContainerDefinition) SetSecrets(v []*Secret) *ContainerDefinition {
	s.Secrets = v
	return s
}

// SetStartTimeout sets the StartTimeout field's value.
func (s *ContainerDefinition) SetStartTimeout(v int64) *ContainerDefinition {
	s.StartTimeout = &v
	return s
}

// SetStopTimeout sets the StopTimeout field's value.
func (s *ContainerDefinition) SetStopTimeout(v int64) *ContainerDefinition {
	s.StopTimeout = &v
	return s
}

// SetSystemControls sets the SystemControls field's value.
func (s *ContainerDefinition) SetSystemControls(v []*SystemControl) *ContainerDefinition {
	s.SystemControls = v
	return s
}

// SetUlimits sets the Ulimits field's value.
func (s *ContainerDefinition) SetUlimits(v []*Ulimit) *ContainerDefinition {
	s.Ulimits = v
	return s
}

// SetUser sets the User field's value.
func (s *ContainerDefinition) SetUser(v string) *ContainerDefinition {
	s.User = &v
	return s
}

// SetVolumesFrom sets the VolumesFrom field's value.
func (s *ContainerDefinition) SetVolumesFrom(v []*VolumeFrom) *ContainerDefinition {
	s.VolumesFrom = v
	return s
}

// SetWorkingDirectory sets the WorkingDirectory field's value.
func (s *ContainerDefinition) SetWorkingDirectory(v string) *ContainerDefinition {
	s.WorkingDirectory = &v
	return s
}

// The dependencies defined for container startup and shutdown. A container
// can contain multiple dependencies. When a dependency is defined for container
// startup, for container shutdown it is reversed.
//
// Your Amazon ECS container instances require at least version 1.26.0 of the
// container agent to use container dependencies. However, we recommend using
// the latest container agent version. For information about checking your agent
// version and updating to the latest version, see Updating the Amazon ECS Container
// Agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html)
// in the Amazon Elastic Container Service Developer Guide. If you're using
// an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1
// of the ecs-init package. If your container instances are launched from version
// 20190301 or later, then they contain the required versions of the container
// agent and ecs-init. For more information, see Amazon ECS-optimized Linux
// AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// For tasks that use the Fargate launch type, the task or service requires
// the following platforms:
//
//   - Linux platform version 1.3.0 or later.
//
//   - Windows platform version 1.0.0 or later.
type ContainerDependency struct {
	_ struct{} `type:"structure"`

	// The dependency condition of the container. The following are the available
	// conditions and their behavior:
	//
	//    * START - This condition emulates the behavior of links and volumes today.
	//    It validates that a dependent container is started before permitting other
	//    containers to start.
	//
	//    * COMPLETE - This condition validates that a dependent container runs
	//    to completion (exits) before permitting other containers to start. This
	//    can be useful for nonessential containers that run a script and then exit.
	//    This condition can't be set on an essential container.
	//
	//    * SUCCESS - This condition is the same as COMPLETE, but it also requires
	//    that the container exits with a zero status. This condition can't be set
	//    on an essential container.
	//
	//    * HEALTHY - This condition validates that the dependent container passes
	//    its Docker health check before permitting other containers to start. This
	//    requires that the dependent container has health checks configured. This
	//    condition is confirmed only at task startup.
	//
	// Condition is a required field
	Condition *string `locationName:"condition" type:"string" required:"true" enum:"ContainerCondition"`

	// The name of a container.
	//
	// ContainerName is a required field
	ContainerName *string `locationName:"containerName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerDependency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerDependency) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerDependency) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerDependency"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *ContainerDependency) SetCondition(v string) *ContainerDependency {
	s.Condition = &v
	return s
}

// SetContainerName sets the ContainerName field's value.
func (s *ContainerDependency) SetContainerName(v string) *ContainerDependency {
	s.ContainerName = &v
	return s
}

// An Amazon EC2 or External instance that's running the Amazon ECS agent and
// has been registered with a cluster.
type ContainerInstance struct {
	_ struct{} `type:"structure"`

	// This parameter returns true if the agent is connected to Amazon ECS. An instance
	// with an agent that may be unhealthy or stopped return false. Only instances
	// connected to an agent can accept task placement requests.
	AgentConnected *bool `locationName:"agentConnected" type:"boolean"`

	// The status of the most recent agent update. If an update wasn't ever requested,
	// this value is NULL.
	AgentUpdateStatus *string `locationName:"agentUpdateStatus" type:"string" enum:"AgentUpdateStatus"`

	// The resources attached to a container instance, such as an elastic network
	// interface.
	Attachments []*Attachment `locationName:"attachments" type:"list"`

	// The attributes set for the container instance, either by the Amazon ECS container
	// agent at instance registration or manually with the PutAttributes operation.
	Attributes []*Attribute `locationName:"attributes" type:"list"`

	// The capacity provider that's associated with the container instance.
	CapacityProviderName *string `locationName:"capacityProviderName" type:"string"`

	// The Amazon Resource Name (ARN) of the container instance. For more information
	// about the ARN format, see Amazon Resource Name (ARN) (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids)
	// in the Amazon ECS Developer Guide.
	ContainerInstanceArn *string `locationName:"containerInstanceArn" type:"string"`

	// The ID of the container instance. For Amazon EC2 instances, this value is
	// the Amazon EC2 instance ID. For external instances, this value is the Amazon
	// Web Services Systems Manager managed instance ID.
	Ec2InstanceId *string `locationName:"ec2InstanceId" type:"string"`

	// An object representing the health status of the container instance.
	HealthStatus *ContainerInstanceHealthStatus `locationName:"healthStatus" type:"structure"`

	// The number of tasks on the container instance that are in the PENDING status.
	PendingTasksCount *int64 `locationName:"pendingTasksCount" type:"integer"`

	// The Unix timestamp for the time when the container instance was registered.
	RegisteredAt *time.Time `locationName:"registeredAt" type:"timestamp"`

	// For CPU and memory resource types, this parameter describes the amount of
	// each resource that was available on the container instance when the container
	// agent registered it with Amazon ECS. This value represents the total amount
	// of CPU and memory that can be allocated on this container instance to tasks.
	// For port resource types, this parameter describes the ports that were reserved
	// by the Amazon ECS container agent when it registered the container instance
	// with Amazon ECS.
	RegisteredResources []*Resource `locationName:"registeredResources" type:"list"`

	// For CPU and memory resource types, this parameter describes the remaining
	// CPU and memory that wasn't already allocated to tasks and is therefore available
	// for new tasks. For port resource types, this parameter describes the ports
	// that were reserved by the Amazon ECS container agent (at instance registration
	// time) and any task containers that have reserved port mappings on the host
	// (with the host or bridge network mode). Any port that's not specified here
	// is available for new tasks.
	RemainingResources []*Resource `locationName:"remainingResources" type:"list"`

	// The number of tasks on the container instance that are in the RUNNING status.
	RunningTasksCount *int64 `locationName:"runningTasksCount" type:"integer"`

	// The status of the container instance. The valid values are REGISTERING, REGISTRATION_FAILED,
	// ACTIVE, INACTIVE, DEREGISTERING, or DRAINING.
	//
	// If your account has opted in to the awsvpcTrunking account setting, then
	// any newly registered container instance will transition to a REGISTERING
	// status while the trunk elastic network interface is provisioned for the instance.
	// If the registration fails, the instance will transition to a REGISTRATION_FAILED
	// status. You can describe the container instance and see the reason for failure
	// in the statusReason parameter. Once the container instance is terminated,
	// the instance transitions to a DEREGISTERING status while the trunk elastic
	// network interface is deprovisioned. The instance then transitions to an INACTIVE
	// status.
	//
	// The ACTIVE status indicates that the container instance can accept tasks.
	// The DRAINING indicates that new tasks aren't placed on the container instance
	// and any service tasks running on the container instance are removed if possible.
	// For more information, see Container instance draining (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-draining.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Status *string `locationName:"status" type:"string"`

	// The reason that the container instance reached its current status.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The metadata that you apply to the container instance to help you categorize
	// and organize them. Each tag consists of a key and an optional value. You
	// define both.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The version counter for the container instance. Every time a container instance
	// experiences a change that triggers a CloudWatch event, the version counter
	// is incremented. If you're replicating your Amazon ECS container instance
	// state with CloudWatch Events, you can compare the version of a container
	// instance reported by the Amazon ECS APIs with the version reported in CloudWatch
	// Events for the container instance (inside the detail object) to verify that
	// the version in your event stream is current.
	Version *int64 `locationName:"version" type:"long"`

	// The version information for the Amazon ECS container agent and Docker daemon
	// running on the container instance.
	VersionInfo *VersionInfo `locationName:"versionInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerInstance) GoString() string {
	return s.String()
}

// SetAgentConnected sets the AgentConnected field's value.
func (s *ContainerInstance) SetAgentConnected(v bool) *ContainerInstance {
	s.AgentConnected = &v
	return s
}

// SetAgentUpdateStatus sets the AgentUpdateStatus field's value.
func (s *ContainerInstance) SetAgentUpdateStatus(v string) *ContainerInstance {
	s.AgentUpdateStatus = &v
	return s
}

// SetAttachments sets the Attachments field's value.
func (s *ContainerInstance) SetAttachments(v []*Attachment) *ContainerInstance {
	s.Attachments = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *ContainerInstance) SetAttributes(v []*Attribute) *ContainerInstance {
	s.Attributes = v
	return s
}

// SetCapacityProviderName sets the CapacityProviderName field's value.
func (s *ContainerInstance) SetCapacityProviderName(v string) *ContainerInstance {
	s.CapacityProviderName = &v
	return s
}

// SetContainerInstanceArn sets the ContainerInstanceArn field's value.
func (s *ContainerInstance) SetContainerInstanceArn(v string) *ContainerInstance {
	s.ContainerInstanceArn = &v
	return s
}

// SetEc2InstanceId sets the Ec2InstanceId field's value.
func (s *ContainerInstance) SetEc2InstanceId(v string) *ContainerInstance {
	s.Ec2InstanceId = &v
	return s
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *ContainerInstance) SetHealthStatus(v *ContainerInstanceHealthStatus) *ContainerInstance {
	s.HealthStatus = v
	return s
}

// SetPendingTasksCount sets the PendingTasksCount field's value.
func (s *ContainerInstance) SetPendingTasksCount(v int64) *ContainerInstance {
	s.PendingTasksCount = &v
	return s
}

// SetRegisteredAt sets the RegisteredAt field's value.
func (s *ContainerInstance) SetRegisteredAt(v time.Time) *ContainerInstance {
	s.RegisteredAt = &v
	return s
}

// SetRegisteredResources sets the RegisteredResources field's value.
func (s *ContainerInstance) SetRegisteredResources(v []*Resource) *ContainerInstance {
	s.RegisteredResources = v
	return s
}

// SetRemainingResources sets the RemainingResources field's value.
func (s *ContainerInstance) SetRemainingResources(v []*Resource) *ContainerInstance {
	s.RemainingResources = v
	return s
}

// SetRunningTasksCount sets the RunningTasksCount field's value.
func (s *ContainerInstance) SetRunningTasksCount(v int64) *ContainerInstance {
	s.RunningTasksCount = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ContainerInstance) SetStatus(v string) *ContainerInstance {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ContainerInstance) SetStatusReason(v string) *ContainerInstance {
	s.StatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ContainerInstance) SetTags(v []*Tag) *ContainerInstance {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *ContainerInstance) SetVersion(v int64) *ContainerInstance {
	s.Version = &v
	return s
}

// SetVersionInfo sets the VersionInfo field's value.
func (s *ContainerInstance) SetVersionInfo(v *VersionInfo) *ContainerInstance {
	s.VersionInfo = v
	return s
}

// An object representing the health status of the container instance.
type ContainerInstanceHealthStatus struct {
	_ struct{} `type:"structure"`

	// An array of objects representing the details of the container instance health
	// status.
	Details []*InstanceHealthCheckResult `locationName:"details" type:"list"`

	// The overall health status of the container instance. This is an aggregate
	// status of all container instance health checks.
	OverallStatus *string `locationName:"overallStatus" type:"string" enum:"InstanceHealthCheckState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerInstanceHealthStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerInstanceHealthStatus) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *ContainerInstanceHealthStatus) SetDetails(v []*InstanceHealthCheckResult) *ContainerInstanceHealthStatus {
	s.Details = v
	return s
}

// SetOverallStatus sets the OverallStatus field's value.
func (s *ContainerInstanceHealthStatus) SetOverallStatus(v string) *ContainerInstanceHealthStatus {
	s.OverallStatus = &v
	return s
}

// The overrides that are sent to a container. An empty container override can
// be passed in. An example of an empty container override is {"containerOverrides":
// [ ] }. If a non-empty container override is specified, the name parameter
// must be included.
type ContainerOverride struct {
	_ struct{} `type:"structure"`

	// The command to send to the container that overrides the default command from
	// the Docker image or the task definition. You must also specify a container
	// name.
	Command []*string `locationName:"command" type:"list"`

	// The number of cpu units reserved for the container, instead of the default
	// value from the task definition. You must also specify a container name.
	Cpu *int64 `locationName:"cpu" type:"integer"`

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch, or you can override
	// the existing environment variables from the Docker image or the task definition.
	// You must also specify a container name.
	Environment []*KeyValuePair `locationName:"environment" type:"list"`

	// A list of files containing the environment variables to pass to a container,
	// instead of the value from the container definition.
	EnvironmentFiles []*EnvironmentFile `locationName:"environmentFiles" type:"list"`

	// The hard limit (in MiB) of memory to present to the container, instead of
	// the default value from the task definition. If your container attempts to
	// exceed the memory specified here, the container is killed. You must also
	// specify a container name.
	Memory *int64 `locationName:"memory" type:"integer"`

	// The soft limit (in MiB) of memory to reserve for the container, instead of
	// the default value from the task definition. You must also specify a container
	// name.
	MemoryReservation *int64 `locationName:"memoryReservation" type:"integer"`

	// The name of the container that receives the override. This parameter is required
	// if any override is specified.
	Name *string `locationName:"name" type:"string"`

	// The type and amount of a resource to assign to a container, instead of the
	// default value from the task definition. The only supported resource is a
	// GPU.
	ResourceRequirements []*ResourceRequirement `locationName:"resourceRequirements" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerOverride"}
	if s.EnvironmentFiles != nil {
		for i, v := range s.EnvironmentFiles {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EnvironmentFiles", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceRequirements != nil {
		for i, v := range s.ResourceRequirements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRequirements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *ContainerOverride) SetCommand(v []*string) *ContainerOverride {
	s.Command = v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *ContainerOverride) SetCpu(v int64) *ContainerOverride {
	s.Cpu = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *ContainerOverride) SetEnvironment(v []*KeyValuePair) *ContainerOverride {
	s.Environment = v
	return s
}

// SetEnvironmentFiles sets the EnvironmentFiles field's value.
func (s *ContainerOverride) SetEnvironmentFiles(v []*EnvironmentFile) *ContainerOverride {
	s.EnvironmentFiles = v
	return s
}

// SetMemory sets the Memory field's value.
func (s *ContainerOverride) SetMemory(v int64) *ContainerOverride {
	s.Memory = &v
	return s
}

// SetMemoryReservation sets the MemoryReservation field's value.
func (s *ContainerOverride) SetMemoryReservation(v int64) *ContainerOverride {
	s.MemoryReservation = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContainerOverride) SetName(v string) *ContainerOverride {
	s.Name = &v
	return s
}

// SetResourceRequirements sets the ResourceRequirements field's value.
func (s *ContainerOverride) SetResourceRequirements(v []*ResourceRequirement) *ContainerOverride {
	s.ResourceRequirements = v
	return s
}

// An object that represents a change in state for a container.
type ContainerStateChange struct {
	_ struct{} `type:"structure"`

	// The name of the container.
	ContainerName *string `locationName:"containerName" type:"string"`

	// The exit code for the container, if the state change is a result of the container
	// exiting.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The container image SHA 256 digest.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// Any network bindings that are associated with the container.
	NetworkBindings []*NetworkBinding `locationName:"networkBindings" type:"list"`

	// The reason for the state change.
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the Docker container.
	RuntimeId *string `locationName:"runtimeId" type:"string"`

	// The status of the container.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerStateChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerStateChange) GoString() string {
	return s.String()
}

// SetContainerName sets the ContainerName field's value.
func (s *ContainerStateChange) SetContainerName(v string) *ContainerStateChange {
	s.ContainerName = &v
	return s
}

// SetExitCode sets the ExitCode field's value.
func (s *ContainerStateChange) SetExitCode(v int64) *ContainerStateChange {
	s.ExitCode = &v
	return s
}

// SetImageDigest sets the ImageDigest field's value.
func (s *ContainerStateChange) SetImageDigest(v string) *ContainerStateChange {
	s.ImageDigest = &v
	return s
}

// SetNetworkBindings sets the NetworkBindings field's value.
func (s *ContainerStateChange) SetNetworkBindings(v []*NetworkBinding) *ContainerStateChange {
	s.NetworkBindings = v
	return s
}

// SetReason sets the Reason field's value.
func (s *ContainerStateChange) SetReason(v string) *ContainerStateChange {
	s.Reason = &v
	return s
}

// SetRuntimeId sets the RuntimeId field's value.
func (s *ContainerStateChange) SetRuntimeId(v string) *ContainerStateChange {
	s.RuntimeId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ContainerStateChange) SetStatus(v string) *ContainerStateChange {
	s.Status = &v
	return s
}

type CreateCapacityProviderInput struct {
	_ struct{} `type:"structure"`

	// The details of the Auto Scaling group for the capacity provider.
	//
	// AutoScalingGroupProvider is a required field
	AutoScalingGroupProvider *AutoScalingGroupProvider `locationName:"autoScalingGroupProvider" type:"structure" required:"true"`

	// The name of the capacity provider. Up to 255 characters are allowed. They
	// include letters (both upper and lowercase letters), numbers, underscores
	// (_), and hyphens (-). The name can't be prefixed with "aws", "ecs", or "fargate".
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The metadata that you apply to the capacity provider to categorize and organize
	// them more conveniently. Each tag consists of a key and an optional value.
	// You define both of them.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCapacityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCapacityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCapacityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCapacityProviderInput"}
	if s.AutoScalingGroupProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupProvider"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.AutoScalingGroupProvider != nil {
		if err := s.AutoScalingGroupProvider.Validate(); err != nil {
			invalidParams.AddNested("AutoScalingGroupProvider", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupProvider sets the AutoScalingGroupProvider field's value.
func (s *CreateCapacityProviderInput) SetAutoScalingGroupProvider(v *AutoScalingGroupProvider) *CreateCapacityProviderInput {
	s.AutoScalingGroupProvider = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCapacityProviderInput) SetName(v string) *CreateCapacityProviderInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCapacityProviderInput) SetTags(v []*Tag) *CreateCapacityProviderInput {
	s.Tags = v
	return s
}

type CreateCapacityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the new capacity provider.
	CapacityProvider *CapacityProvider `locationName:"capacityProvider" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCapacityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCapacityProviderOutput) GoString() string {
	return s.String()
}

// SetCapacityProvider sets the CapacityProvider field's value.
func (s *CreateCapacityProviderOutput) SetCapacityProvider(v *CapacityProvider) *CreateCapacityProviderOutput {
	s.CapacityProvider = v
	return s
}

type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// The short name of one or more capacity providers to associate with the cluster.
	// A capacity provider must be associated with a cluster before it can be included
	// as part of the default capacity provider strategy of the cluster or used
	// in a capacity provider strategy when calling the CreateService or RunTask
	// actions.
	//
	// If specifying a capacity provider that uses an Auto Scaling group, the capacity
	// provider must be created but not associated with another cluster. New Auto
	// Scaling group capacity providers can be created with the CreateCapacityProvider
	// API operation.
	//
	// To use a Fargate capacity provider, specify either the FARGATE or FARGATE_SPOT
	// capacity providers. The Fargate capacity providers are available to all accounts
	// and only need to be associated with a cluster to be used.
	//
	// The PutClusterCapacityProviders API operation is used to update the list
	// of available capacity providers for a cluster after the cluster is created.
	CapacityProviders []*string `locationName:"capacityProviders" type:"list"`

	// The name of your cluster. If you don't specify a name for your cluster, you
	// create a cluster that's named default. Up to 255 letters (uppercase and lowercase),
	// numbers, underscores, and hyphens are allowed.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The execute command configuration for the cluster.
	Configuration *ClusterConfiguration `locationName:"configuration" type:"structure"`

	// The capacity provider strategy to set as the default for the cluster. After
	// a default capacity provider strategy is set for a cluster, when you call
	// the RunTask or CreateService APIs with no capacity provider strategy or launch
	// type specified, the default capacity provider strategy for the cluster is
	// used.
	//
	// If a default capacity provider strategy isn't defined for a cluster when
	// it was created, it can be defined later with the PutClusterCapacityProviders
	// API operation.
	DefaultCapacityProviderStrategy []*CapacityProviderStrategyItem `locationName:"defaultCapacityProviderStrategy" type:"list"`

	// The setting to use when creating a cluster. This parameter is used to turn
	// on CloudWatch Container Insights for a cluster. If this value is specified,
	// it overrides the containerInsights value set with PutAccountSetting or PutAccountSettingDefault.
	Settings []*ClusterSetting `locationName:"settings" type:"list"`

	// The metadata that you apply to the cluster to help you categorize and organize
	// them. Each tag consists of a key and an optional value. You define both.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.DefaultCapacityProviderStrategy != nil {
		for i, v := range s.DefaultCapacityProviderStrategy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DefaultCapacityProviderStrategy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityProviders sets the CapacityProviders field's value.
func (s *CreateClusterInput) SetCapacityProviders(v []*string) *CreateClusterInput {
	s.CapacityProviders = v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterInput) SetClusterName(v string) *CreateClusterInput {
	s.ClusterName = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateClusterInput) SetConfiguration(v *ClusterConfiguration) *CreateClusterInput {
	s.Configuration = v
	return s
}

// SetDefaultCapacityProviderStrategy sets the DefaultCapacityProviderStrategy field's value.
func (s *CreateClusterInput) SetDefaultCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *CreateClusterInput {
	s.DefaultCapacityProviderStrategy = v
	return s
}

// SetSettings sets the Settings field's value.
func (s *CreateClusterInput) SetSettings(v []*ClusterSetting) *CreateClusterInput {
	s.Settings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v []*Tag) *CreateClusterInput {
	s.Tags = v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your new cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *CreateClusterOutput) SetCluster(v *Cluster) *CreateClusterOutput {
	s.Cluster = v
	return s
}

type CreateServiceInput struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy to use for the service.
	//
	// If a capacityProviderStrategy is specified, the launchType parameter must
	// be omitted. If no capacityProviderStrategy or launchType is specified, the
	// defaultCapacityProviderStrategy for the cluster is used.
	//
	// A capacity provider strategy may contain a maximum of 6 capacity providers.
	CapacityProviderStrategy []*CapacityProviderStrategyItem `locationName:"capacityProviderStrategy" type:"list"`

	// An identifier that you provide to ensure the idempotency of the request.
	// It must be unique and is case sensitive. Up to 32 ASCII characters are allowed.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that you
	// run your service on. If you do not specify a cluster, the default cluster
	// is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// Optional deployment parameters that control how many tasks run during the
	// deployment and the ordering of stopping and starting tasks.
	DeploymentConfiguration *DeploymentConfiguration `locationName:"deploymentConfiguration" type:"structure"`

	// The deployment controller to use for the service. If no deployment controller
	// is specified, the default value of ECS is used.
	DeploymentController *DeploymentController `locationName:"deploymentController" type:"structure"`

	// The number of instantiations of the specified task definition to place and
	// keep running on your cluster.
	//
	// This is required if schedulingStrategy is REPLICA or isn't specified. If
	// schedulingStrategy is DAEMON then this isn't required.
	DesiredCount *int64 `locationName:"desiredCount" type:"integer"`

	// Specifies whether to turn on Amazon ECS managed tags for the tasks within
	// the service. For more information, see Tagging your Amazon ECS resources
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
	// in the Amazon Elastic Container Service Developer Guide.
	EnableECSManagedTags *bool `locationName:"enableECSManagedTags" type:"boolean"`

	// Determines whether the execute command functionality is enabled for the service.
	// If true, this enables execute command functionality on all containers in
	// the service tasks.
	EnableExecuteCommand *bool `locationName:"enableExecuteCommand" type:"boolean"`

	// The period of time, in seconds, that the Amazon ECS service scheduler ignores
	// unhealthy Elastic Load Balancing target health checks after a task has first
	// started. This is only used when your service is configured to use a load
	// balancer. If your service has a load balancer defined and you don't specify
	// a health check grace period value, the default value of 0 is used.
	//
	// If you do not use an Elastic Load Balancing, we recomend that you use the
	// startPeriod in the task definition healtch check parameters. For more information,
	// see Health check (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html).
	//
	// If your service's tasks take a while to start and respond to Elastic Load
	// Balancing health checks, you can specify a health check grace period of up
	// to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS
	// service scheduler ignores health check status. This grace period can prevent
	// the service scheduler from marking tasks as unhealthy and stopping them before
	// they have time to come up.
	HealthCheckGracePeriodSeconds *int64 `locationName:"healthCheckGracePeriodSeconds" type:"integer"`

	// The infrastructure that you run your service on. For more information, see
	// Amazon ECS launch types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// The FARGATE launch type runs your tasks on Fargate On-Demand infrastructure.
	//
	// Fargate Spot infrastructure is available for use but a capacity provider
	// strategy must be used. For more information, see Fargate capacity providers
	// (https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html)
	// in the Amazon ECS User Guide for Fargate.
	//
	// The EC2 launch type runs your tasks on Amazon EC2 instances registered to
	// your cluster.
	//
	// The EXTERNAL launch type runs your tasks on your on-premises server or virtual
	// machine (VM) capacity registered to your cluster.
	//
	// A service can use either a launch type or a capacity provider strategy. If
	// a launchType is specified, the capacityProviderStrategy parameter must be
	// omitted.
	LaunchType *string `locationName:"launchType" type:"string" enum:"LaunchType"`

	// A load balancer object representing the load balancers to use with your service.
	// For more information, see Service load balancing (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// If the service uses the rolling update (ECS) deployment controller and using
	// either an Application Load Balancer or Network Load Balancer, you must specify
	// one or more target group ARNs to attach to the service. The service-linked
	// role is required for services that use multiple target groups. For more information,
	// see Using service-linked roles for Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// If the service uses the CODE_DEPLOY deployment controller, the service is
	// required to use either an Application Load Balancer or Network Load Balancer.
	// When creating an CodeDeploy deployment group, you specify two target groups
	// (referred to as a targetGroupPair). During a deployment, CodeDeploy determines
	// which task set in your service has the status PRIMARY, and it associates
	// one target group with it. Then, it also associates the other target group
	// with the replacement task set. The load balancer can also have up to two
	// listeners: a required listener for production traffic and an optional listener
	// that you can use to perform validation tests with Lambda functions before
	// routing production traffic to it.
	//
	// If you use the CODE_DEPLOY deployment controller, these values can be changed
	// when updating the service.
	//
	// For Application Load Balancers and Network Load Balancers, this object must
	// contain the load balancer target group ARN, the container name, and the container
	// port to access from the load balancer. The container name must be as it appears
	// in a container definition. The load balancer name parameter must be omitted.
	// When a task from this service is placed on a container instance, the container
	// instance and port combination is registered as a target in the target group
	// that's specified here.
	//
	// For Classic Load Balancers, this object must contain the load balancer name,
	// the container name , and the container port to access from the load balancer.
	// The container name must be as it appears in a container definition. The target
	// group ARN parameter must be omitted. When a task from this service is placed
	// on a container instance, the container instance is registered with the load
	// balancer that's specified here.
	//
	// Services with tasks that use the awsvpc network mode (for example, those
	// with the Fargate launch type) only support Application Load Balancers and
	// Network Load Balancers. Classic Load Balancers aren't supported. Also, when
	// you create any target groups for these services, you must choose ip as the
	// target type, not instance. This is because tasks that use the awsvpc network
	// mode are associated with an elastic network interface, not an Amazon EC2
	// instance.
	LoadBalancers []*LoadBalancer `locationName:"loadBalancers" type:"list"`

	// The network configuration for the service. This parameter is required for
	// task definitions that use the awsvpc network mode to receive their own elastic
	// network interface, and it isn't supported for other network modes. For more
	// information, see Task networking (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
	// in the Amazon Elastic Container Service Developer Guide.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// An array of placement constraint objects to use for tasks in your service.
	// You can specify a maximum of 10 constraints for each task. This limit includes
	// constraints in the task definition and those specified at runtime.
	PlacementConstraints []*PlacementConstraint `locationName:"placementConstraints" type:"list"`

	// The placement strategy objects to use for tasks in your service. You can
	// specify a maximum of 5 strategy rules for each service.
	PlacementStrategy []*PlacementStrategy `locationName:"placementStrategy" type:"list"`

	// The platform version that your tasks in the service are running on. A platform
	// version is specified only for tasks using the Fargate launch type. If one
	// isn't specified, the LATEST platform version is used. For more information,
	// see Fargate platform versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// Specifies whether to propagate the tags from the task definition to the task.
	// If no value is specified, the tags aren't propagated. Tags can only be propagated
	// to the task during task creation. To add tags to a task after task creation,
	// use the TagResource API action.
	PropagateTags *string `locationName:"propagateTags" type:"string" enum:"PropagateTags"`

	// The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon
	// ECS to make calls to your load balancer on your behalf. This parameter is
	// only permitted if you are using a load balancer with your service and your
	// task definition doesn't use the awsvpc network mode. If you specify the role
	// parameter, you must also specify a load balancer object with the loadBalancers
	// parameter.
	//
	// If your account has already created the Amazon ECS service-linked role, that
	// role is used for your service unless you specify a role here. The service-linked
	// role is required if your task definition uses the awsvpc network mode or
	// if the service is configured to use service discovery, an external deployment
	// controller, multiple target groups, or Elastic Inference accelerators in
	// which case you don't specify a role here. For more information, see Using
	// service-linked roles for Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// If your specified role has a path other than /, then you must either specify
	// the full role ARN (this is recommended) or prefix the role name with the
	// path. For example, if a role with the name bar has a path of /foo/ then you
	// would specify /foo/bar as the role name. For more information, see Friendly
	// names and paths (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names)
	// in the IAM User Guide.
	Role *string `locationName:"role" type:"string"`

	// The scheduling strategy to use for the service. For more information, see
	// Services (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
	//
	// There are two service scheduler strategies available:
	//
	//    * REPLICA-The replica scheduling strategy places and maintains the desired
	//    number of tasks across your cluster. By default, the service scheduler
	//    spreads tasks across Availability Zones. You can use task placement strategies
	//    and constraints to customize task placement decisions. This scheduler
	//    strategy is required if the service uses the CODE_DEPLOY or EXTERNAL deployment
	//    controller types.
	//
	//    * DAEMON-The daemon scheduling strategy deploys exactly one task on each
	//    active container instance that meets all of the task placement constraints
	//    that you specify in your cluster. The service scheduler also evaluates
	//    the task placement constraints for running tasks and will stop tasks that
	//    don't meet the placement constraints. When you're using this strategy,
	//    you don't need to specify a desired number of tasks, a task placement
	//    strategy, or use Service Auto Scaling policies. Tasks using the Fargate
	//    launch type or the CODE_DEPLOY or EXTERNAL deployment controller types
	//    don't support the DAEMON scheduling strategy.
	SchedulingStrategy *string `locationName:"schedulingStrategy" type:"string" enum:"SchedulingStrategy"`

	// The name of your service. Up to 255 letters (uppercase and lowercase), numbers,
	// underscores, and hyphens are allowed. Service names must be unique within
	// a cluster, but you can have similarly named services in multiple clusters
	// within a Region or across multiple Regions.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" type:"string" required:"true"`

	// The details of the service discovery registry to associate with this service.
	// For more information, see Service discovery (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
	//
	// Each service may be associated with one service registry. Multiple service
	// registries for each service isn't supported.
	ServiceRegistries []*ServiceRegistry `locationName:"serviceRegistries" type:"list"`

	// The metadata that you apply to the service to help you categorize and organize
	// them. Each tag consists of a key and an optional value, both of which you
	// define. When a service is deleted, the tags are deleted as well.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The family and revision (family:revision) or full ARN of the task definition
	// to run in your service. If a revision isn't specified, the latest ACTIVE
	// revision is used.
	//
	// A task definition must be specified if the service uses either the ECS or
	// CODE_DEPLOY deployment controllers.
	TaskDefinition *string `locationName:"taskDefinition" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceInput"}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.CapacityProviderStrategy != nil {
		for i, v := range s.CapacityProviderStrategy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CapacityProviderStrategy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DeploymentConfiguration != nil {
		if err := s.DeploymentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DeploymentConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.DeploymentController != nil {
		if err := s.DeploymentController.Validate(); err != nil {
			invalidParams.AddNested("DeploymentController", err.(request.ErrInvalidParams))
		}
	}
	if s.NetworkConfiguration != nil {
		if err := s.NetworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityProviderStrategy sets the CapacityProviderStrategy field's value.
func (s *CreateServiceInput) SetCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *CreateServiceInput {
	s.CapacityProviderStrategy = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateServiceInput) SetClientToken(v string) *CreateServiceInput {
	s.ClientToken = &v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *CreateServiceInput) SetCluster(v string) *CreateServiceInput {
	s.Cluster = &v
	return s
}

// SetDeploymentConfiguration sets the DeploymentConfiguration field's value.
func (s *CreateServiceInput) SetDeploymentConfiguration(v *DeploymentConfiguration) *CreateServiceInput {
	s.DeploymentConfiguration = v
	return s
}

// SetDeploymentController sets the DeploymentController field's value.
func (s *CreateServiceInput) SetDeploymentController(v *DeploymentController) *CreateServiceInput {
	s.DeploymentController = v
	return s
}

// SetDesiredCount sets the DesiredCount field's value.
func (s *CreateServiceInput) SetDesiredCount(v int64) *CreateServiceInput {
	s.DesiredCount = &v
	return s
}

// SetEnableECSManagedTags sets the EnableECSManagedTags field's value.
func (s *CreateServiceInput) SetEnableECSManagedTags(v bool) *CreateServiceInput {
	s.EnableECSManagedTags = &v
	return s
}

// SetEnableExecuteCommand sets the EnableExecuteCommand field's value.
func (s *CreateServiceInput) SetEnableExecuteCommand(v bool) *CreateServiceInput {
	s.EnableExecuteCommand = &v
	return s
}

// SetHealthCheckGracePeriodSeconds sets the HealthCheckGracePeriodSeconds field's value.
func (s *CreateServiceInput) SetHealthCheckGracePeriodSeconds(v int64) *CreateServiceInput {
	s.HealthCheckGracePeriodSeconds = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *CreateServiceInput) SetLaunchType(v string) *CreateServiceInput {
	s.LaunchType = &v
	return s
}

// SetLoadBalancers sets the LoadBalancers field's value.
func (s *CreateServiceInput) SetLoadBalancers(v []*LoadBalancer) *CreateServiceInput {
	s.LoadBalancers = v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *CreateServiceInput) SetNetworkConfiguration(v *NetworkConfiguration) *CreateServiceInput {
	s.NetworkConfiguration = v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *CreateServiceInput) SetPlacementConstraints(v []*PlacementConstraint) *CreateServiceInput {
	s.PlacementConstraints = v
	return s
}

// SetPlacementStrategy sets the PlacementStrategy field's value.
func (s *CreateServiceInput) SetPlacementStrategy(v []*PlacementStrategy) *CreateServiceInput {
	s.PlacementStrategy = v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *CreateServiceInput) SetPlatformVersion(v string) *CreateServiceInput {
	s.PlatformVersion = &v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *CreateServiceInput) SetPropagateTags(v string) *CreateServiceInput {
	s.PropagateTags = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateServiceInput) SetRole(v string) *CreateServiceInput {
	s.Role = &v
	return s
}

// SetSchedulingStrategy sets the SchedulingStrategy field's value.
func (s *CreateServiceInput) SetSchedulingStrategy(v string) *CreateServiceInput {
	s.SchedulingStrategy = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *CreateServiceInput) SetServiceName(v string) *CreateServiceInput {
	s.ServiceName = &v
	return s
}

// SetServiceRegistries sets the ServiceRegistries field's value.
func (s *CreateServiceInput) SetServiceRegistries(v []*ServiceRegistry) *CreateServiceInput {
	s.ServiceRegistries = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceInput) SetTags(v []*Tag) *CreateServiceInput {
	s.Tags = v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *CreateServiceInput) SetTaskDefinition(v string) *CreateServiceInput {
	s.TaskDefinition = &v
	return s
}

type CreateServiceOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your service following the create call.
	//
	// A service will return either a capacityProviderStrategy or launchType parameter,
	// but not both, depending where one was specified when it was created.
	//
	// If a service is using the ECS deployment controller, the deploymentController
	// and taskSets parameters will not be returned.
	//
	// if the service uses the CODE_DEPLOY deployment controller, the deploymentController,
	// taskSets and deployments parameters will be returned, however the deployments
	// parameter will be an empty list.
	Service *Service `locationName:"service" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceOutput) GoString() string {
	return s.String()
}

// SetService sets the Service field's value.
func (s *CreateServiceOutput) SetService(v *Service) *CreateServiceOutput {
	s.Service = v
	return s
}

type CreateTaskSetInput struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy to use for the task set.
	//
	// A capacity provider strategy consists of one or more capacity providers along
	// with the base and weight to assign to them. A capacity provider must be associated
	// with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders
	// API is used to associate a capacity provider with a cluster. Only capacity
	// providers with an ACTIVE or UPDATING status can be used.
	//
	// If a capacityProviderStrategy is specified, the launchType parameter must
	// be omitted. If no capacityProviderStrategy or launchType is specified, the
	// defaultCapacityProviderStrategy for the cluster is used.
	//
	// If specifying a capacity provider that uses an Auto Scaling group, the capacity
	// provider must already be created. New capacity providers can be created with
	// the CreateCapacityProvider API operation.
	//
	// To use a Fargate capacity provider, specify either the FARGATE or FARGATE_SPOT
	// capacity providers. The Fargate capacity providers are available to all accounts
	// and only need to be associated with a cluster to be used.
	//
	// The PutClusterCapacityProviders API operation is used to update the list
	// of available capacity providers for a cluster after the cluster is created.
	CapacityProviderStrategy []*CapacityProviderStrategyItem `locationName:"capacityProviderStrategy" type:"list"`

	// The identifier that you provide to ensure the idempotency of the request.
	// It's case sensitive and must be unique. It can be up to 32 ASCII characters
	// are allowed.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the service to create the task set in.
	//
	// Cluster is a required field
	Cluster *string `locationName:"cluster" type:"string" required:"true"`

	// An optional non-unique tag that identifies this task set in external systems.
	// If the task set is associated with a service discovery registry, the tasks
	// in this task set will have the ECS_TASK_SET_EXTERNAL_ID Cloud Map attribute
	// set to the provided value.
	ExternalId *string `locationName:"externalId" type:"string"`

	// The launch type that new tasks in the task set uses. For more information,
	// see Amazon ECS launch types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// If a launchType is specified, the capacityProviderStrategy parameter must
	// be omitted.
	LaunchType *string `locationName:"launchType" type:"string" enum:"LaunchType"`

	// A load balancer object representing the load balancer to use with the task
	// set. The supported load balancer types are either an Application Load Balancer
	// or a Network Load Balancer.
	LoadBalancers []*LoadBalancer `locationName:"loadBalancers" type:"list"`

	// An object representing the network configuration for a task set.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The platform version that the tasks in the task set uses. A platform version
	// is specified only for tasks using the Fargate launch type. If one isn't specified,
	// the LATEST platform version is used.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// A floating-point percentage of the desired number of tasks to place and keep
	// running in the task set.
	Scale *Scale `locationName:"scale" type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the service to create
	// the task set in.
	//
	// Service is a required field
	Service *string `locationName:"service" type:"string" required:"true"`

	// The details of the service discovery registries to assign to this task set.
	// For more information, see Service discovery (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
	ServiceRegistries []*ServiceRegistry `locationName:"serviceRegistries" type:"list"`

	// The metadata that you apply to the task set to help you categorize and organize
	// them. Each tag consists of a key and an optional value. You define both.
	// When a service is deleted, the tags are deleted.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The task definition for the tasks in the task set to use.
	//
	// TaskDefinition is a required field
	TaskDefinition *string `locationName:"taskDefinition" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTaskSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTaskSetInput"}
	if s.Cluster == nil {
		invalidParams.Add(request.NewErrParamRequired("Cluster"))
	}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}
	if s.TaskDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskDefinition"))
	}
	if s.CapacityProviderStrategy != nil {
		for i, v := range s.CapacityProviderStrategy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CapacityProviderStrategy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.NetworkConfiguration != nil {
		if err := s.NetworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityProviderStrategy sets the CapacityProviderStrategy field's value.
func (s *CreateTaskSetInput) SetCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *CreateTaskSetInput {
	s.CapacityProviderStrategy = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTaskSetInput) SetClientToken(v string) *CreateTaskSetInput {
	s.ClientToken = &v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *CreateTaskSetInput) SetCluster(v string) *CreateTaskSetInput {
	s.Cluster = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *CreateTaskSetInput) SetExternalId(v string) *CreateTaskSetInput {
	s.ExternalId = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *CreateTaskSetInput) SetLaunchType(v string) *CreateTaskSetInput {
	s.LaunchType = &v
	return s
}

// SetLoadBalancers sets the LoadBalancers field's value.
func (s *CreateTaskSetInput) SetLoadBalancers(v []*LoadBalancer) *CreateTaskSetInput {
	s.LoadBalancers = v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *CreateTaskSetInput) SetNetworkConfiguration(v *NetworkConfiguration) *CreateTaskSetInput {
	s.NetworkConfiguration = v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *CreateTaskSetInput) SetPlatformVersion(v string) *CreateTaskSetInput {
	s.PlatformVersion = &v
	return s
}

// SetScale sets the Scale field's value.
func (s *CreateTaskSetInput) SetScale(v *Scale) *CreateTaskSetInput {
	s.Scale = v
	return s
}

// SetService sets the Service field's value.
func (s *CreateTaskSetInput) SetService(v string) *CreateTaskSetInput {
	s.Service = &v
	return s
}

// SetServiceRegistries sets the ServiceRegistries field's value.
func (s *CreateTaskSetInput) SetServiceRegistries(v []*ServiceRegistry) *CreateTaskSetInput {
	s.ServiceRegistries = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTaskSetInput) SetTags(v []*Tag) *CreateTaskSetInput {
	s.Tags = v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *CreateTaskSetInput) SetTaskDefinition(v string) *CreateTaskSetInput {
	s.TaskDefinition = &v
	return s
}

type CreateTaskSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about a set of Amazon ECS tasks in either an CodeDeploy or an
	// EXTERNAL deployment. A task set includes details such as the desired number
	// of tasks, how many tasks are running, and whether the task set serves production
	// traffic.
	TaskSet *TaskSet `locationName:"taskSet" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskSetOutput) GoString() string {
	return s.String()
}

// SetTaskSet sets the TaskSet field's value.
func (s *CreateTaskSetOutput) SetTaskSet(v *TaskSet) *CreateTaskSetOutput {
	s.TaskSet = v
	return s
}

type DeleteAccountSettingInput struct {
	_ struct{} `type:"structure"`

	// The resource name to disable the account setting for. If serviceLongArnFormat
	// is specified, the ARN for your Amazon ECS services is affected. If taskLongArnFormat
	// is specified, the ARN and resource ID for your Amazon ECS tasks is affected.
	// If containerInstanceLongArnFormat is specified, the ARN and resource ID for
	// your Amazon ECS container instances is affected. If awsvpcTrunking is specified,
	// the ENI limit for your Amazon ECS container instances is affected.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"SettingName"`

	// The Amazon Resource Name (ARN) of the principal. It can be an IAM user, IAM
	// role, or the root user. If you specify the root user, it disables the account
	// setting for all IAM users, IAM roles, and the root user of the account unless
	// an IAM user or role explicitly overrides these settings. If this field is
	// omitted, the setting is changed only for the authenticated user.
	PrincipalArn *string `locationName:"principalArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountSettingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountSettingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccountSettingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccountSettingInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteAccountSettingInput) SetName(v string) *DeleteAccountSettingInput {
	s.Name = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *DeleteAccountSettingInput) SetPrincipalArn(v string) *DeleteAccountSettingInput {
	s.PrincipalArn = &v
	return s
}

type DeleteAccountSettingOutput struct {
	_ struct{} `type:"structure"`

	// The account setting for the specified principal ARN.
	Setting *Setting `locationName:"setting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountSettingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountSettingOutput) GoString() string {
	return s.String()
}

// SetSetting sets the Setting field's value.
func (s *DeleteAccountSettingOutput) SetSetting(v *Setting) *DeleteAccountSettingOutput {
	s.Setting = v
	return s
}

type DeleteAttributesInput struct {
	_ struct{} `type:"structure"`

	// The attributes to delete from your resource. You can specify up to 10 attributes
	// for each request. For custom attributes, specify the attribute name and target
	// ID, but don't specify the value. If you specify the target ID using the short
	// form, you must also specify the target type.
	//
	// Attributes is a required field
	Attributes []*Attribute `locationName:"attributes" type:"list" required:"true"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that contains
	// the resource to delete attributes. If you do not specify a cluster, the default
	// cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAttributesInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *DeleteAttributesInput) SetAttributes(v []*Attribute) *DeleteAttributesInput {
	s.Attributes = v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *DeleteAttributesInput) SetCluster(v string) *DeleteAttributesInput {
	s.Cluster = &v
	return s
}

type DeleteAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A list of attribute objects that were successfully deleted from your resource.
	Attributes []*Attribute `locationName:"attributes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *DeleteAttributesOutput) SetAttributes(v []*Attribute) *DeleteAttributesOutput {
	s.Attributes = v
	return s
}

type DeleteCapacityProviderInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the capacity provider
	// to delete.
	//
	// CapacityProvider is a required field
	CapacityProvider *string `locationName:"capacityProvider" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCapacityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCapacityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCapacityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCapacityProviderInput"}
	if s.CapacityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("CapacityProvider"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityProvider sets the CapacityProvider field's value.
func (s *DeleteCapacityProviderInput) SetCapacityProvider(v string) *DeleteCapacityProviderInput {
	s.CapacityProvider = &v
	return s
}

type DeleteCapacityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The details of the capacity provider.
	CapacityProvider *CapacityProvider `locationName:"capacityProvider" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCapacityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCapacityProviderOutput) GoString() string {
	return s.String()
}

// SetCapacityProvider sets the CapacityProvider field's value.
func (s *DeleteCapacityProviderOutput) SetCapacityProvider(v *CapacityProvider) *DeleteCapacityProviderOutput {
	s.CapacityProvider = v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster to delete.
	//
	// Cluster is a required field
	Cluster *string `locationName:"cluster" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.Cluster == nil {
		invalidParams.Add(request.NewErrParamRequired("Cluster"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *DeleteClusterInput) SetCluster(v string) *DeleteClusterInput {
	s.Cluster = &v
	return s
}

type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the deleted cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DeleteClusterOutput) SetCluster(v *Cluster) *DeleteClusterOutput {
	s.Cluster = v
	return s
}

type DeleteServiceInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the service to delete. If you do not specify a cluster, the default cluster
	// is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// If true, allows you to delete a service even if it wasn't scaled down to
	// zero tasks. It's only necessary to use this if the service uses the REPLICA
	// scheduling strategy.
	Force *bool `locationName:"force" type:"boolean"`

	// The name of the service to delete.
	//
	// Service is a required field
	Service *string `locationName:"service" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceInput"}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *DeleteServiceInput) SetCluster(v string) *DeleteServiceInput {
	s.Cluster = &v
	return s
}

// SetForce sets the Force field's value.
func (s *DeleteServiceInput) SetForce(v bool) *DeleteServiceInput {
	s.Force = &v
	return s
}

// SetService sets the Service field's value.
func (s *DeleteServiceInput) SetService(v string) *DeleteServiceInput {
	s.Service = &v
	return s
}

type DeleteServiceOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the deleted service.
	Service *Service `locationName:"service" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceOutput) GoString() string {
	return s.String()
}

// SetService sets the Service field's value.
func (s *DeleteServiceOutput) SetService(v *Service) *DeleteServiceOutput {
	s.Service = v
	return s
}

type DeleteTaskSetInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the service that the task set found in to delete.
	//
	// Cluster is a required field
	Cluster *string `locationName:"cluster" type:"string" required:"true"`

	// If true, you can delete a task set even if it hasn't been scaled down to
	// zero.
	Force *bool `locationName:"force" type:"boolean"`

	// The short name or full Amazon Resource Name (ARN) of the service that hosts
	// the task set to delete.
	//
	// Service is a required field
	Service *string `locationName:"service" type:"string" required:"true"`

	// The task set ID or full Amazon Resource Name (ARN) of the task set to delete.
	//
	// TaskSet is a required field
	TaskSet *string `locationName:"taskSet" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTaskSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTaskSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTaskSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTaskSetInput"}
	if s.Cluster == nil {
		invalidParams.Add(request.NewErrParamRequired("Cluster"))
	}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}
	if s.TaskSet == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskSet"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *DeleteTaskSetInput) SetCluster(v string) *DeleteTaskSetInput {
	s.Cluster = &v
	return s
}

// SetForce sets the Force field's value.
func (s *DeleteTaskSetInput) SetForce(v bool) *DeleteTaskSetInput {
	s.Force = &v
	return s
}

// SetService sets the Service field's value.
func (s *DeleteTaskSetInput) SetService(v string) *DeleteTaskSetInput {
	s.Service = &v
	return s
}

// SetTaskSet sets the TaskSet field's value.
func (s *DeleteTaskSetInput) SetTaskSet(v string) *DeleteTaskSetInput {
	s.TaskSet = &v
	return s
}

type DeleteTaskSetOutput struct {
	_ struct{} `type:"structure"`

	// Details about the task set.
	TaskSet *TaskSet `locationName:"taskSet" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTaskSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTaskSetOutput) GoString() string {
	return s.String()
}

// SetTaskSet sets the TaskSet field's value.
func (s *DeleteTaskSetOutput) SetTaskSet(v *TaskSet) *DeleteTaskSetOutput {
	s.TaskSet = v
	return s
}

// The details of an Amazon ECS service deployment. This is used only when a
// service uses the ECS deployment controller type.
type Deployment struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy that the deployment is using.
	CapacityProviderStrategy []*CapacityProviderStrategyItem `locationName:"capacityProviderStrategy" type:"list"`

	// The Unix timestamp for the time when the service deployment was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The most recent desired count of tasks that was specified for the service
	// to deploy or maintain.
	DesiredCount *int64 `locationName:"desiredCount" type:"integer"`

	// The number of consecutively failed tasks in the deployment. A task is considered
	// a failure if the service scheduler can't launch the task, the task doesn't
	// transition to a RUNNING state, or if it fails any of its defined health checks
	// and is stopped.
	//
	// Once a service deployment has one or more successfully running tasks, the
	// failed task count resets to zero and stops being evaluated.
	FailedTasks *int64 `locationName:"failedTasks" type:"integer"`

	// The ID of the deployment.
	Id *string `locationName:"id" type:"string"`

	// The launch type the tasks in the service are using. For more information,
	// see Amazon ECS Launch Types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LaunchType *string `locationName:"launchType" type:"string" enum:"LaunchType"`

	// The VPC subnet and security group configuration for tasks that receive their
	// own elastic network interface by using the awsvpc networking mode.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The number of tasks in the deployment that are in the PENDING status.
	PendingCount *int64 `locationName:"pendingCount" type:"integer"`

	// The operating system that your tasks in the service, or tasks are running
	// on. A platform family is specified only for tasks using the Fargate launch
	// type.
	//
	// All tasks that run as part of this service must use the same platformFamily
	// value as the service, for example, LINUX..
	PlatformFamily *string `locationName:"platformFamily" type:"string"`

	// The platform version that your tasks in the service run on. A platform version
	// is only specified for tasks using the Fargate launch type. If one isn't specified,
	// the LATEST platform version is used. For more information, see Fargate Platform
	// Versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	//
	// The rolloutState of a service is only returned for services that use the
	// rolling update (ECS) deployment type that aren't behind a Classic Load Balancer.
	//
	// The rollout state of the deployment. When a service deployment is started,
	// it begins in an IN_PROGRESS state. When the service reaches a steady state,
	// the deployment transitions to a COMPLETED state. If the service fails to
	// reach a steady state and circuit breaker is enabled, the deployment transitions
	// to a FAILED state. A deployment in FAILED state doesn't launch any new tasks.
	// For more information, see DeploymentCircuitBreaker.
	RolloutState *string `locationName:"rolloutState" type:"string" enum:"DeploymentRolloutState"`

	// A description of the rollout state of a deployment.
	RolloutStateReason *string `locationName:"rolloutStateReason" type:"string"`

	// The number of tasks in the deployment that are in the RUNNING status.
	RunningCount *int64 `locationName:"runningCount" type:"integer"`

	// The status of the deployment. The following describes each state.
	//
	// PRIMARY
	//
	// The most recent deployment of a service.
	//
	// ACTIVE
	//
	// A service deployment that still has running tasks, but are in the process
	// of being replaced with a new PRIMARY deployment.
	//
	// INACTIVE
	//
	// A deployment that has been completely replaced.
	Status *string `locationName:"status" type:"string"`

	// The most recent task definition that was specified for the tasks in the service
	// to use.
	TaskDefinition *string `locationName:"taskDefinition" type:"string"`

	// The Unix timestamp for the time when the service deployment was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Deployment) GoString() string {
	return s.String()
}

// SetCapacityProviderStrategy sets the CapacityProviderStrategy field's value.
func (s *Deployment) SetCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *Deployment {
	s.CapacityProviderStrategy = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Deployment) SetCreatedAt(v time.Time) *Deployment {
	s.CreatedAt = &v
	return s
}

// SetDesiredCount sets the DesiredCount field's value.
func (s *Deployment) SetDesiredCount(v int64) *Deployment {
	s.DesiredCount = &v
	return s
}

// SetFailedTasks sets the FailedTasks field's value.
func (s *Deployment) SetFailedTasks(v int64) *Deployment {
	s.FailedTasks = &v
	return s
}

// SetId sets the Id field's value.
func (s *Deployment) SetId(v string) *Deployment {
	s.Id = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *Deployment) SetLaunchType(v string) *Deployment {
	s.LaunchType = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *Deployment) SetNetworkConfiguration(v *NetworkConfiguration) *Deployment {
	s.NetworkConfiguration = v
	return s
}

// SetPendingCount sets the PendingCount field's value.
func (s *Deployment) SetPendingCount(v int64) *Deployment {
	s.PendingCount = &v
	return s
}

// SetPlatformFamily sets the PlatformFamily field's value.
func (s *Deployment) SetPlatformFamily(v string) *Deployment {
	s.PlatformFamily = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *Deployment) SetPlatformVersion(v string) *Deployment {
	s.PlatformVersion = &v
	return s
}

// SetRolloutState sets the RolloutState field's value.
func (s *Deployment) SetRolloutState(v string) *Deployment {
	s.RolloutState = &v
	return s
}

// SetRolloutStateReason sets the RolloutStateReason field's value.
func (s *Deployment) SetRolloutStateReason(v string) *Deployment {
	s.RolloutStateReason = &v
	return s
}

// SetRunningCount sets the RunningCount field's value.
func (s *Deployment) SetRunningCount(v int64) *Deployment {
	s.RunningCount = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Deployment) SetStatus(v string) *Deployment {
	s.Status = &v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *Deployment) SetTaskDefinition(v string) *Deployment {
	s.TaskDefinition = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Deployment) SetUpdatedAt(v time.Time) *Deployment {
	s.UpdatedAt = &v
	return s
}

// The deployment circuit breaker can only be used for services using the rolling
// update (ECS) deployment type that aren't behind a Classic Load Balancer.
//
// The deployment circuit breaker determines whether a service deployment will
// fail if the service can't reach a steady state. If enabled, a service deployment
// will transition to a failed state and stop launching new tasks. You can also
// configure Amazon ECS to roll back your service to the last completed deployment
// after a failure. For more information, see Rolling update (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html)
// in the Amazon Elastic Container Service Developer Guide.
type DeploymentCircuitBreaker struct {
	_ struct{} `type:"structure"`

	// Determines whether to use the deployment circuit breaker logic for the service.
	//
	// Enable is a required field
	Enable *bool `locationName:"enable" type:"boolean" required:"true"`

	// Determines whether to configure Amazon ECS to roll back the service if a
	// service deployment fails. If rollback is enabled, when a service deployment
	// fails, the service is rolled back to the last deployment that completed successfully.
	//
	// Rollback is a required field
	Rollback *bool `locationName:"rollback" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentCircuitBreaker) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentCircuitBreaker) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentCircuitBreaker) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeploymentCircuitBreaker"}
	if s.Enable == nil {
		invalidParams.Add(request.NewErrParamRequired("Enable"))
	}
	if s.Rollback == nil {
		invalidParams.Add(request.NewErrParamRequired("Rollback"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnable sets the Enable field's value.
func (s *DeploymentCircuitBreaker) SetEnable(v bool) *DeploymentCircuitBreaker {
	s.Enable = &v
	return s
}

// SetRollback sets the Rollback field's value.
func (s *DeploymentCircuitBreaker) SetRollback(v bool) *DeploymentCircuitBreaker {
	s.Rollback = &v
	return s
}

// Optional deployment parameters that control how many tasks run during a deployment
// and the ordering of stopping and starting tasks.
type DeploymentConfiguration struct {
	_ struct{} `type:"structure"`

	//
	// The deployment circuit breaker can only be used for services using the rolling
	// update (ECS) deployment type.
	//
	// The deployment circuit breaker determines whether a service deployment will
	// fail if the service can't reach a steady state. If deployment circuit breaker
	// is enabled, a service deployment will transition to a failed state and stop
	// launching new tasks. If rollback is enabled, when a service deployment fails,
	// the service is rolled back to the last deployment that completed successfully.
	DeploymentCircuitBreaker *DeploymentCircuitBreaker `locationName:"deploymentCircuitBreaker" type:"structure"`

	// If a service is using the rolling update (ECS) deployment type, the maximumPercent
	// parameter represents an upper limit on the number of your service's tasks
	// that are allowed in the RUNNING or PENDING state during a deployment, as
	// a percentage of the desiredCount (rounded down to the nearest integer). This
	// parameter enables you to define the deployment batch size. For example, if
	// your service is using the REPLICA service scheduler and has a desiredCount
	// of four tasks and a maximumPercent value of 200%, the scheduler may start
	// four new tasks before stopping the four older tasks (provided that the cluster
	// resources required to do this are available). The default maximumPercent
	// value for a service using the REPLICA service scheduler is 200%.
	//
	// If a service is using either the blue/green (CODE_DEPLOY) or EXTERNAL deployment
	// types and tasks that use the EC2 launch type, the maximum percent value is
	// set to the default value and is used to define the upper limit on the number
	// of the tasks in the service that remain in the RUNNING state while the container
	// instances are in the DRAINING state. If the tasks in the service use the
	// Fargate launch type, the maximum percent value is not used, although it is
	// returned when describing your service.
	MaximumPercent *int64 `locationName:"maximumPercent" type:"integer"`

	// If a service is using the rolling update (ECS) deployment type, the minimumHealthyPercent
	// represents a lower limit on the number of your service's tasks that must
	// remain in the RUNNING state during a deployment, as a percentage of the desiredCount
	// (rounded up to the nearest integer). This parameter enables you to deploy
	// without using additional cluster capacity. For example, if your service has
	// a desiredCount of four tasks and a minimumHealthyPercent of 50%, the service
	// scheduler may stop two existing tasks to free up cluster capacity before
	// starting two new tasks.
	//
	// For services that do not use a load balancer, the following should be noted:
	//
	//    * A service is considered healthy if all essential containers within the
	//    tasks in the service pass their health checks.
	//
	//    * If a task has no essential containers with a health check defined, the
	//    service scheduler will wait for 40 seconds after a task reaches a RUNNING
	//    state before the task is counted towards the minimum healthy percent total.
	//
	//    * If a task has one or more essential containers with a health check defined,
	//    the service scheduler will wait for the task to reach a healthy status
	//    before counting it towards the minimum healthy percent total. A task is
	//    considered healthy when all essential containers within the task have
	//    passed their health checks. The amount of time the service scheduler can
	//    wait for is determined by the container health check settings.
	//
	// For services are that do use a load balancer, the following should be noted:
	//
	//    * If a task has no essential containers with a health check defined, the
	//    service scheduler will wait for the load balancer target group health
	//    check to return a healthy status before counting the task towards the
	//    minimum healthy percent total.
	//
	//    * If a task has an essential container with a health check defined, the
	//    service scheduler will wait for both the task to reach a healthy status
	//    and the load balancer target group health check to return a healthy status
	//    before counting the task towards the minimum healthy percent total.
	//
	// If a service is using either the blue/green (CODE_DEPLOY) or EXTERNAL deployment
	// types and is running tasks that use the EC2 launch type, the minimum healthy
	// percent value is set to the default value and is used to define the lower
	// limit on the number of the tasks in the service that remain in the RUNNING
	// state while the container instances are in the DRAINING state. If a service
	// is using either the blue/green (CODE_DEPLOY) or EXTERNAL deployment types
	// and is running tasks that use the Fargate launch type, the minimum healthy
	// percent value is not used, although it is returned when describing your service.
	MinimumHealthyPercent *int64 `locationName:"minimumHealthyPercent" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeploymentConfiguration"}
	if s.DeploymentCircuitBreaker != nil {
		if err := s.DeploymentCircuitBreaker.Validate(); err != nil {
			invalidParams.AddNested("DeploymentCircuitBreaker", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentCircuitBreaker sets the DeploymentCircuitBreaker field's value.
func (s *DeploymentConfiguration) SetDeploymentCircuitBreaker(v *DeploymentCircuitBreaker) *DeploymentConfiguration {
	s.DeploymentCircuitBreaker = v
	return s
}

// SetMaximumPercent sets the MaximumPercent field's value.
func (s *DeploymentConfiguration) SetMaximumPercent(v int64) *DeploymentConfiguration {
	s.MaximumPercent = &v
	return s
}

// SetMinimumHealthyPercent sets the MinimumHealthyPercent field's value.
func (s *DeploymentConfiguration) SetMinimumHealthyPercent(v int64) *DeploymentConfiguration {
	s.MinimumHealthyPercent = &v
	return s
}

// The deployment controller to use for the service. For more information, see
// Amazon ECS deployment types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html)
// in the Amazon Elastic Container Service Developer Guide.
type DeploymentController struct {
	_ struct{} `type:"structure"`

	// The deployment controller type to use.
	//
	// There are three deployment controller types available:
	//
	// ECS
	//
	// The rolling update (ECS) deployment type involves replacing the current running
	// version of the container with the latest version. The number of containers
	// Amazon ECS adds or removes from the service during a rolling update is controlled
	// by adjusting the minimum and maximum number of healthy tasks allowed during
	// a service deployment, as specified in the DeploymentConfiguration.
	//
	// CODE_DEPLOY
	//
	// The blue/green (CODE_DEPLOY) deployment type uses the blue/green deployment
	// model powered by CodeDeploy, which allows you to verify a new deployment
	// of a service before sending production traffic to it.
	//
	// EXTERNAL
	//
	// The external (EXTERNAL) deployment type enables you to use any third-party
	// deployment controller for full control over the deployment process for an
	// Amazon ECS service.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DeploymentControllerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentController) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentController) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentController) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeploymentController"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *DeploymentController) SetType(v string) *DeploymentController {
	s.Type = &v
	return s
}

type DeregisterContainerInstanceInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the container instance to deregister. If you do not specify a cluster, the
	// default cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// The container instance ID or full ARN of the container instance to deregister.
	// For more information about the ARN format, see Amazon Resource Name (ARN)
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids)
	// in the Amazon ECS Developer Guide.
	//
	// ContainerInstance is a required field
	ContainerInstance *string `locationName:"containerInstance" type:"string" required:"true"`

	// Forces the container instance to be deregistered. If you have tasks running
	// on the container instance when you deregister it with the force option, these
	// tasks remain running until you terminate the instance or the tasks stop through
	// some other means, but they're orphaned (no longer monitored or accounted
	// for by Amazon ECS). If an orphaned task on your container instance is part
	// of an Amazon ECS service, then the service scheduler starts another copy
	// of that task, on a different container instance if possible.
	//
	// Any containers in orphaned service tasks that are registered with a Classic
	// Load Balancer or an Application Load Balancer target group are deregistered.
	// They begin connection draining according to the settings on the load balancer
	// or target group.
	Force *bool `locationName:"force" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterContainerInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterContainerInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterContainerInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterContainerInstanceInput"}
	if s.ContainerInstance == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerInstance"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *DeregisterContainerInstanceInput) SetCluster(v string) *DeregisterContainerInstanceInput {
	s.Cluster = &v
	return s
}

// SetContainerInstance sets the ContainerInstance field's value.
func (s *DeregisterContainerInstanceInput) SetContainerInstance(v string) *DeregisterContainerInstanceInput {
	s.ContainerInstance = &v
	return s
}

// SetForce sets the Force field's value.
func (s *DeregisterContainerInstanceInput) SetForce(v bool) *DeregisterContainerInstanceInput {
	s.Force = &v
	return s
}

type DeregisterContainerInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The container instance that was deregistered.
	ContainerInstance *ContainerInstance `locationName:"containerInstance" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterContainerInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterContainerInstanceOutput) GoString() string {
	return s.String()
}

// SetContainerInstance sets the ContainerInstance field's value.
func (s *DeregisterContainerInstanceOutput) SetContainerInstance(v *ContainerInstance) *DeregisterContainerInstanceOutput {
	s.ContainerInstance = v
	return s
}

type DeregisterTaskDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The family and revision (family:revision) or full Amazon Resource Name (ARN)
	// of the task definition to deregister. You must specify a revision.
	//
	// TaskDefinition is a required field
	TaskDefinition *string `locationName:"taskDefinition" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterTaskDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterTaskDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterTaskDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterTaskDefinitionInput"}
	if s.TaskDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskDefinition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *DeregisterTaskDefinitionInput) SetTaskDefinition(v string) *DeregisterTaskDefinitionInput {
	s.TaskDefinition = &v
	return s
}

type DeregisterTaskDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the deregistered task.
	TaskDefinition *TaskDefinition `locationName:"taskDefinition" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterTaskDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterTaskDefinitionOutput) GoString() string {
	return s.String()
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *DeregisterTaskDefinitionOutput) SetTaskDefinition(v *TaskDefinition) *DeregisterTaskDefinitionOutput {
	s.TaskDefinition = v
	return s
}

type DescribeCapacityProvidersInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of one or more capacity
	// providers. Up to 100 capacity providers can be described in an action.
	CapacityProviders []*string `locationName:"capacityProviders" type:"list"`

	// Specifies whether or not you want to see the resource tags for the capacity
	// provider. If TAGS is specified, the tags are included in the response. If
	// this field is omitted, tags aren't included in the response.
	Include []*string `locationName:"include" type:"list" enum:"CapacityProviderField"`

	// The maximum number of account setting results returned by DescribeCapacityProviders
	// in paginated output. When this parameter is used, DescribeCapacityProviders
	// only returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another DescribeCapacityProviders request with the returned nextToken value.
	// This value can be between 1 and 10. If this parameter is not used, then DescribeCapacityProviders
	// returns up to 10 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeCapacityProviders
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCapacityProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCapacityProvidersInput) GoString() string {
	return s.String()
}

// SetCapacityProviders sets the CapacityProviders field's value.
func (s *DescribeCapacityProvidersInput) SetCapacityProviders(v []*string) *DescribeCapacityProvidersInput {
	s.CapacityProviders = v
	return s
}

// SetInclude sets the Include field's value.
func (s *DescribeCapacityProvidersInput) SetInclude(v []*string) *DescribeCapacityProvidersInput {
	s.Include = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeCapacityProvidersInput) SetMaxResults(v int64) *DescribeCapacityProvidersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeCapacityProvidersInput) SetNextToken(v string) *DescribeCapacityProvidersInput {
	s.NextToken = &v
	return s
}

type DescribeCapacityProvidersOutput struct {
	_ struct{} `type:"structure"`

	// The list of capacity providers.
	CapacityProviders []*CapacityProvider `locationName:"capacityProviders" type:"list"`

	// Any failures associated with the call.
	Failures []*Failure `locationName:"failures" type:"list"`

	// The nextToken value to include in a future DescribeCapacityProviders request.
	// When the results of a DescribeCapacityProviders request exceed maxResults,
	// this value can be used to retrieve the next page of results. This value is
	// null when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCapacityProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCapacityProvidersOutput) GoString() string {
	return s.String()
}

// SetCapacityProviders sets the CapacityProviders field's value.
func (s *DescribeCapacityProvidersOutput) SetCapacityProviders(v []*CapacityProvider) *DescribeCapacityProvidersOutput {
	s.CapacityProviders = v
	return s
}

// SetFailures sets the Failures field's value.
func (s *DescribeCapacityProvidersOutput) SetFailures(v []*Failure) *DescribeCapacityProvidersOutput {
	s.Failures = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeCapacityProvidersOutput) SetNextToken(v string) *DescribeCapacityProvidersOutput {
	s.NextToken = &v
	return s
}

type DescribeClustersInput struct {
	_ struct{} `type:"structure"`

	// A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN)
	// entries. If you do not specify a cluster, the default cluster is assumed.
	Clusters []*string `locationName:"clusters" type:"list"`

	// Determines whether to include additional information about the clusters in
	// the response. If this field is omitted, this information isn't included.
	//
	// If ATTACHMENTS is specified, the attachments for the container instances
	// or tasks within the cluster are included.
	//
	// If SETTINGS is specified, the settings for the cluster are included.
	//
	// If CONFIGURATIONS is specified, the configuration for the cluster is included.
	//
	// If STATISTICS is specified, the task and service count is included, separated
	// by launch type.
	//
	// If TAGS is specified, the metadata tags associated with the cluster are included.
	Include []*string `locationName:"include" type:"list" enum:"ClusterField"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClustersInput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *DescribeClustersInput) SetClusters(v []*string) *DescribeClustersInput {
	s.Clusters = v
	return s
}

// SetInclude sets the Include field's value.
func (s *DescribeClustersInput) SetInclude(v []*string) *DescribeClustersInput {
	s.Include = v
	return s
}

type DescribeClustersOutput struct {
	_ struct{} `type:"structure"`

	// The list of clusters.
	Clusters []*Cluster `locationName:"clusters" type:"list"`

	// Any failures associated with the call.
	Failures []*Failure `locationName:"failures" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClustersOutput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *DescribeClustersOutput) SetClusters(v []*Cluster) *DescribeClustersOutput {
	s.Clusters = v
	return s
}

// SetFailures sets the Failures field's value.
func (s *DescribeClustersOutput) SetFailures(v []*Failure) *DescribeClustersOutput {
	s.Failures = v
	return s
}

type DescribeContainerInstancesInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the container instances to describe. If you do not specify a cluster, the
	// default cluster is assumed. This parameter is required if the container instance
	// or container instances you are describing were launched in any cluster other
	// than the default cluster.
	Cluster *string `locationName:"cluster" type:"string"`

	// A list of up to 100 container instance IDs or full Amazon Resource Name (ARN)
	// entries.
	//
	// ContainerInstances is a required field
	ContainerInstances []*string `locationName:"containerInstances" type:"list" required:"true"`

	// Specifies whether you want to see the resource tags for the container instance.
	// If TAGS is specified, the tags are included in the response. If CONTAINER_INSTANCE_HEALTH
	// is specified, the container instance health is included in the response.
	// If this field is omitted, tags and container instance health status aren't
	// included in the response.
	Include []*string `locationName:"include" type:"list" enum:"ContainerInstanceField"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeContainerInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeContainerInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContainerInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeContainerInstancesInput"}
	if s.ContainerInstances == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerInstances"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *DescribeContainerInstancesInput) SetCluster(v string) *DescribeContainerInstancesInput {
	s.Cluster = &v
	return s
}

// SetContainerInstances sets the ContainerInstances field's value.
func (s *DescribeContainerInstancesInput) SetContainerInstances(v []*string) *DescribeContainerInstancesInput {
	s.ContainerInstances = v
	return s
}

// SetInclude sets the Include field's value.
func (s *DescribeContainerInstancesInput) SetInclude(v []*string) *DescribeContainerInstancesInput {
	s.Include = v
	return s
}

type DescribeContainerInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The list of container instances.
	ContainerInstances []*ContainerInstance `locationName:"containerInstances" type:"list"`

	// Any failures associated with the call.
	Failures []*Failure `locationName:"failures" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeContainerInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeContainerInstancesOutput) GoString() string {
	return s.String()
}

// SetContainerInstances sets the ContainerInstances field's value.
func (s *DescribeContainerInstancesOutput) SetContainerInstances(v []*ContainerInstance) *DescribeContainerInstancesOutput {
	s.ContainerInstances = v
	return s
}

// SetFailures sets the Failures field's value.
func (s *DescribeContainerInstancesOutput) SetFailures(v []*Failure) *DescribeContainerInstancesOutput {
	s.Failures = v
	return s
}

type DescribeServicesInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN)the cluster that hosts the
	// service to describe. If you do not specify a cluster, the default cluster
	// is assumed. This parameter is required if the service or services you are
	// describing were launched in any cluster other than the default cluster.
	Cluster *string `locationName:"cluster" type:"string"`

	// Determines whether you want to see the resource tags for the service. If
	// TAGS is specified, the tags are included in the response. If this field is
	// omitted, tags aren't included in the response.
	Include []*string `locationName:"include" type:"list" enum:"ServiceField"`

	// A list of services to describe. You may specify up to 10 services to describe
	// in a single operation.
	//
	// Services is a required field
	Services []*string `locationName:"services" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeServicesInput"}
	if s.Services == nil {
		invalidParams.Add(request.NewErrParamRequired("Services"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *DescribeServicesInput) SetCluster(v string) *DescribeServicesInput {
	s.Cluster = &v
	return s
}

// SetInclude sets the Include field's value.
func (s *DescribeServicesInput) SetInclude(v []*string) *DescribeServicesInput {
	s.Include = v
	return s
}

// SetServices sets the Services field's value.
func (s *DescribeServicesInput) SetServices(v []*string) *DescribeServicesInput {
	s.Services = v
	return s
}

type DescribeServicesOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*Failure `locationName:"failures" type:"list"`

	// The list of services described.
	Services []*Service `locationName:"services" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServicesOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *DescribeServicesOutput) SetFailures(v []*Failure) *DescribeServicesOutput {
	s.Failures = v
	return s
}

// SetServices sets the Services field's value.
func (s *DescribeServicesOutput) SetServices(v []*Service) *DescribeServicesOutput {
	s.Services = v
	return s
}

type DescribeTaskDefinitionInput struct {
	_ struct{} `type:"structure"`

	// Determines whether to see the resource tags for the task definition. If TAGS
	// is specified, the tags are included in the response. If this field is omitted,
	// tags aren't included in the response.
	Include []*string `locationName:"include" type:"list" enum:"TaskDefinitionField"`

	// The family for the latest ACTIVE revision, family and revision (family:revision)
	// for a specific revision in the family, or full Amazon Resource Name (ARN)
	// of the task definition to describe.
	//
	// TaskDefinition is a required field
	TaskDefinition *string `locationName:"taskDefinition" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTaskDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTaskDefinitionInput"}
	if s.TaskDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskDefinition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInclude sets the Include field's value.
func (s *DescribeTaskDefinitionInput) SetInclude(v []*string) *DescribeTaskDefinitionInput {
	s.Include = v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *DescribeTaskDefinitionInput) SetTaskDefinition(v string) *DescribeTaskDefinitionInput {
	s.TaskDefinition = &v
	return s
}

type DescribeTaskDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The metadata that's applied to the task definition to help you categorize
	// and organize them. Each tag consists of a key and an optional value. You
	// define both.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The full task definition description.
	TaskDefinition *TaskDefinition `locationName:"taskDefinition" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskDefinitionOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *DescribeTaskDefinitionOutput) SetTags(v []*Tag) *DescribeTaskDefinitionOutput {
	s.Tags = v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *DescribeTaskDefinitionOutput) SetTaskDefinition(v *TaskDefinition) *DescribeTaskDefinitionOutput {
	s.TaskDefinition = v
	return s
}

type DescribeTaskSetsInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the service that the task sets exist in.
	//
	// Cluster is a required field
	Cluster *string `locationName:"cluster" type:"string" required:"true"`

	// Specifies whether to see the resource tags for the task set. If TAGS is specified,
	// the tags are included in the response. If this field is omitted, tags aren't
	// included in the response.
	Include []*string `locationName:"include" type:"list" enum:"TaskSetField"`

	// The short name or full Amazon Resource Name (ARN) of the service that the
	// task sets exist in.
	//
	// Service is a required field
	Service *string `locationName:"service" type:"string" required:"true"`

	// The ID or full Amazon Resource Name (ARN) of task sets to describe.
	TaskSets []*string `locationName:"taskSets" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTaskSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTaskSetsInput"}
	if s.Cluster == nil {
		invalidParams.Add(request.NewErrParamRequired("Cluster"))
	}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *DescribeTaskSetsInput) SetCluster(v string) *DescribeTaskSetsInput {
	s.Cluster = &v
	return s
}

// SetInclude sets the Include field's value.
func (s *DescribeTaskSetsInput) SetInclude(v []*string) *DescribeTaskSetsInput {
	s.Include = v
	return s
}

// SetService sets the Service field's value.
func (s *DescribeTaskSetsInput) SetService(v string) *DescribeTaskSetsInput {
	s.Service = &v
	return s
}

// SetTaskSets sets the TaskSets field's value.
func (s *DescribeTaskSetsInput) SetTaskSets(v []*string) *DescribeTaskSetsInput {
	s.TaskSets = v
	return s
}

type DescribeTaskSetsOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*Failure `locationName:"failures" type:"list"`

	// The list of task sets described.
	TaskSets []*TaskSet `locationName:"taskSets" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTaskSetsOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *DescribeTaskSetsOutput) SetFailures(v []*Failure) *DescribeTaskSetsOutput {
	s.Failures = v
	return s
}

// SetTaskSets sets the TaskSets field's value.
func (s *DescribeTaskSetsOutput) SetTaskSets(v []*TaskSet) *DescribeTaskSetsOutput {
	s.TaskSets = v
	return s
}

type DescribeTasksInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the task or tasks to describe. If you do not specify a cluster, the default
	// cluster is assumed. This parameter is required if the task or tasks you are
	// describing were launched in any cluster other than the default cluster.
	Cluster *string `locationName:"cluster" type:"string"`

	// Specifies whether you want to see the resource tags for the task. If TAGS
	// is specified, the tags are included in the response. If this field is omitted,
	// tags aren't included in the response.
	Include []*string `locationName:"include" type:"list" enum:"TaskField"`

	// A list of up to 100 task IDs or full ARN entries.
	//
	// Tasks is a required field
	Tasks []*string `locationName:"tasks" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTasksInput"}
	if s.Tasks == nil {
		invalidParams.Add(request.NewErrParamRequired("Tasks"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *DescribeTasksInput) SetCluster(v string) *DescribeTasksInput {
	s.Cluster = &v
	return s
}

// SetInclude sets the Include field's value.
func (s *DescribeTasksInput) SetInclude(v []*string) *DescribeTasksInput {
	s.Include = v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *DescribeTasksInput) SetTasks(v []*string) *DescribeTasksInput {
	s.Tasks = v
	return s
}

type DescribeTasksOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*Failure `locationName:"failures" type:"list"`

	// The list of tasks.
	Tasks []*Task `locationName:"tasks" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTasksOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *DescribeTasksOutput) SetFailures(v []*Failure) *DescribeTasksOutput {
	s.Failures = v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *DescribeTasksOutput) SetTasks(v []*Task) *DescribeTasksOutput {
	s.Tasks = v
	return s
}

// An object representing a container instance host device.
type Device struct {
	_ struct{} `type:"structure"`

	// The path inside the container at which to expose the host device.
	ContainerPath *string `locationName:"containerPath" type:"string"`

	// The path for the device on the host container instance.
	//
	// HostPath is a required field
	HostPath *string `locationName:"hostPath" type:"string" required:"true"`

	// The explicit permissions to provide to the container for the device. By default,
	// the container has permissions for read, write, and mknod for the device.
	Permissions []*string `locationName:"permissions" type:"list" enum:"DeviceCgroupPermission"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Device) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Device) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Device"}
	if s.HostPath == nil {
		invalidParams.Add(request.NewErrParamRequired("HostPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerPath sets the ContainerPath field's value.
func (s *Device) SetContainerPath(v string) *Device {
	s.ContainerPath = &v
	return s
}

// SetHostPath sets the HostPath field's value.
func (s *Device) SetHostPath(v string) *Device {
	s.HostPath = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *Device) SetPermissions(v []*string) *Device {
	s.Permissions = v
	return s
}

type DiscoverPollEndpointInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that the
	// container instance belongs to.
	Cluster *string `locationName:"cluster" type:"string"`

	// The container instance ID or full ARN of the container instance. For more
	// information about the ARN format, see Amazon Resource Name (ARN) (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids)
	// in the Amazon ECS Developer Guide.
	ContainerInstance *string `locationName:"containerInstance" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoverPollEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoverPollEndpointInput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DiscoverPollEndpointInput) SetCluster(v string) *DiscoverPollEndpointInput {
	s.Cluster = &v
	return s
}

// SetContainerInstance sets the ContainerInstance field's value.
func (s *DiscoverPollEndpointInput) SetContainerInstance(v string) *DiscoverPollEndpointInput {
	s.ContainerInstance = &v
	return s
}

type DiscoverPollEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint for the Amazon ECS agent to poll.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// The telemetry endpoint for the Amazon ECS agent.
	TelemetryEndpoint *string `locationName:"telemetryEndpoint" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoverPollEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoverPollEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *DiscoverPollEndpointOutput) SetEndpoint(v string) *DiscoverPollEndpointOutput {
	s.Endpoint = &v
	return s
}

// SetTelemetryEndpoint sets the TelemetryEndpoint field's value.
func (s *DiscoverPollEndpointOutput) SetTelemetryEndpoint(v string) *DiscoverPollEndpointOutput {
	s.TelemetryEndpoint = &v
	return s
}

// This parameter is specified when you're using Docker volumes. Docker volumes
// are only supported when you're using the EC2 launch type. Windows containers
// only support the use of the local driver. To use bind mounts, specify a host
// instead.
type DockerVolumeConfiguration struct {
	_ struct{} `type:"structure"`

	// If this value is true, the Docker volume is created if it doesn't already
	// exist.
	//
	// This field is only used if the scope is shared.
	Autoprovision *bool `locationName:"autoprovision" type:"boolean"`

	// The Docker volume driver to use. The driver value must match the driver name
	// provided by Docker because it is used for task placement. If the driver was
	// installed using the Docker plugin CLI, use docker plugin ls to retrieve the
	// driver name from your container instance. If the driver was installed using
	// another method, use Docker plugin discovery to retrieve the driver name.
	// For more information, see Docker plugin discovery (https://docs.docker.com/engine/extend/plugin_api/#plugin-discovery).
	// This parameter maps to Driver in the Create a volume (https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the xxdriver option to docker volume create (https://docs.docker.com/engine/reference/commandline/volume_create/).
	Driver *string `locationName:"driver" type:"string"`

	// A map of Docker driver-specific options passed through. This parameter maps
	// to DriverOpts in the Create a volume (https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the xxopt option to docker volume create (https://docs.docker.com/engine/reference/commandline/volume_create/).
	DriverOpts map[string]*string `locationName:"driverOpts" type:"map"`

	// Custom metadata to add to your Docker volume. This parameter maps to Labels
	// in the Create a volume (https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the xxlabel option to docker volume create (https://docs.docker.com/engine/reference/commandline/volume_create/).
	Labels map[string]*string `locationName:"labels" type:"map"`

	// The scope for the Docker volume that determines its lifecycle. Docker volumes
	// that are scoped to a task are automatically provisioned when the task starts
	// and destroyed when the task stops. Docker volumes that are scoped as shared
	// persist after the task stops.
	Scope *string `locationName:"scope" type:"string" enum:"Scope"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DockerVolumeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DockerVolumeConfiguration) GoString() string {
	return s.String()
}

// SetAutoprovision sets the Autoprovision field's value.
func (s *DockerVolumeConfiguration) SetAutoprovision(v bool) *DockerVolumeConfiguration {
	s.Autoprovision = &v
	return s
}

// SetDriver sets the Driver field's value.
func (s *DockerVolumeConfiguration) SetDriver(v string) *DockerVolumeConfiguration {
	s.Driver = &v
	return s
}

// SetDriverOpts sets the DriverOpts field's value.
func (s *DockerVolumeConfiguration) SetDriverOpts(v map[string]*string) *DockerVolumeConfiguration {
	s.DriverOpts = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *DockerVolumeConfiguration) SetLabels(v map[string]*string) *DockerVolumeConfiguration {
	s.Labels = v
	return s
}

// SetScope sets the Scope field's value.
func (s *DockerVolumeConfiguration) SetScope(v string) *DockerVolumeConfiguration {
	s.Scope = &v
	return s
}

// The authorization configuration details for the Amazon EFS file system.
type EFSAuthorizationConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon EFS access point ID to use. If an access point is specified, the
	// root directory value specified in the EFSVolumeConfiguration must either
	// be omitted or set to / which will enforce the path set on the EFS access
	// point. If an access point is used, transit encryption must be enabled in
	// the EFSVolumeConfiguration. For more information, see Working with Amazon
	// EFS access points (https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html)
	// in the Amazon Elastic File System User Guide.
	AccessPointId *string `locationName:"accessPointId" type:"string"`

	// Determines whether to use the Amazon ECS task IAM role defined in a task
	// definition when mounting the Amazon EFS file system. If enabled, transit
	// encryption must be enabled in the EFSVolumeConfiguration. If this parameter
	// is omitted, the default value of DISABLED is used. For more information,
	// see Using Amazon EFS access points (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints)
	// in the Amazon Elastic Container Service Developer Guide.
	Iam *string `locationName:"iam" type:"string" enum:"EFSAuthorizationConfigIAM"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EFSAuthorizationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EFSAuthorizationConfig) GoString() string {
	return s.String()
}

// SetAccessPointId sets the AccessPointId field's value.
func (s *EFSAuthorizationConfig) SetAccessPointId(v string) *EFSAuthorizationConfig {
	s.AccessPointId = &v
	return s
}

// SetIam sets the Iam field's value.
func (s *EFSAuthorizationConfig) SetIam(v string) *EFSAuthorizationConfig {
	s.Iam = &v
	return s
}

// This parameter is specified when you're using an Amazon Elastic File System
// file system for task storage. For more information, see Amazon EFS volumes
// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html)
// in the Amazon Elastic Container Service Developer Guide.
type EFSVolumeConfiguration struct {
	_ struct{} `type:"structure"`

	// The authorization configuration details for the Amazon EFS file system.
	AuthorizationConfig *EFSAuthorizationConfig `locationName:"authorizationConfig" type:"structure"`

	// The Amazon EFS file system ID to use.
	//
	// FileSystemId is a required field
	FileSystemId *string `locationName:"fileSystemId" type:"string" required:"true"`

	// The directory within the Amazon EFS file system to mount as the root directory
	// inside the host. If this parameter is omitted, the root of the Amazon EFS
	// volume will be used. Specifying / will have the same effect as omitting this
	// parameter.
	//
	// If an EFS access point is specified in the authorizationConfig, the root
	// directory parameter must either be omitted or set to / which will enforce
	// the path set on the EFS access point.
	RootDirectory *string `locationName:"rootDirectory" type:"string"`

	// Determines whether to use encryption for Amazon EFS data in transit between
	// the Amazon ECS host and the Amazon EFS server. Transit encryption must be
	// enabled if Amazon EFS IAM authorization is used. If this parameter is omitted,
	// the default value of DISABLED is used. For more information, see Encrypting
	// data in transit (https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html)
	// in the Amazon Elastic File System User Guide.
	TransitEncryption *string `locationName:"transitEncryption" type:"string" enum:"EFSTransitEncryption"`

	// The port to use when sending encrypted data between the Amazon ECS host and
	// the Amazon EFS server. If you do not specify a transit encryption port, it
	// will use the port selection strategy that the Amazon EFS mount helper uses.
	// For more information, see EFS mount helper (https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html)
	// in the Amazon Elastic File System User Guide.
	TransitEncryptionPort *int64 `locationName:"transitEncryptionPort" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EFSVolumeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EFSVolumeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EFSVolumeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EFSVolumeConfiguration"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationConfig sets the AuthorizationConfig field's value.
func (s *EFSVolumeConfiguration) SetAuthorizationConfig(v *EFSAuthorizationConfig) *EFSVolumeConfiguration {
	s.AuthorizationConfig = v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *EFSVolumeConfiguration) SetFileSystemId(v string) *EFSVolumeConfiguration {
	s.FileSystemId = &v
	return s
}

// SetRootDirectory sets the RootDirectory field's value.
func (s *EFSVolumeConfiguration) SetRootDirectory(v string) *EFSVolumeConfiguration {
	s.RootDirectory = &v
	return s
}

// SetTransitEncryption sets the TransitEncryption field's value.
func (s *EFSVolumeConfiguration) SetTransitEncryption(v string) *EFSVolumeConfiguration {
	s.TransitEncryption = &v
	return s
}

// SetTransitEncryptionPort sets the TransitEncryptionPort field's value.
func (s *EFSVolumeConfiguration) SetTransitEncryptionPort(v int64) *EFSVolumeConfiguration {
	s.TransitEncryptionPort = &v
	return s
}

// A list of files containing the environment variables to pass to a container.
// You can specify up to ten environment files. The file must have a .env file
// extension. Each line in an environment file should contain an environment
// variable in VARIABLE=VALUE format. Lines beginning with # are treated as
// comments and are ignored. For more information about the environment variable
// file syntax, see Declare default environment variables in file (https://docs.docker.com/compose/env-file/).
//
// If there are environment variables specified using the environment parameter
// in a container definition, they take precedence over the variables contained
// within an environment file. If multiple environment files are specified that
// contain the same variable, they're processed from the top down. We recommend
// that you use unique variable names. For more information, see Specifying
// environment variables (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// This parameter is only supported for tasks hosted on Fargate using the following
// platform versions:
//
//   - Linux platform version 1.4.0 or later.
//
//   - Windows platform version 1.0.0 or later.
type EnvironmentFile struct {
	_ struct{} `type:"structure"`

	// The file type to use. The only supported value is s3.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"EnvironmentFileType"`

	// The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment
	// variable file.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentFile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentFile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentFile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnvironmentFile"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *EnvironmentFile) SetType(v string) *EnvironmentFile {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvironmentFile) SetValue(v string) *EnvironmentFile {
	s.Value = &v
	return s
}

// The amount of ephemeral storage to allocate for the task. This parameter
// is used to expand the total amount of ephemeral storage available, beyond
// the default amount, for tasks hosted on Fargate. For more information, see
// Fargate task storage (https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html)
// in the Amazon ECS User Guide for Fargate.
//
// This parameter is only supported for tasks hosted on Fargate using Linux
// platform version 1.4.0 or later. This parameter is not supported for Windows
// containers on Fargate.
type EphemeralStorage struct {
	_ struct{} `type:"structure"`

	// The total amount, in GiB, of ephemeral storage to set for the task. The minimum
	// supported value is 21 GiB and the maximum supported value is 200 GiB.
	//
	// SizeInGiB is a required field
	SizeInGiB *int64 `locationName:"sizeInGiB" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EphemeralStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EphemeralStorage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EphemeralStorage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EphemeralStorage"}
	if s.SizeInGiB == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeInGiB"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSizeInGiB sets the SizeInGiB field's value.
func (s *EphemeralStorage) SetSizeInGiB(v int64) *EphemeralStorage {
	s.SizeInGiB = &v
	return s
}

// The details of the execute command configuration.
type ExecuteCommandConfiguration struct {
	_ struct{} `type:"structure"`

	// Specify an Key Management Service key ID to encrypt the data between the
	// local client and the container.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The log configuration for the results of the execute command actions. The
	// logs can be sent to CloudWatch Logs or an Amazon S3 bucket. When logging=OVERRIDE
	// is specified, a logConfiguration must be provided.
	LogConfiguration *ExecuteCommandLogConfiguration `locationName:"logConfiguration" type:"structure"`

	// The log setting to use for redirecting logs for your execute command results.
	// The following log settings are available.
	//
	//    * NONE: The execute command session is not logged.
	//
	//    * DEFAULT: The awslogs configuration in the task definition is used. If
	//    no logging parameter is specified, it defaults to this value. If no awslogs
	//    log driver is configured in the task definition, the output won't be logged.
	//
	//    * OVERRIDE: Specify the logging details as a part of logConfiguration.
	//    If the OVERRIDE logging option is specified, the logConfiguration is required.
	Logging *string `locationName:"logging" type:"string" enum:"ExecuteCommandLogging"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteCommandConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteCommandConfiguration) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ExecuteCommandConfiguration) SetKmsKeyId(v string) *ExecuteCommandConfiguration {
	s.KmsKeyId = &v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *ExecuteCommandConfiguration) SetLogConfiguration(v *ExecuteCommandLogConfiguration) *ExecuteCommandConfiguration {
	s.LogConfiguration = v
	return s
}

// SetLogging sets the Logging field's value.
func (s *ExecuteCommandConfiguration) SetLogging(v string) *ExecuteCommandConfiguration {
	s.Logging = &v
	return s
}

type ExecuteCommandInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or short name of the cluster the task is running
	// in. If you do not specify a cluster, the default cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// The command to run on the container.
	//
	// Command is a required field
	Command *string `locationName:"command" type:"string" required:"true"`

	// The name of the container to execute the command on. A container name only
	// needs to be specified for tasks containing multiple containers.
	Container *string `locationName:"container" type:"string"`

	// Use this flag to run your command in interactive mode.
	//
	// Interactive is a required field
	Interactive *bool `locationName:"interactive" type:"boolean" required:"true"`

	// The Amazon Resource Name (ARN) or ID of the task the container is part of.
	//
	// Task is a required field
	Task *string `locationName:"task" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteCommandInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteCommandInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteCommandInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteCommandInput"}
	if s.Command == nil {
		invalidParams.Add(request.NewErrParamRequired("Command"))
	}
	if s.Interactive == nil {
		invalidParams.Add(request.NewErrParamRequired("Interactive"))
	}
	if s.Task == nil {
		invalidParams.Add(request.NewErrParamRequired("Task"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *ExecuteCommandInput) SetCluster(v string) *ExecuteCommandInput {
	s.Cluster = &v
	return s
}

// SetCommand sets the Command field's value.
func (s *ExecuteCommandInput) SetCommand(v string) *ExecuteCommandInput {
	s.Command = &v
	return s
}

// SetContainer sets the Container field's value.
func (s *ExecuteCommandInput) SetContainer(v string) *ExecuteCommandInput {
	s.Container = &v
	return s
}

// SetInteractive sets the Interactive field's value.
func (s *ExecuteCommandInput) SetInteractive(v bool) *ExecuteCommandInput {
	s.Interactive = &v
	return s
}

// SetTask sets the Task field's value.
func (s *ExecuteCommandInput) SetTask(v string) *ExecuteCommandInput {
	s.Task = &v
	return s
}

// The log configuration for the results of the execute command actions. The
// logs can be sent to CloudWatch Logs or an Amazon S3 bucket.
type ExecuteCommandLogConfiguration struct {
	_ struct{} `type:"structure"`

	// Determines whether to use encryption on the CloudWatch logs. If not specified,
	// encryption will be disabled.
	CloudWatchEncryptionEnabled *bool `locationName:"cloudWatchEncryptionEnabled" type:"boolean"`

	// The name of the CloudWatch log group to send logs to.
	//
	// The CloudWatch log group must already be created.
	CloudWatchLogGroupName *string `locationName:"cloudWatchLogGroupName" type:"string"`

	// The name of the S3 bucket to send logs to.
	//
	// The S3 bucket must already be created.
	S3BucketName *string `locationName:"s3BucketName" type:"string"`

	// Determines whether to use encryption on the S3 logs. If not specified, encryption
	// is not used.
	S3EncryptionEnabled *bool `locationName:"s3EncryptionEnabled" type:"boolean"`

	// An optional folder in the S3 bucket to place logs in.
	S3KeyPrefix *string `locationName:"s3KeyPrefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteCommandLogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteCommandLogConfiguration) GoString() string {
	return s.String()
}

// SetCloudWatchEncryptionEnabled sets the CloudWatchEncryptionEnabled field's value.
func (s *ExecuteCommandLogConfiguration) SetCloudWatchEncryptionEnabled(v bool) *ExecuteCommandLogConfiguration {
	s.CloudWatchEncryptionEnabled = &v
	return s
}

// SetCloudWatchLogGroupName sets the CloudWatchLogGroupName field's value.
func (s *ExecuteCommandLogConfiguration) SetCloudWatchLogGroupName(v string) *ExecuteCommandLogConfiguration {
	s.CloudWatchLogGroupName = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *ExecuteCommandLogConfiguration) SetS3BucketName(v string) *ExecuteCommandLogConfiguration {
	s.S3BucketName = &v
	return s
}

// SetS3EncryptionEnabled sets the S3EncryptionEnabled field's value.
func (s *ExecuteCommandLogConfiguration) SetS3EncryptionEnabled(v bool) *ExecuteCommandLogConfiguration {
	s.S3EncryptionEnabled = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *ExecuteCommandLogConfiguration) SetS3KeyPrefix(v string) *ExecuteCommandLogConfiguration {
	s.S3KeyPrefix = &v
	return s
}

type ExecuteCommandOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the container.
	ContainerArn *string `locationName:"containerArn" type:"string"`

	// The name of the container.
	ContainerName *string `locationName:"containerName" type:"string"`

	// Determines whether the execute command session is running in interactive
	// mode. Amazon ECS only supports initiating interactive sessions, so you must
	// specify true for this value.
	Interactive *bool `locationName:"interactive" type:"boolean"`

	// The details of the SSM session that was created for this instance of execute-command.
	Session *Session `locationName:"session" type:"structure"`

	// The Amazon Resource Name (ARN) of the task.
	TaskArn *string `locationName:"taskArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteCommandOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteCommandOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ExecuteCommandOutput) SetClusterArn(v string) *ExecuteCommandOutput {
	s.ClusterArn = &v
	return s
}

// SetContainerArn sets the ContainerArn field's value.
func (s *ExecuteCommandOutput) SetContainerArn(v string) *ExecuteCommandOutput {
	s.ContainerArn = &v
	return s
}

// SetContainerName sets the ContainerName field's value.
func (s *ExecuteCommandOutput) SetContainerName(v string) *ExecuteCommandOutput {
	s.ContainerName = &v
	return s
}

// SetInteractive sets the Interactive field's value.
func (s *ExecuteCommandOutput) SetInteractive(v bool) *ExecuteCommandOutput {
	s.Interactive = &v
	return s
}

// SetSession sets the Session field's value.
func (s *ExecuteCommandOutput) SetSession(v *Session) *ExecuteCommandOutput {
	s.Session = v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *ExecuteCommandOutput) SetTaskArn(v string) *ExecuteCommandOutput {
	s.TaskArn = &v
	return s
}

// The authorization configuration details for Amazon FSx for Windows File Server
// file system. See FSxWindowsFileServerVolumeConfiguration (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_FSxWindowsFileServerVolumeConfiguration.html)
// in the Amazon ECS API Reference.
//
// For more information and the input format, see Amazon FSx for Windows File
// Server Volumes (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html)
// in the Amazon Elastic Container Service Developer Guide.
type FSxWindowsFileServerAuthorizationConfig struct {
	_ struct{} `type:"structure"`

	// The authorization credential option to use. The authorization credential
	// options can be provided using either the Amazon Resource Name (ARN) of an
	// Secrets Manager secret or SSM Parameter Store parameter. The ARN refers to
	// the stored credentials.
	//
	// CredentialsParameter is a required field
	CredentialsParameter *string `locationName:"credentialsParameter" type:"string" required:"true"`

	// A fully qualified domain name hosted by an Directory Service (https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html)
	// Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FSxWindowsFileServerAuthorizationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FSxWindowsFileServerAuthorizationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FSxWindowsFileServerAuthorizationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FSxWindowsFileServerAuthorizationConfig"}
	if s.CredentialsParameter == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsParameter"))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentialsParameter sets the CredentialsParameter field's value.
func (s *FSxWindowsFileServerAuthorizationConfig) SetCredentialsParameter(v string) *FSxWindowsFileServerAuthorizationConfig {
	s.CredentialsParameter = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *FSxWindowsFileServerAuthorizationConfig) SetDomain(v string) *FSxWindowsFileServerAuthorizationConfig {
	s.Domain = &v
	return s
}

// This parameter is specified when you're using Amazon FSx for Windows File
// Server (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/what-is.html)
// file system for task storage.
//
// For more information and the input format, see Amazon FSx for Windows File
// Server volumes (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html)
// in the Amazon Elastic Container Service Developer Guide.
type FSxWindowsFileServerVolumeConfiguration struct {
	_ struct{} `type:"structure"`

	// The authorization configuration details for the Amazon FSx for Windows File
	// Server file system.
	//
	// AuthorizationConfig is a required field
	AuthorizationConfig *FSxWindowsFileServerAuthorizationConfig `locationName:"authorizationConfig" type:"structure" required:"true"`

	// The Amazon FSx for Windows File Server file system ID to use.
	//
	// FileSystemId is a required field
	FileSystemId *string `locationName:"fileSystemId" type:"string" required:"true"`

	// The directory within the Amazon FSx for Windows File Server file system to
	// mount as the root directory inside the host.
	//
	// RootDirectory is a required field
	RootDirectory *string `locationName:"rootDirectory" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FSxWindowsFileServerVolumeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FSxWindowsFileServerVolumeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FSxWindowsFileServerVolumeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FSxWindowsFileServerVolumeConfiguration"}
	if s.AuthorizationConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizationConfig"))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.RootDirectory == nil {
		invalidParams.Add(request.NewErrParamRequired("RootDirectory"))
	}
	if s.AuthorizationConfig != nil {
		if err := s.AuthorizationConfig.Validate(); err != nil {
			invalidParams.AddNested("AuthorizationConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationConfig sets the AuthorizationConfig field's value.
func (s *FSxWindowsFileServerVolumeConfiguration) SetAuthorizationConfig(v *FSxWindowsFileServerAuthorizationConfig) *FSxWindowsFileServerVolumeConfiguration {
	s.AuthorizationConfig = v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *FSxWindowsFileServerVolumeConfiguration) SetFileSystemId(v string) *FSxWindowsFileServerVolumeConfiguration {
	s.FileSystemId = &v
	return s
}

// SetRootDirectory sets the RootDirectory field's value.
func (s *FSxWindowsFileServerVolumeConfiguration) SetRootDirectory(v string) *FSxWindowsFileServerVolumeConfiguration {
	s.RootDirectory = &v
	return s
}

// A failed resource. For a list of common causes, see API failure reasons (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/api_failures_messages.html)
// in the Amazon Elastic Container Service Developer Guide.
type Failure struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the failed resource.
	Arn *string `locationName:"arn" type:"string"`

	// The details of the failure.
	Detail *string `locationName:"detail" type:"string"`

	// The reason for the failure.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Failure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Failure) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Failure) SetArn(v string) *Failure {
	s.Arn = &v
	return s
}

// SetDetail sets the Detail field's value.
func (s *Failure) SetDetail(v string) *Failure {
	s.Detail = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *Failure) SetReason(v string) *Failure {
	s.Reason = &v
	return s
}

// The FireLens configuration for the container. This is used to specify and
// configure a log router for container logs. For more information, see Custom
// log routing (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html)
// in the Amazon Elastic Container Service Developer Guide.
type FirelensConfiguration struct {
	_ struct{} `type:"structure"`

	// The options to use when configuring the log router. This field is optional
	// and can be used to specify a custom configuration file or to add additional
	// metadata, such as the task, task definition, cluster, and container instance
	// details to the log event. If specified, the syntax to use is "options":{"enable-ecs-log-metadata":"true|false","config-file-type:"s3|file","config-file-value":"arn:aws:s3:::mybucket/fluent.conf|filepath"}.
	// For more information, see Creating a task definition that uses a FireLens
	// configuration (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// Tasks hosted on Fargate only support the file configuration file type.
	Options map[string]*string `locationName:"options" type:"map"`

	// The log router to use. The valid values are fluentd or fluentbit.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FirelensConfigurationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirelensConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirelensConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FirelensConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FirelensConfiguration"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOptions sets the Options field's value.
func (s *FirelensConfiguration) SetOptions(v map[string]*string) *FirelensConfiguration {
	s.Options = v
	return s
}

// SetType sets the Type field's value.
func (s *FirelensConfiguration) SetType(v string) *FirelensConfiguration {
	s.Type = &v
	return s
}

// An object representing a container health check. Health check parameters
// that are specified in a container definition override any Docker health checks
// that exist in the container image (such as those specified in a parent image
// or from the image's Dockerfile).
//
// The Amazon ECS container agent only monitors and reports on the health checks
// specified in the task definition. Amazon ECS does not monitor Docker health
// checks that are embedded in a container image and not specified in the container
// definition. Health check parameters that are specified in a container definition
// override any Docker health checks that exist in the container image.
//
// You can view the health status of both individual containers and a task with
// the DescribeTasks API operation or when viewing the task details in the console.
//
// The following describes the possible healthStatus values for a container:
//
//   - HEALTHY-The container health check has passed successfully.
//
//   - UNHEALTHY-The container health check has failed.
//
//   - UNKNOWN-The container health check is being evaluated or there's no
//     container health check defined.
//
// The following describes the possible healthStatus values for a task. The
// container health check status of nonessential containers do not have an effect
// on the health status of a task.
//
//   - HEALTHY-All essential containers within the task have passed their health
//     checks.
//
//   - UNHEALTHY-One or more essential containers have failed their health
//     check.
//
//   - UNKNOWN-The essential containers within the task are still having their
//     health checks evaluated or there are no container health checks defined.
//
// If a task is run manually, and not as part of a service, the task will continue
// its lifecycle regardless of its health status. For tasks that are part of
// a service, if the task reports as unhealthy then the task will be stopped
// and the service scheduler will replace it.
//
// The following are notes about container health check support:
//
//   - Container health checks require version 1.17.0 or greater of the Amazon
//     ECS container agent. For more information, see Updating the Amazon ECS
//     container agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html).
//
//   - Container health checks are supported for Fargate tasks if you're using
//     platform version 1.1.0 or greater. For more information, see Fargate platform
//     versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
//
//   - Container health checks aren't supported for tasks that are part of
//     a service that's configured to use a Classic Load Balancer.
type HealthCheck struct {
	_ struct{} `type:"structure"`

	// A string array representing the command that the container runs to determine
	// if it is healthy. The string array must start with CMD to execute the command
	// arguments directly, or CMD-SHELL to run the command with the container's
	// default shell.
	//
	// When you use the Amazon Web Services Management Console JSON panel, the Command
	// Line Interface, or the APIs, enclose the list of commands in brackets.
	//
	// [ "CMD-SHELL", "curl -f http://localhost/ || exit 1" ]
	//
	// You don't need to include the brackets when you use the Amazon Web Services
	// Management Console.
	//
	// "CMD-SHELL", "curl -f http://localhost/ || exit 1"
	//
	// An exit code of 0 indicates success, and non-zero exit code indicates failure.
	// For more information, see HealthCheck in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/).
	//
	// Command is a required field
	Command []*string `locationName:"command" type:"list" required:"true"`

	// The time period in seconds between each health check execution. You may specify
	// between 5 and 300 seconds. The default value is 30 seconds.
	Interval *int64 `locationName:"interval" type:"integer"`

	// The number of times to retry a failed health check before the container is
	// considered unhealthy. You may specify between 1 and 10 retries. The default
	// value is 3.
	Retries *int64 `locationName:"retries" type:"integer"`

	// The optional grace period to provide containers time to bootstrap before
	// failed health checks count towards the maximum number of retries. You can
	// specify between 0 and 300 seconds. By default, the startPeriod is disabled.
	//
	// If a health check succeeds within the startPeriod, then the container is
	// considered healthy and any subsequent failures count toward the maximum number
	// of retries.
	StartPeriod *int64 `locationName:"startPeriod" type:"integer"`

	// The time period in seconds to wait for a health check to succeed before it
	// is considered a failure. You may specify between 2 and 60 seconds. The default
	// value is 5.
	Timeout *int64 `locationName:"timeout" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HealthCheck) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HealthCheck) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheck) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheck"}
	if s.Command == nil {
		invalidParams.Add(request.NewErrParamRequired("Command"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *HealthCheck) SetCommand(v []*string) *HealthCheck {
	s.Command = v
	return s
}

// SetInterval sets the Interval field's value.
func (s *HealthCheck) SetInterval(v int64) *HealthCheck {
	s.Interval = &v
	return s
}

// SetRetries sets the Retries field's value.
func (s *HealthCheck) SetRetries(v int64) *HealthCheck {
	s.Retries = &v
	return s
}

// SetStartPeriod sets the StartPeriod field's value.
func (s *HealthCheck) SetStartPeriod(v int64) *HealthCheck {
	s.StartPeriod = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *HealthCheck) SetTimeout(v int64) *HealthCheck {
	s.Timeout = &v
	return s
}

// Hostnames and IP address entries that are added to the /etc/hosts file of
// a container via the extraHosts parameter of its ContainerDefinition.
type HostEntry struct {
	_ struct{} `type:"structure"`

	// The hostname to use in the /etc/hosts entry.
	//
	// Hostname is a required field
	Hostname *string `locationName:"hostname" type:"string" required:"true"`

	// The IP address to use in the /etc/hosts entry.
	//
	// IpAddress is a required field
	IpAddress *string `locationName:"ipAddress" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HostEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HostEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HostEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HostEntry"}
	if s.Hostname == nil {
		invalidParams.Add(request.NewErrParamRequired("Hostname"))
	}
	if s.IpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddress"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostname sets the Hostname field's value.
func (s *HostEntry) SetHostname(v string) *HostEntry {
	s.Hostname = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *HostEntry) SetIpAddress(v string) *HostEntry {
	s.IpAddress = &v
	return s
}

// Details on a container instance bind mount host volume.
type HostVolumeProperties struct {
	_ struct{} `type:"structure"`

	// When the host parameter is used, specify a sourcePath to declare the path
	// on the host container instance that's presented to the container. If this
	// parameter is empty, then the Docker daemon has assigned a host path for you.
	// If the host parameter contains a sourcePath file location, then the data
	// volume persists at the specified location on the host container instance
	// until you delete it manually. If the sourcePath value doesn't exist on the
	// host container instance, the Docker daemon creates it. If the location does
	// exist, the contents of the source path folder are exported.
	//
	// If you're using the Fargate launch type, the sourcePath parameter is not
	// supported.
	SourcePath *string `locationName:"sourcePath" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HostVolumeProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HostVolumeProperties) GoString() string {
	return s.String()
}

// SetSourcePath sets the SourcePath field's value.
func (s *HostVolumeProperties) SetSourcePath(v string) *HostVolumeProperties {
	s.SourcePath = &v
	return s
}

// Details on an Elastic Inference accelerator. For more information, see Working
// with Amazon Elastic Inference on Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html)
// in the Amazon Elastic Container Service Developer Guide.
type InferenceAccelerator struct {
	_ struct{} `type:"structure"`

	// The Elastic Inference accelerator device name. The deviceName must also be
	// referenced in a container definition as a ResourceRequirement.
	//
	// DeviceName is a required field
	DeviceName *string `locationName:"deviceName" type:"string" required:"true"`

	// The Elastic Inference accelerator type to use.
	//
	// DeviceType is a required field
	DeviceType *string `locationName:"deviceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceAccelerator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceAccelerator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InferenceAccelerator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InferenceAccelerator"}
	if s.DeviceName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceName"))
	}
	if s.DeviceType == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceName sets the DeviceName field's value.
func (s *InferenceAccelerator) SetDeviceName(v string) *InferenceAccelerator {
	s.DeviceName = &v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *InferenceAccelerator) SetDeviceType(v string) *InferenceAccelerator {
	s.DeviceType = &v
	return s
}

// Details on an Elastic Inference accelerator task override. This parameter
// is used to override the Elastic Inference accelerator specified in the task
// definition. For more information, see Working with Amazon Elastic Inference
// on Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html)
// in the Amazon Elastic Container Service Developer Guide.
type InferenceAcceleratorOverride struct {
	_ struct{} `type:"structure"`

	// The Elastic Inference accelerator device name to override for the task. This
	// parameter must match a deviceName specified in the task definition.
	DeviceName *string `locationName:"deviceName" type:"string"`

	// The Elastic Inference accelerator type to use.
	DeviceType *string `locationName:"deviceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceAcceleratorOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceAcceleratorOverride) GoString() string {
	return s.String()
}

// SetDeviceName sets the DeviceName field's value.
func (s *InferenceAcceleratorOverride) SetDeviceName(v string) *InferenceAcceleratorOverride {
	s.DeviceName = &v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *InferenceAcceleratorOverride) SetDeviceType(v string) *InferenceAcceleratorOverride {
	s.DeviceType = &v
	return s
}

// An object representing the result of a container instance health status check.
type InstanceHealthCheckResult struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp for when the container instance health status last changed.
	LastStatusChange *time.Time `locationName:"lastStatusChange" type:"timestamp"`

	// The Unix timestamp for when the container instance health status was last
	// updated.
	LastUpdated *time.Time `locationName:"lastUpdated" type:"timestamp"`

	// The container instance health status.
	Status *string `locationName:"status" type:"string" enum:"InstanceHealthCheckState"`

	// The type of container instance health status that was verified.
	Type *string `locationName:"type" type:"string" enum:"InstanceHealthCheckType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceHealthCheckResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceHealthCheckResult) GoString() string {
	return s.String()
}

// SetLastStatusChange sets the LastStatusChange field's value.
func (s *InstanceHealthCheckResult) SetLastStatusChange(v time.Time) *InstanceHealthCheckResult {
	s.LastStatusChange = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *InstanceHealthCheckResult) SetLastUpdated(v time.Time) *InstanceHealthCheckResult {
	s.LastUpdated = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceHealthCheckResult) SetStatus(v string) *InstanceHealthCheckResult {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *InstanceHealthCheckResult) SetType(v string) *InstanceHealthCheckResult {
	s.Type = &v
	return s
}

// The specified parameter isn't valid. Review the available parameters for
// the API request.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Linux capabilities for the container that are added to or dropped from
// the default configuration provided by Docker. For more information about
// the default capabilities and the non-default available capabilities, see
// Runtime privilege and Linux capabilities (https://docs.docker.com/engine/reference/run/#runtime-privilege-and-linux-capabilities)
// in the Docker run reference. For more detailed information about these Linux
// capabilities, see the capabilities(7) (http://man7.org/linux/man-pages/man7/capabilities.7.html)
// Linux manual page.
type KernelCapabilities struct {
	_ struct{} `type:"structure"`

	// The Linux capabilities for the container that have been added to the default
	// configuration provided by Docker. This parameter maps to CapAdd in the Create
	// a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --cap-add option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// Tasks launched on Fargate only support adding the SYS_PTRACE kernel capability.
	//
	// Valid values: "ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" |
	// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK"
	// | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE"
	// | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW"
	// | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT"
	// | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" |
	// "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" |
	// "WAKE_ALARM"
	Add []*string `locationName:"add" type:"list"`

	// The Linux capabilities for the container that have been removed from the
	// default configuration provided by Docker. This parameter maps to CapDrop
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --cap-drop option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// Valid values: "ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" |
	// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK"
	// | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE"
	// | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW"
	// | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT"
	// | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" |
	// "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" |
	// "WAKE_ALARM"
	Drop []*string `locationName:"drop" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KernelCapabilities) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KernelCapabilities) GoString() string {
	return s.String()
}

// SetAdd sets the Add field's value.
func (s *KernelCapabilities) SetAdd(v []*string) *KernelCapabilities {
	s.Add = v
	return s
}

// SetDrop sets the Drop field's value.
func (s *KernelCapabilities) SetDrop(v []*string) *KernelCapabilities {
	s.Drop = v
	return s
}

// A key-value pair object.
type KeyValuePair struct {
	_ struct{} `type:"structure"`

	// The name of the key-value pair. For environment variables, this is the name
	// of the environment variable.
	Name *string `locationName:"name" type:"string"`

	// The value of the key-value pair. For environment variables, this is the value
	// of the environment variable.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyValuePair) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *KeyValuePair) SetName(v string) *KeyValuePair {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *KeyValuePair) SetValue(v string) *KeyValuePair {
	s.Value = &v
	return s
}

// The limit for the resource was exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Linux-specific options that are applied to the container, such as Linux KernelCapabilities.
type LinuxParameters struct {
	_ struct{} `type:"structure"`

	// The Linux capabilities for the container that are added to or dropped from
	// the default configuration provided by Docker.
	//
	// For tasks that use the Fargate launch type, capabilities is supported for
	// all platform versions but the add parameter is only supported if using platform
	// version 1.4.0 or later.
	Capabilities *KernelCapabilities `locationName:"capabilities" type:"structure"`

	// Any host devices to expose to the container. This parameter maps to Devices
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --device option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// If you're using tasks that use the Fargate launch type, the devices parameter
	// isn't supported.
	Devices []*Device `locationName:"devices" type:"list"`

	// Run an init process inside the container that forwards signals and reaps
	// processes. This parameter maps to the --init option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	// This parameter requires version 1.25 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	InitProcessEnabled *bool `locationName:"initProcessEnabled" type:"boolean"`

	// The total amount of swap memory (in MiB) a container can use. This parameter
	// will be translated to the --memory-swap option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration)
	// where the value would be the sum of the container memory plus the maxSwap
	// value.
	//
	// If a maxSwap value of 0 is specified, the container will not use swap. Accepted
	// values are 0 or any positive integer. If the maxSwap parameter is omitted,
	// the container will use the swap configuration for the container instance
	// it is running on. A maxSwap value must be set for the swappiness parameter
	// to be used.
	//
	// If you're using tasks that use the Fargate launch type, the maxSwap parameter
	// isn't supported.
	MaxSwap *int64 `locationName:"maxSwap" type:"integer"`

	// The value for the size (in MiB) of the /dev/shm volume. This parameter maps
	// to the --shm-size option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// If you are using tasks that use the Fargate launch type, the sharedMemorySize
	// parameter is not supported.
	SharedMemorySize *int64 `locationName:"sharedMemorySize" type:"integer"`

	// This allows you to tune a container's memory swappiness behavior. A swappiness
	// value of 0 will cause swapping to not happen unless absolutely necessary.
	// A swappiness value of 100 will cause pages to be swapped very aggressively.
	// Accepted values are whole numbers between 0 and 100. If the swappiness parameter
	// is not specified, a default value of 60 is used. If a value is not specified
	// for maxSwap then this parameter is ignored. This parameter maps to the --memory-swappiness
	// option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// If you're using tasks that use the Fargate launch type, the swappiness parameter
	// isn't supported.
	Swappiness *int64 `locationName:"swappiness" type:"integer"`

	// The container path, mount options, and size (in MiB) of the tmpfs mount.
	// This parameter maps to the --tmpfs option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// If you're using tasks that use the Fargate launch type, the tmpfs parameter
	// isn't supported.
	Tmpfs []*Tmpfs `locationName:"tmpfs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LinuxParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LinuxParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LinuxParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LinuxParameters"}
	if s.Devices != nil {
		for i, v := range s.Devices {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Devices", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tmpfs != nil {
		for i, v := range s.Tmpfs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tmpfs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *LinuxParameters) SetCapabilities(v *KernelCapabilities) *LinuxParameters {
	s.Capabilities = v
	return s
}

// SetDevices sets the Devices field's value.
func (s *LinuxParameters) SetDevices(v []*Device) *LinuxParameters {
	s.Devices = v
	return s
}

// SetInitProcessEnabled sets the InitProcessEnabled field's value.
func (s *LinuxParameters) SetInitProcessEnabled(v bool) *LinuxParameters {
	s.InitProcessEnabled = &v
	return s
}

// SetMaxSwap sets the MaxSwap field's value.
func (s *LinuxParameters) SetMaxSwap(v int64) *LinuxParameters {
	s.MaxSwap = &v
	return s
}

// SetSharedMemorySize sets the SharedMemorySize field's value.
func (s *LinuxParameters) SetSharedMemorySize(v int64) *LinuxParameters {
	s.SharedMemorySize = &v
	return s
}

// SetSwappiness sets the Swappiness field's value.
func (s *LinuxParameters) SetSwappiness(v int64) *LinuxParameters {
	s.Swappiness = &v
	return s
}

// SetTmpfs sets the Tmpfs field's value.
func (s *LinuxParameters) SetTmpfs(v []*Tmpfs) *LinuxParameters {
	s.Tmpfs = v
	return s
}

type ListAccountSettingsInput struct {
	_ struct{} `type:"structure"`

	// Determines whether to return the effective settings. If true, the account
	// settings for the root user or the default setting for the principalArn are
	// returned. If false, the account settings for the principalArn are returned
	// if they're set. Otherwise, no account settings are returned.
	EffectiveSettings *bool `locationName:"effectiveSettings" type:"boolean"`

	// The maximum number of account setting results returned by ListAccountSettings
	// in paginated output. When this parameter is used, ListAccountSettings only
	// returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another ListAccountSettings request with the returned nextToken value. This
	// value can be between 1 and 10. If this parameter isn't used, then ListAccountSettings
	// returns up to 10 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The name of the account setting you want to list the settings for.
	Name *string `locationName:"name" type:"string" enum:"SettingName"`

	// The nextToken value returned from a ListAccountSettings request indicating
	// that more results are available to fulfill the request and further calls
	// will be needed. If maxResults was provided, it's possible the number of results
	// to be fewer than maxResults.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ARN of the principal, which can be an IAM user, IAM role, or the root
	// user. If this field is omitted, the account settings are listed only for
	// the authenticated user.
	//
	// Federated users assume the account setting of the root user and can't have
	// explicit account settings set for them.
	PrincipalArn *string `locationName:"principalArn" type:"string"`

	// The value of the account settings to filter results with. You must also specify
	// an account setting name to use this parameter.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountSettingsInput) GoString() string {
	return s.String()
}

// SetEffectiveSettings sets the EffectiveSettings field's value.
func (s *ListAccountSettingsInput) SetEffectiveSettings(v bool) *ListAccountSettingsInput {
	s.EffectiveSettings = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountSettingsInput) SetMaxResults(v int64) *ListAccountSettingsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListAccountSettingsInput) SetName(v string) *ListAccountSettingsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountSettingsInput) SetNextToken(v string) *ListAccountSettingsInput {
	s.NextToken = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *ListAccountSettingsInput) SetPrincipalArn(v string) *ListAccountSettingsInput {
	s.PrincipalArn = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ListAccountSettingsInput) SetValue(v string) *ListAccountSettingsInput {
	s.Value = &v
	return s
}

type ListAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListAccountSettings request. When
	// the results of a ListAccountSettings request exceed maxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The account settings for the resource.
	Settings []*Setting `locationName:"settings" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountSettingsOutput) SetNextToken(v string) *ListAccountSettingsOutput {
	s.NextToken = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *ListAccountSettingsOutput) SetSettings(v []*Setting) *ListAccountSettingsOutput {
	s.Settings = v
	return s
}

type ListAttributesInput struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to filter the results with.
	AttributeName *string `locationName:"attributeName" type:"string"`

	// The value of the attribute to filter results with. You must also specify
	// an attribute name to use this parameter.
	AttributeValue *string `locationName:"attributeValue" type:"string"`

	// The short name or full Amazon Resource Name (ARN) of the cluster to list
	// attributes. If you do not specify a cluster, the default cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// The maximum number of cluster results that ListAttributes returned in paginated
	// output. When this parameter is used, ListAttributes only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another ListAttributes
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter isn't used, then ListAttributes returns up to 100
	// results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a ListAttributes request indicating that
	// more results are available to fulfill the request and further calls are needed.
	// If maxResults was provided, it's possible the number of results to be fewer
	// than maxResults.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The type of the target to list attributes with.
	//
	// TargetType is a required field
	TargetType *string `locationName:"targetType" type:"string" required:"true" enum:"TargetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAttributesInput"}
	if s.TargetType == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *ListAttributesInput) SetAttributeName(v string) *ListAttributesInput {
	s.AttributeName = &v
	return s
}

// SetAttributeValue sets the AttributeValue field's value.
func (s *ListAttributesInput) SetAttributeValue(v string) *ListAttributesInput {
	s.AttributeValue = &v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *ListAttributesInput) SetCluster(v string) *ListAttributesInput {
	s.Cluster = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAttributesInput) SetMaxResults(v int64) *ListAttributesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttributesInput) SetNextToken(v string) *ListAttributesInput {
	s.NextToken = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *ListAttributesInput) SetTargetType(v string) *ListAttributesInput {
	s.TargetType = &v
	return s
}

type ListAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A list of attribute objects that meet the criteria of the request.
	Attributes []*Attribute `locationName:"attributes" type:"list"`

	// The nextToken value to include in a future ListAttributes request. When the
	// results of a ListAttributes request exceed maxResults, this value can be
	// used to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ListAttributesOutput) SetAttributes(v []*Attribute) *ListAttributesOutput {
	s.Attributes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttributesOutput) SetNextToken(v string) *ListAttributesOutput {
	s.NextToken = &v
	return s
}

type ListClustersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of cluster results that ListClusters returned in paginated
	// output. When this parameter is used, ListClusters only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another ListClusters
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter isn't used, then ListClusters returns up to 100 results
	// and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a ListClusters request indicating that
	// more results are available to fulfill the request and further calls are needed.
	// If maxResults was provided, it's possible the number of results to be fewer
	// than maxResults.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClustersInput) SetMaxResults(v int64) *ListClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersInput) SetNextToken(v string) *ListClustersInput {
	s.NextToken = &v
	return s
}

type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// The list of full Amazon Resource Name (ARN) entries for each cluster that's
	// associated with your account.
	ClusterArns []*string `locationName:"clusterArns" type:"list"`

	// The nextToken value to include in a future ListClusters request. When the
	// results of a ListClusters request exceed maxResults, this value can be used
	// to retrieve the next page of results. This value is null when there are no
	// more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetClusterArns sets the ClusterArns field's value.
func (s *ListClustersOutput) SetClusterArns(v []*string) *ListClustersOutput {
	s.ClusterArns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersOutput) SetNextToken(v string) *ListClustersOutput {
	s.NextToken = &v
	return s
}

type ListContainerInstancesInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the container instances to list. If you do not specify a cluster, the default
	// cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// You can filter the results of a ListContainerInstances operation with cluster
	// query language statements. For more information, see Cluster Query Language
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Filter *string `locationName:"filter" type:"string"`

	// The maximum number of container instance results that ListContainerInstances
	// returned in paginated output. When this parameter is used, ListContainerInstances
	// only returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another ListContainerInstances request with the returned nextToken value.
	// This value can be between 1 and 100. If this parameter isn't used, then ListContainerInstances
	// returns up to 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a ListContainerInstances request indicating
	// that more results are available to fulfill the request and further calls
	// are needed. If maxResults was provided, it's possible the number of results
	// to be fewer than maxResults.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Filters the container instances by status. For example, if you specify the
	// DRAINING status, the results include only container instances that have been
	// set to DRAINING using UpdateContainerInstancesState. If you don't specify
	// this parameter, the default is to include container instances set to all
	// states other than INACTIVE.
	Status *string `locationName:"status" type:"string" enum:"ContainerInstanceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContainerInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContainerInstancesInput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ListContainerInstancesInput) SetCluster(v string) *ListContainerInstancesInput {
	s.Cluster = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListContainerInstancesInput) SetFilter(v string) *ListContainerInstancesInput {
	s.Filter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListContainerInstancesInput) SetMaxResults(v int64) *ListContainerInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContainerInstancesInput) SetNextToken(v string) *ListContainerInstancesInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListContainerInstancesInput) SetStatus(v string) *ListContainerInstancesInput {
	s.Status = &v
	return s
}

type ListContainerInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The list of container instances with full ARN entries for each container
	// instance associated with the specified cluster.
	ContainerInstanceArns []*string `locationName:"containerInstanceArns" type:"list"`

	// The nextToken value to include in a future ListContainerInstances request.
	// When the results of a ListContainerInstances request exceed maxResults, this
	// value can be used to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContainerInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContainerInstancesOutput) GoString() string {
	return s.String()
}

// SetContainerInstanceArns sets the ContainerInstanceArns field's value.
func (s *ListContainerInstancesOutput) SetContainerInstanceArns(v []*string) *ListContainerInstancesOutput {
	s.ContainerInstanceArns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContainerInstancesOutput) SetNextToken(v string) *ListContainerInstancesOutput {
	s.NextToken = &v
	return s
}

type ListServicesInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster to use when
	// filtering the ListServices results. If you do not specify a cluster, the
	// default cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// The launch type to use when filtering the ListServices results.
	LaunchType *string `locationName:"launchType" type:"string" enum:"LaunchType"`

	// The maximum number of service results that ListServices returned in paginated
	// output. When this parameter is used, ListServices only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another ListServices
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter isn't used, then ListServices returns up to 10 results
	// and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a ListServices request indicating that
	// more results are available to fulfill the request and further calls will
	// be needed. If maxResults was provided, it is possible the number of results
	// to be fewer than maxResults.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The scheduling strategy to use when filtering the ListServices results.
	SchedulingStrategy *string `locationName:"schedulingStrategy" type:"string" enum:"SchedulingStrategy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesInput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ListServicesInput) SetCluster(v string) *ListServicesInput {
	s.Cluster = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *ListServicesInput) SetLaunchType(v string) *ListServicesInput {
	s.LaunchType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServicesInput) SetMaxResults(v int64) *ListServicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesInput) SetNextToken(v string) *ListServicesInput {
	s.NextToken = &v
	return s
}

// SetSchedulingStrategy sets the SchedulingStrategy field's value.
func (s *ListServicesInput) SetSchedulingStrategy(v string) *ListServicesInput {
	s.SchedulingStrategy = &v
	return s
}

type ListServicesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListServices request. When the
	// results of a ListServices request exceed maxResults, this value can be used
	// to retrieve the next page of results. This value is null when there are no
	// more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of full ARN entries for each service that's associated with the
	// specified cluster.
	ServiceArns []*string `locationName:"serviceArns" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesOutput) SetNextToken(v string) *ListServicesOutput {
	s.NextToken = &v
	return s
}

// SetServiceArns sets the ServiceArns field's value.
func (s *ListServicesOutput) SetServiceArns(v []*string) *ListServicesOutput {
	s.ServiceArns = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the resource to list the tags
	// for. Currently, the supported resources are Amazon ECS tasks, services, task
	// definitions, clusters, and container instances.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTaskDefinitionFamiliesInput struct {
	_ struct{} `type:"structure"`

	// The familyPrefix is a string that's used to filter the results of ListTaskDefinitionFamilies.
	// If you specify a familyPrefix, only task definition family names that begin
	// with the familyPrefix string are returned.
	FamilyPrefix *string `locationName:"familyPrefix" type:"string"`

	// The maximum number of task definition family results that ListTaskDefinitionFamilies
	// returned in paginated output. When this parameter is used, ListTaskDefinitions
	// only returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another ListTaskDefinitionFamilies request with the returned nextToken value.
	// This value can be between 1 and 100. If this parameter isn't used, then ListTaskDefinitionFamilies
	// returns up to 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a ListTaskDefinitionFamilies request indicating
	// that more results are available to fulfill the request and further calls
	// will be needed. If maxResults was provided, it is possible the number of
	// results to be fewer than maxResults.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The task definition family status to filter the ListTaskDefinitionFamilies
	// results with. By default, both ACTIVE and INACTIVE task definition families
	// are listed. If this parameter is set to ACTIVE, only task definition families
	// that have an ACTIVE task definition revision are returned. If this parameter
	// is set to INACTIVE, only task definition families that do not have any ACTIVE
	// task definition revisions are returned. If you paginate the resulting output,
	// be sure to keep the status value constant in each subsequent request.
	Status *string `locationName:"status" type:"string" enum:"TaskDefinitionFamilyStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaskDefinitionFamiliesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaskDefinitionFamiliesInput) GoString() string {
	return s.String()
}

// SetFamilyPrefix sets the FamilyPrefix field's value.
func (s *ListTaskDefinitionFamiliesInput) SetFamilyPrefix(v string) *ListTaskDefinitionFamiliesInput {
	s.FamilyPrefix = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTaskDefinitionFamiliesInput) SetMaxResults(v int64) *ListTaskDefinitionFamiliesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTaskDefinitionFamiliesInput) SetNextToken(v string) *ListTaskDefinitionFamiliesInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTaskDefinitionFamiliesInput) SetStatus(v string) *ListTaskDefinitionFamiliesInput {
	s.Status = &v
	return s
}

type ListTaskDefinitionFamiliesOutput struct {
	_ struct{} `type:"structure"`

	// The list of task definition family names that match the ListTaskDefinitionFamilies
	// request.
	Families []*string `locationName:"families" type:"list"`

	// The nextToken value to include in a future ListTaskDefinitionFamilies request.
	// When the results of a ListTaskDefinitionFamilies request exceed maxResults,
	// this value can be used to retrieve the next page of results. This value is
	// null when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaskDefinitionFamiliesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaskDefinitionFamiliesOutput) GoString() string {
	return s.String()
}

// SetFamilies sets the Families field's value.
func (s *ListTaskDefinitionFamiliesOutput) SetFamilies(v []*string) *ListTaskDefinitionFamiliesOutput {
	s.Families = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTaskDefinitionFamiliesOutput) SetNextToken(v string) *ListTaskDefinitionFamiliesOutput {
	s.NextToken = &v
	return s
}

type ListTaskDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// The full family name to filter the ListTaskDefinitions results with. Specifying
	// a familyPrefix limits the listed task definitions to task definition revisions
	// that belong to that family.
	FamilyPrefix *string `locationName:"familyPrefix" type:"string"`

	// The maximum number of task definition results that ListTaskDefinitions returned
	// in paginated output. When this parameter is used, ListTaskDefinitions only
	// returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another ListTaskDefinitions request with the returned nextToken value. This
	// value can be between 1 and 100. If this parameter isn't used, then ListTaskDefinitions
	// returns up to 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a ListTaskDefinitions request indicating
	// that more results are available to fulfill the request and further calls
	// will be needed. If maxResults was provided, it is possible the number of
	// results to be fewer than maxResults.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The order to sort the results in. Valid values are ASC and DESC. By default,
	// (ASC) task definitions are listed lexicographically by family name and in
	// ascending numerical order by revision so that the newest task definitions
	// in a family are listed last. Setting this parameter to DESC reverses the
	// sort order on family name and revision. This is so that the newest task definitions
	// in a family are listed first.
	Sort *string `locationName:"sort" type:"string" enum:"SortOrder"`

	// The task definition status to filter the ListTaskDefinitions results with.
	// By default, only ACTIVE task definitions are listed. By setting this parameter
	// to INACTIVE, you can view task definitions that are INACTIVE as long as an
	// active task or service still references them. If you paginate the resulting
	// output, be sure to keep the status value constant in each subsequent request.
	Status *string `locationName:"status" type:"string" enum:"TaskDefinitionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaskDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaskDefinitionsInput) GoString() string {
	return s.String()
}

// SetFamilyPrefix sets the FamilyPrefix field's value.
func (s *ListTaskDefinitionsInput) SetFamilyPrefix(v string) *ListTaskDefinitionsInput {
	s.FamilyPrefix = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTaskDefinitionsInput) SetMaxResults(v int64) *ListTaskDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTaskDefinitionsInput) SetNextToken(v string) *ListTaskDefinitionsInput {
	s.NextToken = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *ListTaskDefinitionsInput) SetSort(v string) *ListTaskDefinitionsInput {
	s.Sort = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTaskDefinitionsInput) SetStatus(v string) *ListTaskDefinitionsInput {
	s.Status = &v
	return s
}

type ListTaskDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListTaskDefinitions request. When
	// the results of a ListTaskDefinitions request exceed maxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of task definition Amazon Resource Name (ARN) entries for the ListTaskDefinitions
	// request.
	TaskDefinitionArns []*string `locationName:"taskDefinitionArns" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaskDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaskDefinitionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTaskDefinitionsOutput) SetNextToken(v string) *ListTaskDefinitionsOutput {
	s.NextToken = &v
	return s
}

// SetTaskDefinitionArns sets the TaskDefinitionArns field's value.
func (s *ListTaskDefinitionsOutput) SetTaskDefinitionArns(v []*string) *ListTaskDefinitionsOutput {
	s.TaskDefinitionArns = v
	return s
}

type ListTasksInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster to use when
	// filtering the ListTasks results. If you do not specify a cluster, the default
	// cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// The container instance ID or full ARN of the container instance to use when
	// filtering the ListTasks results. Specifying a containerInstance limits the
	// results to tasks that belong to that container instance.
	ContainerInstance *string `locationName:"containerInstance" type:"string"`

	// The task desired status to use when filtering the ListTasks results. Specifying
	// a desiredStatus of STOPPED limits the results to tasks that Amazon ECS has
	// set the desired status to STOPPED. This can be useful for debugging tasks
	// that aren't starting properly or have died or finished. The default status
	// filter is RUNNING, which shows tasks that Amazon ECS has set the desired
	// status to RUNNING.
	//
	// Although you can filter results based on a desired status of PENDING, this
	// doesn't return any results. Amazon ECS never sets the desired status of a
	// task to that value (only a task's lastStatus may have a value of PENDING).
	DesiredStatus *string `locationName:"desiredStatus" type:"string" enum:"DesiredStatus"`

	// The name of the task definition family to use when filtering the ListTasks
	// results. Specifying a family limits the results to tasks that belong to that
	// family.
	Family *string `locationName:"family" type:"string"`

	// The launch type to use when filtering the ListTasks results.
	LaunchType *string `locationName:"launchType" type:"string" enum:"LaunchType"`

	// The maximum number of task results that ListTasks returned in paginated output.
	// When this parameter is used, ListTasks only returns maxResults results in
	// a single page along with a nextToken response element. The remaining results
	// of the initial request can be seen by sending another ListTasks request with
	// the returned nextToken value. This value can be between 1 and 100. If this
	// parameter isn't used, then ListTasks returns up to 100 results and a nextToken
	// value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a ListTasks request indicating that more
	// results are available to fulfill the request and further calls will be needed.
	// If maxResults was provided, it's possible the number of results to be fewer
	// than maxResults.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the service to use when filtering the ListTasks results. Specifying
	// a serviceName limits the results to tasks that belong to that service.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// The startedBy value to filter the task results with. Specifying a startedBy
	// value limits the results to tasks that were started with that value.
	StartedBy *string `locationName:"startedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksInput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ListTasksInput) SetCluster(v string) *ListTasksInput {
	s.Cluster = &v
	return s
}

// SetContainerInstance sets the ContainerInstance field's value.
func (s *ListTasksInput) SetContainerInstance(v string) *ListTasksInput {
	s.ContainerInstance = &v
	return s
}

// SetDesiredStatus sets the DesiredStatus field's value.
func (s *ListTasksInput) SetDesiredStatus(v string) *ListTasksInput {
	s.DesiredStatus = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *ListTasksInput) SetFamily(v string) *ListTasksInput {
	s.Family = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *ListTasksInput) SetLaunchType(v string) *ListTasksInput {
	s.LaunchType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTasksInput) SetMaxResults(v int64) *ListTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTasksInput) SetNextToken(v string) *ListTasksInput {
	s.NextToken = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ListTasksInput) SetServiceName(v string) *ListTasksInput {
	s.ServiceName = &v
	return s
}

// SetStartedBy sets the StartedBy field's value.
func (s *ListTasksInput) SetStartedBy(v string) *ListTasksInput {
	s.StartedBy = &v
	return s
}

type ListTasksOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListTasks request. When the results
	// of a ListTasks request exceed maxResults, this value can be used to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of task ARN entries for the ListTasks request.
	TaskArns []*string `locationName:"taskArns" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTasksOutput) SetNextToken(v string) *ListTasksOutput {
	s.NextToken = &v
	return s
}

// SetTaskArns sets the TaskArns field's value.
func (s *ListTasksOutput) SetTaskArns(v []*string) *ListTasksOutput {
	s.TaskArns = v
	return s
}

// The load balancer configuration to use with a service or task set.
//
// For specific notes and restrictions regarding the use of load balancers with
// services and task sets, see the CreateService and CreateTaskSet actions.
//
// When you add, update, or remove a load balancer configuration, Amazon ECS
// starts a new deployment with the updated Elastic Load Balancing configuration.
// This causes tasks to register to and deregister from load balancers.
//
// We recommend that you verify this on a test environment before you update
// the Elastic Load Balancing configuration.
//
// A service-linked role is required for services that use multiple target groups.
// For more information, see Using service-linked roles (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html)
// in the Amazon Elastic Container Service Developer Guide.
type LoadBalancer struct {
	_ struct{} `type:"structure"`

	// The name of the container (as it appears in a container definition) to associate
	// with the load balancer.
	ContainerName *string `locationName:"containerName" type:"string"`

	// The port on the container to associate with the load balancer. This port
	// must correspond to a containerPort in the task definition the tasks in the
	// service are using. For tasks that use the EC2 launch type, the container
	// instance they're launched on must allow ingress traffic on the hostPort of
	// the port mapping.
	ContainerPort *int64 `locationName:"containerPort" type:"integer"`

	// The name of the load balancer to associate with the Amazon ECS service or
	// task set.
	//
	// A load balancer name is only specified when using a Classic Load Balancer.
	// If you are using an Application Load Balancer or a Network Load Balancer
	// the load balancer name parameter should be omitted.
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string"`

	// The full Amazon Resource Name (ARN) of the Elastic Load Balancing target
	// group or groups associated with a service or task set.
	//
	// A target group ARN is only specified when using an Application Load Balancer
	// or Network Load Balancer. If you're using a Classic Load Balancer, omit the
	// target group ARN.
	//
	// For services using the ECS deployment controller, you can specify one or
	// multiple target groups. For more information, see Registering multiple target
	// groups with a service (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// For services using the CODE_DEPLOY deployment controller, you're required
	// to define two target groups for the load balancer. For more information,
	// see Blue/green deployment with CodeDeploy (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// If your service's task definition uses the awsvpc network mode, you must
	// choose ip as the target type, not instance. Do this when creating your target
	// groups because tasks that use the awsvpc network mode are associated with
	// an elastic network interface, not an Amazon EC2 instance. This network mode
	// is required for the Fargate launch type.
	TargetGroupArn *string `locationName:"targetGroupArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoadBalancer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoadBalancer) GoString() string {
	return s.String()
}

// SetContainerName sets the ContainerName field's value.
func (s *LoadBalancer) SetContainerName(v string) *LoadBalancer {
	s.ContainerName = &v
	return s
}

// SetContainerPort sets the ContainerPort field's value.
func (s *LoadBalancer) SetContainerPort(v int64) *LoadBalancer {
	s.ContainerPort = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *LoadBalancer) SetLoadBalancerName(v string) *LoadBalancer {
	s.LoadBalancerName = &v
	return s
}

// SetTargetGroupArn sets the TargetGroupArn field's value.
func (s *LoadBalancer) SetTargetGroupArn(v string) *LoadBalancer {
	s.TargetGroupArn = &v
	return s
}

// The log configuration for the container. This parameter maps to LogConfig
// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
// and the --log-driver option to docker run (https://docs.docker.com/engine/reference/commandline/run/).
//
// By default, containers use the same logging driver that the Docker daemon
// uses. However, the container might use a different logging driver than the
// Docker daemon by specifying a log driver configuration in the container definition.
// For more information about the options for different supported log drivers,
// see Configure logging drivers (https://docs.docker.com/engine/admin/logging/overview/)
// in the Docker documentation.
//
// Understand the following when specifying a log configuration for your containers.
//
//   - Amazon ECS currently supports a subset of the logging drivers available
//     to the Docker daemon (shown in the valid values below). Additional log
//     drivers may be available in future releases of the Amazon ECS container
//     agent.
//
//   - This parameter requires version 1.18 of the Docker Remote API or greater
//     on your container instance.
//
//   - For tasks that are hosted on Amazon EC2 instances, the Amazon ECS container
//     agent must register the available logging drivers with the ECS_AVAILABLE_LOGGING_DRIVERS
//     environment variable before containers placed on that instance can use
//     these log configuration options. For more information, see Amazon ECS
//     container agent configuration (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
//     in the Amazon Elastic Container Service Developer Guide.
//
//   - For tasks that are on Fargate, because you don't have access to the
//     underlying infrastructure your tasks are hosted on, any additional software
//     needed must be installed outside of the task. For example, the Fluentd
//     output aggregators or a remote host running Logstash to send Gelf logs
//     to.
type LogConfiguration struct {
	_ struct{} `type:"structure"`

	// The log driver to use for the container.
	//
	// For tasks on Fargate, the supported log drivers are awslogs, splunk, and
	// awsfirelens.
	//
	// For tasks hosted on Amazon EC2 instances, the supported log drivers are awslogs,
	// fluentd, gelf, json-file, journald, logentries,syslog, splunk, and awsfirelens.
	//
	// For more information about using the awslogs log driver, see Using the awslogs
	// log driver (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// For more information about using the awsfirelens log driver, see Custom log
	// routing (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// If you have a custom driver that isn't listed, you can fork the Amazon ECS
	// container agent project that's available on GitHub (https://github.com/aws/amazon-ecs-agent)
	// and customize it to work with that driver. We encourage you to submit pull
	// requests for changes that you would like to have included. However, we don't
	// currently provide support for running modified copies of this software.
	//
	// LogDriver is a required field
	LogDriver *string `locationName:"logDriver" type:"string" required:"true" enum:"LogDriver"`

	// The configuration options to send to the log driver. This parameter requires
	// version 1.19 of the Docker Remote API or greater on your container instance.
	// To check the Docker Remote API version on your container instance, log in
	// to your container instance and run the following command: sudo docker version
	// --format '{{.Server.APIVersion}}'
	Options map[string]*string `locationName:"options" type:"map"`

	// The secrets to pass to the log configuration. For more information, see Specifying
	// sensitive data (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html)
	// in the Amazon Elastic Container Service Developer Guide.
	SecretOptions []*Secret `locationName:"secretOptions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogConfiguration"}
	if s.LogDriver == nil {
		invalidParams.Add(request.NewErrParamRequired("LogDriver"))
	}
	if s.SecretOptions != nil {
		for i, v := range s.SecretOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SecretOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogDriver sets the LogDriver field's value.
func (s *LogConfiguration) SetLogDriver(v string) *LogConfiguration {
	s.LogDriver = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *LogConfiguration) SetOptions(v map[string]*string) *LogConfiguration {
	s.Options = v
	return s
}

// SetSecretOptions sets the SecretOptions field's value.
func (s *LogConfiguration) SetSecretOptions(v []*Secret) *LogConfiguration {
	s.SecretOptions = v
	return s
}

// Details about the managed agent status for the container.
type ManagedAgent struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp for the time when the managed agent was last started.
	LastStartedAt *time.Time `locationName:"lastStartedAt" type:"timestamp"`

	// The last known status of the managed agent.
	LastStatus *string `locationName:"lastStatus" type:"string"`

	// The name of the managed agent. When the execute command feature is enabled,
	// the managed agent name is ExecuteCommandAgent.
	Name *string `locationName:"name" type:"string" enum:"ManagedAgentName"`

	// The reason for why the managed agent is in the state it is in.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedAgent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedAgent) GoString() string {
	return s.String()
}

// SetLastStartedAt sets the LastStartedAt field's value.
func (s *ManagedAgent) SetLastStartedAt(v time.Time) *ManagedAgent {
	s.LastStartedAt = &v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *ManagedAgent) SetLastStatus(v string) *ManagedAgent {
	s.LastStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *ManagedAgent) SetName(v string) *ManagedAgent {
	s.Name = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ManagedAgent) SetReason(v string) *ManagedAgent {
	s.Reason = &v
	return s
}

// An object representing a change in state for a managed agent.
type ManagedAgentStateChange struct {
	_ struct{} `type:"structure"`

	// The name of the container that's associated with the managed agent.
	//
	// ContainerName is a required field
	ContainerName *string `locationName:"containerName" type:"string" required:"true"`

	// The name of the managed agent.
	//
	// ManagedAgentName is a required field
	ManagedAgentName *string `locationName:"managedAgentName" type:"string" required:"true" enum:"ManagedAgentName"`

	// The reason for the status of the managed agent.
	Reason *string `locationName:"reason" type:"string"`

	// The status of the managed agent.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedAgentStateChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedAgentStateChange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManagedAgentStateChange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ManagedAgentStateChange"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ManagedAgentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagedAgentName"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *ManagedAgentStateChange) SetContainerName(v string) *ManagedAgentStateChange {
	s.ContainerName = &v
	return s
}

// SetManagedAgentName sets the ManagedAgentName field's value.
func (s *ManagedAgentStateChange) SetManagedAgentName(v string) *ManagedAgentStateChange {
	s.ManagedAgentName = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ManagedAgentStateChange) SetReason(v string) *ManagedAgentStateChange {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ManagedAgentStateChange) SetStatus(v string) *ManagedAgentStateChange {
	s.Status = &v
	return s
}

// The managed scaling settings for the Auto Scaling group capacity provider.
//
// When managed scaling is enabled, Amazon ECS manages the scale-in and scale-out
// actions of the Auto Scaling group. Amazon ECS manages a target tracking scaling
// policy using an Amazon ECS managed CloudWatch metric with the specified targetCapacity
// value as the target value for the metric. For more information, see Using
// managed scaling (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/asg-capacity-providers.html#asg-capacity-providers-managed-scaling)
// in the Amazon Elastic Container Service Developer Guide.
//
// If managed scaling is disabled, the user must manage the scaling of the Auto
// Scaling group.
type ManagedScaling struct {
	_ struct{} `type:"structure"`

	// The period of time, in seconds, after a newly launched Amazon EC2 instance
	// can contribute to CloudWatch metrics for Auto Scaling group. If this parameter
	// is omitted, the default value of 300 seconds is used.
	InstanceWarmupPeriod *int64 `locationName:"instanceWarmupPeriod" type:"integer"`

	// The maximum number of container instances that Amazon ECS scales in or scales
	// out at one time. If this parameter is omitted, the default value of 10000
	// is used.
	MaximumScalingStepSize *int64 `locationName:"maximumScalingStepSize" min:"1" type:"integer"`

	// The minimum number of container instances that Amazon ECS scales in or scales
	// out at one time. If this parameter is omitted, the default value of 1 is
	// used.
	MinimumScalingStepSize *int64 `locationName:"minimumScalingStepSize" min:"1" type:"integer"`

	// Determines whether to use managed scaling for the capacity provider.
	Status *string `locationName:"status" type:"string" enum:"ManagedScalingStatus"`

	// The target capacity value for the capacity provider. The specified value
	// must be greater than 0 and less than or equal to 100. A value of 100 results
	// in the Amazon EC2 instances in your Auto Scaling group being completely used.
	TargetCapacity *int64 `locationName:"targetCapacity" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedScaling) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedScaling) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManagedScaling) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ManagedScaling"}
	if s.MaximumScalingStepSize != nil && *s.MaximumScalingStepSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumScalingStepSize", 1))
	}
	if s.MinimumScalingStepSize != nil && *s.MinimumScalingStepSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumScalingStepSize", 1))
	}
	if s.TargetCapacity != nil && *s.TargetCapacity < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TargetCapacity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceWarmupPeriod sets the InstanceWarmupPeriod field's value.
func (s *ManagedScaling) SetInstanceWarmupPeriod(v int64) *ManagedScaling {
	s.InstanceWarmupPeriod = &v
	return s
}

// SetMaximumScalingStepSize sets the MaximumScalingStepSize field's value.
func (s *ManagedScaling) SetMaximumScalingStepSize(v int64) *ManagedScaling {
	s.MaximumScalingStepSize = &v
	return s
}

// SetMinimumScalingStepSize sets the MinimumScalingStepSize field's value.
func (s *ManagedScaling) SetMinimumScalingStepSize(v int64) *ManagedScaling {
	s.MinimumScalingStepSize = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ManagedScaling) SetStatus(v string) *ManagedScaling {
	s.Status = &v
	return s
}

// SetTargetCapacity sets the TargetCapacity field's value.
func (s *ManagedScaling) SetTargetCapacity(v int64) *ManagedScaling {
	s.TargetCapacity = &v
	return s
}

// Amazon ECS can't determine the current version of the Amazon ECS container
// agent on the container instance and doesn't have enough information to proceed
// with an update. This could be because the agent running on the container
// instance is a previous or custom version that doesn't use our version information.
type MissingVersionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingVersionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingVersionException) GoString() string {
	return s.String()
}

func newErrorMissingVersionException(v protocol.ResponseMetadata) error {
	return &MissingVersionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MissingVersionException) Code() string {
	return "MissingVersionException"
}

// Message returns the exception's message.
func (s *MissingVersionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MissingVersionException) OrigErr() error {
	return nil
}

func (s *MissingVersionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MissingVersionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MissingVersionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details for a volume mount point that's used in a container definition.
type MountPoint struct {
	_ struct{} `type:"structure"`

	// The path on the container to mount the host volume at.
	ContainerPath *string `locationName:"containerPath" type:"string"`

	// If this value is true, the container has read-only access to the volume.
	// If this value is false, then the container can write to the volume. The default
	// value is false.
	ReadOnly *bool `locationName:"readOnly" type:"boolean"`

	// The name of the volume to mount. Must be a volume name referenced in the
	// name parameter of task definition volume.
	SourceVolume *string `locationName:"sourceVolume" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MountPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MountPoint) GoString() string {
	return s.String()
}

// SetContainerPath sets the ContainerPath field's value.
func (s *MountPoint) SetContainerPath(v string) *MountPoint {
	s.ContainerPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *MountPoint) SetReadOnly(v bool) *MountPoint {
	s.ReadOnly = &v
	return s
}

// SetSourceVolume sets the SourceVolume field's value.
func (s *MountPoint) SetSourceVolume(v string) *MountPoint {
	s.SourceVolume = &v
	return s
}

// Details on the network bindings between a container and its host container
// instance. After a task reaches the RUNNING status, manual and automatic host
// and container port assignments are visible in the networkBindings section
// of DescribeTasks API responses.
type NetworkBinding struct {
	_ struct{} `type:"structure"`

	// The IP address that the container is bound to on the container instance.
	BindIP *string `locationName:"bindIP" type:"string"`

	// The port number on the container that's used with the network binding.
	ContainerPort *int64 `locationName:"containerPort" type:"integer"`

	// The port number on the host that's used with the network binding.
	HostPort *int64 `locationName:"hostPort" type:"integer"`

	// The protocol used for the network binding.
	Protocol *string `locationName:"protocol" type:"string" enum:"TransportProtocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkBinding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkBinding) GoString() string {
	return s.String()
}

// SetBindIP sets the BindIP field's value.
func (s *NetworkBinding) SetBindIP(v string) *NetworkBinding {
	s.BindIP = &v
	return s
}

// SetContainerPort sets the ContainerPort field's value.
func (s *NetworkBinding) SetContainerPort(v int64) *NetworkBinding {
	s.ContainerPort = &v
	return s
}

// SetHostPort sets the HostPort field's value.
func (s *NetworkBinding) SetHostPort(v int64) *NetworkBinding {
	s.HostPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *NetworkBinding) SetProtocol(v string) *NetworkBinding {
	s.Protocol = &v
	return s
}

// An object representing the network configuration for a task or service.
type NetworkConfiguration struct {
	_ struct{} `type:"structure"`

	// The VPC subnets and security groups that are associated with a task.
	//
	// All specified subnets and security groups must be from the same VPC.
	AwsvpcConfiguration *AwsVpcConfiguration `locationName:"awsvpcConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkConfiguration"}
	if s.AwsvpcConfiguration != nil {
		if err := s.AwsvpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AwsvpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsvpcConfiguration sets the AwsvpcConfiguration field's value.
func (s *NetworkConfiguration) SetAwsvpcConfiguration(v *AwsVpcConfiguration) *NetworkConfiguration {
	s.AwsvpcConfiguration = v
	return s
}

// An object representing the elastic network interface for tasks that use the
// awsvpc network mode.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The attachment ID for the network interface.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// The private IPv6 address for the network interface.
	Ipv6Address *string `locationName:"ipv6Address" type:"string"`

	// The private IPv4 address for the network interface.
	PrivateIpv4Address *string `locationName:"privateIpv4Address" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetAttachmentId sets the AttachmentId field's value.
func (s *NetworkInterface) SetAttachmentId(v string) *NetworkInterface {
	s.AttachmentId = &v
	return s
}

// SetIpv6Address sets the Ipv6Address field's value.
func (s *NetworkInterface) SetIpv6Address(v string) *NetworkInterface {
	s.Ipv6Address = &v
	return s
}

// SetPrivateIpv4Address sets the PrivateIpv4Address field's value.
func (s *NetworkInterface) SetPrivateIpv4Address(v string) *NetworkInterface {
	s.PrivateIpv4Address = &v
	return s
}

// There's no update available for this Amazon ECS container agent. This might
// be because the agent is already running the latest version or because it's
// so old that there's no update path to the current version.
type NoUpdateAvailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoUpdateAvailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoUpdateAvailableException) GoString() string {
	return s.String()
}

func newErrorNoUpdateAvailableException(v protocol.ResponseMetadata) error {
	return &NoUpdateAvailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoUpdateAvailableException) Code() string {
	return "NoUpdateAvailableException"
}

// Message returns the exception's message.
func (s *NoUpdateAvailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoUpdateAvailableException) OrigErr() error {
	return nil
}

func (s *NoUpdateAvailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoUpdateAvailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoUpdateAvailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing a constraint on task placement. For more information,
// see Task placement constraints (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// If you're using the Fargate launch type, task placement constraints aren't
// supported.
type PlacementConstraint struct {
	_ struct{} `type:"structure"`

	// A cluster query language expression to apply to the constraint. The expression
	// can have a maximum length of 2000 characters. You can't specify an expression
	// if the constraint type is distinctInstance. For more information, see Cluster
	// query language (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Expression *string `locationName:"expression" type:"string"`

	// The type of constraint. Use distinctInstance to ensure that each task in
	// a particular group is running on a different container instance. Use memberOf
	// to restrict the selection to a group of valid candidates.
	Type *string `locationName:"type" type:"string" enum:"PlacementConstraintType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementConstraint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementConstraint) GoString() string {
	return s.String()
}

// SetExpression sets the Expression field's value.
func (s *PlacementConstraint) SetExpression(v string) *PlacementConstraint {
	s.Expression = &v
	return s
}

// SetType sets the Type field's value.
func (s *PlacementConstraint) SetType(v string) *PlacementConstraint {
	s.Type = &v
	return s
}

// The task placement strategy for a task or service. For more information,
// see Task placement strategies (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html)
// in the Amazon Elastic Container Service Developer Guide.
type PlacementStrategy struct {
	_ struct{} `type:"structure"`

	// The field to apply the placement strategy against. For the spread placement
	// strategy, valid values are instanceId (or host, which has the same effect),
	// or any platform or custom attribute that's applied to a container instance,
	// such as attribute:ecs.availability-zone. For the binpack placement strategy,
	// valid values are cpu and memory. For the random placement strategy, this
	// field is not used.
	Field *string `locationName:"field" type:"string"`

	// The type of placement strategy. The random placement strategy randomly places
	// tasks on available candidates. The spread placement strategy spreads placement
	// across available candidates evenly based on the field parameter. The binpack
	// strategy places tasks on available candidates that have the least available
	// amount of the resource that's specified with the field parameter. For example,
	// if you binpack on memory, a task is placed on the instance with the least
	// amount of remaining memory but still enough to run the task.
	Type *string `locationName:"type" type:"string" enum:"PlacementStrategyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementStrategy) GoString() string {
	return s.String()
}

// SetField sets the Field field's value.
func (s *PlacementStrategy) SetField(v string) *PlacementStrategy {
	s.Field = &v
	return s
}

// SetType sets the Type field's value.
func (s *PlacementStrategy) SetType(v string) *PlacementStrategy {
	s.Type = &v
	return s
}

// The devices that are available on the container instance. The only supported
// device type is a GPU.
type PlatformDevice struct {
	_ struct{} `type:"structure"`

	// The ID for the GPUs on the container instance. The available GPU IDs can
	// also be obtained on the container instance in the /var/lib/ecs/gpu/nvidia_gpu_info.json
	// file.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The type of device that's available on the container instance. The only supported
	// value is GPU.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"PlatformDeviceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlatformDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlatformDevice) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PlatformDevice) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PlatformDevice"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *PlatformDevice) SetId(v string) *PlatformDevice {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *PlatformDevice) SetType(v string) *PlatformDevice {
	s.Type = &v
	return s
}

// The specified platform version doesn't satisfy the required capabilities
// of the task definition.
type PlatformTaskDefinitionIncompatibilityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlatformTaskDefinitionIncompatibilityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlatformTaskDefinitionIncompatibilityException) GoString() string {
	return s.String()
}

func newErrorPlatformTaskDefinitionIncompatibilityException(v protocol.ResponseMetadata) error {
	return &PlatformTaskDefinitionIncompatibilityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PlatformTaskDefinitionIncompatibilityException) Code() string {
	return "PlatformTaskDefinitionIncompatibilityException"
}

// Message returns the exception's message.
func (s *PlatformTaskDefinitionIncompatibilityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PlatformTaskDefinitionIncompatibilityException) OrigErr() error {
	return nil
}

func (s *PlatformTaskDefinitionIncompatibilityException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PlatformTaskDefinitionIncompatibilityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PlatformTaskDefinitionIncompatibilityException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified platform version doesn't exist.
type PlatformUnknownException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlatformUnknownException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlatformUnknownException) GoString() string {
	return s.String()
}

func newErrorPlatformUnknownException(v protocol.ResponseMetadata) error {
	return &PlatformUnknownException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PlatformUnknownException) Code() string {
	return "PlatformUnknownException"
}

// Message returns the exception's message.
func (s *PlatformUnknownException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PlatformUnknownException) OrigErr() error {
	return nil
}

func (s *PlatformUnknownException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PlatformUnknownException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PlatformUnknownException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Port mappings allow containers to access ports on the host container instance
// to send or receive traffic. Port mappings are specified as part of the container
// definition.
//
// If you use containers in a task with the awsvpc or host network mode, specify
// the exposed ports using containerPort. The hostPort can be left blank or
// it must be the same value as the containerPort.
//
// You can't expose the same container port for multiple protocols. If you attempt
// this, an error is returned.
//
// After a task reaches the RUNNING status, manual and automatic host and container
// port assignments are visible in the networkBindings section of DescribeTasks
// API responses.
type PortMapping struct {
	_ struct{} `type:"structure"`

	// The port number on the container that's bound to the user-specified or automatically
	// assigned host port.
	//
	// If you use containers in a task with the awsvpc or host network mode, specify
	// the exposed ports using containerPort.
	//
	// If you use containers in a task with the bridge network mode and you specify
	// a container port and not a host port, your container automatically receives
	// a host port in the ephemeral port range. For more information, see hostPort.
	// Port mappings that are automatically assigned in this way do not count toward
	// the 100 reserved ports limit of a container instance.
	ContainerPort *int64 `locationName:"containerPort" type:"integer"`

	// The port number on the container instance to reserve for your container.
	//
	// If you use containers in a task with the awsvpc or host network mode, the
	// hostPort can either be left blank or set to the same value as the containerPort.
	//
	// If you use containers in a task with the bridge network mode, you can specify
	// a non-reserved host port for your container port mapping, or you can omit
	// the hostPort (or set it to 0) while specifying a containerPort and your container
	// automatically receives a port in the ephemeral port range for your container
	// instance operating system and Docker version.
	//
	// The default ephemeral port range for Docker version 1.6.0 and later is listed
	// on the instance under /proc/sys/net/ipv4/ip_local_port_range. If this kernel
	// parameter is unavailable, the default ephemeral port range from 49153 through
	// 65535 is used. Do not attempt to specify a host port in the ephemeral port
	// range as these are reserved for automatic assignment. In general, ports below
	// 32768 are outside of the ephemeral port range.
	//
	// The default ephemeral port range from 49153 through 65535 is always used
	// for Docker versions before 1.6.0.
	//
	// The default reserved ports are 22 for SSH, the Docker ports 2375 and 2376,
	// and the Amazon ECS container agent ports 51678-51680. Any host port that
	// was previously specified in a running task is also reserved while the task
	// is running. That is, after a task stops, the host port is released. The current
	// reserved ports are displayed in the remainingResources of DescribeContainerInstances
	// output. A container instance can have up to 100 reserved ports at a time.
	// This number includes the default reserved ports. Automatically assigned ports
	// aren't included in the 100 reserved ports quota.
	HostPort *int64 `locationName:"hostPort" type:"integer"`

	// The protocol used for the port mapping. Valid values are tcp and udp. The
	// default is tcp.
	Protocol *string `locationName:"protocol" type:"string" enum:"TransportProtocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortMapping) GoString() string {
	return s.String()
}

// SetContainerPort sets the ContainerPort field's value.
func (s *PortMapping) SetContainerPort(v int64) *PortMapping {
	s.ContainerPort = &v
	return s
}

// SetHostPort sets the HostPort field's value.
func (s *PortMapping) SetHostPort(v int64) *PortMapping {
	s.HostPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *PortMapping) SetProtocol(v string) *PortMapping {
	s.Protocol = &v
	return s
}

// The configuration details for the App Mesh proxy.
//
// For tasks that use the EC2 launch type, the container instances require at
// least version 1.26.0 of the container agent and at least version 1.26.0-1
// of the ecs-init package to use a proxy configuration. If your container instances
// are launched from the Amazon ECS optimized AMI version 20190301 or later,
// then they contain the required versions of the container agent and ecs-init.
// For more information, see Amazon ECS-optimized Linux AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
type ProxyConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the container that will serve as the App Mesh proxy.
	//
	// ContainerName is a required field
	ContainerName *string `locationName:"containerName" type:"string" required:"true"`

	// The set of network configuration parameters to provide the Container Network
	// Interface (CNI) plugin, specified as key-value pairs.
	//
	//    * IgnoredUID - (Required) The user ID (UID) of the proxy container as
	//    defined by the user parameter in a container definition. This is used
	//    to ensure the proxy ignores its own traffic. If IgnoredGID is specified,
	//    this field can be empty.
	//
	//    * IgnoredGID - (Required) The group ID (GID) of the proxy container as
	//    defined by the user parameter in a container definition. This is used
	//    to ensure the proxy ignores its own traffic. If IgnoredUID is specified,
	//    this field can be empty.
	//
	//    * AppPorts - (Required) The list of ports that the application uses. Network
	//    traffic to these ports is forwarded to the ProxyIngressPort and ProxyEgressPort.
	//
	//    * ProxyIngressPort - (Required) Specifies the port that incoming traffic
	//    to the AppPorts is directed to.
	//
	//    * ProxyEgressPort - (Required) Specifies the port that outgoing traffic
	//    from the AppPorts is directed to.
	//
	//    * EgressIgnoredPorts - (Required) The egress traffic going to the specified
	//    ports is ignored and not redirected to the ProxyEgressPort. It can be
	//    an empty list.
	//
	//    * EgressIgnoredIPs - (Required) The egress traffic going to the specified
	//    IP addresses is ignored and not redirected to the ProxyEgressPort. It
	//    can be an empty list.
	Properties []*KeyValuePair `locationName:"properties" type:"list"`

	// The proxy type. The only supported value is APPMESH.
	Type *string `locationName:"type" type:"string" enum:"ProxyConfigurationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProxyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProxyConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProxyConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProxyConfiguration"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *ProxyConfiguration) SetContainerName(v string) *ProxyConfiguration {
	s.ContainerName = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *ProxyConfiguration) SetProperties(v []*KeyValuePair) *ProxyConfiguration {
	s.Properties = v
	return s
}

// SetType sets the Type field's value.
func (s *ProxyConfiguration) SetType(v string) *ProxyConfiguration {
	s.Type = &v
	return s
}

type PutAccountSettingDefaultInput struct {
	_ struct{} `type:"structure"`

	// The resource name for which to modify the account setting. If serviceLongArnFormat
	// is specified, the ARN for your Amazon ECS services is affected. If taskLongArnFormat
	// is specified, the ARN and resource ID for your Amazon ECS tasks is affected.
	// If containerInstanceLongArnFormat is specified, the ARN and resource ID for
	// your Amazon ECS container instances is affected. If awsvpcTrunking is specified,
	// the ENI limit for your Amazon ECS container instances is affected. If containerInsights
	// is specified, the default setting for CloudWatch Container Insights for your
	// clusters is affected.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"SettingName"`

	// The account setting value for the specified principal ARN. Accepted values
	// are enabled and disabled.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountSettingDefaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountSettingDefaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccountSettingDefaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAccountSettingDefaultInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *PutAccountSettingDefaultInput) SetName(v string) *PutAccountSettingDefaultInput {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PutAccountSettingDefaultInput) SetValue(v string) *PutAccountSettingDefaultInput {
	s.Value = &v
	return s
}

type PutAccountSettingDefaultOutput struct {
	_ struct{} `type:"structure"`

	// The current setting for a resource.
	Setting *Setting `locationName:"setting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountSettingDefaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountSettingDefaultOutput) GoString() string {
	return s.String()
}

// SetSetting sets the Setting field's value.
func (s *PutAccountSettingDefaultOutput) SetSetting(v *Setting) *PutAccountSettingDefaultOutput {
	s.Setting = v
	return s
}

type PutAccountSettingInput struct {
	_ struct{} `type:"structure"`

	// The Amazon ECS resource name for which to modify the account setting. If
	// serviceLongArnFormat is specified, the ARN for your Amazon ECS services is
	// affected. If taskLongArnFormat is specified, the ARN and resource ID for
	// your Amazon ECS tasks is affected. If containerInstanceLongArnFormat is specified,
	// the ARN and resource ID for your Amazon ECS container instances is affected.
	// If awsvpcTrunking is specified, the elastic network interface (ENI) limit
	// for your Amazon ECS container instances is affected. If containerInsights
	// is specified, the default setting for CloudWatch Container Insights for your
	// clusters is affected.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"SettingName"`

	// The ARN of the principal, which can be an IAM user, IAM role, or the root
	// user. If you specify the root user, it modifies the account setting for all
	// IAM users, IAM roles, and the root user of the account unless an IAM user
	// or role explicitly overrides these settings. If this field is omitted, the
	// setting is changed only for the authenticated user.
	//
	// Federated users assume the account setting of the root user and can't have
	// explicit account settings set for them.
	PrincipalArn *string `locationName:"principalArn" type:"string"`

	// The account setting value for the specified principal ARN. Accepted values
	// are enabled and disabled.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountSettingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountSettingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccountSettingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAccountSettingInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *PutAccountSettingInput) SetName(v string) *PutAccountSettingInput {
	s.Name = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *PutAccountSettingInput) SetPrincipalArn(v string) *PutAccountSettingInput {
	s.PrincipalArn = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PutAccountSettingInput) SetValue(v string) *PutAccountSettingInput {
	s.Value = &v
	return s
}

type PutAccountSettingOutput struct {
	_ struct{} `type:"structure"`

	// The current account setting for a resource.
	Setting *Setting `locationName:"setting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountSettingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountSettingOutput) GoString() string {
	return s.String()
}

// SetSetting sets the Setting field's value.
func (s *PutAccountSettingOutput) SetSetting(v *Setting) *PutAccountSettingOutput {
	s.Setting = v
	return s
}

type PutAttributesInput struct {
	_ struct{} `type:"structure"`

	// The attributes to apply to your resource. You can specify up to 10 custom
	// attributes for each resource. You can specify up to 10 attributes in a single
	// call.
	//
	// Attributes is a required field
	Attributes []*Attribute `locationName:"attributes" type:"list" required:"true"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that contains
	// the resource to apply attributes. If you do not specify a cluster, the default
	// cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAttributesInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *PutAttributesInput) SetAttributes(v []*Attribute) *PutAttributesInput {
	s.Attributes = v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *PutAttributesInput) SetCluster(v string) *PutAttributesInput {
	s.Cluster = &v
	return s
}

type PutAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The attributes applied to your resource.
	Attributes []*Attribute `locationName:"attributes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *PutAttributesOutput) SetAttributes(v []*Attribute) *PutAttributesOutput {
	s.Attributes = v
	return s
}

type PutClusterCapacityProvidersInput struct {
	_ struct{} `type:"structure"`

	// The name of one or more capacity providers to associate with the cluster.
	//
	// If specifying a capacity provider that uses an Auto Scaling group, the capacity
	// provider must already be created. New capacity providers can be created with
	// the CreateCapacityProvider API operation.
	//
	// To use a Fargate capacity provider, specify either the FARGATE or FARGATE_SPOT
	// capacity providers. The Fargate capacity providers are available to all accounts
	// and only need to be associated with a cluster to be used.
	//
	// CapacityProviders is a required field
	CapacityProviders []*string `locationName:"capacityProviders" type:"list" required:"true"`

	// The short name or full Amazon Resource Name (ARN) of the cluster to modify
	// the capacity provider settings for. If you don't specify a cluster, the default
	// cluster is assumed.
	//
	// Cluster is a required field
	Cluster *string `locationName:"cluster" type:"string" required:"true"`

	// The capacity provider strategy to use by default for the cluster.
	//
	// When creating a service or running a task on a cluster, if no capacity provider
	// or launch type is specified then the default capacity provider strategy for
	// the cluster is used.
	//
	// A capacity provider strategy consists of one or more capacity providers along
	// with the base and weight to assign to them. A capacity provider must be associated
	// with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders
	// API is used to associate a capacity provider with a cluster. Only capacity
	// providers with an ACTIVE or UPDATING status can be used.
	//
	// If specifying a capacity provider that uses an Auto Scaling group, the capacity
	// provider must already be created. New capacity providers can be created with
	// the CreateCapacityProvider API operation.
	//
	// To use a Fargate capacity provider, specify either the FARGATE or FARGATE_SPOT
	// capacity providers. The Fargate capacity providers are available to all accounts
	// and only need to be associated with a cluster to be used.
	//
	// DefaultCapacityProviderStrategy is a required field
	DefaultCapacityProviderStrategy []*CapacityProviderStrategyItem `locationName:"defaultCapacityProviderStrategy" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutClusterCapacityProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutClusterCapacityProvidersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutClusterCapacityProvidersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutClusterCapacityProvidersInput"}
	if s.CapacityProviders == nil {
		invalidParams.Add(request.NewErrParamRequired("CapacityProviders"))
	}
	if s.Cluster == nil {
		invalidParams.Add(request.NewErrParamRequired("Cluster"))
	}
	if s.DefaultCapacityProviderStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultCapacityProviderStrategy"))
	}
	if s.DefaultCapacityProviderStrategy != nil {
		for i, v := range s.DefaultCapacityProviderStrategy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DefaultCapacityProviderStrategy", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityProviders sets the CapacityProviders field's value.
func (s *PutClusterCapacityProvidersInput) SetCapacityProviders(v []*string) *PutClusterCapacityProvidersInput {
	s.CapacityProviders = v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *PutClusterCapacityProvidersInput) SetCluster(v string) *PutClusterCapacityProvidersInput {
	s.Cluster = &v
	return s
}

// SetDefaultCapacityProviderStrategy sets the DefaultCapacityProviderStrategy field's value.
func (s *PutClusterCapacityProvidersInput) SetDefaultCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *PutClusterCapacityProvidersInput {
	s.DefaultCapacityProviderStrategy = v
	return s
}

type PutClusterCapacityProvidersOutput struct {
	_ struct{} `type:"structure"`

	// Details about the cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutClusterCapacityProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutClusterCapacityProvidersOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *PutClusterCapacityProvidersOutput) SetCluster(v *Cluster) *PutClusterCapacityProvidersOutput {
	s.Cluster = v
	return s
}

type RegisterContainerInstanceInput struct {
	_ struct{} `type:"structure"`

	// The container instance attributes that this container instance supports.
	Attributes []*Attribute `locationName:"attributes" type:"list"`

	// The short name or full Amazon Resource Name (ARN) of the cluster to register
	// your container instance with. If you do not specify a cluster, the default
	// cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// The ARN of the container instance (if it was previously registered).
	ContainerInstanceArn *string `locationName:"containerInstanceArn" type:"string"`

	// The instance identity document for the EC2 instance to register. This document
	// can be found by running the following command from the instance: curl http://169.254.169.254/latest/dynamic/instance-identity/document/
	InstanceIdentityDocument *string `locationName:"instanceIdentityDocument" type:"string"`

	// The instance identity document signature for the EC2 instance to register.
	// This signature can be found by running the following command from the instance:
	// curl http://169.254.169.254/latest/dynamic/instance-identity/signature/
	InstanceIdentityDocumentSignature *string `locationName:"instanceIdentityDocumentSignature" type:"string"`

	// The devices that are available on the container instance. The only supported
	// device type is a GPU.
	PlatformDevices []*PlatformDevice `locationName:"platformDevices" type:"list"`

	// The metadata that you apply to the container instance to help you categorize
	// and organize them. Each tag consists of a key and an optional value. You
	// define both.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The resources available on the instance.
	TotalResources []*Resource `locationName:"totalResources" type:"list"`

	// The version information for the Amazon ECS container agent and Docker daemon
	// that runs on the container instance.
	VersionInfo *VersionInfo `locationName:"versionInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterContainerInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterContainerInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterContainerInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterContainerInstanceInput"}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PlatformDevices != nil {
		for i, v := range s.PlatformDevices {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PlatformDevices", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *RegisterContainerInstanceInput) SetAttributes(v []*Attribute) *RegisterContainerInstanceInput {
	s.Attributes = v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *RegisterContainerInstanceInput) SetCluster(v string) *RegisterContainerInstanceInput {
	s.Cluster = &v
	return s
}

// SetContainerInstanceArn sets the ContainerInstanceArn field's value.
func (s *RegisterContainerInstanceInput) SetContainerInstanceArn(v string) *RegisterContainerInstanceInput {
	s.ContainerInstanceArn = &v
	return s
}

// SetInstanceIdentityDocument sets the InstanceIdentityDocument field's value.
func (s *RegisterContainerInstanceInput) SetInstanceIdentityDocument(v string) *RegisterContainerInstanceInput {
	s.InstanceIdentityDocument = &v
	return s
}

// SetInstanceIdentityDocumentSignature sets the InstanceIdentityDocumentSignature field's value.
func (s *RegisterContainerInstanceInput) SetInstanceIdentityDocumentSignature(v string) *RegisterContainerInstanceInput {
	s.InstanceIdentityDocumentSignature = &v
	return s
}

// SetPlatformDevices sets the PlatformDevices field's value.
func (s *RegisterContainerInstanceInput) SetPlatformDevices(v []*PlatformDevice) *RegisterContainerInstanceInput {
	s.PlatformDevices = v
	return s
}

// SetTags sets the Tags field's value.
func (s *RegisterContainerInstanceInput) SetTags(v []*Tag) *RegisterContainerInstanceInput {
	s.Tags = v
	return s
}

// SetTotalResources sets the TotalResources field's value.
func (s *RegisterContainerInstanceInput) SetTotalResources(v []*Resource) *RegisterContainerInstanceInput {
	s.TotalResources = v
	return s
}

// SetVersionInfo sets the VersionInfo field's value.
func (s *RegisterContainerInstanceInput) SetVersionInfo(v *VersionInfo) *RegisterContainerInstanceInput {
	s.VersionInfo = v
	return s
}

type RegisterContainerInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The container instance that was registered.
	ContainerInstance *ContainerInstance `locationName:"containerInstance" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterContainerInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterContainerInstanceOutput) GoString() string {
	return s.String()
}

// SetContainerInstance sets the ContainerInstance field's value.
func (s *RegisterContainerInstanceOutput) SetContainerInstance(v *ContainerInstance) *RegisterContainerInstanceOutput {
	s.ContainerInstance = v
	return s
}

type RegisterTaskDefinitionInput struct {
	_ struct{} `type:"structure"`

	// A list of container definitions in JSON format that describe the different
	// containers that make up your task.
	//
	// ContainerDefinitions is a required field
	ContainerDefinitions []*ContainerDefinition `locationName:"containerDefinitions" type:"list" required:"true"`

	// The number of CPU units used by the task. It can be expressed as an integer
	// using CPU units (for example, 1024) or as a string using vCPUs (for example,
	// 1 vCPU or 1 vcpu) in a task definition. String values are converted to an
	// integer indicating the CPU units when the task definition is registered.
	//
	// Task-level CPU and memory parameters are ignored for Windows containers.
	// We recommend specifying container-level resources for Windows containers.
	//
	// If you're using the EC2 launch type, this field is optional. Supported values
	// are between 128 CPU units (0.125 vCPUs) and 10240 CPU units (10 vCPUs).
	//
	// If you're using the Fargate launch type, this field is required and you must
	// use one of the following values, which determines your range of supported
	// values for the memory parameter:
	//
	// The CPU units cannot be less than 1 vCPU when you use Windows containers
	// on Fargate.
	//
	//    * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB),
	//    2048 (2 GB)
	//
	//    * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072
	//    (3 GB), 4096 (4 GB)
	//
	//    * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096
	//    (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
	//
	//    * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384
	//    (16 GB) in increments of 1024 (1 GB)
	//
	//    * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720
	//    (30 GB) in increments of 1024 (1 GB)
	Cpu *string `locationName:"cpu" type:"string"`

	// The amount of ephemeral storage to allocate for the task. This parameter
	// is used to expand the total amount of ephemeral storage available, beyond
	// the default amount, for tasks hosted on Fargate. For more information, see
	// Fargate task storage (https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html)
	// in the Amazon ECS User Guide for Fargate.
	//
	// This parameter is only supported for tasks hosted on Fargate using the following
	// platform versions:
	//
	//    * Linux platform version 1.4.0 or later.
	//
	//    * Windows platform version 1.0.0 or later.
	EphemeralStorage *EphemeralStorage `locationName:"ephemeralStorage" type:"structure"`

	// The Amazon Resource Name (ARN) of the task execution role that grants the
	// Amazon ECS container agent permission to make Amazon Web Services API calls
	// on your behalf. The task execution IAM role is required depending on the
	// requirements of your task. For more information, see Amazon ECS task execution
	// IAM role (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html)
	// in the Amazon Elastic Container Service Developer Guide.
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string"`

	// You must specify a family for a task definition. You can use it track multiple
	// versions of the same task definition. The family is used as a name for your
	// task definition. Up to 255 letters (uppercase and lowercase), numbers, underscores,
	// and hyphens are allowed.
	//
	// Family is a required field
	Family *string `locationName:"family" type:"string" required:"true"`

	// The Elastic Inference accelerators to use for the containers in the task.
	InferenceAccelerators []*InferenceAccelerator `locationName:"inferenceAccelerators" type:"list"`

	// The IPC resource namespace to use for the containers in the task. The valid
	// values are host, task, or none. If host is specified, then all containers
	// within the tasks that specified the host IPC mode on the same container instance
	// share the same IPC resources with the host Amazon EC2 instance. If task is
	// specified, all containers within the specified task share the same IPC resources.
	// If none is specified, then IPC resources within the containers of a task
	// are private and not shared with other containers in a task or on the container
	// instance. If no value is specified, then the IPC resource namespace sharing
	// depends on the Docker daemon setting on the container instance. For more
	// information, see IPC settings (https://docs.docker.com/engine/reference/run/#ipc-settings---ipc)
	// in the Docker run reference.
	//
	// If the host IPC mode is used, be aware that there is a heightened risk of
	// undesired IPC namespace expose. For more information, see Docker security
	// (https://docs.docker.com/engine/security/security/).
	//
	// If you are setting namespaced kernel parameters using systemControls for
	// the containers in the task, the following will apply to your IPC resource
	// namespace. For more information, see System Controls (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	//    * For tasks that use the host IPC mode, IPC namespace related systemControls
	//    are not supported.
	//
	//    * For tasks that use the task IPC mode, IPC namespace related systemControls
	//    will apply to all containers within a task.
	//
	// This parameter is not supported for Windows containers or tasks run on Fargate.
	IpcMode *string `locationName:"ipcMode" type:"string" enum:"IpcMode"`

	// The amount of memory (in MiB) used by the task. It can be expressed as an
	// integer using MiB (for example ,1024) or as a string using GB (for example,
	// 1GB or 1 GB) in a task definition. String values are converted to an integer
	// indicating the MiB when the task definition is registered.
	//
	// Task-level CPU and memory parameters are ignored for Windows containers.
	// We recommend specifying container-level resources for Windows containers.
	//
	// If using the EC2 launch type, this field is optional.
	//
	// If using the Fargate launch type, this field is required and you must use
	// one of the following values. This determines your range of supported values
	// for the cpu parameter.
	//
	// The CPU units cannot be less than 1 vCPU when you use Windows containers
	// on Fargate.
	//
	//    * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25
	//    vCPU)
	//
	//    * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values:
	//    512 (.5 vCPU)
	//
	//    * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168
	//    (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
	//
	//    * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) -
	//    Available cpu values: 2048 (2 vCPU)
	//
	//    * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) -
	//    Available cpu values: 4096 (4 vCPU)
	Memory *string `locationName:"memory" type:"string"`

	// The Docker networking mode to use for the containers in the task. The valid
	// values are none, bridge, awsvpc, and host. If no network mode is specified,
	// the default is bridge.
	//
	// For Amazon ECS tasks on Fargate, the awsvpc network mode is required. For
	// Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used.
	// For Amazon ECS tasks on Amazon EC2 Windows instances, <default> or awsvpc
	// can be used. If the network mode is set to none, you cannot specify port
	// mappings in your container definitions, and the tasks containers do not have
	// external connectivity. The host and awsvpc network modes offer the highest
	// networking performance for containers because they use the EC2 network stack
	// instead of the virtualized network stack provided by the bridge mode.
	//
	// With the host and awsvpc network modes, exposed container ports are mapped
	// directly to the corresponding host port (for the host network mode) or the
	// attached elastic network interface port (for the awsvpc network mode), so
	// you cannot take advantage of dynamic host port mappings.
	//
	// When using the host network mode, you should not run containers using the
	// root user (UID 0). It is considered best practice to use a non-root user.
	//
	// If the network mode is awsvpc, the task is allocated an elastic network interface,
	// and you must specify a NetworkConfiguration value when you create a service
	// or run a task with the task definition. For more information, see Task Networking
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// If the network mode is host, you cannot run multiple instantiations of the
	// same task on a single container instance when port mappings are used.
	//
	// For more information, see Network settings (https://docs.docker.com/engine/reference/run/#network-settings)
	// in the Docker run reference.
	NetworkMode *string `locationName:"networkMode" type:"string" enum:"NetworkMode"`

	// The process namespace to use for the containers in the task. The valid values
	// are host or task. If host is specified, then all containers within the tasks
	// that specified the host PID mode on the same container instance share the
	// same process namespace with the host Amazon EC2 instance. If task is specified,
	// all containers within the specified task share the same process namespace.
	// If no value is specified, the default is a private namespace. For more information,
	// see PID settings (https://docs.docker.com/engine/reference/run/#pid-settings---pid)
	// in the Docker run reference.
	//
	// If the host PID mode is used, be aware that there is a heightened risk of
	// undesired process namespace expose. For more information, see Docker security
	// (https://docs.docker.com/engine/security/security/).
	//
	// This parameter is not supported for Windows containers or tasks run on Fargate.
	PidMode *string `locationName:"pidMode" type:"string" enum:"PidMode"`

	// An array of placement constraint objects to use for the task. You can specify
	// a maximum of 10 constraints for each task. This limit includes constraints
	// in the task definition and those specified at runtime.
	PlacementConstraints []*TaskDefinitionPlacementConstraint `locationName:"placementConstraints" type:"list"`

	// The configuration details for the App Mesh proxy.
	//
	// For tasks hosted on Amazon EC2 instances, the container instances require
	// at least version 1.26.0 of the container agent and at least version 1.26.0-1
	// of the ecs-init package to use a proxy configuration. If your container instances
	// are launched from the Amazon ECS-optimized AMI version 20190301 or later,
	// then they contain the required versions of the container agent and ecs-init.
	// For more information, see Amazon ECS-optimized AMI versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-ami-versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	ProxyConfiguration *ProxyConfiguration `locationName:"proxyConfiguration" type:"structure"`

	// The task launch type that Amazon ECS validates the task definition against.
	// A client exception is returned if the task definition doesn't validate against
	// the compatibilities specified. If no value is specified, the parameter is
	// omitted from the response.
	RequiresCompatibilities []*string `locationName:"requiresCompatibilities" type:"list" enum:"Compatibility"`

	// The operating system that your tasks definitions run on. A platform family
	// is specified only for tasks using the Fargate launch type.
	//
	// When you specify a task definition in a service, this value must match the
	// runtimePlatform value of the service.
	RuntimePlatform *RuntimePlatform `locationName:"runtimePlatform" type:"structure"`

	// The metadata that you apply to the task definition to help you categorize
	// and organize them. Each tag consists of a key and an optional value. You
	// define both of them.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The short name or full Amazon Resource Name (ARN) of the IAM role that containers
	// in this task can assume. All containers in this task are granted the permissions
	// that are specified in this role. For more information, see IAM Roles for
	// Tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	TaskRoleArn *string `locationName:"taskRoleArn" type:"string"`

	// A list of volume definitions in JSON format that containers in your task
	// might use.
	Volumes []*Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterTaskDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterTaskDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterTaskDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterTaskDefinitionInput"}
	if s.ContainerDefinitions == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerDefinitions"))
	}
	if s.Family == nil {
		invalidParams.Add(request.NewErrParamRequired("Family"))
	}
	if s.ContainerDefinitions != nil {
		for i, v := range s.ContainerDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContainerDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EphemeralStorage != nil {
		if err := s.EphemeralStorage.Validate(); err != nil {
			invalidParams.AddNested("EphemeralStorage", err.(request.ErrInvalidParams))
		}
	}
	if s.InferenceAccelerators != nil {
		for i, v := range s.InferenceAccelerators {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InferenceAccelerators", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ProxyConfiguration != nil {
		if err := s.ProxyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProxyConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Volumes != nil {
		for i, v := range s.Volumes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Volumes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerDefinitions sets the ContainerDefinitions field's value.
func (s *RegisterTaskDefinitionInput) SetContainerDefinitions(v []*ContainerDefinition) *RegisterTaskDefinitionInput {
	s.ContainerDefinitions = v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *RegisterTaskDefinitionInput) SetCpu(v string) *RegisterTaskDefinitionInput {
	s.Cpu = &v
	return s
}

// SetEphemeralStorage sets the EphemeralStorage field's value.
func (s *RegisterTaskDefinitionInput) SetEphemeralStorage(v *EphemeralStorage) *RegisterTaskDefinitionInput {
	s.EphemeralStorage = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *RegisterTaskDefinitionInput) SetExecutionRoleArn(v string) *RegisterTaskDefinitionInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *RegisterTaskDefinitionInput) SetFamily(v string) *RegisterTaskDefinitionInput {
	s.Family = &v
	return s
}

// SetInferenceAccelerators sets the InferenceAccelerators field's value.
func (s *RegisterTaskDefinitionInput) SetInferenceAccelerators(v []*InferenceAccelerator) *RegisterTaskDefinitionInput {
	s.InferenceAccelerators = v
	return s
}

// SetIpcMode sets the IpcMode field's value.
func (s *RegisterTaskDefinitionInput) SetIpcMode(v string) *RegisterTaskDefinitionInput {
	s.IpcMode = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *RegisterTaskDefinitionInput) SetMemory(v string) *RegisterTaskDefinitionInput {
	s.Memory = &v
	return s
}

// SetNetworkMode sets the NetworkMode field's value.
func (s *RegisterTaskDefinitionInput) SetNetworkMode(v string) *RegisterTaskDefinitionInput {
	s.NetworkMode = &v
	return s
}

// SetPidMode sets the PidMode field's value.
func (s *RegisterTaskDefinitionInput) SetPidMode(v string) *RegisterTaskDefinitionInput {
	s.PidMode = &v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *RegisterTaskDefinitionInput) SetPlacementConstraints(v []*TaskDefinitionPlacementConstraint) *RegisterTaskDefinitionInput {
	s.PlacementConstraints = v
	return s
}

// SetProxyConfiguration sets the ProxyConfiguration field's value.
func (s *RegisterTaskDefinitionInput) SetProxyConfiguration(v *ProxyConfiguration) *RegisterTaskDefinitionInput {
	s.ProxyConfiguration = v
	return s
}

// SetRequiresCompatibilities sets the RequiresCompatibilities field's value.
func (s *RegisterTaskDefinitionInput) SetRequiresCompatibilities(v []*string) *RegisterTaskDefinitionInput {
	s.RequiresCompatibilities = v
	return s
}

// SetRuntimePlatform sets the RuntimePlatform field's value.
func (s *RegisterTaskDefinitionInput) SetRuntimePlatform(v *RuntimePlatform) *RegisterTaskDefinitionInput {
	s.RuntimePlatform = v
	return s
}

// SetTags sets the Tags field's value.
func (s *RegisterTaskDefinitionInput) SetTags(v []*Tag) *RegisterTaskDefinitionInput {
	s.Tags = v
	return s
}

// SetTaskRoleArn sets the TaskRoleArn field's value.
func (s *RegisterTaskDefinitionInput) SetTaskRoleArn(v string) *RegisterTaskDefinitionInput {
	s.TaskRoleArn = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *RegisterTaskDefinitionInput) SetVolumes(v []*Volume) *RegisterTaskDefinitionInput {
	s.Volumes = v
	return s
}

type RegisterTaskDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags associated with the task definition.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The full description of the registered task definition.
	TaskDefinition *TaskDefinition `locationName:"taskDefinition" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterTaskDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterTaskDefinitionOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *RegisterTaskDefinitionOutput) SetTags(v []*Tag) *RegisterTaskDefinitionOutput {
	s.Tags = v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *RegisterTaskDefinitionOutput) SetTaskDefinition(v *TaskDefinition) *RegisterTaskDefinitionOutput {
	s.TaskDefinition = v
	return s
}

// The repository credentials for private registry authentication.
type RepositoryCredentials struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret containing the private repository
	// credentials.
	//
	// When you use the Amazon ECS API, CLI, or Amazon Web Services SDK, if the
	// secret exists in the same Region as the task that you're launching then you
	// can use either the full ARN or the name of the secret. When you use the Amazon
	// Web Services Management Console, you must specify the full ARN of the secret.
	//
	// CredentialsParameter is a required field
	CredentialsParameter *string `locationName:"credentialsParameter" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RepositoryCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RepositoryCredentials"}
	if s.CredentialsParameter == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsParameter"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentialsParameter sets the CredentialsParameter field's value.
func (s *RepositoryCredentials) SetCredentialsParameter(v string) *RepositoryCredentials {
	s.CredentialsParameter = &v
	return s
}

// Describes the resources available for a container instance.
type Resource struct {
	_ struct{} `type:"structure"`

	// When the doubleValue type is set, the value of the resource must be a double
	// precision floating-point type.
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// When the integerValue type is set, the value of the resource must be an integer.
	IntegerValue *int64 `locationName:"integerValue" type:"integer"`

	// When the longValue type is set, the value of the resource must be an extended
	// precision floating-point type.
	LongValue *int64 `locationName:"longValue" type:"long"`

	// The name of the resource, such as CPU, MEMORY, PORTS, PORTS_UDP, or a user-defined
	// resource.
	Name *string `locationName:"name" type:"string"`

	// When the stringSetValue type is set, the value of the resource must be a
	// string type.
	StringSetValue []*string `locationName:"stringSetValue" type:"list"`

	// The type of the resource. Valid values: INTEGER, DOUBLE, LONG, or STRINGSET.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetDoubleValue sets the DoubleValue field's value.
func (s *Resource) SetDoubleValue(v float64) *Resource {
	s.DoubleValue = &v
	return s
}

// SetIntegerValue sets the IntegerValue field's value.
func (s *Resource) SetIntegerValue(v int64) *Resource {
	s.IntegerValue = &v
	return s
}

// SetLongValue sets the LongValue field's value.
func (s *Resource) SetLongValue(v int64) *Resource {
	s.LongValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *Resource) SetName(v string) *Resource {
	s.Name = &v
	return s
}

// SetStringSetValue sets the StringSetValue field's value.
func (s *Resource) SetStringSetValue(v []*string) *Resource {
	s.StringSetValue = v
	return s
}

// SetType sets the Type field's value.
func (s *Resource) SetType(v string) *Resource {
	s.Type = &v
	return s
}

// The specified resource is in-use and can't be removed.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource wasn't found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The type and amount of a resource to assign to a container. The supported
// resource types are GPUs and Elastic Inference accelerators. For more information,
// see Working with GPUs on Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-gpu.html)
// or Working with Amazon Elastic Inference on Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html)
// in the Amazon Elastic Container Service Developer Guide
type ResourceRequirement struct {
	_ struct{} `type:"structure"`

	// The type of resource to assign to a container. The supported values are GPU
	// or InferenceAccelerator.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ResourceType"`

	// The value for the specified resource type.
	//
	// If the GPU type is used, the value is the number of physical GPUs the Amazon
	// ECS container agent reserves for the container. The number of GPUs that's
	// reserved for all containers in a task can't exceed the number of available
	// GPUs on the container instance that the task is launched on.
	//
	// If the InferenceAccelerator type is used, the value matches the deviceName
	// for an InferenceAccelerator specified in a task definition.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceRequirement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceRequirement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceRequirement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceRequirement"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *ResourceRequirement) SetType(v string) *ResourceRequirement {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceRequirement) SetValue(v string) *ResourceRequirement {
	s.Value = &v
	return s
}

type RunTaskInput struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy to use for the task.
	//
	// If a capacityProviderStrategy is specified, the launchType parameter must
	// be omitted. If no capacityProviderStrategy or launchType is specified, the
	// defaultCapacityProviderStrategy for the cluster is used.
	//
	// When you use cluster auto scaling, you must specify capacityProviderStrategy
	// and not launchType.
	//
	// A capacity provider strategy may contain a maximum of 6 capacity providers.
	CapacityProviderStrategy []*CapacityProviderStrategyItem `locationName:"capacityProviderStrategy" type:"list"`

	// The short name or full Amazon Resource Name (ARN) of the cluster to run your
	// task on. If you do not specify a cluster, the default cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// The number of instantiations of the specified task to place on your cluster.
	// You can specify up to 10 tasks for each call.
	Count *int64 `locationName:"count" type:"integer"`

	// Specifies whether to use Amazon ECS managed tags for the task. For more information,
	// see Tagging Your Amazon ECS Resources (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
	// in the Amazon Elastic Container Service Developer Guide.
	EnableECSManagedTags *bool `locationName:"enableECSManagedTags" type:"boolean"`

	// Determines whether to use the execute command functionality for the containers
	// in this task. If true, this enables execute command functionality on all
	// containers in the task.
	//
	// If true, then the task definition must have a task role, or you must provide
	// one as an override.
	EnableExecuteCommand *bool `locationName:"enableExecuteCommand" type:"boolean"`

	// The name of the task group to associate with the task. The default value
	// is the family name of the task definition (for example, family:my-family-name).
	Group *string `locationName:"group" type:"string"`

	// The infrastructure to run your standalone task on. For more information,
	// see Amazon ECS launch types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// The FARGATE launch type runs your tasks on Fargate On-Demand infrastructure.
	//
	// Fargate Spot infrastructure is available for use but a capacity provider
	// strategy must be used. For more information, see Fargate capacity providers
	// (https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html)
	// in the Amazon ECS User Guide for Fargate.
	//
	// The EC2 launch type runs your tasks on Amazon EC2 instances registered to
	// your cluster.
	//
	// The EXTERNAL launch type runs your tasks on your on-premises server or virtual
	// machine (VM) capacity registered to your cluster.
	//
	// A task can use either a launch type or a capacity provider strategy. If a
	// launchType is specified, the capacityProviderStrategy parameter must be omitted.
	//
	// When you use cluster auto scaling, you must specify capacityProviderStrategy
	// and not launchType.
	LaunchType *string `locationName:"launchType" type:"string" enum:"LaunchType"`

	// The network configuration for the task. This parameter is required for task
	// definitions that use the awsvpc network mode to receive their own elastic
	// network interface, and it isn't supported for other network modes. For more
	// information, see Task networking (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
	// in the Amazon Elastic Container Service Developer Guide.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// A list of container overrides in JSON format that specify the name of a container
	// in the specified task definition and the overrides it should receive. You
	// can override the default command for a container (that's specified in the
	// task definition or Docker image) with a command override. You can also override
	// existing environment variables (that are specified in the task definition
	// or Docker image) on a container or add new environment variables to it with
	// an environment override.
	//
	// A total of 8192 characters are allowed for overrides. This limit includes
	// the JSON formatting characters of the override structure.
	Overrides *TaskOverride `locationName:"overrides" type:"structure"`

	// An array of placement constraint objects to use for the task. You can specify
	// up to 10 constraints for each task (including constraints in the task definition
	// and those specified at runtime).
	PlacementConstraints []*PlacementConstraint `locationName:"placementConstraints" type:"list"`

	// The placement strategy objects to use for the task. You can specify a maximum
	// of 5 strategy rules for each task.
	PlacementStrategy []*PlacementStrategy `locationName:"placementStrategy" type:"list"`

	// The platform version the task uses. A platform version is only specified
	// for tasks hosted on Fargate. If one isn't specified, the LATEST platform
	// version is used. For more information, see Fargate platform versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// Specifies whether to propagate the tags from the task definition to the task.
	// If no value is specified, the tags aren't propagated. Tags can only be propagated
	// to the task during task creation. To add tags to a task after task creation,
	// use the TagResource API action.
	//
	// An error will be received if you specify the SERVICE option when running
	// a task.
	PropagateTags *string `locationName:"propagateTags" type:"string" enum:"PropagateTags"`

	// The reference ID to use for the task. The reference ID can have a maximum
	// length of 1024 characters.
	ReferenceId *string `locationName:"referenceId" type:"string"`

	// An optional tag specified when a task is started. For example, if you automatically
	// trigger a task to run a batch process job, you could apply a unique identifier
	// for that job to your task with the startedBy parameter. You can then identify
	// which tasks belong to that job by filtering the results of a ListTasks call
	// with the startedBy value. Up to 36 letters (uppercase and lowercase), numbers,
	// hyphens (-), and underscores (_) are allowed.
	//
	// If a task is started by an Amazon ECS service, then the startedBy parameter
	// contains the deployment ID of the service that starts it.
	StartedBy *string `locationName:"startedBy" type:"string"`

	// The metadata that you apply to the task to help you categorize and organize
	// them. Each tag consists of a key and an optional value, both of which you
	// define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The family and revision (family:revision) or full ARN of the task definition
	// to run. If a revision isn't specified, the latest ACTIVE revision is used.
	//
	// When you create an IAM policy for run-task, you can set the resource to be
	// the latest task definition revision, or a specific revision.
	//
	// The full ARN value must match the value that you specified as the Resource
	// of the IAM principal's permissions policy.
	//
	// When you specify the policy resource as the latest task definition version
	// (by setting the Resource in the policy to arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName),
	// then set this value to arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName.
	//
	// When you specify the policy resource as a specific task definition version
	// (by setting the Resource in the policy to arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1
	// or arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:*),
	// then set this value to arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1.
	//
	// For more information, see Policy Resources for Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources)
	// in the Amazon Elastic Container Service developer Guide.
	//
	// TaskDefinition is a required field
	TaskDefinition *string `locationName:"taskDefinition" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunTaskInput"}
	if s.TaskDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskDefinition"))
	}
	if s.CapacityProviderStrategy != nil {
		for i, v := range s.CapacityProviderStrategy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CapacityProviderStrategy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.NetworkConfiguration != nil {
		if err := s.NetworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Overrides != nil {
		if err := s.Overrides.Validate(); err != nil {
			invalidParams.AddNested("Overrides", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityProviderStrategy sets the CapacityProviderStrategy field's value.
func (s *RunTaskInput) SetCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *RunTaskInput {
	s.CapacityProviderStrategy = v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *RunTaskInput) SetCluster(v string) *RunTaskInput {
	s.Cluster = &v
	return s
}

// SetCount sets the Count field's value.
func (s *RunTaskInput) SetCount(v int64) *RunTaskInput {
	s.Count = &v
	return s
}

// SetEnableECSManagedTags sets the EnableECSManagedTags field's value.
func (s *RunTaskInput) SetEnableECSManagedTags(v bool) *RunTaskInput {
	s.EnableECSManagedTags = &v
	return s
}

// SetEnableExecuteCommand sets the EnableExecuteCommand field's value.
func (s *RunTaskInput) SetEnableExecuteCommand(v bool) *RunTaskInput {
	s.EnableExecuteCommand = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *RunTaskInput) SetGroup(v string) *RunTaskInput {
	s.Group = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *RunTaskInput) SetLaunchType(v string) *RunTaskInput {
	s.LaunchType = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *RunTaskInput) SetNetworkConfiguration(v *NetworkConfiguration) *RunTaskInput {
	s.NetworkConfiguration = v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *RunTaskInput) SetOverrides(v *TaskOverride) *RunTaskInput {
	s.Overrides = v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *RunTaskInput) SetPlacementConstraints(v []*PlacementConstraint) *RunTaskInput {
	s.PlacementConstraints = v
	return s
}

// SetPlacementStrategy sets the PlacementStrategy field's value.
func (s *RunTaskInput) SetPlacementStrategy(v []*PlacementStrategy) *RunTaskInput {
	s.PlacementStrategy = v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *RunTaskInput) SetPlatformVersion(v string) *RunTaskInput {
	s.PlatformVersion = &v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *RunTaskInput) SetPropagateTags(v string) *RunTaskInput {
	s.PropagateTags = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *RunTaskInput) SetReferenceId(v string) *RunTaskInput {
	s.ReferenceId = &v
	return s
}

// SetStartedBy sets the StartedBy field's value.
func (s *RunTaskInput) SetStartedBy(v string) *RunTaskInput {
	s.StartedBy = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RunTaskInput) SetTags(v []*Tag) *RunTaskInput {
	s.Tags = v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *RunTaskInput) SetTaskDefinition(v string) *RunTaskInput {
	s.TaskDefinition = &v
	return s
}

type RunTaskOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*Failure `locationName:"failures" type:"list"`

	// A full description of the tasks that were run. The tasks that were successfully
	// placed on your cluster are described here.
	Tasks []*Task `locationName:"tasks" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunTaskOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *RunTaskOutput) SetFailures(v []*Failure) *RunTaskOutput {
	s.Failures = v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *RunTaskOutput) SetTasks(v []*Task) *RunTaskOutput {
	s.Tasks = v
	return s
}

// Information about the platform for the Amazon ECS service or task.
//
// For more informataion about RuntimePlatform, see RuntimePlatform (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform)
// in the Amazon Elastic Container Service Developer Guide.
type RuntimePlatform struct {
	_ struct{} `type:"structure"`

	// The CPU architecture.
	//
	// You can run your Linux tasks on an ARM-based platform by setting the value
	// to ARM64. This option is avaiable for tasks that run on Linux Amazon EC2
	// instance or Linux containers on Fargate.
	CpuArchitecture *string `locationName:"cpuArchitecture" type:"string" enum:"CPUArchitecture"`

	// The operating system.
	OperatingSystemFamily *string `locationName:"operatingSystemFamily" type:"string" enum:"OSFamily"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuntimePlatform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuntimePlatform) GoString() string {
	return s.String()
}

// SetCpuArchitecture sets the CpuArchitecture field's value.
func (s *RuntimePlatform) SetCpuArchitecture(v string) *RuntimePlatform {
	s.CpuArchitecture = &v
	return s
}

// SetOperatingSystemFamily sets the OperatingSystemFamily field's value.
func (s *RuntimePlatform) SetOperatingSystemFamily(v string) *RuntimePlatform {
	s.OperatingSystemFamily = &v
	return s
}

// A floating-point percentage of the desired number of tasks to place and keep
// running in the task set.
type Scale struct {
	_ struct{} `type:"structure"`

	// The unit of measure for the scale value.
	Unit *string `locationName:"unit" type:"string" enum:"ScaleUnit"`

	// The value, specified as a percent total of a service's desiredCount, to scale
	// the task set. Accepted values are numbers between 0 and 100.
	Value *float64 `locationName:"value" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Scale) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Scale) GoString() string {
	return s.String()
}

// SetUnit sets the Unit field's value.
func (s *Scale) SetUnit(v string) *Scale {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Scale) SetValue(v float64) *Scale {
	s.Value = &v
	return s
}

// An object representing the secret to expose to your container. Secrets can
// be exposed to a container in the following ways:
//
//   - To inject sensitive data into your containers as environment variables,
//     use the secrets container definition parameter.
//
//   - To reference sensitive information in the log configuration of a container,
//     use the secretOptions container definition parameter.
//
// For more information, see Specifying sensitive data (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html)
// in the Amazon Elastic Container Service Developer Guide.
type Secret struct {
	_ struct{} `type:"structure"`

	// The name of the secret.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The secret to expose to the container. The supported values are either the
	// full ARN of the Secrets Manager secret or the full ARN of the parameter in
	// the SSM Parameter Store.
	//
	// For information about the require Identity and Access Management permissions,
	// see Required IAM permissions for Amazon ECS secrets (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam)
	// (for Secrets Manager) or Required IAM permissions for Amazon ECS secrets
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html)
	// (for Systems Manager Parameter store) in the Amazon Elastic Container Service
	// Developer Guide.
	//
	// If the SSM Parameter Store parameter exists in the same Region as the task
	// you're launching, then you can use either the full ARN or name of the parameter.
	// If the parameter exists in a different Region, then the full ARN must be
	// specified.
	//
	// ValueFrom is a required field
	ValueFrom *string `locationName:"valueFrom" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Secret) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Secret) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Secret) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Secret"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ValueFrom == nil {
		invalidParams.Add(request.NewErrParamRequired("ValueFrom"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Secret) SetName(v string) *Secret {
	s.Name = &v
	return s
}

// SetValueFrom sets the ValueFrom field's value.
func (s *Secret) SetValueFrom(v string) *Secret {
	s.ValueFrom = &v
	return s
}

// These errors are usually caused by a server issue.
type ServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerException) GoString() string {
	return s.String()
}

func newErrorServerException(v protocol.ResponseMetadata) error {
	return &ServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServerException) Code() string {
	return "ServerException"
}

// Message returns the exception's message.
func (s *ServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServerException) OrigErr() error {
	return nil
}

func (s *ServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details on a service within a cluster
type Service struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy the service uses. When using the DescribeServices
	// API, this field is omitted if the service was created using a launch type.
	CapacityProviderStrategy []*CapacityProviderStrategyItem `locationName:"capacityProviderStrategy" type:"list"`

	// The Amazon Resource Name (ARN) of the cluster that hosts the service.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Unix timestamp for the time when the service was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The principal that created the service.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// Optional deployment parameters that control how many tasks run during the
	// deployment and the ordering of stopping and starting tasks.
	DeploymentConfiguration *DeploymentConfiguration `locationName:"deploymentConfiguration" type:"structure"`

	// The deployment controller type the service is using. When using the DescribeServices
	// API, this field is omitted if the service uses the ECS deployment controller
	// type.
	DeploymentController *DeploymentController `locationName:"deploymentController" type:"structure"`

	// The current state of deployments for the service.
	Deployments []*Deployment `locationName:"deployments" type:"list"`

	// The desired number of instantiations of the task definition to keep running
	// on the service. This value is specified when the service is created with
	// CreateService, and it can be modified with UpdateService.
	DesiredCount *int64 `locationName:"desiredCount" type:"integer"`

	// Determines whether to use Amazon ECS managed tags for the tasks in the service.
	// For more information, see Tagging Your Amazon ECS Resources (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
	// in the Amazon Elastic Container Service Developer Guide.
	EnableECSManagedTags *bool `locationName:"enableECSManagedTags" type:"boolean"`

	// Determines whether the execute command functionality is enabled for the service.
	// If true, the execute command functionality is enabled for all containers
	// in tasks as part of the service.
	EnableExecuteCommand *bool `locationName:"enableExecuteCommand" type:"boolean"`

	// The event stream for your service. A maximum of 100 of the latest events
	// are displayed.
	Events []*ServiceEvent `locationName:"events" type:"list"`

	// The period of time, in seconds, that the Amazon ECS service scheduler ignores
	// unhealthy Elastic Load Balancing target health checks after a task has first
	// started.
	HealthCheckGracePeriodSeconds *int64 `locationName:"healthCheckGracePeriodSeconds" type:"integer"`

	// The launch type the service is using. When using the DescribeServices API,
	// this field is omitted if the service was created using a capacity provider
	// strategy.
	LaunchType *string `locationName:"launchType" type:"string" enum:"LaunchType"`

	// A list of Elastic Load Balancing load balancer objects. It contains the load
	// balancer name, the container name, and the container port to access from
	// the load balancer. The container name is as it appears in a container definition.
	LoadBalancers []*LoadBalancer `locationName:"loadBalancers" type:"list"`

	// The VPC subnet and security group configuration for tasks that receive their
	// own elastic network interface by using the awsvpc networking mode.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The number of tasks in the cluster that are in the PENDING state.
	PendingCount *int64 `locationName:"pendingCount" type:"integer"`

	// The placement constraints for the tasks in the service.
	PlacementConstraints []*PlacementConstraint `locationName:"placementConstraints" type:"list"`

	// The placement strategy that determines how tasks for the service are placed.
	PlacementStrategy []*PlacementStrategy `locationName:"placementStrategy" type:"list"`

	// The operating system that your tasks in the service run on. A platform family
	// is specified only for tasks using the Fargate launch type.
	//
	// All tasks that run as part of this service must use the same platformFamily
	// value as the service (for example, LINUX).
	PlatformFamily *string `locationName:"platformFamily" type:"string"`

	// The platform version to run your service on. A platform version is only specified
	// for tasks that are hosted on Fargate. If one isn't specified, the LATEST
	// platform version is used. For more information, see Fargate Platform Versions
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// Determines whether to propagate the tags from the task definition or the
	// service to the task. If no value is specified, the tags aren't propagated.
	PropagateTags *string `locationName:"propagateTags" type:"string" enum:"PropagateTags"`

	// The ARN of the IAM role that's associated with the service. It allows the
	// Amazon ECS container agent to register container instances with an Elastic
	// Load Balancing load balancer.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The number of tasks in the cluster that are in the RUNNING state.
	RunningCount *int64 `locationName:"runningCount" type:"integer"`

	// The scheduling strategy to use for the service. For more information, see
	// Services (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
	//
	// There are two service scheduler strategies available.
	//
	//    * REPLICA-The replica scheduling strategy places and maintains the desired
	//    number of tasks across your cluster. By default, the service scheduler
	//    spreads tasks across Availability Zones. You can use task placement strategies
	//    and constraints to customize task placement decisions.
	//
	//    * DAEMON-The daemon scheduling strategy deploys exactly one task on each
	//    active container instance. This task meets all of the task placement constraints
	//    that you specify in your cluster. The service scheduler also evaluates
	//    the task placement constraints for running tasks. It stop tasks that don't
	//    meet the placement constraints. Fargate tasks don't support the DAEMON
	//    scheduling strategy.
	SchedulingStrategy *string `locationName:"schedulingStrategy" type:"string" enum:"SchedulingStrategy"`

	// The ARN that identifies the service. For more information about the ARN format,
	// see Amazon Resource Name (ARN) (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids)
	// in the Amazon ECS Developer Guide.
	ServiceArn *string `locationName:"serviceArn" type:"string"`

	// The name of your service. Up to 255 letters (uppercase and lowercase), numbers,
	// underscores, and hyphens are allowed. Service names must be unique within
	// a cluster. However, you can have similarly named services in multiple clusters
	// within a Region or across multiple Regions.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// The details for the service discovery registries to assign to this service.
	// For more information, see Service Discovery (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
	ServiceRegistries []*ServiceRegistry `locationName:"serviceRegistries" type:"list"`

	// The status of the service. The valid values are ACTIVE, DRAINING, or INACTIVE.
	Status *string `locationName:"status" type:"string"`

	// The metadata that you apply to the service to help you categorize and organize
	// them. Each tag consists of a key and an optional value. You define bot the
	// key and value.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The task definition to use for tasks in the service. This value is specified
	// when the service is created with CreateService, and it can be modified with
	// UpdateService.
	TaskDefinition *string `locationName:"taskDefinition" type:"string"`

	// Information about a set of Amazon ECS tasks in either an CodeDeploy or an
	// EXTERNAL deployment. An Amazon ECS task set includes details such as the
	// desired number of tasks, how many tasks are running, and whether the task
	// set serves production traffic.
	TaskSets []*TaskSet `locationName:"taskSets" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Service) GoString() string {
	return s.String()
}

// SetCapacityProviderStrategy sets the CapacityProviderStrategy field's value.
func (s *Service) SetCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *Service {
	s.CapacityProviderStrategy = v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *Service) SetClusterArn(v string) *Service {
	s.ClusterArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Service) SetCreatedAt(v time.Time) *Service {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Service) SetCreatedBy(v string) *Service {
	s.CreatedBy = &v
	return s
}

// SetDeploymentConfiguration sets the DeploymentConfiguration field's value.
func (s *Service) SetDeploymentConfiguration(v *DeploymentConfiguration) *Service {
	s.DeploymentConfiguration = v
	return s
}

// SetDeploymentController sets the DeploymentController field's value.
func (s *Service) SetDeploymentController(v *DeploymentController) *Service {
	s.DeploymentController = v
	return s
}

// SetDeployments sets the Deployments field's value.
func (s *Service) SetDeployments(v []*Deployment) *Service {
	s.Deployments = v
	return s
}

// SetDesiredCount sets the DesiredCount field's value.
func (s *Service) SetDesiredCount(v int64) *Service {
	s.DesiredCount = &v
	return s
}

// SetEnableECSManagedTags sets the EnableECSManagedTags field's value.
func (s *Service) SetEnableECSManagedTags(v bool) *Service {
	s.EnableECSManagedTags = &v
	return s
}

// SetEnableExecuteCommand sets the EnableExecuteCommand field's value.
func (s *Service) SetEnableExecuteCommand(v bool) *Service {
	s.EnableExecuteCommand = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *Service) SetEvents(v []*ServiceEvent) *Service {
	s.Events = v
	return s
}

// SetHealthCheckGracePeriodSeconds sets the HealthCheckGracePeriodSeconds field's value.
func (s *Service) SetHealthCheckGracePeriodSeconds(v int64) *Service {
	s.HealthCheckGracePeriodSeconds = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *Service) SetLaunchType(v string) *Service {
	s.LaunchType = &v
	return s
}

// SetLoadBalancers sets the LoadBalancers field's value.
func (s *Service) SetLoadBalancers(v []*LoadBalancer) *Service {
	s.LoadBalancers = v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *Service) SetNetworkConfiguration(v *NetworkConfiguration) *Service {
	s.NetworkConfiguration = v
	return s
}

// SetPendingCount sets the PendingCount field's value.
func (s *Service) SetPendingCount(v int64) *Service {
	s.PendingCount = &v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *Service) SetPlacementConstraints(v []*PlacementConstraint) *Service {
	s.PlacementConstraints = v
	return s
}

// SetPlacementStrategy sets the PlacementStrategy field's value.
func (s *Service) SetPlacementStrategy(v []*PlacementStrategy) *Service {
	s.PlacementStrategy = v
	return s
}

// SetPlatformFamily sets the PlatformFamily field's value.
func (s *Service) SetPlatformFamily(v string) *Service {
	s.PlatformFamily = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *Service) SetPlatformVersion(v string) *Service {
	s.PlatformVersion = &v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *Service) SetPropagateTags(v string) *Service {
	s.PropagateTags = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Service) SetRoleArn(v string) *Service {
	s.RoleArn = &v
	return s
}

// SetRunningCount sets the RunningCount field's value.
func (s *Service) SetRunningCount(v int64) *Service {
	s.RunningCount = &v
	return s
}

// SetSchedulingStrategy sets the SchedulingStrategy field's value.
func (s *Service) SetSchedulingStrategy(v string) *Service {
	s.SchedulingStrategy = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *Service) SetServiceArn(v string) *Service {
	s.ServiceArn = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *Service) SetServiceName(v string) *Service {
	s.ServiceName = &v
	return s
}

// SetServiceRegistries sets the ServiceRegistries field's value.
func (s *Service) SetServiceRegistries(v []*ServiceRegistry) *Service {
	s.ServiceRegistries = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Service) SetStatus(v string) *Service {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Service) SetTags(v []*Tag) *Service {
	s.Tags = v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *Service) SetTaskDefinition(v string) *Service {
	s.TaskDefinition = &v
	return s
}

// SetTaskSets sets the TaskSets field's value.
func (s *Service) SetTaskSets(v []*TaskSet) *Service {
	s.TaskSets = v
	return s
}

// The details for an event that's associated with a service.
type ServiceEvent struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp for the time when the event was triggered.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID string for the event.
	Id *string `locationName:"id" type:"string"`

	// The event message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceEvent) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceEvent) SetCreatedAt(v time.Time) *ServiceEvent {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *ServiceEvent) SetId(v string) *ServiceEvent {
	s.Id = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ServiceEvent) SetMessage(v string) *ServiceEvent {
	s.Message = &v
	return s
}

// The specified service isn't active. You can't update a service that's inactive.
// If you have previously deleted a service, you can re-create it with CreateService.
type ServiceNotActiveException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNotActiveException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNotActiveException) GoString() string {
	return s.String()
}

func newErrorServiceNotActiveException(v protocol.ResponseMetadata) error {
	return &ServiceNotActiveException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceNotActiveException) Code() string {
	return "ServiceNotActiveException"
}

// Message returns the exception's message.
func (s *ServiceNotActiveException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceNotActiveException) OrigErr() error {
	return nil
}

func (s *ServiceNotActiveException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceNotActiveException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceNotActiveException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified service wasn't found. You can view your available services
// with ListServices. Amazon ECS services are cluster specific and Region specific.
type ServiceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNotFoundException) GoString() string {
	return s.String()
}

func newErrorServiceNotFoundException(v protocol.ResponseMetadata) error {
	return &ServiceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceNotFoundException) Code() string {
	return "ServiceNotFoundException"
}

// Message returns the exception's message.
func (s *ServiceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceNotFoundException) OrigErr() error {
	return nil
}

func (s *ServiceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details for the service registry.
//
// Each service may be associated with one service registry. Multiple service
// registries for each service are not supported.
//
// When you add, update, or remove the service registries configuration, Amazon
// ECS starts a new deployment. New tasks are registered and deregistered to
// the updated service registry configuration.
type ServiceRegistry struct {
	_ struct{} `type:"structure"`

	// The container name value to be used for your service discovery service. It's
	// already specified in the task definition. If the task definition that your
	// service task specifies uses the bridge or host network mode, you must specify
	// a containerName and containerPort combination from the task definition. If
	// the task definition that your service task specifies uses the awsvpc network
	// mode and a type SRV DNS record is used, you must specify either a containerName
	// and containerPort combination or a port value. However, you can't specify
	// both.
	ContainerName *string `locationName:"containerName" type:"string"`

	// The port value to be used for your service discovery service. It's already
	// specified in the task definition. If the task definition your service task
	// specifies uses the bridge or host network mode, you must specify a containerName
	// and containerPort combination from the task definition. If the task definition
	// your service task specifies uses the awsvpc network mode and a type SRV DNS
	// record is used, you must specify either a containerName and containerPort
	// combination or a port value. However, you can't specify both.
	ContainerPort *int64 `locationName:"containerPort" type:"integer"`

	// The port value used if your service discovery service specified an SRV record.
	// This field might be used if both the awsvpc network mode and SRV records
	// are used.
	Port *int64 `locationName:"port" type:"integer"`

	// The Amazon Resource Name (ARN) of the service registry. The currently supported
	// service registry is Cloud Map. For more information, see CreateService (https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
	RegistryArn *string `locationName:"registryArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceRegistry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceRegistry) GoString() string {
	return s.String()
}

// SetContainerName sets the ContainerName field's value.
func (s *ServiceRegistry) SetContainerName(v string) *ServiceRegistry {
	s.ContainerName = &v
	return s
}

// SetContainerPort sets the ContainerPort field's value.
func (s *ServiceRegistry) SetContainerPort(v int64) *ServiceRegistry {
	s.ContainerPort = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ServiceRegistry) SetPort(v int64) *ServiceRegistry {
	s.Port = &v
	return s
}

// SetRegistryArn sets the RegistryArn field's value.
func (s *ServiceRegistry) SetRegistryArn(v string) *ServiceRegistry {
	s.RegistryArn = &v
	return s
}

// The details for the execute command session.
type Session struct {
	_ struct{} `type:"structure"`

	// The ID of the execute command session.
	SessionId *string `locationName:"sessionId" type:"string"`

	// A URL to the managed agent on the container that the SSM Session Manager
	// client uses to send commands and receive output from the container.
	StreamUrl *string `locationName:"streamUrl" type:"string"`

	// An encrypted token value containing session and caller information. It's
	// used to authenticate the connection to the container.
	//
	// TokenValue is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Session's
	// String and GoString methods.
	TokenValue *string `locationName:"tokenValue" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Session) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Session) GoString() string {
	return s.String()
}

// SetSessionId sets the SessionId field's value.
func (s *Session) SetSessionId(v string) *Session {
	s.SessionId = &v
	return s
}

// SetStreamUrl sets the StreamUrl field's value.
func (s *Session) SetStreamUrl(v string) *Session {
	s.StreamUrl = &v
	return s
}

// SetTokenValue sets the TokenValue field's value.
func (s *Session) SetTokenValue(v string) *Session {
	s.TokenValue = &v
	return s
}

// The current account setting for a resource.
type Setting struct {
	_ struct{} `type:"structure"`

	// The Amazon ECS resource name.
	Name *string `locationName:"name" type:"string" enum:"SettingName"`

	// The ARN of the principal. It can be an IAM user, IAM role, or the root user.
	// If this field is omitted, the authenticated user is assumed.
	PrincipalArn *string `locationName:"principalArn" type:"string"`

	// Determines whether the account setting is enabled or disabled for the specified
	// resource.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Setting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Setting) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Setting) SetName(v string) *Setting {
	s.Name = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *Setting) SetPrincipalArn(v string) *Setting {
	s.PrincipalArn = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Setting) SetValue(v string) *Setting {
	s.Value = &v
	return s
}

type StartTaskInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster where to
	// start your task. If you do not specify a cluster, the default cluster is
	// assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// The container instance IDs or full ARN entries for the container instances
	// where you would like to place your task. You can specify up to 10 container
	// instances.
	//
	// ContainerInstances is a required field
	ContainerInstances []*string `locationName:"containerInstances" type:"list" required:"true"`

	// Specifies whether to use Amazon ECS managed tags for the task. For more information,
	// see Tagging Your Amazon ECS Resources (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
	// in the Amazon Elastic Container Service Developer Guide.
	EnableECSManagedTags *bool `locationName:"enableECSManagedTags" type:"boolean"`

	// Whether or not the execute command functionality is enabled for the task.
	// If true, this enables execute command functionality on all containers in
	// the task.
	EnableExecuteCommand *bool `locationName:"enableExecuteCommand" type:"boolean"`

	// The name of the task group to associate with the task. The default value
	// is the family name of the task definition (for example, family:my-family-name).
	Group *string `locationName:"group" type:"string"`

	// The VPC subnet and security group configuration for tasks that receive their
	// own elastic network interface by using the awsvpc networking mode.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// A list of container overrides in JSON format that specify the name of a container
	// in the specified task definition and the overrides it receives. You can override
	// the default command for a container (that's specified in the task definition
	// or Docker image) with a command override. You can also override existing
	// environment variables (that are specified in the task definition or Docker
	// image) on a container or add new environment variables to it with an environment
	// override.
	//
	// A total of 8192 characters are allowed for overrides. This limit includes
	// the JSON formatting characters of the override structure.
	Overrides *TaskOverride `locationName:"overrides" type:"structure"`

	// Specifies whether to propagate the tags from the task definition or the service
	// to the task. If no value is specified, the tags aren't propagated.
	PropagateTags *string `locationName:"propagateTags" type:"string" enum:"PropagateTags"`

	// The reference ID to use for the task.
	ReferenceId *string `locationName:"referenceId" type:"string"`

	// An optional tag specified when a task is started. For example, if you automatically
	// trigger a task to run a batch process job, you could apply a unique identifier
	// for that job to your task with the startedBy parameter. You can then identify
	// which tasks belong to that job by filtering the results of a ListTasks call
	// with the startedBy value. Up to 36 letters (uppercase and lowercase), numbers,
	// hyphens (-), and underscores (_) are allowed.
	//
	// If a task is started by an Amazon ECS service, the startedBy parameter contains
	// the deployment ID of the service that starts it.
	StartedBy *string `locationName:"startedBy" type:"string"`

	// The metadata that you apply to the task to help you categorize and organize
	// them. Each tag consists of a key and an optional value, both of which you
	// define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The family and revision (family:revision) or full ARN of the task definition
	// to start. If a revision isn't specified, the latest ACTIVE revision is used.
	//
	// TaskDefinition is a required field
	TaskDefinition *string `locationName:"taskDefinition" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTaskInput"}
	if s.ContainerInstances == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerInstances"))
	}
	if s.TaskDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskDefinition"))
	}
	if s.NetworkConfiguration != nil {
		if err := s.NetworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Overrides != nil {
		if err := s.Overrides.Validate(); err != nil {
			invalidParams.AddNested("Overrides", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *StartTaskInput) SetCluster(v string) *StartTaskInput {
	s.Cluster = &v
	return s
}

// SetContainerInstances sets the ContainerInstances field's value.
func (s *StartTaskInput) SetContainerInstances(v []*string) *StartTaskInput {
	s.ContainerInstances = v
	return s
}

// SetEnableECSManagedTags sets the EnableECSManagedTags field's value.
func (s *StartTaskInput) SetEnableECSManagedTags(v bool) *StartTaskInput {
	s.EnableECSManagedTags = &v
	return s
}

// SetEnableExecuteCommand sets the EnableExecuteCommand field's value.
func (s *StartTaskInput) SetEnableExecuteCommand(v bool) *StartTaskInput {
	s.EnableExecuteCommand = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *StartTaskInput) SetGroup(v string) *StartTaskInput {
	s.Group = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *StartTaskInput) SetNetworkConfiguration(v *NetworkConfiguration) *StartTaskInput {
	s.NetworkConfiguration = v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *StartTaskInput) SetOverrides(v *TaskOverride) *StartTaskInput {
	s.Overrides = v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *StartTaskInput) SetPropagateTags(v string) *StartTaskInput {
	s.PropagateTags = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *StartTaskInput) SetReferenceId(v string) *StartTaskInput {
	s.ReferenceId = &v
	return s
}

// SetStartedBy sets the StartedBy field's value.
func (s *StartTaskInput) SetStartedBy(v string) *StartTaskInput {
	s.StartedBy = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartTaskInput) SetTags(v []*Tag) *StartTaskInput {
	s.Tags = v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *StartTaskInput) SetTaskDefinition(v string) *StartTaskInput {
	s.TaskDefinition = &v
	return s
}

type StartTaskOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*Failure `locationName:"failures" type:"list"`

	// A full description of the tasks that were started. Each task that was successfully
	// placed on your container instances is described.
	Tasks []*Task `locationName:"tasks" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTaskOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *StartTaskOutput) SetFailures(v []*Failure) *StartTaskOutput {
	s.Failures = v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *StartTaskOutput) SetTasks(v []*Task) *StartTaskOutput {
	s.Tasks = v
	return s
}

type StopTaskInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the task to stop. If you do not specify a cluster, the default cluster is
	// assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// An optional message specified when a task is stopped. For example, if you're
	// using a custom scheduler, you can use this parameter to specify the reason
	// for stopping the task here, and the message appears in subsequent DescribeTasks
	// API operations on this task. Up to 255 characters are allowed in this message.
	Reason *string `locationName:"reason" type:"string"`

	// The task ID or full Amazon Resource Name (ARN) of the task to stop.
	//
	// Task is a required field
	Task *string `locationName:"task" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopTaskInput"}
	if s.Task == nil {
		invalidParams.Add(request.NewErrParamRequired("Task"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *StopTaskInput) SetCluster(v string) *StopTaskInput {
	s.Cluster = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *StopTaskInput) SetReason(v string) *StopTaskInput {
	s.Reason = &v
	return s
}

// SetTask sets the Task field's value.
func (s *StopTaskInput) SetTask(v string) *StopTaskInput {
	s.Task = &v
	return s
}

type StopTaskOutput struct {
	_ struct{} `type:"structure"`

	// The task that was stopped.
	Task *Task `locationName:"task" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTaskOutput) GoString() string {
	return s.String()
}

// SetTask sets the Task field's value.
func (s *StopTaskOutput) SetTask(v *Task) *StopTaskOutput {
	s.Task = v
	return s
}

type SubmitAttachmentStateChangesInput struct {
	_ struct{} `type:"structure"`

	// Any attachments associated with the state change request.
	//
	// Attachments is a required field
	Attachments []*AttachmentStateChange `locationName:"attachments" type:"list" required:"true"`

	// The short name or full ARN of the cluster that hosts the container instance
	// the attachment belongs to.
	Cluster *string `locationName:"cluster" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitAttachmentStateChangesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitAttachmentStateChangesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubmitAttachmentStateChangesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubmitAttachmentStateChangesInput"}
	if s.Attachments == nil {
		invalidParams.Add(request.NewErrParamRequired("Attachments"))
	}
	if s.Attachments != nil {
		for i, v := range s.Attachments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attachments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachments sets the Attachments field's value.
func (s *SubmitAttachmentStateChangesInput) SetAttachments(v []*AttachmentStateChange) *SubmitAttachmentStateChangesInput {
	s.Attachments = v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *SubmitAttachmentStateChangesInput) SetCluster(v string) *SubmitAttachmentStateChangesInput {
	s.Cluster = &v
	return s
}

type SubmitAttachmentStateChangesOutput struct {
	_ struct{} `type:"structure"`

	// Acknowledgement of the state change.
	Acknowledgment *string `locationName:"acknowledgment" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitAttachmentStateChangesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitAttachmentStateChangesOutput) GoString() string {
	return s.String()
}

// SetAcknowledgment sets the Acknowledgment field's value.
func (s *SubmitAttachmentStateChangesOutput) SetAcknowledgment(v string) *SubmitAttachmentStateChangesOutput {
	s.Acknowledgment = &v
	return s
}

type SubmitContainerStateChangeInput struct {
	_ struct{} `type:"structure"`

	// The short name or full ARN of the cluster that hosts the container.
	Cluster *string `locationName:"cluster" type:"string"`

	// The name of the container.
	ContainerName *string `locationName:"containerName" type:"string"`

	// The exit code that's returned for the state change request.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The network bindings of the container.
	NetworkBindings []*NetworkBinding `locationName:"networkBindings" type:"list"`

	// The reason for the state change request.
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the Docker container.
	RuntimeId *string `locationName:"runtimeId" type:"string"`

	// The status of the state change request.
	Status *string `locationName:"status" type:"string"`

	// The task ID or full Amazon Resource Name (ARN) of the task that hosts the
	// container.
	Task *string `locationName:"task" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitContainerStateChangeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitContainerStateChangeInput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *SubmitContainerStateChangeInput) SetCluster(v string) *SubmitContainerStateChangeInput {
	s.Cluster = &v
	return s
}

// SetContainerName sets the ContainerName field's value.
func (s *SubmitContainerStateChangeInput) SetContainerName(v string) *SubmitContainerStateChangeInput {
	s.ContainerName = &v
	return s
}

// SetExitCode sets the ExitCode field's value.
func (s *SubmitContainerStateChangeInput) SetExitCode(v int64) *SubmitContainerStateChangeInput {
	s.ExitCode = &v
	return s
}

// SetNetworkBindings sets the NetworkBindings field's value.
func (s *SubmitContainerStateChangeInput) SetNetworkBindings(v []*NetworkBinding) *SubmitContainerStateChangeInput {
	s.NetworkBindings = v
	return s
}

// SetReason sets the Reason field's value.
func (s *SubmitContainerStateChangeInput) SetReason(v string) *SubmitContainerStateChangeInput {
	s.Reason = &v
	return s
}

// SetRuntimeId sets the RuntimeId field's value.
func (s *SubmitContainerStateChangeInput) SetRuntimeId(v string) *SubmitContainerStateChangeInput {
	s.RuntimeId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SubmitContainerStateChangeInput) SetStatus(v string) *SubmitContainerStateChangeInput {
	s.Status = &v
	return s
}

// SetTask sets the Task field's value.
func (s *SubmitContainerStateChangeInput) SetTask(v string) *SubmitContainerStateChangeInput {
	s.Task = &v
	return s
}

type SubmitContainerStateChangeOutput struct {
	_ struct{} `type:"structure"`

	// Acknowledgement of the state change.
	Acknowledgment *string `locationName:"acknowledgment" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitContainerStateChangeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitContainerStateChangeOutput) GoString() string {
	return s.String()
}

// SetAcknowledgment sets the Acknowledgment field's value.
func (s *SubmitContainerStateChangeOutput) SetAcknowledgment(v string) *SubmitContainerStateChangeOutput {
	s.Acknowledgment = &v
	return s
}

type SubmitTaskStateChangeInput struct {
	_ struct{} `type:"structure"`

	// Any attachments associated with the state change request.
	Attachments []*AttachmentStateChange `locationName:"attachments" type:"list"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the task.
	Cluster *string `locationName:"cluster" type:"string"`

	// Any containers that's associated with the state change request.
	Containers []*ContainerStateChange `locationName:"containers" type:"list"`

	// The Unix timestamp for the time when the task execution stopped.
	ExecutionStoppedAt *time.Time `locationName:"executionStoppedAt" type:"timestamp"`

	// The details for the managed agent that's associated with the task.
	ManagedAgents []*ManagedAgentStateChange `locationName:"managedAgents" type:"list"`

	// The Unix timestamp for the time when the container image pull started.
	PullStartedAt *time.Time `locationName:"pullStartedAt" type:"timestamp"`

	// The Unix timestamp for the time when the container image pull completed.
	PullStoppedAt *time.Time `locationName:"pullStoppedAt" type:"timestamp"`

	// The reason for the state change request.
	Reason *string `locationName:"reason" type:"string"`

	// The status of the state change request.
	Status *string `locationName:"status" type:"string"`

	// The task ID or full ARN of the task in the state change request.
	Task *string `locationName:"task" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitTaskStateChangeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitTaskStateChangeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubmitTaskStateChangeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubmitTaskStateChangeInput"}
	if s.Attachments != nil {
		for i, v := range s.Attachments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attachments", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ManagedAgents != nil {
		for i, v := range s.ManagedAgents {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ManagedAgents", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachments sets the Attachments field's value.
func (s *SubmitTaskStateChangeInput) SetAttachments(v []*AttachmentStateChange) *SubmitTaskStateChangeInput {
	s.Attachments = v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *SubmitTaskStateChangeInput) SetCluster(v string) *SubmitTaskStateChangeInput {
	s.Cluster = &v
	return s
}

// SetContainers sets the Containers field's value.
func (s *SubmitTaskStateChangeInput) SetContainers(v []*ContainerStateChange) *SubmitTaskStateChangeInput {
	s.Containers = v
	return s
}

// SetExecutionStoppedAt sets the ExecutionStoppedAt field's value.
func (s *SubmitTaskStateChangeInput) SetExecutionStoppedAt(v time.Time) *SubmitTaskStateChangeInput {
	s.ExecutionStoppedAt = &v
	return s
}

// SetManagedAgents sets the ManagedAgents field's value.
func (s *SubmitTaskStateChangeInput) SetManagedAgents(v []*ManagedAgentStateChange) *SubmitTaskStateChangeInput {
	s.ManagedAgents = v
	return s
}

// SetPullStartedAt sets the PullStartedAt field's value.
func (s *SubmitTaskStateChangeInput) SetPullStartedAt(v time.Time) *SubmitTaskStateChangeInput {
	s.PullStartedAt = &v
	return s
}

// SetPullStoppedAt sets the PullStoppedAt field's value.
func (s *SubmitTaskStateChangeInput) SetPullStoppedAt(v time.Time) *SubmitTaskStateChangeInput {
	s.PullStoppedAt = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *SubmitTaskStateChangeInput) SetReason(v string) *SubmitTaskStateChangeInput {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SubmitTaskStateChangeInput) SetStatus(v string) *SubmitTaskStateChangeInput {
	s.Status = &v
	return s
}

// SetTask sets the Task field's value.
func (s *SubmitTaskStateChangeInput) SetTask(v string) *SubmitTaskStateChangeInput {
	s.Task = &v
	return s
}

type SubmitTaskStateChangeOutput struct {
	_ struct{} `type:"structure"`

	// Acknowledgement of the state change.
	Acknowledgment *string `locationName:"acknowledgment" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitTaskStateChangeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitTaskStateChangeOutput) GoString() string {
	return s.String()
}

// SetAcknowledgment sets the Acknowledgment field's value.
func (s *SubmitTaskStateChangeOutput) SetAcknowledgment(v string) *SubmitTaskStateChangeOutput {
	s.Acknowledgment = &v
	return s
}

// A list of namespaced kernel parameters to set in the container. This parameter
// maps to Sysctls in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
// and the --sysctl option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
//
// We don't recommend that you specify network-related systemControls parameters
// for multiple containers in a single task. This task also uses either the
// awsvpc or host network mode. It does it for the following reasons.
//
//   - For tasks that use the awsvpc network mode, if you set systemControls
//     for any container, it applies to all containers in the task. If you set
//     different systemControls for multiple containers in a single task, the
//     container that's started last determines which systemControls take effect.
//
//   - For tasks that use the host network mode, the systemControls parameter
//     applies to the container instance's kernel parameter and that of all containers
//     of any tasks running on that container instance.
type SystemControl struct {
	_ struct{} `type:"structure"`

	// The namespaced kernel parameter to set a value for.
	Namespace *string `locationName:"namespace" type:"string"`

	// The value for the namespaced kernel parameter that's specified in namespace.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SystemControl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SystemControl) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *SystemControl) SetNamespace(v string) *SystemControl {
	s.Namespace = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SystemControl) SetValue(v string) *SystemControl {
	s.Value = &v
	return s
}

// The metadata that you apply to a resource to help you categorize and organize
// them. Each tag consists of a key and an optional value. You define them.
//
// The following basic restrictions apply to tags:
//
//   - Maximum number of tags per resource - 50
//
//   - For each resource, each tag key must be unique, and each tag key can
//     have only one value.
//
//   - Maximum key length - 128 Unicode characters in UTF-8
//
//   - Maximum value length - 256 Unicode characters in UTF-8
//
//   - If your tagging schema is used across multiple services and resources,
//     remember that other services may have restrictions on allowed characters.
//     Generally allowed characters are: letters, numbers, and spaces representable
//     in UTF-8, and the following characters: + - = . _ : / @.
//
//   - Tag keys and values are case-sensitive.
//
//   - Do not use aws:, AWS:, or any upper or lowercase combination of such
//     as a prefix for either keys or values as it is reserved for Amazon Web
//     Services use. You cannot edit or delete tag keys or values with this prefix.
//     Tags with this prefix do not count against your tags per resource limit.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to add tags to. Currently,
	// the supported resources are Amazon ECS capacity providers, tasks, services,
	// task definitions, clusters, and container instances.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The tags to add to the resource. A tag is an array of key-value pairs.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The execute command cannot run. This error can be caused by any of the following
// configuration issues:
//
//   - Incorrect IAM permissions
//
//   - The SSM agent is not installed or is not running
//
//   - There is an interface Amazon VPC endpoint for Amazon ECS, but there
//     is not one for for Systems Manager Session Manager
//
// For information about how to troubleshoot the issues, see Troubleshooting
// issues with ECS Exec (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html)
// in the Amazon Elastic Container Service Developer Guide.
type TargetNotConnectedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetNotConnectedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetNotConnectedException) GoString() string {
	return s.String()
}

func newErrorTargetNotConnectedException(v protocol.ResponseMetadata) error {
	return &TargetNotConnectedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TargetNotConnectedException) Code() string {
	return "TargetNotConnectedException"
}

// Message returns the exception's message.
func (s *TargetNotConnectedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TargetNotConnectedException) OrigErr() error {
	return nil
}

func (s *TargetNotConnectedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TargetNotConnectedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TargetNotConnectedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified target wasn't found. You can view your available container
// instances with ListContainerInstances. Amazon ECS container instances are
// cluster-specific and Region-specific.
type TargetNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetNotFoundException) GoString() string {
	return s.String()
}

func newErrorTargetNotFoundException(v protocol.ResponseMetadata) error {
	return &TargetNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TargetNotFoundException) Code() string {
	return "TargetNotFoundException"
}

// Message returns the exception's message.
func (s *TargetNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TargetNotFoundException) OrigErr() error {
	return nil
}

func (s *TargetNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TargetNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TargetNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details on a task in a cluster.
type Task struct {
	_ struct{} `type:"structure"`

	// The Elastic Network Adapter that's associated with the task if the task uses
	// the awsvpc network mode.
	Attachments []*Attachment `locationName:"attachments" type:"list"`

	// The attributes of the task
	Attributes []*Attribute `locationName:"attributes" type:"list"`

	// The Availability Zone for the task.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The capacity provider that's associated with the task.
	CapacityProviderName *string `locationName:"capacityProviderName" type:"string"`

	// The ARN of the cluster that hosts the task.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The connectivity status of a task.
	Connectivity *string `locationName:"connectivity" type:"string" enum:"Connectivity"`

	// The Unix timestamp for the time when the task last went into CONNECTED status.
	ConnectivityAt *time.Time `locationName:"connectivityAt" type:"timestamp"`

	// The ARN of the container instances that host the task.
	ContainerInstanceArn *string `locationName:"containerInstanceArn" type:"string"`

	// The containers that's associated with the task.
	Containers []*Container `locationName:"containers" type:"list"`

	// The number of CPU units used by the task as expressed in a task definition.
	// It can be expressed as an integer using CPU units (for example, 1024). It
	// can also be expressed as a string using vCPUs (for example, 1 vCPU or 1 vcpu).
	// String values are converted to an integer that indicates the CPU units when
	// the task definition is registered.
	//
	// If you use the EC2 launch type, this field is optional. Supported values
	// are between 128 CPU units (0.125 vCPUs) and 10240 CPU units (10 vCPUs).
	//
	// If you use the Fargate launch type, this field is required. You must use
	// one of the following values. These values determine the range of supported
	// values for the memory parameter:
	//
	// The CPU units cannot be less than 1 vCPU when you use Windows containers
	// on Fargate.
	//
	//    * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB),
	//    2048 (2 GB)
	//
	//    * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072
	//    (3 GB), 4096 (4 GB)
	//
	//    * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096
	//    (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
	//
	//    * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384
	//    (16 GB) in increments of 1024 (1 GB)
	//
	//    * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720
	//    (30 GB) in increments of 1024 (1 GB)
	Cpu *string `locationName:"cpu" type:"string"`

	// The Unix timestamp for the time when the task was created. More specifically,
	// it's for the time when the task entered the PENDING state.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The desired status of the task. For more information, see Task Lifecycle
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html).
	DesiredStatus *string `locationName:"desiredStatus" type:"string"`

	// Determines whether execute command functionality is enabled for this task.
	// If true, execute command functionality is enabled on all the containers in
	// the task.
	EnableExecuteCommand *bool `locationName:"enableExecuteCommand" type:"boolean"`

	// The ephemeral storage settings for the task.
	EphemeralStorage *EphemeralStorage `locationName:"ephemeralStorage" type:"structure"`

	// The Unix timestamp for the time when the task execution stopped.
	ExecutionStoppedAt *time.Time `locationName:"executionStoppedAt" type:"timestamp"`

	// The name of the task group that's associated with the task.
	Group *string `locationName:"group" type:"string"`

	// The health status for the task. It's determined by the health of the essential
	// containers in the task. If all essential containers in the task are reporting
	// as HEALTHY, the task status also reports as HEALTHY. If any essential containers
	// in the task are reporting as UNHEALTHY or UNKNOWN, the task status also reports
	// as UNHEALTHY or UNKNOWN.
	//
	// The Amazon ECS container agent doesn't monitor or report on Docker health
	// checks that are embedded in a container image and not specified in the container
	// definition. For example, this includes those specified in a parent image
	// or from the image's Dockerfile. Health check parameters that are specified
	// in a container definition override any Docker health checks that are found
	// in the container image.
	HealthStatus *string `locationName:"healthStatus" type:"string" enum:"HealthStatus"`

	// The Elastic Inference accelerator that's associated with the task.
	InferenceAccelerators []*InferenceAccelerator `locationName:"inferenceAccelerators" type:"list"`

	// The last known status for the task. For more information, see Task Lifecycle
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html).
	LastStatus *string `locationName:"lastStatus" type:"string"`

	// The infrastructure where your task runs on. For more information, see Amazon
	// ECS launch types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LaunchType *string `locationName:"launchType" type:"string" enum:"LaunchType"`

	// The amount of memory (in MiB) that the task uses as expressed in a task definition.
	// It can be expressed as an integer using MiB (for example, 1024). If it's
	// expressed as a string using GB (for example, 1GB or 1 GB), it's converted
	// to an integer indicating the MiB when the task definition is registered.
	//
	// If you use the EC2 launch type, this field is optional.
	//
	// If you use the Fargate launch type, this field is required. You must use
	// one of the following values. The value that you choose determines the range
	// of supported values for the cpu parameter.
	//
	//    * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25
	//    vCPU)
	//
	//    * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values:
	//    512 (.5 vCPU)
	//
	//    * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168
	//    (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
	//
	//    * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) -
	//    Available cpu values: 2048 (2 vCPU)
	//
	//    * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) -
	//    Available cpu values: 4096 (4 vCPU)
	Memory *string `locationName:"memory" type:"string"`

	// One or more container overrides.
	Overrides *TaskOverride `locationName:"overrides" type:"structure"`

	// The operating system that your tasks are running on. A platform family is
	// specified only for tasks that use the Fargate launch type.
	//
	// All tasks that run as part of this service must use the same platformFamily
	// value as the service (for example, LINUX.).
	PlatformFamily *string `locationName:"platformFamily" type:"string"`

	// The platform version where your task runs on. A platform version is only
	// specified for tasks that use the Fargate launch type. If you didn't specify
	// one, the LATEST platform version is used. For more information, see Fargate
	// Platform Versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// The Unix timestamp for the time when the container image pull began.
	PullStartedAt *time.Time `locationName:"pullStartedAt" type:"timestamp"`

	// The Unix timestamp for the time when the container image pull completed.
	PullStoppedAt *time.Time `locationName:"pullStoppedAt" type:"timestamp"`

	// The Unix timestamp for the time when the task started. More specifically,
	// it's for the time when the task transitioned from the PENDING state to the
	// RUNNING state.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp"`

	// The tag specified when a task is started. If an Amazon ECS service started
	// the task, the startedBy parameter contains the deployment ID of that service.
	StartedBy *string `locationName:"startedBy" type:"string"`

	// The stop code indicating why a task was stopped. The stoppedReason might
	// contain additional details.
	//
	// The following are valid values:
	//
	//    * TaskFailedToStart
	//
	//    * EssentialContainerExited
	//
	//    * UserInitiated
	//
	//    * TerminationNotice
	//
	//    * ServiceSchedulerInitiated
	//
	//    * SpotInterruption
	StopCode *string `locationName:"stopCode" type:"string" enum:"TaskStopCode"`

	// The Unix timestamp for the time when the task was stopped. More specifically,
	// it's for the time when the task transitioned from the RUNNING state to the
	// STOPPED state.
	StoppedAt *time.Time `locationName:"stoppedAt" type:"timestamp"`

	// The reason that the task was stopped.
	StoppedReason *string `locationName:"stoppedReason" type:"string"`

	// The Unix timestamp for the time when the task stops. More specifically, it's
	// for the time when the task transitions from the RUNNING state to STOPPED.
	StoppingAt *time.Time `locationName:"stoppingAt" type:"timestamp"`

	// The metadata that you apply to the task to help you categorize and organize
	// the task. Each tag consists of a key and an optional value. You define both
	// the key and value.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The Amazon Resource Name (ARN) of the task.
	TaskArn *string `locationName:"taskArn" type:"string"`

	// The ARN of the task definition that creates the task.
	TaskDefinitionArn *string `locationName:"taskDefinitionArn" type:"string"`

	// The version counter for the task. Every time a task experiences a change
	// that starts a CloudWatch event, the version counter is incremented. If you
	// replicate your Amazon ECS task state with CloudWatch Events, you can compare
	// the version of a task reported by the Amazon ECS API actions with the version
	// reported in CloudWatch Events for the task (inside the detail object) to
	// verify that the version in your event stream is current.
	Version *int64 `locationName:"version" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Task) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Task) GoString() string {
	return s.String()
}

// SetAttachments sets the Attachments field's value.
func (s *Task) SetAttachments(v []*Attachment) *Task {
	s.Attachments = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Task) SetAttributes(v []*Attribute) *Task {
	s.Attributes = v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Task) SetAvailabilityZone(v string) *Task {
	s.AvailabilityZone = &v
	return s
}

// SetCapacityProviderName sets the CapacityProviderName field's value.
func (s *Task) SetCapacityProviderName(v string) *Task {
	s.CapacityProviderName = &v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *Task) SetClusterArn(v string) *Task {
	s.ClusterArn = &v
	return s
}

// SetConnectivity sets the Connectivity field's value.
func (s *Task) SetConnectivity(v string) *Task {
	s.Connectivity = &v
	return s
}

// SetConnectivityAt sets the ConnectivityAt field's value.
func (s *Task) SetConnectivityAt(v time.Time) *Task {
	s.ConnectivityAt = &v
	return s
}

// SetContainerInstanceArn sets the ContainerInstanceArn field's value.
func (s *Task) SetContainerInstanceArn(v string) *Task {
	s.ContainerInstanceArn = &v
	return s
}

// SetContainers sets the Containers field's value.
func (s *Task) SetContainers(v []*Container) *Task {
	s.Containers = v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *Task) SetCpu(v string) *Task {
	s.Cpu = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Task) SetCreatedAt(v time.Time) *Task {
	s.CreatedAt = &v
	return s
}

// SetDesiredStatus sets the DesiredStatus field's value.
func (s *Task) SetDesiredStatus(v string) *Task {
	s.DesiredStatus = &v
	return s
}

// SetEnableExecuteCommand sets the EnableExecuteCommand field's value.
func (s *Task) SetEnableExecuteCommand(v bool) *Task {
	s.EnableExecuteCommand = &v
	return s
}

// SetEphemeralStorage sets the EphemeralStorage field's value.
func (s *Task) SetEphemeralStorage(v *EphemeralStorage) *Task {
	s.EphemeralStorage = v
	return s
}

// SetExecutionStoppedAt sets the ExecutionStoppedAt field's value.
func (s *Task) SetExecutionStoppedAt(v time.Time) *Task {
	s.ExecutionStoppedAt = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *Task) SetGroup(v string) *Task {
	s.Group = &v
	return s
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *Task) SetHealthStatus(v string) *Task {
	s.HealthStatus = &v
	return s
}

// SetInferenceAccelerators sets the InferenceAccelerators field's value.
func (s *Task) SetInferenceAccelerators(v []*InferenceAccelerator) *Task {
	s.InferenceAccelerators = v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *Task) SetLastStatus(v string) *Task {
	s.LastStatus = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *Task) SetLaunchType(v string) *Task {
	s.LaunchType = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *Task) SetMemory(v string) *Task {
	s.Memory = &v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *Task) SetOverrides(v *TaskOverride) *Task {
	s.Overrides = v
	return s
}

// SetPlatformFamily sets the PlatformFamily field's value.
func (s *Task) SetPlatformFamily(v string) *Task {
	s.PlatformFamily = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *Task) SetPlatformVersion(v string) *Task {
	s.PlatformVersion = &v
	return s
}

// SetPullStartedAt sets the PullStartedAt field's value.
func (s *Task) SetPullStartedAt(v time.Time) *Task {
	s.PullStartedAt = &v
	return s
}

// SetPullStoppedAt sets the PullStoppedAt field's value.
func (s *Task) SetPullStoppedAt(v time.Time) *Task {
	s.PullStoppedAt = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *Task) SetStartedAt(v time.Time) *Task {
	s.StartedAt = &v
	return s
}

// SetStartedBy sets the StartedBy field's value.
func (s *Task) SetStartedBy(v string) *Task {
	s.StartedBy = &v
	return s
}

// SetStopCode sets the StopCode field's value.
func (s *Task) SetStopCode(v string) *Task {
	s.StopCode = &v
	return s
}

// SetStoppedAt sets the StoppedAt field's value.
func (s *Task) SetStoppedAt(v time.Time) *Task {
	s.StoppedAt = &v
	return s
}

// SetStoppedReason sets the StoppedReason field's value.
func (s *Task) SetStoppedReason(v string) *Task {
	s.StoppedReason = &v
	return s
}

// SetStoppingAt sets the StoppingAt field's value.
func (s *Task) SetStoppingAt(v time.Time) *Task {
	s.StoppingAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Task) SetTags(v []*Tag) *Task {
	s.Tags = v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *Task) SetTaskArn(v string) *Task {
	s.TaskArn = &v
	return s
}

// SetTaskDefinitionArn sets the TaskDefinitionArn field's value.
func (s *Task) SetTaskDefinitionArn(v string) *Task {
	s.TaskDefinitionArn = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Task) SetVersion(v int64) *Task {
	s.Version = &v
	return s
}

// The details of a task definition which describes the container and volume
// definitions of an Amazon Elastic Container Service task. You can specify
// which Docker images to use, the required resources, and other configurations
// related to launching the task definition through an Amazon ECS service or
// task.
type TaskDefinition struct {
	_ struct{} `type:"structure"`

	// The task launch types the task definition validated against during task definition
	// registration. For more information, see Amazon ECS launch types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Compatibilities []*string `locationName:"compatibilities" type:"list" enum:"Compatibility"`

	// A list of container definitions in JSON format that describe the different
	// containers that make up your task. For more information about container definition
	// parameters and defaults, see Amazon ECS Task Definitions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	ContainerDefinitions []*ContainerDefinition `locationName:"containerDefinitions" type:"list"`

	// The number of cpu units used by the task. If you use the EC2 launch type,
	// this field is optional. Any value can be used. If you use the Fargate launch
	// type, this field is required. You must use one of the following values. The
	// value that you choose determines your range of valid values for the memory
	// parameter.
	//
	// The CPU units cannot be less than 1 vCPU when you use Windows containers
	// on Fargate.
	//
	//    * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB),
	//    2048 (2 GB)
	//
	//    * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072
	//    (3 GB), 4096 (4 GB)
	//
	//    * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096
	//    (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
	//
	//    * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384
	//    (16 GB) in increments of 1024 (1 GB)
	//
	//    * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720
	//    (30 GB) in increments of 1024 (1 GB)
	Cpu *string `locationName:"cpu" type:"string"`

	// The Unix timestamp for the time when the task definition was deregistered.
	DeregisteredAt *time.Time `locationName:"deregisteredAt" type:"timestamp"`

	// The ephemeral storage settings to use for tasks run with the task definition.
	EphemeralStorage *EphemeralStorage `locationName:"ephemeralStorage" type:"structure"`

	// The Amazon Resource Name (ARN) of the task execution role that grants the
	// Amazon ECS container agent permission to make Amazon Web Services API calls
	// on your behalf. The task execution IAM role is required depending on the
	// requirements of your task. For more information, see Amazon ECS task execution
	// IAM role (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html)
	// in the Amazon Elastic Container Service Developer Guide.
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string"`

	// The name of a family that this task definition is registered to. Up to 255
	// characters are allowed. Letters (both uppercase and lowercase letters), numbers,
	// hyphens (-), and underscores (_) are allowed.
	//
	// A family groups multiple versions of a task definition. Amazon ECS gives
	// the first task definition that you registered to a family a revision number
	// of 1. Amazon ECS gives sequential revision numbers to each task definition
	// that you add.
	Family *string `locationName:"family" type:"string"`

	// The Elastic Inference accelerator that's associated with the task.
	InferenceAccelerators []*InferenceAccelerator `locationName:"inferenceAccelerators" type:"list"`

	// The IPC resource namespace to use for the containers in the task. The valid
	// values are host, task, or none. If host is specified, then all containers
	// within the tasks that specified the host IPC mode on the same container instance
	// share the same IPC resources with the host Amazon EC2 instance. If task is
	// specified, all containers within the specified task share the same IPC resources.
	// If none is specified, then IPC resources within the containers of a task
	// are private and not shared with other containers in a task or on the container
	// instance. If no value is specified, then the IPC resource namespace sharing
	// depends on the Docker daemon setting on the container instance. For more
	// information, see IPC settings (https://docs.docker.com/engine/reference/run/#ipc-settings---ipc)
	// in the Docker run reference.
	//
	// If the host IPC mode is used, be aware that there is a heightened risk of
	// undesired IPC namespace expose. For more information, see Docker security
	// (https://docs.docker.com/engine/security/security/).
	//
	// If you are setting namespaced kernel parameters using systemControls for
	// the containers in the task, the following will apply to your IPC resource
	// namespace. For more information, see System Controls (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	//    * For tasks that use the host IPC mode, IPC namespace related systemControls
	//    are not supported.
	//
	//    * For tasks that use the task IPC mode, IPC namespace related systemControls
	//    will apply to all containers within a task.
	//
	// This parameter is not supported for Windows containers or tasks run on Fargate.
	IpcMode *string `locationName:"ipcMode" type:"string" enum:"IpcMode"`

	// The amount (in MiB) of memory used by the task.
	//
	// If your tasks runs on Amazon EC2 instances, you must specify either a task-level
	// memory value or a container-level memory value. This field is optional and
	// any value can be used. If a task-level memory value is specified, the container-level
	// memory value is optional. For more information regarding container-level
	// memory and memory reservation, see ContainerDefinition (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html).
	//
	// If your tasks runs on Fargate, this field is required. You must use one of
	// the following values. The value you choose determines your range of valid
	// values for the cpu parameter.
	//
	//    * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25
	//    vCPU)
	//
	//    * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values:
	//    512 (.5 vCPU)
	//
	//    * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168
	//    (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
	//
	//    * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) -
	//    Available cpu values: 2048 (2 vCPU)
	//
	//    * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) -
	//    Available cpu values: 4096 (4 vCPU)
	Memory *string `locationName:"memory" type:"string"`

	// The Docker networking mode to use for the containers in the task. The valid
	// values are none, bridge, awsvpc, and host. If no network mode is specified,
	// the default is bridge.
	//
	// For Amazon ECS tasks on Fargate, the awsvpc network mode is required. For
	// Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used.
	// For Amazon ECS tasks on Amazon EC2 Windows instances, <default> or awsvpc
	// can be used. If the network mode is set to none, you cannot specify port
	// mappings in your container definitions, and the tasks containers do not have
	// external connectivity. The host and awsvpc network modes offer the highest
	// networking performance for containers because they use the EC2 network stack
	// instead of the virtualized network stack provided by the bridge mode.
	//
	// With the host and awsvpc network modes, exposed container ports are mapped
	// directly to the corresponding host port (for the host network mode) or the
	// attached elastic network interface port (for the awsvpc network mode), so
	// you cannot take advantage of dynamic host port mappings.
	//
	// When using the host network mode, you should not run containers using the
	// root user (UID 0). It is considered best practice to use a non-root user.
	//
	// If the network mode is awsvpc, the task is allocated an elastic network interface,
	// and you must specify a NetworkConfiguration value when you create a service
	// or run a task with the task definition. For more information, see Task Networking
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// If the network mode is host, you cannot run multiple instantiations of the
	// same task on a single container instance when port mappings are used.
	//
	// For more information, see Network settings (https://docs.docker.com/engine/reference/run/#network-settings)
	// in the Docker run reference.
	NetworkMode *string `locationName:"networkMode" type:"string" enum:"NetworkMode"`

	// The process namespace to use for the containers in the task. The valid values
	// are host or task. If host is specified, then all containers within the tasks
	// that specified the host PID mode on the same container instance share the
	// same process namespace with the host Amazon EC2 instance. If task is specified,
	// all containers within the specified task share the same process namespace.
	// If no value is specified, the default is a private namespace. For more information,
	// see PID settings (https://docs.docker.com/engine/reference/run/#pid-settings---pid)
	// in the Docker run reference.
	//
	// If the host PID mode is used, be aware that there is a heightened risk of
	// undesired process namespace expose. For more information, see Docker security
	// (https://docs.docker.com/engine/security/security/).
	//
	// This parameter is not supported for Windows containers or tasks run on Fargate.
	PidMode *string `locationName:"pidMode" type:"string" enum:"PidMode"`

	// An array of placement constraint objects to use for tasks.
	//
	// This parameter isn't supported for tasks run on Fargate.
	PlacementConstraints []*TaskDefinitionPlacementConstraint `locationName:"placementConstraints" type:"list"`

	// The configuration details for the App Mesh proxy.
	//
	// Your Amazon ECS container instances require at least version 1.26.0 of the
	// container agent and at least version 1.26.0-1 of the ecs-init package to
	// use a proxy configuration. If your container instances are launched from
	// the Amazon ECS optimized AMI version 20190301 or later, they contain the
	// required versions of the container agent and ecs-init. For more information,
	// see Amazon ECS-optimized Linux AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
	// in the Amazon Elastic Container Service Developer Guide.
	ProxyConfiguration *ProxyConfiguration `locationName:"proxyConfiguration" type:"structure"`

	// The Unix timestamp for the time when the task definition was registered.
	RegisteredAt *time.Time `locationName:"registeredAt" type:"timestamp"`

	// The principal that registered the task definition.
	RegisteredBy *string `locationName:"registeredBy" type:"string"`

	// The container instance attributes required by your task. When an Amazon EC2
	// instance is registered to your cluster, the Amazon ECS container agent assigns
	// some standard attributes to the instance. You can apply custom attributes.
	// These are specified as key-value pairs using the Amazon ECS console or the
	// PutAttributes API. These attributes are used when determining task placement
	// for tasks hosted on Amazon EC2 instances. For more information, see Attributes
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// This parameter isn't supported for tasks run on Fargate.
	RequiresAttributes []*Attribute `locationName:"requiresAttributes" type:"list"`

	// The task launch types the task definition was validated against. To determine
	// which task launch types the task definition is validated for, see the TaskDefinition$compatibilities
	// parameter.
	RequiresCompatibilities []*string `locationName:"requiresCompatibilities" type:"list" enum:"Compatibility"`

	// The revision of the task in a particular family. The revision is a version
	// number of a task definition in a family. When you register a task definition
	// for the first time, the revision is 1. Each time that you register a new
	// revision of a task definition in the same family, the revision value always
	// increases by one. This is even if you deregistered previous revisions in
	// this family.
	Revision *int64 `locationName:"revision" type:"integer"`

	// The operating system that your task definitions are running on. A platform
	// family is specified only for tasks using the Fargate launch type.
	//
	// When you specify a task in a service, this value must match the runtimePlatform
	// value of the service.
	RuntimePlatform *RuntimePlatform `locationName:"runtimePlatform" type:"structure"`

	// The status of the task definition.
	Status *string `locationName:"status" type:"string" enum:"TaskDefinitionStatus"`

	// The full Amazon Resource Name (ARN) of the task definition.
	TaskDefinitionArn *string `locationName:"taskDefinitionArn" type:"string"`

	// The short name or full Amazon Resource Name (ARN) of the Identity and Access
	// Management role that grants containers in the task permission to call Amazon
	// Web Services APIs on your behalf. For more information, see Amazon ECS Task
	// Role (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// IAM roles for tasks on Windows require that the -EnableTaskIAMRole option
	// is set when you launch the Amazon ECS-optimized Windows AMI. Your containers
	// must also run some configuration code to use the feature. For more information,
	// see Windows IAM roles for tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	TaskRoleArn *string `locationName:"taskRoleArn" type:"string"`

	// The list of data volume definitions for the task. For more information, see
	// Using data volumes in tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// The host and sourcePath parameters aren't supported for tasks run on Fargate.
	Volumes []*Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskDefinition) GoString() string {
	return s.String()
}

// SetCompatibilities sets the Compatibilities field's value.
func (s *TaskDefinition) SetCompatibilities(v []*string) *TaskDefinition {
	s.Compatibilities = v
	return s
}

// SetContainerDefinitions sets the ContainerDefinitions field's value.
func (s *TaskDefinition) SetContainerDefinitions(v []*ContainerDefinition) *TaskDefinition {
	s.ContainerDefinitions = v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *TaskDefinition) SetCpu(v string) *TaskDefinition {
	s.Cpu = &v
	return s
}

// SetDeregisteredAt sets the DeregisteredAt field's value.
func (s *TaskDefinition) SetDeregisteredAt(v time.Time) *TaskDefinition {
	s.DeregisteredAt = &v
	return s
}

// SetEphemeralStorage sets the EphemeralStorage field's value.
func (s *TaskDefinition) SetEphemeralStorage(v *EphemeralStorage) *TaskDefinition {
	s.EphemeralStorage = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *TaskDefinition) SetExecutionRoleArn(v string) *TaskDefinition {
	s.ExecutionRoleArn = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *TaskDefinition) SetFamily(v string) *TaskDefinition {
	s.Family = &v
	return s
}

// SetInferenceAccelerators sets the InferenceAccelerators field's value.
func (s *TaskDefinition) SetInferenceAccelerators(v []*InferenceAccelerator) *TaskDefinition {
	s.InferenceAccelerators = v
	return s
}

// SetIpcMode sets the IpcMode field's value.
func (s *TaskDefinition) SetIpcMode(v string) *TaskDefinition {
	s.IpcMode = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *TaskDefinition) SetMemory(v string) *TaskDefinition {
	s.Memory = &v
	return s
}

// SetNetworkMode sets the NetworkMode field's value.
func (s *TaskDefinition) SetNetworkMode(v string) *TaskDefinition {
	s.NetworkMode = &v
	return s
}

// SetPidMode sets the PidMode field's value.
func (s *TaskDefinition) SetPidMode(v string) *TaskDefinition {
	s.PidMode = &v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *TaskDefinition) SetPlacementConstraints(v []*TaskDefinitionPlacementConstraint) *TaskDefinition {
	s.PlacementConstraints = v
	return s
}

// SetProxyConfiguration sets the ProxyConfiguration field's value.
func (s *TaskDefinition) SetProxyConfiguration(v *ProxyConfiguration) *TaskDefinition {
	s.ProxyConfiguration = v
	return s
}

// SetRegisteredAt sets the RegisteredAt field's value.
func (s *TaskDefinition) SetRegisteredAt(v time.Time) *TaskDefinition {
	s.RegisteredAt = &v
	return s
}

// SetRegisteredBy sets the RegisteredBy field's value.
func (s *TaskDefinition) SetRegisteredBy(v string) *TaskDefinition {
	s.RegisteredBy = &v
	return s
}

// SetRequiresAttributes sets the RequiresAttributes field's value.
func (s *TaskDefinition) SetRequiresAttributes(v []*Attribute) *TaskDefinition {
	s.RequiresAttributes = v
	return s
}

// SetRequiresCompatibilities sets the RequiresCompatibilities field's value.
func (s *TaskDefinition) SetRequiresCompatibilities(v []*string) *TaskDefinition {
	s.RequiresCompatibilities = v
	return s
}

// SetRevision sets the Revision field's value.
func (s *TaskDefinition) SetRevision(v int64) *TaskDefinition {
	s.Revision = &v
	return s
}

// SetRuntimePlatform sets the RuntimePlatform field's value.
func (s *TaskDefinition) SetRuntimePlatform(v *RuntimePlatform) *TaskDefinition {
	s.RuntimePlatform = v
	return s
}

// SetStatus sets the Status field's value.
func (s *TaskDefinition) SetStatus(v string) *TaskDefinition {
	s.Status = &v
	return s
}

// SetTaskDefinitionArn sets the TaskDefinitionArn field's value.
func (s *TaskDefinition) SetTaskDefinitionArn(v string) *TaskDefinition {
	s.TaskDefinitionArn = &v
	return s
}

// SetTaskRoleArn sets the TaskRoleArn field's value.
func (s *TaskDefinition) SetTaskRoleArn(v string) *TaskDefinition {
	s.TaskRoleArn = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *TaskDefinition) SetVolumes(v []*Volume) *TaskDefinition {
	s.Volumes = v
	return s
}

// An object representing a constraint on task placement in the task definition.
// For more information, see Task placement constraints (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// Task placement constraints aren't supported for tasks run on Fargate.
type TaskDefinitionPlacementConstraint struct {
	_ struct{} `type:"structure"`

	// A cluster query language expression to apply to the constraint. For more
	// information, see Cluster query language (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Expression *string `locationName:"expression" type:"string"`

	// The type of constraint. The MemberOf constraint restricts selection to be
	// from a group of valid candidates.
	Type *string `locationName:"type" type:"string" enum:"TaskDefinitionPlacementConstraintType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskDefinitionPlacementConstraint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskDefinitionPlacementConstraint) GoString() string {
	return s.String()
}

// SetExpression sets the Expression field's value.
func (s *TaskDefinitionPlacementConstraint) SetExpression(v string) *TaskDefinitionPlacementConstraint {
	s.Expression = &v
	return s
}

// SetType sets the Type field's value.
func (s *TaskDefinitionPlacementConstraint) SetType(v string) *TaskDefinitionPlacementConstraint {
	s.Type = &v
	return s
}

// The overrides that are associated with a task.
type TaskOverride struct {
	_ struct{} `type:"structure"`

	// One or more container overrides that are sent to a task.
	ContainerOverrides []*ContainerOverride `locationName:"containerOverrides" type:"list"`

	// The cpu override for the task.
	Cpu *string `locationName:"cpu" type:"string"`

	// The ephemeral storage setting override for the task.
	//
	// This parameter is only supported for tasks hosted on Fargate that use the
	// following platform versions:
	//
	//    * Linux platform version 1.4.0 or later.
	//
	//    * Windows platform version 1.0.0 or later.
	EphemeralStorage *EphemeralStorage `locationName:"ephemeralStorage" type:"structure"`

	// The Amazon Resource Name (ARN) of the task execution IAM role override for
	// the task. For more information, see Amazon ECS task execution IAM role (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html)
	// in the Amazon Elastic Container Service Developer Guide.
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string"`

	// The Elastic Inference accelerator override for the task.
	InferenceAcceleratorOverrides []*InferenceAcceleratorOverride `locationName:"inferenceAcceleratorOverrides" type:"list"`

	// The memory override for the task.
	Memory *string `locationName:"memory" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that containers in this task
	// can assume. All containers in this task are granted the permissions that
	// are specified in this role. For more information, see IAM Role for Tasks
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	TaskRoleArn *string `locationName:"taskRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaskOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TaskOverride"}
	if s.ContainerOverrides != nil {
		for i, v := range s.ContainerOverrides {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContainerOverrides", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EphemeralStorage != nil {
		if err := s.EphemeralStorage.Validate(); err != nil {
			invalidParams.AddNested("EphemeralStorage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerOverrides sets the ContainerOverrides field's value.
func (s *TaskOverride) SetContainerOverrides(v []*ContainerOverride) *TaskOverride {
	s.ContainerOverrides = v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *TaskOverride) SetCpu(v string) *TaskOverride {
	s.Cpu = &v
	return s
}

// SetEphemeralStorage sets the EphemeralStorage field's value.
func (s *TaskOverride) SetEphemeralStorage(v *EphemeralStorage) *TaskOverride {
	s.EphemeralStorage = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *TaskOverride) SetExecutionRoleArn(v string) *TaskOverride {
	s.ExecutionRoleArn = &v
	return s
}

// SetInferenceAcceleratorOverrides sets the InferenceAcceleratorOverrides field's value.
func (s *TaskOverride) SetInferenceAcceleratorOverrides(v []*InferenceAcceleratorOverride) *TaskOverride {
	s.InferenceAcceleratorOverrides = v
	return s
}

// SetMemory sets the Memory field's value.
func (s *TaskOverride) SetMemory(v string) *TaskOverride {
	s.Memory = &v
	return s
}

// SetTaskRoleArn sets the TaskRoleArn field's value.
func (s *TaskOverride) SetTaskRoleArn(v string) *TaskOverride {
	s.TaskRoleArn = &v
	return s
}

// Information about a set of Amazon ECS tasks in either an CodeDeploy or an
// EXTERNAL deployment. An Amazon ECS task set includes details such as the
// desired number of tasks, how many tasks are running, and whether the task
// set serves production traffic.
type TaskSet struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy that are associated with the task set.
	CapacityProviderStrategy []*CapacityProviderStrategyItem `locationName:"capacityProviderStrategy" type:"list"`

	// The Amazon Resource Name (ARN) of the cluster that the service that hosts
	// the task set exists in.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The computed desired count for the task set. This is calculated by multiplying
	// the service's desiredCount by the task set's scale percentage. The result
	// is always rounded up. For example, if the computed desired count is 1.2,
	// it rounds up to 2 tasks.
	ComputedDesiredCount *int64 `locationName:"computedDesiredCount" type:"integer"`

	// The Unix timestamp for the time when the task set was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The external ID associated with the task set.
	//
	// If an CodeDeploy deployment created a task set, the externalId parameter
	// contains the CodeDeploy deployment ID.
	//
	// If a task set is created for an external deployment and is associated with
	// a service discovery registry, the externalId parameter contains the ECS_TASK_SET_EXTERNAL_ID
	// Cloud Map attribute.
	ExternalId *string `locationName:"externalId" type:"string"`

	// The ID of the task set.
	Id *string `locationName:"id" type:"string"`

	// The launch type the tasks in the task set are using. For more information,
	// see Amazon ECS launch types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LaunchType *string `locationName:"launchType" type:"string" enum:"LaunchType"`

	// Details on a load balancer that are used with a task set.
	LoadBalancers []*LoadBalancer `locationName:"loadBalancers" type:"list"`

	// The network configuration for the task set.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The number of tasks in the task set that are in the PENDING status during
	// a deployment. A task in the PENDING state is preparing to enter the RUNNING
	// state. A task set enters the PENDING status when it launches for the first
	// time or when it's restarted after being in the STOPPED state.
	PendingCount *int64 `locationName:"pendingCount" type:"integer"`

	// The operating system that your tasks in the set are running on. A platform
	// family is specified only for tasks that use the Fargate launch type.
	//
	// All tasks in the set must have the same value.
	PlatformFamily *string `locationName:"platformFamily" type:"string"`

	// The Fargate platform version where the tasks in the task set are running.
	// A platform version is only specified for tasks run on Fargate. For more information,
	// see Fargate platform versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// The number of tasks in the task set that are in the RUNNING status during
	// a deployment. A task in the RUNNING state is running and ready for use.
	RunningCount *int64 `locationName:"runningCount" type:"integer"`

	// A floating-point percentage of your desired number of tasks to place and
	// keep running in the task set.
	Scale *Scale `locationName:"scale" type:"structure"`

	// The Amazon Resource Name (ARN) of the service the task set exists in.
	ServiceArn *string `locationName:"serviceArn" type:"string"`

	// The details for the service discovery registries to assign to this task set.
	// For more information, see Service discovery (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
	ServiceRegistries []*ServiceRegistry `locationName:"serviceRegistries" type:"list"`

	// The stability status. This indicates whether the task set has reached a steady
	// state. If the following conditions are met, the task set sre in STEADY_STATE:
	//
	//    * The task runningCount is equal to the computedDesiredCount.
	//
	//    * The pendingCount is 0.
	//
	//    * There are no tasks that are running on container instances in the DRAINING
	//    status.
	//
	//    * All tasks are reporting a healthy status from the load balancers, service
	//    discovery, and container health checks.
	//
	// If any of those conditions aren't met, the stability status returns STABILIZING.
	StabilityStatus *string `locationName:"stabilityStatus" type:"string" enum:"StabilityStatus"`

	// The Unix timestamp for the time when the task set stability status was retrieved.
	StabilityStatusAt *time.Time `locationName:"stabilityStatusAt" type:"timestamp"`

	// The tag specified when a task set is started. If an CodeDeploy deployment
	// created the task set, the startedBy parameter is CODE_DEPLOY. If an external
	// deployment created the task set, the startedBy field isn't used.
	StartedBy *string `locationName:"startedBy" type:"string"`

	// The status of the task set. The following describes each state.
	//
	// PRIMARY
	//
	// The task set is serving production traffic.
	//
	// ACTIVE
	//
	// The task set isn't serving production traffic.
	//
	// DRAINING
	//
	// The tasks in the task set are being stopped, and their corresponding targets
	// are being deregistered from their target group.
	Status *string `locationName:"status" type:"string"`

	// The metadata that you apply to the task set to help you categorize and organize
	// them. Each tag consists of a key and an optional value. You define both.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The task definition that the task set is using.
	TaskDefinition *string `locationName:"taskDefinition" type:"string"`

	// The Amazon Resource Name (ARN) of the task set.
	TaskSetArn *string `locationName:"taskSetArn" type:"string"`

	// The Unix timestamp for the time when the task set was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskSet) GoString() string {
	return s.String()
}

// SetCapacityProviderStrategy sets the CapacityProviderStrategy field's value.
func (s *TaskSet) SetCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *TaskSet {
	s.CapacityProviderStrategy = v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *TaskSet) SetClusterArn(v string) *TaskSet {
	s.ClusterArn = &v
	return s
}

// SetComputedDesiredCount sets the ComputedDesiredCount field's value.
func (s *TaskSet) SetComputedDesiredCount(v int64) *TaskSet {
	s.ComputedDesiredCount = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *TaskSet) SetCreatedAt(v time.Time) *TaskSet {
	s.CreatedAt = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *TaskSet) SetExternalId(v string) *TaskSet {
	s.ExternalId = &v
	return s
}

// SetId sets the Id field's value.
func (s *TaskSet) SetId(v string) *TaskSet {
	s.Id = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *TaskSet) SetLaunchType(v string) *TaskSet {
	s.LaunchType = &v
	return s
}

// SetLoadBalancers sets the LoadBalancers field's value.
func (s *TaskSet) SetLoadBalancers(v []*LoadBalancer) *TaskSet {
	s.LoadBalancers = v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *TaskSet) SetNetworkConfiguration(v *NetworkConfiguration) *TaskSet {
	s.NetworkConfiguration = v
	return s
}

// SetPendingCount sets the PendingCount field's value.
func (s *TaskSet) SetPendingCount(v int64) *TaskSet {
	s.PendingCount = &v
	return s
}

// SetPlatformFamily sets the PlatformFamily field's value.
func (s *TaskSet) SetPlatformFamily(v string) *TaskSet {
	s.PlatformFamily = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *TaskSet) SetPlatformVersion(v string) *TaskSet {
	s.PlatformVersion = &v
	return s
}

// SetRunningCount sets the RunningCount field's value.
func (s *TaskSet) SetRunningCount(v int64) *TaskSet {
	s.RunningCount = &v
	return s
}

// SetScale sets the Scale field's value.
func (s *TaskSet) SetScale(v *Scale) *TaskSet {
	s.Scale = v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *TaskSet) SetServiceArn(v string) *TaskSet {
	s.ServiceArn = &v
	return s
}

// SetServiceRegistries sets the ServiceRegistries field's value.
func (s *TaskSet) SetServiceRegistries(v []*ServiceRegistry) *TaskSet {
	s.ServiceRegistries = v
	return s
}

// SetStabilityStatus sets the StabilityStatus field's value.
func (s *TaskSet) SetStabilityStatus(v string) *TaskSet {
	s.StabilityStatus = &v
	return s
}

// SetStabilityStatusAt sets the StabilityStatusAt field's value.
func (s *TaskSet) SetStabilityStatusAt(v time.Time) *TaskSet {
	s.StabilityStatusAt = &v
	return s
}

// SetStartedBy sets the StartedBy field's value.
func (s *TaskSet) SetStartedBy(v string) *TaskSet {
	s.StartedBy = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TaskSet) SetStatus(v string) *TaskSet {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TaskSet) SetTags(v []*Tag) *TaskSet {
	s.Tags = v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *TaskSet) SetTaskDefinition(v string) *TaskSet {
	s.TaskDefinition = &v
	return s
}

// SetTaskSetArn sets the TaskSetArn field's value.
func (s *TaskSet) SetTaskSetArn(v string) *TaskSet {
	s.TaskSetArn = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *TaskSet) SetUpdatedAt(v time.Time) *TaskSet {
	s.UpdatedAt = &v
	return s
}

// The specified task set wasn't found. You can view your available task sets
// with DescribeTaskSets. Task sets are specific to each cluster, service and
// Region.
type TaskSetNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskSetNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskSetNotFoundException) GoString() string {
	return s.String()
}

func newErrorTaskSetNotFoundException(v protocol.ResponseMetadata) error {
	return &TaskSetNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TaskSetNotFoundException) Code() string {
	return "TaskSetNotFoundException"
}

// Message returns the exception's message.
func (s *TaskSetNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TaskSetNotFoundException) OrigErr() error {
	return nil
}

func (s *TaskSetNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TaskSetNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TaskSetNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The container path, mount options, and size of the tmpfs mount.
type Tmpfs struct {
	_ struct{} `type:"structure"`

	// The absolute file path where the tmpfs volume is to be mounted.
	//
	// ContainerPath is a required field
	ContainerPath *string `locationName:"containerPath" type:"string" required:"true"`

	// The list of tmpfs volume mount options.
	//
	// Valid values: "defaults" | "ro" | "rw" | "suid" | "nosuid" | "dev" | "nodev"
	// | "exec" | "noexec" | "sync" | "async" | "dirsync" | "remount" | "mand" |
	// "nomand" | "atime" | "noatime" | "diratime" | "nodiratime" | "bind" | "rbind"
	// | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared"
	// | "slave" | "rslave" | "relatime" | "norelatime" | "strictatime" | "nostrictatime"
	// | "mode" | "uid" | "gid" | "nr_inodes" | "nr_blocks" | "mpol"
	MountOptions []*string `locationName:"mountOptions" type:"list"`

	// The maximum size (in MiB) of the tmpfs volume.
	//
	// Size is a required field
	Size *int64 `locationName:"size" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tmpfs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tmpfs) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tmpfs) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tmpfs"}
	if s.ContainerPath == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerPath"))
	}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerPath sets the ContainerPath field's value.
func (s *Tmpfs) SetContainerPath(v string) *Tmpfs {
	s.ContainerPath = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *Tmpfs) SetMountOptions(v []*string) *Tmpfs {
	s.MountOptions = v
	return s
}

// SetSize sets the Size field's value.
func (s *Tmpfs) SetSize(v int64) *Tmpfs {
	s.Size = &v
	return s
}

// The ulimit settings to pass to the container.
//
// Amazon ECS tasks hosted on Fargate use the default resource limit values
// set by the operating system with the exception of the nofile resource limit
// parameter which Fargate overrides. The nofile resource limit sets a restriction
// on the number of open files that a container can use. The default nofile
// soft limit is 1024 and hard limit is 4096.
type Ulimit struct {
	_ struct{} `type:"structure"`

	// The hard limit for the ulimit type.
	//
	// HardLimit is a required field
	HardLimit *int64 `locationName:"hardLimit" type:"integer" required:"true"`

	// The type of the ulimit.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"UlimitName"`

	// The soft limit for the ulimit type.
	//
	// SoftLimit is a required field
	SoftLimit *int64 `locationName:"softLimit" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ulimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ulimit) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ulimit) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ulimit"}
	if s.HardLimit == nil {
		invalidParams.Add(request.NewErrParamRequired("HardLimit"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SoftLimit == nil {
		invalidParams.Add(request.NewErrParamRequired("SoftLimit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHardLimit sets the HardLimit field's value.
func (s *Ulimit) SetHardLimit(v int64) *Ulimit {
	s.HardLimit = &v
	return s
}

// SetName sets the Name field's value.
func (s *Ulimit) SetName(v string) *Ulimit {
	s.Name = &v
	return s
}

// SetSoftLimit sets the SoftLimit field's value.
func (s *Ulimit) SetSoftLimit(v int64) *Ulimit {
	s.SoftLimit = &v
	return s
}

// The specified task isn't supported in this Region.
type UnsupportedFeatureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedFeatureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedFeatureException) GoString() string {
	return s.String()
}

func newErrorUnsupportedFeatureException(v protocol.ResponseMetadata) error {
	return &UnsupportedFeatureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedFeatureException) Code() string {
	return "UnsupportedFeatureException"
}

// Message returns the exception's message.
func (s *UnsupportedFeatureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedFeatureException) OrigErr() error {
	return nil
}

func (s *UnsupportedFeatureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedFeatureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedFeatureException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to delete tags from. Currently,
	// the supported resources are Amazon ECS capacity providers, tasks, services,
	// task definitions, clusters, and container instances.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The keys of the tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCapacityProviderInput struct {
	_ struct{} `type:"structure"`

	// An object that represent the parameters to update for the Auto Scaling group
	// capacity provider.
	//
	// AutoScalingGroupProvider is a required field
	AutoScalingGroupProvider *AutoScalingGroupProviderUpdate `locationName:"autoScalingGroupProvider" type:"structure" required:"true"`

	// The name of the capacity provider to update.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCapacityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCapacityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCapacityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCapacityProviderInput"}
	if s.AutoScalingGroupProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupProvider"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.AutoScalingGroupProvider != nil {
		if err := s.AutoScalingGroupProvider.Validate(); err != nil {
			invalidParams.AddNested("AutoScalingGroupProvider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupProvider sets the AutoScalingGroupProvider field's value.
func (s *UpdateCapacityProviderInput) SetAutoScalingGroupProvider(v *AutoScalingGroupProviderUpdate) *UpdateCapacityProviderInput {
	s.AutoScalingGroupProvider = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCapacityProviderInput) SetName(v string) *UpdateCapacityProviderInput {
	s.Name = &v
	return s
}

type UpdateCapacityProviderOutput struct {
	_ struct{} `type:"structure"`

	// Details about the capacity provider.
	CapacityProvider *CapacityProvider `locationName:"capacityProvider" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCapacityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCapacityProviderOutput) GoString() string {
	return s.String()
}

// SetCapacityProvider sets the CapacityProvider field's value.
func (s *UpdateCapacityProviderOutput) SetCapacityProvider(v *CapacityProvider) *UpdateCapacityProviderOutput {
	s.CapacityProvider = v
	return s
}

type UpdateClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster to modify the settings for.
	//
	// Cluster is a required field
	Cluster *string `locationName:"cluster" type:"string" required:"true"`

	// The execute command configuration for the cluster.
	Configuration *ClusterConfiguration `locationName:"configuration" type:"structure"`

	// The cluster settings for your cluster.
	Settings []*ClusterSetting `locationName:"settings" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterInput"}
	if s.Cluster == nil {
		invalidParams.Add(request.NewErrParamRequired("Cluster"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *UpdateClusterInput) SetCluster(v string) *UpdateClusterInput {
	s.Cluster = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateClusterInput) SetConfiguration(v *ClusterConfiguration) *UpdateClusterInput {
	s.Configuration = v
	return s
}

// SetSettings sets the Settings field's value.
func (s *UpdateClusterInput) SetSettings(v []*ClusterSetting) *UpdateClusterInput {
	s.Settings = v
	return s
}

type UpdateClusterOutput struct {
	_ struct{} `type:"structure"`

	// Details about the cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *UpdateClusterOutput) SetCluster(v *Cluster) *UpdateClusterOutput {
	s.Cluster = v
	return s
}

type UpdateClusterSettingsInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster to modify the settings for.
	//
	// Cluster is a required field
	Cluster *string `locationName:"cluster" type:"string" required:"true"`

	// The setting to use by default for a cluster. This parameter is used to turn
	// on CloudWatch Container Insights for a cluster. If this value is specified,
	// it overrides the containerInsights value set with PutAccountSetting or PutAccountSettingDefault.
	//
	// Settings is a required field
	Settings []*ClusterSetting `locationName:"settings" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterSettingsInput"}
	if s.Cluster == nil {
		invalidParams.Add(request.NewErrParamRequired("Cluster"))
	}
	if s.Settings == nil {
		invalidParams.Add(request.NewErrParamRequired("Settings"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *UpdateClusterSettingsInput) SetCluster(v string) *UpdateClusterSettingsInput {
	s.Cluster = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *UpdateClusterSettingsInput) SetSettings(v []*ClusterSetting) *UpdateClusterSettingsInput {
	s.Settings = v
	return s
}

type UpdateClusterSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Details about the cluster
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterSettingsOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *UpdateClusterSettingsOutput) SetCluster(v *Cluster) *UpdateClusterSettingsOutput {
	s.Cluster = v
	return s
}

type UpdateContainerAgentInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that your
	// container instance is running on. If you do not specify a cluster, the default
	// cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// The container instance ID or full ARN entries for the container instance
	// where you would like to update the Amazon ECS container agent.
	//
	// ContainerInstance is a required field
	ContainerInstance *string `locationName:"containerInstance" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContainerAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContainerAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContainerAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContainerAgentInput"}
	if s.ContainerInstance == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerInstance"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *UpdateContainerAgentInput) SetCluster(v string) *UpdateContainerAgentInput {
	s.Cluster = &v
	return s
}

// SetContainerInstance sets the ContainerInstance field's value.
func (s *UpdateContainerAgentInput) SetContainerInstance(v string) *UpdateContainerAgentInput {
	s.ContainerInstance = &v
	return s
}

type UpdateContainerAgentOutput struct {
	_ struct{} `type:"structure"`

	// The container instance that the container agent was updated for.
	ContainerInstance *ContainerInstance `locationName:"containerInstance" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContainerAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContainerAgentOutput) GoString() string {
	return s.String()
}

// SetContainerInstance sets the ContainerInstance field's value.
func (s *UpdateContainerAgentOutput) SetContainerInstance(v *ContainerInstance) *UpdateContainerAgentOutput {
	s.ContainerInstance = v
	return s
}

type UpdateContainerInstancesStateInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the container instance to update. If you do not specify a cluster, the default
	// cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// A list of up to 10 container instance IDs or full ARN entries.
	//
	// ContainerInstances is a required field
	ContainerInstances []*string `locationName:"containerInstances" type:"list" required:"true"`

	// The container instance state to update the container instance with. The only
	// valid values for this action are ACTIVE and DRAINING. A container instance
	// can only be updated to DRAINING status once it has reached an ACTIVE state.
	// If a container instance is in REGISTERING, DEREGISTERING, or REGISTRATION_FAILED
	// state you can describe the container instance but can't update the container
	// instance state.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ContainerInstanceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContainerInstancesStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContainerInstancesStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContainerInstancesStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContainerInstancesStateInput"}
	if s.ContainerInstances == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerInstances"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *UpdateContainerInstancesStateInput) SetCluster(v string) *UpdateContainerInstancesStateInput {
	s.Cluster = &v
	return s
}

// SetContainerInstances sets the ContainerInstances field's value.
func (s *UpdateContainerInstancesStateInput) SetContainerInstances(v []*string) *UpdateContainerInstancesStateInput {
	s.ContainerInstances = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateContainerInstancesStateInput) SetStatus(v string) *UpdateContainerInstancesStateInput {
	s.Status = &v
	return s
}

type UpdateContainerInstancesStateOutput struct {
	_ struct{} `type:"structure"`

	// The list of container instances.
	ContainerInstances []*ContainerInstance `locationName:"containerInstances" type:"list"`

	// Any failures associated with the call.
	Failures []*Failure `locationName:"failures" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContainerInstancesStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContainerInstancesStateOutput) GoString() string {
	return s.String()
}

// SetContainerInstances sets the ContainerInstances field's value.
func (s *UpdateContainerInstancesStateOutput) SetContainerInstances(v []*ContainerInstance) *UpdateContainerInstancesStateOutput {
	s.ContainerInstances = v
	return s
}

// SetFailures sets the Failures field's value.
func (s *UpdateContainerInstancesStateOutput) SetFailures(v []*Failure) *UpdateContainerInstancesStateOutput {
	s.Failures = v
	return s
}

// There's already a current Amazon ECS container agent update in progress on
// the container instance that's specified. If the container agent becomes disconnected
// while it's in a transitional stage, such as PENDING or STAGING, the update
// process can get stuck in that state. However, when the agent reconnects,
// it resumes where it stopped previously.
type UpdateInProgressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInProgressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInProgressException) GoString() string {
	return s.String()
}

func newErrorUpdateInProgressException(v protocol.ResponseMetadata) error {
	return &UpdateInProgressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UpdateInProgressException) Code() string {
	return "UpdateInProgressException"
}

// Message returns the exception's message.
func (s *UpdateInProgressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UpdateInProgressException) OrigErr() error {
	return nil
}

func (s *UpdateInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UpdateInProgressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UpdateInProgressException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateServiceInput struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy to update the service to use.
	//
	// if the service uses the default capacity provider strategy for the cluster,
	// the service can be updated to use one or more capacity providers as opposed
	// to the default capacity provider strategy. However, when a service is using
	// a capacity provider strategy that's not the default capacity provider strategy,
	// the service can't be updated to use the cluster's default capacity provider
	// strategy.
	//
	// A capacity provider strategy consists of one or more capacity providers along
	// with the base and weight to assign to them. A capacity provider must be associated
	// with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders
	// API is used to associate a capacity provider with a cluster. Only capacity
	// providers with an ACTIVE or UPDATING status can be used.
	//
	// If specifying a capacity provider that uses an Auto Scaling group, the capacity
	// provider must already be created. New capacity providers can be created with
	// the CreateCapacityProvider API operation.
	//
	// To use a Fargate capacity provider, specify either the FARGATE or FARGATE_SPOT
	// capacity providers. The Fargate capacity providers are available to all accounts
	// and only need to be associated with a cluster to be used.
	//
	// The PutClusterCapacityProviders API operation is used to update the list
	// of available capacity providers for a cluster after the cluster is created.
	CapacityProviderStrategy []*CapacityProviderStrategyItem `locationName:"capacityProviderStrategy" type:"list"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that your
	// service runs on. If you do not specify a cluster, the default cluster is
	// assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// Optional deployment parameters that control how many tasks run during the
	// deployment and the ordering of stopping and starting tasks.
	DeploymentConfiguration *DeploymentConfiguration `locationName:"deploymentConfiguration" type:"structure"`

	// The number of instantiations of the task to place and keep running in your
	// service.
	DesiredCount *int64 `locationName:"desiredCount" type:"integer"`

	// Determines whether to turn on Amazon ECS managed tags for the tasks in the
	// service. For more information, see Tagging Your Amazon ECS Resources (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// Only tasks launched after the update will reflect the update. To update the
	// tags on all tasks, set forceNewDeployment to true, so that Amazon ECS starts
	// new tasks with the updated tags.
	EnableECSManagedTags *bool `locationName:"enableECSManagedTags" type:"boolean"`

	// If true, this enables execute command functionality on all task containers.
	//
	// If you do not want to override the value that was set when the service was
	// created, you can set this to null when performing this action.
	EnableExecuteCommand *bool `locationName:"enableExecuteCommand" type:"boolean"`

	// Determines whether to force a new deployment of the service. By default,
	// deployments aren't forced. You can use this option to start a new deployment
	// with no service definition changes. For example, you can update a service's
	// tasks to use a newer Docker image with the same image/tag combination (my_image:latest)
	// or to roll Fargate tasks onto a newer platform version.
	ForceNewDeployment *bool `locationName:"forceNewDeployment" type:"boolean"`

	// The period of time, in seconds, that the Amazon ECS service scheduler ignores
	// unhealthy Elastic Load Balancing target health checks after a task has first
	// started. This is only valid if your service is configured to use a load balancer.
	// If your service's tasks take a while to start and respond to Elastic Load
	// Balancing health checks, you can specify a health check grace period of up
	// to 2,147,483,647 seconds. During that time, the Amazon ECS service scheduler
	// ignores the Elastic Load Balancing health check status. This grace period
	// can prevent the ECS service scheduler from marking tasks as unhealthy and
	// stopping them before they have time to come up.
	HealthCheckGracePeriodSeconds *int64 `locationName:"healthCheckGracePeriodSeconds" type:"integer"`

	// A list of Elastic Load Balancing load balancer objects. It contains the load
	// balancer name, the container name, and the container port to access from
	// the load balancer. The container name is as it appears in a container definition.
	//
	// When you add, update, or remove a load balancer configuration, Amazon ECS
	// starts new tasks with the updated Elastic Load Balancing configuration, and
	// then stops the old tasks when the new tasks are running.
	//
	// For services that use rolling updates, you can add, update, or remove Elastic
	// Load Balancing target groups. You can update from a single target group to
	// multiple target groups and from multiple target groups to a single target
	// group.
	//
	// For services that use blue/green deployments, you can update Elastic Load
	// Balancing target groups by using CreateDeployment (https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html)
	// through CodeDeploy. Note that multiple target groups are not supported for
	// blue/green deployments. For more information see Register multiple target
	// groups with a service (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// For services that use the external deployment controller, you can add, update,
	// or remove load balancers by using CreateTaskSet (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html).
	// Note that multiple target groups are not supported for external deployments.
	// For more information see Register multiple target groups with a service (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// You can remove existing loadBalancers by passing an empty list.
	LoadBalancers []*LoadBalancer `locationName:"loadBalancers" type:"list"`

	// An object representing the network configuration for the service.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// An array of task placement constraint objects to update the service to use.
	// If no value is specified, the existing placement constraints for the service
	// will remain unchanged. If this value is specified, it will override any existing
	// placement constraints defined for the service. To remove all existing placement
	// constraints, specify an empty array.
	//
	// You can specify a maximum of 10 constraints for each task. This limit includes
	// constraints in the task definition and those specified at runtime.
	PlacementConstraints []*PlacementConstraint `locationName:"placementConstraints" type:"list"`

	// The task placement strategy objects to update the service to use. If no value
	// is specified, the existing placement strategy for the service will remain
	// unchanged. If this value is specified, it will override the existing placement
	// strategy defined for the service. To remove an existing placement strategy,
	// specify an empty object.
	//
	// You can specify a maximum of five strategy rules for each service.
	PlacementStrategy []*PlacementStrategy `locationName:"placementStrategy" type:"list"`

	// The platform version that your tasks in the service run on. A platform version
	// is only specified for tasks using the Fargate launch type. If a platform
	// version is not specified, the LATEST platform version is used. For more information,
	// see Fargate Platform Versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// Determines whether to propagate the tags from the task definition or the
	// service to the task. If no value is specified, the tags aren't propagated.
	//
	// Only tasks launched after the update will reflect the update. To update the
	// tags on all tasks, set forceNewDeployment to true, so that Amazon ECS starts
	// new tasks with the updated tags.
	PropagateTags *string `locationName:"propagateTags" type:"string" enum:"PropagateTags"`

	// The name of the service to update.
	//
	// Service is a required field
	Service *string `locationName:"service" type:"string" required:"true"`

	// The details for the service discovery registries to assign to this service.
	// For more information, see Service Discovery (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
	//
	// When you add, update, or remove the service registries configuration, Amazon
	// ECS starts new tasks with the updated service registries configuration, and
	// then stops the old tasks when the new tasks are running.
	//
	// You can remove existing serviceRegistries by passing an empty list.
	ServiceRegistries []*ServiceRegistry `locationName:"serviceRegistries" type:"list"`

	// The family and revision (family:revision) or full ARN of the task definition
	// to run in your service. If a revision is not specified, the latest ACTIVE
	// revision is used. If you modify the task definition with UpdateService, Amazon
	// ECS spawns a task with the new version of the task definition and then stops
	// an old task after the new version is running.
	TaskDefinition *string `locationName:"taskDefinition" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceInput"}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}
	if s.CapacityProviderStrategy != nil {
		for i, v := range s.CapacityProviderStrategy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CapacityProviderStrategy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DeploymentConfiguration != nil {
		if err := s.DeploymentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DeploymentConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.NetworkConfiguration != nil {
		if err := s.NetworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityProviderStrategy sets the CapacityProviderStrategy field's value.
func (s *UpdateServiceInput) SetCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *UpdateServiceInput {
	s.CapacityProviderStrategy = v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *UpdateServiceInput) SetCluster(v string) *UpdateServiceInput {
	s.Cluster = &v
	return s
}

// SetDeploymentConfiguration sets the DeploymentConfiguration field's value.
func (s *UpdateServiceInput) SetDeploymentConfiguration(v *DeploymentConfiguration) *UpdateServiceInput {
	s.DeploymentConfiguration = v
	return s
}

// SetDesiredCount sets the DesiredCount field's value.
func (s *UpdateServiceInput) SetDesiredCount(v int64) *UpdateServiceInput {
	s.DesiredCount = &v
	return s
}

// SetEnableECSManagedTags sets the EnableECSManagedTags field's value.
func (s *UpdateServiceInput) SetEnableECSManagedTags(v bool) *UpdateServiceInput {
	s.EnableECSManagedTags = &v
	return s
}

// SetEnableExecuteCommand sets the EnableExecuteCommand field's value.
func (s *UpdateServiceInput) SetEnableExecuteCommand(v bool) *UpdateServiceInput {
	s.EnableExecuteCommand = &v
	return s
}

// SetForceNewDeployment sets the ForceNewDeployment field's value.
func (s *UpdateServiceInput) SetForceNewDeployment(v bool) *UpdateServiceInput {
	s.ForceNewDeployment = &v
	return s
}

// SetHealthCheckGracePeriodSeconds sets the HealthCheckGracePeriodSeconds field's value.
func (s *UpdateServiceInput) SetHealthCheckGracePeriodSeconds(v int64) *UpdateServiceInput {
	s.HealthCheckGracePeriodSeconds = &v
	return s
}

// SetLoadBalancers sets the LoadBalancers field's value.
func (s *UpdateServiceInput) SetLoadBalancers(v []*LoadBalancer) *UpdateServiceInput {
	s.LoadBalancers = v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *UpdateServiceInput) SetNetworkConfiguration(v *NetworkConfiguration) *UpdateServiceInput {
	s.NetworkConfiguration = v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *UpdateServiceInput) SetPlacementConstraints(v []*PlacementConstraint) *UpdateServiceInput {
	s.PlacementConstraints = v
	return s
}

// SetPlacementStrategy sets the PlacementStrategy field's value.
func (s *UpdateServiceInput) SetPlacementStrategy(v []*PlacementStrategy) *UpdateServiceInput {
	s.PlacementStrategy = v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *UpdateServiceInput) SetPlatformVersion(v string) *UpdateServiceInput {
	s.PlatformVersion = &v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *UpdateServiceInput) SetPropagateTags(v string) *UpdateServiceInput {
	s.PropagateTags = &v
	return s
}

// SetService sets the Service field's value.
func (s *UpdateServiceInput) SetService(v string) *UpdateServiceInput {
	s.Service = &v
	return s
}

// SetServiceRegistries sets the ServiceRegistries field's value.
func (s *UpdateServiceInput) SetServiceRegistries(v []*ServiceRegistry) *UpdateServiceInput {
	s.ServiceRegistries = v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *UpdateServiceInput) SetTaskDefinition(v string) *UpdateServiceInput {
	s.TaskDefinition = &v
	return s
}

type UpdateServiceOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your service following the update call.
	Service *Service `locationName:"service" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceOutput) GoString() string {
	return s.String()
}

// SetService sets the Service field's value.
func (s *UpdateServiceOutput) SetService(v *Service) *UpdateServiceOutput {
	s.Service = v
	return s
}

type UpdateServicePrimaryTaskSetInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the service that the task set exists in.
	//
	// Cluster is a required field
	Cluster *string `locationName:"cluster" type:"string" required:"true"`

	// The short name or full Amazon Resource Name (ARN) of the task set to set
	// as the primary task set in the deployment.
	//
	// PrimaryTaskSet is a required field
	PrimaryTaskSet *string `locationName:"primaryTaskSet" type:"string" required:"true"`

	// The short name or full Amazon Resource Name (ARN) of the service that the
	// task set exists in.
	//
	// Service is a required field
	Service *string `locationName:"service" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServicePrimaryTaskSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServicePrimaryTaskSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServicePrimaryTaskSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServicePrimaryTaskSetInput"}
	if s.Cluster == nil {
		invalidParams.Add(request.NewErrParamRequired("Cluster"))
	}
	if s.PrimaryTaskSet == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryTaskSet"))
	}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *UpdateServicePrimaryTaskSetInput) SetCluster(v string) *UpdateServicePrimaryTaskSetInput {
	s.Cluster = &v
	return s
}

// SetPrimaryTaskSet sets the PrimaryTaskSet field's value.
func (s *UpdateServicePrimaryTaskSetInput) SetPrimaryTaskSet(v string) *UpdateServicePrimaryTaskSetInput {
	s.PrimaryTaskSet = &v
	return s
}

// SetService sets the Service field's value.
func (s *UpdateServicePrimaryTaskSetInput) SetService(v string) *UpdateServicePrimaryTaskSetInput {
	s.Service = &v
	return s
}

type UpdateServicePrimaryTaskSetOutput struct {
	_ struct{} `type:"structure"`

	// etails about the task set.
	TaskSet *TaskSet `locationName:"taskSet" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServicePrimaryTaskSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServicePrimaryTaskSetOutput) GoString() string {
	return s.String()
}

// SetTaskSet sets the TaskSet field's value.
func (s *UpdateServicePrimaryTaskSetOutput) SetTaskSet(v *TaskSet) *UpdateServicePrimaryTaskSetOutput {
	s.TaskSet = v
	return s
}

type UpdateTaskSetInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the service that the task set is found in.
	//
	// Cluster is a required field
	Cluster *string `locationName:"cluster" type:"string" required:"true"`

	// A floating-point percentage of the desired number of tasks to place and keep
	// running in the task set.
	//
	// Scale is a required field
	Scale *Scale `locationName:"scale" type:"structure" required:"true"`

	// The short name or full Amazon Resource Name (ARN) of the service that the
	// task set is found in.
	//
	// Service is a required field
	Service *string `locationName:"service" type:"string" required:"true"`

	// The short name or full Amazon Resource Name (ARN) of the task set to update.
	//
	// TaskSet is a required field
	TaskSet *string `locationName:"taskSet" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaskSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaskSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTaskSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTaskSetInput"}
	if s.Cluster == nil {
		invalidParams.Add(request.NewErrParamRequired("Cluster"))
	}
	if s.Scale == nil {
		invalidParams.Add(request.NewErrParamRequired("Scale"))
	}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}
	if s.TaskSet == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskSet"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCluster sets the Cluster field's value.
func (s *UpdateTaskSetInput) SetCluster(v string) *UpdateTaskSetInput {
	s.Cluster = &v
	return s
}

// SetScale sets the Scale field's value.
func (s *UpdateTaskSetInput) SetScale(v *Scale) *UpdateTaskSetInput {
	s.Scale = v
	return s
}

// SetService sets the Service field's value.
func (s *UpdateTaskSetInput) SetService(v string) *UpdateTaskSetInput {
	s.Service = &v
	return s
}

// SetTaskSet sets the TaskSet field's value.
func (s *UpdateTaskSetInput) SetTaskSet(v string) *UpdateTaskSetInput {
	s.TaskSet = &v
	return s
}

type UpdateTaskSetOutput struct {
	_ struct{} `type:"structure"`

	// Details about the task set.
	TaskSet *TaskSet `locationName:"taskSet" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaskSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaskSetOutput) GoString() string {
	return s.String()
}

// SetTaskSet sets the TaskSet field's value.
func (s *UpdateTaskSetOutput) SetTaskSet(v *TaskSet) *UpdateTaskSetOutput {
	s.TaskSet = v
	return s
}

// The Docker and Amazon ECS container agent version information about a container
// instance.
type VersionInfo struct {
	_ struct{} `type:"structure"`

	// The Git commit hash for the Amazon ECS container agent build on the amazon-ecs-agent
	// (https://github.com/aws/amazon-ecs-agent/commits/master) GitHub repository.
	AgentHash *string `locationName:"agentHash" type:"string"`

	// The version number of the Amazon ECS container agent.
	AgentVersion *string `locationName:"agentVersion" type:"string"`

	// The Docker version that's running on the container instance.
	DockerVersion *string `locationName:"dockerVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionInfo) GoString() string {
	return s.String()
}

// SetAgentHash sets the AgentHash field's value.
func (s *VersionInfo) SetAgentHash(v string) *VersionInfo {
	s.AgentHash = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *VersionInfo) SetAgentVersion(v string) *VersionInfo {
	s.AgentVersion = &v
	return s
}

// SetDockerVersion sets the DockerVersion field's value.
func (s *VersionInfo) SetDockerVersion(v string) *VersionInfo {
	s.DockerVersion = &v
	return s
}

// A data volume that's used in a task definition. For tasks that use the Amazon
// Elastic File System (Amazon EFS), specify an efsVolumeConfiguration. For
// Windows tasks that use Amazon FSx for Windows File Server file system, specify
// a fsxWindowsFileServerVolumeConfiguration. For tasks that use a Docker volume,
// specify a DockerVolumeConfiguration. For tasks that use a bind mount host
// volume, specify a host and optional sourcePath. For more information, see
// Using Data Volumes in Tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html).
type Volume struct {
	_ struct{} `type:"structure"`

	// This parameter is specified when you use Docker volumes.
	//
	// Windows containers only support the use of the local driver. To use bind
	// mounts, specify the host parameter instead.
	//
	// Docker volumes aren't supported by tasks run on Fargate.
	DockerVolumeConfiguration *DockerVolumeConfiguration `locationName:"dockerVolumeConfiguration" type:"structure"`

	// This parameter is specified when you use an Amazon Elastic File System file
	// system for task storage.
	EfsVolumeConfiguration *EFSVolumeConfiguration `locationName:"efsVolumeConfiguration" type:"structure"`

	// This parameter is specified when you use Amazon FSx for Windows File Server
	// file system for task storage.
	FsxWindowsFileServerVolumeConfiguration *FSxWindowsFileServerVolumeConfiguration `locationName:"fsxWindowsFileServerVolumeConfiguration" type:"structure"`

	// This parameter is specified when you use bind mount host volumes. The contents
	// of the host parameter determine whether your bind mount host volume persists
	// on the host container instance and where it's stored. If the host parameter
	// is empty, then the Docker daemon assigns a host path for your data volume.
	// However, the data isn't guaranteed to persist after the containers that are
	// associated with it stop running.
	//
	// Windows containers can mount whole directories on the same drive as $env:ProgramData.
	// Windows containers can't mount directories on a different drive, and mount
	// point can't be across drives. For example, you can mount C:\my\path:C:\my\path
	// and D:\:D:\, but not D:\my\path:C:\my\path or D:\:C:\my\path.
	Host *HostVolumeProperties `locationName:"host" type:"structure"`

	// The name of the volume. Up to 255 letters (uppercase and lowercase), numbers,
	// underscores, and hyphens are allowed. This name is referenced in the sourceVolume
	// parameter of container definition mountPoints.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Volume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Volume) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Volume) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Volume"}
	if s.EfsVolumeConfiguration != nil {
		if err := s.EfsVolumeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EfsVolumeConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.FsxWindowsFileServerVolumeConfiguration != nil {
		if err := s.FsxWindowsFileServerVolumeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FsxWindowsFileServerVolumeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDockerVolumeConfiguration sets the DockerVolumeConfiguration field's value.
func (s *Volume) SetDockerVolumeConfiguration(v *DockerVolumeConfiguration) *Volume {
	s.DockerVolumeConfiguration = v
	return s
}

// SetEfsVolumeConfiguration sets the EfsVolumeConfiguration field's value.
func (s *Volume) SetEfsVolumeConfiguration(v *EFSVolumeConfiguration) *Volume {
	s.EfsVolumeConfiguration = v
	return s
}

// SetFsxWindowsFileServerVolumeConfiguration sets the FsxWindowsFileServerVolumeConfiguration field's value.
func (s *Volume) SetFsxWindowsFileServerVolumeConfiguration(v *FSxWindowsFileServerVolumeConfiguration) *Volume {
	s.FsxWindowsFileServerVolumeConfiguration = v
	return s
}

// SetHost sets the Host field's value.
func (s *Volume) SetHost(v *HostVolumeProperties) *Volume {
	s.Host = v
	return s
}

// SetName sets the Name field's value.
func (s *Volume) SetName(v string) *Volume {
	s.Name = &v
	return s
}

// Details on a data volume from another container in the same task definition.
type VolumeFrom struct {
	_ struct{} `type:"structure"`

	// If this value is true, the container has read-only access to the volume.
	// If this value is false, then the container can write to the volume. The default
	// value is false.
	ReadOnly *bool `locationName:"readOnly" type:"boolean"`

	// The name of another container within the same task definition to mount volumes
	// from.
	SourceContainer *string `locationName:"sourceContainer" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VolumeFrom) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VolumeFrom) GoString() string {
	return s.String()
}

// SetReadOnly sets the ReadOnly field's value.
func (s *VolumeFrom) SetReadOnly(v bool) *VolumeFrom {
	s.ReadOnly = &v
	return s
}

// SetSourceContainer sets the SourceContainer field's value.
func (s *VolumeFrom) SetSourceContainer(v string) *VolumeFrom {
	s.SourceContainer = &v
	return s
}

const (
	// AgentUpdateStatusPending is a AgentUpdateStatus enum value
	AgentUpdateStatusPending = "PENDING"

	// AgentUpdateStatusStaging is a AgentUpdateStatus enum value
	AgentUpdateStatusStaging = "STAGING"

	// AgentUpdateStatusStaged is a AgentUpdateStatus enum value
	AgentUpdateStatusStaged = "STAGED"

	// AgentUpdateStatusUpdating is a AgentUpdateStatus enum value
	AgentUpdateStatusUpdating = "UPDATING"

	// AgentUpdateStatusUpdated is a AgentUpdateStatus enum value
	AgentUpdateStatusUpdated = "UPDATED"

	// AgentUpdateStatusFailed is a AgentUpdateStatus enum value
	AgentUpdateStatusFailed = "FAILED"
)

// AgentUpdateStatus_Values returns all elements of the AgentUpdateStatus enum
func AgentUpdateStatus_Values() []string {
	return []string{
		AgentUpdateStatusPending,
		AgentUpdateStatusStaging,
		AgentUpdateStatusStaged,
		AgentUpdateStatusUpdating,
		AgentUpdateStatusUpdated,
		AgentUpdateStatusFailed,
	}
}

const (
	// AssignPublicIpEnabled is a AssignPublicIp enum value
	AssignPublicIpEnabled = "ENABLED"

	// AssignPublicIpDisabled is a AssignPublicIp enum value
	AssignPublicIpDisabled = "DISABLED"
)

// AssignPublicIp_Values returns all elements of the AssignPublicIp enum
func AssignPublicIp_Values() []string {
	return []string{
		AssignPublicIpEnabled,
		AssignPublicIpDisabled,
	}
}

const (
	// CPUArchitectureX8664 is a CPUArchitecture enum value
	CPUArchitectureX8664 = "X86_64"

	// CPUArchitectureArm64 is a CPUArchitecture enum value
	CPUArchitectureArm64 = "ARM64"
)

// CPUArchitecture_Values returns all elements of the CPUArchitecture enum
func CPUArchitecture_Values() []string {
	return []string{
		CPUArchitectureX8664,
		CPUArchitectureArm64,
	}
}

const (
	// CapacityProviderFieldTags is a CapacityProviderField enum value
	CapacityProviderFieldTags = "TAGS"
)

// CapacityProviderField_Values returns all elements of the CapacityProviderField enum
func CapacityProviderField_Values() []string {
	return []string{
		CapacityProviderFieldTags,
	}
}

const (
	// CapacityProviderStatusActive is a CapacityProviderStatus enum value
	CapacityProviderStatusActive = "ACTIVE"

	// CapacityProviderStatusInactive is a CapacityProviderStatus enum value
	CapacityProviderStatusInactive = "INACTIVE"
)

// CapacityProviderStatus_Values returns all elements of the CapacityProviderStatus enum
func CapacityProviderStatus_Values() []string {
	return []string{
		CapacityProviderStatusActive,
		CapacityProviderStatusInactive,
	}
}

const (
	// CapacityProviderUpdateStatusDeleteInProgress is a CapacityProviderUpdateStatus enum value
	CapacityProviderUpdateStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// CapacityProviderUpdateStatusDeleteComplete is a CapacityProviderUpdateStatus enum value
	CapacityProviderUpdateStatusDeleteComplete = "DELETE_COMPLETE"

	// CapacityProviderUpdateStatusDeleteFailed is a CapacityProviderUpdateStatus enum value
	CapacityProviderUpdateStatusDeleteFailed = "DELETE_FAILED"

	// CapacityProviderUpdateStatusUpdateInProgress is a CapacityProviderUpdateStatus enum value
	CapacityProviderUpdateStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// CapacityProviderUpdateStatusUpdateComplete is a CapacityProviderUpdateStatus enum value
	CapacityProviderUpdateStatusUpdateComplete = "UPDATE_COMPLETE"

	// CapacityProviderUpdateStatusUpdateFailed is a CapacityProviderUpdateStatus enum value
	CapacityProviderUpdateStatusUpdateFailed = "UPDATE_FAILED"
)

// CapacityProviderUpdateStatus_Values returns all elements of the CapacityProviderUpdateStatus enum
func CapacityProviderUpdateStatus_Values() []string {
	return []string{
		CapacityProviderUpdateStatusDeleteInProgress,
		CapacityProviderUpdateStatusDeleteComplete,
		CapacityProviderUpdateStatusDeleteFailed,
		CapacityProviderUpdateStatusUpdateInProgress,
		CapacityProviderUpdateStatusUpdateComplete,
		CapacityProviderUpdateStatusUpdateFailed,
	}
}

const (
	// ClusterFieldAttachments is a ClusterField enum value
	ClusterFieldAttachments = "ATTACHMENTS"

	// ClusterFieldConfigurations is a ClusterField enum value
	ClusterFieldConfigurations = "CONFIGURATIONS"

	// ClusterFieldSettings is a ClusterField enum value
	ClusterFieldSettings = "SETTINGS"

	// ClusterFieldStatistics is a ClusterField enum value
	ClusterFieldStatistics = "STATISTICS"

	// ClusterFieldTags is a ClusterField enum value
	ClusterFieldTags = "TAGS"
)

// ClusterField_Values returns all elements of the ClusterField enum
func ClusterField_Values() []string {
	return []string{
		ClusterFieldAttachments,
		ClusterFieldConfigurations,
		ClusterFieldSettings,
		ClusterFieldStatistics,
		ClusterFieldTags,
	}
}

const (
	// ClusterSettingNameContainerInsights is a ClusterSettingName enum value
	ClusterSettingNameContainerInsights = "containerInsights"
)

// ClusterSettingName_Values returns all elements of the ClusterSettingName enum
func ClusterSettingName_Values() []string {
	return []string{
		ClusterSettingNameContainerInsights,
	}
}

const (
	// CompatibilityEc2 is a Compatibility enum value
	CompatibilityEc2 = "EC2"

	// CompatibilityFargate is a Compatibility enum value
	CompatibilityFargate = "FARGATE"

	// CompatibilityExternal is a Compatibility enum value
	CompatibilityExternal = "EXTERNAL"
)

// Compatibility_Values returns all elements of the Compatibility enum
func Compatibility_Values() []string {
	return []string{
		CompatibilityEc2,
		CompatibilityFargate,
		CompatibilityExternal,
	}
}

const (
	// ConnectivityConnected is a Connectivity enum value
	ConnectivityConnected = "CONNECTED"

	// ConnectivityDisconnected is a Connectivity enum value
	ConnectivityDisconnected = "DISCONNECTED"
)

// Connectivity_Values returns all elements of the Connectivity enum
func Connectivity_Values() []string {
	return []string{
		ConnectivityConnected,
		ConnectivityDisconnected,
	}
}

const (
	// ContainerConditionStart is a ContainerCondition enum value
	ContainerConditionStart = "START"

	// ContainerConditionComplete is a ContainerCondition enum value
	ContainerConditionComplete = "COMPLETE"

	// ContainerConditionSuccess is a ContainerCondition enum value
	ContainerConditionSuccess = "SUCCESS"

	// ContainerConditionHealthy is a ContainerCondition enum value
	ContainerConditionHealthy = "HEALTHY"
)

// ContainerCondition_Values returns all elements of the ContainerCondition enum
func ContainerCondition_Values() []string {
	return []string{
		ContainerConditionStart,
		ContainerConditionComplete,
		ContainerConditionSuccess,
		ContainerConditionHealthy,
	}
}

const (
	// ContainerInstanceFieldTags is a ContainerInstanceField enum value
	ContainerInstanceFieldTags = "TAGS"

	// ContainerInstanceFieldContainerInstanceHealth is a ContainerInstanceField enum value
	ContainerInstanceFieldContainerInstanceHealth = "CONTAINER_INSTANCE_HEALTH"
)

// ContainerInstanceField_Values returns all elements of the ContainerInstanceField enum
func ContainerInstanceField_Values() []string {
	return []string{
		ContainerInstanceFieldTags,
		ContainerInstanceFieldContainerInstanceHealth,
	}
}

const (
	// ContainerInstanceStatusActive is a ContainerInstanceStatus enum value
	ContainerInstanceStatusActive = "ACTIVE"

	// ContainerInstanceStatusDraining is a ContainerInstanceStatus enum value
	ContainerInstanceStatusDraining = "DRAINING"

	// ContainerInstanceStatusRegistering is a ContainerInstanceStatus enum value
	ContainerInstanceStatusRegistering = "REGISTERING"

	// ContainerInstanceStatusDeregistering is a ContainerInstanceStatus enum value
	ContainerInstanceStatusDeregistering = "DEREGISTERING"

	// ContainerInstanceStatusRegistrationFailed is a ContainerInstanceStatus enum value
	ContainerInstanceStatusRegistrationFailed = "REGISTRATION_FAILED"
)

// ContainerInstanceStatus_Values returns all elements of the ContainerInstanceStatus enum
func ContainerInstanceStatus_Values() []string {
	return []string{
		ContainerInstanceStatusActive,
		ContainerInstanceStatusDraining,
		ContainerInstanceStatusRegistering,
		ContainerInstanceStatusDeregistering,
		ContainerInstanceStatusRegistrationFailed,
	}
}

const (
	// DeploymentControllerTypeEcs is a DeploymentControllerType enum value
	DeploymentControllerTypeEcs = "ECS"

	// DeploymentControllerTypeCodeDeploy is a DeploymentControllerType enum value
	DeploymentControllerTypeCodeDeploy = "CODE_DEPLOY"

	// DeploymentControllerTypeExternal is a DeploymentControllerType enum value
	DeploymentControllerTypeExternal = "EXTERNAL"
)

// DeploymentControllerType_Values returns all elements of the DeploymentControllerType enum
func DeploymentControllerType_Values() []string {
	return []string{
		DeploymentControllerTypeEcs,
		DeploymentControllerTypeCodeDeploy,
		DeploymentControllerTypeExternal,
	}
}

const (
	// DeploymentRolloutStateCompleted is a DeploymentRolloutState enum value
	DeploymentRolloutStateCompleted = "COMPLETED"

	// DeploymentRolloutStateFailed is a DeploymentRolloutState enum value
	DeploymentRolloutStateFailed = "FAILED"

	// DeploymentRolloutStateInProgress is a DeploymentRolloutState enum value
	DeploymentRolloutStateInProgress = "IN_PROGRESS"
)

// DeploymentRolloutState_Values returns all elements of the DeploymentRolloutState enum
func DeploymentRolloutState_Values() []string {
	return []string{
		DeploymentRolloutStateCompleted,
		DeploymentRolloutStateFailed,
		DeploymentRolloutStateInProgress,
	}
}

const (
	// DesiredStatusRunning is a DesiredStatus enum value
	DesiredStatusRunning = "RUNNING"

	// DesiredStatusPending is a DesiredStatus enum value
	DesiredStatusPending = "PENDING"

	// DesiredStatusStopped is a DesiredStatus enum value
	DesiredStatusStopped = "STOPPED"
)

// DesiredStatus_Values returns all elements of the DesiredStatus enum
func DesiredStatus_Values() []string {
	return []string{
		DesiredStatusRunning,
		DesiredStatusPending,
		DesiredStatusStopped,
	}
}

const (
	// DeviceCgroupPermissionRead is a DeviceCgroupPermission enum value
	DeviceCgroupPermissionRead = "read"

	// DeviceCgroupPermissionWrite is a DeviceCgroupPermission enum value
	DeviceCgroupPermissionWrite = "write"

	// DeviceCgroupPermissionMknod is a DeviceCgroupPermission enum value
	DeviceCgroupPermissionMknod = "mknod"
)

// DeviceCgroupPermission_Values returns all elements of the DeviceCgroupPermission enum
func DeviceCgroupPermission_Values() []string {
	return []string{
		DeviceCgroupPermissionRead,
		DeviceCgroupPermissionWrite,
		DeviceCgroupPermissionMknod,
	}
}

const (
	// EFSAuthorizationConfigIAMEnabled is a EFSAuthorizationConfigIAM enum value
	EFSAuthorizationConfigIAMEnabled = "ENABLED"

	// EFSAuthorizationConfigIAMDisabled is a EFSAuthorizationConfigIAM enum value
	EFSAuthorizationConfigIAMDisabled = "DISABLED"
)

// EFSAuthorizationConfigIAM_Values returns all elements of the EFSAuthorizationConfigIAM enum
func EFSAuthorizationConfigIAM_Values() []string {
	return []string{
		EFSAuthorizationConfigIAMEnabled,
		EFSAuthorizationConfigIAMDisabled,
	}
}

const (
	// EFSTransitEncryptionEnabled is a EFSTransitEncryption enum value
	EFSTransitEncryptionEnabled = "ENABLED"

	// EFSTransitEncryptionDisabled is a EFSTransitEncryption enum value
	EFSTransitEncryptionDisabled = "DISABLED"
)

// EFSTransitEncryption_Values returns all elements of the EFSTransitEncryption enum
func EFSTransitEncryption_Values() []string {
	return []string{
		EFSTransitEncryptionEnabled,
		EFSTransitEncryptionDisabled,
	}
}

const (
	// EnvironmentFileTypeS3 is a EnvironmentFileType enum value
	EnvironmentFileTypeS3 = "s3"
)

// EnvironmentFileType_Values returns all elements of the EnvironmentFileType enum
func EnvironmentFileType_Values() []string {
	return []string{
		EnvironmentFileTypeS3,
	}
}

const (
	// ExecuteCommandLoggingNone is a ExecuteCommandLogging enum value
	ExecuteCommandLoggingNone = "NONE"

	// ExecuteCommandLoggingDefault is a ExecuteCommandLogging enum value
	ExecuteCommandLoggingDefault = "DEFAULT"

	// ExecuteCommandLoggingOverride is a ExecuteCommandLogging enum value
	ExecuteCommandLoggingOverride = "OVERRIDE"
)

// ExecuteCommandLogging_Values returns all elements of the ExecuteCommandLogging enum
func ExecuteCommandLogging_Values() []string {
	return []string{
		ExecuteCommandLoggingNone,
		ExecuteCommandLoggingDefault,
		ExecuteCommandLoggingOverride,
	}
}

const (
	// FirelensConfigurationTypeFluentd is a FirelensConfigurationType enum value
	FirelensConfigurationTypeFluentd = "fluentd"

	// FirelensConfigurationTypeFluentbit is a FirelensConfigurationType enum value
	FirelensConfigurationTypeFluentbit = "fluentbit"
)

// FirelensConfigurationType_Values returns all elements of the FirelensConfigurationType enum
func FirelensConfigurationType_Values() []string {
	return []string{
		FirelensConfigurationTypeFluentd,
		FirelensConfigurationTypeFluentbit,
	}
}

const (
	// HealthStatusHealthy is a HealthStatus enum value
	HealthStatusHealthy = "HEALTHY"

	// HealthStatusUnhealthy is a HealthStatus enum value
	HealthStatusUnhealthy = "UNHEALTHY"

	// HealthStatusUnknown is a HealthStatus enum value
	HealthStatusUnknown = "UNKNOWN"
)

// HealthStatus_Values returns all elements of the HealthStatus enum
func HealthStatus_Values() []string {
	return []string{
		HealthStatusHealthy,
		HealthStatusUnhealthy,
		HealthStatusUnknown,
	}
}

const (
	// InstanceHealthCheckStateOk is a InstanceHealthCheckState enum value
	InstanceHealthCheckStateOk = "OK"

	// InstanceHealthCheckStateImpaired is a InstanceHealthCheckState enum value
	InstanceHealthCheckStateImpaired = "IMPAIRED"

	// InstanceHealthCheckStateInsufficientData is a InstanceHealthCheckState enum value
	InstanceHealthCheckStateInsufficientData = "INSUFFICIENT_DATA"

	// InstanceHealthCheckStateInitializing is a InstanceHealthCheckState enum value
	InstanceHealthCheckStateInitializing = "INITIALIZING"
)

// InstanceHealthCheckState_Values returns all elements of the InstanceHealthCheckState enum
func InstanceHealthCheckState_Values() []string {
	return []string{
		InstanceHealthCheckStateOk,
		InstanceHealthCheckStateImpaired,
		InstanceHealthCheckStateInsufficientData,
		InstanceHealthCheckStateInitializing,
	}
}

const (
	// InstanceHealthCheckTypeContainerRuntime is a InstanceHealthCheckType enum value
	InstanceHealthCheckTypeContainerRuntime = "CONTAINER_RUNTIME"
)

// InstanceHealthCheckType_Values returns all elements of the InstanceHealthCheckType enum
func InstanceHealthCheckType_Values() []string {
	return []string{
		InstanceHealthCheckTypeContainerRuntime,
	}
}

const (
	// IpcModeHost is a IpcMode enum value
	IpcModeHost = "host"

	// IpcModeTask is a IpcMode enum value
	IpcModeTask = "task"

	// IpcModeNone is a IpcMode enum value
	IpcModeNone = "none"
)

// IpcMode_Values returns all elements of the IpcMode enum
func IpcMode_Values() []string {
	return []string{
		IpcModeHost,
		IpcModeTask,
		IpcModeNone,
	}
}

const (
	// LaunchTypeEc2 is a LaunchType enum value
	LaunchTypeEc2 = "EC2"

	// LaunchTypeFargate is a LaunchType enum value
	LaunchTypeFargate = "FARGATE"

	// LaunchTypeExternal is a LaunchType enum value
	LaunchTypeExternal = "EXTERNAL"
)

// LaunchType_Values returns all elements of the LaunchType enum
func LaunchType_Values() []string {
	return []string{
		LaunchTypeEc2,
		LaunchTypeFargate,
		LaunchTypeExternal,
	}
}

const (
	// LogDriverJsonFile is a LogDriver enum value
	LogDriverJsonFile = "json-file"

	// LogDriverSyslog is a LogDriver enum value
	LogDriverSyslog = "syslog"

	// LogDriverJournald is a LogDriver enum value
	LogDriverJournald = "journald"

	// LogDriverGelf is a LogDriver enum value
	LogDriverGelf = "gelf"

	// LogDriverFluentd is a LogDriver enum value
	LogDriverFluentd = "fluentd"

	// LogDriverAwslogs is a LogDriver enum value
	LogDriverAwslogs = "awslogs"

	// LogDriverSplunk is a LogDriver enum value
	LogDriverSplunk = "splunk"

	// LogDriverAwsfirelens is a LogDriver enum value
	LogDriverAwsfirelens = "awsfirelens"
)

// LogDriver_Values returns all elements of the LogDriver enum
func LogDriver_Values() []string {
	return []string{
		LogDriverJsonFile,
		LogDriverSyslog,
		LogDriverJournald,
		LogDriverGelf,
		LogDriverFluentd,
		LogDriverAwslogs,
		LogDriverSplunk,
		LogDriverAwsfirelens,
	}
}

const (
	// ManagedAgentNameExecuteCommandAgent is a ManagedAgentName enum value
	ManagedAgentNameExecuteCommandAgent = "ExecuteCommandAgent"
)

// ManagedAgentName_Values returns all elements of the ManagedAgentName enum
func ManagedAgentName_Values() []string {
	return []string{
		ManagedAgentNameExecuteCommandAgent,
	}
}

const (
	// ManagedScalingStatusEnabled is a ManagedScalingStatus enum value
	ManagedScalingStatusEnabled = "ENABLED"

	// ManagedScalingStatusDisabled is a ManagedScalingStatus enum value
	ManagedScalingStatusDisabled = "DISABLED"
)

// ManagedScalingStatus_Values returns all elements of the ManagedScalingStatus enum
func ManagedScalingStatus_Values() []string {
	return []string{
		ManagedScalingStatusEnabled,
		ManagedScalingStatusDisabled,
	}
}

const (
	// ManagedTerminationProtectionEnabled is a ManagedTerminationProtection enum value
	ManagedTerminationProtectionEnabled = "ENABLED"

	// ManagedTerminationProtectionDisabled is a ManagedTerminationProtection enum value
	ManagedTerminationProtectionDisabled = "DISABLED"
)

// ManagedTerminationProtection_Values returns all elements of the ManagedTerminationProtection enum
func ManagedTerminationProtection_Values() []string {
	return []string{
		ManagedTerminationProtectionEnabled,
		ManagedTerminationProtectionDisabled,
	}
}

const (
	// NetworkModeBridge is a NetworkMode enum value
	NetworkModeBridge = "bridge"

	// NetworkModeHost is a NetworkMode enum value
	NetworkModeHost = "host"

	// NetworkModeAwsvpc is a NetworkMode enum value
	NetworkModeAwsvpc = "awsvpc"

	// NetworkModeNone is a NetworkMode enum value
	NetworkModeNone = "none"
)

// NetworkMode_Values returns all elements of the NetworkMode enum
func NetworkMode_Values() []string {
	return []string{
		NetworkModeBridge,
		NetworkModeHost,
		NetworkModeAwsvpc,
		NetworkModeNone,
	}
}

const (
	// OSFamilyWindowsServer2019Full is a OSFamily enum value
	OSFamilyWindowsServer2019Full = "WINDOWS_SERVER_2019_FULL"

	// OSFamilyWindowsServer2019Core is a OSFamily enum value
	OSFamilyWindowsServer2019Core = "WINDOWS_SERVER_2019_CORE"

	// OSFamilyWindowsServer2016Full is a OSFamily enum value
	OSFamilyWindowsServer2016Full = "WINDOWS_SERVER_2016_FULL"

	// OSFamilyWindowsServer2004Core is a OSFamily enum value
	OSFamilyWindowsServer2004Core = "WINDOWS_SERVER_2004_CORE"

	// OSFamilyWindowsServer2022Core is a OSFamily enum value
	OSFamilyWindowsServer2022Core = "WINDOWS_SERVER_2022_CORE"

	// OSFamilyWindowsServer2022Full is a OSFamily enum value
	OSFamilyWindowsServer2022Full = "WINDOWS_SERVER_2022_FULL"

	// OSFamilyWindowsServer20h2Core is a OSFamily enum value
	OSFamilyWindowsServer20h2Core = "WINDOWS_SERVER_20H2_CORE"

	// OSFamilyLinux is a OSFamily enum value
	OSFamilyLinux = "LINUX"
)

// OSFamily_Values returns all elements of the OSFamily enum
func OSFamily_Values() []string {
	return []string{
		OSFamilyWindowsServer2019Full,
		OSFamilyWindowsServer2019Core,
		OSFamilyWindowsServer2016Full,
		OSFamilyWindowsServer2004Core,
		OSFamilyWindowsServer2022Core,
		OSFamilyWindowsServer2022Full,
		OSFamilyWindowsServer20h2Core,
		OSFamilyLinux,
	}
}

const (
	// PidModeHost is a PidMode enum value
	PidModeHost = "host"

	// PidModeTask is a PidMode enum value
	PidModeTask = "task"
)

// PidMode_Values returns all elements of the PidMode enum
func PidMode_Values() []string {
	return []string{
		PidModeHost,
		PidModeTask,
	}
}

const (
	// PlacementConstraintTypeDistinctInstance is a PlacementConstraintType enum value
	PlacementConstraintTypeDistinctInstance = "distinctInstance"

	// PlacementConstraintTypeMemberOf is a PlacementConstraintType enum value
	PlacementConstraintTypeMemberOf = "memberOf"
)

// PlacementConstraintType_Values returns all elements of the PlacementConstraintType enum
func PlacementConstraintType_Values() []string {
	return []string{
		PlacementConstraintTypeDistinctInstance,
		PlacementConstraintTypeMemberOf,
	}
}

const (
	// PlacementStrategyTypeRandom is a PlacementStrategyType enum value
	PlacementStrategyTypeRandom = "random"

	// PlacementStrategyTypeSpread is a PlacementStrategyType enum value
	PlacementStrategyTypeSpread = "spread"

	// PlacementStrategyTypeBinpack is a PlacementStrategyType enum value
	PlacementStrategyTypeBinpack = "binpack"
)

// PlacementStrategyType_Values returns all elements of the PlacementStrategyType enum
func PlacementStrategyType_Values() []string {
	return []string{
		PlacementStrategyTypeRandom,
		PlacementStrategyTypeSpread,
		PlacementStrategyTypeBinpack,
	}
}

const (
	// PlatformDeviceTypeGpu is a PlatformDeviceType enum value
	PlatformDeviceTypeGpu = "GPU"
)

// PlatformDeviceType_Values returns all elements of the PlatformDeviceType enum
func PlatformDeviceType_Values() []string {
	return []string{
		PlatformDeviceTypeGpu,
	}
}

const (
	// PropagateTagsTaskDefinition is a PropagateTags enum value
	PropagateTagsTaskDefinition = "TASK_DEFINITION"

	// PropagateTagsService is a PropagateTags enum value
	PropagateTagsService = "SERVICE"

	// PropagateTagsNone is a PropagateTags enum value
	PropagateTagsNone = "NONE"
)

// PropagateTags_Values returns all elements of the PropagateTags enum
func PropagateTags_Values() []string {
	return []string{
		PropagateTagsTaskDefinition,
		PropagateTagsService,
		PropagateTagsNone,
	}
}

const (
	// ProxyConfigurationTypeAppmesh is a ProxyConfigurationType enum value
	ProxyConfigurationTypeAppmesh = "APPMESH"
)

// ProxyConfigurationType_Values returns all elements of the ProxyConfigurationType enum
func ProxyConfigurationType_Values() []string {
	return []string{
		ProxyConfigurationTypeAppmesh,
	}
}

const (
	// ResourceTypeGpu is a ResourceType enum value
	ResourceTypeGpu = "GPU"

	// ResourceTypeInferenceAccelerator is a ResourceType enum value
	ResourceTypeInferenceAccelerator = "InferenceAccelerator"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeGpu,
		ResourceTypeInferenceAccelerator,
	}
}

const (
	// ScaleUnitPercent is a ScaleUnit enum value
	ScaleUnitPercent = "PERCENT"
)

// ScaleUnit_Values returns all elements of the ScaleUnit enum
func ScaleUnit_Values() []string {
	return []string{
		ScaleUnitPercent,
	}
}

const (
	// SchedulingStrategyReplica is a SchedulingStrategy enum value
	SchedulingStrategyReplica = "REPLICA"

	// SchedulingStrategyDaemon is a SchedulingStrategy enum value
	SchedulingStrategyDaemon = "DAEMON"
)

// SchedulingStrategy_Values returns all elements of the SchedulingStrategy enum
func SchedulingStrategy_Values() []string {
	return []string{
		SchedulingStrategyReplica,
		SchedulingStrategyDaemon,
	}
}

const (
	// ScopeTask is a Scope enum value
	ScopeTask = "task"

	// ScopeShared is a Scope enum value
	ScopeShared = "shared"
)

// Scope_Values returns all elements of the Scope enum
func Scope_Values() []string {
	return []string{
		ScopeTask,
		ScopeShared,
	}
}

const (
	// ServiceFieldTags is a ServiceField enum value
	ServiceFieldTags = "TAGS"
)

// ServiceField_Values returns all elements of the ServiceField enum
func ServiceField_Values() []string {
	return []string{
		ServiceFieldTags,
	}
}

const (
	// SettingNameServiceLongArnFormat is a SettingName enum value
	SettingNameServiceLongArnFormat = "serviceLongArnFormat"

	// SettingNameTaskLongArnFormat is a SettingName enum value
	SettingNameTaskLongArnFormat = "taskLongArnFormat"

	// SettingNameContainerInstanceLongArnFormat is a SettingName enum value
	SettingNameContainerInstanceLongArnFormat = "containerInstanceLongArnFormat"

	// SettingNameAwsvpcTrunking is a SettingName enum value
	SettingNameAwsvpcTrunking = "awsvpcTrunking"

	// SettingNameContainerInsights is a SettingName enum value
	SettingNameContainerInsights = "containerInsights"
)

// SettingName_Values returns all elements of the SettingName enum
func SettingName_Values() []string {
	return []string{
		SettingNameServiceLongArnFormat,
		SettingNameTaskLongArnFormat,
		SettingNameContainerInstanceLongArnFormat,
		SettingNameAwsvpcTrunking,
		SettingNameContainerInsights,
	}
}

const (
	// SortOrderAsc is a SortOrder enum value
	SortOrderAsc = "ASC"

	// SortOrderDesc is a SortOrder enum value
	SortOrderDesc = "DESC"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAsc,
		SortOrderDesc,
	}
}

const (
	// StabilityStatusSteadyState is a StabilityStatus enum value
	StabilityStatusSteadyState = "STEADY_STATE"

	// StabilityStatusStabilizing is a StabilityStatus enum value
	StabilityStatusStabilizing = "STABILIZING"
)

// StabilityStatus_Values returns all elements of the StabilityStatus enum
func StabilityStatus_Values() []string {
	return []string{
		StabilityStatusSteadyState,
		StabilityStatusStabilizing,
	}
}

const (
	// TargetTypeContainerInstance is a TargetType enum value
	TargetTypeContainerInstance = "container-instance"
)

// TargetType_Values returns all elements of the TargetType enum
func TargetType_Values() []string {
	return []string{
		TargetTypeContainerInstance,
	}
}

const (
	// TaskDefinitionFamilyStatusActive is a TaskDefinitionFamilyStatus enum value
	TaskDefinitionFamilyStatusActive = "ACTIVE"

	// TaskDefinitionFamilyStatusInactive is a TaskDefinitionFamilyStatus enum value
	TaskDefinitionFamilyStatusInactive = "INACTIVE"

	// TaskDefinitionFamilyStatusAll is a TaskDefinitionFamilyStatus enum value
	TaskDefinitionFamilyStatusAll = "ALL"
)

// TaskDefinitionFamilyStatus_Values returns all elements of the TaskDefinitionFamilyStatus enum
func TaskDefinitionFamilyStatus_Values() []string {
	return []string{
		TaskDefinitionFamilyStatusActive,
		TaskDefinitionFamilyStatusInactive,
		TaskDefinitionFamilyStatusAll,
	}
}

const (
	// TaskDefinitionFieldTags is a TaskDefinitionField enum value
	TaskDefinitionFieldTags = "TAGS"
)

// TaskDefinitionField_Values returns all elements of the TaskDefinitionField enum
func TaskDefinitionField_Values() []string {
	return []string{
		TaskDefinitionFieldTags,
	}
}

const (
	// TaskDefinitionPlacementConstraintTypeMemberOf is a TaskDefinitionPlacementConstraintType enum value
	TaskDefinitionPlacementConstraintTypeMemberOf = "memberOf"
)

// TaskDefinitionPlacementConstraintType_Values returns all elements of the TaskDefinitionPlacementConstraintType enum
func TaskDefinitionPlacementConstraintType_Values() []string {
	return []string{
		TaskDefinitionPlacementConstraintTypeMemberOf,
	}
}

const (
	// TaskDefinitionStatusActive is a TaskDefinitionStatus enum value
	TaskDefinitionStatusActive = "ACTIVE"

	// TaskDefinitionStatusInactive is a TaskDefinitionStatus enum value
	TaskDefinitionStatusInactive = "INACTIVE"
)

// TaskDefinitionStatus_Values returns all elements of the TaskDefinitionStatus enum
func TaskDefinitionStatus_Values() []string {
	return []string{
		TaskDefinitionStatusActive,
		TaskDefinitionStatusInactive,
	}
}

const (
	// TaskFieldTags is a TaskField enum value
	TaskFieldTags = "TAGS"
)

// TaskField_Values returns all elements of the TaskField enum
func TaskField_Values() []string {
	return []string{
		TaskFieldTags,
	}
}

const (
	// TaskSetFieldTags is a TaskSetField enum value
	TaskSetFieldTags = "TAGS"
)

// TaskSetField_Values returns all elements of the TaskSetField enum
func TaskSetField_Values() []string {
	return []string{
		TaskSetFieldTags,
	}
}

const (
	// TaskStopCodeTaskFailedToStart is a TaskStopCode enum value
	TaskStopCodeTaskFailedToStart = "TaskFailedToStart"

	// TaskStopCodeEssentialContainerExited is a TaskStopCode enum value
	TaskStopCodeEssentialContainerExited = "EssentialContainerExited"

	// TaskStopCodeUserInitiated is a TaskStopCode enum value
	TaskStopCodeUserInitiated = "UserInitiated"
)

// TaskStopCode_Values returns all elements of the TaskStopCode enum
func TaskStopCode_Values() []string {
	return []string{
		TaskStopCodeTaskFailedToStart,
		TaskStopCodeEssentialContainerExited,
		TaskStopCodeUserInitiated,
	}
}

const (
	// TransportProtocolTcp is a TransportProtocol enum value
	TransportProtocolTcp = "tcp"

	// TransportProtocolUdp is a TransportProtocol enum value
	TransportProtocolUdp = "udp"
)

// TransportProtocol_Values returns all elements of the TransportProtocol enum
func TransportProtocol_Values() []string {
	return []string{
		TransportProtocolTcp,
		TransportProtocolUdp,
	}
}

const (
	// UlimitNameCore is a UlimitName enum value
	UlimitNameCore = "core"

	// UlimitNameCpu is a UlimitName enum value
	UlimitNameCpu = "cpu"

	// UlimitNameData is a UlimitName enum value
	UlimitNameData = "data"

	// UlimitNameFsize is a UlimitName enum value
	UlimitNameFsize = "fsize"

	// UlimitNameLocks is a UlimitName enum value
	UlimitNameLocks = "locks"

	// UlimitNameMemlock is a UlimitName enum value
	UlimitNameMemlock = "memlock"

	// UlimitNameMsgqueue is a UlimitName enum value
	UlimitNameMsgqueue = "msgqueue"

	// UlimitNameNice is a UlimitName enum value
	UlimitNameNice = "nice"

	// UlimitNameNofile is a UlimitName enum value
	UlimitNameNofile = "nofile"

	// UlimitNameNproc is a UlimitName enum value
	UlimitNameNproc = "nproc"

	// UlimitNameRss is a UlimitName enum value
	UlimitNameRss = "rss"

	// UlimitNameRtprio is a UlimitName enum value
	UlimitNameRtprio = "rtprio"

	// UlimitNameRttime is a UlimitName enum value
	UlimitNameRttime = "rttime"

	// UlimitNameSigpending is a UlimitName enum value
	UlimitNameSigpending = "sigpending"

	// UlimitNameStack is a UlimitName enum value
	UlimitNameStack = "stack"
)

// UlimitName_Values returns all elements of the UlimitName enum
func UlimitName_Values() []string {
	return []string{
		UlimitNameCore,
		UlimitNameCpu,
		UlimitNameData,
		UlimitNameFsize,
		UlimitNameLocks,
		UlimitNameMemlock,
		UlimitNameMsgqueue,
		UlimitNameNice,
		UlimitNameNofile,
		UlimitNameNproc,
		UlimitNameRss,
		UlimitNameRtprio,
		UlimitNameRttime,
		UlimitNameSigpending,
		UlimitNameStack,
	}
}
