// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fis

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateExperimentTemplate = "CreateExperimentTemplate"

// CreateExperimentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateExperimentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExperimentTemplate for more information on using the CreateExperimentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateExperimentTemplateRequest method.
//	req, resp := client.CreateExperimentTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/CreateExperimentTemplate
func (c *FIS) CreateExperimentTemplateRequest(input *CreateExperimentTemplateInput) (req *request.Request, output *CreateExperimentTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateExperimentTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/experimentTemplates",
	}

	if input == nil {
		input = &CreateExperimentTemplateInput{}
	}

	output = &CreateExperimentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExperimentTemplate API operation for AWS Fault Injection Simulator.
//
// Creates an experiment template.
//
// An experiment template includes the following components:
//
//   - Targets: A target can be a specific resource in your Amazon Web Services
//     environment, or one or more resources that match criteria that you specify,
//     for example, resources that have specific tags.
//
//   - Actions: The actions to carry out on the target. You can specify multiple
//     actions, the duration of each action, and when to start each action during
//     an experiment.
//
//   - Stop conditions: If a stop condition is triggered while an experiment
//     is running, the experiment is automatically stopped. You can define a
//     stop condition as a CloudWatch alarm.
//
// For more information, see experiment templates (https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html)
// in the Fault Injection Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation CreateExperimentTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ConflictException
//     The request could not be processed because of a conflict.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/CreateExperimentTemplate
func (c *FIS) CreateExperimentTemplate(input *CreateExperimentTemplateInput) (*CreateExperimentTemplateOutput, error) {
	req, out := c.CreateExperimentTemplateRequest(input)
	return out, req.Send()
}

// CreateExperimentTemplateWithContext is the same as CreateExperimentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExperimentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) CreateExperimentTemplateWithContext(ctx aws.Context, input *CreateExperimentTemplateInput, opts ...request.Option) (*CreateExperimentTemplateOutput, error) {
	req, out := c.CreateExperimentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTargetAccountConfiguration = "CreateTargetAccountConfiguration"

// CreateTargetAccountConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateTargetAccountConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTargetAccountConfiguration for more information on using the CreateTargetAccountConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTargetAccountConfigurationRequest method.
//	req, resp := client.CreateTargetAccountConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/CreateTargetAccountConfiguration
func (c *FIS) CreateTargetAccountConfigurationRequest(input *CreateTargetAccountConfigurationInput) (req *request.Request, output *CreateTargetAccountConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateTargetAccountConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/experimentTemplates/{id}/targetAccountConfigurations/{accountId}",
	}

	if input == nil {
		input = &CreateTargetAccountConfigurationInput{}
	}

	output = &CreateTargetAccountConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTargetAccountConfiguration API operation for AWS Fault Injection Simulator.
//
// Creates a target account configuration for the experiment template. A target
// account configuration is required when accountTargeting of experimentOptions
// is set to multi-account. For more information, see experiment options (https://docs.aws.amazon.com/fis/latest/userguide/experiment-options.html)
// in the Fault Injection Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation CreateTargetAccountConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ConflictException
//     The request could not be processed because of a conflict.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/CreateTargetAccountConfiguration
func (c *FIS) CreateTargetAccountConfiguration(input *CreateTargetAccountConfigurationInput) (*CreateTargetAccountConfigurationOutput, error) {
	req, out := c.CreateTargetAccountConfigurationRequest(input)
	return out, req.Send()
}

// CreateTargetAccountConfigurationWithContext is the same as CreateTargetAccountConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTargetAccountConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) CreateTargetAccountConfigurationWithContext(ctx aws.Context, input *CreateTargetAccountConfigurationInput, opts ...request.Option) (*CreateTargetAccountConfigurationOutput, error) {
	req, out := c.CreateTargetAccountConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteExperimentTemplate = "DeleteExperimentTemplate"

// DeleteExperimentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteExperimentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteExperimentTemplate for more information on using the DeleteExperimentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteExperimentTemplateRequest method.
//	req, resp := client.DeleteExperimentTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/DeleteExperimentTemplate
func (c *FIS) DeleteExperimentTemplateRequest(input *DeleteExperimentTemplateInput) (req *request.Request, output *DeleteExperimentTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteExperimentTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/experimentTemplates/{id}",
	}

	if input == nil {
		input = &DeleteExperimentTemplateInput{}
	}

	output = &DeleteExperimentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteExperimentTemplate API operation for AWS Fault Injection Simulator.
//
// Deletes the specified experiment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation DeleteExperimentTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/DeleteExperimentTemplate
func (c *FIS) DeleteExperimentTemplate(input *DeleteExperimentTemplateInput) (*DeleteExperimentTemplateOutput, error) {
	req, out := c.DeleteExperimentTemplateRequest(input)
	return out, req.Send()
}

// DeleteExperimentTemplateWithContext is the same as DeleteExperimentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteExperimentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) DeleteExperimentTemplateWithContext(ctx aws.Context, input *DeleteExperimentTemplateInput, opts ...request.Option) (*DeleteExperimentTemplateOutput, error) {
	req, out := c.DeleteExperimentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTargetAccountConfiguration = "DeleteTargetAccountConfiguration"

// DeleteTargetAccountConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTargetAccountConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTargetAccountConfiguration for more information on using the DeleteTargetAccountConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTargetAccountConfigurationRequest method.
//	req, resp := client.DeleteTargetAccountConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/DeleteTargetAccountConfiguration
func (c *FIS) DeleteTargetAccountConfigurationRequest(input *DeleteTargetAccountConfigurationInput) (req *request.Request, output *DeleteTargetAccountConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteTargetAccountConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/experimentTemplates/{id}/targetAccountConfigurations/{accountId}",
	}

	if input == nil {
		input = &DeleteTargetAccountConfigurationInput{}
	}

	output = &DeleteTargetAccountConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTargetAccountConfiguration API operation for AWS Fault Injection Simulator.
//
// Deletes the specified target account configuration of the experiment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation DeleteTargetAccountConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/DeleteTargetAccountConfiguration
func (c *FIS) DeleteTargetAccountConfiguration(input *DeleteTargetAccountConfigurationInput) (*DeleteTargetAccountConfigurationOutput, error) {
	req, out := c.DeleteTargetAccountConfigurationRequest(input)
	return out, req.Send()
}

// DeleteTargetAccountConfigurationWithContext is the same as DeleteTargetAccountConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTargetAccountConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) DeleteTargetAccountConfigurationWithContext(ctx aws.Context, input *DeleteTargetAccountConfigurationInput, opts ...request.Option) (*DeleteTargetAccountConfigurationOutput, error) {
	req, out := c.DeleteTargetAccountConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAction = "GetAction"

// GetActionRequest generates a "aws/request.Request" representing the
// client's request for the GetAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAction for more information on using the GetAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetActionRequest method.
//	req, resp := client.GetActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetAction
func (c *FIS) GetActionRequest(input *GetActionInput) (req *request.Request, output *GetActionOutput) {
	op := &request.Operation{
		Name:       opGetAction,
		HTTPMethod: "GET",
		HTTPPath:   "/actions/{id}",
	}

	if input == nil {
		input = &GetActionInput{}
	}

	output = &GetActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAction API operation for AWS Fault Injection Simulator.
//
// Gets information about the specified FIS action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation GetAction for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetAction
func (c *FIS) GetAction(input *GetActionInput) (*GetActionOutput, error) {
	req, out := c.GetActionRequest(input)
	return out, req.Send()
}

// GetActionWithContext is the same as GetAction with the addition of
// the ability to pass a context and additional request options.
//
// See GetAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) GetActionWithContext(ctx aws.Context, input *GetActionInput, opts ...request.Option) (*GetActionOutput, error) {
	req, out := c.GetActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExperiment = "GetExperiment"

// GetExperimentRequest generates a "aws/request.Request" representing the
// client's request for the GetExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExperiment for more information on using the GetExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExperimentRequest method.
//	req, resp := client.GetExperimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperiment
func (c *FIS) GetExperimentRequest(input *GetExperimentInput) (req *request.Request, output *GetExperimentOutput) {
	op := &request.Operation{
		Name:       opGetExperiment,
		HTTPMethod: "GET",
		HTTPPath:   "/experiments/{id}",
	}

	if input == nil {
		input = &GetExperimentInput{}
	}

	output = &GetExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExperiment API operation for AWS Fault Injection Simulator.
//
// Gets information about the specified experiment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation GetExperiment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperiment
func (c *FIS) GetExperiment(input *GetExperimentInput) (*GetExperimentOutput, error) {
	req, out := c.GetExperimentRequest(input)
	return out, req.Send()
}

// GetExperimentWithContext is the same as GetExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See GetExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) GetExperimentWithContext(ctx aws.Context, input *GetExperimentInput, opts ...request.Option) (*GetExperimentOutput, error) {
	req, out := c.GetExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExperimentTargetAccountConfiguration = "GetExperimentTargetAccountConfiguration"

// GetExperimentTargetAccountConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetExperimentTargetAccountConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExperimentTargetAccountConfiguration for more information on using the GetExperimentTargetAccountConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExperimentTargetAccountConfigurationRequest method.
//	req, resp := client.GetExperimentTargetAccountConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperimentTargetAccountConfiguration
func (c *FIS) GetExperimentTargetAccountConfigurationRequest(input *GetExperimentTargetAccountConfigurationInput) (req *request.Request, output *GetExperimentTargetAccountConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetExperimentTargetAccountConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/experiments/{id}/targetAccountConfigurations/{accountId}",
	}

	if input == nil {
		input = &GetExperimentTargetAccountConfigurationInput{}
	}

	output = &GetExperimentTargetAccountConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExperimentTargetAccountConfiguration API operation for AWS Fault Injection Simulator.
//
// Gets information about the specified target account configuration of the
// experiment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation GetExperimentTargetAccountConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperimentTargetAccountConfiguration
func (c *FIS) GetExperimentTargetAccountConfiguration(input *GetExperimentTargetAccountConfigurationInput) (*GetExperimentTargetAccountConfigurationOutput, error) {
	req, out := c.GetExperimentTargetAccountConfigurationRequest(input)
	return out, req.Send()
}

// GetExperimentTargetAccountConfigurationWithContext is the same as GetExperimentTargetAccountConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetExperimentTargetAccountConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) GetExperimentTargetAccountConfigurationWithContext(ctx aws.Context, input *GetExperimentTargetAccountConfigurationInput, opts ...request.Option) (*GetExperimentTargetAccountConfigurationOutput, error) {
	req, out := c.GetExperimentTargetAccountConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExperimentTemplate = "GetExperimentTemplate"

// GetExperimentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetExperimentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExperimentTemplate for more information on using the GetExperimentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExperimentTemplateRequest method.
//	req, resp := client.GetExperimentTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperimentTemplate
func (c *FIS) GetExperimentTemplateRequest(input *GetExperimentTemplateInput) (req *request.Request, output *GetExperimentTemplateOutput) {
	op := &request.Operation{
		Name:       opGetExperimentTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/experimentTemplates/{id}",
	}

	if input == nil {
		input = &GetExperimentTemplateInput{}
	}

	output = &GetExperimentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExperimentTemplate API operation for AWS Fault Injection Simulator.
//
// Gets information about the specified experiment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation GetExperimentTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperimentTemplate
func (c *FIS) GetExperimentTemplate(input *GetExperimentTemplateInput) (*GetExperimentTemplateOutput, error) {
	req, out := c.GetExperimentTemplateRequest(input)
	return out, req.Send()
}

// GetExperimentTemplateWithContext is the same as GetExperimentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetExperimentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) GetExperimentTemplateWithContext(ctx aws.Context, input *GetExperimentTemplateInput, opts ...request.Option) (*GetExperimentTemplateOutput, error) {
	req, out := c.GetExperimentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTargetAccountConfiguration = "GetTargetAccountConfiguration"

// GetTargetAccountConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetTargetAccountConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTargetAccountConfiguration for more information on using the GetTargetAccountConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTargetAccountConfigurationRequest method.
//	req, resp := client.GetTargetAccountConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetTargetAccountConfiguration
func (c *FIS) GetTargetAccountConfigurationRequest(input *GetTargetAccountConfigurationInput) (req *request.Request, output *GetTargetAccountConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetTargetAccountConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/experimentTemplates/{id}/targetAccountConfigurations/{accountId}",
	}

	if input == nil {
		input = &GetTargetAccountConfigurationInput{}
	}

	output = &GetTargetAccountConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTargetAccountConfiguration API operation for AWS Fault Injection Simulator.
//
// Gets information about the specified target account configuration of the
// experiment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation GetTargetAccountConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetTargetAccountConfiguration
func (c *FIS) GetTargetAccountConfiguration(input *GetTargetAccountConfigurationInput) (*GetTargetAccountConfigurationOutput, error) {
	req, out := c.GetTargetAccountConfigurationRequest(input)
	return out, req.Send()
}

// GetTargetAccountConfigurationWithContext is the same as GetTargetAccountConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetTargetAccountConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) GetTargetAccountConfigurationWithContext(ctx aws.Context, input *GetTargetAccountConfigurationInput, opts ...request.Option) (*GetTargetAccountConfigurationOutput, error) {
	req, out := c.GetTargetAccountConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTargetResourceType = "GetTargetResourceType"

// GetTargetResourceTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetTargetResourceType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTargetResourceType for more information on using the GetTargetResourceType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTargetResourceTypeRequest method.
//	req, resp := client.GetTargetResourceTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetTargetResourceType
func (c *FIS) GetTargetResourceTypeRequest(input *GetTargetResourceTypeInput) (req *request.Request, output *GetTargetResourceTypeOutput) {
	op := &request.Operation{
		Name:       opGetTargetResourceType,
		HTTPMethod: "GET",
		HTTPPath:   "/targetResourceTypes/{resourceType}",
	}

	if input == nil {
		input = &GetTargetResourceTypeInput{}
	}

	output = &GetTargetResourceTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTargetResourceType API operation for AWS Fault Injection Simulator.
//
// Gets information about the specified resource type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation GetTargetResourceType for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetTargetResourceType
func (c *FIS) GetTargetResourceType(input *GetTargetResourceTypeInput) (*GetTargetResourceTypeOutput, error) {
	req, out := c.GetTargetResourceTypeRequest(input)
	return out, req.Send()
}

// GetTargetResourceTypeWithContext is the same as GetTargetResourceType with the addition of
// the ability to pass a context and additional request options.
//
// See GetTargetResourceType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) GetTargetResourceTypeWithContext(ctx aws.Context, input *GetTargetResourceTypeInput, opts ...request.Option) (*GetTargetResourceTypeOutput, error) {
	req, out := c.GetTargetResourceTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListActions = "ListActions"

// ListActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActions for more information on using the ListActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListActionsRequest method.
//	req, resp := client.ListActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListActions
func (c *FIS) ListActionsRequest(input *ListActionsInput) (req *request.Request, output *ListActionsOutput) {
	op := &request.Operation{
		Name:       opListActions,
		HTTPMethod: "GET",
		HTTPPath:   "/actions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListActionsInput{}
	}

	output = &ListActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActions API operation for AWS Fault Injection Simulator.
//
// Lists the available FIS actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation ListActions for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListActions
func (c *FIS) ListActions(input *ListActionsInput) (*ListActionsOutput, error) {
	req, out := c.ListActionsRequest(input)
	return out, req.Send()
}

// ListActionsWithContext is the same as ListActions with the addition of
// the ability to pass a context and additional request options.
//
// See ListActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListActionsWithContext(ctx aws.Context, input *ListActionsInput, opts ...request.Option) (*ListActionsOutput, error) {
	req, out := c.ListActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListActionsPages iterates over the pages of a ListActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListActions operation.
//	pageNum := 0
//	err := client.ListActionsPages(params,
//	    func(page *fis.ListActionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FIS) ListActionsPages(input *ListActionsInput, fn func(*ListActionsOutput, bool) bool) error {
	return c.ListActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListActionsPagesWithContext same as ListActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListActionsPagesWithContext(ctx aws.Context, input *ListActionsInput, fn func(*ListActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExperimentResolvedTargets = "ListExperimentResolvedTargets"

// ListExperimentResolvedTargetsRequest generates a "aws/request.Request" representing the
// client's request for the ListExperimentResolvedTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExperimentResolvedTargets for more information on using the ListExperimentResolvedTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExperimentResolvedTargetsRequest method.
//	req, resp := client.ListExperimentResolvedTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentResolvedTargets
func (c *FIS) ListExperimentResolvedTargetsRequest(input *ListExperimentResolvedTargetsInput) (req *request.Request, output *ListExperimentResolvedTargetsOutput) {
	op := &request.Operation{
		Name:       opListExperimentResolvedTargets,
		HTTPMethod: "GET",
		HTTPPath:   "/experiments/{id}/resolvedTargets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExperimentResolvedTargetsInput{}
	}

	output = &ListExperimentResolvedTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExperimentResolvedTargets API operation for AWS Fault Injection Simulator.
//
// Lists the resolved targets information of the specified experiment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation ListExperimentResolvedTargets for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentResolvedTargets
func (c *FIS) ListExperimentResolvedTargets(input *ListExperimentResolvedTargetsInput) (*ListExperimentResolvedTargetsOutput, error) {
	req, out := c.ListExperimentResolvedTargetsRequest(input)
	return out, req.Send()
}

// ListExperimentResolvedTargetsWithContext is the same as ListExperimentResolvedTargets with the addition of
// the ability to pass a context and additional request options.
//
// See ListExperimentResolvedTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListExperimentResolvedTargetsWithContext(ctx aws.Context, input *ListExperimentResolvedTargetsInput, opts ...request.Option) (*ListExperimentResolvedTargetsOutput, error) {
	req, out := c.ListExperimentResolvedTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExperimentResolvedTargetsPages iterates over the pages of a ListExperimentResolvedTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExperimentResolvedTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExperimentResolvedTargets operation.
//	pageNum := 0
//	err := client.ListExperimentResolvedTargetsPages(params,
//	    func(page *fis.ListExperimentResolvedTargetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FIS) ListExperimentResolvedTargetsPages(input *ListExperimentResolvedTargetsInput, fn func(*ListExperimentResolvedTargetsOutput, bool) bool) error {
	return c.ListExperimentResolvedTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExperimentResolvedTargetsPagesWithContext same as ListExperimentResolvedTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListExperimentResolvedTargetsPagesWithContext(ctx aws.Context, input *ListExperimentResolvedTargetsInput, fn func(*ListExperimentResolvedTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExperimentResolvedTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExperimentResolvedTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExperimentResolvedTargetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExperimentTargetAccountConfigurations = "ListExperimentTargetAccountConfigurations"

// ListExperimentTargetAccountConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListExperimentTargetAccountConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExperimentTargetAccountConfigurations for more information on using the ListExperimentTargetAccountConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExperimentTargetAccountConfigurationsRequest method.
//	req, resp := client.ListExperimentTargetAccountConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTargetAccountConfigurations
func (c *FIS) ListExperimentTargetAccountConfigurationsRequest(input *ListExperimentTargetAccountConfigurationsInput) (req *request.Request, output *ListExperimentTargetAccountConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListExperimentTargetAccountConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/experiments/{id}/targetAccountConfigurations",
	}

	if input == nil {
		input = &ListExperimentTargetAccountConfigurationsInput{}
	}

	output = &ListExperimentTargetAccountConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExperimentTargetAccountConfigurations API operation for AWS Fault Injection Simulator.
//
// Lists the target account configurations of the specified experiment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation ListExperimentTargetAccountConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTargetAccountConfigurations
func (c *FIS) ListExperimentTargetAccountConfigurations(input *ListExperimentTargetAccountConfigurationsInput) (*ListExperimentTargetAccountConfigurationsOutput, error) {
	req, out := c.ListExperimentTargetAccountConfigurationsRequest(input)
	return out, req.Send()
}

// ListExperimentTargetAccountConfigurationsWithContext is the same as ListExperimentTargetAccountConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListExperimentTargetAccountConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListExperimentTargetAccountConfigurationsWithContext(ctx aws.Context, input *ListExperimentTargetAccountConfigurationsInput, opts ...request.Option) (*ListExperimentTargetAccountConfigurationsOutput, error) {
	req, out := c.ListExperimentTargetAccountConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListExperimentTemplates = "ListExperimentTemplates"

// ListExperimentTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListExperimentTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExperimentTemplates for more information on using the ListExperimentTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExperimentTemplatesRequest method.
//	req, resp := client.ListExperimentTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTemplates
func (c *FIS) ListExperimentTemplatesRequest(input *ListExperimentTemplatesInput) (req *request.Request, output *ListExperimentTemplatesOutput) {
	op := &request.Operation{
		Name:       opListExperimentTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/experimentTemplates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExperimentTemplatesInput{}
	}

	output = &ListExperimentTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExperimentTemplates API operation for AWS Fault Injection Simulator.
//
// Lists your experiment templates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation ListExperimentTemplates for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTemplates
func (c *FIS) ListExperimentTemplates(input *ListExperimentTemplatesInput) (*ListExperimentTemplatesOutput, error) {
	req, out := c.ListExperimentTemplatesRequest(input)
	return out, req.Send()
}

// ListExperimentTemplatesWithContext is the same as ListExperimentTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListExperimentTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListExperimentTemplatesWithContext(ctx aws.Context, input *ListExperimentTemplatesInput, opts ...request.Option) (*ListExperimentTemplatesOutput, error) {
	req, out := c.ListExperimentTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExperimentTemplatesPages iterates over the pages of a ListExperimentTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExperimentTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExperimentTemplates operation.
//	pageNum := 0
//	err := client.ListExperimentTemplatesPages(params,
//	    func(page *fis.ListExperimentTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FIS) ListExperimentTemplatesPages(input *ListExperimentTemplatesInput, fn func(*ListExperimentTemplatesOutput, bool) bool) error {
	return c.ListExperimentTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExperimentTemplatesPagesWithContext same as ListExperimentTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListExperimentTemplatesPagesWithContext(ctx aws.Context, input *ListExperimentTemplatesInput, fn func(*ListExperimentTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExperimentTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExperimentTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExperimentTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExperiments = "ListExperiments"

// ListExperimentsRequest generates a "aws/request.Request" representing the
// client's request for the ListExperiments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExperiments for more information on using the ListExperiments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExperimentsRequest method.
//	req, resp := client.ListExperimentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperiments
func (c *FIS) ListExperimentsRequest(input *ListExperimentsInput) (req *request.Request, output *ListExperimentsOutput) {
	op := &request.Operation{
		Name:       opListExperiments,
		HTTPMethod: "GET",
		HTTPPath:   "/experiments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExperimentsInput{}
	}

	output = &ListExperimentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExperiments API operation for AWS Fault Injection Simulator.
//
// Lists your experiments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation ListExperiments for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperiments
func (c *FIS) ListExperiments(input *ListExperimentsInput) (*ListExperimentsOutput, error) {
	req, out := c.ListExperimentsRequest(input)
	return out, req.Send()
}

// ListExperimentsWithContext is the same as ListExperiments with the addition of
// the ability to pass a context and additional request options.
//
// See ListExperiments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListExperimentsWithContext(ctx aws.Context, input *ListExperimentsInput, opts ...request.Option) (*ListExperimentsOutput, error) {
	req, out := c.ListExperimentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExperimentsPages iterates over the pages of a ListExperiments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExperiments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExperiments operation.
//	pageNum := 0
//	err := client.ListExperimentsPages(params,
//	    func(page *fis.ListExperimentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FIS) ListExperimentsPages(input *ListExperimentsInput, fn func(*ListExperimentsOutput, bool) bool) error {
	return c.ListExperimentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExperimentsPagesWithContext same as ListExperimentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListExperimentsPagesWithContext(ctx aws.Context, input *ListExperimentsInput, fn func(*ListExperimentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExperimentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExperimentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExperimentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTagsForResource
func (c *FIS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Fault Injection Simulator.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation ListTagsForResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTagsForResource
func (c *FIS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargetAccountConfigurations = "ListTargetAccountConfigurations"

// ListTargetAccountConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetAccountConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargetAccountConfigurations for more information on using the ListTargetAccountConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTargetAccountConfigurationsRequest method.
//	req, resp := client.ListTargetAccountConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTargetAccountConfigurations
func (c *FIS) ListTargetAccountConfigurationsRequest(input *ListTargetAccountConfigurationsInput) (req *request.Request, output *ListTargetAccountConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListTargetAccountConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/experimentTemplates/{id}/targetAccountConfigurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTargetAccountConfigurationsInput{}
	}

	output = &ListTargetAccountConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetAccountConfigurations API operation for AWS Fault Injection Simulator.
//
// Lists the target account configurations of the specified experiment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation ListTargetAccountConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTargetAccountConfigurations
func (c *FIS) ListTargetAccountConfigurations(input *ListTargetAccountConfigurationsInput) (*ListTargetAccountConfigurationsOutput, error) {
	req, out := c.ListTargetAccountConfigurationsRequest(input)
	return out, req.Send()
}

// ListTargetAccountConfigurationsWithContext is the same as ListTargetAccountConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetAccountConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListTargetAccountConfigurationsWithContext(ctx aws.Context, input *ListTargetAccountConfigurationsInput, opts ...request.Option) (*ListTargetAccountConfigurationsOutput, error) {
	req, out := c.ListTargetAccountConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTargetAccountConfigurationsPages iterates over the pages of a ListTargetAccountConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTargetAccountConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTargetAccountConfigurations operation.
//	pageNum := 0
//	err := client.ListTargetAccountConfigurationsPages(params,
//	    func(page *fis.ListTargetAccountConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FIS) ListTargetAccountConfigurationsPages(input *ListTargetAccountConfigurationsInput, fn func(*ListTargetAccountConfigurationsOutput, bool) bool) error {
	return c.ListTargetAccountConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTargetAccountConfigurationsPagesWithContext same as ListTargetAccountConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListTargetAccountConfigurationsPagesWithContext(ctx aws.Context, input *ListTargetAccountConfigurationsInput, fn func(*ListTargetAccountConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTargetAccountConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTargetAccountConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTargetAccountConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTargetResourceTypes = "ListTargetResourceTypes"

// ListTargetResourceTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetResourceTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargetResourceTypes for more information on using the ListTargetResourceTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTargetResourceTypesRequest method.
//	req, resp := client.ListTargetResourceTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTargetResourceTypes
func (c *FIS) ListTargetResourceTypesRequest(input *ListTargetResourceTypesInput) (req *request.Request, output *ListTargetResourceTypesOutput) {
	op := &request.Operation{
		Name:       opListTargetResourceTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/targetResourceTypes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTargetResourceTypesInput{}
	}

	output = &ListTargetResourceTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetResourceTypes API operation for AWS Fault Injection Simulator.
//
// Lists the target resource types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation ListTargetResourceTypes for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTargetResourceTypes
func (c *FIS) ListTargetResourceTypes(input *ListTargetResourceTypesInput) (*ListTargetResourceTypesOutput, error) {
	req, out := c.ListTargetResourceTypesRequest(input)
	return out, req.Send()
}

// ListTargetResourceTypesWithContext is the same as ListTargetResourceTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetResourceTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListTargetResourceTypesWithContext(ctx aws.Context, input *ListTargetResourceTypesInput, opts ...request.Option) (*ListTargetResourceTypesOutput, error) {
	req, out := c.ListTargetResourceTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTargetResourceTypesPages iterates over the pages of a ListTargetResourceTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTargetResourceTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTargetResourceTypes operation.
//	pageNum := 0
//	err := client.ListTargetResourceTypesPages(params,
//	    func(page *fis.ListTargetResourceTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FIS) ListTargetResourceTypesPages(input *ListTargetResourceTypesInput, fn func(*ListTargetResourceTypesOutput, bool) bool) error {
	return c.ListTargetResourceTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTargetResourceTypesPagesWithContext same as ListTargetResourceTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListTargetResourceTypesPagesWithContext(ctx aws.Context, input *ListTargetResourceTypesInput, fn func(*ListTargetResourceTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTargetResourceTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTargetResourceTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTargetResourceTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartExperiment = "StartExperiment"

// StartExperimentRequest generates a "aws/request.Request" representing the
// client's request for the StartExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartExperiment for more information on using the StartExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartExperimentRequest method.
//	req, resp := client.StartExperimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StartExperiment
func (c *FIS) StartExperimentRequest(input *StartExperimentInput) (req *request.Request, output *StartExperimentOutput) {
	op := &request.Operation{
		Name:       opStartExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/experiments",
	}

	if input == nil {
		input = &StartExperimentInput{}
	}

	output = &StartExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartExperiment API operation for AWS Fault Injection Simulator.
//
// Starts running an experiment from the specified experiment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation StartExperiment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ConflictException
//     The request could not be processed because of a conflict.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StartExperiment
func (c *FIS) StartExperiment(input *StartExperimentInput) (*StartExperimentOutput, error) {
	req, out := c.StartExperimentRequest(input)
	return out, req.Send()
}

// StartExperimentWithContext is the same as StartExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See StartExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) StartExperimentWithContext(ctx aws.Context, input *StartExperimentInput, opts ...request.Option) (*StartExperimentOutput, error) {
	req, out := c.StartExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopExperiment = "StopExperiment"

// StopExperimentRequest generates a "aws/request.Request" representing the
// client's request for the StopExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopExperiment for more information on using the StopExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopExperimentRequest method.
//	req, resp := client.StopExperimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StopExperiment
func (c *FIS) StopExperimentRequest(input *StopExperimentInput) (req *request.Request, output *StopExperimentOutput) {
	op := &request.Operation{
		Name:       opStopExperiment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/experiments/{id}",
	}

	if input == nil {
		input = &StopExperimentInput{}
	}

	output = &StopExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopExperiment API operation for AWS Fault Injection Simulator.
//
// Stops the specified experiment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation StopExperiment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StopExperiment
func (c *FIS) StopExperiment(input *StopExperimentInput) (*StopExperimentOutput, error) {
	req, out := c.StopExperimentRequest(input)
	return out, req.Send()
}

// StopExperimentWithContext is the same as StopExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See StopExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) StopExperimentWithContext(ctx aws.Context, input *StopExperimentInput, opts ...request.Option) (*StopExperimentOutput, error) {
	req, out := c.StopExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/TagResource
func (c *FIS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Fault Injection Simulator.
//
// Applies the specified tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation TagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/TagResource
func (c *FIS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UntagResource
func (c *FIS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Fault Injection Simulator.
//
// Removes the specified tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation UntagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UntagResource
func (c *FIS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateExperimentTemplate = "UpdateExperimentTemplate"

// UpdateExperimentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateExperimentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateExperimentTemplate for more information on using the UpdateExperimentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateExperimentTemplateRequest method.
//	req, resp := client.UpdateExperimentTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UpdateExperimentTemplate
func (c *FIS) UpdateExperimentTemplateRequest(input *UpdateExperimentTemplateInput) (req *request.Request, output *UpdateExperimentTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateExperimentTemplate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/experimentTemplates/{id}",
	}

	if input == nil {
		input = &UpdateExperimentTemplateInput{}
	}

	output = &UpdateExperimentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateExperimentTemplate API operation for AWS Fault Injection Simulator.
//
// Updates the specified experiment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation UpdateExperimentTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UpdateExperimentTemplate
func (c *FIS) UpdateExperimentTemplate(input *UpdateExperimentTemplateInput) (*UpdateExperimentTemplateOutput, error) {
	req, out := c.UpdateExperimentTemplateRequest(input)
	return out, req.Send()
}

// UpdateExperimentTemplateWithContext is the same as UpdateExperimentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateExperimentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) UpdateExperimentTemplateWithContext(ctx aws.Context, input *UpdateExperimentTemplateInput, opts ...request.Option) (*UpdateExperimentTemplateOutput, error) {
	req, out := c.UpdateExperimentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTargetAccountConfiguration = "UpdateTargetAccountConfiguration"

// UpdateTargetAccountConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTargetAccountConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTargetAccountConfiguration for more information on using the UpdateTargetAccountConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTargetAccountConfigurationRequest method.
//	req, resp := client.UpdateTargetAccountConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UpdateTargetAccountConfiguration
func (c *FIS) UpdateTargetAccountConfigurationRequest(input *UpdateTargetAccountConfigurationInput) (req *request.Request, output *UpdateTargetAccountConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateTargetAccountConfiguration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/experimentTemplates/{id}/targetAccountConfigurations/{accountId}",
	}

	if input == nil {
		input = &UpdateTargetAccountConfigurationInput{}
	}

	output = &UpdateTargetAccountConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTargetAccountConfiguration API operation for AWS Fault Injection Simulator.
//
// Updates the target account configuration for the specified experiment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation UpdateTargetAccountConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The specified input is not valid, or fails to satisfy the constraints for
//     the request.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UpdateTargetAccountConfiguration
func (c *FIS) UpdateTargetAccountConfiguration(input *UpdateTargetAccountConfigurationInput) (*UpdateTargetAccountConfigurationOutput, error) {
	req, out := c.UpdateTargetAccountConfigurationRequest(input)
	return out, req.Send()
}

// UpdateTargetAccountConfigurationWithContext is the same as UpdateTargetAccountConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTargetAccountConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) UpdateTargetAccountConfigurationWithContext(ctx aws.Context, input *UpdateTargetAccountConfigurationInput, opts ...request.Option) (*UpdateTargetAccountConfigurationOutput, error) {
	req, out := c.UpdateTargetAccountConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes an action. For more information, see FIS actions (https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html)
// in the Fault Injection Service User Guide.
type Action struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the action.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The description for the action.
	Description *string `locationName:"description" type:"string"`

	// The ID of the action.
	Id *string `locationName:"id" type:"string"`

	// The action parameters, if applicable.
	Parameters map[string]*ActionParameter `locationName:"parameters" type:"map"`

	// The tags for the action.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The supported targets for the action.
	Targets map[string]*ActionTarget `locationName:"targets" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Action) SetArn(v string) *Action {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Action) SetDescription(v string) *Action {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Action) SetId(v string) *Action {
	s.Id = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Action) SetParameters(v map[string]*ActionParameter) *Action {
	s.Parameters = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Action) SetTags(v map[string]*string) *Action {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Action) SetTargets(v map[string]*ActionTarget) *Action {
	s.Targets = v
	return s
}

// Describes a parameter for an action.
type ActionParameter struct {
	_ struct{} `type:"structure"`

	// The parameter description.
	Description *string `locationName:"description" type:"string"`

	// Indicates whether the parameter is required.
	Required *bool `locationName:"required" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionParameter) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ActionParameter) SetDescription(v string) *ActionParameter {
	s.Description = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *ActionParameter) SetRequired(v bool) *ActionParameter {
	s.Required = &v
	return s
}

// Provides a summary of an action.
type ActionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the action.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The description for the action.
	Description *string `locationName:"description" type:"string"`

	// The ID of the action.
	Id *string `locationName:"id" type:"string"`

	// The tags for the action.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The targets for the action.
	Targets map[string]*ActionTarget `locationName:"targets" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ActionSummary) SetArn(v string) *ActionSummary {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ActionSummary) SetDescription(v string) *ActionSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ActionSummary) SetId(v string) *ActionSummary {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ActionSummary) SetTags(v map[string]*string) *ActionSummary {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ActionSummary) SetTargets(v map[string]*ActionTarget) *ActionSummary {
	s.Targets = v
	return s
}

// Describes a target for an action.
type ActionTarget struct {
	_ struct{} `type:"structure"`

	// The resource type of the target.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTarget) GoString() string {
	return s.String()
}

// SetResourceType sets the ResourceType field's value.
func (s *ActionTarget) SetResourceType(v string) *ActionTarget {
	s.ResourceType = &v
	return s
}

// The request could not be processed because of a conflict.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies an action for an experiment template.
//
// For more information, see Actions (https://docs.aws.amazon.com/fis/latest/userguide/actions.html)
// in the Fault Injection Service User Guide.
type CreateExperimentTemplateActionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the action. The format of the action ID is: aws:service-name:action-type.
	//
	// ActionId is a required field
	ActionId *string `locationName:"actionId" type:"string" required:"true"`

	// A description for the action.
	Description *string `locationName:"description" type:"string"`

	// The parameters for the action, if applicable.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The name of the action that must be completed before the current action starts.
	// Omit this parameter to run the action at the start of the experiment.
	StartAfter []*string `locationName:"startAfter" type:"list"`

	// The targets for the action.
	Targets map[string]*string `locationName:"targets" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExperimentTemplateActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExperimentTemplateActionInput"}
	if s.ActionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionId sets the ActionId field's value.
func (s *CreateExperimentTemplateActionInput) SetActionId(v string) *CreateExperimentTemplateActionInput {
	s.ActionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateExperimentTemplateActionInput) SetDescription(v string) *CreateExperimentTemplateActionInput {
	s.Description = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateExperimentTemplateActionInput) SetParameters(v map[string]*string) *CreateExperimentTemplateActionInput {
	s.Parameters = v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *CreateExperimentTemplateActionInput) SetStartAfter(v []*string) *CreateExperimentTemplateActionInput {
	s.StartAfter = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateExperimentTemplateActionInput) SetTargets(v map[string]*string) *CreateExperimentTemplateActionInput {
	s.Targets = v
	return s
}

// Specifies experiment options for an experiment template.
type CreateExperimentTemplateExperimentOptionsInput_ struct {
	_ struct{} `type:"structure"`

	// Specifies the account targeting setting for experiment options.
	AccountTargeting *string `locationName:"accountTargeting" type:"string" enum:"AccountTargeting"`

	// Specifies the empty target resolution mode for experiment options.
	EmptyTargetResolutionMode *string `locationName:"emptyTargetResolutionMode" type:"string" enum:"EmptyTargetResolutionMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateExperimentOptionsInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateExperimentOptionsInput_) GoString() string {
	return s.String()
}

// SetAccountTargeting sets the AccountTargeting field's value.
func (s *CreateExperimentTemplateExperimentOptionsInput_) SetAccountTargeting(v string) *CreateExperimentTemplateExperimentOptionsInput_ {
	s.AccountTargeting = &v
	return s
}

// SetEmptyTargetResolutionMode sets the EmptyTargetResolutionMode field's value.
func (s *CreateExperimentTemplateExperimentOptionsInput_) SetEmptyTargetResolutionMode(v string) *CreateExperimentTemplateExperimentOptionsInput_ {
	s.EmptyTargetResolutionMode = &v
	return s
}

type CreateExperimentTemplateInput struct {
	_ struct{} `type:"structure"`

	// The actions for the experiment.
	//
	// Actions is a required field
	Actions map[string]*CreateExperimentTemplateActionInput `locationName:"actions" type:"map" required:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description for the experiment template.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The experiment options for the experiment template.
	ExperimentOptions *CreateExperimentTemplateExperimentOptionsInput_ `locationName:"experimentOptions" type:"structure"`

	// The configuration for experiment logging.
	LogConfiguration *CreateExperimentTemplateLogConfigurationInput_ `locationName:"logConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that grants the FIS service
	// permission to perform service actions on your behalf.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The stop conditions.
	//
	// StopConditions is a required field
	StopConditions []*CreateExperimentTemplateStopConditionInput `locationName:"stopConditions" type:"list" required:"true"`

	// The tags to apply to the experiment template.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The targets for the experiment.
	Targets map[string]*CreateExperimentTemplateTargetInput `locationName:"targets" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExperimentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExperimentTemplateInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.StopConditions == nil {
		invalidParams.Add(request.NewErrParamRequired("StopConditions"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LogConfiguration != nil {
		if err := s.LogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LogConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.StopConditions != nil {
		for i, v := range s.StopConditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StopConditions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CreateExperimentTemplateInput) SetActions(v map[string]*CreateExperimentTemplateActionInput) *CreateExperimentTemplateInput {
	s.Actions = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateExperimentTemplateInput) SetClientToken(v string) *CreateExperimentTemplateInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateExperimentTemplateInput) SetDescription(v string) *CreateExperimentTemplateInput {
	s.Description = &v
	return s
}

// SetExperimentOptions sets the ExperimentOptions field's value.
func (s *CreateExperimentTemplateInput) SetExperimentOptions(v *CreateExperimentTemplateExperimentOptionsInput_) *CreateExperimentTemplateInput {
	s.ExperimentOptions = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *CreateExperimentTemplateInput) SetLogConfiguration(v *CreateExperimentTemplateLogConfigurationInput_) *CreateExperimentTemplateInput {
	s.LogConfiguration = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateExperimentTemplateInput) SetRoleArn(v string) *CreateExperimentTemplateInput {
	s.RoleArn = &v
	return s
}

// SetStopConditions sets the StopConditions field's value.
func (s *CreateExperimentTemplateInput) SetStopConditions(v []*CreateExperimentTemplateStopConditionInput) *CreateExperimentTemplateInput {
	s.StopConditions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateExperimentTemplateInput) SetTags(v map[string]*string) *CreateExperimentTemplateInput {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateExperimentTemplateInput) SetTargets(v map[string]*CreateExperimentTemplateTargetInput) *CreateExperimentTemplateInput {
	s.Targets = v
	return s
}

// Specifies the configuration for experiment logging.
type CreateExperimentTemplateLogConfigurationInput_ struct {
	_ struct{} `type:"structure"`

	// The configuration for experiment logging to Amazon CloudWatch Logs.
	CloudWatchLogsConfiguration *ExperimentTemplateCloudWatchLogsLogConfigurationInput_ `locationName:"cloudWatchLogsConfiguration" type:"structure"`

	// The schema version.
	//
	// LogSchemaVersion is a required field
	LogSchemaVersion *int64 `locationName:"logSchemaVersion" type:"integer" required:"true"`

	// The configuration for experiment logging to Amazon S3.
	S3Configuration *ExperimentTemplateS3LogConfigurationInput_ `locationName:"s3Configuration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateLogConfigurationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateLogConfigurationInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExperimentTemplateLogConfigurationInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExperimentTemplateLogConfigurationInput_"}
	if s.LogSchemaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("LogSchemaVersion"))
	}
	if s.CloudWatchLogsConfiguration != nil {
		if err := s.CloudWatchLogsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsConfiguration sets the CloudWatchLogsConfiguration field's value.
func (s *CreateExperimentTemplateLogConfigurationInput_) SetCloudWatchLogsConfiguration(v *ExperimentTemplateCloudWatchLogsLogConfigurationInput_) *CreateExperimentTemplateLogConfigurationInput_ {
	s.CloudWatchLogsConfiguration = v
	return s
}

// SetLogSchemaVersion sets the LogSchemaVersion field's value.
func (s *CreateExperimentTemplateLogConfigurationInput_) SetLogSchemaVersion(v int64) *CreateExperimentTemplateLogConfigurationInput_ {
	s.LogSchemaVersion = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *CreateExperimentTemplateLogConfigurationInput_) SetS3Configuration(v *ExperimentTemplateS3LogConfigurationInput_) *CreateExperimentTemplateLogConfigurationInput_ {
	s.S3Configuration = v
	return s
}

type CreateExperimentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment template.
	ExperimentTemplate *ExperimentTemplate `locationName:"experimentTemplate" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateOutput) GoString() string {
	return s.String()
}

// SetExperimentTemplate sets the ExperimentTemplate field's value.
func (s *CreateExperimentTemplateOutput) SetExperimentTemplate(v *ExperimentTemplate) *CreateExperimentTemplateOutput {
	s.ExperimentTemplate = v
	return s
}

// Specifies a stop condition for an experiment template.
type CreateExperimentTemplateStopConditionInput struct {
	_ struct{} `type:"structure"`

	// The source for the stop condition. Specify aws:cloudwatch:alarm if the stop
	// condition is defined by a CloudWatch alarm. Specify none if there is no stop
	// condition.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the CloudWatch alarm. This is required
	// if the source is a CloudWatch alarm.
	Value *string `locationName:"value" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateStopConditionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateStopConditionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExperimentTemplateStopConditionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExperimentTemplateStopConditionInput"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Value != nil && len(*s.Value) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *CreateExperimentTemplateStopConditionInput) SetSource(v string) *CreateExperimentTemplateStopConditionInput {
	s.Source = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CreateExperimentTemplateStopConditionInput) SetValue(v string) *CreateExperimentTemplateStopConditionInput {
	s.Value = &v
	return s
}

// Specifies a target for an experiment. You must specify at least one Amazon
// Resource Name (ARN) or at least one resource tag. You cannot specify both
// ARNs and tags.
//
// For more information, see Targets (https://docs.aws.amazon.com/fis/latest/userguide/targets.html)
// in the Fault Injection Service User Guide.
type CreateExperimentTemplateTargetInput struct {
	_ struct{} `type:"structure"`

	// The filters to apply to identify target resources using specific attributes.
	Filters []*ExperimentTemplateTargetInputFilter `locationName:"filters" type:"list"`

	// The resource type parameters.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The Amazon Resource Names (ARNs) of the resources.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// The tags for the target resources.
	ResourceTags map[string]*string `locationName:"resourceTags" type:"map"`

	// The resource type. The resource type must be supported for the specified
	// action.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// Scopes the identified resources to a specific count of the resources at random,
	// or a percentage of the resources. All identified resources are included in
	// the target.
	//
	//    * ALL - Run the action on all identified targets. This is the default.
	//
	//    * COUNT(n) - Run the action on the specified number of targets, chosen
	//    from the identified targets at random. For example, COUNT(1) selects one
	//    of the targets.
	//
	//    * PERCENT(n) - Run the action on the specified percentage of targets,
	//    chosen from the identified targets at random. For example, PERCENT(25)
	//    selects 25% of the targets.
	//
	// SelectionMode is a required field
	SelectionMode *string `locationName:"selectionMode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentTemplateTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExperimentTemplateTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExperimentTemplateTargetInput"}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.SelectionMode == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectionMode"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *CreateExperimentTemplateTargetInput) SetFilters(v []*ExperimentTemplateTargetInputFilter) *CreateExperimentTemplateTargetInput {
	s.Filters = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateExperimentTemplateTargetInput) SetParameters(v map[string]*string) *CreateExperimentTemplateTargetInput {
	s.Parameters = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *CreateExperimentTemplateTargetInput) SetResourceArns(v []*string) *CreateExperimentTemplateTargetInput {
	s.ResourceArns = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *CreateExperimentTemplateTargetInput) SetResourceTags(v map[string]*string) *CreateExperimentTemplateTargetInput {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CreateExperimentTemplateTargetInput) SetResourceType(v string) *CreateExperimentTemplateTargetInput {
	s.ResourceType = &v
	return s
}

// SetSelectionMode sets the SelectionMode field's value.
func (s *CreateExperimentTemplateTargetInput) SetSelectionMode(v string) *CreateExperimentTemplateTargetInput {
	s.SelectionMode = &v
	return s
}

type CreateTargetAccountConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the target account.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" min:"12" type:"string" required:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the target account.
	Description *string `locationName:"description" type:"string"`

	// The experiment template ID.
	//
	// ExperimentTemplateId is a required field
	ExperimentTemplateId *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role for the target account.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTargetAccountConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTargetAccountConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTargetAccountConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTargetAccountConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ExperimentTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentTemplateId"))
	}
	if s.ExperimentTemplateId != nil && len(*s.ExperimentTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentTemplateId", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateTargetAccountConfigurationInput) SetAccountId(v string) *CreateTargetAccountConfigurationInput {
	s.AccountId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTargetAccountConfigurationInput) SetClientToken(v string) *CreateTargetAccountConfigurationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateTargetAccountConfigurationInput) SetDescription(v string) *CreateTargetAccountConfigurationInput {
	s.Description = &v
	return s
}

// SetExperimentTemplateId sets the ExperimentTemplateId field's value.
func (s *CreateTargetAccountConfigurationInput) SetExperimentTemplateId(v string) *CreateTargetAccountConfigurationInput {
	s.ExperimentTemplateId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateTargetAccountConfigurationInput) SetRoleArn(v string) *CreateTargetAccountConfigurationInput {
	s.RoleArn = &v
	return s
}

type CreateTargetAccountConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the target account configuration.
	TargetAccountConfiguration *TargetAccountConfiguration `locationName:"targetAccountConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTargetAccountConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTargetAccountConfigurationOutput) GoString() string {
	return s.String()
}

// SetTargetAccountConfiguration sets the TargetAccountConfiguration field's value.
func (s *CreateTargetAccountConfigurationOutput) SetTargetAccountConfiguration(v *TargetAccountConfiguration) *CreateTargetAccountConfigurationOutput {
	s.TargetAccountConfiguration = v
	return s
}

type DeleteExperimentTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the experiment template.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExperimentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExperimentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteExperimentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteExperimentTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteExperimentTemplateInput) SetId(v string) *DeleteExperimentTemplateInput {
	s.Id = &v
	return s
}

type DeleteExperimentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment template.
	ExperimentTemplate *ExperimentTemplate `locationName:"experimentTemplate" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExperimentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExperimentTemplateOutput) GoString() string {
	return s.String()
}

// SetExperimentTemplate sets the ExperimentTemplate field's value.
func (s *DeleteExperimentTemplateOutput) SetExperimentTemplate(v *ExperimentTemplate) *DeleteExperimentTemplateOutput {
	s.ExperimentTemplate = v
	return s
}

type DeleteTargetAccountConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Web Services account ID of the target account.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" min:"12" type:"string" required:"true"`

	// The ID of the experiment template.
	//
	// ExperimentTemplateId is a required field
	ExperimentTemplateId *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTargetAccountConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTargetAccountConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTargetAccountConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTargetAccountConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.ExperimentTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentTemplateId"))
	}
	if s.ExperimentTemplateId != nil && len(*s.ExperimentTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentTemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteTargetAccountConfigurationInput) SetAccountId(v string) *DeleteTargetAccountConfigurationInput {
	s.AccountId = &v
	return s
}

// SetExperimentTemplateId sets the ExperimentTemplateId field's value.
func (s *DeleteTargetAccountConfigurationInput) SetExperimentTemplateId(v string) *DeleteTargetAccountConfigurationInput {
	s.ExperimentTemplateId = &v
	return s
}

type DeleteTargetAccountConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the target account configuration.
	TargetAccountConfiguration *TargetAccountConfiguration `locationName:"targetAccountConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTargetAccountConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTargetAccountConfigurationOutput) GoString() string {
	return s.String()
}

// SetTargetAccountConfiguration sets the TargetAccountConfiguration field's value.
func (s *DeleteTargetAccountConfigurationOutput) SetTargetAccountConfiguration(v *TargetAccountConfiguration) *DeleteTargetAccountConfigurationOutput {
	s.TargetAccountConfiguration = v
	return s
}

// Describes an experiment.
type Experiment struct {
	_ struct{} `type:"structure"`

	// The actions for the experiment.
	Actions map[string]*ExperimentAction `locationName:"actions" type:"map"`

	// The Amazon Resource Name (ARN) of the experiment.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The time that the experiment was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The time that the experiment ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The experiment options for the experiment.
	ExperimentOptions *ExperimentOptions `locationName:"experimentOptions" type:"structure"`

	// The ID of the experiment template.
	ExperimentTemplateId *string `locationName:"experimentTemplateId" type:"string"`

	// The ID of the experiment.
	Id *string `locationName:"id" type:"string"`

	// The configuration for experiment logging.
	LogConfiguration *ExperimentLogConfiguration `locationName:"logConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that grants the FIS service
	// permission to perform service actions on your behalf.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The time that the experiment started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The state of the experiment.
	State *ExperimentState `locationName:"state" type:"structure"`

	// The stop conditions for the experiment.
	StopConditions []*ExperimentStopCondition `locationName:"stopConditions" type:"list"`

	// The tags for the experiment.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The count of target account configurations for the experiment.
	TargetAccountConfigurationsCount *int64 `locationName:"targetAccountConfigurationsCount" type:"long"`

	// The targets for the experiment.
	Targets map[string]*ExperimentTarget `locationName:"targets" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Experiment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Experiment) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *Experiment) SetActions(v map[string]*ExperimentAction) *Experiment {
	s.Actions = v
	return s
}

// SetArn sets the Arn field's value.
func (s *Experiment) SetArn(v string) *Experiment {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Experiment) SetCreationTime(v time.Time) *Experiment {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Experiment) SetEndTime(v time.Time) *Experiment {
	s.EndTime = &v
	return s
}

// SetExperimentOptions sets the ExperimentOptions field's value.
func (s *Experiment) SetExperimentOptions(v *ExperimentOptions) *Experiment {
	s.ExperimentOptions = v
	return s
}

// SetExperimentTemplateId sets the ExperimentTemplateId field's value.
func (s *Experiment) SetExperimentTemplateId(v string) *Experiment {
	s.ExperimentTemplateId = &v
	return s
}

// SetId sets the Id field's value.
func (s *Experiment) SetId(v string) *Experiment {
	s.Id = &v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *Experiment) SetLogConfiguration(v *ExperimentLogConfiguration) *Experiment {
	s.LogConfiguration = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Experiment) SetRoleArn(v string) *Experiment {
	s.RoleArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Experiment) SetStartTime(v time.Time) *Experiment {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Experiment) SetState(v *ExperimentState) *Experiment {
	s.State = v
	return s
}

// SetStopConditions sets the StopConditions field's value.
func (s *Experiment) SetStopConditions(v []*ExperimentStopCondition) *Experiment {
	s.StopConditions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Experiment) SetTags(v map[string]*string) *Experiment {
	s.Tags = v
	return s
}

// SetTargetAccountConfigurationsCount sets the TargetAccountConfigurationsCount field's value.
func (s *Experiment) SetTargetAccountConfigurationsCount(v int64) *Experiment {
	s.TargetAccountConfigurationsCount = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Experiment) SetTargets(v map[string]*ExperimentTarget) *Experiment {
	s.Targets = v
	return s
}

// Describes the action for an experiment.
type ExperimentAction struct {
	_ struct{} `type:"structure"`

	// The ID of the action.
	ActionId *string `locationName:"actionId" type:"string"`

	// The description for the action.
	Description *string `locationName:"description" type:"string"`

	// The time that the action ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The parameters for the action.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The name of the action that must be completed before this action starts.
	StartAfter []*string `locationName:"startAfter" type:"list"`

	// The time that the action started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The state of the action.
	State *ExperimentActionState `locationName:"state" type:"structure"`

	// The targets for the action.
	Targets map[string]*string `locationName:"targets" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentAction) GoString() string {
	return s.String()
}

// SetActionId sets the ActionId field's value.
func (s *ExperimentAction) SetActionId(v string) *ExperimentAction {
	s.ActionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ExperimentAction) SetDescription(v string) *ExperimentAction {
	s.Description = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ExperimentAction) SetEndTime(v time.Time) *ExperimentAction {
	s.EndTime = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ExperimentAction) SetParameters(v map[string]*string) *ExperimentAction {
	s.Parameters = v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *ExperimentAction) SetStartAfter(v []*string) *ExperimentAction {
	s.StartAfter = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ExperimentAction) SetStartTime(v time.Time) *ExperimentAction {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ExperimentAction) SetState(v *ExperimentActionState) *ExperimentAction {
	s.State = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ExperimentAction) SetTargets(v map[string]*string) *ExperimentAction {
	s.Targets = v
	return s
}

// Describes the state of an action.
type ExperimentActionState struct {
	_ struct{} `type:"structure"`

	// The reason for the state.
	Reason *string `locationName:"reason" type:"string"`

	// The state of the action.
	Status *string `locationName:"status" type:"string" enum:"ExperimentActionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentActionState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentActionState) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *ExperimentActionState) SetReason(v string) *ExperimentActionState {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExperimentActionState) SetStatus(v string) *ExperimentActionState {
	s.Status = &v
	return s
}

// Describes the configuration for experiment logging to Amazon CloudWatch Logs.
type ExperimentCloudWatchLogsLogConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination Amazon CloudWatch Logs
	// log group.
	LogGroupArn *string `locationName:"logGroupArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentCloudWatchLogsLogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentCloudWatchLogsLogConfiguration) GoString() string {
	return s.String()
}

// SetLogGroupArn sets the LogGroupArn field's value.
func (s *ExperimentCloudWatchLogsLogConfiguration) SetLogGroupArn(v string) *ExperimentCloudWatchLogsLogConfiguration {
	s.LogGroupArn = &v
	return s
}

// Describes the configuration for experiment logging.
type ExperimentLogConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration for experiment logging to Amazon CloudWatch Logs.
	CloudWatchLogsConfiguration *ExperimentCloudWatchLogsLogConfiguration `locationName:"cloudWatchLogsConfiguration" type:"structure"`

	// The schema version.
	LogSchemaVersion *int64 `locationName:"logSchemaVersion" type:"integer"`

	// The configuration for experiment logging to Amazon S3.
	S3Configuration *ExperimentS3LogConfiguration `locationName:"s3Configuration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentLogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentLogConfiguration) GoString() string {
	return s.String()
}

// SetCloudWatchLogsConfiguration sets the CloudWatchLogsConfiguration field's value.
func (s *ExperimentLogConfiguration) SetCloudWatchLogsConfiguration(v *ExperimentCloudWatchLogsLogConfiguration) *ExperimentLogConfiguration {
	s.CloudWatchLogsConfiguration = v
	return s
}

// SetLogSchemaVersion sets the LogSchemaVersion field's value.
func (s *ExperimentLogConfiguration) SetLogSchemaVersion(v int64) *ExperimentLogConfiguration {
	s.LogSchemaVersion = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *ExperimentLogConfiguration) SetS3Configuration(v *ExperimentS3LogConfiguration) *ExperimentLogConfiguration {
	s.S3Configuration = v
	return s
}

// Describes the options for an experiment.
type ExperimentOptions struct {
	_ struct{} `type:"structure"`

	// The account targeting setting for an experiment.
	AccountTargeting *string `locationName:"accountTargeting" type:"string" enum:"AccountTargeting"`

	// The actions mode of the experiment that is set from the StartExperiment API
	// command.
	ActionsMode *string `locationName:"actionsMode" type:"string" enum:"ActionsMode"`

	// The empty target resolution mode for an experiment.
	EmptyTargetResolutionMode *string `locationName:"emptyTargetResolutionMode" type:"string" enum:"EmptyTargetResolutionMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentOptions) GoString() string {
	return s.String()
}

// SetAccountTargeting sets the AccountTargeting field's value.
func (s *ExperimentOptions) SetAccountTargeting(v string) *ExperimentOptions {
	s.AccountTargeting = &v
	return s
}

// SetActionsMode sets the ActionsMode field's value.
func (s *ExperimentOptions) SetActionsMode(v string) *ExperimentOptions {
	s.ActionsMode = &v
	return s
}

// SetEmptyTargetResolutionMode sets the EmptyTargetResolutionMode field's value.
func (s *ExperimentOptions) SetEmptyTargetResolutionMode(v string) *ExperimentOptions {
	s.EmptyTargetResolutionMode = &v
	return s
}

// Describes the configuration for experiment logging to Amazon S3.
type ExperimentS3LogConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the destination bucket.
	BucketName *string `locationName:"bucketName" min:"3" type:"string"`

	// The bucket prefix.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentS3LogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentS3LogConfiguration) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *ExperimentS3LogConfiguration) SetBucketName(v string) *ExperimentS3LogConfiguration {
	s.BucketName = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ExperimentS3LogConfiguration) SetPrefix(v string) *ExperimentS3LogConfiguration {
	s.Prefix = &v
	return s
}

// Describes the state of an experiment.
type ExperimentState struct {
	_ struct{} `type:"structure"`

	// The reason for the state.
	Reason *string `locationName:"reason" type:"string"`

	// The state of the experiment.
	Status *string `locationName:"status" type:"string" enum:"ExperimentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentState) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *ExperimentState) SetReason(v string) *ExperimentState {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExperimentState) SetStatus(v string) *ExperimentState {
	s.Status = &v
	return s
}

// Describes the stop condition for an experiment.
type ExperimentStopCondition struct {
	_ struct{} `type:"structure"`

	// The source for the stop condition.
	Source *string `locationName:"source" type:"string"`

	// The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.
	Value *string `locationName:"value" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentStopCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentStopCondition) GoString() string {
	return s.String()
}

// SetSource sets the Source field's value.
func (s *ExperimentStopCondition) SetSource(v string) *ExperimentStopCondition {
	s.Source = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ExperimentStopCondition) SetValue(v string) *ExperimentStopCondition {
	s.Value = &v
	return s
}

// Provides a summary of an experiment.
type ExperimentSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the experiment.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The time that the experiment was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The experiment options for the experiment.
	ExperimentOptions *ExperimentOptions `locationName:"experimentOptions" type:"structure"`

	// The ID of the experiment template.
	ExperimentTemplateId *string `locationName:"experimentTemplateId" type:"string"`

	// The ID of the experiment.
	Id *string `locationName:"id" type:"string"`

	// The state of the experiment.
	State *ExperimentState `locationName:"state" type:"structure"`

	// The tags for the experiment.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ExperimentSummary) SetArn(v string) *ExperimentSummary {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ExperimentSummary) SetCreationTime(v time.Time) *ExperimentSummary {
	s.CreationTime = &v
	return s
}

// SetExperimentOptions sets the ExperimentOptions field's value.
func (s *ExperimentSummary) SetExperimentOptions(v *ExperimentOptions) *ExperimentSummary {
	s.ExperimentOptions = v
	return s
}

// SetExperimentTemplateId sets the ExperimentTemplateId field's value.
func (s *ExperimentSummary) SetExperimentTemplateId(v string) *ExperimentSummary {
	s.ExperimentTemplateId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ExperimentSummary) SetId(v string) *ExperimentSummary {
	s.Id = &v
	return s
}

// SetState sets the State field's value.
func (s *ExperimentSummary) SetState(v *ExperimentState) *ExperimentSummary {
	s.State = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ExperimentSummary) SetTags(v map[string]*string) *ExperimentSummary {
	s.Tags = v
	return s
}

// Describes a target for an experiment.
type ExperimentTarget struct {
	_ struct{} `type:"structure"`

	// The filters to apply to identify target resources using specific attributes.
	Filters []*ExperimentTargetFilter `locationName:"filters" type:"list"`

	// The resource type parameters.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The Amazon Resource Names (ARNs) of the resources.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// The tags for the target resources.
	ResourceTags map[string]*string `locationName:"resourceTags" type:"map"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// Scopes the identified resources to a specific count or percentage.
	SelectionMode *string `locationName:"selectionMode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTarget) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *ExperimentTarget) SetFilters(v []*ExperimentTargetFilter) *ExperimentTarget {
	s.Filters = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ExperimentTarget) SetParameters(v map[string]*string) *ExperimentTarget {
	s.Parameters = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *ExperimentTarget) SetResourceArns(v []*string) *ExperimentTarget {
	s.ResourceArns = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *ExperimentTarget) SetResourceTags(v map[string]*string) *ExperimentTarget {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ExperimentTarget) SetResourceType(v string) *ExperimentTarget {
	s.ResourceType = &v
	return s
}

// SetSelectionMode sets the SelectionMode field's value.
func (s *ExperimentTarget) SetSelectionMode(v string) *ExperimentTarget {
	s.SelectionMode = &v
	return s
}

// Describes a target account configuration for an experiment.
type ExperimentTargetAccountConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the target account.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The description of the target account.
	Description *string `locationName:"description" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role for the target account.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTargetAccountConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTargetAccountConfiguration) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ExperimentTargetAccountConfiguration) SetAccountId(v string) *ExperimentTargetAccountConfiguration {
	s.AccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ExperimentTargetAccountConfiguration) SetDescription(v string) *ExperimentTargetAccountConfiguration {
	s.Description = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExperimentTargetAccountConfiguration) SetRoleArn(v string) *ExperimentTargetAccountConfiguration {
	s.RoleArn = &v
	return s
}

// Provides a summary of a target account configuration.
type ExperimentTargetAccountConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the target account.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The description of the target account.
	Description *string `locationName:"description" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role for the target account.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTargetAccountConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTargetAccountConfigurationSummary) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ExperimentTargetAccountConfigurationSummary) SetAccountId(v string) *ExperimentTargetAccountConfigurationSummary {
	s.AccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ExperimentTargetAccountConfigurationSummary) SetDescription(v string) *ExperimentTargetAccountConfigurationSummary {
	s.Description = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExperimentTargetAccountConfigurationSummary) SetRoleArn(v string) *ExperimentTargetAccountConfigurationSummary {
	s.RoleArn = &v
	return s
}

// Describes a filter used for the target resources in an experiment.
type ExperimentTargetFilter struct {
	_ struct{} `type:"structure"`

	// The attribute path for the filter.
	Path *string `locationName:"path" type:"string"`

	// The attribute values for the filter.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTargetFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTargetFilter) GoString() string {
	return s.String()
}

// SetPath sets the Path field's value.
func (s *ExperimentTargetFilter) SetPath(v string) *ExperimentTargetFilter {
	s.Path = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ExperimentTargetFilter) SetValues(v []*string) *ExperimentTargetFilter {
	s.Values = v
	return s
}

// Describes an experiment template.
type ExperimentTemplate struct {
	_ struct{} `type:"structure"`

	// The actions for the experiment.
	Actions map[string]*ExperimentTemplateAction `locationName:"actions" type:"map"`

	// The Amazon Resource Name (ARN) of the experiment template.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The time the experiment template was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description for the experiment template.
	Description *string `locationName:"description" type:"string"`

	// The experiment options for an experiment template.
	ExperimentOptions *ExperimentTemplateExperimentOptions `locationName:"experimentOptions" type:"structure"`

	// The ID of the experiment template.
	Id *string `locationName:"id" type:"string"`

	// The time the experiment template was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The configuration for experiment logging.
	LogConfiguration *ExperimentTemplateLogConfiguration `locationName:"logConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The stop conditions for the experiment.
	StopConditions []*ExperimentTemplateStopCondition `locationName:"stopConditions" type:"list"`

	// The tags for the experiment template.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The count of target account configurations for the experiment template.
	TargetAccountConfigurationsCount *int64 `locationName:"targetAccountConfigurationsCount" type:"long"`

	// The targets for the experiment.
	Targets map[string]*ExperimentTemplateTarget `locationName:"targets" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplate) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *ExperimentTemplate) SetActions(v map[string]*ExperimentTemplateAction) *ExperimentTemplate {
	s.Actions = v
	return s
}

// SetArn sets the Arn field's value.
func (s *ExperimentTemplate) SetArn(v string) *ExperimentTemplate {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ExperimentTemplate) SetCreationTime(v time.Time) *ExperimentTemplate {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ExperimentTemplate) SetDescription(v string) *ExperimentTemplate {
	s.Description = &v
	return s
}

// SetExperimentOptions sets the ExperimentOptions field's value.
func (s *ExperimentTemplate) SetExperimentOptions(v *ExperimentTemplateExperimentOptions) *ExperimentTemplate {
	s.ExperimentOptions = v
	return s
}

// SetId sets the Id field's value.
func (s *ExperimentTemplate) SetId(v string) *ExperimentTemplate {
	s.Id = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *ExperimentTemplate) SetLastUpdateTime(v time.Time) *ExperimentTemplate {
	s.LastUpdateTime = &v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *ExperimentTemplate) SetLogConfiguration(v *ExperimentTemplateLogConfiguration) *ExperimentTemplate {
	s.LogConfiguration = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExperimentTemplate) SetRoleArn(v string) *ExperimentTemplate {
	s.RoleArn = &v
	return s
}

// SetStopConditions sets the StopConditions field's value.
func (s *ExperimentTemplate) SetStopConditions(v []*ExperimentTemplateStopCondition) *ExperimentTemplate {
	s.StopConditions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ExperimentTemplate) SetTags(v map[string]*string) *ExperimentTemplate {
	s.Tags = v
	return s
}

// SetTargetAccountConfigurationsCount sets the TargetAccountConfigurationsCount field's value.
func (s *ExperimentTemplate) SetTargetAccountConfigurationsCount(v int64) *ExperimentTemplate {
	s.TargetAccountConfigurationsCount = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ExperimentTemplate) SetTargets(v map[string]*ExperimentTemplateTarget) *ExperimentTemplate {
	s.Targets = v
	return s
}

// Describes an action for an experiment template.
type ExperimentTemplateAction struct {
	_ struct{} `type:"structure"`

	// The ID of the action.
	ActionId *string `locationName:"actionId" type:"string"`

	// A description for the action.
	Description *string `locationName:"description" type:"string"`

	// The parameters for the action.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The name of the action that must be completed before the current action starts.
	StartAfter []*string `locationName:"startAfter" type:"list"`

	// The targets for the action.
	Targets map[string]*string `locationName:"targets" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateAction) GoString() string {
	return s.String()
}

// SetActionId sets the ActionId field's value.
func (s *ExperimentTemplateAction) SetActionId(v string) *ExperimentTemplateAction {
	s.ActionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ExperimentTemplateAction) SetDescription(v string) *ExperimentTemplateAction {
	s.Description = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ExperimentTemplateAction) SetParameters(v map[string]*string) *ExperimentTemplateAction {
	s.Parameters = v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *ExperimentTemplateAction) SetStartAfter(v []*string) *ExperimentTemplateAction {
	s.StartAfter = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ExperimentTemplateAction) SetTargets(v map[string]*string) *ExperimentTemplateAction {
	s.Targets = v
	return s
}

// Describes the configuration for experiment logging to Amazon CloudWatch Logs.
type ExperimentTemplateCloudWatchLogsLogConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination Amazon CloudWatch Logs
	// log group.
	LogGroupArn *string `locationName:"logGroupArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateCloudWatchLogsLogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateCloudWatchLogsLogConfiguration) GoString() string {
	return s.String()
}

// SetLogGroupArn sets the LogGroupArn field's value.
func (s *ExperimentTemplateCloudWatchLogsLogConfiguration) SetLogGroupArn(v string) *ExperimentTemplateCloudWatchLogsLogConfiguration {
	s.LogGroupArn = &v
	return s
}

// Specifies the configuration for experiment logging to Amazon CloudWatch Logs.
type ExperimentTemplateCloudWatchLogsLogConfigurationInput_ struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination Amazon CloudWatch Logs
	// log group.
	//
	// LogGroupArn is a required field
	LogGroupArn *string `locationName:"logGroupArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateCloudWatchLogsLogConfigurationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateCloudWatchLogsLogConfigurationInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExperimentTemplateCloudWatchLogsLogConfigurationInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExperimentTemplateCloudWatchLogsLogConfigurationInput_"}
	if s.LogGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupArn"))
	}
	if s.LogGroupArn != nil && len(*s.LogGroupArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("LogGroupArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogGroupArn sets the LogGroupArn field's value.
func (s *ExperimentTemplateCloudWatchLogsLogConfigurationInput_) SetLogGroupArn(v string) *ExperimentTemplateCloudWatchLogsLogConfigurationInput_ {
	s.LogGroupArn = &v
	return s
}

// Describes the experiment options for an experiment template.
type ExperimentTemplateExperimentOptions struct {
	_ struct{} `type:"structure"`

	// The account targeting setting for an experiment template.
	AccountTargeting *string `locationName:"accountTargeting" type:"string" enum:"AccountTargeting"`

	// The empty target resolution mode for an experiment template.
	EmptyTargetResolutionMode *string `locationName:"emptyTargetResolutionMode" type:"string" enum:"EmptyTargetResolutionMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateExperimentOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateExperimentOptions) GoString() string {
	return s.String()
}

// SetAccountTargeting sets the AccountTargeting field's value.
func (s *ExperimentTemplateExperimentOptions) SetAccountTargeting(v string) *ExperimentTemplateExperimentOptions {
	s.AccountTargeting = &v
	return s
}

// SetEmptyTargetResolutionMode sets the EmptyTargetResolutionMode field's value.
func (s *ExperimentTemplateExperimentOptions) SetEmptyTargetResolutionMode(v string) *ExperimentTemplateExperimentOptions {
	s.EmptyTargetResolutionMode = &v
	return s
}

// Describes the configuration for experiment logging.
type ExperimentTemplateLogConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration for experiment logging to Amazon CloudWatch Logs.
	CloudWatchLogsConfiguration *ExperimentTemplateCloudWatchLogsLogConfiguration `locationName:"cloudWatchLogsConfiguration" type:"structure"`

	// The schema version.
	LogSchemaVersion *int64 `locationName:"logSchemaVersion" type:"integer"`

	// The configuration for experiment logging to Amazon S3.
	S3Configuration *ExperimentTemplateS3LogConfiguration `locationName:"s3Configuration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateLogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateLogConfiguration) GoString() string {
	return s.String()
}

// SetCloudWatchLogsConfiguration sets the CloudWatchLogsConfiguration field's value.
func (s *ExperimentTemplateLogConfiguration) SetCloudWatchLogsConfiguration(v *ExperimentTemplateCloudWatchLogsLogConfiguration) *ExperimentTemplateLogConfiguration {
	s.CloudWatchLogsConfiguration = v
	return s
}

// SetLogSchemaVersion sets the LogSchemaVersion field's value.
func (s *ExperimentTemplateLogConfiguration) SetLogSchemaVersion(v int64) *ExperimentTemplateLogConfiguration {
	s.LogSchemaVersion = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *ExperimentTemplateLogConfiguration) SetS3Configuration(v *ExperimentTemplateS3LogConfiguration) *ExperimentTemplateLogConfiguration {
	s.S3Configuration = v
	return s
}

// Describes the configuration for experiment logging to Amazon S3.
type ExperimentTemplateS3LogConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the destination bucket.
	BucketName *string `locationName:"bucketName" min:"3" type:"string"`

	// The bucket prefix.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateS3LogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateS3LogConfiguration) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *ExperimentTemplateS3LogConfiguration) SetBucketName(v string) *ExperimentTemplateS3LogConfiguration {
	s.BucketName = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ExperimentTemplateS3LogConfiguration) SetPrefix(v string) *ExperimentTemplateS3LogConfiguration {
	s.Prefix = &v
	return s
}

// Specifies the configuration for experiment logging to Amazon S3.
type ExperimentTemplateS3LogConfigurationInput_ struct {
	_ struct{} `type:"structure"`

	// The name of the destination bucket.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`

	// The bucket prefix.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateS3LogConfigurationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateS3LogConfigurationInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExperimentTemplateS3LogConfigurationInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExperimentTemplateS3LogConfigurationInput_"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *ExperimentTemplateS3LogConfigurationInput_) SetBucketName(v string) *ExperimentTemplateS3LogConfigurationInput_ {
	s.BucketName = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ExperimentTemplateS3LogConfigurationInput_) SetPrefix(v string) *ExperimentTemplateS3LogConfigurationInput_ {
	s.Prefix = &v
	return s
}

// Describes a stop condition for an experiment template.
type ExperimentTemplateStopCondition struct {
	_ struct{} `type:"structure"`

	// The source for the stop condition.
	Source *string `locationName:"source" type:"string"`

	// The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.
	Value *string `locationName:"value" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateStopCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateStopCondition) GoString() string {
	return s.String()
}

// SetSource sets the Source field's value.
func (s *ExperimentTemplateStopCondition) SetSource(v string) *ExperimentTemplateStopCondition {
	s.Source = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ExperimentTemplateStopCondition) SetValue(v string) *ExperimentTemplateStopCondition {
	s.Value = &v
	return s
}

// Provides a summary of an experiment template.
type ExperimentTemplateSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the experiment template.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The time that the experiment template was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description of the experiment template.
	Description *string `locationName:"description" type:"string"`

	// The ID of the experiment template.
	Id *string `locationName:"id" type:"string"`

	// The time that the experiment template was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The tags for the experiment template.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ExperimentTemplateSummary) SetArn(v string) *ExperimentTemplateSummary {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ExperimentTemplateSummary) SetCreationTime(v time.Time) *ExperimentTemplateSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ExperimentTemplateSummary) SetDescription(v string) *ExperimentTemplateSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ExperimentTemplateSummary) SetId(v string) *ExperimentTemplateSummary {
	s.Id = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *ExperimentTemplateSummary) SetLastUpdateTime(v time.Time) *ExperimentTemplateSummary {
	s.LastUpdateTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ExperimentTemplateSummary) SetTags(v map[string]*string) *ExperimentTemplateSummary {
	s.Tags = v
	return s
}

// Describes a target for an experiment template.
type ExperimentTemplateTarget struct {
	_ struct{} `type:"structure"`

	// The filters to apply to identify target resources using specific attributes.
	Filters []*ExperimentTemplateTargetFilter `locationName:"filters" type:"list"`

	// The resource type parameters.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The Amazon Resource Names (ARNs) of the targets.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// The tags for the target resources.
	ResourceTags map[string]*string `locationName:"resourceTags" type:"map"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// Scopes the identified resources to a specific count or percentage.
	SelectionMode *string `locationName:"selectionMode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateTarget) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *ExperimentTemplateTarget) SetFilters(v []*ExperimentTemplateTargetFilter) *ExperimentTemplateTarget {
	s.Filters = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ExperimentTemplateTarget) SetParameters(v map[string]*string) *ExperimentTemplateTarget {
	s.Parameters = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *ExperimentTemplateTarget) SetResourceArns(v []*string) *ExperimentTemplateTarget {
	s.ResourceArns = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *ExperimentTemplateTarget) SetResourceTags(v map[string]*string) *ExperimentTemplateTarget {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ExperimentTemplateTarget) SetResourceType(v string) *ExperimentTemplateTarget {
	s.ResourceType = &v
	return s
}

// SetSelectionMode sets the SelectionMode field's value.
func (s *ExperimentTemplateTarget) SetSelectionMode(v string) *ExperimentTemplateTarget {
	s.SelectionMode = &v
	return s
}

// Describes a filter used for the target resources in an experiment template.
type ExperimentTemplateTargetFilter struct {
	_ struct{} `type:"structure"`

	// The attribute path for the filter.
	Path *string `locationName:"path" type:"string"`

	// The attribute values for the filter.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateTargetFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateTargetFilter) GoString() string {
	return s.String()
}

// SetPath sets the Path field's value.
func (s *ExperimentTemplateTargetFilter) SetPath(v string) *ExperimentTemplateTargetFilter {
	s.Path = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ExperimentTemplateTargetFilter) SetValues(v []*string) *ExperimentTemplateTargetFilter {
	s.Values = v
	return s
}

// Specifies a filter used for the target resource input in an experiment template.
//
// For more information, see Resource filters (https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters)
// in the Fault Injection Service User Guide.
type ExperimentTemplateTargetInputFilter struct {
	_ struct{} `type:"structure"`

	// The attribute path for the filter.
	//
	// Path is a required field
	Path *string `locationName:"path" type:"string" required:"true"`

	// The attribute values for the filter.
	//
	// Values is a required field
	Values []*string `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateTargetInputFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentTemplateTargetInputFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExperimentTemplateTargetInputFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExperimentTemplateTargetInputFilter"}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPath sets the Path field's value.
func (s *ExperimentTemplateTargetInputFilter) SetPath(v string) *ExperimentTemplateTargetInputFilter {
	s.Path = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ExperimentTemplateTargetInputFilter) SetValues(v []*string) *ExperimentTemplateTargetInputFilter {
	s.Values = v
	return s
}

type GetActionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the action.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetActionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetActionInput) SetId(v string) *GetActionInput {
	s.Id = &v
	return s
}

type GetActionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the action.
	Action *Action `locationName:"action" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetActionOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GetActionOutput) SetAction(v *Action) *GetActionOutput {
	s.Action = v
	return s
}

type GetExperimentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the experiment.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExperimentInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetExperimentInput) SetId(v string) *GetExperimentInput {
	s.Id = &v
	return s
}

type GetExperimentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment.
	Experiment *Experiment `locationName:"experiment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentOutput) GoString() string {
	return s.String()
}

// SetExperiment sets the Experiment field's value.
func (s *GetExperimentOutput) SetExperiment(v *Experiment) *GetExperimentOutput {
	s.Experiment = v
	return s
}

type GetExperimentTargetAccountConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Web Services account ID of the target account.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" min:"12" type:"string" required:"true"`

	// The ID of the experiment.
	//
	// ExperimentId is a required field
	ExperimentId *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentTargetAccountConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentTargetAccountConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExperimentTargetAccountConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExperimentTargetAccountConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.ExperimentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentId"))
	}
	if s.ExperimentId != nil && len(*s.ExperimentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetExperimentTargetAccountConfigurationInput) SetAccountId(v string) *GetExperimentTargetAccountConfigurationInput {
	s.AccountId = &v
	return s
}

// SetExperimentId sets the ExperimentId field's value.
func (s *GetExperimentTargetAccountConfigurationInput) SetExperimentId(v string) *GetExperimentTargetAccountConfigurationInput {
	s.ExperimentId = &v
	return s
}

type GetExperimentTargetAccountConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the target account configuration.
	TargetAccountConfiguration *ExperimentTargetAccountConfiguration `locationName:"targetAccountConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentTargetAccountConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentTargetAccountConfigurationOutput) GoString() string {
	return s.String()
}

// SetTargetAccountConfiguration sets the TargetAccountConfiguration field's value.
func (s *GetExperimentTargetAccountConfigurationOutput) SetTargetAccountConfiguration(v *ExperimentTargetAccountConfiguration) *GetExperimentTargetAccountConfigurationOutput {
	s.TargetAccountConfiguration = v
	return s
}

type GetExperimentTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the experiment template.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExperimentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExperimentTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetExperimentTemplateInput) SetId(v string) *GetExperimentTemplateInput {
	s.Id = &v
	return s
}

type GetExperimentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment template.
	ExperimentTemplate *ExperimentTemplate `locationName:"experimentTemplate" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentTemplateOutput) GoString() string {
	return s.String()
}

// SetExperimentTemplate sets the ExperimentTemplate field's value.
func (s *GetExperimentTemplateOutput) SetExperimentTemplate(v *ExperimentTemplate) *GetExperimentTemplateOutput {
	s.ExperimentTemplate = v
	return s
}

type GetTargetAccountConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Web Services account ID of the target account.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" min:"12" type:"string" required:"true"`

	// The ID of the experiment template.
	//
	// ExperimentTemplateId is a required field
	ExperimentTemplateId *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTargetAccountConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTargetAccountConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTargetAccountConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTargetAccountConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.ExperimentTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentTemplateId"))
	}
	if s.ExperimentTemplateId != nil && len(*s.ExperimentTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentTemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetTargetAccountConfigurationInput) SetAccountId(v string) *GetTargetAccountConfigurationInput {
	s.AccountId = &v
	return s
}

// SetExperimentTemplateId sets the ExperimentTemplateId field's value.
func (s *GetTargetAccountConfigurationInput) SetExperimentTemplateId(v string) *GetTargetAccountConfigurationInput {
	s.ExperimentTemplateId = &v
	return s
}

type GetTargetAccountConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the target account configuration.
	TargetAccountConfiguration *TargetAccountConfiguration `locationName:"targetAccountConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTargetAccountConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTargetAccountConfigurationOutput) GoString() string {
	return s.String()
}

// SetTargetAccountConfiguration sets the TargetAccountConfiguration field's value.
func (s *GetTargetAccountConfigurationOutput) SetTargetAccountConfiguration(v *TargetAccountConfiguration) *GetTargetAccountConfigurationOutput {
	s.TargetAccountConfiguration = v
	return s
}

type GetTargetResourceTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `location:"uri" locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTargetResourceTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTargetResourceTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTargetResourceTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTargetResourceTypeInput"}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceType sets the ResourceType field's value.
func (s *GetTargetResourceTypeInput) SetResourceType(v string) *GetTargetResourceTypeInput {
	s.ResourceType = &v
	return s
}

type GetTargetResourceTypeOutput struct {
	_ struct{} `type:"structure"`

	// Information about the resource type.
	TargetResourceType *TargetResourceType `locationName:"targetResourceType" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTargetResourceTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTargetResourceTypeOutput) GoString() string {
	return s.String()
}

// SetTargetResourceType sets the TargetResourceType field's value.
func (s *GetTargetResourceTypeOutput) SetTargetResourceType(v *TargetResourceType) *GetTargetResourceTypeOutput {
	s.TargetResourceType = v
	return s
}

type ListActionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListActionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListActionsInput) SetMaxResults(v int64) *ListActionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActionsInput) SetNextToken(v string) *ListActionsInput {
	s.NextToken = &v
	return s
}

type ListActionsOutput struct {
	_ struct{} `type:"structure"`

	// The actions.
	Actions []*ActionSummary `locationName:"actions" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListActionsOutput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *ListActionsOutput) SetActions(v []*ActionSummary) *ListActionsOutput {
	s.Actions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActionsOutput) SetNextToken(v string) *ListActionsOutput {
	s.NextToken = &v
	return s
}

type ListExperimentResolvedTargetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the experiment.
	//
	// ExperimentId is a required field
	ExperimentId *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The name of the target.
	TargetName *string `location:"querystring" locationName:"targetName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentResolvedTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentResolvedTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExperimentResolvedTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExperimentResolvedTargetsInput"}
	if s.ExperimentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentId"))
	}
	if s.ExperimentId != nil && len(*s.ExperimentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExperimentId sets the ExperimentId field's value.
func (s *ListExperimentResolvedTargetsInput) SetExperimentId(v string) *ListExperimentResolvedTargetsInput {
	s.ExperimentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExperimentResolvedTargetsInput) SetMaxResults(v int64) *ListExperimentResolvedTargetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentResolvedTargetsInput) SetNextToken(v string) *ListExperimentResolvedTargetsInput {
	s.NextToken = &v
	return s
}

// SetTargetName sets the TargetName field's value.
func (s *ListExperimentResolvedTargetsInput) SetTargetName(v string) *ListExperimentResolvedTargetsInput {
	s.TargetName = &v
	return s
}

type ListExperimentResolvedTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The resolved targets.
	ResolvedTargets []*ResolvedTarget `locationName:"resolvedTargets" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentResolvedTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentResolvedTargetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentResolvedTargetsOutput) SetNextToken(v string) *ListExperimentResolvedTargetsOutput {
	s.NextToken = &v
	return s
}

// SetResolvedTargets sets the ResolvedTargets field's value.
func (s *ListExperimentResolvedTargetsOutput) SetResolvedTargets(v []*ResolvedTarget) *ListExperimentResolvedTargetsOutput {
	s.ResolvedTargets = v
	return s
}

type ListExperimentTargetAccountConfigurationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the experiment.
	//
	// ExperimentId is a required field
	ExperimentId *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentTargetAccountConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentTargetAccountConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExperimentTargetAccountConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExperimentTargetAccountConfigurationsInput"}
	if s.ExperimentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentId"))
	}
	if s.ExperimentId != nil && len(*s.ExperimentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExperimentId sets the ExperimentId field's value.
func (s *ListExperimentTargetAccountConfigurationsInput) SetExperimentId(v string) *ListExperimentTargetAccountConfigurationsInput {
	s.ExperimentId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentTargetAccountConfigurationsInput) SetNextToken(v string) *ListExperimentTargetAccountConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListExperimentTargetAccountConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The target account configurations.
	TargetAccountConfigurations []*ExperimentTargetAccountConfigurationSummary `locationName:"targetAccountConfigurations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentTargetAccountConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentTargetAccountConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentTargetAccountConfigurationsOutput) SetNextToken(v string) *ListExperimentTargetAccountConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetTargetAccountConfigurations sets the TargetAccountConfigurations field's value.
func (s *ListExperimentTargetAccountConfigurationsOutput) SetTargetAccountConfigurations(v []*ExperimentTargetAccountConfigurationSummary) *ListExperimentTargetAccountConfigurationsOutput {
	s.TargetAccountConfigurations = v
	return s
}

type ListExperimentTemplatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExperimentTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExperimentTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExperimentTemplatesInput) SetMaxResults(v int64) *ListExperimentTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentTemplatesInput) SetNextToken(v string) *ListExperimentTemplatesInput {
	s.NextToken = &v
	return s
}

type ListExperimentTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The experiment templates.
	ExperimentTemplates []*ExperimentTemplateSummary `locationName:"experimentTemplates" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentTemplatesOutput) GoString() string {
	return s.String()
}

// SetExperimentTemplates sets the ExperimentTemplates field's value.
func (s *ListExperimentTemplatesOutput) SetExperimentTemplates(v []*ExperimentTemplateSummary) *ListExperimentTemplatesOutput {
	s.ExperimentTemplates = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentTemplatesOutput) SetNextToken(v string) *ListExperimentTemplatesOutput {
	s.NextToken = &v
	return s
}

type ListExperimentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the experiment template.
	ExperimentTemplateId *string `location:"querystring" locationName:"experimentTemplateId" type:"string"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExperimentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExperimentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExperimentTemplateId sets the ExperimentTemplateId field's value.
func (s *ListExperimentsInput) SetExperimentTemplateId(v string) *ListExperimentsInput {
	s.ExperimentTemplateId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExperimentsInput) SetMaxResults(v int64) *ListExperimentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentsInput) SetNextToken(v string) *ListExperimentsInput {
	s.NextToken = &v
	return s
}

type ListExperimentsOutput struct {
	_ struct{} `type:"structure"`

	// The experiments.
	Experiments []*ExperimentSummary `locationName:"experiments" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentsOutput) GoString() string {
	return s.String()
}

// SetExperiments sets the Experiments field's value.
func (s *ListExperimentsOutput) SetExperiments(v []*ExperimentSummary) *ListExperimentsOutput {
	s.Experiments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentsOutput) SetNextToken(v string) *ListExperimentsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTargetAccountConfigurationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the experiment template.
	//
	// ExperimentTemplateId is a required field
	ExperimentTemplateId *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetAccountConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetAccountConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetAccountConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetAccountConfigurationsInput"}
	if s.ExperimentTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentTemplateId"))
	}
	if s.ExperimentTemplateId != nil && len(*s.ExperimentTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentTemplateId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExperimentTemplateId sets the ExperimentTemplateId field's value.
func (s *ListTargetAccountConfigurationsInput) SetExperimentTemplateId(v string) *ListTargetAccountConfigurationsInput {
	s.ExperimentTemplateId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTargetAccountConfigurationsInput) SetMaxResults(v int64) *ListTargetAccountConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetAccountConfigurationsInput) SetNextToken(v string) *ListTargetAccountConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListTargetAccountConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The target account configurations.
	TargetAccountConfigurations []*TargetAccountConfigurationSummary `locationName:"targetAccountConfigurations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetAccountConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetAccountConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetAccountConfigurationsOutput) SetNextToken(v string) *ListTargetAccountConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetTargetAccountConfigurations sets the TargetAccountConfigurations field's value.
func (s *ListTargetAccountConfigurationsOutput) SetTargetAccountConfigurations(v []*TargetAccountConfigurationSummary) *ListTargetAccountConfigurationsOutput {
	s.TargetAccountConfigurations = v
	return s
}

type ListTargetResourceTypesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetResourceTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetResourceTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetResourceTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetResourceTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTargetResourceTypesInput) SetMaxResults(v int64) *ListTargetResourceTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetResourceTypesInput) SetNextToken(v string) *ListTargetResourceTypesInput {
	s.NextToken = &v
	return s
}

type ListTargetResourceTypesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The target resource types.
	TargetResourceTypes []*TargetResourceTypeSummary `locationName:"targetResourceTypes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetResourceTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetResourceTypesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetResourceTypesOutput) SetNextToken(v string) *ListTargetResourceTypesOutput {
	s.NextToken = &v
	return s
}

// SetTargetResourceTypes sets the TargetResourceTypes field's value.
func (s *ListTargetResourceTypesOutput) SetTargetResourceTypes(v []*TargetResourceTypeSummary) *ListTargetResourceTypesOutput {
	s.TargetResourceTypes = v
	return s
}

// Describes a resolved target.
type ResolvedTarget struct {
	_ struct{} `type:"structure"`

	// The resource type of the target.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// Information about the target.
	TargetInformation map[string]*string `locationName:"targetInformation" type:"map"`

	// The name of the target.
	TargetName *string `locationName:"targetName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolvedTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolvedTarget) GoString() string {
	return s.String()
}

// SetResourceType sets the ResourceType field's value.
func (s *ResolvedTarget) SetResourceType(v string) *ResolvedTarget {
	s.ResourceType = &v
	return s
}

// SetTargetInformation sets the TargetInformation field's value.
func (s *ResolvedTarget) SetTargetInformation(v map[string]*string) *ResolvedTarget {
	s.TargetInformation = v
	return s
}

// SetTargetName sets the TargetName field's value.
func (s *ResolvedTarget) SetTargetName(v string) *ResolvedTarget {
	s.TargetName = &v
	return s
}

// The specified resource cannot be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have exceeded your service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies experiment options for running an experiment.
type StartExperimentExperimentOptionsInput_ struct {
	_ struct{} `type:"structure"`

	// Specifies the actions mode for experiment options.
	ActionsMode *string `locationName:"actionsMode" type:"string" enum:"ActionsMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExperimentExperimentOptionsInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExperimentExperimentOptionsInput_) GoString() string {
	return s.String()
}

// SetActionsMode sets the ActionsMode field's value.
func (s *StartExperimentExperimentOptionsInput_) SetActionsMode(v string) *StartExperimentExperimentOptionsInput_ {
	s.ActionsMode = &v
	return s
}

type StartExperimentInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The experiment options for running the experiment.
	ExperimentOptions *StartExperimentExperimentOptionsInput_ `locationName:"experimentOptions" type:"structure"`

	// The ID of the experiment template.
	//
	// ExperimentTemplateId is a required field
	ExperimentTemplateId *string `locationName:"experimentTemplateId" type:"string" required:"true"`

	// The tags to apply to the experiment.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartExperimentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ExperimentTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentTemplateId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartExperimentInput) SetClientToken(v string) *StartExperimentInput {
	s.ClientToken = &v
	return s
}

// SetExperimentOptions sets the ExperimentOptions field's value.
func (s *StartExperimentInput) SetExperimentOptions(v *StartExperimentExperimentOptionsInput_) *StartExperimentInput {
	s.ExperimentOptions = v
	return s
}

// SetExperimentTemplateId sets the ExperimentTemplateId field's value.
func (s *StartExperimentInput) SetExperimentTemplateId(v string) *StartExperimentInput {
	s.ExperimentTemplateId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartExperimentInput) SetTags(v map[string]*string) *StartExperimentInput {
	s.Tags = v
	return s
}

type StartExperimentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment.
	Experiment *Experiment `locationName:"experiment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExperimentOutput) GoString() string {
	return s.String()
}

// SetExperiment sets the Experiment field's value.
func (s *StartExperimentOutput) SetExperiment(v *Experiment) *StartExperimentOutput {
	s.Experiment = v
	return s
}

type StopExperimentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the experiment.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopExperimentInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *StopExperimentInput) SetId(v string) *StopExperimentInput {
	s.Id = &v
	return s
}

type StopExperimentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment.
	Experiment *Experiment `locationName:"experiment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopExperimentOutput) GoString() string {
	return s.String()
}

// SetExperiment sets the Experiment field's value.
func (s *StopExperimentOutput) SetExperiment(v *Experiment) *StopExperimentOutput {
	s.Experiment = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The tags for the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Describes a target account configuration.
type TargetAccountConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the target account.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The description of the target account.
	Description *string `locationName:"description" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role for the target account.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetAccountConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetAccountConfiguration) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *TargetAccountConfiguration) SetAccountId(v string) *TargetAccountConfiguration {
	s.AccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TargetAccountConfiguration) SetDescription(v string) *TargetAccountConfiguration {
	s.Description = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *TargetAccountConfiguration) SetRoleArn(v string) *TargetAccountConfiguration {
	s.RoleArn = &v
	return s
}

// Provides a summary of a target account configuration.
type TargetAccountConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the target account.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The description of the target account.
	Description *string `locationName:"description" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role for the target account.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetAccountConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetAccountConfigurationSummary) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *TargetAccountConfigurationSummary) SetAccountId(v string) *TargetAccountConfigurationSummary {
	s.AccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TargetAccountConfigurationSummary) SetDescription(v string) *TargetAccountConfigurationSummary {
	s.Description = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *TargetAccountConfigurationSummary) SetRoleArn(v string) *TargetAccountConfigurationSummary {
	s.RoleArn = &v
	return s
}

// Describes a resource type.
type TargetResourceType struct {
	_ struct{} `type:"structure"`

	// A description of the resource type.
	Description *string `locationName:"description" type:"string"`

	// The parameters for the resource type.
	Parameters map[string]*TargetResourceTypeParameter `locationName:"parameters" type:"map"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetResourceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetResourceType) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *TargetResourceType) SetDescription(v string) *TargetResourceType {
	s.Description = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *TargetResourceType) SetParameters(v map[string]*TargetResourceTypeParameter) *TargetResourceType {
	s.Parameters = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TargetResourceType) SetResourceType(v string) *TargetResourceType {
	s.ResourceType = &v
	return s
}

// Describes the parameters for a resource type. Use parameters to determine
// which tasks are identified during target resolution.
type TargetResourceTypeParameter struct {
	_ struct{} `type:"structure"`

	// A description of the parameter.
	Description *string `locationName:"description" type:"string"`

	// Indicates whether the parameter is required.
	Required *bool `locationName:"required" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetResourceTypeParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetResourceTypeParameter) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *TargetResourceTypeParameter) SetDescription(v string) *TargetResourceTypeParameter {
	s.Description = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *TargetResourceTypeParameter) SetRequired(v bool) *TargetResourceTypeParameter {
	s.Required = &v
	return s
}

// Describes a resource type.
type TargetResourceTypeSummary struct {
	_ struct{} `type:"structure"`

	// A description of the resource type.
	Description *string `locationName:"description" type:"string"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetResourceTypeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetResourceTypeSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *TargetResourceTypeSummary) SetDescription(v string) *TargetResourceTypeSummary {
	s.Description = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TargetResourceTypeSummary) SetResourceType(v string) *TargetResourceTypeSummary {
	s.ResourceType = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The tag keys to remove.
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Specifies an action for an experiment template.
type UpdateExperimentTemplateActionInputItem struct {
	_ struct{} `type:"structure"`

	// The ID of the action.
	ActionId *string `locationName:"actionId" type:"string"`

	// A description for the action.
	Description *string `locationName:"description" type:"string"`

	// The parameters for the action, if applicable.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The name of the action that must be completed before the current action starts.
	// Omit this parameter to run the action at the start of the experiment.
	StartAfter []*string `locationName:"startAfter" type:"list"`

	// The targets for the action.
	Targets map[string]*string `locationName:"targets" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateActionInputItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateActionInputItem) GoString() string {
	return s.String()
}

// SetActionId sets the ActionId field's value.
func (s *UpdateExperimentTemplateActionInputItem) SetActionId(v string) *UpdateExperimentTemplateActionInputItem {
	s.ActionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateExperimentTemplateActionInputItem) SetDescription(v string) *UpdateExperimentTemplateActionInputItem {
	s.Description = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdateExperimentTemplateActionInputItem) SetParameters(v map[string]*string) *UpdateExperimentTemplateActionInputItem {
	s.Parameters = v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *UpdateExperimentTemplateActionInputItem) SetStartAfter(v []*string) *UpdateExperimentTemplateActionInputItem {
	s.StartAfter = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *UpdateExperimentTemplateActionInputItem) SetTargets(v map[string]*string) *UpdateExperimentTemplateActionInputItem {
	s.Targets = v
	return s
}

// Specifies an experiment option for an experiment template.
type UpdateExperimentTemplateExperimentOptionsInput_ struct {
	_ struct{} `type:"structure"`

	// The empty target resolution mode of the experiment template.
	EmptyTargetResolutionMode *string `locationName:"emptyTargetResolutionMode" type:"string" enum:"EmptyTargetResolutionMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateExperimentOptionsInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateExperimentOptionsInput_) GoString() string {
	return s.String()
}

// SetEmptyTargetResolutionMode sets the EmptyTargetResolutionMode field's value.
func (s *UpdateExperimentTemplateExperimentOptionsInput_) SetEmptyTargetResolutionMode(v string) *UpdateExperimentTemplateExperimentOptionsInput_ {
	s.EmptyTargetResolutionMode = &v
	return s
}

type UpdateExperimentTemplateInput struct {
	_ struct{} `type:"structure"`

	// The actions for the experiment.
	Actions map[string]*UpdateExperimentTemplateActionInputItem `locationName:"actions" type:"map"`

	// A description for the template.
	Description *string `locationName:"description" type:"string"`

	// The experiment options for the experiment template.
	ExperimentOptions *UpdateExperimentTemplateExperimentOptionsInput_ `locationName:"experimentOptions" type:"structure"`

	// The ID of the experiment template.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The configuration for experiment logging.
	LogConfiguration *UpdateExperimentTemplateLogConfigurationInput_ `locationName:"logConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that grants the FIS service
	// permission to perform service actions on your behalf.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The stop conditions for the experiment.
	StopConditions []*UpdateExperimentTemplateStopConditionInput `locationName:"stopConditions" type:"list"`

	// The targets for the experiment.
	Targets map[string]*UpdateExperimentTemplateTargetInput `locationName:"targets" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateExperimentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateExperimentTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.LogConfiguration != nil {
		if err := s.LogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LogConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.StopConditions != nil {
		for i, v := range s.StopConditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StopConditions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *UpdateExperimentTemplateInput) SetActions(v map[string]*UpdateExperimentTemplateActionInputItem) *UpdateExperimentTemplateInput {
	s.Actions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateExperimentTemplateInput) SetDescription(v string) *UpdateExperimentTemplateInput {
	s.Description = &v
	return s
}

// SetExperimentOptions sets the ExperimentOptions field's value.
func (s *UpdateExperimentTemplateInput) SetExperimentOptions(v *UpdateExperimentTemplateExperimentOptionsInput_) *UpdateExperimentTemplateInput {
	s.ExperimentOptions = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateExperimentTemplateInput) SetId(v string) *UpdateExperimentTemplateInput {
	s.Id = &v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *UpdateExperimentTemplateInput) SetLogConfiguration(v *UpdateExperimentTemplateLogConfigurationInput_) *UpdateExperimentTemplateInput {
	s.LogConfiguration = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateExperimentTemplateInput) SetRoleArn(v string) *UpdateExperimentTemplateInput {
	s.RoleArn = &v
	return s
}

// SetStopConditions sets the StopConditions field's value.
func (s *UpdateExperimentTemplateInput) SetStopConditions(v []*UpdateExperimentTemplateStopConditionInput) *UpdateExperimentTemplateInput {
	s.StopConditions = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *UpdateExperimentTemplateInput) SetTargets(v map[string]*UpdateExperimentTemplateTargetInput) *UpdateExperimentTemplateInput {
	s.Targets = v
	return s
}

// Specifies the configuration for experiment logging.
type UpdateExperimentTemplateLogConfigurationInput_ struct {
	_ struct{} `type:"structure"`

	// The configuration for experiment logging to Amazon CloudWatch Logs.
	CloudWatchLogsConfiguration *ExperimentTemplateCloudWatchLogsLogConfigurationInput_ `locationName:"cloudWatchLogsConfiguration" type:"structure"`

	// The schema version.
	LogSchemaVersion *int64 `locationName:"logSchemaVersion" type:"integer"`

	// The configuration for experiment logging to Amazon S3.
	S3Configuration *ExperimentTemplateS3LogConfigurationInput_ `locationName:"s3Configuration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateLogConfigurationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateLogConfigurationInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateExperimentTemplateLogConfigurationInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateExperimentTemplateLogConfigurationInput_"}
	if s.CloudWatchLogsConfiguration != nil {
		if err := s.CloudWatchLogsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsConfiguration sets the CloudWatchLogsConfiguration field's value.
func (s *UpdateExperimentTemplateLogConfigurationInput_) SetCloudWatchLogsConfiguration(v *ExperimentTemplateCloudWatchLogsLogConfigurationInput_) *UpdateExperimentTemplateLogConfigurationInput_ {
	s.CloudWatchLogsConfiguration = v
	return s
}

// SetLogSchemaVersion sets the LogSchemaVersion field's value.
func (s *UpdateExperimentTemplateLogConfigurationInput_) SetLogSchemaVersion(v int64) *UpdateExperimentTemplateLogConfigurationInput_ {
	s.LogSchemaVersion = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *UpdateExperimentTemplateLogConfigurationInput_) SetS3Configuration(v *ExperimentTemplateS3LogConfigurationInput_) *UpdateExperimentTemplateLogConfigurationInput_ {
	s.S3Configuration = v
	return s
}

type UpdateExperimentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment template.
	ExperimentTemplate *ExperimentTemplate `locationName:"experimentTemplate" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateOutput) GoString() string {
	return s.String()
}

// SetExperimentTemplate sets the ExperimentTemplate field's value.
func (s *UpdateExperimentTemplateOutput) SetExperimentTemplate(v *ExperimentTemplate) *UpdateExperimentTemplateOutput {
	s.ExperimentTemplate = v
	return s
}

// Specifies a stop condition for an experiment. You can define a stop condition
// as a CloudWatch alarm.
type UpdateExperimentTemplateStopConditionInput struct {
	_ struct{} `type:"structure"`

	// The source for the stop condition. Specify aws:cloudwatch:alarm if the stop
	// condition is defined by a CloudWatch alarm. Specify none if there is no stop
	// condition.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the CloudWatch alarm.
	Value *string `locationName:"value" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateStopConditionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateStopConditionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateExperimentTemplateStopConditionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateExperimentTemplateStopConditionInput"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Value != nil && len(*s.Value) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *UpdateExperimentTemplateStopConditionInput) SetSource(v string) *UpdateExperimentTemplateStopConditionInput {
	s.Source = &v
	return s
}

// SetValue sets the Value field's value.
func (s *UpdateExperimentTemplateStopConditionInput) SetValue(v string) *UpdateExperimentTemplateStopConditionInput {
	s.Value = &v
	return s
}

// Specifies a target for an experiment. You must specify at least one Amazon
// Resource Name (ARN) or at least one resource tag. You cannot specify both.
type UpdateExperimentTemplateTargetInput struct {
	_ struct{} `type:"structure"`

	// The filters to apply to identify target resources using specific attributes.
	Filters []*ExperimentTemplateTargetInputFilter `locationName:"filters" type:"list"`

	// The resource type parameters.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The Amazon Resource Names (ARNs) of the targets.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// The tags for the target resources.
	ResourceTags map[string]*string `locationName:"resourceTags" type:"map"`

	// The resource type. The resource type must be supported for the specified
	// action.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// Scopes the identified resources to a specific count or percentage.
	//
	// SelectionMode is a required field
	SelectionMode *string `locationName:"selectionMode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentTemplateTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateExperimentTemplateTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateExperimentTemplateTargetInput"}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.SelectionMode == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectionMode"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *UpdateExperimentTemplateTargetInput) SetFilters(v []*ExperimentTemplateTargetInputFilter) *UpdateExperimentTemplateTargetInput {
	s.Filters = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdateExperimentTemplateTargetInput) SetParameters(v map[string]*string) *UpdateExperimentTemplateTargetInput {
	s.Parameters = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *UpdateExperimentTemplateTargetInput) SetResourceArns(v []*string) *UpdateExperimentTemplateTargetInput {
	s.ResourceArns = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *UpdateExperimentTemplateTargetInput) SetResourceTags(v map[string]*string) *UpdateExperimentTemplateTargetInput {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *UpdateExperimentTemplateTargetInput) SetResourceType(v string) *UpdateExperimentTemplateTargetInput {
	s.ResourceType = &v
	return s
}

// SetSelectionMode sets the SelectionMode field's value.
func (s *UpdateExperimentTemplateTargetInput) SetSelectionMode(v string) *UpdateExperimentTemplateTargetInput {
	s.SelectionMode = &v
	return s
}

type UpdateTargetAccountConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the target account.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" min:"12" type:"string" required:"true"`

	// The description of the target account.
	Description *string `locationName:"description" type:"string"`

	// The ID of the experiment template.
	//
	// ExperimentTemplateId is a required field
	ExperimentTemplateId *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role for the target account.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTargetAccountConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTargetAccountConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTargetAccountConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTargetAccountConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.ExperimentTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentTemplateId"))
	}
	if s.ExperimentTemplateId != nil && len(*s.ExperimentTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExperimentTemplateId", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateTargetAccountConfigurationInput) SetAccountId(v string) *UpdateTargetAccountConfigurationInput {
	s.AccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateTargetAccountConfigurationInput) SetDescription(v string) *UpdateTargetAccountConfigurationInput {
	s.Description = &v
	return s
}

// SetExperimentTemplateId sets the ExperimentTemplateId field's value.
func (s *UpdateTargetAccountConfigurationInput) SetExperimentTemplateId(v string) *UpdateTargetAccountConfigurationInput {
	s.ExperimentTemplateId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateTargetAccountConfigurationInput) SetRoleArn(v string) *UpdateTargetAccountConfigurationInput {
	s.RoleArn = &v
	return s
}

type UpdateTargetAccountConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the target account configuration.
	TargetAccountConfiguration *TargetAccountConfiguration `locationName:"targetAccountConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTargetAccountConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTargetAccountConfigurationOutput) GoString() string {
	return s.String()
}

// SetTargetAccountConfiguration sets the TargetAccountConfiguration field's value.
func (s *UpdateTargetAccountConfigurationOutput) SetTargetAccountConfiguration(v *TargetAccountConfiguration) *UpdateTargetAccountConfigurationOutput {
	s.TargetAccountConfiguration = v
	return s
}

// The specified input is not valid, or fails to satisfy the constraints for
// the request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AccountTargetingSingleAccount is a AccountTargeting enum value
	AccountTargetingSingleAccount = "single-account"

	// AccountTargetingMultiAccount is a AccountTargeting enum value
	AccountTargetingMultiAccount = "multi-account"
)

// AccountTargeting_Values returns all elements of the AccountTargeting enum
func AccountTargeting_Values() []string {
	return []string{
		AccountTargetingSingleAccount,
		AccountTargetingMultiAccount,
	}
}

const (
	// ActionsModeSkipAll is a ActionsMode enum value
	ActionsModeSkipAll = "skip-all"

	// ActionsModeRunAll is a ActionsMode enum value
	ActionsModeRunAll = "run-all"
)

// ActionsMode_Values returns all elements of the ActionsMode enum
func ActionsMode_Values() []string {
	return []string{
		ActionsModeSkipAll,
		ActionsModeRunAll,
	}
}

const (
	// EmptyTargetResolutionModeFail is a EmptyTargetResolutionMode enum value
	EmptyTargetResolutionModeFail = "fail"

	// EmptyTargetResolutionModeSkip is a EmptyTargetResolutionMode enum value
	EmptyTargetResolutionModeSkip = "skip"
)

// EmptyTargetResolutionMode_Values returns all elements of the EmptyTargetResolutionMode enum
func EmptyTargetResolutionMode_Values() []string {
	return []string{
		EmptyTargetResolutionModeFail,
		EmptyTargetResolutionModeSkip,
	}
}

const (
	// ExperimentActionStatusPending is a ExperimentActionStatus enum value
	ExperimentActionStatusPending = "pending"

	// ExperimentActionStatusInitiating is a ExperimentActionStatus enum value
	ExperimentActionStatusInitiating = "initiating"

	// ExperimentActionStatusRunning is a ExperimentActionStatus enum value
	ExperimentActionStatusRunning = "running"

	// ExperimentActionStatusCompleted is a ExperimentActionStatus enum value
	ExperimentActionStatusCompleted = "completed"

	// ExperimentActionStatusCancelled is a ExperimentActionStatus enum value
	ExperimentActionStatusCancelled = "cancelled"

	// ExperimentActionStatusStopping is a ExperimentActionStatus enum value
	ExperimentActionStatusStopping = "stopping"

	// ExperimentActionStatusStopped is a ExperimentActionStatus enum value
	ExperimentActionStatusStopped = "stopped"

	// ExperimentActionStatusFailed is a ExperimentActionStatus enum value
	ExperimentActionStatusFailed = "failed"

	// ExperimentActionStatusSkipped is a ExperimentActionStatus enum value
	ExperimentActionStatusSkipped = "skipped"
)

// ExperimentActionStatus_Values returns all elements of the ExperimentActionStatus enum
func ExperimentActionStatus_Values() []string {
	return []string{
		ExperimentActionStatusPending,
		ExperimentActionStatusInitiating,
		ExperimentActionStatusRunning,
		ExperimentActionStatusCompleted,
		ExperimentActionStatusCancelled,
		ExperimentActionStatusStopping,
		ExperimentActionStatusStopped,
		ExperimentActionStatusFailed,
		ExperimentActionStatusSkipped,
	}
}

const (
	// ExperimentStatusPending is a ExperimentStatus enum value
	ExperimentStatusPending = "pending"

	// ExperimentStatusInitiating is a ExperimentStatus enum value
	ExperimentStatusInitiating = "initiating"

	// ExperimentStatusRunning is a ExperimentStatus enum value
	ExperimentStatusRunning = "running"

	// ExperimentStatusCompleted is a ExperimentStatus enum value
	ExperimentStatusCompleted = "completed"

	// ExperimentStatusStopping is a ExperimentStatus enum value
	ExperimentStatusStopping = "stopping"

	// ExperimentStatusStopped is a ExperimentStatus enum value
	ExperimentStatusStopped = "stopped"

	// ExperimentStatusFailed is a ExperimentStatus enum value
	ExperimentStatusFailed = "failed"
)

// ExperimentStatus_Values returns all elements of the ExperimentStatus enum
func ExperimentStatus_Values() []string {
	return []string{
		ExperimentStatusPending,
		ExperimentStatusInitiating,
		ExperimentStatusRunning,
		ExperimentStatusCompleted,
		ExperimentStatusStopping,
		ExperimentStatusStopped,
		ExperimentStatusFailed,
	}
}
