// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectorlogs "go.opentelemetry.io/proto/slim/otlp/collector/logs/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExportLogsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExportLogsServiceResponse()
				CopyExportLogsServiceResponse(dest, src)
				assert.Equal(t, src, dest)
				CopyExportLogsServiceResponse(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExportLogsServiceResponseSlice(t *testing.T) {
	src := []ExportLogsServiceResponse{}
	dest := []ExportLogsServiceResponse{}
	// Test CopyTo empty
	dest = CopyExportLogsServiceResponseSlice(dest, src)
	assert.Equal(t, []ExportLogsServiceResponse{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportLogsServiceResponseSlice()
	dest = CopyExportLogsServiceResponseSlice(dest, src)
	assert.Equal(t, GenTestExportLogsServiceResponseSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportLogsServiceResponseSlice(dest, src)
	assert.Equal(t, GenTestExportLogsServiceResponseSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportLogsServiceResponseSlice(dest, []ExportLogsServiceResponse{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportLogsServiceResponseSlice(dest, src)
	assert.Equal(t, GenTestExportLogsServiceResponseSlice(), dest)
}

func TestCopyExportLogsServiceResponsePtrSlice(t *testing.T) {
	src := []*ExportLogsServiceResponse{}
	dest := []*ExportLogsServiceResponse{}
	// Test CopyTo empty
	dest = CopyExportLogsServiceResponsePtrSlice(dest, src)
	assert.Equal(t, []*ExportLogsServiceResponse{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportLogsServiceResponsePtrSlice()
	dest = CopyExportLogsServiceResponsePtrSlice(dest, src)
	assert.Equal(t, GenTestExportLogsServiceResponsePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportLogsServiceResponsePtrSlice(dest, src)
	assert.Equal(t, GenTestExportLogsServiceResponsePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportLogsServiceResponsePtrSlice(dest, []*ExportLogsServiceResponse{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportLogsServiceResponsePtrSlice(dest, src)
	assert.Equal(t, GenTestExportLogsServiceResponsePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExportLogsServiceResponseUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExportLogsServiceResponse()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExportLogsServiceResponse(), dest)
}

func TestMarshalAndUnmarshalJSONExportLogsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExportLogsServiceResponse()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExportLogsServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExportLogsServiceResponseFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportLogsServiceResponse() {
		t.Run(name, func(t *testing.T) {
			dest := NewExportLogsServiceResponse()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExportLogsServiceResponseUnknown(t *testing.T) {
	dest := NewExportLogsServiceResponse()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExportLogsServiceResponse(), dest)
}

func TestMarshalAndUnmarshalProtoExportLogsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExportLogsServiceResponse()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExportLogsServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportLogsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceResponse() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectorlogs.ExportLogsServiceResponse{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExportLogsServiceResponse()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportLogsServiceResponse() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"PartialSuccess/wrong_wire_type": {0xc},
		"PartialSuccess/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportLogsServiceResponse() map[string]*ExportLogsServiceResponse {
	return map[string]*ExportLogsServiceResponse{
		"empty":               NewExportLogsServiceResponse(),
		"PartialSuccess/test": {PartialSuccess: *GenTestExportLogsPartialSuccess()},
	}
}
