// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyResourceProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceProfiles() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewResourceProfiles()
				CopyResourceProfiles(dest, src)
				assert.Equal(t, src, dest)
				CopyResourceProfiles(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyResourceProfilesSlice(t *testing.T) {
	src := []ResourceProfiles{}
	dest := []ResourceProfiles{}
	// Test CopyTo empty
	dest = CopyResourceProfilesSlice(dest, src)
	assert.Equal(t, []ResourceProfiles{}, dest)

	// Test CopyTo larger slice
	src = GenTestResourceProfilesSlice()
	dest = CopyResourceProfilesSlice(dest, src)
	assert.Equal(t, GenTestResourceProfilesSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyResourceProfilesSlice(dest, src)
	assert.Equal(t, GenTestResourceProfilesSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyResourceProfilesSlice(dest, []ResourceProfiles{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyResourceProfilesSlice(dest, src)
	assert.Equal(t, GenTestResourceProfilesSlice(), dest)
}

func TestCopyResourceProfilesPtrSlice(t *testing.T) {
	src := []*ResourceProfiles{}
	dest := []*ResourceProfiles{}
	// Test CopyTo empty
	dest = CopyResourceProfilesPtrSlice(dest, src)
	assert.Equal(t, []*ResourceProfiles{}, dest)

	// Test CopyTo larger slice
	src = GenTestResourceProfilesPtrSlice()
	dest = CopyResourceProfilesPtrSlice(dest, src)
	assert.Equal(t, GenTestResourceProfilesPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyResourceProfilesPtrSlice(dest, src)
	assert.Equal(t, GenTestResourceProfilesPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyResourceProfilesPtrSlice(dest, []*ResourceProfiles{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyResourceProfilesPtrSlice(dest, src)
	assert.Equal(t, GenTestResourceProfilesPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONResourceProfilesUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewResourceProfiles()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewResourceProfiles(), dest)
}

func TestMarshalAndUnmarshalJSONResourceProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceProfiles() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewResourceProfiles()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteResourceProfiles(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoResourceProfilesFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesResourceProfiles() {
		t.Run(name, func(t *testing.T) {
			dest := NewResourceProfiles()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoResourceProfilesUnknown(t *testing.T) {
	dest := NewResourceProfiles()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewResourceProfiles(), dest)
}

func TestMarshalAndUnmarshalProtoResourceProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceProfiles() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewResourceProfiles()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteResourceProfiles(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufResourceProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceProfiles() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.ResourceProfiles{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewResourceProfiles()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesResourceProfiles() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                 {0x02},
		"Resource/wrong_wire_type":      {0xc},
		"Resource/missing_value":        {0xa},
		"ScopeProfiles/wrong_wire_type": {0x14},
		"ScopeProfiles/missing_value":   {0x12},
		"SchemaUrl/wrong_wire_type":     {0x1c},
		"SchemaUrl/missing_value":       {0x1a},
	}
}

func genTestEncodingValuesResourceProfiles() map[string]*ResourceProfiles {
	return map[string]*ResourceProfiles{
		"empty":              NewResourceProfiles(),
		"Resource/test":      {Resource: *GenTestResource()},
		"ScopeProfiles/test": {ScopeProfiles: []*ScopeProfiles{{}, GenTestScopeProfiles()}},
		"SchemaUrl/test":     {SchemaUrl: "test_schemaurl"},
	}
}
