// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExponentialHistogramDataPointBuckets(t *testing.T) {
	for name, src := range genTestEncodingValuesExponentialHistogramDataPointBuckets() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExponentialHistogramDataPointBuckets()
				CopyExponentialHistogramDataPointBuckets(dest, src)
				assert.Equal(t, src, dest)
				CopyExponentialHistogramDataPointBuckets(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExponentialHistogramDataPointBucketsSlice(t *testing.T) {
	src := []ExponentialHistogramDataPointBuckets{}
	dest := []ExponentialHistogramDataPointBuckets{}
	// Test CopyTo empty
	dest = CopyExponentialHistogramDataPointBucketsSlice(dest, src)
	assert.Equal(t, []ExponentialHistogramDataPointBuckets{}, dest)

	// Test CopyTo larger slice
	src = GenTestExponentialHistogramDataPointBucketsSlice()
	dest = CopyExponentialHistogramDataPointBucketsSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramDataPointBucketsSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExponentialHistogramDataPointBucketsSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramDataPointBucketsSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExponentialHistogramDataPointBucketsSlice(dest, []ExponentialHistogramDataPointBuckets{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExponentialHistogramDataPointBucketsSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramDataPointBucketsSlice(), dest)
}

func TestCopyExponentialHistogramDataPointBucketsPtrSlice(t *testing.T) {
	src := []*ExponentialHistogramDataPointBuckets{}
	dest := []*ExponentialHistogramDataPointBuckets{}
	// Test CopyTo empty
	dest = CopyExponentialHistogramDataPointBucketsPtrSlice(dest, src)
	assert.Equal(t, []*ExponentialHistogramDataPointBuckets{}, dest)

	// Test CopyTo larger slice
	src = GenTestExponentialHistogramDataPointBucketsPtrSlice()
	dest = CopyExponentialHistogramDataPointBucketsPtrSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramDataPointBucketsPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExponentialHistogramDataPointBucketsPtrSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramDataPointBucketsPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExponentialHistogramDataPointBucketsPtrSlice(dest, []*ExponentialHistogramDataPointBuckets{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExponentialHistogramDataPointBucketsPtrSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramDataPointBucketsPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExponentialHistogramDataPointBucketsUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExponentialHistogramDataPointBuckets()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExponentialHistogramDataPointBuckets(), dest)
}

func TestMarshalAndUnmarshalJSONExponentialHistogramDataPointBuckets(t *testing.T) {
	for name, src := range genTestEncodingValuesExponentialHistogramDataPointBuckets() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExponentialHistogramDataPointBuckets()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExponentialHistogramDataPointBuckets(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExponentialHistogramDataPointBucketsFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExponentialHistogramDataPointBuckets() {
		t.Run(name, func(t *testing.T) {
			dest := NewExponentialHistogramDataPointBuckets()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExponentialHistogramDataPointBucketsUnknown(t *testing.T) {
	dest := NewExponentialHistogramDataPointBuckets()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExponentialHistogramDataPointBuckets(), dest)
}

func TestMarshalAndUnmarshalProtoExponentialHistogramDataPointBuckets(t *testing.T) {
	for name, src := range genTestEncodingValuesExponentialHistogramDataPointBuckets() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExponentialHistogramDataPointBuckets()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExponentialHistogramDataPointBuckets(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExponentialHistogramDataPointBuckets(t *testing.T) {
	for name, src := range genTestEncodingValuesExponentialHistogramDataPointBuckets() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.ExponentialHistogramDataPoint_Buckets{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExponentialHistogramDataPointBuckets()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExponentialHistogramDataPointBuckets() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                {0x02},
		"Offset/wrong_wire_type":       {0xc},
		"Offset/missing_value":         {0x8},
		"BucketCounts/wrong_wire_type": {0x14},
		"BucketCounts/missing_value":   {0x12},
	}
}

func genTestEncodingValuesExponentialHistogramDataPointBuckets() map[string]*ExponentialHistogramDataPointBuckets {
	return map[string]*ExponentialHistogramDataPointBuckets{
		"empty":             NewExponentialHistogramDataPointBuckets(),
		"Offset/test":       {Offset: int32(13)},
		"BucketCounts/test": {BucketCounts: []uint64{uint64(0), uint64(13)}},
	}
}
