// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"
	"unsafe"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
)

func TestScopeMetricsSlice(t *testing.T) {
	es := NewScopeMetricsSlice()
	assert.Equal(t, 0, es.Len())
	es = newScopeMetricsSlice(&[]*internal.ScopeMetrics{}, internal.NewState())
	assert.Equal(t, 0, es.Len())

	emptyVal := NewScopeMetrics()
	testVal := generateTestScopeMetrics()
	for i := 0; i < 7; i++ {
		es.AppendEmpty()
		assert.Equal(t, emptyVal, es.At(i))
		(*es.orig)[i] = internal.GenTestScopeMetrics()
		assert.Equal(t, testVal, es.At(i))
	}
	assert.Equal(t, 7, es.Len())
}

func TestScopeMetricsSliceReadOnly(t *testing.T) {
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	es := newScopeMetricsSlice(&[]*internal.ScopeMetrics{}, sharedState)
	assert.Equal(t, 0, es.Len())
	assert.Panics(t, func() { es.AppendEmpty() })
	assert.Panics(t, func() { es.EnsureCapacity(2) })
	es2 := NewScopeMetricsSlice()
	es.CopyTo(es2)
	assert.Panics(t, func() { es2.CopyTo(es) })
	assert.Panics(t, func() { es.MoveAndAppendTo(es2) })
	assert.Panics(t, func() { es2.MoveAndAppendTo(es) })
}

func TestScopeMetricsSlice_CopyTo(t *testing.T) {
	dest := NewScopeMetricsSlice()
	src := generateTestScopeMetricsSlice()
	src.CopyTo(dest)
	assert.Equal(t, generateTestScopeMetricsSlice(), dest)
	dest.CopyTo(dest)
	assert.Equal(t, generateTestScopeMetricsSlice(), dest)
}

func TestScopeMetricsSlice_EnsureCapacity(t *testing.T) {
	es := generateTestScopeMetricsSlice()

	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	assert.Equal(t, es.Len(), cap(*es.orig))
	assert.Equal(t, generateTestScopeMetricsSlice(), es)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	es.EnsureCapacity(ensureLargeLen)
	assert.Less(t, generateTestScopeMetricsSlice().Len(), ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	assert.Equal(t, generateTestScopeMetricsSlice(), es)
}

func TestScopeMetricsSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestScopeMetricsSlice()
	dest := NewScopeMetricsSlice()
	src := generateTestScopeMetricsSlice()
	src.MoveAndAppendTo(dest)
	assert.Equal(t, generateTestScopeMetricsSlice(), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, generateTestScopeMetricsSlice(), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestScopeMetricsSlice().MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}

	dest.MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestScopeMetricsSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewScopeMetricsSlice()
	emptySlice.RemoveIf(func(el ScopeMetrics) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestScopeMetricsSlice()
	pos := 0
	filtered.RemoveIf(func(el ScopeMetrics) bool {
		pos++
		return pos%2 == 1
	})
	assert.Equal(t, 2, filtered.Len())
}

func TestScopeMetricsSlice_RemoveIfAll(t *testing.T) {
	got := generateTestScopeMetricsSlice()
	got.RemoveIf(func(el ScopeMetrics) bool {
		return true
	})
	assert.Equal(t, 0, got.Len())
}

func TestScopeMetricsSliceAll(t *testing.T) {
	ms := generateTestScopeMetricsSlice()
	assert.NotEmpty(t, ms.Len())

	var c int
	for i, v := range ms.All() {
		assert.Equal(t, ms.At(i), v, "element should match")
		c++
	}
	assert.Equal(t, ms.Len(), c, "All elements should have been visited")
}

func TestScopeMetricsSlice_Sort(t *testing.T) {
	es := generateTestScopeMetricsSlice()
	es.Sort(func(a, b ScopeMetrics) bool {
		return uintptr(unsafe.Pointer(a.orig)) < uintptr(unsafe.Pointer(b.orig))
	})
	for i := 1; i < es.Len(); i++ {
		assert.Less(t, uintptr(unsafe.Pointer(es.At(i-1).orig)), uintptr(unsafe.Pointer(es.At(i).orig)))
	}
	es.Sort(func(a, b ScopeMetrics) bool {
		return uintptr(unsafe.Pointer(a.orig)) > uintptr(unsafe.Pointer(b.orig))
	})
	for i := 1; i < es.Len(); i++ {
		assert.Greater(t, uintptr(unsafe.Pointer(es.At(i-1).orig)), uintptr(unsafe.Pointer(es.At(i).orig)))
	}
}

func generateTestScopeMetricsSlice() ScopeMetricsSlice {
	ms := NewScopeMetricsSlice()
	*ms.orig = internal.GenTestScopeMetricsPtrSlice()
	return ms
}
