// Copyright 2013-present Barefoot Networks, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v3.18.1
// source: p4/config/v1/p4info.proto

// This package and its contents are a work-in-progress.

package v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ids are allocated in such a way that it is possible based on an id to
// deduce the resource type (e.g. table, action, counter, ...). The
// most-significant byte of the 32-bit id encodes the resource type. The
// purpose of this enum is to define which value is used as the
// most-significant byte for each resource type. The P4 compiler must use
// these values when allocating ids for P4 objects. Other users of P4Info can
// refer to this enum to identify a resource type based on its id.
type P4Ids_Prefix int32

const (
	P4Ids_UNSPECIFIED P4Ids_Prefix = 0
	// P4 language built-ins
	P4Ids_ACTION            P4Ids_Prefix = 1
	P4Ids_TABLE             P4Ids_Prefix = 2
	P4Ids_VALUE_SET         P4Ids_Prefix = 3
	P4Ids_CONTROLLER_HEADER P4Ids_Prefix = 4
	// PSA externs
	P4Ids_PSA_EXTERNS_START P4Ids_Prefix = 16
	P4Ids_ACTION_PROFILE    P4Ids_Prefix = 17
	P4Ids_COUNTER           P4Ids_Prefix = 18
	P4Ids_DIRECT_COUNTER    P4Ids_Prefix = 19
	P4Ids_METER             P4Ids_Prefix = 20
	P4Ids_DIRECT_METER      P4Ids_Prefix = 21
	P4Ids_REGISTER          P4Ids_Prefix = 22
	P4Ids_DIGEST            P4Ids_Prefix = 23
	// externs for other architectures (vendor extensions)
	P4Ids_OTHER_EXTERNS_START P4Ids_Prefix = 128
	// max value for an unsigned 8-bit byte
	P4Ids_MAX P4Ids_Prefix = 255
)

// Enum value maps for P4Ids_Prefix.
var (
	P4Ids_Prefix_name = map[int32]string{
		0:   "UNSPECIFIED",
		1:   "ACTION",
		2:   "TABLE",
		3:   "VALUE_SET",
		4:   "CONTROLLER_HEADER",
		16:  "PSA_EXTERNS_START",
		17:  "ACTION_PROFILE",
		18:  "COUNTER",
		19:  "DIRECT_COUNTER",
		20:  "METER",
		21:  "DIRECT_METER",
		22:  "REGISTER",
		23:  "DIGEST",
		128: "OTHER_EXTERNS_START",
		255: "MAX",
	}
	P4Ids_Prefix_value = map[string]int32{
		"UNSPECIFIED":         0,
		"ACTION":              1,
		"TABLE":               2,
		"VALUE_SET":           3,
		"CONTROLLER_HEADER":   4,
		"PSA_EXTERNS_START":   16,
		"ACTION_PROFILE":      17,
		"COUNTER":             18,
		"DIRECT_COUNTER":      19,
		"METER":               20,
		"DIRECT_METER":        21,
		"REGISTER":            22,
		"DIGEST":              23,
		"OTHER_EXTERNS_START": 128,
		"MAX":                 255,
	}
)

func (x P4Ids_Prefix) Enum() *P4Ids_Prefix {
	p := new(P4Ids_Prefix)
	*p = x
	return p
}

func (x P4Ids_Prefix) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (P4Ids_Prefix) Descriptor() protoreflect.EnumDescriptor {
	return file_p4_config_v1_p4info_proto_enumTypes[0].Descriptor()
}

func (P4Ids_Prefix) Type() protoreflect.EnumType {
	return &file_p4_config_v1_p4info_proto_enumTypes[0]
}

func (x P4Ids_Prefix) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use P4Ids_Prefix.Descriptor instead.
func (P4Ids_Prefix) EnumDescriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{4, 0}
}

type MatchField_MatchType int32

const (
	MatchField_UNSPECIFIED MatchField_MatchType = 0
	MatchField_EXACT       MatchField_MatchType = 2
	MatchField_LPM         MatchField_MatchType = 3
	MatchField_TERNARY     MatchField_MatchType = 4
	MatchField_RANGE       MatchField_MatchType = 5
	MatchField_OPTIONAL    MatchField_MatchType = 6
)

// Enum value maps for MatchField_MatchType.
var (
	MatchField_MatchType_name = map[int32]string{
		0: "UNSPECIFIED",
		2: "EXACT",
		3: "LPM",
		4: "TERNARY",
		5: "RANGE",
		6: "OPTIONAL",
	}
	MatchField_MatchType_value = map[string]int32{
		"UNSPECIFIED": 0,
		"EXACT":       2,
		"LPM":         3,
		"TERNARY":     4,
		"RANGE":       5,
		"OPTIONAL":    6,
	}
)

func (x MatchField_MatchType) Enum() *MatchField_MatchType {
	p := new(MatchField_MatchType)
	*p = x
	return p
}

func (x MatchField_MatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MatchField_MatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_p4_config_v1_p4info_proto_enumTypes[1].Descriptor()
}

func (MatchField_MatchType) Type() protoreflect.EnumType {
	return &file_p4_config_v1_p4info_proto_enumTypes[1]
}

func (x MatchField_MatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MatchField_MatchType.Descriptor instead.
func (MatchField_MatchType) EnumDescriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{8, 0}
}

// this enum can be extended in the future with other behaviors, such as
// "HARD_EVICTION"
type Table_IdleTimeoutBehavior int32

const (
	Table_NO_TIMEOUT     Table_IdleTimeoutBehavior = 0
	Table_NOTIFY_CONTROL Table_IdleTimeoutBehavior = 1
)

// Enum value maps for Table_IdleTimeoutBehavior.
var (
	Table_IdleTimeoutBehavior_name = map[int32]string{
		0: "NO_TIMEOUT",
		1: "NOTIFY_CONTROL",
	}
	Table_IdleTimeoutBehavior_value = map[string]int32{
		"NO_TIMEOUT":     0,
		"NOTIFY_CONTROL": 1,
	}
)

func (x Table_IdleTimeoutBehavior) Enum() *Table_IdleTimeoutBehavior {
	p := new(Table_IdleTimeoutBehavior)
	*p = x
	return p
}

func (x Table_IdleTimeoutBehavior) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Table_IdleTimeoutBehavior) Descriptor() protoreflect.EnumDescriptor {
	return file_p4_config_v1_p4info_proto_enumTypes[2].Descriptor()
}

func (Table_IdleTimeoutBehavior) Type() protoreflect.EnumType {
	return &file_p4_config_v1_p4info_proto_enumTypes[2]
}

func (x Table_IdleTimeoutBehavior) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Table_IdleTimeoutBehavior.Descriptor instead.
func (Table_IdleTimeoutBehavior) EnumDescriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{10, 0}
}

type ActionRef_Scope int32

const (
	ActionRef_TABLE_AND_DEFAULT ActionRef_Scope = 0
	ActionRef_TABLE_ONLY        ActionRef_Scope = 1
	ActionRef_DEFAULT_ONLY      ActionRef_Scope = 2
)

// Enum value maps for ActionRef_Scope.
var (
	ActionRef_Scope_name = map[int32]string{
		0: "TABLE_AND_DEFAULT",
		1: "TABLE_ONLY",
		2: "DEFAULT_ONLY",
	}
	ActionRef_Scope_value = map[string]int32{
		"TABLE_AND_DEFAULT": 0,
		"TABLE_ONLY":        1,
		"DEFAULT_ONLY":      2,
	}
)

func (x ActionRef_Scope) Enum() *ActionRef_Scope {
	p := new(ActionRef_Scope)
	*p = x
	return p
}

func (x ActionRef_Scope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActionRef_Scope) Descriptor() protoreflect.EnumDescriptor {
	return file_p4_config_v1_p4info_proto_enumTypes[3].Descriptor()
}

func (ActionRef_Scope) Type() protoreflect.EnumType {
	return &file_p4_config_v1_p4info_proto_enumTypes[3]
}

func (x ActionRef_Scope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActionRef_Scope.Descriptor instead.
func (ActionRef_Scope) EnumDescriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{11, 0}
}

// Corresponds to 'type' constructor parameter for Counter / DirectCounter in
// PSA
type CounterSpec_Unit int32

const (
	CounterSpec_UNSPECIFIED CounterSpec_Unit = 0
	CounterSpec_BYTES       CounterSpec_Unit = 1
	CounterSpec_PACKETS     CounterSpec_Unit = 2
	CounterSpec_BOTH        CounterSpec_Unit = 3
)

// Enum value maps for CounterSpec_Unit.
var (
	CounterSpec_Unit_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "BYTES",
		2: "PACKETS",
		3: "BOTH",
	}
	CounterSpec_Unit_value = map[string]int32{
		"UNSPECIFIED": 0,
		"BYTES":       1,
		"PACKETS":     2,
		"BOTH":        3,
	}
)

func (x CounterSpec_Unit) Enum() *CounterSpec_Unit {
	p := new(CounterSpec_Unit)
	*p = x
	return p
}

func (x CounterSpec_Unit) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CounterSpec_Unit) Descriptor() protoreflect.EnumDescriptor {
	return file_p4_config_v1_p4info_proto_enumTypes[4].Descriptor()
}

func (CounterSpec_Unit) Type() protoreflect.EnumType {
	return &file_p4_config_v1_p4info_proto_enumTypes[4]
}

func (x CounterSpec_Unit) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CounterSpec_Unit.Descriptor instead.
func (CounterSpec_Unit) EnumDescriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{14, 0}
}

// Corresponds to 'type' constructor parameter for Meter / DirectMeter in PSA
type MeterSpec_Unit int32

const (
	MeterSpec_UNSPECIFIED MeterSpec_Unit = 0
	MeterSpec_BYTES       MeterSpec_Unit = 1
	MeterSpec_PACKETS     MeterSpec_Unit = 2
)

// Enum value maps for MeterSpec_Unit.
var (
	MeterSpec_Unit_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "BYTES",
		2: "PACKETS",
	}
	MeterSpec_Unit_value = map[string]int32{
		"UNSPECIFIED": 0,
		"BYTES":       1,
		"PACKETS":     2,
	}
)

func (x MeterSpec_Unit) Enum() *MeterSpec_Unit {
	p := new(MeterSpec_Unit)
	*p = x
	return p
}

func (x MeterSpec_Unit) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeterSpec_Unit) Descriptor() protoreflect.EnumDescriptor {
	return file_p4_config_v1_p4info_proto_enumTypes[5].Descriptor()
}

func (MeterSpec_Unit) Type() protoreflect.EnumType {
	return &file_p4_config_v1_p4info_proto_enumTypes[5]
}

func (x MeterSpec_Unit) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeterSpec_Unit.Descriptor instead.
func (MeterSpec_Unit) EnumDescriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{17, 0}
}

// Used to restrict the MeterConfigs that can be used to instantiate the
// meter.
// Added in 1.4.0.
type MeterSpec_Type int32

const (
	// As described in RFC 2698, allows meters to use two rates to split packets
	// into three potential colors.
	// MeterConfigs on table entries using this meter type MUST have `eburst ==
	// 0` (i.e. unset).
	MeterSpec_TWO_RATE_THREE_COLOR MeterSpec_Type = 0
	// As described in RFC 2697, allows meters to use one rate with an Excess
	// Burst Size (EBS) to split packets into three potential colors.
	// MeterConfigs on table entries using this meter type MUST have
	// `cir == pir && cburst == pburst`.
	MeterSpec_SINGLE_RATE_THREE_COLOR MeterSpec_Type = 1
	// A simplified version of RFC 2697, restricting meters to using a single
	// rate to split packets into only RED or GREEN, by not providing an Excess
	// Burst Size (EBS).
	// MeterConfigs on table entries using this meter type MUST have
	// `cir == pir && cburst == pburst && eburst == 0` (i.e. unset).
	MeterSpec_SINGLE_RATE_TWO_COLOR MeterSpec_Type = 2
)

// Enum value maps for MeterSpec_Type.
var (
	MeterSpec_Type_name = map[int32]string{
		0: "TWO_RATE_THREE_COLOR",
		1: "SINGLE_RATE_THREE_COLOR",
		2: "SINGLE_RATE_TWO_COLOR",
	}
	MeterSpec_Type_value = map[string]int32{
		"TWO_RATE_THREE_COLOR":    0,
		"SINGLE_RATE_THREE_COLOR": 1,
		"SINGLE_RATE_TWO_COLOR":   2,
	}
)

func (x MeterSpec_Type) Enum() *MeterSpec_Type {
	p := new(MeterSpec_Type)
	*p = x
	return p
}

func (x MeterSpec_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeterSpec_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_p4_config_v1_p4info_proto_enumTypes[6].Descriptor()
}

func (MeterSpec_Type) Type() protoreflect.EnumType {
	return &file_p4_config_v1_p4info_proto_enumTypes[6]
}

func (x MeterSpec_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeterSpec_Type.Descriptor instead.
func (MeterSpec_Type) EnumDescriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{17, 1}
}

type P4Info struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PkgInfo                  *PkgInfo                    `protobuf:"bytes,1,opt,name=pkg_info,json=pkgInfo,proto3" json:"pkg_info,omitempty"`
	Tables                   []*Table                    `protobuf:"bytes,2,rep,name=tables,proto3" json:"tables,omitempty"`
	Actions                  []*Action                   `protobuf:"bytes,3,rep,name=actions,proto3" json:"actions,omitempty"`
	ActionProfiles           []*ActionProfile            `protobuf:"bytes,4,rep,name=action_profiles,json=actionProfiles,proto3" json:"action_profiles,omitempty"`
	Counters                 []*Counter                  `protobuf:"bytes,5,rep,name=counters,proto3" json:"counters,omitempty"`
	DirectCounters           []*DirectCounter            `protobuf:"bytes,6,rep,name=direct_counters,json=directCounters,proto3" json:"direct_counters,omitempty"`
	Meters                   []*Meter                    `protobuf:"bytes,7,rep,name=meters,proto3" json:"meters,omitempty"`
	DirectMeters             []*DirectMeter              `protobuf:"bytes,8,rep,name=direct_meters,json=directMeters,proto3" json:"direct_meters,omitempty"`
	ControllerPacketMetadata []*ControllerPacketMetadata `protobuf:"bytes,9,rep,name=controller_packet_metadata,json=controllerPacketMetadata,proto3" json:"controller_packet_metadata,omitempty"`
	ValueSets                []*ValueSet                 `protobuf:"bytes,10,rep,name=value_sets,json=valueSets,proto3" json:"value_sets,omitempty"`
	Registers                []*Register                 `protobuf:"bytes,11,rep,name=registers,proto3" json:"registers,omitempty"`
	Digests                  []*Digest                   `protobuf:"bytes,12,rep,name=digests,proto3" json:"digests,omitempty"`
	Externs                  []*Extern                   `protobuf:"bytes,100,rep,name=externs,proto3" json:"externs,omitempty"`
	TypeInfo                 *P4TypeInfo                 `protobuf:"bytes,200,opt,name=type_info,json=typeInfo,proto3" json:"type_info,omitempty"`
}

func (x *P4Info) Reset() {
	*x = P4Info{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4Info) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4Info) ProtoMessage() {}

func (x *P4Info) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4Info.ProtoReflect.Descriptor instead.
func (*P4Info) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{0}
}

func (x *P4Info) GetPkgInfo() *PkgInfo {
	if x != nil {
		return x.PkgInfo
	}
	return nil
}

func (x *P4Info) GetTables() []*Table {
	if x != nil {
		return x.Tables
	}
	return nil
}

func (x *P4Info) GetActions() []*Action {
	if x != nil {
		return x.Actions
	}
	return nil
}

func (x *P4Info) GetActionProfiles() []*ActionProfile {
	if x != nil {
		return x.ActionProfiles
	}
	return nil
}

func (x *P4Info) GetCounters() []*Counter {
	if x != nil {
		return x.Counters
	}
	return nil
}

func (x *P4Info) GetDirectCounters() []*DirectCounter {
	if x != nil {
		return x.DirectCounters
	}
	return nil
}

func (x *P4Info) GetMeters() []*Meter {
	if x != nil {
		return x.Meters
	}
	return nil
}

func (x *P4Info) GetDirectMeters() []*DirectMeter {
	if x != nil {
		return x.DirectMeters
	}
	return nil
}

func (x *P4Info) GetControllerPacketMetadata() []*ControllerPacketMetadata {
	if x != nil {
		return x.ControllerPacketMetadata
	}
	return nil
}

func (x *P4Info) GetValueSets() []*ValueSet {
	if x != nil {
		return x.ValueSets
	}
	return nil
}

func (x *P4Info) GetRegisters() []*Register {
	if x != nil {
		return x.Registers
	}
	return nil
}

func (x *P4Info) GetDigests() []*Digest {
	if x != nil {
		return x.Digests
	}
	return nil
}

func (x *P4Info) GetExterns() []*Extern {
	if x != nil {
		return x.Externs
	}
	return nil
}

func (x *P4Info) GetTypeInfo() *P4TypeInfo {
	if x != nil {
		return x.TypeInfo
	}
	return nil
}

type Documentation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A brief description of something, e.g. one sentence
	Brief string `protobuf:"bytes,1,opt,name=brief,proto3" json:"brief,omitempty"`
	// A more verbose description of something. Multiline is accepted. Markup
	// format (if any) is TBD.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Documentation) Reset() {
	*x = Documentation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Documentation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Documentation) ProtoMessage() {}

func (x *Documentation) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Documentation.ProtoReflect.Descriptor instead.
func (*Documentation) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{1}
}

func (x *Documentation) GetBrief() string {
	if x != nil {
		return x.Brief
	}
	return ""
}

func (x *Documentation) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Used to describe the required properties of the underlying platform.
// Added in v1.4.0
type PlatformProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum number of multicast entries (i.e. multicast groups) that the
	// platform is required to support. If 0, there are no requirements.
	MulticastGroupTableSize int32 `protobuf:"varint,1,opt,name=multicast_group_table_size,json=multicastGroupTableSize,proto3" json:"multicast_group_table_size,omitempty"`
	// The minimum number of replicas that the platform is required to support
	// across all  groups. If 0, there are no requirements.
	MulticastGroupTableTotalReplicas int32 `protobuf:"varint,2,opt,name=multicast_group_table_total_replicas,json=multicastGroupTableTotalReplicas,proto3" json:"multicast_group_table_total_replicas,omitempty"`
	// The number of replicas that the platform is required to support per
	// group/entry. If 0, `multicast_group_table_total_replicas` should be used.
	// Must be no larger than `multicast_group_table_total_replicas`.
	MulticastGroupTableMaxReplicasPerEntry int32 `protobuf:"varint,3,opt,name=multicast_group_table_max_replicas_per_entry,json=multicastGroupTableMaxReplicasPerEntry,proto3" json:"multicast_group_table_max_replicas_per_entry,omitempty"`
}

func (x *PlatformProperties) Reset() {
	*x = PlatformProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformProperties) ProtoMessage() {}

func (x *PlatformProperties) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformProperties.ProtoReflect.Descriptor instead.
func (*PlatformProperties) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{2}
}

func (x *PlatformProperties) GetMulticastGroupTableSize() int32 {
	if x != nil {
		return x.MulticastGroupTableSize
	}
	return 0
}

func (x *PlatformProperties) GetMulticastGroupTableTotalReplicas() int32 {
	if x != nil {
		return x.MulticastGroupTableTotalReplicas
	}
	return 0
}

func (x *PlatformProperties) GetMulticastGroupTableMaxReplicasPerEntry() int32 {
	if x != nil {
		return x.MulticastGroupTableMaxReplicasPerEntry
	}
	return 0
}

// Top-level package documentation describing the forwarding pipeline config
// Can be used to manage multiple P4 packages.
type PkgInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// a definitive name for this configuration, e.g. switch.p4_v1.0
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// configuration version, free-format string
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// brief and detailed descriptions
	Doc *Documentation `protobuf:"bytes,3,opt,name=doc,proto3" json:"doc,omitempty"`
	// Miscellaneous metadata, free-form; a way to extend PkgInfo
	Annotations []string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations []*SourceLocation `protobuf:"bytes,10,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	// the target architecture, e.g. "psa"
	Arch string `protobuf:"bytes,5,opt,name=arch,proto3" json:"arch,omitempty"`
	// organization which produced the configuration, e.g. "p4.org"
	Organization string `protobuf:"bytes,6,opt,name=organization,proto3" json:"organization,omitempty"`
	// contact info for support,e.g. "tech-support@acme.org"
	Contact string `protobuf:"bytes,7,opt,name=contact,proto3" json:"contact,omitempty"`
	// url for more information, e.g.
	// "http://support.p4.org/ref/p4/switch.p4_v1.0"
	Url string `protobuf:"bytes,8,opt,name=url,proto3" json:"url,omitempty"`
	// Miscellaneous metadata, structured; a way to extend PkgInfo
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,9,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
	// If set, specifies the properties that the underlying platform should have.
	// If the platform does not conform to these properties, the server should
	// reject the P4Info when used with a SetForwardingPipelineConfigRequest.
	// Added in 1.4.0
	PlatformProperties *PlatformProperties `protobuf:"bytes,11,opt,name=platform_properties,json=platformProperties,proto3" json:"platform_properties,omitempty"`
}

func (x *PkgInfo) Reset() {
	*x = PkgInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PkgInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PkgInfo) ProtoMessage() {}

func (x *PkgInfo) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PkgInfo.ProtoReflect.Descriptor instead.
func (*PkgInfo) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{3}
}

func (x *PkgInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PkgInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *PkgInfo) GetDoc() *Documentation {
	if x != nil {
		return x.Doc
	}
	return nil
}

func (x *PkgInfo) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PkgInfo) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *PkgInfo) GetArch() string {
	if x != nil {
		return x.Arch
	}
	return ""
}

func (x *PkgInfo) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *PkgInfo) GetContact() string {
	if x != nil {
		return x.Contact
	}
	return ""
}

func (x *PkgInfo) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *PkgInfo) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

func (x *PkgInfo) GetPlatformProperties() *PlatformProperties {
	if x != nil {
		return x.PlatformProperties
	}
	return nil
}

// wrapping the enum in a message to avoid name collisions in C++, where "enum
// values are siblings of their type, not children of it"
type P4Ids struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *P4Ids) Reset() {
	*x = P4Ids{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *P4Ids) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*P4Ids) ProtoMessage() {}

func (x *P4Ids) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use P4Ids.ProtoReflect.Descriptor instead.
func (*P4Ids) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{4}
}

type Preamble struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ids share the same number-space; e.g. table ids cannot overlap with counter
	// ids. Even though this is irrelevant to this proto definition, the ids are
	// allocated in such a way that it is possible based on an id to deduce the
	// resource type (e.g. table, action, counter, ...). This means that code
	// using these ids can detect if the wrong resource type is used
	// somewhere. This also means that ids of different types can be mixed
	// (e.g. direct resource list for a table) without ambiguity. Note that id 0
	// is reserved and means "invalid id".
	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// fully qualified name of the P4 object, e.g. c1.c2.ipv4_lpm
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// an alias (alternative name) for the P4 object, probably shorter than its
	// fully qualified name. The only constraint is for it to be unique with
	// respect to other P4 objects of the same type. By default, the compiler uses
	// the shortest suffix of the name that uniquely identifies the object. For
	// example if the P4 program contains two tables with names s.c1.t and s.c2.t,
	// the default aliases will respectively be c1.t and c2.t. In the future, the
	// P4 programmer may also be able to override the default alias for any P4
	// object (TBD).
	Alias       string   `protobuf:"bytes,3,opt,name=alias,proto3" json:"alias,omitempty"`
	Annotations []string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations []*SourceLocation `protobuf:"bytes,7,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	// Documentation of the entity
	Doc                   *Documentation          `protobuf:"bytes,5,opt,name=doc,proto3" json:"doc,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,6,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *Preamble) Reset() {
	*x = Preamble{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Preamble) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Preamble) ProtoMessage() {}

func (x *Preamble) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Preamble.ProtoReflect.Descriptor instead.
func (*Preamble) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{5}
}

func (x *Preamble) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Preamble) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Preamble) GetAlias() string {
	if x != nil {
		return x.Alias
	}
	return ""
}

func (x *Preamble) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Preamble) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *Preamble) GetDoc() *Documentation {
	if x != nil {
		return x.Doc
	}
	return nil
}

func (x *Preamble) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

// used to group all extern instances of the same type in one message
type Extern struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the extern_type_id is unique for a given architecture and must be in the
	// range [0x81, 0xfe].
	ExternTypeId   uint32            `protobuf:"varint,1,opt,name=extern_type_id,json=externTypeId,proto3" json:"extern_type_id,omitempty"`
	ExternTypeName string            `protobuf:"bytes,2,opt,name=extern_type_name,json=externTypeName,proto3" json:"extern_type_name,omitempty"`
	Instances      []*ExternInstance `protobuf:"bytes,3,rep,name=instances,proto3" json:"instances,omitempty"`
}

func (x *Extern) Reset() {
	*x = Extern{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Extern) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Extern) ProtoMessage() {}

func (x *Extern) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Extern.ProtoReflect.Descriptor instead.
func (*Extern) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{6}
}

func (x *Extern) GetExternTypeId() uint32 {
	if x != nil {
		return x.ExternTypeId
	}
	return 0
}

func (x *Extern) GetExternTypeName() string {
	if x != nil {
		return x.ExternTypeName
	}
	return ""
}

func (x *Extern) GetInstances() []*ExternInstance {
	if x != nil {
		return x.Instances
	}
	return nil
}

type ExternInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Preamble *Preamble `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
	// specific to the extern type, declared in a separate vendor-specific proto
	// file
	Info *anypb.Any `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
}

func (x *ExternInstance) Reset() {
	*x = ExternInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternInstance) ProtoMessage() {}

func (x *ExternInstance) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternInstance.ProtoReflect.Descriptor instead.
func (*ExternInstance) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{7}
}

func (x *ExternInstance) GetPreamble() *Preamble {
	if x != nil {
		return x.Preamble
	}
	return nil
}

func (x *ExternInstance) GetInfo() *anypb.Any {
	if x != nil {
		return x.Info
	}
	return nil
}

type MatchField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id          uint32   `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Name        string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Annotations []string `protobuf:"bytes,3,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations []*SourceLocation `protobuf:"bytes,10,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	Bitwidth            int32             `protobuf:"varint,4,opt,name=bitwidth,proto3" json:"bitwidth,omitempty"`
	// Types that are assignable to Match:
	//
	//	*MatchField_MatchType_
	//	*MatchField_OtherMatchType
	Match isMatchField_Match `protobuf_oneof:"match"`
	// Documentation of the match field
	Doc *Documentation `protobuf:"bytes,6,opt,name=doc,proto3" json:"doc,omitempty"`
	// unset if not user-defined type
	TypeName              *P4NamedType            `protobuf:"bytes,8,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,9,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *MatchField) Reset() {
	*x = MatchField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MatchField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MatchField) ProtoMessage() {}

func (x *MatchField) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MatchField.ProtoReflect.Descriptor instead.
func (*MatchField) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{8}
}

func (x *MatchField) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *MatchField) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MatchField) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *MatchField) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *MatchField) GetBitwidth() int32 {
	if x != nil {
		return x.Bitwidth
	}
	return 0
}

func (m *MatchField) GetMatch() isMatchField_Match {
	if m != nil {
		return m.Match
	}
	return nil
}

func (x *MatchField) GetMatchType() MatchField_MatchType {
	if x, ok := x.GetMatch().(*MatchField_MatchType_); ok {
		return x.MatchType
	}
	return MatchField_UNSPECIFIED
}

func (x *MatchField) GetOtherMatchType() string {
	if x, ok := x.GetMatch().(*MatchField_OtherMatchType); ok {
		return x.OtherMatchType
	}
	return ""
}

func (x *MatchField) GetDoc() *Documentation {
	if x != nil {
		return x.Doc
	}
	return nil
}

func (x *MatchField) GetTypeName() *P4NamedType {
	if x != nil {
		return x.TypeName
	}
	return nil
}

func (x *MatchField) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

type isMatchField_Match interface {
	isMatchField_Match()
}

type MatchField_MatchType_ struct {
	MatchType MatchField_MatchType `protobuf:"varint,5,opt,name=match_type,json=matchType,proto3,enum=p4.config.v1.MatchField_MatchType,oneof"`
}

type MatchField_OtherMatchType struct {
	// used for architecture-specific match types which are not part of the core
	// P4 language or of the PSA architecture.
	OtherMatchType string `protobuf:"bytes,7,opt,name=other_match_type,json=otherMatchType,proto3,oneof"`
}

func (*MatchField_MatchType_) isMatchField_Match() {}

func (*MatchField_OtherMatchType) isMatchField_Match() {}

// A TableActionCall references a particular action id and executes the
// action with the supplied list of arguments.
// Arguments are matched to the id of the respective action parameter.
// TableActionCalls may be used as the default action call of a table implementation.
// Added in 1.4.0.
type TableActionCall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ActionId  uint32                      `protobuf:"varint,1,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	Arguments []*TableActionCall_Argument `protobuf:"bytes,4,rep,name=arguments,proto3" json:"arguments,omitempty"`
}

func (x *TableActionCall) Reset() {
	*x = TableActionCall{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableActionCall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableActionCall) ProtoMessage() {}

func (x *TableActionCall) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableActionCall.ProtoReflect.Descriptor instead.
func (*TableActionCall) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{9}
}

func (x *TableActionCall) GetActionId() uint32 {
	if x != nil {
		return x.ActionId
	}
	return 0
}

func (x *TableActionCall) GetArguments() []*TableActionCall_Argument {
	if x != nil {
		return x.Arguments
	}
	return nil
}

type Table struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Preamble    *Preamble     `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
	MatchFields []*MatchField `protobuf:"bytes,2,rep,name=match_fields,json=matchFields,proto3" json:"match_fields,omitempty"`
	// even when the table is indirect (see implementation_id) below, this field
	// includes all possible actions for the table; by using ActionRef instead of
	// a repeated field of action ids, each action reference in a P4 table is able
	// to have its own annotations
	ActionRefs []*ActionRef `protobuf:"bytes,3,rep,name=action_refs,json=actionRefs,proto3" json:"action_refs,omitempty"`
	// 0 (default value) means that the table does not have a const default action
	ConstDefaultActionId uint32 `protobuf:"varint,4,opt,name=const_default_action_id,json=constDefaultActionId,proto3" json:"const_default_action_id,omitempty"`
	// The initial default action of the table. This can be overridden at runtime.
	// Added in 1.4.0.
	InitialDefaultAction *TableActionCall `protobuf:"bytes,5,opt,name=initial_default_action,json=initialDefaultAction,proto3" json:"initial_default_action,omitempty"`
	// P4 id of the "implementation" for this table (e.g. action profile id); 0
	// (default value) means that the table is a regular (direct) match table. As
	// of today, only action profiles are supported but other table
	// implementations may be added in the future
	ImplementationId uint32 `protobuf:"varint,6,opt,name=implementation_id,json=implementationId,proto3" json:"implementation_id,omitempty"`
	// ids of the direct resources (if any) attached to this table; for now this
	// includes only direct counters and direct meters, but other resources may be
	// added in the future
	DirectResourceIds []uint32 `protobuf:"varint,7,rep,packed,name=direct_resource_ids,json=directResourceIds,proto3" json:"direct_resource_ids,omitempty"`
	Size              int64    `protobuf:"varint,8,opt,name=size,proto3" json:"size,omitempty"` // max number of entries in table
	// is idle timeout supported for this table?
	IdleTimeoutBehavior Table_IdleTimeoutBehavior `protobuf:"varint,9,opt,name=idle_timeout_behavior,json=idleTimeoutBehavior,proto3,enum=p4.config.v1.Table_IdleTimeoutBehavior" json:"idle_timeout_behavior,omitempty"`
	// True if and only if the table's entries are immutable,
	// i.e. defined using the 'const entries' table property in the P4
	// source code, and thus entries cannot be deleted, modified, or
	// inserted at run time.
	IsConstTable bool `protobuf:"varint,10,opt,name=is_const_table,json=isConstTable,proto3" json:"is_const_table,omitempty"`
	// True if and only if the table has initial entries defined using
	// the 'entries' table property in the P4 source code, either with
	// or without the 'const' qualifier on 'entries', and there is at
	// least one entry in that list.  This field is false if the list of
	// entries is empty in the P4 source code.
	// Added in 1.4.0.
	HasInitialEntries bool `protobuf:"varint,11,opt,name=has_initial_entries,json=hasInitialEntries,proto3" json:"has_initial_entries,omitempty"`
	// architecture-specific table properties which are not part of the core P4
	// language or of the PSA architecture.
	OtherProperties *anypb.Any `protobuf:"bytes,100,opt,name=other_properties,json=otherProperties,proto3" json:"other_properties,omitempty"`
}

func (x *Table) Reset() {
	*x = Table{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Table) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Table) ProtoMessage() {}

func (x *Table) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Table.ProtoReflect.Descriptor instead.
func (*Table) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{10}
}

func (x *Table) GetPreamble() *Preamble {
	if x != nil {
		return x.Preamble
	}
	return nil
}

func (x *Table) GetMatchFields() []*MatchField {
	if x != nil {
		return x.MatchFields
	}
	return nil
}

func (x *Table) GetActionRefs() []*ActionRef {
	if x != nil {
		return x.ActionRefs
	}
	return nil
}

func (x *Table) GetConstDefaultActionId() uint32 {
	if x != nil {
		return x.ConstDefaultActionId
	}
	return 0
}

func (x *Table) GetInitialDefaultAction() *TableActionCall {
	if x != nil {
		return x.InitialDefaultAction
	}
	return nil
}

func (x *Table) GetImplementationId() uint32 {
	if x != nil {
		return x.ImplementationId
	}
	return 0
}

func (x *Table) GetDirectResourceIds() []uint32 {
	if x != nil {
		return x.DirectResourceIds
	}
	return nil
}

func (x *Table) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *Table) GetIdleTimeoutBehavior() Table_IdleTimeoutBehavior {
	if x != nil {
		return x.IdleTimeoutBehavior
	}
	return Table_NO_TIMEOUT
}

func (x *Table) GetIsConstTable() bool {
	if x != nil {
		return x.IsConstTable
	}
	return false
}

func (x *Table) GetHasInitialEntries() bool {
	if x != nil {
		return x.HasInitialEntries
	}
	return false
}

func (x *Table) GetOtherProperties() *anypb.Any {
	if x != nil {
		return x.OtherProperties
	}
	return nil
}

// used to list all possible actions in a Table
type ActionRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id          uint32          `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Scope       ActionRef_Scope `protobuf:"varint,3,opt,name=scope,proto3,enum=p4.config.v1.ActionRef_Scope" json:"scope,omitempty"`
	Annotations []string        `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations   []*SourceLocation       `protobuf:"bytes,5,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,4,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *ActionRef) Reset() {
	*x = ActionRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionRef) ProtoMessage() {}

func (x *ActionRef) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionRef.ProtoReflect.Descriptor instead.
func (*ActionRef) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{11}
}

func (x *ActionRef) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *ActionRef) GetScope() ActionRef_Scope {
	if x != nil {
		return x.Scope
	}
	return ActionRef_TABLE_AND_DEFAULT
}

func (x *ActionRef) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ActionRef) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *ActionRef) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Preamble *Preamble       `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
	Params   []*Action_Param `protobuf:"bytes,2,rep,name=params,proto3" json:"params,omitempty"`
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{12}
}

func (x *Action) GetPreamble() *Preamble {
	if x != nil {
		return x.Preamble
	}
	return nil
}

func (x *Action) GetParams() []*Action_Param {
	if x != nil {
		return x.Params
	}
	return nil
}

type ActionProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Preamble *Preamble `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
	// the ids of the tables sharing this action profile
	TableIds []uint32 `protobuf:"varint,2,rep,packed,name=table_ids,json=tableIds,proto3" json:"table_ids,omitempty"`
	// true iff the action profile used dynamic selection
	WithSelector bool `protobuf:"varint,3,opt,name=with_selector,json=withSelector,proto3" json:"with_selector,omitempty"`
	// max number of member entries across all groups if the action profile does
	// not have a selector. Otherwise, semantics as specified by
	// `selector_size_semantics` below.
	Size int64 `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
	// 0 if the action profile does not have a selector. Otherwise, semantics as
	// specified by `selector_size_semantics` below.
	MaxGroupSize int32 `protobuf:"varint,5,opt,name=max_group_size,json=maxGroupSize,proto3" json:"max_group_size,omitempty"`
	// specifies the semantics of `size` and `max_group_size` above
	//
	// Types that are assignable to SelectorSizeSemantics:
	//
	//	*ActionProfile_SumOfWeights_
	//	*ActionProfile_SumOfMembers_
	SelectorSizeSemantics isActionProfile_SelectorSizeSemantics `protobuf_oneof:"selector_size_semantics"`
}

func (x *ActionProfile) Reset() {
	*x = ActionProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionProfile) ProtoMessage() {}

func (x *ActionProfile) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionProfile.ProtoReflect.Descriptor instead.
func (*ActionProfile) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{13}
}

func (x *ActionProfile) GetPreamble() *Preamble {
	if x != nil {
		return x.Preamble
	}
	return nil
}

func (x *ActionProfile) GetTableIds() []uint32 {
	if x != nil {
		return x.TableIds
	}
	return nil
}

func (x *ActionProfile) GetWithSelector() bool {
	if x != nil {
		return x.WithSelector
	}
	return false
}

func (x *ActionProfile) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *ActionProfile) GetMaxGroupSize() int32 {
	if x != nil {
		return x.MaxGroupSize
	}
	return 0
}

func (m *ActionProfile) GetSelectorSizeSemantics() isActionProfile_SelectorSizeSemantics {
	if m != nil {
		return m.SelectorSizeSemantics
	}
	return nil
}

func (x *ActionProfile) GetSumOfWeights() *ActionProfile_SumOfWeights {
	if x, ok := x.GetSelectorSizeSemantics().(*ActionProfile_SumOfWeights_); ok {
		return x.SumOfWeights
	}
	return nil
}

func (x *ActionProfile) GetSumOfMembers() *ActionProfile_SumOfMembers {
	if x, ok := x.GetSelectorSizeSemantics().(*ActionProfile_SumOfMembers_); ok {
		return x.SumOfMembers
	}
	return nil
}

type isActionProfile_SelectorSizeSemantics interface {
	isActionProfile_SelectorSizeSemantics()
}

type ActionProfile_SumOfWeights_ struct {
	// group size is the sum of the group's weights.
	// Added in v1.4.0
	SumOfWeights *ActionProfile_SumOfWeights `protobuf:"bytes,6,opt,name=sum_of_weights,json=sumOfWeights,proto3,oneof"`
}

type ActionProfile_SumOfMembers_ struct {
	// group size is the sum of the group's members.
	// Added in v1.4.0
	SumOfMembers *ActionProfile_SumOfMembers `protobuf:"bytes,7,opt,name=sum_of_members,json=sumOfMembers,proto3,oneof"`
}

func (*ActionProfile_SumOfWeights_) isActionProfile_SelectorSizeSemantics() {}

func (*ActionProfile_SumOfMembers_) isActionProfile_SelectorSizeSemantics() {}

type CounterSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Unit CounterSpec_Unit `protobuf:"varint,1,opt,name=unit,proto3,enum=p4.config.v1.CounterSpec_Unit" json:"unit,omitempty"`
}

func (x *CounterSpec) Reset() {
	*x = CounterSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CounterSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CounterSpec) ProtoMessage() {}

func (x *CounterSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CounterSpec.ProtoReflect.Descriptor instead.
func (*CounterSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{14}
}

func (x *CounterSpec) GetUnit() CounterSpec_Unit {
	if x != nil {
		return x.Unit
	}
	return CounterSpec_UNSPECIFIED
}

type Counter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Preamble *Preamble    `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
	Spec     *CounterSpec `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	// number of entries in the counter array
	Size int64 `protobuf:"varint,3,opt,name=size,proto3" json:"size,omitempty"`
	// unset if index is not user-defined type
	IndexTypeName *P4NamedType `protobuf:"bytes,4,opt,name=index_type_name,json=indexTypeName,proto3" json:"index_type_name,omitempty"`
}

func (x *Counter) Reset() {
	*x = Counter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Counter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Counter) ProtoMessage() {}

func (x *Counter) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Counter.ProtoReflect.Descriptor instead.
func (*Counter) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{15}
}

func (x *Counter) GetPreamble() *Preamble {
	if x != nil {
		return x.Preamble
	}
	return nil
}

func (x *Counter) GetSpec() *CounterSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *Counter) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *Counter) GetIndexTypeName() *P4NamedType {
	if x != nil {
		return x.IndexTypeName
	}
	return nil
}

type DirectCounter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Preamble *Preamble    `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
	Spec     *CounterSpec `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	// the id of the table to which the counter is attached
	DirectTableId uint32 `protobuf:"varint,3,opt,name=direct_table_id,json=directTableId,proto3" json:"direct_table_id,omitempty"`
}

func (x *DirectCounter) Reset() {
	*x = DirectCounter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectCounter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectCounter) ProtoMessage() {}

func (x *DirectCounter) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectCounter.ProtoReflect.Descriptor instead.
func (*DirectCounter) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{16}
}

func (x *DirectCounter) GetPreamble() *Preamble {
	if x != nil {
		return x.Preamble
	}
	return nil
}

func (x *DirectCounter) GetSpec() *CounterSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *DirectCounter) GetDirectTableId() uint32 {
	if x != nil {
		return x.DirectTableId
	}
	return 0
}

type MeterSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Unit MeterSpec_Unit `protobuf:"varint,1,opt,name=unit,proto3,enum=p4.config.v1.MeterSpec_Unit" json:"unit,omitempty"`
	// Added in 1.4.0.
	Type MeterSpec_Type `protobuf:"varint,2,opt,name=type,proto3,enum=p4.config.v1.MeterSpec_Type" json:"type,omitempty"`
}

func (x *MeterSpec) Reset() {
	*x = MeterSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MeterSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeterSpec) ProtoMessage() {}

func (x *MeterSpec) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeterSpec.ProtoReflect.Descriptor instead.
func (*MeterSpec) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{17}
}

func (x *MeterSpec) GetUnit() MeterSpec_Unit {
	if x != nil {
		return x.Unit
	}
	return MeterSpec_UNSPECIFIED
}

func (x *MeterSpec) GetType() MeterSpec_Type {
	if x != nil {
		return x.Type
	}
	return MeterSpec_TWO_RATE_THREE_COLOR
}

type Meter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Preamble *Preamble  `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
	Spec     *MeterSpec `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	// number of entries in the meter array
	Size int64 `protobuf:"varint,3,opt,name=size,proto3" json:"size,omitempty"`
	// unset if index is not user-defined type
	IndexTypeName *P4NamedType `protobuf:"bytes,4,opt,name=index_type_name,json=indexTypeName,proto3" json:"index_type_name,omitempty"`
}

func (x *Meter) Reset() {
	*x = Meter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Meter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Meter) ProtoMessage() {}

func (x *Meter) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Meter.ProtoReflect.Descriptor instead.
func (*Meter) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{18}
}

func (x *Meter) GetPreamble() *Preamble {
	if x != nil {
		return x.Preamble
	}
	return nil
}

func (x *Meter) GetSpec() *MeterSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *Meter) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *Meter) GetIndexTypeName() *P4NamedType {
	if x != nil {
		return x.IndexTypeName
	}
	return nil
}

type DirectMeter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Preamble *Preamble  `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
	Spec     *MeterSpec `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	// the id of the table to which the meter is attached
	DirectTableId uint32 `protobuf:"varint,3,opt,name=direct_table_id,json=directTableId,proto3" json:"direct_table_id,omitempty"`
}

func (x *DirectMeter) Reset() {
	*x = DirectMeter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectMeter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectMeter) ProtoMessage() {}

func (x *DirectMeter) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectMeter.ProtoReflect.Descriptor instead.
func (*DirectMeter) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{19}
}

func (x *DirectMeter) GetPreamble() *Preamble {
	if x != nil {
		return x.Preamble
	}
	return nil
}

func (x *DirectMeter) GetSpec() *MeterSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *DirectMeter) GetDirectTableId() uint32 {
	if x != nil {
		return x.DirectTableId
	}
	return 0
}

// Any metadata associated with controller Packet-IO (Packet-In or Packet-Out)
// is modeled as P4 headers carrying special annotations
// @controller_header("packet_out") and @controller_header("packet_in")
// respectively. There can be at most one header each with these annotations.
// This message captures the info contained within these special headers,
// and used in p4runtime.proto to supply the metadata.
type ControllerPacketMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// preamble.name and preamble.id will specify header type ("packet_out" or
	// "packet_in" for now).
	Preamble *Preamble `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
	// Ordered based on header layout.
	// This is a constraint on the generator of this P4Info.
	Metadata []*ControllerPacketMetadata_Metadata `protobuf:"bytes,2,rep,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *ControllerPacketMetadata) Reset() {
	*x = ControllerPacketMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ControllerPacketMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ControllerPacketMetadata) ProtoMessage() {}

func (x *ControllerPacketMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ControllerPacketMetadata.ProtoReflect.Descriptor instead.
func (*ControllerPacketMetadata) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{20}
}

func (x *ControllerPacketMetadata) GetPreamble() *Preamble {
	if x != nil {
		return x.Preamble
	}
	return nil
}

func (x *ControllerPacketMetadata) GetMetadata() []*ControllerPacketMetadata_Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type ValueSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Preamble *Preamble     `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
	Match    []*MatchField `protobuf:"bytes,2,rep,name=match,proto3" json:"match,omitempty"`
	// number of entries in the value_set, as per the P4 constructor call.
	Size int32 `protobuf:"varint,3,opt,name=size,proto3" json:"size,omitempty"`
}

func (x *ValueSet) Reset() {
	*x = ValueSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValueSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueSet) ProtoMessage() {}

func (x *ValueSet) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueSet.ProtoReflect.Descriptor instead.
func (*ValueSet) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{21}
}

func (x *ValueSet) GetPreamble() *Preamble {
	if x != nil {
		return x.Preamble
	}
	return nil
}

func (x *ValueSet) GetMatch() []*MatchField {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *ValueSet) GetSize() int32 {
	if x != nil {
		return x.Size
	}
	return 0
}

type Register struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Preamble *Preamble       `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
	TypeSpec *P4DataTypeSpec `protobuf:"bytes,2,opt,name=type_spec,json=typeSpec,proto3" json:"type_spec,omitempty"`
	Size     int32           `protobuf:"varint,3,opt,name=size,proto3" json:"size,omitempty"`
	// unset if index is not user-defined type
	IndexTypeName *P4NamedType `protobuf:"bytes,4,opt,name=index_type_name,json=indexTypeName,proto3" json:"index_type_name,omitempty"`
}

func (x *Register) Reset() {
	*x = Register{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Register) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Register) ProtoMessage() {}

func (x *Register) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Register.ProtoReflect.Descriptor instead.
func (*Register) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{22}
}

func (x *Register) GetPreamble() *Preamble {
	if x != nil {
		return x.Preamble
	}
	return nil
}

func (x *Register) GetTypeSpec() *P4DataTypeSpec {
	if x != nil {
		return x.TypeSpec
	}
	return nil
}

func (x *Register) GetSize() int32 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *Register) GetIndexTypeName() *P4NamedType {
	if x != nil {
		return x.IndexTypeName
	}
	return nil
}

type Digest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Preamble *Preamble       `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
	TypeSpec *P4DataTypeSpec `protobuf:"bytes,2,opt,name=type_spec,json=typeSpec,proto3" json:"type_spec,omitempty"`
}

func (x *Digest) Reset() {
	*x = Digest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Digest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Digest) ProtoMessage() {}

func (x *Digest) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Digest.ProtoReflect.Descriptor instead.
func (*Digest) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{23}
}

func (x *Digest) GetPreamble() *Preamble {
	if x != nil {
		return x.Preamble
	}
	return nil
}

func (x *Digest) GetTypeSpec() *P4DataTypeSpec {
	if x != nil {
		return x.TypeSpec
	}
	return nil
}

type TableActionCall_Argument struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ParamId uint32 `protobuf:"varint,2,opt,name=param_id,json=paramId,proto3" json:"param_id,omitempty"`
	Value   []byte `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *TableActionCall_Argument) Reset() {
	*x = TableActionCall_Argument{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableActionCall_Argument) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableActionCall_Argument) ProtoMessage() {}

func (x *TableActionCall_Argument) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableActionCall_Argument.ProtoReflect.Descriptor instead.
func (*TableActionCall_Argument) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{9, 0}
}

func (x *TableActionCall_Argument) GetParamId() uint32 {
	if x != nil {
		return x.ParamId
	}
	return 0
}

func (x *TableActionCall_Argument) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type Action_Param struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id          uint32   `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Name        string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Annotations []string `protobuf:"bytes,3,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations []*SourceLocation `protobuf:"bytes,8,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	Bitwidth            int32             `protobuf:"varint,4,opt,name=bitwidth,proto3" json:"bitwidth,omitempty"`
	// Documentation of the Param
	Doc *Documentation `protobuf:"bytes,5,opt,name=doc,proto3" json:"doc,omitempty"`
	// unset if not user-defined type
	TypeName              *P4NamedType            `protobuf:"bytes,6,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,7,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *Action_Param) Reset() {
	*x = Action_Param{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_Param) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_Param) ProtoMessage() {}

func (x *Action_Param) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_Param.ProtoReflect.Descriptor instead.
func (*Action_Param) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{12, 0}
}

func (x *Action_Param) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Action_Param) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Action_Param) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Action_Param) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *Action_Param) GetBitwidth() int32 {
	if x != nil {
		return x.Bitwidth
	}
	return 0
}

func (x *Action_Param) GetDoc() *Documentation {
	if x != nil {
		return x.Doc
	}
	return nil
}

func (x *Action_Param) GetTypeName() *P4NamedType {
	if x != nil {
		return x.TypeName
	}
	return nil
}

func (x *Action_Param) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

// indicates that `size` and `max_group_size` represent the maximum sum of
// weights that can be present across all selector groups and within a
// single selector group respectively.
// Added in v1.4.0
type ActionProfile_SumOfWeights struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ActionProfile_SumOfWeights) Reset() {
	*x = ActionProfile_SumOfWeights{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionProfile_SumOfWeights) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionProfile_SumOfWeights) ProtoMessage() {}

func (x *ActionProfile_SumOfWeights) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionProfile_SumOfWeights.ProtoReflect.Descriptor instead.
func (*ActionProfile_SumOfWeights) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{13, 0}
}

// indicates that `size` and `max_group_size` represent the maximum number
// of members that can be present across all selector groups and within a
// single selector group respectively.
// Added in v1.4.0
type ActionProfile_SumOfMembers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the maximum weight of each individual member in a group.
	MaxMemberWeight int32 `protobuf:"varint,1,opt,name=max_member_weight,json=maxMemberWeight,proto3" json:"max_member_weight,omitempty"`
}

func (x *ActionProfile_SumOfMembers) Reset() {
	*x = ActionProfile_SumOfMembers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionProfile_SumOfMembers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionProfile_SumOfMembers) ProtoMessage() {}

func (x *ActionProfile_SumOfMembers) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionProfile_SumOfMembers.ProtoReflect.Descriptor instead.
func (*ActionProfile_SumOfMembers) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{13, 1}
}

func (x *ActionProfile_SumOfMembers) GetMaxMemberWeight() int32 {
	if x != nil {
		return x.MaxMemberWeight
	}
	return 0
}

type ControllerPacketMetadata_Metadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// This is the name of the header field (not fully-qualified), similar
	// to e.g. Action.Param.name.
	Name        string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Annotations []string `protobuf:"bytes,3,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional. If present, the location of `annotations[i]` is given by
	// `annotation_locations[i]`.
	AnnotationLocations []*SourceLocation `protobuf:"bytes,7,rep,name=annotation_locations,json=annotationLocations,proto3" json:"annotation_locations,omitempty"`
	Bitwidth            int32             `protobuf:"varint,4,opt,name=bitwidth,proto3" json:"bitwidth,omitempty"`
	// unset if not user-defined type
	TypeName              *P4NamedType            `protobuf:"bytes,5,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	StructuredAnnotations []*StructuredAnnotation `protobuf:"bytes,6,rep,name=structured_annotations,json=structuredAnnotations,proto3" json:"structured_annotations,omitempty"`
}

func (x *ControllerPacketMetadata_Metadata) Reset() {
	*x = ControllerPacketMetadata_Metadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_config_v1_p4info_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ControllerPacketMetadata_Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ControllerPacketMetadata_Metadata) ProtoMessage() {}

func (x *ControllerPacketMetadata_Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_p4_config_v1_p4info_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ControllerPacketMetadata_Metadata.ProtoReflect.Descriptor instead.
func (*ControllerPacketMetadata_Metadata) Descriptor() ([]byte, []int) {
	return file_p4_config_v1_p4info_proto_rawDescGZIP(), []int{20, 0}
}

func (x *ControllerPacketMetadata_Metadata) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *ControllerPacketMetadata_Metadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ControllerPacketMetadata_Metadata) GetAnnotations() []string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ControllerPacketMetadata_Metadata) GetAnnotationLocations() []*SourceLocation {
	if x != nil {
		return x.AnnotationLocations
	}
	return nil
}

func (x *ControllerPacketMetadata_Metadata) GetBitwidth() int32 {
	if x != nil {
		return x.Bitwidth
	}
	return 0
}

func (x *ControllerPacketMetadata_Metadata) GetTypeName() *P4NamedType {
	if x != nil {
		return x.TypeName
	}
	return nil
}

func (x *ControllerPacketMetadata_Metadata) GetStructuredAnnotations() []*StructuredAnnotation {
	if x != nil {
		return x.StructuredAnnotations
	}
	return nil
}

var File_p4_config_v1_p4info_proto protoreflect.FileDescriptor

var file_p4_config_v1_p4info_proto_rawDesc = []byte{
	0x0a, 0x19, 0x70, 0x34, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x34, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0c, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x70, 0x34, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x34, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xae, 0x06, 0x0a, 0x06, 0x50, 0x34, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x30, 0x0a, 0x08, 0x70,
	0x6b, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6b, 0x67,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x70, 0x6b, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2b, 0x0a,
	0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x52, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x07, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x44, 0x0a, 0x0f, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x52, 0x0e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x12, 0x31, 0x0a, 0x08, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x52, 0x08, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x44, 0x0a, 0x0f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70,
	0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x52, 0x0e, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2b, 0x0a, 0x06, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x34, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x06,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x3e, 0x0a, 0x0d, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0c, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x64, 0x0a, 0x1a, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x18, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x35, 0x0a, 0x0a,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x65, 0x74, 0x52, 0x09, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x53,
	0x65, 0x74, 0x73, 0x12, 0x34, 0x0a, 0x09, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x09,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2e, 0x0a, 0x07, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74,
	0x52, 0x07, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x12, 0x2e, 0x0a, 0x07, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x73, 0x18, 0x64, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x52, 0x07, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x12, 0x36, 0x0a, 0x09, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x54,
	0x79, 0x70, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x22, 0x47, 0x0a, 0x0d, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x72, 0x69, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x62, 0x72, 0x69, 0x65, 0x66, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xff, 0x01, 0x0a, 0x12, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x3b, 0x0a, 0x1a, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x4e,
	0x0a, 0x24, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x72, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x20, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x12, 0x5c,
	0x0a, 0x2c, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x26, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x61, 0x78, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x73, 0x50, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0xeb, 0x03, 0x0a,
	0x07, 0x50, 0x6b, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x03, 0x64, 0x6f, 0x63, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x03, 0x64, 0x6f, 0x63, 0x12, 0x20, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x14, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x72, 0x63, 0x68,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x61, 0x72, 0x63, 0x68, 0x12, 0x22, 0x0a, 0x0c,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72,
	0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x59, 0x0a, 0x16,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70,
	0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x15, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x51, 0x0a, 0x13, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x12, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0x87, 0x02, 0x0a, 0x05, 0x50,
	0x34, 0x49, 0x64, 0x73, 0x22, 0xfd, 0x01, 0x0a, 0x06, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12,
	0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05,
	0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x56, 0x41, 0x4c, 0x55, 0x45,
	0x5f, 0x53, 0x45, 0x54, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f,
	0x4c, 0x4c, 0x45, 0x52, 0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x04, 0x12, 0x15, 0x0a,
	0x11, 0x50, 0x53, 0x41, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x53, 0x5f, 0x53, 0x54, 0x41,
	0x52, 0x54, 0x10, 0x10, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50,
	0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x11, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x55, 0x4e,
	0x54, 0x45, 0x52, 0x10, 0x12, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f,
	0x43, 0x4f, 0x55, 0x4e, 0x54, 0x45, 0x52, 0x10, 0x13, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x45, 0x54,
	0x45, 0x52, 0x10, 0x14, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x4d,
	0x45, 0x54, 0x45, 0x52, 0x10, 0x15, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54,
	0x45, 0x52, 0x10, 0x16, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x49, 0x47, 0x45, 0x53, 0x54, 0x10, 0x17,
	0x12, 0x18, 0x0a, 0x13, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e,
	0x53, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x10, 0x80, 0x01, 0x12, 0x08, 0x0a, 0x03, 0x4d, 0x41,
	0x58, 0x10, 0xff, 0x01, 0x22, 0xc1, 0x02, 0x0a, 0x08, 0x50, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c,
	0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a,
	0x14, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2d,
	0x0a, 0x03, 0x64, 0x6f, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x64, 0x6f, 0x63, 0x12, 0x59, 0x0a,
	0x16, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x15, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x94, 0x01, 0x0a, 0x06, 0x45, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x22,
	0x6e, 0x0a, 0x0e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x52, 0x08, 0x70, 0x72, 0x65,
	0x61, 0x6d, 0x62, 0x6c, 0x65, 0x12, 0x28, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x22,
	0xd3, 0x04, 0x0a, 0x0a, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x14, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x69, 0x74, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x62, 0x69, 0x74, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x12, 0x43, 0x0a, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x2d, 0x0a, 0x03, 0x64, 0x6f, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x64, 0x6f,
	0x63, 0x12, 0x36, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x16, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x34, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x56, 0x0a, 0x09, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x58, 0x41, 0x43, 0x54, 0x10, 0x02, 0x12, 0x07, 0x0a,
	0x03, 0x4c, 0x50, 0x4d, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x52,
	0x59, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x05, 0x12, 0x0c,
	0x0a, 0x08, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x06, 0x42, 0x07, 0x0a, 0x05,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x22, 0xb1, 0x01, 0x0a, 0x0f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x70, 0x34, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x2e, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x3b, 0x0a, 0x08,
	0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xde, 0x05, 0x0a, 0x05, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x52, 0x08, 0x70,
	0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x12, 0x3b, 0x0a, 0x0c, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x12, 0x38, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x66, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x70, 0x34, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x66, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x73, 0x12, 0x35,
	0x0a, 0x17, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x14, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x16, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c,
	0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x61, 0x6c, 0x6c, 0x52, 0x14, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11, 0x69, 0x6d,
	0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x10, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x0d, 0x52, 0x11, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x5b, 0x0a, 0x15, 0x69,
	0x64, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x49, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x52, 0x13, 0x69, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x24, 0x0a, 0x0e, 0x69, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x69, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x2e,
	0x0a, 0x13, 0x68, 0x61, 0x73, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x65, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x68, 0x61, 0x73,
	0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x3f,
	0x0a, 0x10, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x0f,
	0x6f, 0x74, 0x68, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22,
	0x39, 0x0a, 0x13, 0x49, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x42, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x4f, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x4f, 0x55, 0x54, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x59,
	0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x10, 0x01, 0x22, 0xe0, 0x02, 0x0a, 0x09, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x33, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66,
	0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x20, 0x0a,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x4f, 0x0a, 0x14, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x59, 0x0a, 0x16, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x40, 0x0a, 0x05, 0x53,
	0x63, 0x6f, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x41, 0x4e,
	0x44, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x54,
	0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x44,
	0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x22, 0xef, 0x03,
	0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x61,
	0x6d, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x61, 0x6d, 0x62,
	0x6c, 0x65, 0x52, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x12, 0x32, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x70,
	0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x1a, 0xfc, 0x02, 0x0a, 0x05, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x4f, 0x0a, 0x14, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x69, 0x74, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x62, 0x69, 0x74, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x2d, 0x0a,
	0x03, 0x64, 0x6f, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x64, 0x6f, 0x63, 0x12, 0x36, 0x0a, 0x09,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x16, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0xca, 0x03, 0x0a, 0x0d, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x52, 0x08, 0x70, 0x72, 0x65,
	0x61, 0x6d, 0x62, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49,
	0x64, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x77, 0x69, 0x74, 0x68, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x6d,
	0x61, 0x78, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x50, 0x0a, 0x0e, 0x73, 0x75, 0x6d, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x70, 0x34, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x4f, 0x66, 0x57, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x75, 0x6d, 0x4f, 0x66, 0x57, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x0e, 0x73, 0x75, 0x6d, 0x5f, 0x6f, 0x66, 0x5f, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x4f, 0x66, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x75, 0x6d, 0x4f, 0x66, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x1a, 0x0e, 0x0a, 0x0c, 0x53, 0x75, 0x6d, 0x4f, 0x66, 0x57, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x53, 0x75, 0x6d, 0x4f, 0x66, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x5f, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0f, 0x6d, 0x61, 0x78, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x57, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x42, 0x19, 0x0a, 0x17, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x5f, 0x73, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x73, 0x22, 0x7c, 0x0a, 0x0b,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x32, 0x0a, 0x04, 0x75,
	0x6e, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x70, 0x34, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x22,
	0x39, 0x0a, 0x04, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x59, 0x54, 0x45,
	0x53, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x41, 0x43, 0x4b, 0x45, 0x54, 0x53, 0x10, 0x02,
	0x12, 0x08, 0x0a, 0x04, 0x42, 0x4f, 0x54, 0x48, 0x10, 0x03, 0x22, 0xc3, 0x01, 0x0a, 0x07, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62,
	0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65,
	0x52, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x12, 0x2d, 0x0a, 0x04, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x41, 0x0a,
	0x0f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0d, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x22, 0x9a, 0x01, 0x0a, 0x0d, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x65, 0x72, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x52, 0x08, 0x70, 0x72,
	0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x12, 0x2d, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x26, 0x0a, 0x0f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64, 0x22, 0xfa, 0x01,
	0x0a, 0x09, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x30, 0x0a, 0x04, 0x75,
	0x6e, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x12, 0x30, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x65, 0x72,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22,
	0x2f, 0x0a, 0x04, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x59, 0x54, 0x45,
	0x53, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x41, 0x43, 0x4b, 0x45, 0x54, 0x53, 0x10, 0x02,
	0x22, 0x58, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x57, 0x4f, 0x5f,
	0x52, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x48, 0x52, 0x45, 0x45, 0x5f, 0x43, 0x4f, 0x4c, 0x4f, 0x52,
	0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x52, 0x41, 0x54,
	0x45, 0x5f, 0x54, 0x48, 0x52, 0x45, 0x45, 0x5f, 0x43, 0x4f, 0x4c, 0x4f, 0x52, 0x10, 0x01, 0x12,
	0x19, 0x0a, 0x15, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x54,
	0x57, 0x4f, 0x5f, 0x43, 0x4f, 0x4c, 0x4f, 0x52, 0x10, 0x02, 0x22, 0xbf, 0x01, 0x0a, 0x05, 0x4d,
	0x65, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x52, 0x08,
	0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x12, 0x2b, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x41, 0x0a, 0x0f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x96, 0x01, 0x0a,
	0x0b, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x08,
	0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x52, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65,
	0x12, 0x2b, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x26, 0x0a,
	0x0f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x49, 0x64, 0x22, 0xee, 0x03, 0x0a, 0x18, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x52, 0x08, 0x70, 0x72,
	0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x12, 0x4b, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x1a, 0xd0, 0x02, 0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x14, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x69, 0x74, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x62, 0x69, 0x74, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x12, 0x36, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x16, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x15, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x82, 0x01, 0x0a, 0x08, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x53, 0x65, 0x74, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x52, 0x08, 0x70,
	0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x12, 0x2e, 0x0a, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x52, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x08,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x61,
	0x6d, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x61, 0x6d, 0x62,
	0x6c, 0x65, 0x52, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x12, 0x39, 0x0a, 0x09,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x34, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x08, 0x74,
	0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x41, 0x0a, 0x0f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0d, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x77,
	0x0a, 0x06, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x61,
	0x6d, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x34, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x61, 0x6d, 0x62,
	0x6c, 0x65, 0x52, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x12, 0x39, 0x0a, 0x09,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x34, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x08, 0x74,
	0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x2d, 0x5a, 0x2b, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x70, 0x34, 0x6c, 0x61, 0x6e, 0x67, 0x2f, 0x70, 0x34, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x34, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_p4_config_v1_p4info_proto_rawDescOnce sync.Once
	file_p4_config_v1_p4info_proto_rawDescData = file_p4_config_v1_p4info_proto_rawDesc
)

func file_p4_config_v1_p4info_proto_rawDescGZIP() []byte {
	file_p4_config_v1_p4info_proto_rawDescOnce.Do(func() {
		file_p4_config_v1_p4info_proto_rawDescData = protoimpl.X.CompressGZIP(file_p4_config_v1_p4info_proto_rawDescData)
	})
	return file_p4_config_v1_p4info_proto_rawDescData
}

var file_p4_config_v1_p4info_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_p4_config_v1_p4info_proto_msgTypes = make([]protoimpl.MessageInfo, 29)
var file_p4_config_v1_p4info_proto_goTypes = []interface{}{
	(P4Ids_Prefix)(0),                         // 0: p4.config.v1.P4Ids.Prefix
	(MatchField_MatchType)(0),                 // 1: p4.config.v1.MatchField.MatchType
	(Table_IdleTimeoutBehavior)(0),            // 2: p4.config.v1.Table.IdleTimeoutBehavior
	(ActionRef_Scope)(0),                      // 3: p4.config.v1.ActionRef.Scope
	(CounterSpec_Unit)(0),                     // 4: p4.config.v1.CounterSpec.Unit
	(MeterSpec_Unit)(0),                       // 5: p4.config.v1.MeterSpec.Unit
	(MeterSpec_Type)(0),                       // 6: p4.config.v1.MeterSpec.Type
	(*P4Info)(nil),                            // 7: p4.config.v1.P4Info
	(*Documentation)(nil),                     // 8: p4.config.v1.Documentation
	(*PlatformProperties)(nil),                // 9: p4.config.v1.PlatformProperties
	(*PkgInfo)(nil),                           // 10: p4.config.v1.PkgInfo
	(*P4Ids)(nil),                             // 11: p4.config.v1.P4Ids
	(*Preamble)(nil),                          // 12: p4.config.v1.Preamble
	(*Extern)(nil),                            // 13: p4.config.v1.Extern
	(*ExternInstance)(nil),                    // 14: p4.config.v1.ExternInstance
	(*MatchField)(nil),                        // 15: p4.config.v1.MatchField
	(*TableActionCall)(nil),                   // 16: p4.config.v1.TableActionCall
	(*Table)(nil),                             // 17: p4.config.v1.Table
	(*ActionRef)(nil),                         // 18: p4.config.v1.ActionRef
	(*Action)(nil),                            // 19: p4.config.v1.Action
	(*ActionProfile)(nil),                     // 20: p4.config.v1.ActionProfile
	(*CounterSpec)(nil),                       // 21: p4.config.v1.CounterSpec
	(*Counter)(nil),                           // 22: p4.config.v1.Counter
	(*DirectCounter)(nil),                     // 23: p4.config.v1.DirectCounter
	(*MeterSpec)(nil),                         // 24: p4.config.v1.MeterSpec
	(*Meter)(nil),                             // 25: p4.config.v1.Meter
	(*DirectMeter)(nil),                       // 26: p4.config.v1.DirectMeter
	(*ControllerPacketMetadata)(nil),          // 27: p4.config.v1.ControllerPacketMetadata
	(*ValueSet)(nil),                          // 28: p4.config.v1.ValueSet
	(*Register)(nil),                          // 29: p4.config.v1.Register
	(*Digest)(nil),                            // 30: p4.config.v1.Digest
	(*TableActionCall_Argument)(nil),          // 31: p4.config.v1.TableActionCall.Argument
	(*Action_Param)(nil),                      // 32: p4.config.v1.Action.Param
	(*ActionProfile_SumOfWeights)(nil),        // 33: p4.config.v1.ActionProfile.SumOfWeights
	(*ActionProfile_SumOfMembers)(nil),        // 34: p4.config.v1.ActionProfile.SumOfMembers
	(*ControllerPacketMetadata_Metadata)(nil), // 35: p4.config.v1.ControllerPacketMetadata.Metadata
	(*P4TypeInfo)(nil),                        // 36: p4.config.v1.P4TypeInfo
	(*SourceLocation)(nil),                    // 37: p4.config.v1.SourceLocation
	(*StructuredAnnotation)(nil),              // 38: p4.config.v1.StructuredAnnotation
	(*anypb.Any)(nil),                         // 39: google.protobuf.Any
	(*P4NamedType)(nil),                       // 40: p4.config.v1.P4NamedType
	(*P4DataTypeSpec)(nil),                    // 41: p4.config.v1.P4DataTypeSpec
}
var file_p4_config_v1_p4info_proto_depIdxs = []int32{
	10, // 0: p4.config.v1.P4Info.pkg_info:type_name -> p4.config.v1.PkgInfo
	17, // 1: p4.config.v1.P4Info.tables:type_name -> p4.config.v1.Table
	19, // 2: p4.config.v1.P4Info.actions:type_name -> p4.config.v1.Action
	20, // 3: p4.config.v1.P4Info.action_profiles:type_name -> p4.config.v1.ActionProfile
	22, // 4: p4.config.v1.P4Info.counters:type_name -> p4.config.v1.Counter
	23, // 5: p4.config.v1.P4Info.direct_counters:type_name -> p4.config.v1.DirectCounter
	25, // 6: p4.config.v1.P4Info.meters:type_name -> p4.config.v1.Meter
	26, // 7: p4.config.v1.P4Info.direct_meters:type_name -> p4.config.v1.DirectMeter
	27, // 8: p4.config.v1.P4Info.controller_packet_metadata:type_name -> p4.config.v1.ControllerPacketMetadata
	28, // 9: p4.config.v1.P4Info.value_sets:type_name -> p4.config.v1.ValueSet
	29, // 10: p4.config.v1.P4Info.registers:type_name -> p4.config.v1.Register
	30, // 11: p4.config.v1.P4Info.digests:type_name -> p4.config.v1.Digest
	13, // 12: p4.config.v1.P4Info.externs:type_name -> p4.config.v1.Extern
	36, // 13: p4.config.v1.P4Info.type_info:type_name -> p4.config.v1.P4TypeInfo
	8,  // 14: p4.config.v1.PkgInfo.doc:type_name -> p4.config.v1.Documentation
	37, // 15: p4.config.v1.PkgInfo.annotation_locations:type_name -> p4.config.v1.SourceLocation
	38, // 16: p4.config.v1.PkgInfo.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	9,  // 17: p4.config.v1.PkgInfo.platform_properties:type_name -> p4.config.v1.PlatformProperties
	37, // 18: p4.config.v1.Preamble.annotation_locations:type_name -> p4.config.v1.SourceLocation
	8,  // 19: p4.config.v1.Preamble.doc:type_name -> p4.config.v1.Documentation
	38, // 20: p4.config.v1.Preamble.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	14, // 21: p4.config.v1.Extern.instances:type_name -> p4.config.v1.ExternInstance
	12, // 22: p4.config.v1.ExternInstance.preamble:type_name -> p4.config.v1.Preamble
	39, // 23: p4.config.v1.ExternInstance.info:type_name -> google.protobuf.Any
	37, // 24: p4.config.v1.MatchField.annotation_locations:type_name -> p4.config.v1.SourceLocation
	1,  // 25: p4.config.v1.MatchField.match_type:type_name -> p4.config.v1.MatchField.MatchType
	8,  // 26: p4.config.v1.MatchField.doc:type_name -> p4.config.v1.Documentation
	40, // 27: p4.config.v1.MatchField.type_name:type_name -> p4.config.v1.P4NamedType
	38, // 28: p4.config.v1.MatchField.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	31, // 29: p4.config.v1.TableActionCall.arguments:type_name -> p4.config.v1.TableActionCall.Argument
	12, // 30: p4.config.v1.Table.preamble:type_name -> p4.config.v1.Preamble
	15, // 31: p4.config.v1.Table.match_fields:type_name -> p4.config.v1.MatchField
	18, // 32: p4.config.v1.Table.action_refs:type_name -> p4.config.v1.ActionRef
	16, // 33: p4.config.v1.Table.initial_default_action:type_name -> p4.config.v1.TableActionCall
	2,  // 34: p4.config.v1.Table.idle_timeout_behavior:type_name -> p4.config.v1.Table.IdleTimeoutBehavior
	39, // 35: p4.config.v1.Table.other_properties:type_name -> google.protobuf.Any
	3,  // 36: p4.config.v1.ActionRef.scope:type_name -> p4.config.v1.ActionRef.Scope
	37, // 37: p4.config.v1.ActionRef.annotation_locations:type_name -> p4.config.v1.SourceLocation
	38, // 38: p4.config.v1.ActionRef.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	12, // 39: p4.config.v1.Action.preamble:type_name -> p4.config.v1.Preamble
	32, // 40: p4.config.v1.Action.params:type_name -> p4.config.v1.Action.Param
	12, // 41: p4.config.v1.ActionProfile.preamble:type_name -> p4.config.v1.Preamble
	33, // 42: p4.config.v1.ActionProfile.sum_of_weights:type_name -> p4.config.v1.ActionProfile.SumOfWeights
	34, // 43: p4.config.v1.ActionProfile.sum_of_members:type_name -> p4.config.v1.ActionProfile.SumOfMembers
	4,  // 44: p4.config.v1.CounterSpec.unit:type_name -> p4.config.v1.CounterSpec.Unit
	12, // 45: p4.config.v1.Counter.preamble:type_name -> p4.config.v1.Preamble
	21, // 46: p4.config.v1.Counter.spec:type_name -> p4.config.v1.CounterSpec
	40, // 47: p4.config.v1.Counter.index_type_name:type_name -> p4.config.v1.P4NamedType
	12, // 48: p4.config.v1.DirectCounter.preamble:type_name -> p4.config.v1.Preamble
	21, // 49: p4.config.v1.DirectCounter.spec:type_name -> p4.config.v1.CounterSpec
	5,  // 50: p4.config.v1.MeterSpec.unit:type_name -> p4.config.v1.MeterSpec.Unit
	6,  // 51: p4.config.v1.MeterSpec.type:type_name -> p4.config.v1.MeterSpec.Type
	12, // 52: p4.config.v1.Meter.preamble:type_name -> p4.config.v1.Preamble
	24, // 53: p4.config.v1.Meter.spec:type_name -> p4.config.v1.MeterSpec
	40, // 54: p4.config.v1.Meter.index_type_name:type_name -> p4.config.v1.P4NamedType
	12, // 55: p4.config.v1.DirectMeter.preamble:type_name -> p4.config.v1.Preamble
	24, // 56: p4.config.v1.DirectMeter.spec:type_name -> p4.config.v1.MeterSpec
	12, // 57: p4.config.v1.ControllerPacketMetadata.preamble:type_name -> p4.config.v1.Preamble
	35, // 58: p4.config.v1.ControllerPacketMetadata.metadata:type_name -> p4.config.v1.ControllerPacketMetadata.Metadata
	12, // 59: p4.config.v1.ValueSet.preamble:type_name -> p4.config.v1.Preamble
	15, // 60: p4.config.v1.ValueSet.match:type_name -> p4.config.v1.MatchField
	12, // 61: p4.config.v1.Register.preamble:type_name -> p4.config.v1.Preamble
	41, // 62: p4.config.v1.Register.type_spec:type_name -> p4.config.v1.P4DataTypeSpec
	40, // 63: p4.config.v1.Register.index_type_name:type_name -> p4.config.v1.P4NamedType
	12, // 64: p4.config.v1.Digest.preamble:type_name -> p4.config.v1.Preamble
	41, // 65: p4.config.v1.Digest.type_spec:type_name -> p4.config.v1.P4DataTypeSpec
	37, // 66: p4.config.v1.Action.Param.annotation_locations:type_name -> p4.config.v1.SourceLocation
	8,  // 67: p4.config.v1.Action.Param.doc:type_name -> p4.config.v1.Documentation
	40, // 68: p4.config.v1.Action.Param.type_name:type_name -> p4.config.v1.P4NamedType
	38, // 69: p4.config.v1.Action.Param.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	37, // 70: p4.config.v1.ControllerPacketMetadata.Metadata.annotation_locations:type_name -> p4.config.v1.SourceLocation
	40, // 71: p4.config.v1.ControllerPacketMetadata.Metadata.type_name:type_name -> p4.config.v1.P4NamedType
	38, // 72: p4.config.v1.ControllerPacketMetadata.Metadata.structured_annotations:type_name -> p4.config.v1.StructuredAnnotation
	73, // [73:73] is the sub-list for method output_type
	73, // [73:73] is the sub-list for method input_type
	73, // [73:73] is the sub-list for extension type_name
	73, // [73:73] is the sub-list for extension extendee
	0,  // [0:73] is the sub-list for field type_name
}

func init() { file_p4_config_v1_p4info_proto_init() }
func file_p4_config_v1_p4info_proto_init() {
	if File_p4_config_v1_p4info_proto != nil {
		return
	}
	file_p4_config_v1_p4types_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_p4_config_v1_p4info_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4Info); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Documentation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PkgInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*P4Ids); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Preamble); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Extern); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExternInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MatchField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableActionCall); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Table); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CounterSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Counter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectCounter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MeterSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Meter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectMeter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ControllerPacketMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValueSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Register); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Digest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableActionCall_Argument); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_Param); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionProfile_SumOfWeights); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionProfile_SumOfMembers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_config_v1_p4info_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ControllerPacketMetadata_Metadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_p4_config_v1_p4info_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*MatchField_MatchType_)(nil),
		(*MatchField_OtherMatchType)(nil),
	}
	file_p4_config_v1_p4info_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*ActionProfile_SumOfWeights_)(nil),
		(*ActionProfile_SumOfMembers_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_p4_config_v1_p4info_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   29,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_p4_config_v1_p4info_proto_goTypes,
		DependencyIndexes: file_p4_config_v1_p4info_proto_depIdxs,
		EnumInfos:         file_p4_config_v1_p4info_proto_enumTypes,
		MessageInfos:      file_p4_config_v1_p4info_proto_msgTypes,
	}.Build()
	File_p4_config_v1_p4info_proto = out.File
	file_p4_config_v1_p4info_proto_rawDesc = nil
	file_p4_config_v1_p4info_proto_goTypes = nil
	file_p4_config_v1_p4info_proto_depIdxs = nil
}
