// @generated
// This file is @generated by prost-build.
// P4 type specs ---------------------------------------------------------------

// From the P4_16 spec:

// |--------------------|--------------------------------------------|
// |                    | Container type                             |
// | Element type       |-----------|--------------|-----------------|
// |                    | header    | header_union | struct or tuple |
// |--------------------|-----------|--------------|-----------------|
// | bit<W>             | allowed   | error        | allowed         |
// | int<W>             | allowed   | error        | allowed         |
// | varbit<W>          | allowed   | error        | allowed         |
// | int                | error     | error        | error           |
// | void               | error     | error        | error           |
// | error              | error     | error        | allowed         |
// | match_kind         | error     | error        | error           |
// | bool               | error     | error        | allowed         |
// | enum               | allowed*  | error        | allowed         |
// | header             | error     | allowed      | allowed         |
// | header stack       | error     | error        | allowed         |
// | header_union       | error     | error        | allowed         |
// | struct             | error     | error        | allowed         |
// | tuple              | error     | error        | allowed         |
// |--------------------|-----------|--------------|-----------------|
//
// *if serializable

/// These P4 types (struct, header_type, header_union and enum) are guaranteed to
/// have a fully-qualified name (e.g. you cannot use an anonymous struct to
/// declare a variable like in C). Instead of duplicating the type spec for these
/// every time the type is used, we include the type spec once in this P4TypeInfo
/// message and refer to the types by name in the P4DataTypeSpec message. We also
/// support annotations for these type specs which can be useful, e.g. to
/// identify well-known headers (such as ipv4).
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4TypeInfo {
    #[prost(map="string, message", tag="1")]
    pub structs: ::std::collections::HashMap<::prost::alloc::string::String, P4StructTypeSpec>,
    #[prost(map="string, message", tag="2")]
    pub headers: ::std::collections::HashMap<::prost::alloc::string::String, P4HeaderTypeSpec>,
    #[prost(map="string, message", tag="3")]
    pub header_unions: ::std::collections::HashMap<::prost::alloc::string::String, P4HeaderUnionTypeSpec>,
    #[prost(map="string, message", tag="4")]
    pub enums: ::std::collections::HashMap<::prost::alloc::string::String, P4EnumTypeSpec>,
    #[prost(message, optional, tag="5")]
    pub error: ::core::option::Option<P4ErrorTypeSpec>,
    #[prost(map="string, message", tag="6")]
    pub serializable_enums: ::std::collections::HashMap<::prost::alloc::string::String, P4SerializableEnumTypeSpec>,
    #[prost(map="string, message", tag="7")]
    pub new_types: ::std::collections::HashMap<::prost::alloc::string::String, P4NewTypeSpec>,
}
/// Describes a P4_16 type.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4DataTypeSpec {
    #[prost(oneof="p4_data_type_spec::TypeSpec", tags="1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12")]
    pub type_spec: ::core::option::Option<p4_data_type_spec::TypeSpec>,
}
/// Nested message and enum types in `P4DataTypeSpec`.
pub mod p4_data_type_spec {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum TypeSpec {
        #[prost(message, tag="1")]
        Bitstring(super::P4BitstringLikeTypeSpec),
        #[prost(message, tag="2")]
        Bool(super::P4BoolType),
        #[prost(message, tag="3")]
        Tuple(super::P4TupleTypeSpec),
        #[prost(message, tag="4")]
        Struct(super::P4NamedType),
        #[prost(message, tag="5")]
        Header(super::P4NamedType),
        #[prost(message, tag="6")]
        HeaderUnion(super::P4NamedType),
        #[prost(message, tag="7")]
        HeaderStack(super::P4HeaderStackTypeSpec),
        #[prost(message, tag="8")]
        HeaderUnionStack(super::P4HeaderUnionStackTypeSpec),
        #[prost(message, tag="9")]
        Enum(super::P4NamedType),
        #[prost(message, tag="10")]
        Error(super::P4ErrorType),
        #[prost(message, tag="11")]
        SerializableEnum(super::P4NamedType),
        #[prost(message, tag="12")]
        NewType(super::P4NamedType),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4NamedType {
    #[prost(string, tag="1")]
    pub name: ::prost::alloc::string::String,
}
/// Empty message as no type information needed, just used as a placeholder in
/// the oneof to identify boolean types.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct P4BoolType {
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct P4ErrorType {
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4BitstringLikeTypeSpec {
    /// Useful to identify well-known types, such as IP address or Ethernet MAC
    /// address.
    #[prost(string, repeated, tag="4")]
    pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. If present, the location of `annotations\[i\]` is given by
    /// `annotation_locations\[i\]`.
    #[prost(message, repeated, tag="5")]
    pub annotation_locations: ::prost::alloc::vec::Vec<SourceLocation>,
    #[prost(message, repeated, tag="6")]
    pub structured_annotations: ::prost::alloc::vec::Vec<StructuredAnnotation>,
    #[prost(oneof="p4_bitstring_like_type_spec::TypeSpec", tags="1, 2, 3")]
    pub type_spec: ::core::option::Option<p4_bitstring_like_type_spec::TypeSpec>,
}
/// Nested message and enum types in `P4BitstringLikeTypeSpec`.
pub mod p4_bitstring_like_type_spec {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Oneof)]
    pub enum TypeSpec {
        /// bit<W>
        #[prost(message, tag="1")]
        Bit(super::P4BitTypeSpec),
        /// int<W>
        #[prost(message, tag="2")]
        Int(super::P4IntTypeSpec),
        /// varbit<W>
        #[prost(message, tag="3")]
        Varbit(super::P4VarbitTypeSpec),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct P4BitTypeSpec {
    #[prost(int32, tag="1")]
    pub bitwidth: i32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct P4IntTypeSpec {
    #[prost(int32, tag="1")]
    pub bitwidth: i32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct P4VarbitTypeSpec {
    #[prost(int32, tag="1")]
    pub max_bitwidth: i32,
}
/// From the P4_16 spec: "A tuple is similar to a struct, in that it holds
/// multiple values. Unlike a struct type, tuples have no named fields."
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4TupleTypeSpec {
    #[prost(message, repeated, tag="1")]
    pub members: ::prost::alloc::vec::Vec<P4DataTypeSpec>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4StructTypeSpec {
    #[prost(message, repeated, tag="1")]
    pub members: ::prost::alloc::vec::Vec<p4_struct_type_spec::Member>,
    #[prost(string, repeated, tag="2")]
    pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. If present, the location of `annotations\[i\]` is given by
    /// `annotation_locations\[i\]`.
    #[prost(message, repeated, tag="3")]
    pub annotation_locations: ::prost::alloc::vec::Vec<SourceLocation>,
    #[prost(message, repeated, tag="4")]
    pub structured_annotations: ::prost::alloc::vec::Vec<StructuredAnnotation>,
}
/// Nested message and enum types in `P4StructTypeSpec`.
pub mod p4_struct_type_spec {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Member {
        #[prost(string, tag="1")]
        pub name: ::prost::alloc::string::String,
        #[prost(message, optional, tag="2")]
        pub type_spec: ::core::option::Option<super::P4DataTypeSpec>,
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4HeaderTypeSpec {
    #[prost(message, repeated, tag="1")]
    pub members: ::prost::alloc::vec::Vec<p4_header_type_spec::Member>,
    #[prost(string, repeated, tag="2")]
    pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. If present, the location of `annotations\[i\]` is given by
    /// `annotation_locations\[i\]`.
    #[prost(message, repeated, tag="3")]
    pub annotation_locations: ::prost::alloc::vec::Vec<SourceLocation>,
    #[prost(message, repeated, tag="4")]
    pub structured_annotations: ::prost::alloc::vec::Vec<StructuredAnnotation>,
}
/// Nested message and enum types in `P4HeaderTypeSpec`.
pub mod p4_header_type_spec {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Member {
        #[prost(string, tag="1")]
        pub name: ::prost::alloc::string::String,
        #[prost(message, optional, tag="2")]
        pub type_spec: ::core::option::Option<super::P4BitstringLikeTypeSpec>,
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4HeaderUnionTypeSpec {
    #[prost(message, repeated, tag="1")]
    pub members: ::prost::alloc::vec::Vec<p4_header_union_type_spec::Member>,
    #[prost(string, repeated, tag="2")]
    pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. If present, the location of `annotations\[i\]` is given by
    /// `annotation_locations\[i\]`.
    #[prost(message, repeated, tag="3")]
    pub annotation_locations: ::prost::alloc::vec::Vec<SourceLocation>,
    #[prost(message, repeated, tag="4")]
    pub structured_annotations: ::prost::alloc::vec::Vec<StructuredAnnotation>,
}
/// Nested message and enum types in `P4HeaderUnionTypeSpec`.
pub mod p4_header_union_type_spec {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Member {
        #[prost(string, tag="1")]
        pub name: ::prost::alloc::string::String,
        #[prost(message, optional, tag="2")]
        pub header: ::core::option::Option<super::P4NamedType>,
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4HeaderStackTypeSpec {
    #[prost(message, optional, tag="1")]
    pub header: ::core::option::Option<P4NamedType>,
    #[prost(int32, tag="2")]
    pub size: i32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4HeaderUnionStackTypeSpec {
    #[prost(message, optional, tag="1")]
    pub header_union: ::core::option::Option<P4NamedType>,
    #[prost(int32, tag="2")]
    pub size: i32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct KeyValuePair {
    #[prost(string, tag="1")]
    pub key: ::prost::alloc::string::String,
    #[prost(message, optional, tag="2")]
    pub value: ::core::option::Option<Expression>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct KeyValuePairList {
    #[prost(message, repeated, tag="1")]
    pub kv_pairs: ::prost::alloc::vec::Vec<KeyValuePair>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Expression {
    #[prost(oneof="expression::Value", tags="1, 2, 3")]
    pub value: ::core::option::Option<expression::Value>,
}
/// Nested message and enum types in `Expression`.
pub mod expression {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Value {
        #[prost(string, tag="1")]
        StringValue(::prost::alloc::string::String),
        #[prost(int64, tag="2")]
        Int64Value(i64),
        #[prost(bool, tag="3")]
        BoolValue(bool),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExpressionList {
    #[prost(message, repeated, tag="1")]
    pub expressions: ::prost::alloc::vec::Vec<Expression>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StructuredAnnotation {
    #[prost(string, tag="1")]
    pub name: ::prost::alloc::string::String,
    /// Optional. Location of the '@' symbol of this annotation in the source code.
    #[prost(message, optional, tag="4")]
    pub source_location: ::core::option::Option<SourceLocation>,
    #[prost(oneof="structured_annotation::Body", tags="2, 3")]
    pub body: ::core::option::Option<structured_annotation::Body>,
}
/// Nested message and enum types in `StructuredAnnotation`.
pub mod structured_annotation {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Body {
        #[prost(message, tag="2")]
        ExpressionList(super::ExpressionList),
        #[prost(message, tag="3")]
        KvPairList(super::KeyValuePairList),
    }
}
/// Location of code relative to a given source file.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SourceLocation {
    /// Path to the source file (absolute or relative to the working directory).
    #[prost(string, tag="1")]
    pub file: ::prost::alloc::string::String,
    /// Line and column numbers within the source file, 1-based.
    #[prost(int32, tag="2")]
    pub line: i32,
    #[prost(int32, tag="3")]
    pub column: i32,
}
/// For "safe" enums with no underlying representation and no member integer
/// values.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4EnumTypeSpec {
    #[prost(message, repeated, tag="1")]
    pub members: ::prost::alloc::vec::Vec<p4_enum_type_spec::Member>,
    #[prost(string, repeated, tag="2")]
    pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. If present, the location of `annotations\[i\]` is given by
    /// `annotation_locations\[i\]`.
    #[prost(message, repeated, tag="4")]
    pub annotation_locations: ::prost::alloc::vec::Vec<SourceLocation>,
    #[prost(message, repeated, tag="3")]
    pub structured_annotations: ::prost::alloc::vec::Vec<StructuredAnnotation>,
}
/// Nested message and enum types in `P4EnumTypeSpec`.
pub mod p4_enum_type_spec {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Member {
        #[prost(string, tag="1")]
        pub name: ::prost::alloc::string::String,
        #[prost(string, repeated, tag="2")]
        pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
        /// Optional. If present, the location of `annotations\[i\]` is given by
        /// `annotation_locations\[i\]`.
        #[prost(message, repeated, tag="4")]
        pub annotation_locations: ::prost::alloc::vec::Vec<super::SourceLocation>,
        #[prost(message, repeated, tag="3")]
        pub structured_annotations: ::prost::alloc::vec::Vec<super::StructuredAnnotation>,
    }
}
/// For serializable (or "unsafe") enums, which have an underlying type. Note
/// that as per the P4_16 specification, the underlying representation can only
/// be a bit<W> type.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4SerializableEnumTypeSpec {
    #[prost(message, optional, tag="1")]
    pub underlying_type: ::core::option::Option<P4BitTypeSpec>,
    #[prost(message, repeated, tag="2")]
    pub members: ::prost::alloc::vec::Vec<p4_serializable_enum_type_spec::Member>,
    #[prost(string, repeated, tag="3")]
    pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. If present, the location of `annotations\[i\]` is given by
    /// `annotation_locations\[i\]`.
    #[prost(message, repeated, tag="5")]
    pub annotation_locations: ::prost::alloc::vec::Vec<SourceLocation>,
    #[prost(message, repeated, tag="4")]
    pub structured_annotations: ::prost::alloc::vec::Vec<StructuredAnnotation>,
}
/// Nested message and enum types in `P4SerializableEnumTypeSpec`.
pub mod p4_serializable_enum_type_spec {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Member {
        #[prost(string, tag="1")]
        pub name: ::prost::alloc::string::String,
        #[prost(bytes="vec", tag="2")]
        pub value: ::prost::alloc::vec::Vec<u8>,
        #[prost(string, repeated, tag="3")]
        pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
        /// Optional. If present, the location of `annotations\[i\]` is given by
        /// `annotation_locations\[i\]`.
        #[prost(message, repeated, tag="5")]
        pub annotation_locations: ::prost::alloc::vec::Vec<super::SourceLocation>,
        #[prost(message, repeated, tag="4")]
        pub structured_annotations: ::prost::alloc::vec::Vec<super::StructuredAnnotation>,
    }
}
/// Similar to an enum, but there is always one and only one instance per P4
/// program.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4ErrorTypeSpec {
    #[prost(string, repeated, tag="1")]
    pub members: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4NewTypeTranslation {
    /// the URI uniquely identifies the translation in order to enable the
    /// P4Runtime agent to perform value-mapping appropriately when required. It is
    /// recommended that the URI includes at least the P4 architecture name and the
    /// type name.
    #[prost(string, tag="1")]
    pub uri: ::prost::alloc::string::String,
    /// The object is either represented as an unsigned integer with a bitwidth of
    /// `sdn_bitwidth`, or as a string.
    #[prost(oneof="p4_new_type_translation::SdnType", tags="2, 3")]
    pub sdn_type: ::core::option::Option<p4_new_type_translation::SdnType>,
}
/// Nested message and enum types in `P4NewTypeTranslation`.
pub mod p4_new_type_translation {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct SdnString {
    }
    /// The object is either represented as an unsigned integer with a bitwidth of
    /// `sdn_bitwidth`, or as a string.
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Oneof)]
    pub enum SdnType {
        #[prost(int32, tag="2")]
        SdnBitwidth(i32),
        #[prost(message, tag="3")]
        SdnString(SdnString),
    }
}
/// New types introduced with the "type" keyword
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4NewTypeSpec {
    /// for other annotations (not @p4runtime_translation)
    #[prost(string, repeated, tag="3")]
    pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. If present, the location of `annotations\[i\]` is given by
    /// `annotation_locations\[i\]`.
    #[prost(message, repeated, tag="5")]
    pub annotation_locations: ::prost::alloc::vec::Vec<SourceLocation>,
    #[prost(message, repeated, tag="4")]
    pub structured_annotations: ::prost::alloc::vec::Vec<StructuredAnnotation>,
    #[prost(oneof="p4_new_type_spec::Representation", tags="1, 2")]
    pub representation: ::core::option::Option<p4_new_type_spec::Representation>,
}
/// Nested message and enum types in `P4NewTypeSpec`.
pub mod p4_new_type_spec {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Representation {
        /// if no @p4runtime_translation annotation present
        #[prost(message, tag="1")]
        OriginalType(super::P4DataTypeSpec),
        /// if @p4runtime_translation annotation present
        #[prost(message, tag="2")]
        TranslatedType(super::P4NewTypeTranslation),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4Info {
    #[prost(message, optional, tag="1")]
    pub pkg_info: ::core::option::Option<PkgInfo>,
    #[prost(message, repeated, tag="2")]
    pub tables: ::prost::alloc::vec::Vec<Table>,
    #[prost(message, repeated, tag="3")]
    pub actions: ::prost::alloc::vec::Vec<Action>,
    #[prost(message, repeated, tag="4")]
    pub action_profiles: ::prost::alloc::vec::Vec<ActionProfile>,
    #[prost(message, repeated, tag="5")]
    pub counters: ::prost::alloc::vec::Vec<Counter>,
    #[prost(message, repeated, tag="6")]
    pub direct_counters: ::prost::alloc::vec::Vec<DirectCounter>,
    #[prost(message, repeated, tag="7")]
    pub meters: ::prost::alloc::vec::Vec<Meter>,
    #[prost(message, repeated, tag="8")]
    pub direct_meters: ::prost::alloc::vec::Vec<DirectMeter>,
    #[prost(message, repeated, tag="9")]
    pub controller_packet_metadata: ::prost::alloc::vec::Vec<ControllerPacketMetadata>,
    #[prost(message, repeated, tag="10")]
    pub value_sets: ::prost::alloc::vec::Vec<ValueSet>,
    #[prost(message, repeated, tag="11")]
    pub registers: ::prost::alloc::vec::Vec<Register>,
    #[prost(message, repeated, tag="12")]
    pub digests: ::prost::alloc::vec::Vec<Digest>,
    #[prost(message, repeated, tag="100")]
    pub externs: ::prost::alloc::vec::Vec<Extern>,
    #[prost(message, optional, tag="200")]
    pub type_info: ::core::option::Option<P4TypeInfo>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Documentation {
    /// A brief description of something, e.g. one sentence
    #[prost(string, tag="1")]
    pub brief: ::prost::alloc::string::String,
    /// A more verbose description of something. Multiline is accepted. Markup
    /// format (if any) is TBD.
    #[prost(string, tag="2")]
    pub description: ::prost::alloc::string::String,
}
/// Used to describe the required properties of the underlying platform.
/// Added in v1.4.0
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct PlatformProperties {
    /// The minimum number of multicast entries (i.e. multicast groups) that the
    /// platform is required to support. If 0, there are no requirements.
    #[prost(int32, tag="1")]
    pub multicast_group_table_size: i32,
    /// The minimum number of replicas that the platform is required to support
    /// across all  groups. If 0, there are no requirements.
    #[prost(int32, tag="2")]
    pub multicast_group_table_total_replicas: i32,
    /// The number of replicas that the platform is required to support per
    /// group/entry. If 0, `multicast_group_table_total_replicas` should be used.
    /// Must be no larger than `multicast_group_table_total_replicas`.
    #[prost(int32, tag="3")]
    pub multicast_group_table_max_replicas_per_entry: i32,
}
/// Top-level package documentation describing the forwarding pipeline config
/// Can be used to manage multiple P4 packages.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PkgInfo {
    /// a definitive name for this configuration, e.g. switch.p4_v1.0
    #[prost(string, tag="1")]
    pub name: ::prost::alloc::string::String,
    /// configuration version, free-format string
    #[prost(string, tag="2")]
    pub version: ::prost::alloc::string::String,
    /// brief and detailed descriptions
    #[prost(message, optional, tag="3")]
    pub doc: ::core::option::Option<Documentation>,
    /// Miscellaneous metadata, free-form; a way to extend PkgInfo
    #[prost(string, repeated, tag="4")]
    pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. If present, the location of `annotations\[i\]` is given by
    /// `annotation_locations\[i\]`.
    #[prost(message, repeated, tag="10")]
    pub annotation_locations: ::prost::alloc::vec::Vec<SourceLocation>,
    /// the target architecture, e.g. "psa"
    #[prost(string, tag="5")]
    pub arch: ::prost::alloc::string::String,
    /// organization which produced the configuration, e.g. "p4.org"
    #[prost(string, tag="6")]
    pub organization: ::prost::alloc::string::String,
    /// contact info for support,e.g. "tech-support@acme.org"
    #[prost(string, tag="7")]
    pub contact: ::prost::alloc::string::String,
    /// url for more information, e.g.
    /// "<http://support.p4.org/ref/p4/switch.p4_v1.0">
    #[prost(string, tag="8")]
    pub url: ::prost::alloc::string::String,
    /// Miscellaneous metadata, structured; a way to extend PkgInfo
    #[prost(message, repeated, tag="9")]
    pub structured_annotations: ::prost::alloc::vec::Vec<StructuredAnnotation>,
    /// If set, specifies the properties that the underlying platform should have.
    /// If the platform does not conform to these properties, the server should
    /// reject the P4Info when used with a SetForwardingPipelineConfigRequest.
    /// Added in 1.4.0
    #[prost(message, optional, tag="11")]
    pub platform_properties: ::core::option::Option<PlatformProperties>,
}
/// wrapping the enum in a message to avoid name collisions in C++, where "enum
/// values are siblings of their type, not children of it"
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct P4Ids {
}
/// Nested message and enum types in `P4Ids`.
pub mod p4_ids {
    /// ids are allocated in such a way that it is possible based on an id to
    /// deduce the resource type (e.g. table, action, counter, ...). The
    /// most-significant byte of the 32-bit id encodes the resource type. The
    /// purpose of this enum is to define which value is used as the
    /// most-significant byte for each resource type. The P4 compiler must use
    /// these values when allocating ids for P4 objects. Other users of P4Info can
    /// refer to this enum to identify a resource type based on its id.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Prefix {
        Unspecified = 0,
        /// P4 language built-ins
        Action = 1,
        Table = 2,
        ValueSet = 3,
        ControllerHeader = 4,
        /// PSA externs
        PsaExternsStart = 16,
        ActionProfile = 17,
        Counter = 18,
        DirectCounter = 19,
        Meter = 20,
        DirectMeter = 21,
        Register = 22,
        Digest = 23,
        /// externs for other architectures (vendor extensions)
        OtherExternsStart = 128,
        /// max value for an unsigned 8-bit byte
        ///
        /// requires protoc >= 3.5.0
        /// reserved 0x100 to max;
        Max = 255,
    }
    impl Prefix {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Prefix::Unspecified => "UNSPECIFIED",
                Prefix::Action => "ACTION",
                Prefix::Table => "TABLE",
                Prefix::ValueSet => "VALUE_SET",
                Prefix::ControllerHeader => "CONTROLLER_HEADER",
                Prefix::PsaExternsStart => "PSA_EXTERNS_START",
                Prefix::ActionProfile => "ACTION_PROFILE",
                Prefix::Counter => "COUNTER",
                Prefix::DirectCounter => "DIRECT_COUNTER",
                Prefix::Meter => "METER",
                Prefix::DirectMeter => "DIRECT_METER",
                Prefix::Register => "REGISTER",
                Prefix::Digest => "DIGEST",
                Prefix::OtherExternsStart => "OTHER_EXTERNS_START",
                Prefix::Max => "MAX",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNSPECIFIED" => Some(Self::Unspecified),
                "ACTION" => Some(Self::Action),
                "TABLE" => Some(Self::Table),
                "VALUE_SET" => Some(Self::ValueSet),
                "CONTROLLER_HEADER" => Some(Self::ControllerHeader),
                "PSA_EXTERNS_START" => Some(Self::PsaExternsStart),
                "ACTION_PROFILE" => Some(Self::ActionProfile),
                "COUNTER" => Some(Self::Counter),
                "DIRECT_COUNTER" => Some(Self::DirectCounter),
                "METER" => Some(Self::Meter),
                "DIRECT_METER" => Some(Self::DirectMeter),
                "REGISTER" => Some(Self::Register),
                "DIGEST" => Some(Self::Digest),
                "OTHER_EXTERNS_START" => Some(Self::OtherExternsStart),
                "MAX" => Some(Self::Max),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Preamble {
    /// ids share the same number-space; e.g. table ids cannot overlap with counter
    /// ids. Even though this is irrelevant to this proto definition, the ids are
    /// allocated in such a way that it is possible based on an id to deduce the
    /// resource type (e.g. table, action, counter, ...). This means that code
    /// using these ids can detect if the wrong resource type is used
    /// somewhere. This also means that ids of different types can be mixed
    /// (e.g. direct resource list for a table) without ambiguity. Note that id 0
    /// is reserved and means "invalid id".
    #[prost(uint32, tag="1")]
    pub id: u32,
    /// fully qualified name of the P4 object, e.g. c1.c2.ipv4_lpm
    #[prost(string, tag="2")]
    pub name: ::prost::alloc::string::String,
    /// an alias (alternative name) for the P4 object, probably shorter than its
    /// fully qualified name. The only constraint is for it to be unique with
    /// respect to other P4 objects of the same type. By default, the compiler uses
    /// the shortest suffix of the name that uniquely identifies the object. For
    /// example if the P4 program contains two tables with names s.c1.t and s.c2.t,
    /// the default aliases will respectively be c1.t and c2.t. In the future, the
    /// P4 programmer may also be able to override the default alias for any P4
    /// object (TBD).
    #[prost(string, tag="3")]
    pub alias: ::prost::alloc::string::String,
    #[prost(string, repeated, tag="4")]
    pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. If present, the location of `annotations\[i\]` is given by
    /// `annotation_locations\[i\]`.
    #[prost(message, repeated, tag="7")]
    pub annotation_locations: ::prost::alloc::vec::Vec<SourceLocation>,
    /// Documentation of the entity
    #[prost(message, optional, tag="5")]
    pub doc: ::core::option::Option<Documentation>,
    #[prost(message, repeated, tag="6")]
    pub structured_annotations: ::prost::alloc::vec::Vec<StructuredAnnotation>,
}
/// used to group all extern instances of the same type in one message
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Extern {
    /// the extern_type_id is unique for a given architecture and must be in the
    /// range \[0x81, 0xfe\].
    #[prost(uint32, tag="1")]
    pub extern_type_id: u32,
    #[prost(string, tag="2")]
    pub extern_type_name: ::prost::alloc::string::String,
    #[prost(message, repeated, tag="3")]
    pub instances: ::prost::alloc::vec::Vec<ExternInstance>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExternInstance {
    #[prost(message, optional, tag="1")]
    pub preamble: ::core::option::Option<Preamble>,
    /// specific to the extern type, declared in a separate vendor-specific proto
    /// file
    #[prost(message, optional, tag="2")]
    pub info: ::core::option::Option<::pbjson_types::Any>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MatchField {
    #[prost(uint32, tag="1")]
    pub id: u32,
    #[prost(string, tag="2")]
    pub name: ::prost::alloc::string::String,
    #[prost(string, repeated, tag="3")]
    pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. If present, the location of `annotations\[i\]` is given by
    /// `annotation_locations\[i\]`.
    #[prost(message, repeated, tag="10")]
    pub annotation_locations: ::prost::alloc::vec::Vec<SourceLocation>,
    #[prost(int32, tag="4")]
    pub bitwidth: i32,
    /// Documentation of the match field
    #[prost(message, optional, tag="6")]
    pub doc: ::core::option::Option<Documentation>,
    /// unset if not user-defined type
    #[prost(message, optional, tag="8")]
    pub type_name: ::core::option::Option<P4NamedType>,
    #[prost(message, repeated, tag="9")]
    pub structured_annotations: ::prost::alloc::vec::Vec<StructuredAnnotation>,
    #[prost(oneof="match_field::Match", tags="5, 7")]
    pub r#match: ::core::option::Option<match_field::Match>,
}
/// Nested message and enum types in `MatchField`.
pub mod match_field {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum MatchType {
        Unspecified = 0,
        Exact = 2,
        Lpm = 3,
        Ternary = 4,
        Range = 5,
        Optional = 6,
    }
    impl MatchType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                MatchType::Unspecified => "UNSPECIFIED",
                MatchType::Exact => "EXACT",
                MatchType::Lpm => "LPM",
                MatchType::Ternary => "TERNARY",
                MatchType::Range => "RANGE",
                MatchType::Optional => "OPTIONAL",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNSPECIFIED" => Some(Self::Unspecified),
                "EXACT" => Some(Self::Exact),
                "LPM" => Some(Self::Lpm),
                "TERNARY" => Some(Self::Ternary),
                "RANGE" => Some(Self::Range),
                "OPTIONAL" => Some(Self::Optional),
                _ => None,
            }
        }
    }
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Match {
        #[prost(enumeration="MatchType", tag="5")]
        MatchType(i32),
        /// used for architecture-specific match types which are not part of the core
        /// P4 language or of the PSA architecture.
        #[prost(string, tag="7")]
        OtherMatchType(::prost::alloc::string::String),
    }
}
/// A TableActionCall references a particular action id and executes the
/// action with the supplied list of arguments.
/// Arguments are matched to the id of the respective action parameter.
/// TableActionCalls may be used as the default action call of a table implementation.
/// Added in 1.4.0.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableActionCall {
    #[prost(uint32, tag="1")]
    pub action_id: u32,
    #[prost(message, repeated, tag="4")]
    pub arguments: ::prost::alloc::vec::Vec<table_action_call::Argument>,
}
/// Nested message and enum types in `TableActionCall`.
pub mod table_action_call {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Argument {
        #[prost(uint32, tag="2")]
        pub param_id: u32,
        #[prost(bytes="vec", tag="3")]
        pub value: ::prost::alloc::vec::Vec<u8>,
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Table {
    #[prost(message, optional, tag="1")]
    pub preamble: ::core::option::Option<Preamble>,
    #[prost(message, repeated, tag="2")]
    pub match_fields: ::prost::alloc::vec::Vec<MatchField>,
    /// even when the table is indirect (see implementation_id) below, this field
    /// includes all possible actions for the table; by using ActionRef instead of
    /// a repeated field of action ids, each action reference in a P4 table is able
    /// to have its own annotations
    #[prost(message, repeated, tag="3")]
    pub action_refs: ::prost::alloc::vec::Vec<ActionRef>,
    /// 0 (default value) means that the table does not have a const default action
    #[prost(uint32, tag="4")]
    pub const_default_action_id: u32,
    /// The initial default action of the table. This can be overridden at runtime.
    /// Added in 1.4.0.
    #[prost(message, optional, tag="5")]
    pub initial_default_action: ::core::option::Option<TableActionCall>,
    /// P4 id of the "implementation" for this table (e.g. action profile id); 0
    /// (default value) means that the table is a regular (direct) match table. As
    /// of today, only action profiles are supported but other table
    /// implementations may be added in the future
    #[prost(uint32, tag="6")]
    pub implementation_id: u32,
    /// ids of the direct resources (if any) attached to this table; for now this
    /// includes only direct counters and direct meters, but other resources may be
    /// added in the future
    #[prost(uint32, repeated, tag="7")]
    pub direct_resource_ids: ::prost::alloc::vec::Vec<u32>,
    /// max number of entries in table
    #[prost(int64, tag="8")]
    pub size: i64,
    /// is idle timeout supported for this table?
    #[prost(enumeration="table::IdleTimeoutBehavior", tag="9")]
    pub idle_timeout_behavior: i32,
    /// True if and only if the table's entries are immutable,
    /// i.e. defined using the 'const entries' table property in the P4
    /// source code, and thus entries cannot be deleted, modified, or
    /// inserted at run time.
    #[prost(bool, tag="10")]
    pub is_const_table: bool,
    /// True if and only if the table has initial entries defined using
    /// the 'entries' table property in the P4 source code, either with
    /// or without the 'const' qualifier on 'entries', and there is at
    /// least one entry in that list.  This field is false if the list of
    /// entries is empty in the P4 source code.
    /// Added in 1.4.0.
    #[prost(bool, tag="11")]
    pub has_initial_entries: bool,
    /// architecture-specific table properties which are not part of the core P4
    /// language or of the PSA architecture.
    #[prost(message, optional, tag="100")]
    pub other_properties: ::core::option::Option<::pbjson_types::Any>,
}
/// Nested message and enum types in `Table`.
pub mod table {
    /// this enum can be extended in the future with other behaviors, such as
    /// "HARD_EVICTION"
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum IdleTimeoutBehavior {
        NoTimeout = 0,
        NotifyControl = 1,
    }
    impl IdleTimeoutBehavior {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                IdleTimeoutBehavior::NoTimeout => "NO_TIMEOUT",
                IdleTimeoutBehavior::NotifyControl => "NOTIFY_CONTROL",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "NO_TIMEOUT" => Some(Self::NoTimeout),
                "NOTIFY_CONTROL" => Some(Self::NotifyControl),
                _ => None,
            }
        }
    }
}
/// used to list all possible actions in a Table
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ActionRef {
    #[prost(uint32, tag="1")]
    pub id: u32,
    #[prost(enumeration="action_ref::Scope", tag="3")]
    pub scope: i32,
    #[prost(string, repeated, tag="2")]
    pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Optional. If present, the location of `annotations\[i\]` is given by
    /// `annotation_locations\[i\]`.
    #[prost(message, repeated, tag="5")]
    pub annotation_locations: ::prost::alloc::vec::Vec<SourceLocation>,
    #[prost(message, repeated, tag="4")]
    pub structured_annotations: ::prost::alloc::vec::Vec<StructuredAnnotation>,
}
/// Nested message and enum types in `ActionRef`.
pub mod action_ref {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Scope {
        TableAndDefault = 0,
        TableOnly = 1,
        DefaultOnly = 2,
    }
    impl Scope {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Scope::TableAndDefault => "TABLE_AND_DEFAULT",
                Scope::TableOnly => "TABLE_ONLY",
                Scope::DefaultOnly => "DEFAULT_ONLY",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "TABLE_AND_DEFAULT" => Some(Self::TableAndDefault),
                "TABLE_ONLY" => Some(Self::TableOnly),
                "DEFAULT_ONLY" => Some(Self::DefaultOnly),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Action {
    #[prost(message, optional, tag="1")]
    pub preamble: ::core::option::Option<Preamble>,
    #[prost(message, repeated, tag="2")]
    pub params: ::prost::alloc::vec::Vec<action::Param>,
}
/// Nested message and enum types in `Action`.
pub mod action {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Param {
        #[prost(uint32, tag="1")]
        pub id: u32,
        #[prost(string, tag="2")]
        pub name: ::prost::alloc::string::String,
        #[prost(string, repeated, tag="3")]
        pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
        /// Optional. If present, the location of `annotations\[i\]` is given by
        /// `annotation_locations\[i\]`.
        #[prost(message, repeated, tag="8")]
        pub annotation_locations: ::prost::alloc::vec::Vec<super::SourceLocation>,
        #[prost(int32, tag="4")]
        pub bitwidth: i32,
        /// Documentation of the Param
        #[prost(message, optional, tag="5")]
        pub doc: ::core::option::Option<super::Documentation>,
        /// unset if not user-defined type
        #[prost(message, optional, tag="6")]
        pub type_name: ::core::option::Option<super::P4NamedType>,
        #[prost(message, repeated, tag="7")]
        pub structured_annotations: ::prost::alloc::vec::Vec<super::StructuredAnnotation>,
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ActionProfile {
    #[prost(message, optional, tag="1")]
    pub preamble: ::core::option::Option<Preamble>,
    /// the ids of the tables sharing this action profile
    #[prost(uint32, repeated, tag="2")]
    pub table_ids: ::prost::alloc::vec::Vec<u32>,
    /// true iff the action profile used dynamic selection
    #[prost(bool, tag="3")]
    pub with_selector: bool,
    /// max number of member entries across all groups if the action profile does
    /// not have a selector. Otherwise, semantics as specified by
    /// `selector_size_semantics` below.
    #[prost(int64, tag="4")]
    pub size: i64,
    /// 0 if the action profile does not have a selector. Otherwise, semantics as
    /// specified by `selector_size_semantics` below.
    #[prost(int32, tag="5")]
    pub max_group_size: i32,
    /// specifies the semantics of `size` and `max_group_size` above
    #[prost(oneof="action_profile::SelectorSizeSemantics", tags="6, 7")]
    pub selector_size_semantics: ::core::option::Option<action_profile::SelectorSizeSemantics>,
}
/// Nested message and enum types in `ActionProfile`.
pub mod action_profile {
    /// indicates that `size` and `max_group_size` represent the maximum sum of
    /// weights that can be present across all selector groups and within a
    /// single selector group respectively.
    /// Added in v1.4.0
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct SumOfWeights {
    }
    /// indicates that `size` and `max_group_size` represent the maximum number
    /// of members that can be present across all selector groups and within a
    /// single selector group respectively.
    /// Added in v1.4.0
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct SumOfMembers {
        /// the maximum weight of each individual member in a group.
        #[prost(int32, tag="1")]
        pub max_member_weight: i32,
    }
    /// specifies the semantics of `size` and `max_group_size` above
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Oneof)]
    pub enum SelectorSizeSemantics {
        /// group size is the sum of the group's weights.
        /// Added in v1.4.0
        #[prost(message, tag="6")]
        SumOfWeights(SumOfWeights),
        /// group size is the sum of the group's members.
        /// Added in v1.4.0
        #[prost(message, tag="7")]
        SumOfMembers(SumOfMembers),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CounterSpec {
    #[prost(enumeration="counter_spec::Unit", tag="1")]
    pub unit: i32,
}
/// Nested message and enum types in `CounterSpec`.
pub mod counter_spec {
    /// Corresponds to 'type' constructor parameter for Counter / DirectCounter in
    /// PSA
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Unit {
        Unspecified = 0,
        Bytes = 1,
        Packets = 2,
        Both = 3,
    }
    impl Unit {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Unit::Unspecified => "UNSPECIFIED",
                Unit::Bytes => "BYTES",
                Unit::Packets => "PACKETS",
                Unit::Both => "BOTH",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNSPECIFIED" => Some(Self::Unspecified),
                "BYTES" => Some(Self::Bytes),
                "PACKETS" => Some(Self::Packets),
                "BOTH" => Some(Self::Both),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Counter {
    #[prost(message, optional, tag="1")]
    pub preamble: ::core::option::Option<Preamble>,
    #[prost(message, optional, tag="2")]
    pub spec: ::core::option::Option<CounterSpec>,
    /// number of entries in the counter array
    #[prost(int64, tag="3")]
    pub size: i64,
    /// unset if index is not user-defined type
    #[prost(message, optional, tag="4")]
    pub index_type_name: ::core::option::Option<P4NamedType>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DirectCounter {
    #[prost(message, optional, tag="1")]
    pub preamble: ::core::option::Option<Preamble>,
    #[prost(message, optional, tag="2")]
    pub spec: ::core::option::Option<CounterSpec>,
    /// the id of the table to which the counter is attached
    #[prost(uint32, tag="3")]
    pub direct_table_id: u32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct MeterSpec {
    #[prost(enumeration="meter_spec::Unit", tag="1")]
    pub unit: i32,
    /// Added in 1.4.0.
    #[prost(enumeration="meter_spec::Type", tag="2")]
    pub r#type: i32,
}
/// Nested message and enum types in `MeterSpec`.
pub mod meter_spec {
    /// Corresponds to 'type' constructor parameter for Meter / DirectMeter in PSA
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Unit {
        Unspecified = 0,
        Bytes = 1,
        Packets = 2,
    }
    impl Unit {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Unit::Unspecified => "UNSPECIFIED",
                Unit::Bytes => "BYTES",
                Unit::Packets => "PACKETS",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNSPECIFIED" => Some(Self::Unspecified),
                "BYTES" => Some(Self::Bytes),
                "PACKETS" => Some(Self::Packets),
                _ => None,
            }
        }
    }
    /// Used to restrict the MeterConfigs that can be used to instantiate the
    /// meter.
    /// Added in 1.4.0.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Type {
        /// As described in RFC 2698, allows meters to use two rates to split packets
        /// into three potential colors.
        /// MeterConfigs on table entries using this meter type MUST have `eburst ==
        /// 0` (i.e. unset).
        TwoRateThreeColor = 0,
        /// As described in RFC 2697, allows meters to use one rate with an Excess
        /// Burst Size (EBS) to split packets into three potential colors.
        /// MeterConfigs on table entries using this meter type MUST have
        /// `cir == pir && cburst == pburst`.
        SingleRateThreeColor = 1,
        /// A simplified version of RFC 2697, restricting meters to using a single
        /// rate to split packets into only RED or GREEN, by not providing an Excess
        /// Burst Size (EBS).
        /// MeterConfigs on table entries using this meter type MUST have
        /// `cir == pir && cburst == pburst && eburst == 0` (i.e. unset).
        SingleRateTwoColor = 2,
    }
    impl Type {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Type::TwoRateThreeColor => "TWO_RATE_THREE_COLOR",
                Type::SingleRateThreeColor => "SINGLE_RATE_THREE_COLOR",
                Type::SingleRateTwoColor => "SINGLE_RATE_TWO_COLOR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "TWO_RATE_THREE_COLOR" => Some(Self::TwoRateThreeColor),
                "SINGLE_RATE_THREE_COLOR" => Some(Self::SingleRateThreeColor),
                "SINGLE_RATE_TWO_COLOR" => Some(Self::SingleRateTwoColor),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Meter {
    #[prost(message, optional, tag="1")]
    pub preamble: ::core::option::Option<Preamble>,
    #[prost(message, optional, tag="2")]
    pub spec: ::core::option::Option<MeterSpec>,
    /// number of entries in the meter array
    #[prost(int64, tag="3")]
    pub size: i64,
    /// unset if index is not user-defined type
    #[prost(message, optional, tag="4")]
    pub index_type_name: ::core::option::Option<P4NamedType>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DirectMeter {
    #[prost(message, optional, tag="1")]
    pub preamble: ::core::option::Option<Preamble>,
    #[prost(message, optional, tag="2")]
    pub spec: ::core::option::Option<MeterSpec>,
    /// the id of the table to which the meter is attached
    #[prost(uint32, tag="3")]
    pub direct_table_id: u32,
}
/// Any metadata associated with controller Packet-IO (Packet-In or Packet-Out)
/// is modeled as P4 headers carrying special annotations
/// @controller_header("packet_out") and @controller_header("packet_in")
/// respectively. There can be at most one header each with these annotations.
/// This message captures the info contained within these special headers,
/// and used in p4runtime.proto to supply the metadata.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ControllerPacketMetadata {
    /// preamble.name and preamble.id will specify header type ("packet_out" or
    /// "packet_in" for now).
    #[prost(message, optional, tag="1")]
    pub preamble: ::core::option::Option<Preamble>,
    /// Ordered based on header layout.
    /// This is a constraint on the generator of this P4Info.
    #[prost(message, repeated, tag="2")]
    pub metadata: ::prost::alloc::vec::Vec<controller_packet_metadata::Metadata>,
}
/// Nested message and enum types in `ControllerPacketMetadata`.
pub mod controller_packet_metadata {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Metadata {
        #[prost(uint32, tag="1")]
        pub id: u32,
        /// This is the name of the header field (not fully-qualified), similar
        /// to e.g. Action.Param.name.
        #[prost(string, tag="2")]
        pub name: ::prost::alloc::string::String,
        #[prost(string, repeated, tag="3")]
        pub annotations: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
        /// Optional. If present, the location of `annotations\[i\]` is given by
        /// `annotation_locations\[i\]`.
        #[prost(message, repeated, tag="7")]
        pub annotation_locations: ::prost::alloc::vec::Vec<super::SourceLocation>,
        #[prost(int32, tag="4")]
        pub bitwidth: i32,
        /// unset if not user-defined type
        #[prost(message, optional, tag="5")]
        pub type_name: ::core::option::Option<super::P4NamedType>,
        #[prost(message, repeated, tag="6")]
        pub structured_annotations: ::prost::alloc::vec::Vec<super::StructuredAnnotation>,
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ValueSet {
    #[prost(message, optional, tag="1")]
    pub preamble: ::core::option::Option<Preamble>,
    #[prost(message, repeated, tag="2")]
    pub r#match: ::prost::alloc::vec::Vec<MatchField>,
    /// number of entries in the value_set, as per the P4 constructor call.
    #[prost(int32, tag="3")]
    pub size: i32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Register {
    #[prost(message, optional, tag="1")]
    pub preamble: ::core::option::Option<Preamble>,
    #[prost(message, optional, tag="2")]
    pub type_spec: ::core::option::Option<P4DataTypeSpec>,
    #[prost(int32, tag="3")]
    pub size: i32,
    /// unset if index is not user-defined type
    #[prost(message, optional, tag="4")]
    pub index_type_name: ::core::option::Option<P4NamedType>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Digest {
    #[prost(message, optional, tag="1")]
    pub preamble: ::core::option::Option<Preamble>,
    #[prost(message, optional, tag="2")]
    pub type_spec: ::core::option::Option<P4DataTypeSpec>,
}
// @@protoc_insertion_point(module)
