/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.template.network;

import com.ubnt.data.NetworkConf;
import com.ubnt.service.orchestration.dto.report.IssueDetailReportDto;
import com.ubnt.service.orchestration.model.NetworkTemplate;
import com.ubnt.service.orchestration.template.TemplateConfigurationConstructor;
import com.ubnt.service.orchestration.template.TemplateProvisioningHandler;
import com.ubnt.service.orchestration.template.TemplateProvisioningValidationIssue;
import com.ubnt.service.orchestration.template.TemplateType;
import com.ubnt.service.orchestration.template.network.NetworkConfigsProvisionService;
import com.ubnt.service.orchestration.template.network.validator.NetworkOrchestrationError;
import com.ubnt.service.orchestration.template.wifi.validator.WifiOrchestrationError;
import com.ubnt.service.system.jA;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

public class NetworkTemplateTypeProvisioningHandler
implements TemplateProvisioningHandler<NetworkTemplate> {
    private static final Logger LOGGER = jA.ifnew;
    private final TemplateConfigurationConstructor<NetworkTemplate, NetworkConf> templateConfigurationConstructor;
    private final NetworkConfigsProvisionService networkConfigsProvisionService;

    @Override
    public Map<TemplateProvisioningValidationIssue, List<IssueDetailReportDto>> handle(String string, NetworkTemplate networkTemplate) {
        try {
            NetworkConf networkConf = this.templateConfigurationConstructor.construct(string, networkTemplate);
            if (networkConf == null) {
                LOGGER.warn("Can't construct VLAN configuration for siteId '{}' and orchestrationId '{}'", (Object)string, (Object)networkTemplate.getMetaData().orchestrationId());
                return Map.of(TemplateProvisioningValidationIssue.ERROR, List.of(IssueDetailReportDto.builder().code(WifiOrchestrationError.PROVISIONING_ERROR).issueDetail("Can't construct VLAN configuration from template").build()));
            }
            return this.networkConfigsProvisionService.validateAndProvision(List.of(networkConf));
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to apply VLAN configuration: {}", (Object)exception.getMessage(), (Object)exception);
            return Map.of(TemplateProvisioningValidationIssue.ERROR, List.of(IssueDetailReportDto.builder().code(NetworkOrchestrationError.PROVISIONING_ERROR).issueDetail("Failed to apply VLAN configuration").build()));
        }
    }

    @Override
    public TemplateType getType() {
        return TemplateType.NETWORK;
    }

    @Override
    public Class<NetworkTemplate> handledType() {
        return NetworkTemplate.class;
    }

    @ConstructorProperties(value={"templateConfigurationConstructor", "networkConfigsProvisionService"})
    @Generated
    public NetworkTemplateTypeProvisioningHandler(TemplateConfigurationConstructor<NetworkTemplate, NetworkConf> templateConfigurationConstructor, NetworkConfigsProvisionService networkConfigsProvisionService) {
        this.templateConfigurationConstructor = templateConfigurationConstructor;
        this.networkConfigsProvisionService = networkConfigsProvisionService;
    }
}

