/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogBrush;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogRegion;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdPaintRgn
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_REGION = 0;
    private int region;

    public void replay(WmfFile file) {
        MfLogRegion regio = file.getRegionObject(this.region);
        MfDcState state = file.getCurrentState();
        state.setLogRegion(regio);
        MfLogBrush brush = state.getLogBrush();
        Graphics2D graph = file.getGraphics2D();
        Rectangle rec = this.scaleRect(regio.getBounds());
        if (brush.isVisible()) {
            state.preparePaint();
            graph.fill(rec);
            state.postPaint();
        }
    }

    public MfCmd getInstance() {
        return new MfCmdPaintRgn();
    }

    public void setRecord(MfRecord record) {
        this.region = record.getParam(0);
    }

    public MfRecord getRecord() {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getRegion());
        return record;
    }

    public void setRegion(int region) {
        this.region = region;
    }

    public int getRegion() {
        return this.region;
    }

    public int getFunction() {
        return 299;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[PAINT_REGION] region=");
        b.append(this.getRegion());
        return b.toString();
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }
}

