// Code generated by gen/gen_test.go DO NOT EDIT.

package namesilo

import (
	"context"
	"encoding/xml"
	"io"
	"net/http"
	"net/http/httptest"
	"net/url"
	"os"
	"path/filepath"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func setupFakeAPI(t *testing.T, operation string) *Client {
	t.Helper()

	mux := http.NewServeMux()
	server := httptest.NewServer(mux)
	t.Cleanup(server.Close)

	mux.HandleFunc("/"+operation, func(w http.ResponseWriter, r *http.Request) {
		query := r.URL.Query()

		key := query.Get("key")
		if key != "1234" {
			err := xml.NewEncoder(w).Encode(Operation{Reply: Reply{Code: "110", Detail: "Invalid API Key"}})
			if err != nil {
				http.Error(w, err.Error(), http.StatusInternalServerError)
				return
			}
		}

		f, err := os.Open(filepath.Clean(filepath.Join(".", "fixtures", "operations", operation+".xml")))
		if err != nil {
			http.Error(w, err.Error(), http.StatusInternalServerError)
			return
		}

		_, err = io.Copy(w, f)
		if err != nil {
			http.Error(w, err.Error(), http.StatusInternalServerError)
			return
		}
	})

	client := NewClient("1234")
	client.Endpoint, _ = url.Parse(server.URL)

	return client
}

func TestClient_AddAccountFunds(t *testing.T) {
	client := setupFakeAPI(t, "addAccountFunds")

	params := &AddAccountFundsParams{}

	result, err := client.AddAccountFunds(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &AddAccountFunds{}, result)
}

func TestClient_AddAutoRenewal(t *testing.T) {
	client := setupFakeAPI(t, "addAutoRenewal")

	params := &AddAutoRenewalParams{}

	result, err := client.AddAutoRenewal(context.TODO(), params)
	require.Error(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &AddAutoRenewal{}, result)
}

func TestClient_AddPrivacy(t *testing.T) {
	client := setupFakeAPI(t, "addPrivacy")

	params := &AddPrivacyParams{}

	result, err := client.AddPrivacy(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &AddPrivacy{}, result)
}

func TestClient_AddRegisteredNameServer(t *testing.T) {
	client := setupFakeAPI(t, "addRegisteredNameServer")

	params := &AddRegisteredNameServerParams{}

	result, err := client.AddRegisteredNameServer(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &AddRegisteredNameServer{}, result)
}

func TestClient_BidAuction(t *testing.T) {
	client := setupFakeAPI(t, "bidAuction")

	params := &BidAuctionParams{}

	result, err := client.BidAuction(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &BidAuction{}, result)
}

func TestClient_BuyNowAuction(t *testing.T) {
	client := setupFakeAPI(t, "buyNowAuction")

	params := &BuyNowAuctionParams{}

	result, err := client.BuyNowAuction(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &BuyNowAuction{}, result)
}

func TestClient_ChangeNameServers(t *testing.T) {
	client := setupFakeAPI(t, "changeNameServers")

	params := &ChangeNameServersParams{}

	result, err := client.ChangeNameServers(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ChangeNameServers{}, result)
}

func TestClient_CheckRegisterAvailability(t *testing.T) {
	client := setupFakeAPI(t, "checkRegisterAvailability")

	params := &CheckRegisterAvailabilityParams{}

	result, err := client.CheckRegisterAvailability(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &CheckRegisterAvailability{}, result)
}

func TestClient_CheckTransferAvailability(t *testing.T) {
	client := setupFakeAPI(t, "checkTransferAvailability")

	params := &CheckTransferAvailabilityParams{}

	result, err := client.CheckTransferAvailability(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &CheckTransferAvailability{}, result)
}

func TestClient_CheckTransferStatus(t *testing.T) {
	client := setupFakeAPI(t, "checkTransferStatus")

	params := &CheckTransferStatusParams{}

	result, err := client.CheckTransferStatus(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &CheckTransferStatus{}, result)
}

func TestClient_ConfigureEmailForward(t *testing.T) {
	client := setupFakeAPI(t, "configureEmailForward")

	params := &ConfigureEmailForwardParams{}

	result, err := client.ConfigureEmailForward(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ConfigureEmailForward{}, result)
}

func TestClient_ContactAdd(t *testing.T) {
	client := setupFakeAPI(t, "contactAdd")

	params := &ContactAddParams{}

	result, err := client.ContactAdd(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ContactAdd{}, result)
}

func TestClient_ContactDelete(t *testing.T) {
	client := setupFakeAPI(t, "contactDelete")

	params := &ContactDeleteParams{}

	result, err := client.ContactDelete(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ContactDelete{}, result)
}

func TestClient_ContactDomainAssociate(t *testing.T) {
	client := setupFakeAPI(t, "contactDomainAssociate")

	params := &ContactDomainAssociateParams{}

	result, err := client.ContactDomainAssociate(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ContactDomainAssociate{}, result)
}

func TestClient_ContactList(t *testing.T) {
	client := setupFakeAPI(t, "contactList")

	params := &ContactListParams{}

	result, err := client.ContactList(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ContactList{}, result)
}

func TestClient_ContactUpdate(t *testing.T) {
	client := setupFakeAPI(t, "contactUpdate")

	params := &ContactUpdateParams{}

	result, err := client.ContactUpdate(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ContactUpdate{}, result)
}

func TestClient_CountExpiringDomains(t *testing.T) {
	client := setupFakeAPI(t, "countExpiringDomains")

	params := &CountExpiringDomainsParams{}

	result, err := client.CountExpiringDomains(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &CountExpiringDomains{}, result)
}

func TestClient_DeleteEmailForward(t *testing.T) {
	client := setupFakeAPI(t, "deleteEmailForward")

	params := &DeleteEmailForwardParams{}

	result, err := client.DeleteEmailForward(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DeleteEmailForward{}, result)
}

func TestClient_DeleteRegisteredNameServer(t *testing.T) {
	client := setupFakeAPI(t, "deleteRegisteredNameServer")

	params := &DeleteRegisteredNameServerParams{}

	result, err := client.DeleteRegisteredNameServer(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DeleteRegisteredNameServer{}, result)
}

func TestClient_DnsAddRecord(t *testing.T) {
	client := setupFakeAPI(t, "dnsAddRecord")

	params := &DnsAddRecordParams{}

	result, err := client.DnsAddRecord(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DnsAddRecord{}, result)
}

func TestClient_DnsDeleteRecord(t *testing.T) {
	client := setupFakeAPI(t, "dnsDeleteRecord")

	params := &DnsDeleteRecordParams{}

	result, err := client.DnsDeleteRecord(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DnsDeleteRecord{}, result)
}

func TestClient_DnsListRecords(t *testing.T) {
	client := setupFakeAPI(t, "dnsListRecords")

	params := &DnsListRecordsParams{}

	result, err := client.DnsListRecords(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DnsListRecords{}, result)
}

func TestClient_DnsSecAddRecord(t *testing.T) {
	client := setupFakeAPI(t, "dnsSecAddRecord")

	params := &DnsSecAddRecordParams{}

	result, err := client.DnsSecAddRecord(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DnsSecAddRecord{}, result)
}

func TestClient_DnsSecDeleteRecord(t *testing.T) {
	client := setupFakeAPI(t, "dnsSecDeleteRecord")

	params := &DnsSecDeleteRecordParams{}

	result, err := client.DnsSecDeleteRecord(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DnsSecDeleteRecord{}, result)
}

func TestClient_DnsSecListRecords(t *testing.T) {
	client := setupFakeAPI(t, "dnsSecListRecords")

	params := &DnsSecListRecordsParams{}

	result, err := client.DnsSecListRecords(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DnsSecListRecords{}, result)
}

func TestClient_DnsUpdateRecord(t *testing.T) {
	client := setupFakeAPI(t, "dnsUpdateRecord")

	params := &DnsUpdateRecordParams{}

	result, err := client.DnsUpdateRecord(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DnsUpdateRecord{}, result)
}

func TestClient_DomainForward(t *testing.T) {
	client := setupFakeAPI(t, "domainForward")

	params := &DomainForwardParams{}

	result, err := client.DomainForward(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DomainForward{}, result)
}

func TestClient_DomainForwardSubDomain(t *testing.T) {
	client := setupFakeAPI(t, "domainForwardSubDomain")

	params := &DomainForwardSubDomainParams{}

	result, err := client.DomainForwardSubDomain(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DomainForwardSubDomain{}, result)
}

func TestClient_DomainForwardSubDomainDelete(t *testing.T) {
	client := setupFakeAPI(t, "domainForwardSubDomainDelete")

	params := &DomainForwardSubDomainDeleteParams{}

	result, err := client.DomainForwardSubDomainDelete(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DomainForwardSubDomainDelete{}, result)
}

func TestClient_DomainLock(t *testing.T) {
	client := setupFakeAPI(t, "domainLock")

	params := &DomainLockParams{}

	result, err := client.DomainLock(context.TODO(), params)
	require.Error(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DomainLock{}, result)
}

func TestClient_DomainPush(t *testing.T) {
	client := setupFakeAPI(t, "domainPush")

	params := &DomainPushParams{}

	result, err := client.DomainPush(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DomainPush{}, result)
}

func TestClient_DomainUnlock(t *testing.T) {
	client := setupFakeAPI(t, "domainUnlock")

	params := &DomainUnlockParams{}

	result, err := client.DomainUnlock(context.TODO(), params)
	require.Error(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &DomainUnlock{}, result)
}

func TestClient_EmailVerification(t *testing.T) {
	client := setupFakeAPI(t, "emailVerification")

	params := &EmailVerificationParams{}

	result, err := client.EmailVerification(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &EmailVerification{}, result)
}

func TestClient_GetAccountBalance(t *testing.T) {
	client := setupFakeAPI(t, "getAccountBalance")

	params := &GetAccountBalanceParams{}

	result, err := client.GetAccountBalance(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &GetAccountBalance{}, result)
}

func TestClient_GetDomainInfo(t *testing.T) {
	client := setupFakeAPI(t, "getDomainInfo")

	params := &GetDomainInfoParams{}

	result, err := client.GetDomainInfo(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &GetDomainInfo{}, result)
}

func TestClient_GetPrices(t *testing.T) {
	client := setupFakeAPI(t, "getPrices")

	params := &GetPricesParams{}

	result, err := client.GetPrices(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &GetPrices{}, result)
}

func TestClient_ListAuctions(t *testing.T) {
	client := setupFakeAPI(t, "listAuctions")

	params := &ListAuctionsParams{}

	result, err := client.ListAuctions(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ListAuctions{}, result)
}

func TestClient_ListDomains(t *testing.T) {
	client := setupFakeAPI(t, "listDomains")

	params := &ListDomainsParams{}

	result, err := client.ListDomains(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ListDomains{}, result)
}

func TestClient_ListEmailForwards(t *testing.T) {
	client := setupFakeAPI(t, "listEmailForwards")

	params := &ListEmailForwardsParams{}

	result, err := client.ListEmailForwards(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ListEmailForwards{}, result)
}

func TestClient_ListExpiringDomains(t *testing.T) {
	client := setupFakeAPI(t, "listExpiringDomains")

	params := &ListExpiringDomainsParams{}

	result, err := client.ListExpiringDomains(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ListExpiringDomains{}, result)
}

func TestClient_ListOrders(t *testing.T) {
	client := setupFakeAPI(t, "listOrders")

	params := &ListOrdersParams{}

	result, err := client.ListOrders(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ListOrders{}, result)
}

func TestClient_ListRegisteredNameServers(t *testing.T) {
	client := setupFakeAPI(t, "listRegisteredNameServers")

	params := &ListRegisteredNameServersParams{}

	result, err := client.ListRegisteredNameServers(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ListRegisteredNameServers{}, result)
}

func TestClient_MarketplaceActiveSalesOverview(t *testing.T) {
	client := setupFakeAPI(t, "marketplaceActiveSalesOverview")

	params := &MarketplaceActiveSalesOverviewParams{}

	result, err := client.MarketplaceActiveSalesOverview(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &MarketplaceActiveSalesOverview{}, result)
}

func TestClient_MarketplaceAddOrModifySale(t *testing.T) {
	client := setupFakeAPI(t, "marketplaceAddOrModifySale")

	params := &MarketplaceAddOrModifySaleParams{}

	result, err := client.MarketplaceAddOrModifySale(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &MarketplaceAddOrModifySale{}, result)
}

func TestClient_MarketplaceLandingPageUpdate(t *testing.T) {
	client := setupFakeAPI(t, "marketplaceLandingPageUpdate")

	params := &MarketplaceLandingPageUpdateParams{}

	result, err := client.MarketplaceLandingPageUpdate(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &MarketplaceLandingPageUpdate{}, result)
}

func TestClient_ModifyRegisteredNameServer(t *testing.T) {
	client := setupFakeAPI(t, "modifyRegisteredNameServer")

	params := &ModifyRegisteredNameServerParams{}

	result, err := client.ModifyRegisteredNameServer(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ModifyRegisteredNameServer{}, result)
}

func TestClient_OrderDetails(t *testing.T) {
	client := setupFakeAPI(t, "orderDetails")

	params := &OrderDetailsParams{}

	result, err := client.OrderDetails(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &OrderDetails{}, result)
}

func TestClient_PortfolioAdd(t *testing.T) {
	client := setupFakeAPI(t, "portfolioAdd")

	params := &PortfolioAddParams{}

	result, err := client.PortfolioAdd(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &PortfolioAdd{}, result)
}

func TestClient_PortfolioDelete(t *testing.T) {
	client := setupFakeAPI(t, "portfolioDelete")

	params := &PortfolioDeleteParams{}

	result, err := client.PortfolioDelete(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &PortfolioDelete{}, result)
}

func TestClient_PortfolioDomainAssociate(t *testing.T) {
	client := setupFakeAPI(t, "portfolioDomainAssociate")

	params := &PortfolioDomainAssociateParams{}

	result, err := client.PortfolioDomainAssociate(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &PortfolioDomainAssociate{}, result)
}

func TestClient_PortfolioList(t *testing.T) {
	client := setupFakeAPI(t, "portfolioList")

	params := &PortfolioListParams{}

	result, err := client.PortfolioList(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &PortfolioList{}, result)
}

func TestClient_RegisterDomain(t *testing.T) {
	client := setupFakeAPI(t, "registerDomain")

	params := &RegisterDomainParams{}

	result, err := client.RegisterDomain(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &RegisterDomain{}, result)
}

func TestClient_RegisterDomainDrop(t *testing.T) {
	client := setupFakeAPI(t, "registerDomainDrop")

	params := &RegisterDomainDropParams{}

	result, err := client.RegisterDomainDrop(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &RegisterDomainDrop{}, result)
}

func TestClient_RegistrantVerificationStatus(t *testing.T) {
	client := setupFakeAPI(t, "registrantVerificationStatus")

	params := &RegistrantVerificationStatusParams{}

	result, err := client.RegistrantVerificationStatus(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &RegistrantVerificationStatus{}, result)
}

func TestClient_RemoveAutoRenewal(t *testing.T) {
	client := setupFakeAPI(t, "removeAutoRenewal")

	params := &RemoveAutoRenewalParams{}

	result, err := client.RemoveAutoRenewal(context.TODO(), params)
	require.Error(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &RemoveAutoRenewal{}, result)
}

func TestClient_RemovePrivacy(t *testing.T) {
	client := setupFakeAPI(t, "removePrivacy")

	params := &RemovePrivacyParams{}

	result, err := client.RemovePrivacy(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &RemovePrivacy{}, result)
}

func TestClient_RenewDomain(t *testing.T) {
	client := setupFakeAPI(t, "renewDomain")

	params := &RenewDomainParams{}

	result, err := client.RenewDomain(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &RenewDomain{}, result)
}

func TestClient_RetrieveAuthCode(t *testing.T) {
	client := setupFakeAPI(t, "retrieveAuthCode")

	params := &RetrieveAuthCodeParams{}

	result, err := client.RetrieveAuthCode(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &RetrieveAuthCode{}, result)
}

func TestClient_TransferDomain(t *testing.T) {
	client := setupFakeAPI(t, "transferDomain")

	params := &TransferDomainParams{}

	result, err := client.TransferDomain(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &TransferDomain{}, result)
}

func TestClient_TransferUpdateChangeEPPCode(t *testing.T) {
	client := setupFakeAPI(t, "transferUpdateChangeEPPCode")

	params := &TransferUpdateChangeEPPCodeParams{}

	result, err := client.TransferUpdateChangeEPPCode(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &TransferUpdateChangeEPPCode{}, result)
}

func TestClient_TransferUpdateResendAdminEmail(t *testing.T) {
	client := setupFakeAPI(t, "transferUpdateResendAdminEmail")

	params := &TransferUpdateResendAdminEmailParams{}

	result, err := client.TransferUpdateResendAdminEmail(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &TransferUpdateResendAdminEmail{}, result)
}

func TestClient_TransferUpdateResubmitToRegistry(t *testing.T) {
	client := setupFakeAPI(t, "transferUpdateResubmitToRegistry")

	params := &TransferUpdateResubmitToRegistryParams{}

	result, err := client.TransferUpdateResubmitToRegistry(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &TransferUpdateResubmitToRegistry{}, result)
}

func TestClient_ViewAuction(t *testing.T) {
	client := setupFakeAPI(t, "viewAuction")

	params := &ViewAuctionParams{}

	result, err := client.ViewAuction(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ViewAuction{}, result)
}

func TestClient_ViewAuctionHistory(t *testing.T) {
	client := setupFakeAPI(t, "viewAuctionHistory")

	params := &ViewAuctionHistoryParams{}

	result, err := client.ViewAuctionHistory(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ViewAuctionHistory{}, result)
}

func TestClient_ViewAuctions(t *testing.T) {
	client := setupFakeAPI(t, "viewAuctions")

	params := &ViewAuctionsParams{}

	result, err := client.ViewAuctions(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &ViewAuctions{}, result)
}

func TestClient_WatchAuction(t *testing.T) {
	client := setupFakeAPI(t, "watchAuction")

	params := &WatchAuctionParams{}

	result, err := client.WatchAuction(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &WatchAuction{}, result)
}

func TestClient_WhoisInfo(t *testing.T) {
	client := setupFakeAPI(t, "whoisInfo")

	params := &WhoisInfoParams{}

	result, err := client.WhoisInfo(context.TODO(), params)
	require.NoError(t, err)

	require.NotNil(t, result)

	assert.IsType(t, &WhoisInfo{}, result)
}
