// Code generated by gen/gen_test.go DO NOT EDIT.

package namesilo

import (
	"encoding/xml"
	"os"
	"path/filepath"
	"regexp"
	"strings"
	"testing"

	"github.com/stretchr/testify/require"
)

func assertXMLEqual(t *testing.T, model any, fixture string) {
	t.Helper()

	expected, err := os.ReadFile(filepath.FromSlash(fixture))
	require.NoError(t, err)

	err = xml.Unmarshal(expected, model)
	require.NoError(t, err)

	raw, err := xml.MarshalIndent(model, "", "    ")
	require.NoError(t, err)

	// Fix self-closing tags.
	exp, err := regexp.Compile("<(\\w+)></\\w+>")
	require.NoError(t, err)

	raw = exp.ReplaceAll(raw, []byte("<$1/>"))

	if toCleanString(raw) != toCleanString(expected) {
		t.Logf("Got:\n%s\n\nWant:\n%s\n", string(raw), string(expected))
		t.Error("Errors")
	}
}

func toCleanString(data []byte) string {
	return strings.TrimSuffix(strings.ReplaceAll(string(data), "\r\n", "\n"), "\n")
}

func TestAddAccountFunds(t *testing.T) {
	assertXMLEqual(t, &AddAccountFunds{}, "./fixtures/operations/addAccountFunds.xml")
}

func TestAddAutoRenewal(t *testing.T) {
	assertXMLEqual(t, &AddAutoRenewal{}, "./fixtures/operations/addAutoRenewal.xml")
}

func TestAddPrivacy(t *testing.T) {
	assertXMLEqual(t, &AddPrivacy{}, "./fixtures/operations/addPrivacy.xml")
}

func TestAddRegisteredNameServer(t *testing.T) {
	assertXMLEqual(t, &AddRegisteredNameServer{}, "./fixtures/operations/addRegisteredNameServer.xml")
}

func TestBidAuction(t *testing.T) {
	assertXMLEqual(t, &BidAuction{}, "./fixtures/operations/bidAuction.xml")
}

func TestBuyNowAuction(t *testing.T) {
	assertXMLEqual(t, &BuyNowAuction{}, "./fixtures/operations/buyNowAuction.xml")
}

func TestChangeNameServers(t *testing.T) {
	assertXMLEqual(t, &ChangeNameServers{}, "./fixtures/operations/changeNameServers.xml")
}

func TestCheckRegisterAvailability(t *testing.T) {
	assertXMLEqual(t, &CheckRegisterAvailability{}, "./fixtures/operations/checkRegisterAvailability.xml")
}

func TestCheckTransferAvailability(t *testing.T) {
	assertXMLEqual(t, &CheckTransferAvailability{}, "./fixtures/operations/checkTransferAvailability.xml")
}

func TestCheckTransferStatus(t *testing.T) {
	assertXMLEqual(t, &CheckTransferStatus{}, "./fixtures/operations/checkTransferStatus.xml")
}

func TestConfigureEmailForward(t *testing.T) {
	assertXMLEqual(t, &ConfigureEmailForward{}, "./fixtures/operations/configureEmailForward.xml")
}

func TestContactAdd(t *testing.T) {
	assertXMLEqual(t, &ContactAdd{}, "./fixtures/operations/contactAdd.xml")
}

func TestContactDelete(t *testing.T) {
	assertXMLEqual(t, &ContactDelete{}, "./fixtures/operations/contactDelete.xml")
}

func TestContactDomainAssociate(t *testing.T) {
	assertXMLEqual(t, &ContactDomainAssociate{}, "./fixtures/operations/contactDomainAssociate.xml")
}

func TestContactList(t *testing.T) {
	assertXMLEqual(t, &ContactList{}, "./fixtures/operations/contactList.xml")
}

func TestContactUpdate(t *testing.T) {
	assertXMLEqual(t, &ContactUpdate{}, "./fixtures/operations/contactUpdate.xml")
}

func TestCountExpiringDomains(t *testing.T) {
	assertXMLEqual(t, &CountExpiringDomains{}, "./fixtures/operations/countExpiringDomains.xml")
}

func TestDeleteEmailForward(t *testing.T) {
	assertXMLEqual(t, &DeleteEmailForward{}, "./fixtures/operations/deleteEmailForward.xml")
}

func TestDeleteRegisteredNameServer(t *testing.T) {
	assertXMLEqual(t, &DeleteRegisteredNameServer{}, "./fixtures/operations/deleteRegisteredNameServer.xml")
}

func TestDnsAddRecord(t *testing.T) {
	assertXMLEqual(t, &DnsAddRecord{}, "./fixtures/operations/dnsAddRecord.xml")
}

func TestDnsDeleteRecord(t *testing.T) {
	assertXMLEqual(t, &DnsDeleteRecord{}, "./fixtures/operations/dnsDeleteRecord.xml")
}

func TestDnsListRecords(t *testing.T) {
	assertXMLEqual(t, &DnsListRecords{}, "./fixtures/operations/dnsListRecords.xml")
}

func TestDnsSecAddRecord(t *testing.T) {
	assertXMLEqual(t, &DnsSecAddRecord{}, "./fixtures/operations/dnsSecAddRecord.xml")
}

func TestDnsSecDeleteRecord(t *testing.T) {
	assertXMLEqual(t, &DnsSecDeleteRecord{}, "./fixtures/operations/dnsSecDeleteRecord.xml")
}

func TestDnsSecListRecords(t *testing.T) {
	assertXMLEqual(t, &DnsSecListRecords{}, "./fixtures/operations/dnsSecListRecords.xml")
}

func TestDnsUpdateRecord(t *testing.T) {
	assertXMLEqual(t, &DnsUpdateRecord{}, "./fixtures/operations/dnsUpdateRecord.xml")
}

func TestDomainForward(t *testing.T) {
	assertXMLEqual(t, &DomainForward{}, "./fixtures/operations/domainForward.xml")
}

func TestDomainForwardSubDomain(t *testing.T) {
	assertXMLEqual(t, &DomainForwardSubDomain{}, "./fixtures/operations/domainForwardSubDomain.xml")
}

func TestDomainForwardSubDomainDelete(t *testing.T) {
	assertXMLEqual(t, &DomainForwardSubDomainDelete{}, "./fixtures/operations/domainForwardSubDomainDelete.xml")
}

func TestDomainLock(t *testing.T) {
	assertXMLEqual(t, &DomainLock{}, "./fixtures/operations/domainLock.xml")
}

func TestDomainPush(t *testing.T) {
	assertXMLEqual(t, &DomainPush{}, "./fixtures/operations/domainPush.xml")
}

func TestDomainUnlock(t *testing.T) {
	assertXMLEqual(t, &DomainUnlock{}, "./fixtures/operations/domainUnlock.xml")
}

func TestEmailVerification(t *testing.T) {
	assertXMLEqual(t, &EmailVerification{}, "./fixtures/operations/emailVerification.xml")
}

func TestGetAccountBalance(t *testing.T) {
	assertXMLEqual(t, &GetAccountBalance{}, "./fixtures/operations/getAccountBalance.xml")
}

func TestGetDomainInfo(t *testing.T) {
	assertXMLEqual(t, &GetDomainInfo{}, "./fixtures/operations/getDomainInfo.xml")
}

func TestGetPrices(t *testing.T) {
	assertXMLEqual(t, &GetPrices{}, "./fixtures/operations/getPrices.xml")
}

func TestListAuctions(t *testing.T) {
	assertXMLEqual(t, &ListAuctions{}, "./fixtures/operations/listAuctions.xml")
}

func TestListDomains(t *testing.T) {
	assertXMLEqual(t, &ListDomains{}, "./fixtures/operations/listDomains.xml")
}

func TestListEmailForwards(t *testing.T) {
	assertXMLEqual(t, &ListEmailForwards{}, "./fixtures/operations/listEmailForwards.xml")
}

func TestListExpiringDomains(t *testing.T) {
	assertXMLEqual(t, &ListExpiringDomains{}, "./fixtures/operations/listExpiringDomains.xml")
}

func TestListOrders(t *testing.T) {
	assertXMLEqual(t, &ListOrders{}, "./fixtures/operations/listOrders.xml")
}

func TestListRegisteredNameServers(t *testing.T) {
	assertXMLEqual(t, &ListRegisteredNameServers{}, "./fixtures/operations/listRegisteredNameServers.xml")
}

func TestMarketplaceActiveSalesOverview(t *testing.T) {
	assertXMLEqual(t, &MarketplaceActiveSalesOverview{}, "./fixtures/operations/marketplaceActiveSalesOverview.xml")
}

func TestMarketplaceAddOrModifySale(t *testing.T) {
	assertXMLEqual(t, &MarketplaceAddOrModifySale{}, "./fixtures/operations/marketplaceAddOrModifySale.xml")
}

func TestMarketplaceLandingPageUpdate(t *testing.T) {
	assertXMLEqual(t, &MarketplaceLandingPageUpdate{}, "./fixtures/operations/marketplaceLandingPageUpdate.xml")
}

func TestModifyRegisteredNameServer(t *testing.T) {
	assertXMLEqual(t, &ModifyRegisteredNameServer{}, "./fixtures/operations/modifyRegisteredNameServer.xml")
}

func TestOrderDetails(t *testing.T) {
	assertXMLEqual(t, &OrderDetails{}, "./fixtures/operations/orderDetails.xml")
}

func TestPortfolioAdd(t *testing.T) {
	assertXMLEqual(t, &PortfolioAdd{}, "./fixtures/operations/portfolioAdd.xml")
}

func TestPortfolioDelete(t *testing.T) {
	assertXMLEqual(t, &PortfolioDelete{}, "./fixtures/operations/portfolioDelete.xml")
}

func TestPortfolioDomainAssociate(t *testing.T) {
	assertXMLEqual(t, &PortfolioDomainAssociate{}, "./fixtures/operations/portfolioDomainAssociate.xml")
}

func TestPortfolioList(t *testing.T) {
	assertXMLEqual(t, &PortfolioList{}, "./fixtures/operations/portfolioList.xml")
}

func TestRegisterDomain(t *testing.T) {
	assertXMLEqual(t, &RegisterDomain{}, "./fixtures/operations/registerDomain.xml")
}

func TestRegisterDomainDrop(t *testing.T) {
	assertXMLEqual(t, &RegisterDomainDrop{}, "./fixtures/operations/registerDomainDrop.xml")
}

func TestRegistrantVerificationStatus(t *testing.T) {
	assertXMLEqual(t, &RegistrantVerificationStatus{}, "./fixtures/operations/registrantVerificationStatus.xml")
}

func TestRemoveAutoRenewal(t *testing.T) {
	assertXMLEqual(t, &RemoveAutoRenewal{}, "./fixtures/operations/removeAutoRenewal.xml")
}

func TestRemovePrivacy(t *testing.T) {
	assertXMLEqual(t, &RemovePrivacy{}, "./fixtures/operations/removePrivacy.xml")
}

func TestRenewDomain(t *testing.T) {
	assertXMLEqual(t, &RenewDomain{}, "./fixtures/operations/renewDomain.xml")
}

func TestRetrieveAuthCode(t *testing.T) {
	assertXMLEqual(t, &RetrieveAuthCode{}, "./fixtures/operations/retrieveAuthCode.xml")
}

func TestTransferDomain(t *testing.T) {
	assertXMLEqual(t, &TransferDomain{}, "./fixtures/operations/transferDomain.xml")
}

func TestTransferUpdateChangeEPPCode(t *testing.T) {
	assertXMLEqual(t, &TransferUpdateChangeEPPCode{}, "./fixtures/operations/transferUpdateChangeEPPCode.xml")
}

func TestTransferUpdateResendAdminEmail(t *testing.T) {
	assertXMLEqual(t, &TransferUpdateResendAdminEmail{}, "./fixtures/operations/transferUpdateResendAdminEmail.xml")
}

func TestTransferUpdateResubmitToRegistry(t *testing.T) {
	assertXMLEqual(t, &TransferUpdateResubmitToRegistry{}, "./fixtures/operations/transferUpdateResubmitToRegistry.xml")
}

func TestViewAuction(t *testing.T) {
	assertXMLEqual(t, &ViewAuction{}, "./fixtures/operations/viewAuction.xml")
}

func TestViewAuctionHistory(t *testing.T) {
	assertXMLEqual(t, &ViewAuctionHistory{}, "./fixtures/operations/viewAuctionHistory.xml")
}

func TestViewAuctions(t *testing.T) {
	assertXMLEqual(t, &ViewAuctions{}, "./fixtures/operations/viewAuctions.xml")
}

func TestWatchAuction(t *testing.T) {
	assertXMLEqual(t, &WatchAuction{}, "./fixtures/operations/watchAuction.xml")
}

func TestWhoisInfo(t *testing.T) {
	assertXMLEqual(t, &WhoisInfo{}, "./fixtures/operations/whoisInfo.xml")
}
