/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class AnnotationExprent
extends Exprent {
    private final String className;
    private final List<String> parNames;
    private final List<? extends Exprent> parValues;
    private boolean didWriteAlready;

    public AnnotationExprent(String className, List<String> parNames, List<? extends Exprent> parValues) {
        super(Exprent.Type.ANNOTATION);
        this.className = className;
        this.parNames = parNames;
        this.parValues = parValues;
    }

    @Override
    protected List<Exprent> getAllExprents(List<Exprent> list) {
        list.addAll(this.parValues);
        return list;
    }

    @Override
    public Exprent copy() {
        ArrayList<Exprent> exps = new ArrayList<Exprent>();
        for (Exprent exprent : this.parValues) {
            exps.add(exprent.copy());
        }
        return new AnnotationExprent(this.className, this.parNames, exps);
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buffer = new TextBuffer();
        buffer.append('@');
        buffer.appendAllClasses(DecompilerContext.getImportCollector().getShortName(ExprProcessor.buildJavaClassName(this.className)), this.className);
        Type type = this.getAnnotationType();
        if (type != Type.MARKER) {
            buffer.append('(');
            buffer.pushNewlineGroup(indent, 1);
            buffer.appendPossibleNewline();
            for (int i = 0; i < this.parNames.size(); ++i) {
                Exprent parValue;
                if (type != Type.SINGLE_ELEMENT) {
                    String name = this.parNames.get(i);
                    StructClass structClass = DecompilerContext.getStructContext().getClass(this.className);
                    if (structClass != null) {
                        Optional<StructMethod> method = structClass.getMethods().stream().filter(m -> m.getName().equals(name)).findAny();
                        if (method.isPresent()) {
                            buffer.appendMethod(name, false, this.className, name, method.get().getDescriptor());
                        } else {
                            buffer.appendMethod(name, false, this.className, name, "()" + String.valueOf(this.parValues.get(i).getExprType()));
                        }
                    } else {
                        buffer.appendMethod(name, false, this.className, name, "()" + String.valueOf(this.parValues.get(i).getExprType()));
                    }
                    buffer.append(" = ");
                }
                if (AnnotationExprent.isArrayValue(parValue = this.parValues.get(i)) && ((NewExprent)parValue).getLstArrayElements().size() == 1 && !AnnotationExprent.isArrayValue(((NewExprent)parValue).getLstArrayElements().get(0))) {
                    buffer.append(((NewExprent)parValue).getLstArrayElements().get(0).toJava(indent));
                } else {
                    buffer.append(parValue.toJava(indent));
                }
                if (i < this.parNames.size() - 1) {
                    buffer.append(",");
                    buffer.appendPossibleNewline(" ");
                    continue;
                }
                buffer.appendPossibleNewline("", true);
            }
            buffer.append(')');
            buffer.popNewlineGroup();
        }
        return buffer;
    }

    private static boolean isArrayValue(Exprent parValue) {
        NewExprent newExpr;
        return parValue instanceof NewExprent && (newExpr = (NewExprent)parValue).isDirectArrayInit();
    }

    public String getClassName() {
        return this.className;
    }

    public Type getAnnotationType() {
        if (this.parNames.isEmpty()) {
            return Type.MARKER;
        }
        if (this.parNames.size() == 1 && "value".equals(this.parNames.get(0))) {
            return Type.SINGLE_ELEMENT;
        }
        return Type.NORMAL;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotationExprent)) {
            return false;
        }
        AnnotationExprent ann = (AnnotationExprent)o;
        return this.className.equals(ann.className) && InterpreterUtil.equalLists(this.parNames, ann.parNames) && InterpreterUtil.equalLists(this.parValues, ann.parValues);
    }

    public List<String> getParNames() {
        return this.parNames;
    }

    public List<? extends Exprent> getParValues() {
        return this.parValues;
    }

    public boolean didWriteAlready() {
        return this.didWriteAlready;
    }

    public void setDidWriteAlready(boolean didWriteAlready) {
        this.didWriteAlready = didWriteAlready;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        AnnotationExprent.measureBytecode(values, this.parValues);
        this.measureBytecode(values);
    }

    public static enum Type {
        NORMAL,
        MARKER,
        SINGLE_ELEMENT;

    }
}

