/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.code.BytecodeVersion;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.StructRecordComponent;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGenericSignatureAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructRecordAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.collections.VBStyleCollection;

public class StructClass
extends StructMember {
    public final String qualifiedName;
    public final PrimitiveConstant superClass;
    private final boolean own;
    private final BytecodeVersion version;
    private final int[] interfaces;
    private final String[] interfaceNames;
    private final VBStyleCollection<StructField, String> fields;
    private final VBStyleCollection<StructMethod, String> methods;
    private final GenericClassDescriptor signature;
    private ConstantPool pool;
    private Map<String, Map<VarType, VarType>> genericHiarachy;
    private List<StructClass> superClasses;

    public static StructClass create(DataInputFullStream in, boolean own) throws IOException {
        StructGenericSignatureAttribute signatureAttr;
        in.discard(4);
        int minorVersion = in.readUnsignedShort();
        int majorVersion = in.readUnsignedShort();
        BytecodeVersion bytecodeVersion = new BytecodeVersion(majorVersion, minorVersion);
        ConstantPool pool = new ConstantPool(in);
        int accessFlags = in.readUnsignedShort();
        int thisClassIdx = in.readUnsignedShort();
        int superClassIdx = in.readUnsignedShort();
        String qualifiedName = pool.getPrimitiveConstant(thisClassIdx).getString();
        PrimitiveConstant superClass = pool.getPrimitiveConstant(superClassIdx);
        int length = in.readUnsignedShort();
        int[] interfaces = new int[length];
        String[] interfaceNames = new String[length];
        for (int i = 0; i < length; ++i) {
            interfaces[i] = in.readUnsignedShort();
            interfaceNames[i] = pool.getPrimitiveConstant(interfaces[i]).getString();
        }
        length = in.readUnsignedShort();
        VBStyleCollection<StructField, String> fields = new VBStyleCollection<StructField, String>(length);
        for (int i = 0; i < length; ++i) {
            StructField field = StructField.create(in, pool, qualifiedName, bytecodeVersion);
            fields.addWithKey(field, InterpreterUtil.makeUniqueKey(field.getName(), field.getDescriptor()));
        }
        length = in.readUnsignedShort();
        VBStyleCollection<StructMethod, String> methods = new VBStyleCollection<StructMethod, String>(length);
        for (int i = 0; i < length; ++i) {
            StructMethod method = StructMethod.create(in, pool, qualifiedName, bytecodeVersion, own);
            String key = InterpreterUtil.makeUniqueKey(method.getName(), method.getDescriptor());
            if (methods.containsKey(key)) {
                String fullName = qualifiedName + "." + method.getName() + method.getDescriptor();
                DecompilerContext.getLogger().writeMessage("Duplicate method " + fullName, IFernflowerLogger.Severity.WARN);
            }
            methods.addWithKey(method, key);
        }
        Map<String, StructGeneralAttribute> attributes = StructClass.readAttributes(in, pool, bytecodeVersion);
        GenericClassDescriptor signature = null;
        if (DecompilerContext.getOption("decompile-generics") && (signatureAttr = (StructGenericSignatureAttribute)attributes.get(StructGeneralAttribute.ATTRIBUTE_SIGNATURE.name)) != null) {
            signature = GenericMain.parseClassSignature(qualifiedName, signatureAttr.getSignature());
        }
        StructClass cl = new StructClass(accessFlags, attributes, qualifiedName, superClass, own, minorVersion, majorVersion, interfaces, interfaceNames, fields, methods, signature);
        cl.pool = pool;
        return cl;
    }

    private StructClass(int accessFlags, Map<String, StructGeneralAttribute> attributes, String qualifiedName, PrimitiveConstant superClass, boolean own, int minorVersion, int majorVersion, int[] interfaces, String[] interfaceNames, VBStyleCollection<StructField, String> fields, VBStyleCollection<StructMethod, String> methods, GenericClassDescriptor signature) {
        super(accessFlags, attributes);
        this.qualifiedName = qualifiedName;
        this.superClass = superClass;
        this.own = own;
        this.version = new BytecodeVersion(majorVersion, minorVersion);
        this.interfaces = interfaces;
        this.interfaceNames = interfaceNames;
        this.fields = fields;
        this.methods = methods;
        this.signature = signature;
    }

    @Override
    public BytecodeVersion getVersion() {
        return this.version;
    }

    public boolean hasField(String name, String descriptor) {
        return this.getField(name, descriptor) != null;
    }

    public StructField getField(String name, String descriptor) {
        return this.fields.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public StructMethod getMethod(String key) {
        return this.methods.getWithKey(key);
    }

    public StructMethod getMethod(String name, String descriptor) {
        return this.methods.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public StructMethod getMethodRecursive(String name, String descriptor) {
        StructClass cls;
        StructMethod ret = this.getMethod(name, descriptor);
        if (ret != null) {
            return ret;
        }
        if (this.superClass != null && (cls = DecompilerContext.getStructContext().getClass((String)this.superClass.value)) != null && (ret = cls.getMethodRecursive(name, descriptor)) != null) {
            return ret;
        }
        for (String intf : this.getInterfaceNames()) {
            StructClass cls2 = DecompilerContext.getStructContext().getClass(intf);
            if (cls2 == null || (ret = cls2.getMethodRecursive(name, descriptor)) == null) continue;
            return ret;
        }
        return null;
    }

    public String getInterface(int i) {
        return this.interfaceNames[i];
    }

    public void releaseResources() {
    }

    public ConstantPool getPool() {
        return this.pool;
    }

    @Nullable
    public List<StructRecordComponent> getRecordComponents() {
        StructRecordAttribute recordAttr = this.getAttribute(StructGeneralAttribute.ATTRIBUTE_RECORD);
        if (recordAttr == null) {
            if (this.superClass != null && this.superClass.getString().equals("java/lang/Record")) {
                return new ArrayList<StructRecordComponent>();
            }
            return null;
        }
        return recordAttr.getComponents();
    }

    public int[] getInterfaces() {
        return this.interfaces;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public VBStyleCollection<StructMethod, String> getMethods() {
        return this.methods;
    }

    public VBStyleCollection<StructField, String> getFields() {
        return this.fields;
    }

    public boolean isOwn() {
        return this.own;
    }

    public String toString() {
        return this.qualifiedName;
    }

    public GenericClassDescriptor getSignature() {
        return this.signature;
    }

    private Map<VarType, VarType> getGenericMap(VarType type) {
        if (this.signature == null || type == null || !type.isGeneric()) {
            return Collections.emptyMap();
        }
        GenericType gtype = (GenericType)type;
        if (gtype.getArguments().size() != this.signature.fparameters.size()) {
            return Collections.emptyMap();
        }
        HashMap<VarType, VarType> ret = new HashMap<VarType, VarType>();
        for (int x = 0; x < this.signature.fparameters.size(); ++x) {
            VarType var = gtype.getArguments().get(x);
            if (var == null) continue;
            ret.put(GenericType.parse("T" + this.signature.fparameters.get(x) + ";"), var);
        }
        return ret;
    }

    public Map<String, Map<VarType, VarType>> getAllGenerics() {
        StructClass cls;
        if (this.genericHiarachy != null) {
            return this.genericHiarachy;
        }
        HashMap<String, Map<Object, Object>> ret = new HashMap<String, Map<Object, Object>>();
        if (this.signature != null && !this.signature.fparameters.isEmpty()) {
            HashMap<VarType, VarType> mine = new HashMap<VarType, VarType>();
            for (String par : this.signature.fparameters) {
                VarType type = GenericType.parse("T" + par + ";");
                mine.put(type, type);
            }
            ret.put(this.qualifiedName, mine);
        }
        HashSet<String> visited = new HashSet<String>();
        if (this.signature != null) {
            for (VarType intf : this.signature.superinterfaces) {
                visited.add(intf.value);
                StructClass cls2 = DecompilerContext.getStructContext().getClass(intf.value);
                if (cls2 == null) continue;
                Map<VarType, VarType> sig = cls2.getGenericMap(intf);
                for (Map.Entry<String, Map<VarType, VarType>> e : cls2.getAllGenerics().entrySet()) {
                    if (e.getValue().isEmpty()) {
                        ret.put(e.getKey(), e.getValue());
                        continue;
                    }
                    HashMap<VarType, VarType> sub = new HashMap<VarType, VarType>();
                    for (Map.Entry<VarType, VarType> e2 : e.getValue().entrySet()) {
                        sub.put(e2.getKey(), sig.getOrDefault(e2.getValue(), e2.getValue()));
                    }
                    ret.put(e.getKey(), sub);
                }
            }
        }
        for (String intf : this.interfaceNames) {
            StructClass cls3;
            if (visited.contains(intf) || (cls3 = DecompilerContext.getStructContext().getClass(intf)) == null) continue;
            ret.putAll(cls3.getAllGenerics());
        }
        if (this.superClass != null && (cls = DecompilerContext.getStructContext().getClass((String)this.superClass.value)) != null) {
            Map sig;
            Map<Object, VarType> map = sig = this.signature == null ? Collections.emptyMap() : cls.getGenericMap(this.signature.superclass);
            if (sig.isEmpty()) {
                ret.putAll(cls.getAllGenerics());
            } else {
                for (Map.Entry<String, Map<VarType, VarType>> e : cls.getAllGenerics().entrySet()) {
                    if (e.getValue().isEmpty()) {
                        ret.put(e.getKey(), e.getValue());
                        continue;
                    }
                    HashMap<VarType, VarType> sub = new HashMap<VarType, VarType>();
                    for (Map.Entry<VarType, VarType> e2 : e.getValue().entrySet()) {
                        sub.put(e2.getKey(), sig.getOrDefault(e2.getValue(), e2.getValue()));
                    }
                    ret.put(e.getKey(), sub);
                }
            }
        }
        this.genericHiarachy = ret.isEmpty() ? Collections.emptyMap() : ret;
        return this.genericHiarachy;
    }

    public List<StructClass> getAllSuperClasses() {
        if (this.superClasses != null) {
            return this.superClasses;
        }
        ArrayList<StructClass> classList = new ArrayList<StructClass>();
        StructContext context = DecompilerContext.getStructContext();
        if (this.superClass != null) {
            StructClass cl = context.getClass(this.superClass.getString());
            while (cl != null) {
                classList.add(cl);
                if (cl.superClass == null) break;
                cl = context.getClass(cl.superClass.getString());
            }
        }
        this.superClasses = classList;
        return this.superClasses;
    }
}

