/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.util.function.Consumer;

public final class Either<L, R> {
    private final L left;
    private final R right;

    private Either(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public static <L, R> Either<L, R> left(L left) {
        return new Either<L, Object>(left, null);
    }

    public static <L, R> Either<L, R> right(R right) {
        return new Either<Object, R>(null, right);
    }

    public void map(Consumer<L> ifLeft, Consumer<R> ifRight) {
        this.checkInvariants();
        if (this.left != null) {
            ifLeft.accept(this.left);
        }
        if (this.right != null) {
            ifRight.accept(this.right);
        }
    }

    private void checkInvariants() {
        if (this.left == null && this.right == null) {
            throw new IllegalStateException("Either is empty!");
        }
        if (this.left != null && this.right != null) {
            throw new IllegalStateException("Either is full!");
        }
    }
}

