// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storage/armstorage"
	"net/http"
	"net/url"
	"regexp"
)

// QueueServicesServer is a fake server for instances of the armstorage.QueueServicesClient type.
type QueueServicesServer struct {
	// GetServiceProperties is the fake for method QueueServicesClient.GetServiceProperties
	// HTTP status codes to indicate success: http.StatusOK
	GetServiceProperties func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.QueueServicesClientGetServicePropertiesOptions) (resp azfake.Responder[armstorage.QueueServicesClientGetServicePropertiesResponse], errResp azfake.ErrorResponder)

	// List is the fake for method QueueServicesClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.QueueServicesClientListOptions) (resp azfake.Responder[armstorage.QueueServicesClientListResponse], errResp azfake.ErrorResponder)

	// SetServiceProperties is the fake for method QueueServicesClient.SetServiceProperties
	// HTTP status codes to indicate success: http.StatusOK
	SetServiceProperties func(ctx context.Context, resourceGroupName string, accountName string, parameters armstorage.QueueServiceProperties, options *armstorage.QueueServicesClientSetServicePropertiesOptions) (resp azfake.Responder[armstorage.QueueServicesClientSetServicePropertiesResponse], errResp azfake.ErrorResponder)
}

// NewQueueServicesServerTransport creates a new instance of QueueServicesServerTransport with the provided implementation.
// The returned QueueServicesServerTransport instance is connected to an instance of armstorage.QueueServicesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewQueueServicesServerTransport(srv *QueueServicesServer) *QueueServicesServerTransport {
	return &QueueServicesServerTransport{srv: srv}
}

// QueueServicesServerTransport connects instances of armstorage.QueueServicesClient to instances of QueueServicesServer.
// Don't use this type directly, use NewQueueServicesServerTransport instead.
type QueueServicesServerTransport struct {
	srv *QueueServicesServer
}

// Do implements the policy.Transporter interface for QueueServicesServerTransport.
func (q *QueueServicesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	return q.dispatchToMethodFake(req, method)
}

func (q *QueueServicesServerTransport) dispatchToMethodFake(req *http.Request, method string) (*http.Response, error) {
	resultChan := make(chan result)
	defer close(resultChan)

	go func() {
		var intercepted bool
		var res result
		if queueServicesServerTransportInterceptor != nil {
			res.resp, res.err, intercepted = queueServicesServerTransportInterceptor.Do(req)
		}
		if !intercepted {
			switch method {
			case "QueueServicesClient.GetServiceProperties":
				res.resp, res.err = q.dispatchGetServiceProperties(req)
			case "QueueServicesClient.List":
				res.resp, res.err = q.dispatchList(req)
			case "QueueServicesClient.SetServiceProperties":
				res.resp, res.err = q.dispatchSetServiceProperties(req)
			default:
				res.err = fmt.Errorf("unhandled API %s", method)
			}

		}
		select {
		case resultChan <- res:
		case <-req.Context().Done():
		}
	}()

	select {
	case <-req.Context().Done():
		return nil, req.Context().Err()
	case res := <-resultChan:
		return res.resp, res.err
	}
}

func (q *QueueServicesServerTransport) dispatchGetServiceProperties(req *http.Request) (*http.Response, error) {
	if q.srv.GetServiceProperties == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetServiceProperties not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queueServices/(?P<queueServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := q.srv.GetServiceProperties(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).QueueServiceProperties, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (q *QueueServicesServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if q.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queueServices`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := q.srv.List(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ListQueueServices, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (q *QueueServicesServerTransport) dispatchSetServiceProperties(req *http.Request) (*http.Response, error) {
	if q.srv.SetServiceProperties == nil {
		return nil, &nonRetriableError{errors.New("fake for method SetServiceProperties not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queueServices/(?P<queueServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorage.QueueServiceProperties](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := q.srv.SetServiceProperties(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).QueueServiceProperties, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// set this to conditionally intercept incoming requests to QueueServicesServerTransport
var queueServicesServerTransportInterceptor interface {
	// Do returns true if the server transport should use the returned response/error
	Do(*http.Request) (*http.Response, error, bool)
}
