Jaldi [Asap-Devanagari]
===============
**Omnibus-Type**  
*SIL Open Font License, 1.1*

Jaldi, the Devanagari typeface family designed as a complement of Asap.

![Sample of Jaldi](SRC/jaldi_poster.png "Jaldi")

# Jaldi family

Jaldi is a libre Devanagari typeface family designed as a complement to [Asap](https://www.google.com/url?q=https%3A%2F%2Fwww.google.com%2Ffonts%2Fspecimen%2FAsap)* (“As Soon As Possible”). Jaldi is a contemporary sans-serif non-modular Devanagari family with subtle rounded corners designed by Nicolás Silva and Pablo Cosgaya. It comes in two weights (Regular and Bold) and was specially developed for screen as a webfont and desktop font, too. It offers a standardised character width on all styles, which means that the lines of text remain the same length. This useful feature allows users to change type styles on-the-go without reflowing the text body. The Latin version of Jaldi was based on Ancha (designed by Pablo Cosgaya & Héctor Gatti) and was developed with the collaboration of the [Omnibus-Type](http://www.google.com/url?q=http%3A%2F%2Fomnibus-type.com%2F&sa=D&sntz=1&usg=AFQjCNEK1dbRyWJN56zeP8EaPCup9kDYQw) team.

\*Jaldi (जल्दी) is the Hindi word for ‘soon’.


####Jaldi Family contains:
* regular
* bold

To contribute to the project contact [Omnibus-Type](http://omnibus-type.com/).

### Designers

* Pablo Cosgaya
* Nicolas Silva

### License

Copyright (c) 2011-2015, Omnibus-Type (www.omnibus-type.com omnibus.type@gmail.com)

Licensed under the [*SIL Open Font License, 1.1*](http://scripts.sil.org/OFL); you may not use this file except in compliance with the License.

======
## FONTLOG for the Jaldi fonts

This file provides detailed information on the Jaldi font software.  
This information should be distributed along with the Jaldi fonts and any derivative works.

### Jaldi is a typeface family that supports Unicode language range: 

* Devanagari            U+0900-U+097F (128/128)
* Devanagari Extended   U+A8E0-U+A8FF (28/28)
* Vedic Extension       U+1CD0-U+1CFF (4/39)
* Basic Latin 				  U+0020-U+007E
* Latin-1 Supplement 		U+00A0-U+00FF
* Latin Extended-A 			U+0100-U+017F
* Latin Extended Additional	U+1E00-U+1EFF (111/256)

**Character map to support MS Codepages:**
* 1252 Latin-1
* 1250 Latin-2 (Easter Europe)
* 1254 Turkish
* 1257 Windows Baltic
* 1258 Vietnamese
* Mac Roman

*To contribute to the project contact Omnibus-Type at omnibus.type@gmail.com*

**11 May 2015 (Jaldi Release Candidate v.1.007) Omnibus-Type**
- Inserted `lookupflag IgnoreMarks;` in `cjct` connections_devanagari lookup in order to avoid deactivation of this feature when Nukta is present.

**21 April 2015 (Jaldi Release Candidate v.1.006) Omnibus-Type**
- Support of most of the consonants for half forms with a nukta, rakar forms, rakar forms with a nukta, half rakar forms, and half rakar forms with a nukta

**13 April 2015 (Jaldi Release Candidate v.1.005) Omnibus-Type**
- Changed semantic versioning to fit name tables records

**13 April 2015 (Jaldi v.1.004-beta.2) Omnibus-Type**
- Fixed nuktarakar procompound glyphs in TTF fonts
- Removed all name tables records with `platformID="1"`
- Updated TTFs with ttfautohint 1.3

**13 April 2015 (Jaldi v.1.004-beta.1) Omnibus-Type**
- Updated Family Aligment zones in TTF fonts
- Fixed vertical metrics and embox values
- fsType 0: Installable Mode

**6 April 2015 (Jaldi v.1.003) Omnibus-Type**
- Fixed linked anchors in nukta instances
- Inserted 'lookupflag IgnoreMarks' in pres
- Inserted rakar Anchor below halant

**25 February 2015 (Jaldi v.1.002) Omnibus-Type**
- Fixed issue with nukta next to halant
- Matched size of the Devanagari letters with Ek Mukta
- Improved conections between iMatras with reph and the stem of the last consonant in a cluster

**27 January 2015 (Jaldi v.1.001) Omnibus-Type**
- Removed Reserve Font Name from the license
- fsType Installable mode

**14 Jan 2015 (Jaldi v.1.001) Omnibus-Type**
- Several changes in the proportion of the letters (Thanks Vaishnavi).
- Enhance halfform conections with other consonants.
- Added halfforms variants for Ka, Pha and others.
- Scaled glyphs in order to stay insie 1k UPM

**14 Nov 2014 (Jaldi v.1.000) Omnibus-Type**
- First complete released of Jaldi (previously Asap Devanagari)

**11 Nov 2014 (Jaldi v.0.9) Omnibus-Type**
- Released beta version of Jaldi (previously Asap Devanagari)

**22 Sep 2014 (v.1.005) Omnibus-Type**
- Starting with the development of the Devanagari version

**1 Oct 2013 (v.1.005) Omnibus-Type**
- Expanded in order to support Adobe Latin 3 and vietnamite
- Updating hinting with ttfautohint (v0.97)
- Increased vertical metrics
- Improved CFF hint (AFDK 2.5.59)
- Improved TTF hint (TTFAutohint 0.95)
- Fixed TTF table names
- Updated and expanded features in OT Tables:
  - GSUB:
    * **aalt** Access All Alternatives
    * **ccmp** Glyph Composition/Decomposition
    * **locl** Localized Forms
    * **sups** SuperScript
    * **frac** Diagonal Fractions
    * **ordn** Ordinals
    * **liga** Standar Ligatures
    * **ss01** Style Set 1
    * **salt** Stylistic Alternatives
      * Single Substitution
      * Ligature Substitution
  - GPOS:
    * **mark** Mark Positioning
    * **mkmk** Mark to Mark
    * **cpsp** Capital Spacing

**19 Jan 2012 (v.1.001) Omnibus-Type**
- Initial release

### Acknowledgements

If you make modifications be sure to add your name (N), email (E), web-address
(if you have one) (W) and description (D). This list is in alphabetical order.

**N:** **Andres Torresi**  
**E:** omnibus.type@gmail.com  
**W:** http://www.omnibus-type.com  
**D:** Assistant designer of Asap family  

**N:** **Hector Gatti**  
**E:** omnibus.type@gmail.com  
**W:** http://www.omnibus-type.com  
**D:** Designer of Ancha upstream  

**N:** **Nicolas Silva**  
**E:** omnibus.type@gmail.com  
**W:** http://www.omnibus-type.com  
**D:** Typeface developer and designer of the Devanagari version

**N:** **Pablo Cosgaya**  
**E:** omnibus.type@gmail.com  
**W:** http://www.omnibus-type.com  
**D:** Original designer of Asap and designer of the Devanagari version
