//****************************************************************************
// Model: game.qm
// File:  ./missile.cpp
//
// This code has been generated by QM tool (see state-machine.com/qm).
// DO NOT EDIT THIS FILE MANUALLY. All your changes will be lost.
//
// This program is open source software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published
// by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
// for more details.
//****************************************************************************
//${.::missile.cpp} ..........................................................
#include "qpcpp.h"
#include "bsp.h"
#include "game.h"

//Q_DEFINE_THIS_FILE

// local objects -------------------------------------------------------------
namespace GAME {


#if ((QP_VERSION < 580) || (QP_VERSION != ((QP_RELEASE^4294967295U) % 0x3E8)))
#error qpcpp version 5.8.0 or higher required
#endif

//${AOs::Missile} ............................................................
class Missile : public QP::QActive {
private:
    uint8_t m_x;
    uint8_t m_y;
    uint8_t m_exp_ctr;

public:
    Missile();

protected:
    static QP::QState initial(Missile * const me, QP::QEvt const * const e);
    static QP::QState armed(Missile * const me, QP::QEvt const * const e);
    static QP::QState flying(Missile * const me, QP::QEvt const * const e);
    static QP::QState exploding(Missile * const me, QP::QEvt const * const e);
};

} // namespace GAME

namespace GAME {

static Missile l_missile; // the sole instance of the Missile active object

// Public-scope objects ------------------------------------------------------
QP::QActive * const AO_Missile = &l_missile; // opaque pointer

} // namespace GAME

// Active object definition --------------------------------------------------
namespace GAME {

//${AOs::Missile} ............................................................
//${AOs::Missile::Missile} ...................................................
Missile::Missile()
 : QActive(Q_STATE_CAST(&Missile::initial))
{}

//${AOs::Missile::SM} ........................................................
QP::QState Missile::initial(Missile * const me, QP::QEvt const * const e) {
    // ${AOs::Missile::SM::initial}
    me->subscribe( TIME_TICK_SIG);

    QS_OBJ_DICTIONARY(&l_missile);  // object dictionary for Missile object

    QS_FUN_DICTIONARY(&Missile::initial); // dictionaries for Missile HSM
    QS_FUN_DICTIONARY(&Missile::armed);
    QS_FUN_DICTIONARY(&Missile::flying);
    QS_FUN_DICTIONARY(&Missile::exploding);

    QS_SIG_DICTIONARY(MISSILE_FIRE_SIG,   &l_missile);     // local signals
    QS_SIG_DICTIONARY(HIT_WALL_SIG,       &l_missile);
    QS_SIG_DICTIONARY(DESTROYED_MINE_SIG, &l_missile);
    return Q_TRAN(&armed);
}
//${AOs::Missile::SM::armed} .................................................
QP::QState Missile::armed(Missile * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${AOs::Missile::SM::armed::MISSILE_FIRE}
        case MISSILE_FIRE_SIG: {
            me->m_x = Q_EVT_CAST(ObjectPosEvt)->x;
            me->m_y = Q_EVT_CAST(ObjectPosEvt)->y;
            status_ = Q_TRAN(&flying);
            break;
        }
        default: {
            status_ = Q_SUPER(&top);
            break;
        }
    }
    return status_;
}
//${AOs::Missile::SM::flying} ................................................
QP::QState Missile::flying(Missile * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${AOs::Missile::SM::flying::TIME_TICK}
        case TIME_TICK_SIG: {
            // ${AOs::Missile::SM::flying::TIME_TICK::[me->m_x+GAME_MISSILE_SPEED_X<GA~}
            if (me->m_x + GAME_MISSILE_SPEED_X < GAME_SCREEN_WIDTH) {
                me->m_x += GAME_MISSILE_SPEED_X;
                // tell the Tunnel to draw the Missile and test for wall hits
                AO_Tunnel->POST(Q_NEW(ObjectImageEvt, MISSILE_IMG_SIG,
                                      me->m_x, me->m_y, MISSILE_BMP),
                                me);
                status_ = Q_HANDLED();
            }
            // ${AOs::Missile::SM::flying::TIME_TICK::[else]}
            else {
                status_ = Q_TRAN(&armed);
            }
            break;
        }
        // ${AOs::Missile::SM::flying::HIT_WALL}
        case HIT_WALL_SIG: {
            status_ = Q_TRAN(&exploding);
            break;
        }
        // ${AOs::Missile::SM::flying::DESTROYED_MINE}
        case DESTROYED_MINE_SIG: {
            AO_Ship->POST(e, me);
            status_ = Q_TRAN(&armed);
            break;
        }
        default: {
            status_ = Q_SUPER(&top);
            break;
        }
    }
    return status_;
}
//${AOs::Missile::SM::exploding} .............................................
QP::QState Missile::exploding(Missile * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${AOs::Missile::SM::exploding}
        case Q_ENTRY_SIG: {
            me->m_exp_ctr = 0U;
            status_ = Q_HANDLED();
            break;
        }
        // ${AOs::Missile::SM::exploding::TIME_TICK}
        case TIME_TICK_SIG: {
            // ${AOs::Missile::SM::exploding::TIME_TICK::[(me->m_x>=GAME_SPEED_X)&&(me->m~}
            if ((me->m_x >= GAME_SPEED_X) && (me->m_exp_ctr < 15U)) {
                ++me->m_exp_ctr;           // advance the explosion counter
                me->m_x -= GAME_SPEED_X;   // move the explosion by one step

                // tell the Tunnel to render the current stage of Explosion
                AO_Tunnel->POST(Q_NEW(ObjectImageEvt, EXPLOSION_SIG,
                                      me->m_x + 3U,
                                      (int8_t)((int)me->m_y - 4U),
                                      EXPLOSION0_BMP + (me->m_exp_ctr >> 2)),
                                me);
                status_ = Q_HANDLED();
            }
            // ${AOs::Missile::SM::exploding::TIME_TICK::[else]}
            else {
                status_ = Q_TRAN(&armed);
            }
            break;
        }
        default: {
            status_ = Q_SUPER(&top);
            break;
        }
    }
    return status_;
}

} // namespace GAME
