/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow.actions;

import com.almworks.tracklink.toolwindow.table.model.ArtifactInfoRow;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class LoadStackTraceAction
extends AnAction {
    private ArtifactInfoRow getSelectedRow(DataContext dataContext) {
        ArtifactInfoRow artifactCollection = (ArtifactInfoRow)dataContext.getData("ArtifactInfoNodes");
        if (artifactCollection != null) {
            return artifactCollection;
        }
        return null;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        boolean containsStackTrace = false;
        ArtifactInfoRow selected = this.getSelectedRow(e.getDataContext());
        if (selected != null && selected.hasStackTrace()) {
            containsStackTrace = true;
        }
        e.getPresentation().setVisible(containsStackTrace);
        e.getPresentation().setEnabled(containsStackTrace);
    }

    public void actionPerformed(AnActionEvent e) {
        ArtifactInfoRow selected = this.getSelectedRow(e.getDataContext());
        if (selected != null && selected.hasStackTrace()) {
            StringSelection stringSelection = new StringSelection(selected.getStackTrace());
            CopyPasteManager.getInstance().setContents((Transferable)stringSelection);
            AnAction unscramble = ActionManager.getInstance().getAction("Unscramble");
            unscramble.actionPerformed(e);
        }
    }
}

