/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.util;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;

public class PatternInversion {
    private static final String PATTERN_ESCAPE_CHARACTERS = "\\[](){}+*-.?&|,=^$";
    private static final String PATTERN_UNESCAPED_WILDCARDS = ".+*?[{";
    private static final String PATTERN_BOUNDARY_MATCHERS = "bBzZAG";
    private final String mySourcePattern;
    private final String mySourceReplacement;
    private List<Group> myGroups;
    private String myInvertedPattern;
    private String myInvertedReplacement;
    private StringBuffer myInvPatternBuffer;
    private StringBuffer myInvReplacementBuffer;
    public static final char INTERMEDIATE_REFERENCE = '*';

    public PatternInversion(String sourcePattern, String sourceReplacement) {
        this.mySourcePattern = sourcePattern;
        this.mySourceReplacement = sourceReplacement;
    }

    public String getInvertedPattern() {
        return this.myInvertedPattern;
    }

    public String getInvertedReplacement() {
        return this.myInvertedReplacement;
    }

    public PatternInversion invert() throws InversionImpossibleException {
        this.prepare();
        this.invertPattern();
        this.invertReplacement();
        this.finish();
        return this;
    }

    private void prepare() {
        assert (this.myInvertedPattern == null && this.myInvertedReplacement == null);
        this.myInvertedPattern = null;
        this.myInvertedReplacement = null;
        this.myInvPatternBuffer = new StringBuffer();
        this.myInvReplacementBuffer = new StringBuffer();
        this.myGroups = new ArrayList<Group>();
    }

    private void invertPattern() throws InversionImpossibleException {
        int splen = this.mySourcePattern.length();
        Stack<Group> currentGroups = new Stack<Group>();
        boolean escape = false;
        for (int i = 0; i < splen; ++i) {
            char c = this.mySourcePattern.charAt(i);
            if (!escape) {
                Group group;
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                if (c == '(') {
                    group = new Group(this.myGroups.size() + 1, i, currentGroups.size());
                    this.myGroups.add(group);
                    for (Group g : currentGroups) {
                        g.incrementNestedGroupCount();
                    }
                    currentGroups.push(group);
                    continue;
                }
                if (c == ')') {
                    try {
                        group = (Group)currentGroups.pop();
                        group.setPattern(this.mySourcePattern.substring(group.getSourceStart() + 1, i));
                        if (group.getLevel() != 0) continue;
                        this.myInvReplacementBuffer.append('$');
                        this.myInvReplacementBuffer.append('*');
                        group.setReplacementReference(this.myInvReplacementBuffer.length() - 1);
                        continue;
                    }
                    catch (EmptyStackException e) {
                        throw new InversionImpossibleException("unmatched group end", i);
                    }
                }
                if (currentGroups.size() != 0 || c == '$' || c == '^') continue;
                if (PATTERN_UNESCAPED_WILDCARDS.indexOf(c) >= 0) {
                    throw new InversionImpossibleException("ungrouped wildcard " + c, i);
                }
                this.addReplacementChar(c);
                continue;
            }
            escape = false;
            if (currentGroups.size() != 0) continue;
            if (Character.isLetter(c)) {
                if (PATTERN_BOUNDARY_MATCHERS.indexOf(c) >= 0) continue;
                throw new InversionImpossibleException("ungrouped wildcard \\" + c, i);
            }
            if (Character.isDigit(c)) {
                if (c == '0') {
                    throw new InversionImpossibleException("numerical chars are not supported", i);
                }
                throw new InversionImpossibleException("back references are not supported", i);
            }
            this.addReplacementChar(c);
        }
        if (currentGroups.size() > 0) {
            throw new InversionImpossibleException("unmatched group start", ((Group)currentGroups.pop()).getSourceStart());
        }
        if (escape) {
            this.addReplacementChar('\\');
        }
    }

    private void addReplacementChar(char c) {
        if (c == '\\' || c == '$') {
            this.myInvReplacementBuffer.append('\\');
        }
        this.myInvReplacementBuffer.append(c);
    }

    private void invertReplacement() throws InversionImpossibleException {
        this.myInvPatternBuffer.append('^');
        int srlen = this.mySourceReplacement.length();
        boolean escape = false;
        int groupCounter = 1;
        for (int i = 0; i < srlen; ++i) {
            char c = this.mySourceReplacement.charAt(i);
            if (!escape) {
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                if (c == '$') {
                    int j;
                    for (j = i + 1; j < srlen && Character.isDigit(this.mySourceReplacement.charAt(j)); ++j) {
                    }
                    int reference = 0;
                    if (j > i + 1) {
                        try {
                            reference = Integer.parseInt(this.mySourceReplacement.substring(i + 1, j));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (reference <= 0) {
                        this.addPatternChar(c);
                        continue;
                    }
                    if (reference > this.myGroups.size()) {
                        throw new InversionImpossibleException("bad reference to group " + reference, i);
                    }
                    Group group = this.myGroups.get(reference - 1);
                    if (group.getLevel() != 0) {
                        throw new InversionImpossibleException("reference to a nested group is not supported", i);
                    }
                    this.myInvPatternBuffer.append('(');
                    this.myInvPatternBuffer.append(group.getPattern());
                    this.myInvPatternBuffer.append(')');
                    group.setUsed(true);
                    i = j - 1;
                    int r = group.getReplacementReference();
                    if (this.myInvReplacementBuffer.charAt(r) != '*') {
                        throw new InversionImpossibleException("multiple references are not supported", i);
                    }
                    this.myInvReplacementBuffer.replace(r, r + 1, String.valueOf(groupCounter));
                    groupCounter += group.getNestedGroupCount() + 1;
                    continue;
                }
                this.addPatternChar(c);
                continue;
            }
            escape = false;
            this.addPatternChar(c);
        }
        if (escape) {
            this.addPatternChar('\\');
        }
        for (Group group : this.myGroups) {
            if (group.getLevel() != 0 || group.isUsed()) continue;
            throw new InversionImpossibleException("group " + group.getGroupNumber() + " is not used", group.getSourceStart());
        }
        this.myInvPatternBuffer.append('$');
    }

    private void addPatternChar(char c) {
        if (PATTERN_ESCAPE_CHARACTERS.indexOf(c) >= 0) {
            this.myInvPatternBuffer.append('\\');
        }
        this.myInvPatternBuffer.append(c);
    }

    private void finish() {
        this.myInvertedPattern = this.myInvPatternBuffer.toString();
        this.myInvertedReplacement = this.myInvReplacementBuffer.toString();
        this.myGroups = null;
        this.myInvReplacementBuffer = null;
        this.myInvPatternBuffer = null;
    }

    private static class Group {
        private final int myGroupNumber;
        private final int myLevel;
        private final int mySourceStart;
        private String myPattern;
        private boolean myUsed;
        private int myReplacementReference;
        private int myNestedGroupCounter = 0;

        public Group(int groupNumber, int sourceStart, int level) {
            this.myGroupNumber = groupNumber;
            this.mySourceStart = sourceStart;
            this.myLevel = level;
        }

        public int getGroupNumber() {
            return this.myGroupNumber;
        }

        public int getLevel() {
            return this.myLevel;
        }

        public String getPattern() {
            return this.myPattern;
        }

        public void setPattern(String pattern) {
            this.myPattern = pattern;
        }

        public int getSourceStart() {
            return this.mySourceStart;
        }

        public boolean isUsed() {
            return this.myUsed;
        }

        public void setUsed(boolean used) {
            this.myUsed = used;
        }

        public void setReplacementReference(int replacementReference) {
            this.myReplacementReference = replacementReference;
        }

        public int getReplacementReference() {
            return this.myReplacementReference;
        }

        public int getNestedGroupCount() {
            return this.myNestedGroupCounter;
        }

        public void incrementNestedGroupCount() {
            ++this.myNestedGroupCounter;
        }
    }

    public static class InversionImpossibleException
    extends Exception {
        public InversionImpossibleException(String message, int position) {
            super(message + (position >= 0 ? " (" + position + ")" : ""));
        }
    }
}

