// DO NOT EDIT. Code generated by pigeon, run "go generate" to update.

package parser

import (
	"bytes"
	"errors"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"reflect"
	"strconv"
	"strings"
	"unicode"
	"unicode/utf8"
)

type namespace struct {
	scope     string
	namespace string
}

var inTests = false

type exception *Struct

type union *Struct

type include string

func makePos(p position) Pos {
	// This is not ideal, but otherwise we'd have to constantly update position information
	// in the test tables whenever the test source fragments changed.
	if inTests {
		return Pos{}
	}
	return Pos{Line: p.line, Col: p.col}
}

func toIfaceSlice(v interface{}) []interface{} {
	if v == nil {
		return nil
	}
	return v.([]interface{})
}

func ifaceSliceToString(v interface{}) string {
	ifs := toIfaceSlice(v)
	b := make([]byte, len(ifs))
	for i, v := range ifs {
		b[i] = v.([]uint8)[0]
	}
	return string(b)
}

func ifaceSliceToCommentString(v interface{}) string {
	cps := v.([]interface{})
	ccs := cps[1].([]interface{})
	b := make([]byte, len(ccs))
	for i, v := range ccs {
		tmp := v.([]interface{})
		b[i] = tmp[1].([]uint8)[0]
	}
	s := strings.Replace(string(b), "\n", "", -1)
	return strings.TrimSpace(s)
}

func ifaceSliceToBlockCommentLineString(v interface{}) string {
	cps := v.([]interface{})
	ccs := cps[1].([]interface{})
	b := make([]byte, len(ccs))
	for i, v := range ccs {
		tmp := v.([]interface{})
		b[i] = tmp[1].([]uint8)[0]
	}
	s := strings.Replace(string(b), "\n", "", -1)
	for {
		sub := strings.TrimSpace(s)
		sub = strings.TrimPrefix(sub, "*")
		sub = strings.Replace(sub, "  * ", "", -1)
		sub = strings.Replace(sub, " *", "", -1)
		if sub == s {
			break
		}
		s = sub
	}
	return s
}

func ifaceSliceToBlockComment(v interface{}) string {
	bcs := v.([]interface{})
	coms := make([]string, len(bcs))
	for i, b := range bcs {
		if reflect.TypeOf(b) != reflect.TypeOf([]uint8{}) {
			bps := b.([]interface{})
			if len(bps) > 0 && bps[1] != nil {
				coms[i] = ifaceSliceToBlockCommentLineString(bps[1])
			} else {
				coms[i] = ""
			}
		}
	}
	s := strings.Join(coms, " ")
	s = strings.TrimSpace(s)
	s = strings.TrimPrefix(s, "*")
	s = strings.TrimSpace(s)
	return s
}

// toStruct converts a union to a struct with all fields optional.
func unionToStruct(u union) *Struct {
	st := (*Struct)(u)
	for _, f := range st.Fields {
		f.Optional = true
	}
	return st
}

func toAnnotations(v interface{}) []*Annotation {
	if v == nil {
		return nil
	}
	return v.([]*Annotation)
}

var g = &grammar{
	rules: []*rule{
		{
			name: "Grammar",
			pos:  position{line: 121, col: 1, offset: 2945},
			expr: &actionExpr{
				pos: position{line: 121, col: 11, offset: 2957},
				run: (*parser).callonGrammar1,
				expr: &seqExpr{
					pos: position{line: 121, col: 11, offset: 2957},
					exprs: []interface{}{
						&ruleRefExpr{
							pos:  position{line: 121, col: 11, offset: 2957},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 121, col: 13, offset: 2959},
							label: "statements",
							expr: &zeroOrMoreExpr{
								pos: position{line: 121, col: 24, offset: 2970},
								expr: &ruleRefExpr{
									pos:  position{line: 121, col: 26, offset: 2972},
									name: "Statement",
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 121, col: 39, offset: 2985},
							name: "__",
						},
						&choiceExpr{
							pos: position{line: 121, col: 43, offset: 2989},
							alternatives: []interface{}{
								&ruleRefExpr{
									pos:  position{line: 121, col: 43, offset: 2989},
									name: "EOF",
								},
								&ruleRefExpr{
									pos:  position{line: 121, col: 49, offset: 2995},
									name: "SyntaxError",
								},
							},
						},
					},
				},
			},
		},
		{
			name: "SyntaxError",
			pos:  position{line: 165, col: 1, offset: 4146},
			expr: &actionExpr{
				pos: position{line: 165, col: 15, offset: 4162},
				run: (*parser).callonSyntaxError1,
				expr: &anyMatcher{
					line: 165, col: 15, offset: 4162,
				},
			},
		},
		{
			name: "Include",
			pos:  position{line: 169, col: 1, offset: 4217},
			expr: &actionExpr{
				pos: position{line: 169, col: 11, offset: 4229},
				run: (*parser).callonInclude1,
				expr: &seqExpr{
					pos: position{line: 169, col: 11, offset: 4229},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 169, col: 11, offset: 4229},
							label: "blockComment",
							expr: &zeroOrMoreExpr{
								pos: position{line: 169, col: 24, offset: 4242},
								expr: &seqExpr{
									pos: position{line: 169, col: 25, offset: 4243},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 169, col: 25, offset: 4243},
											name: "_",
										},
										&zeroOrOneExpr{
											pos: position{line: 169, col: 27, offset: 4245},
											expr: &ruleRefExpr{
												pos:  position{line: 169, col: 27, offset: 4245},
												name: "Comment",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 169, col: 36, offset: 4254},
											name: "EOL",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 169, col: 42, offset: 4260},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 169, col: 44, offset: 4262},
							val:        "include",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 169, col: 54, offset: 4272},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 169, col: 56, offset: 4274},
							label: "file",
							expr: &ruleRefExpr{
								pos:  position{line: 169, col: 61, offset: 4279},
								name: "Literal",
							},
						},
						&zeroOrMoreExpr{
							pos: position{line: 169, col: 69, offset: 4287},
							expr: &choiceExpr{
								pos: position{line: 169, col: 70, offset: 4288},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 169, col: 70, offset: 4288},
										name: "Whitespace",
									},
									&ruleRefExpr{
										pos:  position{line: 169, col: 83, offset: 4301},
										name: "EOL",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "Statement",
			pos:  position{line: 173, col: 1, offset: 4348},
			expr: &choiceExpr{
				pos: position{line: 173, col: 13, offset: 4362},
				alternatives: []interface{}{
					&ruleRefExpr{
						pos:  position{line: 173, col: 13, offset: 4362},
						name: "Include",
					},
					&ruleRefExpr{
						pos:  position{line: 173, col: 23, offset: 4372},
						name: "Namespace",
					},
					&ruleRefExpr{
						pos:  position{line: 173, col: 35, offset: 4384},
						name: "Const",
					},
					&ruleRefExpr{
						pos:  position{line: 173, col: 43, offset: 4392},
						name: "Enum",
					},
					&ruleRefExpr{
						pos:  position{line: 173, col: 50, offset: 4399},
						name: "TypeDef",
					},
					&ruleRefExpr{
						pos:  position{line: 173, col: 60, offset: 4409},
						name: "Struct",
					},
					&ruleRefExpr{
						pos:  position{line: 173, col: 69, offset: 4418},
						name: "Exception",
					},
					&ruleRefExpr{
						pos:  position{line: 173, col: 81, offset: 4430},
						name: "Union",
					},
					&ruleRefExpr{
						pos:  position{line: 173, col: 89, offset: 4438},
						name: "Service",
					},
				},
			},
		},
		{
			name: "Namespace",
			pos:  position{line: 175, col: 1, offset: 4447},
			expr: &actionExpr{
				pos: position{line: 175, col: 13, offset: 4461},
				run: (*parser).callonNamespace1,
				expr: &seqExpr{
					pos: position{line: 175, col: 13, offset: 4461},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 175, col: 13, offset: 4461},
							label: "blockComment",
							expr: &zeroOrMoreExpr{
								pos: position{line: 175, col: 26, offset: 4474},
								expr: &seqExpr{
									pos: position{line: 175, col: 27, offset: 4475},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 175, col: 27, offset: 4475},
											name: "_",
										},
										&zeroOrOneExpr{
											pos: position{line: 175, col: 29, offset: 4477},
											expr: &ruleRefExpr{
												pos:  position{line: 175, col: 29, offset: 4477},
												name: "Comment",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 175, col: 38, offset: 4486},
											name: "EOL",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 175, col: 44, offset: 4492},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 175, col: 46, offset: 4494},
							val:        "namespace",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 175, col: 58, offset: 4506},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 175, col: 60, offset: 4508},
							label: "scope",
							expr: &oneOrMoreExpr{
								pos: position{line: 175, col: 66, offset: 4514},
								expr: &charClassMatcher{
									pos:        position{line: 175, col: 66, offset: 4514},
									val:        "[*a-z.-]",
									chars:      []rune{'*', '.', '-'},
									ranges:     []rune{'a', 'z'},
									ignoreCase: false,
									inverted:   false,
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 175, col: 76, offset: 4524},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 175, col: 78, offset: 4526},
							label: "ns",
							expr: &ruleRefExpr{
								pos:  position{line: 175, col: 81, offset: 4529},
								name: "Identifier",
							},
						},
						&zeroOrMoreExpr{
							pos: position{line: 175, col: 92, offset: 4540},
							expr: &choiceExpr{
								pos: position{line: 175, col: 93, offset: 4541},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 175, col: 93, offset: 4541},
										name: "Whitespace",
									},
									&ruleRefExpr{
										pos:  position{line: 175, col: 106, offset: 4554},
										name: "EOL",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "Const",
			pos:  position{line: 182, col: 1, offset: 4667},
			expr: &actionExpr{
				pos: position{line: 182, col: 9, offset: 4677},
				run: (*parser).callonConst1,
				expr: &seqExpr{
					pos: position{line: 182, col: 9, offset: 4677},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 182, col: 9, offset: 4677},
							label: "blockComment",
							expr: &zeroOrMoreExpr{
								pos: position{line: 182, col: 22, offset: 4690},
								expr: &seqExpr{
									pos: position{line: 182, col: 23, offset: 4691},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 182, col: 23, offset: 4691},
											name: "_",
										},
										&zeroOrOneExpr{
											pos: position{line: 182, col: 25, offset: 4693},
											expr: &ruleRefExpr{
												pos:  position{line: 182, col: 25, offset: 4693},
												name: "Comment",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 182, col: 34, offset: 4702},
											name: "EOL",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 182, col: 40, offset: 4708},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 182, col: 42, offset: 4710},
							val:        "const",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 182, col: 50, offset: 4718},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 182, col: 52, offset: 4720},
							label: "typ",
							expr: &ruleRefExpr{
								pos:  position{line: 182, col: 56, offset: 4724},
								name: "FieldType",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 182, col: 66, offset: 4734},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 182, col: 68, offset: 4736},
							label: "name",
							expr: &ruleRefExpr{
								pos:  position{line: 182, col: 73, offset: 4741},
								name: "Identifier",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 182, col: 84, offset: 4752},
							name: "__",
						},
						&litMatcher{
							pos:        position{line: 182, col: 87, offset: 4755},
							val:        "=",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 182, col: 91, offset: 4759},
							name: "__",
						},
						&labeledExpr{
							pos:   position{line: 182, col: 94, offset: 4762},
							label: "value",
							expr: &ruleRefExpr{
								pos:  position{line: 182, col: 100, offset: 4768},
								name: "ConstValue",
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 182, col: 111, offset: 4779},
							expr: &ruleRefExpr{
								pos:  position{line: 182, col: 111, offset: 4779},
								name: "ListSeparator",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 182, col: 126, offset: 4794},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 182, col: 128, offset: 4796},
							label: "comment",
							expr: &zeroOrOneExpr{
								pos: position{line: 182, col: 136, offset: 4804},
								expr: &ruleRefExpr{
									pos:  position{line: 182, col: 136, offset: 4804},
									name: "Comment",
								},
							},
						},
						&zeroOrMoreExpr{
							pos: position{line: 182, col: 145, offset: 4813},
							expr: &choiceExpr{
								pos: position{line: 182, col: 146, offset: 4814},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 182, col: 146, offset: 4814},
										name: "Whitespace",
									},
									&ruleRefExpr{
										pos:  position{line: 182, col: 159, offset: 4827},
										name: "EOL",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "Enum",
			pos:  position{line: 201, col: 1, offset: 5240},
			expr: &actionExpr{
				pos: position{line: 201, col: 8, offset: 5249},
				run: (*parser).callonEnum1,
				expr: &seqExpr{
					pos: position{line: 201, col: 8, offset: 5249},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 201, col: 8, offset: 5249},
							label: "blockComment",
							expr: &zeroOrMoreExpr{
								pos: position{line: 201, col: 21, offset: 5262},
								expr: &seqExpr{
									pos: position{line: 201, col: 22, offset: 5263},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 201, col: 22, offset: 5263},
											name: "_",
										},
										&zeroOrOneExpr{
											pos: position{line: 201, col: 24, offset: 5265},
											expr: &ruleRefExpr{
												pos:  position{line: 201, col: 24, offset: 5265},
												name: "Comment",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 201, col: 33, offset: 5274},
											name: "EOL",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 201, col: 39, offset: 5280},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 201, col: 41, offset: 5282},
							val:        "enum",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 201, col: 48, offset: 5289},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 201, col: 50, offset: 5291},
							label: "name",
							expr: &ruleRefExpr{
								pos:  position{line: 201, col: 55, offset: 5296},
								name: "Identifier",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 201, col: 66, offset: 5307},
							name: "__",
						},
						&litMatcher{
							pos:        position{line: 201, col: 69, offset: 5310},
							val:        "{",
							ignoreCase: false,
						},
						&zeroOrMoreExpr{
							pos: position{line: 201, col: 73, offset: 5314},
							expr: &choiceExpr{
								pos: position{line: 201, col: 74, offset: 5315},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 201, col: 74, offset: 5315},
										name: "Whitespace",
									},
									&ruleRefExpr{
										pos:  position{line: 201, col: 87, offset: 5328},
										name: "EOL",
									},
								},
							},
						},
						&labeledExpr{
							pos:   position{line: 201, col: 93, offset: 5334},
							label: "values",
							expr: &zeroOrMoreExpr{
								pos: position{line: 201, col: 100, offset: 5341},
								expr: &ruleRefExpr{
									pos:  position{line: 201, col: 100, offset: 5341},
									name: "EnumValue",
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 201, col: 111, offset: 5352},
							name: "__",
						},
						&litMatcher{
							pos:        position{line: 201, col: 113, offset: 5354},
							val:        "}",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 201, col: 117, offset: 5358},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 201, col: 119, offset: 5360},
							label: "annotations",
							expr: &zeroOrOneExpr{
								pos: position{line: 201, col: 131, offset: 5372},
								expr: &ruleRefExpr{
									pos:  position{line: 201, col: 131, offset: 5372},
									name: "TypeAnnotations",
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 201, col: 148, offset: 5389},
							expr: &ruleRefExpr{
								pos:  position{line: 201, col: 148, offset: 5389},
								name: "ListSeparator",
							},
						},
						&zeroOrMoreExpr{
							pos: position{line: 201, col: 163, offset: 5404},
							expr: &choiceExpr{
								pos: position{line: 201, col: 164, offset: 5405},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 201, col: 164, offset: 5405},
										name: "Whitespace",
									},
									&ruleRefExpr{
										pos:  position{line: 201, col: 177, offset: 5418},
										name: "EOL",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "EnumValue",
			pos:  position{line: 232, col: 1, offset: 6161},
			expr: &actionExpr{
				pos: position{line: 232, col: 13, offset: 6175},
				run: (*parser).callonEnumValue1,
				expr: &seqExpr{
					pos: position{line: 232, col: 13, offset: 6175},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 232, col: 13, offset: 6175},
							label: "blockComment",
							expr: &zeroOrMoreExpr{
								pos: position{line: 232, col: 26, offset: 6188},
								expr: &seqExpr{
									pos: position{line: 232, col: 27, offset: 6189},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 232, col: 27, offset: 6189},
											name: "_",
										},
										&zeroOrOneExpr{
											pos: position{line: 232, col: 29, offset: 6191},
											expr: &ruleRefExpr{
												pos:  position{line: 232, col: 29, offset: 6191},
												name: "Comment",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 232, col: 38, offset: 6200},
											name: "EOL",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 232, col: 44, offset: 6206},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 232, col: 46, offset: 6208},
							label: "name",
							expr: &ruleRefExpr{
								pos:  position{line: 232, col: 51, offset: 6213},
								name: "Identifier",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 232, col: 62, offset: 6224},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 232, col: 64, offset: 6226},
							label: "value",
							expr: &zeroOrOneExpr{
								pos: position{line: 232, col: 70, offset: 6232},
								expr: &seqExpr{
									pos: position{line: 232, col: 71, offset: 6233},
									exprs: []interface{}{
										&litMatcher{
											pos:        position{line: 232, col: 71, offset: 6233},
											val:        "=",
											ignoreCase: false,
										},
										&ruleRefExpr{
											pos:  position{line: 232, col: 75, offset: 6237},
											name: "_",
										},
										&ruleRefExpr{
											pos:  position{line: 232, col: 77, offset: 6239},
											name: "IntConstant",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 232, col: 91, offset: 6253},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 232, col: 93, offset: 6255},
							label: "annotations",
							expr: &zeroOrOneExpr{
								pos: position{line: 232, col: 105, offset: 6267},
								expr: &ruleRefExpr{
									pos:  position{line: 232, col: 105, offset: 6267},
									name: "TypeAnnotations",
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 232, col: 122, offset: 6284},
							expr: &ruleRefExpr{
								pos:  position{line: 232, col: 122, offset: 6284},
								name: "ListSeparator",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 232, col: 137, offset: 6299},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 232, col: 139, offset: 6301},
							label: "comment",
							expr: &zeroOrOneExpr{
								pos: position{line: 232, col: 147, offset: 6309},
								expr: &ruleRefExpr{
									pos:  position{line: 232, col: 147, offset: 6309},
									name: "Comment",
								},
							},
						},
					},
				},
			},
		},
		{
			name: "TypeDef",
			pos:  position{line: 254, col: 1, offset: 6842},
			expr: &actionExpr{
				pos: position{line: 254, col: 11, offset: 6854},
				run: (*parser).callonTypeDef1,
				expr: &seqExpr{
					pos: position{line: 254, col: 11, offset: 6854},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 254, col: 11, offset: 6854},
							label: "blockComment",
							expr: &zeroOrMoreExpr{
								pos: position{line: 254, col: 24, offset: 6867},
								expr: &seqExpr{
									pos: position{line: 254, col: 25, offset: 6868},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 254, col: 25, offset: 6868},
											name: "_",
										},
										&zeroOrOneExpr{
											pos: position{line: 254, col: 27, offset: 6870},
											expr: &ruleRefExpr{
												pos:  position{line: 254, col: 27, offset: 6870},
												name: "Comment",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 254, col: 36, offset: 6879},
											name: "EOL",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 254, col: 42, offset: 6885},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 254, col: 44, offset: 6887},
							val:        "typedef",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 254, col: 54, offset: 6897},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 254, col: 56, offset: 6899},
							label: "typ",
							expr: &ruleRefExpr{
								pos:  position{line: 254, col: 60, offset: 6903},
								name: "FieldType",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 254, col: 70, offset: 6913},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 254, col: 72, offset: 6915},
							label: "name",
							expr: &ruleRefExpr{
								pos:  position{line: 254, col: 77, offset: 6920},
								name: "Identifier",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 254, col: 88, offset: 6931},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 254, col: 90, offset: 6933},
							label: "annotations",
							expr: &zeroOrOneExpr{
								pos: position{line: 254, col: 102, offset: 6945},
								expr: &ruleRefExpr{
									pos:  position{line: 254, col: 102, offset: 6945},
									name: "TypeAnnotations",
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 254, col: 119, offset: 6962},
							expr: &ruleRefExpr{
								pos:  position{line: 254, col: 119, offset: 6962},
								name: "ListSeparator",
							},
						},
						&zeroOrMoreExpr{
							pos: position{line: 254, col: 134, offset: 6977},
							expr: &choiceExpr{
								pos: position{line: 254, col: 135, offset: 6978},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 254, col: 135, offset: 6978},
										name: "Whitespace",
									},
									&ruleRefExpr{
										pos:  position{line: 254, col: 148, offset: 6991},
										name: "EOL",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "Struct",
			pos:  position{line: 263, col: 1, offset: 7151},
			expr: &actionExpr{
				pos: position{line: 263, col: 10, offset: 7162},
				run: (*parser).callonStruct1,
				expr: &seqExpr{
					pos: position{line: 263, col: 10, offset: 7162},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 263, col: 10, offset: 7162},
							label: "blockComment",
							expr: &zeroOrMoreExpr{
								pos: position{line: 263, col: 23, offset: 7175},
								expr: &seqExpr{
									pos: position{line: 263, col: 24, offset: 7176},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 263, col: 24, offset: 7176},
											name: "_",
										},
										&zeroOrOneExpr{
											pos: position{line: 263, col: 26, offset: 7178},
											expr: &ruleRefExpr{
												pos:  position{line: 263, col: 26, offset: 7178},
												name: "Comment",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 263, col: 35, offset: 7187},
											name: "EOL",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 263, col: 41, offset: 7193},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 263, col: 43, offset: 7195},
							val:        "struct",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 263, col: 52, offset: 7204},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 263, col: 54, offset: 7206},
							label: "st",
							expr: &ruleRefExpr{
								pos:  position{line: 263, col: 57, offset: 7209},
								name: "StructLike",
							},
						},
					},
				},
			},
		},
		{
			name: "Exception",
			pos:  position{line: 274, col: 1, offset: 7470},
			expr: &actionExpr{
				pos: position{line: 274, col: 13, offset: 7484},
				run: (*parser).callonException1,
				expr: &seqExpr{
					pos: position{line: 274, col: 13, offset: 7484},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 274, col: 13, offset: 7484},
							label: "blockComment",
							expr: &zeroOrMoreExpr{
								pos: position{line: 274, col: 26, offset: 7497},
								expr: &seqExpr{
									pos: position{line: 274, col: 27, offset: 7498},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 274, col: 27, offset: 7498},
											name: "_",
										},
										&zeroOrOneExpr{
											pos: position{line: 274, col: 29, offset: 7500},
											expr: &ruleRefExpr{
												pos:  position{line: 274, col: 29, offset: 7500},
												name: "Comment",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 274, col: 38, offset: 7509},
											name: "EOL",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 274, col: 44, offset: 7515},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 274, col: 46, offset: 7517},
							val:        "exception",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 274, col: 58, offset: 7529},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 274, col: 60, offset: 7531},
							label: "st",
							expr: &ruleRefExpr{
								pos:  position{line: 274, col: 63, offset: 7534},
								name: "StructLike",
							},
						},
					},
				},
			},
		},
		{
			name: "Union",
			pos:  position{line: 285, col: 1, offset: 7806},
			expr: &actionExpr{
				pos: position{line: 285, col: 9, offset: 7816},
				run: (*parser).callonUnion1,
				expr: &seqExpr{
					pos: position{line: 285, col: 9, offset: 7816},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 285, col: 9, offset: 7816},
							label: "blockComment",
							expr: &zeroOrMoreExpr{
								pos: position{line: 285, col: 22, offset: 7829},
								expr: &seqExpr{
									pos: position{line: 285, col: 23, offset: 7830},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 285, col: 23, offset: 7830},
											name: "_",
										},
										&zeroOrOneExpr{
											pos: position{line: 285, col: 25, offset: 7832},
											expr: &ruleRefExpr{
												pos:  position{line: 285, col: 25, offset: 7832},
												name: "Comment",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 285, col: 34, offset: 7841},
											name: "EOL",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 285, col: 40, offset: 7847},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 285, col: 42, offset: 7849},
							val:        "union",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 285, col: 50, offset: 7857},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 285, col: 52, offset: 7859},
							label: "st",
							expr: &ruleRefExpr{
								pos:  position{line: 285, col: 55, offset: 7862},
								name: "StructLike",
							},
						},
					},
				},
			},
		},
		{
			name: "StructLike",
			pos:  position{line: 296, col: 1, offset: 8130},
			expr: &actionExpr{
				pos: position{line: 296, col: 14, offset: 8145},
				run: (*parser).callonStructLike1,
				expr: &seqExpr{
					pos: position{line: 296, col: 14, offset: 8145},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 296, col: 14, offset: 8145},
							label: "name",
							expr: &ruleRefExpr{
								pos:  position{line: 296, col: 19, offset: 8150},
								name: "Identifier",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 296, col: 30, offset: 8161},
							name: "__",
						},
						&litMatcher{
							pos:        position{line: 296, col: 33, offset: 8164},
							val:        "{",
							ignoreCase: false,
						},
						&zeroOrMoreExpr{
							pos: position{line: 296, col: 37, offset: 8168},
							expr: &choiceExpr{
								pos: position{line: 296, col: 38, offset: 8169},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 296, col: 38, offset: 8169},
										name: "Whitespace",
									},
									&ruleRefExpr{
										pos:  position{line: 296, col: 51, offset: 8182},
										name: "EOL",
									},
								},
							},
						},
						&labeledExpr{
							pos:   position{line: 296, col: 57, offset: 8188},
							label: "fields",
							expr: &ruleRefExpr{
								pos:  position{line: 296, col: 64, offset: 8195},
								name: "FieldList",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 296, col: 74, offset: 8205},
							name: "__",
						},
						&litMatcher{
							pos:        position{line: 296, col: 76, offset: 8207},
							val:        "}",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 296, col: 80, offset: 8211},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 296, col: 82, offset: 8213},
							label: "annotations",
							expr: &zeroOrOneExpr{
								pos: position{line: 296, col: 94, offset: 8225},
								expr: &ruleRefExpr{
									pos:  position{line: 296, col: 94, offset: 8225},
									name: "TypeAnnotations",
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 296, col: 111, offset: 8242},
							expr: &ruleRefExpr{
								pos:  position{line: 296, col: 111, offset: 8242},
								name: "ListSeparator",
							},
						},
						&zeroOrMoreExpr{
							pos: position{line: 296, col: 126, offset: 8257},
							expr: &choiceExpr{
								pos: position{line: 296, col: 127, offset: 8258},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 296, col: 127, offset: 8258},
										name: "Whitespace",
									},
									&ruleRefExpr{
										pos:  position{line: 296, col: 140, offset: 8271},
										name: "EOL",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "FieldList",
			pos:  position{line: 308, col: 1, offset: 8473},
			expr: &actionExpr{
				pos: position{line: 308, col: 13, offset: 8487},
				run: (*parser).callonFieldList1,
				expr: &labeledExpr{
					pos:   position{line: 308, col: 13, offset: 8487},
					label: "fields",
					expr: &zeroOrMoreExpr{
						pos: position{line: 308, col: 20, offset: 8494},
						expr: &seqExpr{
							pos: position{line: 308, col: 21, offset: 8495},
							exprs: []interface{}{
								&ruleRefExpr{
									pos:  position{line: 308, col: 21, offset: 8495},
									name: "Field",
								},
								&zeroOrMoreExpr{
									pos: position{line: 308, col: 27, offset: 8501},
									expr: &choiceExpr{
										pos: position{line: 308, col: 28, offset: 8502},
										alternatives: []interface{}{
											&ruleRefExpr{
												pos:  position{line: 308, col: 28, offset: 8502},
												name: "Whitespace",
											},
											&ruleRefExpr{
												pos:  position{line: 308, col: 41, offset: 8515},
												name: "EOL",
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "Field",
			pos:  position{line: 317, col: 1, offset: 8678},
			expr: &actionExpr{
				pos: position{line: 317, col: 9, offset: 8688},
				run: (*parser).callonField1,
				expr: &seqExpr{
					pos: position{line: 317, col: 9, offset: 8688},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 317, col: 9, offset: 8688},
							label: "blockComment",
							expr: &zeroOrMoreExpr{
								pos: position{line: 317, col: 22, offset: 8701},
								expr: &seqExpr{
									pos: position{line: 317, col: 23, offset: 8702},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 317, col: 23, offset: 8702},
											name: "_",
										},
										&zeroOrOneExpr{
											pos: position{line: 317, col: 25, offset: 8704},
											expr: &ruleRefExpr{
												pos:  position{line: 317, col: 25, offset: 8704},
												name: "Comment",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 317, col: 34, offset: 8713},
											name: "EOL",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 317, col: 40, offset: 8719},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 317, col: 42, offset: 8721},
							label: "id",
							expr: &ruleRefExpr{
								pos:  position{line: 317, col: 45, offset: 8724},
								name: "IntConstant",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 317, col: 57, offset: 8736},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 317, col: 59, offset: 8738},
							val:        ":",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 317, col: 63, offset: 8742},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 317, col: 65, offset: 8744},
							label: "req",
							expr: &zeroOrOneExpr{
								pos: position{line: 317, col: 69, offset: 8748},
								expr: &ruleRefExpr{
									pos:  position{line: 317, col: 69, offset: 8748},
									name: "FieldReq",
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 317, col: 79, offset: 8758},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 317, col: 81, offset: 8760},
							label: "typ",
							expr: &ruleRefExpr{
								pos:  position{line: 317, col: 85, offset: 8764},
								name: "FieldType",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 317, col: 95, offset: 8774},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 317, col: 97, offset: 8776},
							label: "name",
							expr: &ruleRefExpr{
								pos:  position{line: 317, col: 102, offset: 8781},
								name: "Identifier",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 317, col: 113, offset: 8792},
							name: "__",
						},
						&labeledExpr{
							pos:   position{line: 317, col: 116, offset: 8795},
							label: "def",
							expr: &zeroOrOneExpr{
								pos: position{line: 317, col: 120, offset: 8799},
								expr: &seqExpr{
									pos: position{line: 317, col: 121, offset: 8800},
									exprs: []interface{}{
										&litMatcher{
											pos:        position{line: 317, col: 121, offset: 8800},
											val:        "=",
											ignoreCase: false,
										},
										&ruleRefExpr{
											pos:  position{line: 317, col: 125, offset: 8804},
											name: "_",
										},
										&ruleRefExpr{
											pos:  position{line: 317, col: 127, offset: 8806},
											name: "ConstValue",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 317, col: 140, offset: 8819},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 317, col: 142, offset: 8821},
							label: "annotations",
							expr: &zeroOrOneExpr{
								pos: position{line: 317, col: 154, offset: 8833},
								expr: &ruleRefExpr{
									pos:  position{line: 317, col: 154, offset: 8833},
									name: "TypeAnnotations",
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 317, col: 171, offset: 8850},
							expr: &ruleRefExpr{
								pos:  position{line: 317, col: 171, offset: 8850},
								name: "ListSeparator",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 317, col: 186, offset: 8865},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 317, col: 188, offset: 8867},
							label: "comment",
							expr: &zeroOrOneExpr{
								pos: position{line: 317, col: 196, offset: 8875},
								expr: &ruleRefExpr{
									pos:  position{line: 317, col: 196, offset: 8875},
									name: "Comment",
								},
							},
						},
					},
				},
			},
		},
		{
			name: "FieldReq",
			pos:  position{line: 343, col: 1, offset: 9430},
			expr: &actionExpr{
				pos: position{line: 343, col: 12, offset: 9443},
				run: (*parser).callonFieldReq1,
				expr: &choiceExpr{
					pos: position{line: 343, col: 13, offset: 9444},
					alternatives: []interface{}{
						&litMatcher{
							pos:        position{line: 343, col: 13, offset: 9444},
							val:        "required",
							ignoreCase: false,
						},
						&litMatcher{
							pos:        position{line: 343, col: 26, offset: 9457},
							val:        "optional",
							ignoreCase: false,
						},
					},
				},
			},
		},
		{
			name: "Service",
			pos:  position{line: 347, col: 1, offset: 9528},
			expr: &actionExpr{
				pos: position{line: 347, col: 11, offset: 9540},
				run: (*parser).callonService1,
				expr: &seqExpr{
					pos: position{line: 347, col: 11, offset: 9540},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 347, col: 11, offset: 9540},
							label: "blockComment",
							expr: &zeroOrMoreExpr{
								pos: position{line: 347, col: 24, offset: 9553},
								expr: &seqExpr{
									pos: position{line: 347, col: 25, offset: 9554},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 347, col: 25, offset: 9554},
											name: "_",
										},
										&zeroOrOneExpr{
											pos: position{line: 347, col: 27, offset: 9556},
											expr: &ruleRefExpr{
												pos:  position{line: 347, col: 27, offset: 9556},
												name: "Comment",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 347, col: 36, offset: 9565},
											name: "EOL",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 347, col: 42, offset: 9571},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 347, col: 44, offset: 9573},
							val:        "service",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 347, col: 54, offset: 9583},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 347, col: 56, offset: 9585},
							label: "name",
							expr: &ruleRefExpr{
								pos:  position{line: 347, col: 61, offset: 9590},
								name: "Identifier",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 347, col: 72, offset: 9601},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 347, col: 74, offset: 9603},
							label: "extends",
							expr: &zeroOrOneExpr{
								pos: position{line: 347, col: 82, offset: 9611},
								expr: &seqExpr{
									pos: position{line: 347, col: 83, offset: 9612},
									exprs: []interface{}{
										&litMatcher{
											pos:        position{line: 347, col: 83, offset: 9612},
											val:        "extends",
											ignoreCase: false,
										},
										&ruleRefExpr{
											pos:  position{line: 347, col: 93, offset: 9622},
											name: "__",
										},
										&ruleRefExpr{
											pos:  position{line: 347, col: 96, offset: 9625},
											name: "Identifier",
										},
										&ruleRefExpr{
											pos:  position{line: 347, col: 107, offset: 9636},
											name: "__",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 347, col: 112, offset: 9641},
							name: "__",
						},
						&litMatcher{
							pos:        position{line: 347, col: 115, offset: 9644},
							val:        "{",
							ignoreCase: false,
						},
						&labeledExpr{
							pos:   position{line: 347, col: 119, offset: 9648},
							label: "methods",
							expr: &zeroOrMoreExpr{
								pos: position{line: 347, col: 127, offset: 9656},
								expr: &ruleRefExpr{
									pos:  position{line: 347, col: 128, offset: 9657},
									name: "Function",
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 347, col: 139, offset: 9668},
							name: "__",
						},
						&choiceExpr{
							pos: position{line: 347, col: 143, offset: 9672},
							alternatives: []interface{}{
								&litMatcher{
									pos:        position{line: 347, col: 143, offset: 9672},
									val:        "}",
									ignoreCase: false,
								},
								&ruleRefExpr{
									pos:  position{line: 347, col: 149, offset: 9678},
									name: "EndOfServiceError",
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 347, col: 168, offset: 9697},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 347, col: 170, offset: 9699},
							label: "annotations",
							expr: &zeroOrOneExpr{
								pos: position{line: 347, col: 182, offset: 9711},
								expr: &ruleRefExpr{
									pos:  position{line: 347, col: 182, offset: 9711},
									name: "TypeAnnotations",
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 347, col: 199, offset: 9728},
							expr: &ruleRefExpr{
								pos:  position{line: 347, col: 199, offset: 9728},
								name: "ListSeparator",
							},
						},
						&zeroOrMoreExpr{
							pos: position{line: 347, col: 214, offset: 9743},
							expr: &choiceExpr{
								pos: position{line: 347, col: 215, offset: 9744},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 347, col: 215, offset: 9744},
										name: "Whitespace",
									},
									&ruleRefExpr{
										pos:  position{line: 347, col: 228, offset: 9757},
										name: "EOL",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "EndOfServiceError",
			pos:  position{line: 370, col: 1, offset: 10340},
			expr: &actionExpr{
				pos: position{line: 370, col: 21, offset: 10362},
				run: (*parser).callonEndOfServiceError1,
				expr: &anyMatcher{
					line: 370, col: 21, offset: 10362,
				},
			},
		},
		{
			name: "Function",
			pos:  position{line: 374, col: 1, offset: 10428},
			expr: &actionExpr{
				pos: position{line: 374, col: 12, offset: 10441},
				run: (*parser).callonFunction1,
				expr: &seqExpr{
					pos: position{line: 374, col: 12, offset: 10441},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 374, col: 12, offset: 10441},
							label: "blockComment",
							expr: &zeroOrMoreExpr{
								pos: position{line: 374, col: 25, offset: 10454},
								expr: &seqExpr{
									pos: position{line: 374, col: 26, offset: 10455},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 374, col: 26, offset: 10455},
											name: "_",
										},
										&zeroOrOneExpr{
											pos: position{line: 374, col: 28, offset: 10457},
											expr: &ruleRefExpr{
												pos:  position{line: 374, col: 28, offset: 10457},
												name: "Comment",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 374, col: 37, offset: 10466},
											name: "EOL",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 374, col: 43, offset: 10472},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 374, col: 45, offset: 10474},
							label: "oneway",
							expr: &zeroOrOneExpr{
								pos: position{line: 374, col: 52, offset: 10481},
								expr: &seqExpr{
									pos: position{line: 374, col: 53, offset: 10482},
									exprs: []interface{}{
										&litMatcher{
											pos:        position{line: 374, col: 53, offset: 10482},
											val:        "oneway",
											ignoreCase: false,
										},
										&ruleRefExpr{
											pos:  position{line: 374, col: 62, offset: 10491},
											name: "__",
										},
									},
								},
							},
						},
						&labeledExpr{
							pos:   position{line: 374, col: 67, offset: 10496},
							label: "typ",
							expr: &ruleRefExpr{
								pos:  position{line: 374, col: 71, offset: 10500},
								name: "FunctionType",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 374, col: 84, offset: 10513},
							name: "__",
						},
						&labeledExpr{
							pos:   position{line: 374, col: 87, offset: 10516},
							label: "name",
							expr: &ruleRefExpr{
								pos:  position{line: 374, col: 92, offset: 10521},
								name: "Identifier",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 374, col: 103, offset: 10532},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 374, col: 105, offset: 10534},
							val:        "(",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 374, col: 109, offset: 10538},
							name: "__",
						},
						&labeledExpr{
							pos:   position{line: 374, col: 112, offset: 10541},
							label: "arguments",
							expr: &ruleRefExpr{
								pos:  position{line: 374, col: 122, offset: 10551},
								name: "FieldList",
							},
						},
						&litMatcher{
							pos:        position{line: 374, col: 132, offset: 10561},
							val:        ")",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 374, col: 136, offset: 10565},
							name: "__",
						},
						&labeledExpr{
							pos:   position{line: 374, col: 139, offset: 10568},
							label: "exceptions",
							expr: &zeroOrOneExpr{
								pos: position{line: 374, col: 150, offset: 10579},
								expr: &ruleRefExpr{
									pos:  position{line: 374, col: 150, offset: 10579},
									name: "Throws",
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 374, col: 158, offset: 10587},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 374, col: 160, offset: 10589},
							label: "annotations",
							expr: &zeroOrOneExpr{
								pos: position{line: 374, col: 172, offset: 10601},
								expr: &ruleRefExpr{
									pos:  position{line: 374, col: 172, offset: 10601},
									name: "TypeAnnotations",
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 374, col: 189, offset: 10618},
							expr: &ruleRefExpr{
								pos:  position{line: 374, col: 189, offset: 10618},
								name: "ListSeparator",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 374, col: 204, offset: 10633},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 374, col: 206, offset: 10635},
							label: "comment",
							expr: &zeroOrOneExpr{
								pos: position{line: 374, col: 214, offset: 10643},
								expr: &ruleRefExpr{
									pos:  position{line: 374, col: 214, offset: 10643},
									name: "Comment",
								},
							},
						},
					},
				},
			},
		},
		{
			name: "FunctionType",
			pos:  position{line: 408, col: 1, offset: 11376},
			expr: &actionExpr{
				pos: position{line: 408, col: 16, offset: 11393},
				run: (*parser).callonFunctionType1,
				expr: &labeledExpr{
					pos:   position{line: 408, col: 16, offset: 11393},
					label: "typ",
					expr: &choiceExpr{
						pos: position{line: 408, col: 21, offset: 11398},
						alternatives: []interface{}{
							&litMatcher{
								pos:        position{line: 408, col: 21, offset: 11398},
								val:        "void",
								ignoreCase: false,
							},
							&ruleRefExpr{
								pos:  position{line: 408, col: 30, offset: 11407},
								name: "FieldType",
							},
						},
					},
				},
			},
		},
		{
			name: "Throws",
			pos:  position{line: 418, col: 1, offset: 11543},
			expr: &actionExpr{
				pos: position{line: 418, col: 10, offset: 11554},
				run: (*parser).callonThrows1,
				expr: &seqExpr{
					pos: position{line: 418, col: 10, offset: 11554},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 418, col: 10, offset: 11554},
							val:        "throws",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 418, col: 19, offset: 11563},
							name: "__",
						},
						&litMatcher{
							pos:        position{line: 418, col: 22, offset: 11566},
							val:        "(",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 418, col: 26, offset: 11570},
							name: "__",
						},
						&labeledExpr{
							pos:   position{line: 418, col: 29, offset: 11573},
							label: "exceptions",
							expr: &ruleRefExpr{
								pos:  position{line: 418, col: 40, offset: 11584},
								name: "FieldList",
							},
						},
						&litMatcher{
							pos:        position{line: 418, col: 50, offset: 11594},
							val:        ")",
							ignoreCase: false,
						},
					},
				},
			},
		},
		{
			name: "FieldType",
			pos:  position{line: 422, col: 1, offset: 11627},
			expr: &actionExpr{
				pos: position{line: 422, col: 13, offset: 11641},
				run: (*parser).callonFieldType1,
				expr: &labeledExpr{
					pos:   position{line: 422, col: 13, offset: 11641},
					label: "typ",
					expr: &choiceExpr{
						pos: position{line: 422, col: 18, offset: 11646},
						alternatives: []interface{}{
							&ruleRefExpr{
								pos:  position{line: 422, col: 18, offset: 11646},
								name: "BaseType",
							},
							&ruleRefExpr{
								pos:  position{line: 422, col: 29, offset: 11657},
								name: "ContainerType",
							},
							&ruleRefExpr{
								pos:  position{line: 422, col: 45, offset: 11673},
								name: "Identifier",
							},
						},
					},
				},
			},
		},
		{
			name: "DefinitionType",
			pos:  position{line: 432, col: 1, offset: 11815},
			expr: &actionExpr{
				pos: position{line: 432, col: 18, offset: 11834},
				run: (*parser).callonDefinitionType1,
				expr: &labeledExpr{
					pos:   position{line: 432, col: 18, offset: 11834},
					label: "typ",
					expr: &choiceExpr{
						pos: position{line: 432, col: 23, offset: 11839},
						alternatives: []interface{}{
							&ruleRefExpr{
								pos:  position{line: 432, col: 23, offset: 11839},
								name: "BaseType",
							},
							&ruleRefExpr{
								pos:  position{line: 432, col: 34, offset: 11850},
								name: "ContainerType",
							},
						},
					},
				},
			},
		},
		{
			name: "BaseType",
			pos:  position{line: 436, col: 1, offset: 11887},
			expr: &actionExpr{
				pos: position{line: 436, col: 12, offset: 11900},
				run: (*parser).callonBaseType1,
				expr: &seqExpr{
					pos: position{line: 436, col: 12, offset: 11900},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 436, col: 12, offset: 11900},
							label: "name",
							expr: &ruleRefExpr{
								pos:  position{line: 436, col: 17, offset: 11905},
								name: "BaseTypeName",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 436, col: 30, offset: 11918},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 436, col: 32, offset: 11920},
							label: "annotations",
							expr: &zeroOrOneExpr{
								pos: position{line: 436, col: 44, offset: 11932},
								expr: &ruleRefExpr{
									pos:  position{line: 436, col: 44, offset: 11932},
									name: "TypeAnnotations",
								},
							},
						},
					},
				},
			},
		},
		{
			name: "BaseTypeName",
			pos:  position{line: 444, col: 1, offset: 12066},
			expr: &actionExpr{
				pos: position{line: 444, col: 16, offset: 12083},
				run: (*parser).callonBaseTypeName1,
				expr: &choiceExpr{
					pos: position{line: 444, col: 17, offset: 12084},
					alternatives: []interface{}{
						&litMatcher{
							pos:        position{line: 444, col: 17, offset: 12084},
							val:        "bool",
							ignoreCase: false,
						},
						&litMatcher{
							pos:        position{line: 444, col: 26, offset: 12093},
							val:        "byte",
							ignoreCase: false,
						},
						&litMatcher{
							pos:        position{line: 444, col: 35, offset: 12102},
							val:        "i16",
							ignoreCase: false,
						},
						&litMatcher{
							pos:        position{line: 444, col: 43, offset: 12110},
							val:        "i32",
							ignoreCase: false,
						},
						&litMatcher{
							pos:        position{line: 444, col: 51, offset: 12118},
							val:        "i64",
							ignoreCase: false,
						},
						&litMatcher{
							pos:        position{line: 444, col: 59, offset: 12126},
							val:        "double",
							ignoreCase: false,
						},
						&litMatcher{
							pos:        position{line: 444, col: 70, offset: 12137},
							val:        "string",
							ignoreCase: false,
						},
						&litMatcher{
							pos:        position{line: 444, col: 81, offset: 12148},
							val:        "binary",
							ignoreCase: false,
						},
					},
				},
			},
		},
		{
			name: "ContainerType",
			pos:  position{line: 448, col: 1, offset: 12192},
			expr: &actionExpr{
				pos: position{line: 448, col: 17, offset: 12210},
				run: (*parser).callonContainerType1,
				expr: &labeledExpr{
					pos:   position{line: 448, col: 17, offset: 12210},
					label: "typ",
					expr: &choiceExpr{
						pos: position{line: 448, col: 22, offset: 12215},
						alternatives: []interface{}{
							&ruleRefExpr{
								pos:  position{line: 448, col: 22, offset: 12215},
								name: "MapType",
							},
							&ruleRefExpr{
								pos:  position{line: 448, col: 32, offset: 12225},
								name: "SetType",
							},
							&ruleRefExpr{
								pos:  position{line: 448, col: 42, offset: 12235},
								name: "ListType",
							},
						},
					},
				},
			},
		},
		{
			name: "MapType",
			pos:  position{line: 452, col: 1, offset: 12267},
			expr: &actionExpr{
				pos: position{line: 452, col: 11, offset: 12279},
				run: (*parser).callonMapType1,
				expr: &seqExpr{
					pos: position{line: 452, col: 11, offset: 12279},
					exprs: []interface{}{
						&zeroOrOneExpr{
							pos: position{line: 452, col: 11, offset: 12279},
							expr: &ruleRefExpr{
								pos:  position{line: 452, col: 11, offset: 12279},
								name: "CppType",
							},
						},
						&litMatcher{
							pos:        position{line: 452, col: 20, offset: 12288},
							val:        "map",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 452, col: 26, offset: 12294},
							name: "WS",
						},
						&litMatcher{
							pos:        position{line: 452, col: 29, offset: 12297},
							val:        "<",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 452, col: 33, offset: 12301},
							name: "WS",
						},
						&labeledExpr{
							pos:   position{line: 452, col: 36, offset: 12304},
							label: "key",
							expr: &ruleRefExpr{
								pos:  position{line: 452, col: 40, offset: 12308},
								name: "FieldType",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 452, col: 50, offset: 12318},
							name: "WS",
						},
						&litMatcher{
							pos:        position{line: 452, col: 53, offset: 12321},
							val:        ",",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 452, col: 57, offset: 12325},
							name: "WS",
						},
						&labeledExpr{
							pos:   position{line: 452, col: 60, offset: 12328},
							label: "value",
							expr: &ruleRefExpr{
								pos:  position{line: 452, col: 66, offset: 12334},
								name: "FieldType",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 452, col: 76, offset: 12344},
							name: "WS",
						},
						&litMatcher{
							pos:        position{line: 452, col: 79, offset: 12347},
							val:        ">",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 452, col: 83, offset: 12351},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 452, col: 85, offset: 12353},
							label: "annotations",
							expr: &zeroOrOneExpr{
								pos: position{line: 452, col: 97, offset: 12365},
								expr: &ruleRefExpr{
									pos:  position{line: 452, col: 97, offset: 12365},
									name: "TypeAnnotations",
								},
							},
						},
					},
				},
			},
		},
		{
			name: "SetType",
			pos:  position{line: 462, col: 1, offset: 12543},
			expr: &actionExpr{
				pos: position{line: 462, col: 11, offset: 12555},
				run: (*parser).callonSetType1,
				expr: &seqExpr{
					pos: position{line: 462, col: 11, offset: 12555},
					exprs: []interface{}{
						&zeroOrOneExpr{
							pos: position{line: 462, col: 11, offset: 12555},
							expr: &ruleRefExpr{
								pos:  position{line: 462, col: 11, offset: 12555},
								name: "CppType",
							},
						},
						&litMatcher{
							pos:        position{line: 462, col: 20, offset: 12564},
							val:        "set",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 462, col: 26, offset: 12570},
							name: "WS",
						},
						&litMatcher{
							pos:        position{line: 462, col: 29, offset: 12573},
							val:        "<",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 462, col: 33, offset: 12577},
							name: "WS",
						},
						&labeledExpr{
							pos:   position{line: 462, col: 36, offset: 12580},
							label: "typ",
							expr: &ruleRefExpr{
								pos:  position{line: 462, col: 40, offset: 12584},
								name: "FieldType",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 462, col: 50, offset: 12594},
							name: "WS",
						},
						&litMatcher{
							pos:        position{line: 462, col: 53, offset: 12597},
							val:        ">",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 462, col: 57, offset: 12601},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 462, col: 59, offset: 12603},
							label: "annotations",
							expr: &zeroOrOneExpr{
								pos: position{line: 462, col: 71, offset: 12615},
								expr: &ruleRefExpr{
									pos:  position{line: 462, col: 71, offset: 12615},
									name: "TypeAnnotations",
								},
							},
						},
					},
				},
			},
		},
		{
			name: "ListType",
			pos:  position{line: 471, col: 1, offset: 12767},
			expr: &actionExpr{
				pos: position{line: 471, col: 12, offset: 12780},
				run: (*parser).callonListType1,
				expr: &seqExpr{
					pos: position{line: 471, col: 12, offset: 12780},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 471, col: 12, offset: 12780},
							val:        "list",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 471, col: 19, offset: 12787},
							name: "WS",
						},
						&litMatcher{
							pos:        position{line: 471, col: 22, offset: 12790},
							val:        "<",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 471, col: 26, offset: 12794},
							name: "WS",
						},
						&labeledExpr{
							pos:   position{line: 471, col: 29, offset: 12797},
							label: "typ",
							expr: &ruleRefExpr{
								pos:  position{line: 471, col: 33, offset: 12801},
								name: "FieldType",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 471, col: 43, offset: 12811},
							name: "WS",
						},
						&litMatcher{
							pos:        position{line: 471, col: 46, offset: 12814},
							val:        ">",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 471, col: 50, offset: 12818},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 471, col: 52, offset: 12820},
							label: "annotations",
							expr: &zeroOrOneExpr{
								pos: position{line: 471, col: 64, offset: 12832},
								expr: &ruleRefExpr{
									pos:  position{line: 471, col: 64, offset: 12832},
									name: "TypeAnnotations",
								},
							},
						},
					},
				},
			},
		},
		{
			name: "CppType",
			pos:  position{line: 480, col: 1, offset: 12985},
			expr: &actionExpr{
				pos: position{line: 480, col: 11, offset: 12997},
				run: (*parser).callonCppType1,
				expr: &seqExpr{
					pos: position{line: 480, col: 11, offset: 12997},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 480, col: 11, offset: 12997},
							val:        "cpp_type",
							ignoreCase: false,
						},
						&labeledExpr{
							pos:   position{line: 480, col: 22, offset: 13008},
							label: "cppType",
							expr: &ruleRefExpr{
								pos:  position{line: 480, col: 30, offset: 13016},
								name: "Literal",
							},
						},
					},
				},
			},
		},
		{
			name: "ConstValue",
			pos:  position{line: 484, col: 1, offset: 13050},
			expr: &choiceExpr{
				pos: position{line: 484, col: 14, offset: 13065},
				alternatives: []interface{}{
					&ruleRefExpr{
						pos:  position{line: 484, col: 14, offset: 13065},
						name: "Literal",
					},
					&ruleRefExpr{
						pos:  position{line: 484, col: 24, offset: 13075},
						name: "DoubleConstant",
					},
					&ruleRefExpr{
						pos:  position{line: 484, col: 41, offset: 13092},
						name: "IntConstant",
					},
					&ruleRefExpr{
						pos:  position{line: 484, col: 55, offset: 13106},
						name: "ConstMap",
					},
					&ruleRefExpr{
						pos:  position{line: 484, col: 66, offset: 13117},
						name: "ConstList",
					},
					&ruleRefExpr{
						pos:  position{line: 484, col: 78, offset: 13129},
						name: "Identifier",
					},
				},
			},
		},
		{
			name: "TypeAnnotations",
			pos:  position{line: 486, col: 1, offset: 13141},
			expr: &actionExpr{
				pos: position{line: 486, col: 19, offset: 13161},
				run: (*parser).callonTypeAnnotations1,
				expr: &seqExpr{
					pos: position{line: 486, col: 19, offset: 13161},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 486, col: 19, offset: 13161},
							val:        "(",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 486, col: 23, offset: 13165},
							name: "__",
						},
						&labeledExpr{
							pos:   position{line: 486, col: 26, offset: 13168},
							label: "annotations",
							expr: &zeroOrMoreExpr{
								pos: position{line: 486, col: 38, offset: 13180},
								expr: &ruleRefExpr{
									pos:  position{line: 486, col: 38, offset: 13180},
									name: "TypeAnnotation",
								},
							},
						},
						&litMatcher{
							pos:        position{line: 486, col: 54, offset: 13196},
							val:        ")",
							ignoreCase: false,
						},
					},
				},
			},
		},
		{
			name: "TypeAnnotation",
			pos:  position{line: 494, col: 1, offset: 13342},
			expr: &actionExpr{
				pos: position{line: 494, col: 18, offset: 13361},
				run: (*parser).callonTypeAnnotation1,
				expr: &seqExpr{
					pos: position{line: 494, col: 18, offset: 13361},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 494, col: 18, offset: 13361},
							label: "name",
							expr: &ruleRefExpr{
								pos:  position{line: 494, col: 23, offset: 13366},
								name: "Identifier",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 494, col: 34, offset: 13377},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 494, col: 36, offset: 13379},
							label: "value",
							expr: &zeroOrOneExpr{
								pos: position{line: 494, col: 42, offset: 13385},
								expr: &actionExpr{
									pos: position{line: 494, col: 43, offset: 13386},
									run: (*parser).callonTypeAnnotation8,
									expr: &seqExpr{
										pos: position{line: 494, col: 43, offset: 13386},
										exprs: []interface{}{
											&litMatcher{
												pos:        position{line: 494, col: 43, offset: 13386},
												val:        "=",
												ignoreCase: false,
											},
											&ruleRefExpr{
												pos:  position{line: 494, col: 47, offset: 13390},
												name: "__",
											},
											&labeledExpr{
												pos:   position{line: 494, col: 50, offset: 13393},
												label: "value",
												expr: &ruleRefExpr{
													pos:  position{line: 494, col: 56, offset: 13399},
													name: "Literal",
												},
											},
										},
									},
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 494, col: 88, offset: 13431},
							expr: &ruleRefExpr{
								pos:  position{line: 494, col: 88, offset: 13431},
								name: "ListSeparator",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 494, col: 103, offset: 13446},
							name: "__",
						},
					},
				},
			},
		},
		{
			name: "IntConstant",
			pos:  position{line: 506, col: 1, offset: 13631},
			expr: &actionExpr{
				pos: position{line: 506, col: 15, offset: 13647},
				run: (*parser).callonIntConstant1,
				expr: &seqExpr{
					pos: position{line: 506, col: 15, offset: 13647},
					exprs: []interface{}{
						&zeroOrOneExpr{
							pos: position{line: 506, col: 15, offset: 13647},
							expr: &charClassMatcher{
								pos:        position{line: 506, col: 15, offset: 13647},
								val:        "[-+]",
								chars:      []rune{'-', '+'},
								ignoreCase: false,
								inverted:   false,
							},
						},
						&oneOrMoreExpr{
							pos: position{line: 506, col: 21, offset: 13653},
							expr: &ruleRefExpr{
								pos:  position{line: 506, col: 21, offset: 13653},
								name: "Digit",
							},
						},
					},
				},
			},
		},
		{
			name: "DoubleConstant",
			pos:  position{line: 510, col: 1, offset: 13714},
			expr: &actionExpr{
				pos: position{line: 510, col: 18, offset: 13733},
				run: (*parser).callonDoubleConstant1,
				expr: &seqExpr{
					pos: position{line: 510, col: 18, offset: 13733},
					exprs: []interface{}{
						&zeroOrOneExpr{
							pos: position{line: 510, col: 18, offset: 13733},
							expr: &charClassMatcher{
								pos:        position{line: 510, col: 18, offset: 13733},
								val:        "[+-]",
								chars:      []rune{'+', '-'},
								ignoreCase: false,
								inverted:   false,
							},
						},
						&zeroOrMoreExpr{
							pos: position{line: 510, col: 24, offset: 13739},
							expr: &ruleRefExpr{
								pos:  position{line: 510, col: 24, offset: 13739},
								name: "Digit",
							},
						},
						&litMatcher{
							pos:        position{line: 510, col: 31, offset: 13746},
							val:        ".",
							ignoreCase: false,
						},
						&zeroOrMoreExpr{
							pos: position{line: 510, col: 35, offset: 13750},
							expr: &ruleRefExpr{
								pos:  position{line: 510, col: 35, offset: 13750},
								name: "Digit",
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 510, col: 42, offset: 13757},
							expr: &seqExpr{
								pos: position{line: 510, col: 44, offset: 13759},
								exprs: []interface{}{
									&charClassMatcher{
										pos:        position{line: 510, col: 44, offset: 13759},
										val:        "['Ee']",
										chars:      []rune{'\'', 'E', 'e', '\''},
										ignoreCase: false,
										inverted:   false,
									},
									&ruleRefExpr{
										pos:  position{line: 510, col: 51, offset: 13766},
										name: "IntConstant",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "ConstList",
			pos:  position{line: 514, col: 1, offset: 13833},
			expr: &actionExpr{
				pos: position{line: 514, col: 13, offset: 13847},
				run: (*parser).callonConstList1,
				expr: &seqExpr{
					pos: position{line: 514, col: 13, offset: 13847},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 514, col: 13, offset: 13847},
							val:        "[",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 514, col: 17, offset: 13851},
							name: "__",
						},
						&labeledExpr{
							pos:   position{line: 514, col: 20, offset: 13854},
							label: "values",
							expr: &zeroOrMoreExpr{
								pos: position{line: 514, col: 27, offset: 13861},
								expr: &seqExpr{
									pos: position{line: 514, col: 28, offset: 13862},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 514, col: 28, offset: 13862},
											name: "ConstValue",
										},
										&ruleRefExpr{
											pos:  position{line: 514, col: 39, offset: 13873},
											name: "__",
										},
										&zeroOrOneExpr{
											pos: position{line: 514, col: 42, offset: 13876},
											expr: &ruleRefExpr{
												pos:  position{line: 514, col: 42, offset: 13876},
												name: "ListSeparator",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 514, col: 57, offset: 13891},
											name: "__",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 514, col: 62, offset: 13896},
							name: "__",
						},
						&litMatcher{
							pos:        position{line: 514, col: 65, offset: 13899},
							val:        "]",
							ignoreCase: false,
						},
					},
				},
			},
		},
		{
			name: "ConstMap",
			pos:  position{line: 523, col: 1, offset: 14072},
			expr: &actionExpr{
				pos: position{line: 523, col: 12, offset: 14085},
				run: (*parser).callonConstMap1,
				expr: &seqExpr{
					pos: position{line: 523, col: 12, offset: 14085},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 523, col: 12, offset: 14085},
							val:        "{",
							ignoreCase: false,
						},
						&ruleRefExpr{
							pos:  position{line: 523, col: 16, offset: 14089},
							name: "__",
						},
						&labeledExpr{
							pos:   position{line: 523, col: 19, offset: 14092},
							label: "values",
							expr: &zeroOrMoreExpr{
								pos: position{line: 523, col: 26, offset: 14099},
								expr: &seqExpr{
									pos: position{line: 523, col: 27, offset: 14100},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 523, col: 27, offset: 14100},
											name: "ConstValue",
										},
										&ruleRefExpr{
											pos:  position{line: 523, col: 38, offset: 14111},
											name: "__",
										},
										&litMatcher{
											pos:        position{line: 523, col: 41, offset: 14114},
											val:        ":",
											ignoreCase: false,
										},
										&ruleRefExpr{
											pos:  position{line: 523, col: 45, offset: 14118},
											name: "__",
										},
										&ruleRefExpr{
											pos:  position{line: 523, col: 48, offset: 14121},
											name: "ConstValue",
										},
										&ruleRefExpr{
											pos:  position{line: 523, col: 59, offset: 14132},
											name: "__",
										},
										&choiceExpr{
											pos: position{line: 523, col: 63, offset: 14136},
											alternatives: []interface{}{
												&litMatcher{
													pos:        position{line: 523, col: 63, offset: 14136},
													val:        ",",
													ignoreCase: false,
												},
												&andExpr{
													pos: position{line: 523, col: 69, offset: 14142},
													expr: &litMatcher{
														pos:        position{line: 523, col: 70, offset: 14143},
														val:        "}",
														ignoreCase: false,
													},
												},
											},
										},
										&ruleRefExpr{
											pos:  position{line: 523, col: 75, offset: 14148},
											name: "__",
										},
									},
								},
							},
						},
						&litMatcher{
							pos:        position{line: 523, col: 80, offset: 14153},
							val:        "}",
							ignoreCase: false,
						},
					},
				},
			},
		},
		{
			name: "Literal",
			pos:  position{line: 539, col: 1, offset: 14399},
			expr: &actionExpr{
				pos: position{line: 539, col: 11, offset: 14411},
				run: (*parser).callonLiteral1,
				expr: &choiceExpr{
					pos: position{line: 539, col: 12, offset: 14412},
					alternatives: []interface{}{
						&seqExpr{
							pos: position{line: 539, col: 13, offset: 14413},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 539, col: 13, offset: 14413},
									val:        "\"",
									ignoreCase: false,
								},
								&zeroOrMoreExpr{
									pos: position{line: 539, col: 17, offset: 14417},
									expr: &choiceExpr{
										pos: position{line: 539, col: 18, offset: 14418},
										alternatives: []interface{}{
											&litMatcher{
												pos:        position{line: 539, col: 18, offset: 14418},
												val:        "\\\"",
												ignoreCase: false,
											},
											&charClassMatcher{
												pos:        position{line: 539, col: 25, offset: 14425},
												val:        "[^\"]",
												chars:      []rune{'"'},
												ignoreCase: false,
												inverted:   true,
											},
										},
									},
								},
								&litMatcher{
									pos:        position{line: 539, col: 32, offset: 14432},
									val:        "\"",
									ignoreCase: false,
								},
							},
						},
						&seqExpr{
							pos: position{line: 539, col: 40, offset: 14440},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 539, col: 40, offset: 14440},
									val:        "'",
									ignoreCase: false,
								},
								&zeroOrMoreExpr{
									pos: position{line: 539, col: 45, offset: 14445},
									expr: &choiceExpr{
										pos: position{line: 539, col: 46, offset: 14446},
										alternatives: []interface{}{
											&litMatcher{
												pos:        position{line: 539, col: 46, offset: 14446},
												val:        "\\'",
												ignoreCase: false,
											},
											&charClassMatcher{
												pos:        position{line: 539, col: 53, offset: 14453},
												val:        "[^']",
												chars:      []rune{'\''},
												ignoreCase: false,
												inverted:   true,
											},
										},
									},
								},
								&litMatcher{
									pos:        position{line: 539, col: 60, offset: 14460},
									val:        "'",
									ignoreCase: false,
								},
							},
						},
					},
				},
			},
		},
		{
			name: "Identifier",
			pos:  position{line: 546, col: 1, offset: 14661},
			expr: &actionExpr{
				pos: position{line: 546, col: 14, offset: 14676},
				run: (*parser).callonIdentifier1,
				expr: &seqExpr{
					pos: position{line: 546, col: 14, offset: 14676},
					exprs: []interface{}{
						&oneOrMoreExpr{
							pos: position{line: 546, col: 14, offset: 14676},
							expr: &choiceExpr{
								pos: position{line: 546, col: 15, offset: 14677},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 546, col: 15, offset: 14677},
										name: "Letter",
									},
									&litMatcher{
										pos:        position{line: 546, col: 24, offset: 14686},
										val:        "_",
										ignoreCase: false,
									},
								},
							},
						},
						&zeroOrMoreExpr{
							pos: position{line: 546, col: 30, offset: 14692},
							expr: &choiceExpr{
								pos: position{line: 546, col: 31, offset: 14693},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 546, col: 31, offset: 14693},
										name: "Letter",
									},
									&ruleRefExpr{
										pos:  position{line: 546, col: 40, offset: 14702},
										name: "Digit",
									},
									&charClassMatcher{
										pos:        position{line: 546, col: 48, offset: 14710},
										val:        "[._]",
										chars:      []rune{'.', '_'},
										ignoreCase: false,
										inverted:   false,
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "ListSeparator",
			pos:  position{line: 550, col: 1, offset: 14762},
			expr: &charClassMatcher{
				pos:        position{line: 550, col: 17, offset: 14780},
				val:        "[,;]",
				chars:      []rune{',', ';'},
				ignoreCase: false,
				inverted:   false,
			},
		},
		{
			name: "Letter",
			pos:  position{line: 551, col: 1, offset: 14785},
			expr: &charClassMatcher{
				pos:        position{line: 551, col: 10, offset: 14796},
				val:        "[A-Za-z]",
				ranges:     []rune{'A', 'Z', 'a', 'z'},
				ignoreCase: false,
				inverted:   false,
			},
		},
		{
			name: "Digit",
			pos:  position{line: 552, col: 1, offset: 14805},
			expr: &charClassMatcher{
				pos:        position{line: 552, col: 9, offset: 14815},
				val:        "[0-9]",
				ranges:     []rune{'0', '9'},
				ignoreCase: false,
				inverted:   false,
			},
		},
		{
			name: "SourceChar",
			pos:  position{line: 556, col: 1, offset: 14826},
			expr: &anyMatcher{
				line: 556, col: 14, offset: 14841,
			},
		},
		{
			name: "Comment",
			pos:  position{line: 557, col: 1, offset: 14843},
			expr: &choiceExpr{
				pos: position{line: 557, col: 11, offset: 14855},
				alternatives: []interface{}{
					&ruleRefExpr{
						pos:  position{line: 557, col: 11, offset: 14855},
						name: "MultiLineComment",
					},
					&ruleRefExpr{
						pos:  position{line: 557, col: 30, offset: 14874},
						name: "SingleLineComment",
					},
				},
			},
		},
		{
			name: "MultiLineComment",
			pos:  position{line: 558, col: 1, offset: 14892},
			expr: &seqExpr{
				pos: position{line: 558, col: 20, offset: 14913},
				exprs: []interface{}{
					&choiceExpr{
						pos: position{line: 558, col: 21, offset: 14914},
						alternatives: []interface{}{
							&litMatcher{
								pos:        position{line: 558, col: 21, offset: 14914},
								val:        "/*",
								ignoreCase: false,
							},
							&litMatcher{
								pos:        position{line: 558, col: 28, offset: 14921},
								val:        "/**",
								ignoreCase: false,
							},
						},
					},
					&zeroOrMoreExpr{
						pos: position{line: 558, col: 35, offset: 14928},
						expr: &seqExpr{
							pos: position{line: 558, col: 37, offset: 14930},
							exprs: []interface{}{
								&notExpr{
									pos: position{line: 558, col: 37, offset: 14930},
									expr: &choiceExpr{
										pos: position{line: 558, col: 39, offset: 14932},
										alternatives: []interface{}{
											&litMatcher{
												pos:        position{line: 558, col: 39, offset: 14932},
												val:        "*/",
												ignoreCase: false,
											},
											&litMatcher{
												pos:        position{line: 558, col: 46, offset: 14939},
												val:        "**/",
												ignoreCase: false,
											},
										},
									},
								},
								&ruleRefExpr{
									pos:  position{line: 558, col: 53, offset: 14946},
									name: "SourceChar",
								},
							},
						},
					},
					&choiceExpr{
						pos: position{line: 558, col: 68, offset: 14961},
						alternatives: []interface{}{
							&litMatcher{
								pos:        position{line: 558, col: 68, offset: 14961},
								val:        "*/",
								ignoreCase: false,
							},
							&litMatcher{
								pos:        position{line: 558, col: 75, offset: 14968},
								val:        "**/",
								ignoreCase: false,
							},
						},
					},
				},
			},
		},
		{
			name: "MultiLineCommentNoLineTerminator",
			pos:  position{line: 559, col: 1, offset: 14975},
			expr: &seqExpr{
				pos: position{line: 559, col: 36, offset: 15012},
				exprs: []interface{}{
					&litMatcher{
						pos:        position{line: 559, col: 36, offset: 15012},
						val:        "/*",
						ignoreCase: false,
					},
					&zeroOrMoreExpr{
						pos: position{line: 559, col: 41, offset: 15017},
						expr: &seqExpr{
							pos: position{line: 559, col: 43, offset: 15019},
							exprs: []interface{}{
								&notExpr{
									pos: position{line: 559, col: 43, offset: 15019},
									expr: &choiceExpr{
										pos: position{line: 559, col: 46, offset: 15022},
										alternatives: []interface{}{
											&litMatcher{
												pos:        position{line: 559, col: 46, offset: 15022},
												val:        "*/",
												ignoreCase: false,
											},
											&ruleRefExpr{
												pos:  position{line: 559, col: 53, offset: 15029},
												name: "EOL",
											},
										},
									},
								},
								&ruleRefExpr{
									pos:  position{line: 559, col: 59, offset: 15035},
									name: "SourceChar",
								},
							},
						},
					},
					&litMatcher{
						pos:        position{line: 559, col: 73, offset: 15049},
						val:        "*/",
						ignoreCase: false,
					},
				},
			},
		},
		{
			name: "SingleLineComment",
			pos:  position{line: 560, col: 1, offset: 15054},
			expr: &choiceExpr{
				pos: position{line: 560, col: 21, offset: 15076},
				alternatives: []interface{}{
					&seqExpr{
						pos: position{line: 560, col: 22, offset: 15077},
						exprs: []interface{}{
							&litMatcher{
								pos:        position{line: 560, col: 22, offset: 15077},
								val:        "//",
								ignoreCase: false,
							},
							&zeroOrMoreExpr{
								pos: position{line: 560, col: 27, offset: 15082},
								expr: &seqExpr{
									pos: position{line: 560, col: 29, offset: 15084},
									exprs: []interface{}{
										&notExpr{
											pos: position{line: 560, col: 29, offset: 15084},
											expr: &ruleRefExpr{
												pos:  position{line: 560, col: 30, offset: 15085},
												name: "EOL",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 560, col: 34, offset: 15089},
											name: "SourceChar",
										},
									},
								},
							},
						},
					},
					&seqExpr{
						pos: position{line: 560, col: 52, offset: 15107},
						exprs: []interface{}{
							&litMatcher{
								pos:        position{line: 560, col: 52, offset: 15107},
								val:        "#",
								ignoreCase: false,
							},
							&zeroOrMoreExpr{
								pos: position{line: 560, col: 56, offset: 15111},
								expr: &seqExpr{
									pos: position{line: 560, col: 58, offset: 15113},
									exprs: []interface{}{
										&notExpr{
											pos: position{line: 560, col: 58, offset: 15113},
											expr: &ruleRefExpr{
												pos:  position{line: 560, col: 59, offset: 15114},
												name: "EOL",
											},
										},
										&ruleRefExpr{
											pos:  position{line: 560, col: 63, offset: 15118},
											name: "SourceChar",
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "__",
			pos:  position{line: 562, col: 1, offset: 15134},
			expr: &zeroOrMoreExpr{
				pos: position{line: 562, col: 6, offset: 15141},
				expr: &choiceExpr{
					pos: position{line: 562, col: 8, offset: 15143},
					alternatives: []interface{}{
						&ruleRefExpr{
							pos:  position{line: 562, col: 8, offset: 15143},
							name: "Whitespace",
						},
						&ruleRefExpr{
							pos:  position{line: 562, col: 21, offset: 15156},
							name: "EOL",
						},
						&ruleRefExpr{
							pos:  position{line: 562, col: 27, offset: 15162},
							name: "Comment",
						},
					},
				},
			},
		},
		{
			name: "_",
			pos:  position{line: 563, col: 1, offset: 15173},
			expr: &zeroOrMoreExpr{
				pos: position{line: 563, col: 5, offset: 15179},
				expr: &choiceExpr{
					pos: position{line: 563, col: 7, offset: 15181},
					alternatives: []interface{}{
						&ruleRefExpr{
							pos:  position{line: 563, col: 7, offset: 15181},
							name: "Whitespace",
						},
						&ruleRefExpr{
							pos:  position{line: 563, col: 20, offset: 15194},
							name: "MultiLineCommentNoLineTerminator",
						},
					},
				},
			},
		},
		{
			name: "WS",
			pos:  position{line: 564, col: 1, offset: 15230},
			expr: &zeroOrMoreExpr{
				pos: position{line: 564, col: 6, offset: 15237},
				expr: &ruleRefExpr{
					pos:  position{line: 564, col: 6, offset: 15237},
					name: "Whitespace",
				},
			},
		},
		{
			name: "Whitespace",
			pos:  position{line: 566, col: 1, offset: 15250},
			expr: &charClassMatcher{
				pos:        position{line: 566, col: 14, offset: 15265},
				val:        "[ \\t\\r]",
				chars:      []rune{' ', '\t', '\r'},
				ignoreCase: false,
				inverted:   false,
			},
		},
		{
			name: "EOL",
			pos:  position{line: 567, col: 1, offset: 15273},
			expr: &litMatcher{
				pos:        position{line: 567, col: 7, offset: 15281},
				val:        "\n",
				ignoreCase: false,
			},
		},
		{
			name: "EOS",
			pos:  position{line: 568, col: 1, offset: 15286},
			expr: &choiceExpr{
				pos: position{line: 568, col: 7, offset: 15294},
				alternatives: []interface{}{
					&seqExpr{
						pos: position{line: 568, col: 7, offset: 15294},
						exprs: []interface{}{
							&ruleRefExpr{
								pos:  position{line: 568, col: 7, offset: 15294},
								name: "__",
							},
							&litMatcher{
								pos:        position{line: 568, col: 10, offset: 15297},
								val:        ";",
								ignoreCase: false,
							},
						},
					},
					&seqExpr{
						pos: position{line: 568, col: 16, offset: 15303},
						exprs: []interface{}{
							&ruleRefExpr{
								pos:  position{line: 568, col: 16, offset: 15303},
								name: "_",
							},
							&zeroOrOneExpr{
								pos: position{line: 568, col: 18, offset: 15305},
								expr: &ruleRefExpr{
									pos:  position{line: 568, col: 18, offset: 15305},
									name: "SingleLineComment",
								},
							},
							&ruleRefExpr{
								pos:  position{line: 568, col: 37, offset: 15324},
								name: "EOL",
							},
						},
					},
					&seqExpr{
						pos: position{line: 568, col: 43, offset: 15330},
						exprs: []interface{}{
							&ruleRefExpr{
								pos:  position{line: 568, col: 43, offset: 15330},
								name: "__",
							},
							&ruleRefExpr{
								pos:  position{line: 568, col: 46, offset: 15333},
								name: "EOF",
							},
						},
					},
				},
			},
		},
		{
			name: "EOF",
			pos:  position{line: 570, col: 1, offset: 15338},
			expr: &notExpr{
				pos: position{line: 570, col: 7, offset: 15346},
				expr: &anyMatcher{
					line: 570, col: 8, offset: 15347,
				},
			},
		},
	},
}

func (c *current) onGrammar1(statements interface{}) (interface{}, error) {
	thrift := &Thrift{
		Includes:   make(map[string]string),
		Namespaces: make(map[string]string),
		Typedefs:   make(map[string]*Typedef),
		Constants:  make(map[string]*Constant),
		Enums:      make(map[string]*Enum),
		Structs:    make(map[string]*Struct),
		Exceptions: make(map[string]*Struct),
		Unions:     make(map[string]*Struct),
		Services:   make(map[string]*Service),
	}
	stmts := toIfaceSlice(statements)
	for _, st := range stmts {
		switch v := st.(type) {
		case *namespace:
			thrift.Namespaces[v.scope] = v.namespace
		case *Constant:
			thrift.Constants[v.Name] = v
		case *Enum:
			thrift.Enums[v.Name] = v
		case *Typedef:
			thrift.Typedefs[v.Alias] = v
		case *Struct:
			thrift.Structs[v.Name] = v
		case exception:
			thrift.Exceptions[v.Name] = (*Struct)(v)
		case union:
			thrift.Unions[v.Name] = unionToStruct(v)
		case *Service:
			thrift.Services[v.Name] = v
		case include:
			name := filepath.Base(string(v))
			if ix := strings.LastIndex(name, "."); ix > 0 {
				name = name[:ix]
			}
			thrift.Includes[name] = string(v)
		default:
			return nil, fmt.Errorf("parser: unknown value %#v", v)
		}
	}
	return thrift, nil
}

func (p *parser) callonGrammar1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onGrammar1(stack["statements"])
}

func (c *current) onSyntaxError1() (interface{}, error) {
	return nil, errors.New("parser: syntax error")
}

func (p *parser) callonSyntaxError1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSyntaxError1()
}

func (c *current) onInclude1(blockComment, file interface{}) (interface{}, error) {
	return include(file.(string)), nil
}

func (p *parser) callonInclude1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onInclude1(stack["blockComment"], stack["file"])
}

func (c *current) onNamespace1(blockComment, scope, ns interface{}) (interface{}, error) {
	return &namespace{
		scope:     ifaceSliceToString(scope),
		namespace: string(ns.(Identifier)),
	}, nil
}

func (p *parser) callonNamespace1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onNamespace1(stack["blockComment"], stack["scope"], stack["ns"])
}

func (c *current) onConst1(blockComment, typ, name, value, comment interface{}) (interface{}, error) {
	con := &Constant{
		Pos:   makePos(c.pos),
		Name:  string(name.(Identifier)),
		Type:  typ.(*Type),
		Value: value,
	}
	if comment != nil {
		con.Comment = ifaceSliceToCommentString(comment)
	}
	if blockComment != nil {
		bc := ifaceSliceToBlockComment(blockComment)
		if bc != "" {
			con.Comment = bc
		}
	}
	return con, nil
}

func (p *parser) callonConst1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onConst1(stack["blockComment"], stack["typ"], stack["name"], stack["value"], stack["comment"])
}

func (c *current) onEnum1(blockComment, name, values, annotations interface{}) (interface{}, error) {
	vs := toIfaceSlice(values)
	en := &Enum{
		Pos:         makePos(c.pos),
		Name:        string(name.(Identifier)),
		Values:      make(map[string]*EnumValue, len(vs)),
		Annotations: toAnnotations(annotations),
	}
	// Assigns numbers in order. This will behave badly if some values are
	// defined and other are not, but I think that's ok since that's a silly
	// thing to do.
	next := 0
	for _, v := range vs {
		ev := v.(*EnumValue)
		if ev.Value < 0 {
			ev.Value = next
		}
		if ev.Value >= next {
			next = ev.Value + 1
		}
		en.Values[ev.Name] = ev
	}
	if blockComment != nil {
		bc := ifaceSliceToBlockComment(blockComment)
		if bc != "" {
			en.Comment = bc
		}
	}
	return en, nil
}

func (p *parser) callonEnum1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onEnum1(stack["blockComment"], stack["name"], stack["values"], stack["annotations"])
}

func (c *current) onEnumValue1(blockComment, name, value, annotations, comment interface{}) (interface{}, error) {
	ev := &EnumValue{
		Pos:         makePos(c.pos),
		Name:        string(name.(Identifier)),
		Value:       -1,
		Annotations: toAnnotations(annotations),
	}
	if value != nil {
		ev.Value = int(value.([]interface{})[2].(int64))
	}
	if comment != nil {
		ev.Comment = ifaceSliceToCommentString(comment)
	}
	if blockComment != nil {
		bc := ifaceSliceToBlockComment(blockComment)
		if bc != "" {
			ev.Comment = bc
		}
	}
	return ev, nil
}

func (p *parser) callonEnumValue1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onEnumValue1(stack["blockComment"], stack["name"], stack["value"], stack["annotations"], stack["comment"])
}

func (c *current) onTypeDef1(blockComment, typ, name, annotations interface{}) (interface{}, error) {
	return &Typedef{
		Pos:         makePos(c.pos),
		Type:        typ.(*Type),
		Alias:       string(name.(Identifier)),
		Annotations: toAnnotations(annotations),
	}, nil
}

func (p *parser) callonTypeDef1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onTypeDef1(stack["blockComment"], stack["typ"], stack["name"], stack["annotations"])
}

func (c *current) onStruct1(blockComment, st interface{}) (interface{}, error) {
	stc := st.(*Struct)
	if blockComment != nil {
		bc := ifaceSliceToBlockComment(blockComment)
		if bc != "" {
			stc.Comment = bc
		}
	}
	return stc, nil
}

func (p *parser) callonStruct1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onStruct1(stack["blockComment"], stack["st"])
}

func (c *current) onException1(blockComment, st interface{}) (interface{}, error) {
	stc := st.(*Struct)
	if blockComment != nil {
		bc := ifaceSliceToBlockComment(blockComment)
		if bc != "" {
			stc.Comment = bc
		}
	}
	return exception(stc), nil
}

func (p *parser) callonException1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onException1(stack["blockComment"], stack["st"])
}

func (c *current) onUnion1(blockComment, st interface{}) (interface{}, error) {
	stc := st.(*Struct)
	if blockComment != nil {
		bc := ifaceSliceToBlockComment(blockComment)
		if bc != "" {
			stc.Comment = bc
		}
	}
	return union(stc), nil
}

func (p *parser) callonUnion1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onUnion1(stack["blockComment"], stack["st"])
}

func (c *current) onStructLike1(name, fields, annotations interface{}) (interface{}, error) {
	st := &Struct{
		Pos:         makePos(c.pos),
		Name:        string(name.(Identifier)),
		Annotations: toAnnotations(annotations),
	}
	if fields != nil {
		st.Fields = fields.([]*Field)
	}
	return st, nil
}

func (p *parser) callonStructLike1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onStructLike1(stack["name"], stack["fields"], stack["annotations"])
}

func (c *current) onFieldList1(fields interface{}) (interface{}, error) {
	fs := fields.([]interface{})
	flds := make([]*Field, len(fs))
	for i, f := range fs {
		flds[i] = f.([]interface{})[0].(*Field)
	}
	return flds, nil
}

func (p *parser) callonFieldList1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldList1(stack["fields"])
}

func (c *current) onField1(blockComment, id, req, typ, name, def, annotations, comment interface{}) (interface{}, error) {
	f := &Field{
		Pos:         makePos(c.pos),
		ID:          int(id.(int64)),
		Name:        string(name.(Identifier)),
		Type:        typ.(*Type),
		Annotations: toAnnotations(annotations),
	}
	if req != nil && !req.(bool) {
		f.Optional = true
	}
	if def != nil {
		f.Default = def.([]interface{})[2]
	}
	if comment != nil {
		f.Comment = ifaceSliceToCommentString(comment)
	}
	if blockComment != nil {
		bc := ifaceSliceToBlockComment(blockComment)
		if bc != "" {
			f.Comment = bc
		}
	}
	return f, nil
}

func (p *parser) callonField1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onField1(stack["blockComment"], stack["id"], stack["req"], stack["typ"], stack["name"], stack["def"], stack["annotations"], stack["comment"])
}

func (c *current) onFieldReq1() (interface{}, error) {
	return !bytes.Equal(c.text, []byte("optional")), nil
}

func (p *parser) callonFieldReq1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldReq1()
}

func (c *current) onService1(blockComment, name, extends, methods, annotations interface{}) (interface{}, error) {
	ms := methods.([]interface{})
	svc := &Service{
		Pos:         makePos(c.pos),
		Name:        string(name.(Identifier)),
		Methods:     make(map[string]*Method, len(ms)),
		Annotations: toAnnotations(annotations),
	}
	if extends != nil {
		svc.Extends = string(extends.([]interface{})[2].(Identifier))
	}
	for _, m := range ms {
		mt := m.(*Method)
		svc.Methods[mt.Name] = mt
	}
	if blockComment != nil {
		bc := ifaceSliceToBlockComment(blockComment)
		if bc != "" {
			svc.Comment = bc
		}
	}
	return svc, nil
}

func (p *parser) callonService1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onService1(stack["blockComment"], stack["name"], stack["extends"], stack["methods"], stack["annotations"])
}

func (c *current) onEndOfServiceError1() (interface{}, error) {
	return nil, errors.New("parser: expected end of service")
}

func (p *parser) callonEndOfServiceError1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onEndOfServiceError1()
}

func (c *current) onFunction1(blockComment, oneway, typ, name, arguments, exceptions, annotations, comment interface{}) (interface{}, error) {
	m := &Method{
		Pos:         makePos(c.pos),
		Name:        string(name.(Identifier)),
		Annotations: toAnnotations(annotations),
	}
	t := typ.(*Type)
	if t.Name != "void" {
		m.ReturnType = t
	}
	if oneway != nil {
		m.Oneway = true
	}
	if arguments != nil {
		m.Arguments = arguments.([]*Field)
	}
	if exceptions != nil {
		m.Exceptions = exceptions.([]*Field)
		for _, e := range m.Exceptions {
			e.Optional = true
		}
	}
	if comment != nil {
		m.Comment = ifaceSliceToCommentString(comment)
	}
	if blockComment != nil {
		bc := ifaceSliceToBlockComment(blockComment)
		if bc != "" {
			m.Comment = bc
		}
	}
	return m, nil
}

func (p *parser) callonFunction1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFunction1(stack["blockComment"], stack["oneway"], stack["typ"], stack["name"], stack["arguments"], stack["exceptions"], stack["annotations"], stack["comment"])
}

func (c *current) onFunctionType1(typ interface{}) (interface{}, error) {
	if t, ok := typ.(*Type); ok {
		return t, nil
	}
	return &Type{
		Pos:  makePos(c.pos),
		Name: string(c.text),
	}, nil
}

func (p *parser) callonFunctionType1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFunctionType1(stack["typ"])
}

func (c *current) onThrows1(exceptions interface{}) (interface{}, error) {
	return exceptions, nil
}

func (p *parser) callonThrows1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onThrows1(stack["exceptions"])
}

func (c *current) onFieldType1(typ interface{}) (interface{}, error) {
	if t, ok := typ.(Identifier); ok {
		return &Type{
			Pos:  makePos(c.pos),
			Name: string(t),
		}, nil
	}
	return typ, nil
}

func (p *parser) callonFieldType1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldType1(stack["typ"])
}

func (c *current) onDefinitionType1(typ interface{}) (interface{}, error) {
	return typ, nil
}

func (p *parser) callonDefinitionType1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDefinitionType1(stack["typ"])
}

func (c *current) onBaseType1(name, annotations interface{}) (interface{}, error) {
	return &Type{
		Pos:         makePos(c.pos),
		Name:        name.(string),
		Annotations: toAnnotations(annotations),
	}, nil
}

func (p *parser) callonBaseType1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onBaseType1(stack["name"], stack["annotations"])
}

func (c *current) onBaseTypeName1() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonBaseTypeName1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onBaseTypeName1()
}

func (c *current) onContainerType1(typ interface{}) (interface{}, error) {
	return typ, nil
}

func (p *parser) callonContainerType1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onContainerType1(stack["typ"])
}

func (c *current) onMapType1(key, value, annotations interface{}) (interface{}, error) {
	return &Type{
		Pos:         makePos(c.pos),
		Name:        "map",
		KeyType:     key.(*Type),
		ValueType:   value.(*Type),
		Annotations: toAnnotations(annotations),
	}, nil
}

func (p *parser) callonMapType1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onMapType1(stack["key"], stack["value"], stack["annotations"])
}

func (c *current) onSetType1(typ, annotations interface{}) (interface{}, error) {
	return &Type{
		Pos:         makePos(c.pos),
		Name:        "set",
		ValueType:   typ.(*Type),
		Annotations: toAnnotations(annotations),
	}, nil
}

func (p *parser) callonSetType1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSetType1(stack["typ"], stack["annotations"])
}

func (c *current) onListType1(typ, annotations interface{}) (interface{}, error) {
	return &Type{
		Pos:         makePos(c.pos),
		Name:        "list",
		ValueType:   typ.(*Type),
		Annotations: toAnnotations(annotations),
	}, nil
}

func (p *parser) callonListType1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onListType1(stack["typ"], stack["annotations"])
}

func (c *current) onCppType1(cppType interface{}) (interface{}, error) {
	return cppType, nil
}

func (p *parser) callonCppType1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onCppType1(stack["cppType"])
}

func (c *current) onTypeAnnotations1(annotations interface{}) (interface{}, error) {
	var anns []*Annotation
	for _, ann := range annotations.([]interface{}) {
		anns = append(anns, ann.(*Annotation))
	}
	return anns, nil
}

func (p *parser) callonTypeAnnotations1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onTypeAnnotations1(stack["annotations"])
}

func (c *current) onTypeAnnotation8(value interface{}) (interface{}, error) {
	return value, nil
}

func (p *parser) callonTypeAnnotation8() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onTypeAnnotation8(stack["value"])
}

func (c *current) onTypeAnnotation1(name, value interface{}) (interface{}, error) {
	var optValue string
	if value != nil {
		optValue = value.(string)
	}
	return &Annotation{
		Pos:   makePos(c.pos),
		Name:  string(name.(Identifier)),
		Value: optValue,
	}, nil
}

func (p *parser) callonTypeAnnotation1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onTypeAnnotation1(stack["name"], stack["value"])
}

func (c *current) onIntConstant1() (interface{}, error) {
	return strconv.ParseInt(string(c.text), 10, 64)
}

func (p *parser) callonIntConstant1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIntConstant1()
}

func (c *current) onDoubleConstant1() (interface{}, error) {
	return strconv.ParseFloat(string(c.text), 64)
}

func (p *parser) callonDoubleConstant1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDoubleConstant1()
}

func (c *current) onConstList1(values interface{}) (interface{}, error) {
	valueSlice := values.([]interface{})
	vs := make([]interface{}, len(valueSlice))
	for i, v := range valueSlice {
		vs[i] = v.([]interface{})[0]
	}
	return vs, nil
}

func (p *parser) callonConstList1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onConstList1(stack["values"])
}

func (c *current) onConstMap1(values interface{}) (interface{}, error) {
	if values == nil {
		return nil, nil
	}
	vals := values.([]interface{})
	kvs := make([]KeyValue, len(vals))
	for i, kv := range vals {
		v := kv.([]interface{})
		kvs[i] = KeyValue{
			Key:   v[0],
			Value: v[4],
		}
	}
	return kvs, nil
}

func (p *parser) callonConstMap1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onConstMap1(stack["values"])
}

func (c *current) onLiteral1() (interface{}, error) {
	if len(c.text) != 0 && c.text[0] == '\'' {
		return strconv.Unquote(`"` + strings.Replace(string(c.text[1:len(c.text)-1]), `\'`, `'`, -1) + `"`)
	}
	return strconv.Unquote(string(c.text))
}

func (p *parser) callonLiteral1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLiteral1()
}

func (c *current) onIdentifier1() (interface{}, error) {
	return Identifier(string(c.text)), nil
}

func (p *parser) callonIdentifier1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier1()
}

var (
	// errNoRule is returned when the grammar to parse has no rule.
	errNoRule = errors.New("grammar has no rule")

	// errInvalidEncoding is returned when the source is not properly
	// utf8-encoded.
	errInvalidEncoding = errors.New("invalid encoding")

	// errNoMatch is returned if no match could be found.
	errNoMatch = errors.New("no match found")
)

// Option is a function that can set an option on the parser. It returns
// the previous setting as an Option.
type Option func(*parser) Option

// Debug creates an Option to set the debug flag to b. When set to true,
// debugging information is printed to stdout while parsing.
//
// The default is false.
func Debug(b bool) Option {
	return func(p *parser) Option {
		old := p.debug
		p.debug = b
		return Debug(old)
	}
}

// Memoize creates an Option to set the memoize flag to b. When set to true,
// the parser will cache all results so each expression is evaluated only
// once. This guarantees linear parsing time even for pathological cases,
// at the expense of more memory and slower times for typical cases.
//
// The default is false.
func Memoize(b bool) Option {
	return func(p *parser) Option {
		old := p.memoize
		p.memoize = b
		return Memoize(old)
	}
}

// Recover creates an Option to set the recover flag to b. When set to
// true, this causes the parser to recover from panics and convert it
// to an error. Setting it to false can be useful while debugging to
// access the full stack trace.
//
// The default is true.
func Recover(b bool) Option {
	return func(p *parser) Option {
		old := p.recover
		p.recover = b
		return Recover(old)
	}
}

// ParseFile parses the file identified by filename.
func ParseFile(filename string, opts ...Option) (interface{}, error) {
	f, err := os.Open(filename)
	if err != nil {
		return nil, err
	}
	defer f.Close()
	return ParseReader(filename, f, opts...)
}

// ParseReader parses the data from r using filename as information in the
// error messages.
func ParseReader(filename string, r io.Reader, opts ...Option) (interface{}, error) {
	b, err := ioutil.ReadAll(r)
	if err != nil {
		return nil, err
	}

	return Parse(filename, b, opts...)
}

// Parse parses the data from b using filename as information in the
// error messages.
func Parse(filename string, b []byte, opts ...Option) (interface{}, error) {
	return newParser(filename, b, opts...).parse(g)
}

// position records a position in the text.
type position struct {
	line, col, offset int
}

func (p position) String() string {
	return fmt.Sprintf("%d:%d [%d]", p.line, p.col, p.offset)
}

// savepoint stores all state required to go back to this point in the
// parser.
type savepoint struct {
	position
	rn rune
	w  int
}

type current struct {
	pos  position // start position of the match
	text []byte   // raw text of the match
}

// the AST types...

type grammar struct {
	pos   position
	rules []*rule
}

type rule struct {
	pos         position
	name        string
	displayName string
	expr        interface{}
}

type choiceExpr struct {
	pos          position
	alternatives []interface{}
}

type actionExpr struct {
	pos  position
	expr interface{}
	run  func(*parser) (interface{}, error)
}

type seqExpr struct {
	pos   position
	exprs []interface{}
}

type labeledExpr struct {
	pos   position
	label string
	expr  interface{}
}

type expr struct {
	pos  position
	expr interface{}
}

type andExpr expr
type notExpr expr
type zeroOrOneExpr expr
type zeroOrMoreExpr expr
type oneOrMoreExpr expr

type ruleRefExpr struct {
	pos  position
	name string
}

type andCodeExpr struct {
	pos position
	run func(*parser) (bool, error)
}

type notCodeExpr struct {
	pos position
	run func(*parser) (bool, error)
}

type litMatcher struct {
	pos        position
	val        string
	ignoreCase bool
}

type charClassMatcher struct {
	pos        position
	val        string
	chars      []rune
	ranges     []rune
	classes    []*unicode.RangeTable
	ignoreCase bool
	inverted   bool
}

type anyMatcher position

// errList cumulates the errors found by the parser.
type errList []error

func (e *errList) add(err error) {
	*e = append(*e, err)
}

func (e errList) err() error {
	if len(e) == 0 {
		return nil
	}
	e.dedupe()
	return e
}

func (e *errList) dedupe() {
	var cleaned []error
	set := make(map[string]bool)
	for _, err := range *e {
		if msg := err.Error(); !set[msg] {
			set[msg] = true
			cleaned = append(cleaned, err)
		}
	}
	*e = cleaned
}

func (e errList) Error() string {
	switch len(e) {
	case 0:
		return ""
	case 1:
		return e[0].Error()
	default:
		var buf bytes.Buffer

		for i, err := range e {
			if i > 0 {
				buf.WriteRune('\n')
			}
			buf.WriteString(err.Error())
		}
		return buf.String()
	}
}

// parserError wraps an error with a prefix indicating the rule in which
// the error occurred. The original error is stored in the Inner field.
type parserError struct {
	Inner  error
	pos    position
	prefix string
}

// Error returns the error message.
func (p *parserError) Error() string {
	return p.prefix + ": " + p.Inner.Error()
}

// newParser creates a parser with the specified input source and options.
func newParser(filename string, b []byte, opts ...Option) *parser {
	p := &parser{
		filename: filename,
		errs:     new(errList),
		data:     b,
		pt:       savepoint{position: position{line: 1}},
		recover:  true,
	}
	p.setOptions(opts)
	return p
}

// setOptions applies the options to the parser.
func (p *parser) setOptions(opts []Option) {
	for _, opt := range opts {
		opt(p)
	}
}

type resultTuple struct {
	v   interface{}
	b   bool
	end savepoint
}

type parser struct {
	filename string
	pt       savepoint
	cur      current

	data []byte
	errs *errList

	recover bool
	debug   bool
	depth   int

	memoize bool
	// memoization table for the packrat algorithm:
	// map[offset in source] map[expression or rule] {value, match}
	memo map[int]map[interface{}]resultTuple

	// rules table, maps the rule identifier to the rule node
	rules map[string]*rule
	// variables stack, map of label to value
	vstack []map[string]interface{}
	// rule stack, allows identification of the current rule in errors
	rstack []*rule

	// stats
	exprCnt int
}

// push a variable set on the vstack.
func (p *parser) pushV() {
	if cap(p.vstack) == len(p.vstack) {
		// create new empty slot in the stack
		p.vstack = append(p.vstack, nil)
	} else {
		// slice to 1 more
		p.vstack = p.vstack[:len(p.vstack)+1]
	}

	// get the last args set
	m := p.vstack[len(p.vstack)-1]
	if m != nil && len(m) == 0 {
		// empty map, all good
		return
	}

	m = make(map[string]interface{})
	p.vstack[len(p.vstack)-1] = m
}

// pop a variable set from the vstack.
func (p *parser) popV() {
	// if the map is not empty, clear it
	m := p.vstack[len(p.vstack)-1]
	if len(m) > 0 {
		// GC that map
		p.vstack[len(p.vstack)-1] = nil
	}
	p.vstack = p.vstack[:len(p.vstack)-1]
}

func (p *parser) print(prefix, s string) string {
	if !p.debug {
		return s
	}

	fmt.Printf("%s %d:%d:%d: %s [%#U]\n",
		prefix, p.pt.line, p.pt.col, p.pt.offset, s, p.pt.rn)
	return s
}

func (p *parser) in(s string) string {
	p.depth++
	return p.print(strings.Repeat(" ", p.depth)+">", s)
}

func (p *parser) out(s string) string {
	p.depth--
	return p.print(strings.Repeat(" ", p.depth)+"<", s)
}

func (p *parser) addErr(err error) {
	p.addErrAt(err, p.pt.position)
}

func (p *parser) addErrAt(err error, pos position) {
	var buf bytes.Buffer
	if p.filename != "" {
		buf.WriteString(p.filename)
	}
	if buf.Len() > 0 {
		buf.WriteString(":")
	}
	buf.WriteString(fmt.Sprintf("%d:%d (%d)", pos.line, pos.col, pos.offset))
	if len(p.rstack) > 0 {
		if buf.Len() > 0 {
			buf.WriteString(": ")
		}
		rule := p.rstack[len(p.rstack)-1]
		if rule.displayName != "" {
			buf.WriteString("rule " + rule.displayName)
		} else {
			buf.WriteString("rule " + rule.name)
		}
	}
	pe := &parserError{Inner: err, pos: pos, prefix: buf.String()}
	p.errs.add(pe)
}

// read advances the parser to the next rune.
func (p *parser) read() {
	p.pt.offset += p.pt.w
	rn, n := utf8.DecodeRune(p.data[p.pt.offset:])
	p.pt.rn = rn
	p.pt.w = n
	p.pt.col++
	if rn == '\n' {
		p.pt.line++
		p.pt.col = 0
	}

	if rn == utf8.RuneError {
		if n == 1 {
			p.addErr(errInvalidEncoding)
		}
	}
}

// restore parser position to the savepoint pt.
func (p *parser) restore(pt savepoint) {
	if p.debug {
		defer p.out(p.in("restore"))
	}
	if pt.offset == p.pt.offset {
		return
	}
	p.pt = pt
}

// get the slice of bytes from the savepoint start to the current position.
func (p *parser) sliceFrom(start savepoint) []byte {
	return p.data[start.position.offset:p.pt.position.offset]
}

func (p *parser) getMemoized(node interface{}) (resultTuple, bool) {
	if len(p.memo) == 0 {
		return resultTuple{}, false
	}
	m := p.memo[p.pt.offset]
	if len(m) == 0 {
		return resultTuple{}, false
	}
	res, ok := m[node]
	return res, ok
}

func (p *parser) setMemoized(pt savepoint, node interface{}, tuple resultTuple) {
	if p.memo == nil {
		p.memo = make(map[int]map[interface{}]resultTuple)
	}
	m := p.memo[pt.offset]
	if m == nil {
		m = make(map[interface{}]resultTuple)
		p.memo[pt.offset] = m
	}
	m[node] = tuple
}

func (p *parser) buildRulesTable(g *grammar) {
	p.rules = make(map[string]*rule, len(g.rules))
	for _, r := range g.rules {
		p.rules[r.name] = r
	}
}

func (p *parser) parse(g *grammar) (val interface{}, err error) {
	if len(g.rules) == 0 {
		p.addErr(errNoRule)
		return nil, p.errs.err()
	}

	// TODO : not super critical but this could be generated
	p.buildRulesTable(g)

	if p.recover {
		// panic can be used in action code to stop parsing immediately
		// and return the panic as an error.
		defer func() {
			if e := recover(); e != nil {
				if p.debug {
					defer p.out(p.in("panic handler"))
				}
				val = nil
				switch e := e.(type) {
				case error:
					p.addErr(e)
				default:
					p.addErr(fmt.Errorf("%v", e))
				}
				err = p.errs.err()
			}
		}()
	}

	// start rule is rule [0]
	p.read() // advance to first rune
	val, ok := p.parseRule(g.rules[0])
	if !ok {
		if len(*p.errs) == 0 {
			// make sure this doesn't go out silently
			p.addErr(errNoMatch)
		}
		return nil, p.errs.err()
	}
	return val, p.errs.err()
}

func (p *parser) parseRule(rule *rule) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseRule " + rule.name))
	}

	if p.memoize {
		res, ok := p.getMemoized(rule)
		if ok {
			p.restore(res.end)
			return res.v, res.b
		}
	}

	start := p.pt
	p.rstack = append(p.rstack, rule)
	p.pushV()
	val, ok := p.parseExpr(rule.expr)
	p.popV()
	p.rstack = p.rstack[:len(p.rstack)-1]
	if ok && p.debug {
		p.print(strings.Repeat(" ", p.depth)+"MATCH", string(p.sliceFrom(start)))
	}

	if p.memoize {
		p.setMemoized(start, rule, resultTuple{val, ok, p.pt})
	}
	return val, ok
}

func (p *parser) parseExpr(expr interface{}) (interface{}, bool) {
	var pt savepoint
	var ok bool

	if p.memoize {
		res, ok := p.getMemoized(expr)
		if ok {
			p.restore(res.end)
			return res.v, res.b
		}
		pt = p.pt
	}

	p.exprCnt++
	var val interface{}
	switch expr := expr.(type) {
	case *actionExpr:
		val, ok = p.parseActionExpr(expr)
	case *andCodeExpr:
		val, ok = p.parseAndCodeExpr(expr)
	case *andExpr:
		val, ok = p.parseAndExpr(expr)
	case *anyMatcher:
		val, ok = p.parseAnyMatcher(expr)
	case *charClassMatcher:
		val, ok = p.parseCharClassMatcher(expr)
	case *choiceExpr:
		val, ok = p.parseChoiceExpr(expr)
	case *labeledExpr:
		val, ok = p.parseLabeledExpr(expr)
	case *litMatcher:
		val, ok = p.parseLitMatcher(expr)
	case *notCodeExpr:
		val, ok = p.parseNotCodeExpr(expr)
	case *notExpr:
		val, ok = p.parseNotExpr(expr)
	case *oneOrMoreExpr:
		val, ok = p.parseOneOrMoreExpr(expr)
	case *ruleRefExpr:
		val, ok = p.parseRuleRefExpr(expr)
	case *seqExpr:
		val, ok = p.parseSeqExpr(expr)
	case *zeroOrMoreExpr:
		val, ok = p.parseZeroOrMoreExpr(expr)
	case *zeroOrOneExpr:
		val, ok = p.parseZeroOrOneExpr(expr)
	default:
		panic(fmt.Sprintf("unknown expression type %T", expr))
	}
	if p.memoize {
		p.setMemoized(pt, expr, resultTuple{val, ok, p.pt})
	}
	return val, ok
}

func (p *parser) parseActionExpr(act *actionExpr) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseActionExpr"))
	}

	start := p.pt
	val, ok := p.parseExpr(act.expr)
	if ok {
		p.cur.pos = start.position
		p.cur.text = p.sliceFrom(start)
		actVal, err := act.run(p)
		if err != nil {
			p.addErrAt(err, start.position)
		}
		val = actVal
	}
	if ok && p.debug {
		p.print(strings.Repeat(" ", p.depth)+"MATCH", string(p.sliceFrom(start)))
	}
	return val, ok
}

func (p *parser) parseAndCodeExpr(and *andCodeExpr) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseAndCodeExpr"))
	}

	ok, err := and.run(p)
	if err != nil {
		p.addErr(err)
	}
	return nil, ok
}

func (p *parser) parseAndExpr(and *andExpr) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseAndExpr"))
	}

	pt := p.pt
	p.pushV()
	_, ok := p.parseExpr(and.expr)
	p.popV()
	p.restore(pt)
	return nil, ok
}

func (p *parser) parseAnyMatcher(any *anyMatcher) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseAnyMatcher"))
	}

	if p.pt.rn != utf8.RuneError {
		start := p.pt
		p.read()
		return p.sliceFrom(start), true
	}
	return nil, false
}

func (p *parser) parseCharClassMatcher(chr *charClassMatcher) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseCharClassMatcher"))
	}

	cur := p.pt.rn
	// can't match EOF
	if cur == utf8.RuneError {
		return nil, false
	}
	start := p.pt
	if chr.ignoreCase {
		cur = unicode.ToLower(cur)
	}

	// try to match in the list of available chars
	for _, rn := range chr.chars {
		if rn == cur {
			if chr.inverted {
				return nil, false
			}
			p.read()
			return p.sliceFrom(start), true
		}
	}

	// try to match in the list of ranges
	for i := 0; i < len(chr.ranges); i += 2 {
		if cur >= chr.ranges[i] && cur <= chr.ranges[i+1] {
			if chr.inverted {
				return nil, false
			}
			p.read()
			return p.sliceFrom(start), true
		}
	}

	// try to match in the list of Unicode classes
	for _, cl := range chr.classes {
		if unicode.Is(cl, cur) {
			if chr.inverted {
				return nil, false
			}
			p.read()
			return p.sliceFrom(start), true
		}
	}

	if chr.inverted {
		p.read()
		return p.sliceFrom(start), true
	}
	return nil, false
}

func (p *parser) parseChoiceExpr(ch *choiceExpr) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseChoiceExpr"))
	}

	for _, alt := range ch.alternatives {
		p.pushV()
		val, ok := p.parseExpr(alt)
		p.popV()
		if ok {
			return val, ok
		}
	}
	return nil, false
}

func (p *parser) parseLabeledExpr(lab *labeledExpr) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseLabeledExpr"))
	}

	p.pushV()
	val, ok := p.parseExpr(lab.expr)
	p.popV()
	if ok && lab.label != "" {
		m := p.vstack[len(p.vstack)-1]
		m[lab.label] = val
	}
	return val, ok
}

func (p *parser) parseLitMatcher(lit *litMatcher) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseLitMatcher"))
	}

	start := p.pt
	for _, want := range lit.val {
		cur := p.pt.rn
		if lit.ignoreCase {
			cur = unicode.ToLower(cur)
		}
		if cur != want {
			p.restore(start)
			return nil, false
		}
		p.read()
	}
	return p.sliceFrom(start), true
}

func (p *parser) parseNotCodeExpr(not *notCodeExpr) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseNotCodeExpr"))
	}

	ok, err := not.run(p)
	if err != nil {
		p.addErr(err)
	}
	return nil, !ok
}

func (p *parser) parseNotExpr(not *notExpr) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseNotExpr"))
	}

	pt := p.pt
	p.pushV()
	_, ok := p.parseExpr(not.expr)
	p.popV()
	p.restore(pt)
	return nil, !ok
}

func (p *parser) parseOneOrMoreExpr(expr *oneOrMoreExpr) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseOneOrMoreExpr"))
	}

	var vals []interface{}

	for {
		p.pushV()
		val, ok := p.parseExpr(expr.expr)
		p.popV()
		if !ok {
			if len(vals) == 0 {
				// did not match once, no match
				return nil, false
			}
			return vals, true
		}
		vals = append(vals, val)
	}
}

func (p *parser) parseRuleRefExpr(ref *ruleRefExpr) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseRuleRefExpr " + ref.name))
	}

	if ref.name == "" {
		panic(fmt.Sprintf("%s: invalid rule: missing name", ref.pos))
	}

	rule := p.rules[ref.name]
	if rule == nil {
		p.addErr(fmt.Errorf("undefined rule: %s", ref.name))
		return nil, false
	}
	return p.parseRule(rule)
}

func (p *parser) parseSeqExpr(seq *seqExpr) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseSeqExpr"))
	}

	var vals []interface{}

	pt := p.pt
	for _, expr := range seq.exprs {
		val, ok := p.parseExpr(expr)
		if !ok {
			p.restore(pt)
			return nil, false
		}
		vals = append(vals, val)
	}
	return vals, true
}

func (p *parser) parseZeroOrMoreExpr(expr *zeroOrMoreExpr) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseZeroOrMoreExpr"))
	}

	var vals []interface{}

	for {
		p.pushV()
		val, ok := p.parseExpr(expr.expr)
		p.popV()
		if !ok {
			return vals, true
		}
		vals = append(vals, val)
	}
}

func (p *parser) parseZeroOrOneExpr(expr *zeroOrOneExpr) (interface{}, bool) {
	if p.debug {
		defer p.out(p.in("parseZeroOrOneExpr"))
	}

	p.pushV()
	val, _ := p.parseExpr(expr.expr)
	p.popV()
	// whether it matched or not, consider it a match
	return val, true
}

func rangeTable(class string) *unicode.RangeTable {
	if rt, ok := unicode.Categories[class]; ok {
		return rt
	}
	if rt, ok := unicode.Properties[class]; ok {
		return rt
	}
	if rt, ok := unicode.Scripts[class]; ok {
		return rt
	}

	// cannot happen
	panic(fmt.Sprintf("invalid Unicode class: %s", class))
}
