// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/iam/v3/principal_access_boundary_policies_service.proto

package iampb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PrincipalAccessBoundaryPolicies_CreatePrincipalAccessBoundaryPolicy_FullMethodName         = "/google.iam.v3.PrincipalAccessBoundaryPolicies/CreatePrincipalAccessBoundaryPolicy"
	PrincipalAccessBoundaryPolicies_GetPrincipalAccessBoundaryPolicy_FullMethodName            = "/google.iam.v3.PrincipalAccessBoundaryPolicies/GetPrincipalAccessBoundaryPolicy"
	PrincipalAccessBoundaryPolicies_UpdatePrincipalAccessBoundaryPolicy_FullMethodName         = "/google.iam.v3.PrincipalAccessBoundaryPolicies/UpdatePrincipalAccessBoundaryPolicy"
	PrincipalAccessBoundaryPolicies_DeletePrincipalAccessBoundaryPolicy_FullMethodName         = "/google.iam.v3.PrincipalAccessBoundaryPolicies/DeletePrincipalAccessBoundaryPolicy"
	PrincipalAccessBoundaryPolicies_ListPrincipalAccessBoundaryPolicies_FullMethodName         = "/google.iam.v3.PrincipalAccessBoundaryPolicies/ListPrincipalAccessBoundaryPolicies"
	PrincipalAccessBoundaryPolicies_SearchPrincipalAccessBoundaryPolicyBindings_FullMethodName = "/google.iam.v3.PrincipalAccessBoundaryPolicies/SearchPrincipalAccessBoundaryPolicyBindings"
)

// PrincipalAccessBoundaryPoliciesClient is the client API for PrincipalAccessBoundaryPolicies service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PrincipalAccessBoundaryPoliciesClient interface {
	// Creates a principal access boundary policy, and returns a long running
	// operation.
	CreatePrincipalAccessBoundaryPolicy(ctx context.Context, in *CreatePrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a principal access boundary policy.
	GetPrincipalAccessBoundaryPolicy(ctx context.Context, in *GetPrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*PrincipalAccessBoundaryPolicy, error)
	// Updates a principal access boundary policy.
	UpdatePrincipalAccessBoundaryPolicy(ctx context.Context, in *UpdatePrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a principal access boundary policy.
	DeletePrincipalAccessBoundaryPolicy(ctx context.Context, in *DeletePrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists principal access boundary policies.
	ListPrincipalAccessBoundaryPolicies(ctx context.Context, in *ListPrincipalAccessBoundaryPoliciesRequest, opts ...grpc.CallOption) (*ListPrincipalAccessBoundaryPoliciesResponse, error)
	// Returns all policy bindings that bind a specific policy if a user has
	// searchPolicyBindings permission on that policy.
	SearchPrincipalAccessBoundaryPolicyBindings(ctx context.Context, in *SearchPrincipalAccessBoundaryPolicyBindingsRequest, opts ...grpc.CallOption) (*SearchPrincipalAccessBoundaryPolicyBindingsResponse, error)
}

type principalAccessBoundaryPoliciesClient struct {
	cc grpc.ClientConnInterface
}

func NewPrincipalAccessBoundaryPoliciesClient(cc grpc.ClientConnInterface) PrincipalAccessBoundaryPoliciesClient {
	return &principalAccessBoundaryPoliciesClient{cc}
}

func (c *principalAccessBoundaryPoliciesClient) CreatePrincipalAccessBoundaryPolicy(ctx context.Context, in *CreatePrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PrincipalAccessBoundaryPolicies_CreatePrincipalAccessBoundaryPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *principalAccessBoundaryPoliciesClient) GetPrincipalAccessBoundaryPolicy(ctx context.Context, in *GetPrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*PrincipalAccessBoundaryPolicy, error) {
	out := new(PrincipalAccessBoundaryPolicy)
	err := c.cc.Invoke(ctx, PrincipalAccessBoundaryPolicies_GetPrincipalAccessBoundaryPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *principalAccessBoundaryPoliciesClient) UpdatePrincipalAccessBoundaryPolicy(ctx context.Context, in *UpdatePrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PrincipalAccessBoundaryPolicies_UpdatePrincipalAccessBoundaryPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *principalAccessBoundaryPoliciesClient) DeletePrincipalAccessBoundaryPolicy(ctx context.Context, in *DeletePrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PrincipalAccessBoundaryPolicies_DeletePrincipalAccessBoundaryPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *principalAccessBoundaryPoliciesClient) ListPrincipalAccessBoundaryPolicies(ctx context.Context, in *ListPrincipalAccessBoundaryPoliciesRequest, opts ...grpc.CallOption) (*ListPrincipalAccessBoundaryPoliciesResponse, error) {
	out := new(ListPrincipalAccessBoundaryPoliciesResponse)
	err := c.cc.Invoke(ctx, PrincipalAccessBoundaryPolicies_ListPrincipalAccessBoundaryPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *principalAccessBoundaryPoliciesClient) SearchPrincipalAccessBoundaryPolicyBindings(ctx context.Context, in *SearchPrincipalAccessBoundaryPolicyBindingsRequest, opts ...grpc.CallOption) (*SearchPrincipalAccessBoundaryPolicyBindingsResponse, error) {
	out := new(SearchPrincipalAccessBoundaryPolicyBindingsResponse)
	err := c.cc.Invoke(ctx, PrincipalAccessBoundaryPolicies_SearchPrincipalAccessBoundaryPolicyBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PrincipalAccessBoundaryPoliciesServer is the server API for PrincipalAccessBoundaryPolicies service.
// All implementations should embed UnimplementedPrincipalAccessBoundaryPoliciesServer
// for forward compatibility
type PrincipalAccessBoundaryPoliciesServer interface {
	// Creates a principal access boundary policy, and returns a long running
	// operation.
	CreatePrincipalAccessBoundaryPolicy(context.Context, *CreatePrincipalAccessBoundaryPolicyRequest) (*longrunningpb.Operation, error)
	// Gets a principal access boundary policy.
	GetPrincipalAccessBoundaryPolicy(context.Context, *GetPrincipalAccessBoundaryPolicyRequest) (*PrincipalAccessBoundaryPolicy, error)
	// Updates a principal access boundary policy.
	UpdatePrincipalAccessBoundaryPolicy(context.Context, *UpdatePrincipalAccessBoundaryPolicyRequest) (*longrunningpb.Operation, error)
	// Deletes a principal access boundary policy.
	DeletePrincipalAccessBoundaryPolicy(context.Context, *DeletePrincipalAccessBoundaryPolicyRequest) (*longrunningpb.Operation, error)
	// Lists principal access boundary policies.
	ListPrincipalAccessBoundaryPolicies(context.Context, *ListPrincipalAccessBoundaryPoliciesRequest) (*ListPrincipalAccessBoundaryPoliciesResponse, error)
	// Returns all policy bindings that bind a specific policy if a user has
	// searchPolicyBindings permission on that policy.
	SearchPrincipalAccessBoundaryPolicyBindings(context.Context, *SearchPrincipalAccessBoundaryPolicyBindingsRequest) (*SearchPrincipalAccessBoundaryPolicyBindingsResponse, error)
}

// UnimplementedPrincipalAccessBoundaryPoliciesServer should be embedded to have forward compatible implementations.
type UnimplementedPrincipalAccessBoundaryPoliciesServer struct {
}

func (UnimplementedPrincipalAccessBoundaryPoliciesServer) CreatePrincipalAccessBoundaryPolicy(context.Context, *CreatePrincipalAccessBoundaryPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePrincipalAccessBoundaryPolicy not implemented")
}
func (UnimplementedPrincipalAccessBoundaryPoliciesServer) GetPrincipalAccessBoundaryPolicy(context.Context, *GetPrincipalAccessBoundaryPolicyRequest) (*PrincipalAccessBoundaryPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrincipalAccessBoundaryPolicy not implemented")
}
func (UnimplementedPrincipalAccessBoundaryPoliciesServer) UpdatePrincipalAccessBoundaryPolicy(context.Context, *UpdatePrincipalAccessBoundaryPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePrincipalAccessBoundaryPolicy not implemented")
}
func (UnimplementedPrincipalAccessBoundaryPoliciesServer) DeletePrincipalAccessBoundaryPolicy(context.Context, *DeletePrincipalAccessBoundaryPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePrincipalAccessBoundaryPolicy not implemented")
}
func (UnimplementedPrincipalAccessBoundaryPoliciesServer) ListPrincipalAccessBoundaryPolicies(context.Context, *ListPrincipalAccessBoundaryPoliciesRequest) (*ListPrincipalAccessBoundaryPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrincipalAccessBoundaryPolicies not implemented")
}
func (UnimplementedPrincipalAccessBoundaryPoliciesServer) SearchPrincipalAccessBoundaryPolicyBindings(context.Context, *SearchPrincipalAccessBoundaryPolicyBindingsRequest) (*SearchPrincipalAccessBoundaryPolicyBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchPrincipalAccessBoundaryPolicyBindings not implemented")
}

// UnsafePrincipalAccessBoundaryPoliciesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PrincipalAccessBoundaryPoliciesServer will
// result in compilation errors.
type UnsafePrincipalAccessBoundaryPoliciesServer interface {
	mustEmbedUnimplementedPrincipalAccessBoundaryPoliciesServer()
}

func RegisterPrincipalAccessBoundaryPoliciesServer(s grpc.ServiceRegistrar, srv PrincipalAccessBoundaryPoliciesServer) {
	s.RegisterService(&PrincipalAccessBoundaryPolicies_ServiceDesc, srv)
}

func _PrincipalAccessBoundaryPolicies_CreatePrincipalAccessBoundaryPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePrincipalAccessBoundaryPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrincipalAccessBoundaryPoliciesServer).CreatePrincipalAccessBoundaryPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PrincipalAccessBoundaryPolicies_CreatePrincipalAccessBoundaryPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrincipalAccessBoundaryPoliciesServer).CreatePrincipalAccessBoundaryPolicy(ctx, req.(*CreatePrincipalAccessBoundaryPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrincipalAccessBoundaryPolicies_GetPrincipalAccessBoundaryPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPrincipalAccessBoundaryPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrincipalAccessBoundaryPoliciesServer).GetPrincipalAccessBoundaryPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PrincipalAccessBoundaryPolicies_GetPrincipalAccessBoundaryPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrincipalAccessBoundaryPoliciesServer).GetPrincipalAccessBoundaryPolicy(ctx, req.(*GetPrincipalAccessBoundaryPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrincipalAccessBoundaryPolicies_UpdatePrincipalAccessBoundaryPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePrincipalAccessBoundaryPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrincipalAccessBoundaryPoliciesServer).UpdatePrincipalAccessBoundaryPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PrincipalAccessBoundaryPolicies_UpdatePrincipalAccessBoundaryPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrincipalAccessBoundaryPoliciesServer).UpdatePrincipalAccessBoundaryPolicy(ctx, req.(*UpdatePrincipalAccessBoundaryPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrincipalAccessBoundaryPolicies_DeletePrincipalAccessBoundaryPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePrincipalAccessBoundaryPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrincipalAccessBoundaryPoliciesServer).DeletePrincipalAccessBoundaryPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PrincipalAccessBoundaryPolicies_DeletePrincipalAccessBoundaryPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrincipalAccessBoundaryPoliciesServer).DeletePrincipalAccessBoundaryPolicy(ctx, req.(*DeletePrincipalAccessBoundaryPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrincipalAccessBoundaryPolicies_ListPrincipalAccessBoundaryPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrincipalAccessBoundaryPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrincipalAccessBoundaryPoliciesServer).ListPrincipalAccessBoundaryPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PrincipalAccessBoundaryPolicies_ListPrincipalAccessBoundaryPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrincipalAccessBoundaryPoliciesServer).ListPrincipalAccessBoundaryPolicies(ctx, req.(*ListPrincipalAccessBoundaryPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrincipalAccessBoundaryPolicies_SearchPrincipalAccessBoundaryPolicyBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchPrincipalAccessBoundaryPolicyBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrincipalAccessBoundaryPoliciesServer).SearchPrincipalAccessBoundaryPolicyBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PrincipalAccessBoundaryPolicies_SearchPrincipalAccessBoundaryPolicyBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrincipalAccessBoundaryPoliciesServer).SearchPrincipalAccessBoundaryPolicyBindings(ctx, req.(*SearchPrincipalAccessBoundaryPolicyBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PrincipalAccessBoundaryPolicies_ServiceDesc is the grpc.ServiceDesc for PrincipalAccessBoundaryPolicies service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PrincipalAccessBoundaryPolicies_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.iam.v3.PrincipalAccessBoundaryPolicies",
	HandlerType: (*PrincipalAccessBoundaryPoliciesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePrincipalAccessBoundaryPolicy",
			Handler:    _PrincipalAccessBoundaryPolicies_CreatePrincipalAccessBoundaryPolicy_Handler,
		},
		{
			MethodName: "GetPrincipalAccessBoundaryPolicy",
			Handler:    _PrincipalAccessBoundaryPolicies_GetPrincipalAccessBoundaryPolicy_Handler,
		},
		{
			MethodName: "UpdatePrincipalAccessBoundaryPolicy",
			Handler:    _PrincipalAccessBoundaryPolicies_UpdatePrincipalAccessBoundaryPolicy_Handler,
		},
		{
			MethodName: "DeletePrincipalAccessBoundaryPolicy",
			Handler:    _PrincipalAccessBoundaryPolicies_DeletePrincipalAccessBoundaryPolicy_Handler,
		},
		{
			MethodName: "ListPrincipalAccessBoundaryPolicies",
			Handler:    _PrincipalAccessBoundaryPolicies_ListPrincipalAccessBoundaryPolicies_Handler,
		},
		{
			MethodName: "SearchPrincipalAccessBoundaryPolicyBindings",
			Handler:    _PrincipalAccessBoundaryPolicies_SearchPrincipalAccessBoundaryPolicyBindings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/iam/v3/principal_access_boundary_policies_service.proto",
}
