/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1 "sigs.k8s.io/gateway-api/apis/v1"
)

// GRPCRouteLister helps list GRPCRoutes.
// All objects returned here must be treated as read-only.
type GRPCRouteLister interface {
	// List lists all GRPCRoutes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.GRPCRoute, err error)
	// GRPCRoutes returns an object that can list and get GRPCRoutes.
	GRPCRoutes(namespace string) GRPCRouteNamespaceLister
	GRPCRouteListerExpansion
}

// gRPCRouteLister implements the GRPCRouteLister interface.
type gRPCRouteLister struct {
	indexer cache.Indexer
}

// NewGRPCRouteLister returns a new GRPCRouteLister.
func NewGRPCRouteLister(indexer cache.Indexer) GRPCRouteLister {
	return &gRPCRouteLister{indexer: indexer}
}

// List lists all GRPCRoutes in the indexer.
func (s *gRPCRouteLister) List(selector labels.Selector) (ret []*v1.GRPCRoute, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.GRPCRoute))
	})
	return ret, err
}

// GRPCRoutes returns an object that can list and get GRPCRoutes.
func (s *gRPCRouteLister) GRPCRoutes(namespace string) GRPCRouteNamespaceLister {
	return gRPCRouteNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// GRPCRouteNamespaceLister helps list and get GRPCRoutes.
// All objects returned here must be treated as read-only.
type GRPCRouteNamespaceLister interface {
	// List lists all GRPCRoutes in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.GRPCRoute, err error)
	// Get retrieves the GRPCRoute from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.GRPCRoute, error)
	GRPCRouteNamespaceListerExpansion
}

// gRPCRouteNamespaceLister implements the GRPCRouteNamespaceLister
// interface.
type gRPCRouteNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all GRPCRoutes in the indexer for a given namespace.
func (s gRPCRouteNamespaceLister) List(selector labels.Selector) (ret []*v1.GRPCRoute, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.GRPCRoute))
	})
	return ret, err
}

// Get retrieves the GRPCRoute from the indexer for a given namespace and name.
func (s gRPCRouteNamespaceLister) Get(name string) (*v1.GRPCRoute, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("grpcroute"), name)
	}
	return obj.(*v1.GRPCRoute), nil
}
