// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/tool.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// These are available confidence level user can set to block malicious urls
// with chosen confidence and above. For understanding different confidence of
// webrisk, please refer to
// https://cloud.google.com/web-risk/docs/reference/rpc/google.cloud.webrisk.v1eap1#confidencelevel
type Tool_PhishBlockThreshold int32

const (
	// Defaults to unspecified.
	Tool_PHISH_BLOCK_THRESHOLD_UNSPECIFIED Tool_PhishBlockThreshold = 0
	// Blocks Low and above confidence URL that is risky.
	Tool_BLOCK_LOW_AND_ABOVE Tool_PhishBlockThreshold = 30
	// Blocks Medium and above confidence URL that is risky.
	Tool_BLOCK_MEDIUM_AND_ABOVE Tool_PhishBlockThreshold = 40
	// Blocks High and above confidence URL that is risky.
	Tool_BLOCK_HIGH_AND_ABOVE Tool_PhishBlockThreshold = 50
	// Blocks Higher and above confidence URL that is risky.
	Tool_BLOCK_HIGHER_AND_ABOVE Tool_PhishBlockThreshold = 55
	// Blocks Very high and above confidence URL that is risky.
	Tool_BLOCK_VERY_HIGH_AND_ABOVE Tool_PhishBlockThreshold = 60
	// Blocks Extremely high confidence URL that is risky.
	Tool_BLOCK_ONLY_EXTREMELY_HIGH Tool_PhishBlockThreshold = 100
)

// Enum value maps for Tool_PhishBlockThreshold.
var (
	Tool_PhishBlockThreshold_name = map[int32]string{
		0:   "PHISH_BLOCK_THRESHOLD_UNSPECIFIED",
		30:  "BLOCK_LOW_AND_ABOVE",
		40:  "BLOCK_MEDIUM_AND_ABOVE",
		50:  "BLOCK_HIGH_AND_ABOVE",
		55:  "BLOCK_HIGHER_AND_ABOVE",
		60:  "BLOCK_VERY_HIGH_AND_ABOVE",
		100: "BLOCK_ONLY_EXTREMELY_HIGH",
	}
	Tool_PhishBlockThreshold_value = map[string]int32{
		"PHISH_BLOCK_THRESHOLD_UNSPECIFIED": 0,
		"BLOCK_LOW_AND_ABOVE":               30,
		"BLOCK_MEDIUM_AND_ABOVE":            40,
		"BLOCK_HIGH_AND_ABOVE":              50,
		"BLOCK_HIGHER_AND_ABOVE":            55,
		"BLOCK_VERY_HIGH_AND_ABOVE":         60,
		"BLOCK_ONLY_EXTREMELY_HIGH":         100,
	}
)

func (x Tool_PhishBlockThreshold) Enum() *Tool_PhishBlockThreshold {
	p := new(Tool_PhishBlockThreshold)
	*p = x
	return p
}

func (x Tool_PhishBlockThreshold) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_PhishBlockThreshold) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[0].Descriptor()
}

func (Tool_PhishBlockThreshold) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[0]
}

func (x Tool_PhishBlockThreshold) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_PhishBlockThreshold.Descriptor instead.
func (Tool_PhishBlockThreshold) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{0, 0}
}

// Represents the environment being operated, such as a web browser.
type Tool_ComputerUse_Environment int32

const (
	// Defaults to browser.
	Tool_ComputerUse_ENVIRONMENT_UNSPECIFIED Tool_ComputerUse_Environment = 0
	// Operates in a web browser.
	Tool_ComputerUse_ENVIRONMENT_BROWSER Tool_ComputerUse_Environment = 1
)

// Enum value maps for Tool_ComputerUse_Environment.
var (
	Tool_ComputerUse_Environment_name = map[int32]string{
		0: "ENVIRONMENT_UNSPECIFIED",
		1: "ENVIRONMENT_BROWSER",
	}
	Tool_ComputerUse_Environment_value = map[string]int32{
		"ENVIRONMENT_UNSPECIFIED": 0,
		"ENVIRONMENT_BROWSER":     1,
	}
)

func (x Tool_ComputerUse_Environment) Enum() *Tool_ComputerUse_Environment {
	p := new(Tool_ComputerUse_Environment)
	*p = x
	return p
}

func (x Tool_ComputerUse_Environment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_ComputerUse_Environment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[1].Descriptor()
}

func (Tool_ComputerUse_Environment) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[1]
}

func (x Tool_ComputerUse_Environment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_ComputerUse_Environment.Descriptor instead.
func (Tool_ComputerUse_Environment) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{0, 2, 0}
}

// Supported programming languages for the generated code.
type ExecutableCode_Language int32

const (
	// Unspecified language. This value should not be used.
	ExecutableCode_LANGUAGE_UNSPECIFIED ExecutableCode_Language = 0
	// Python >= 3.10, with numpy and simpy available.
	ExecutableCode_PYTHON ExecutableCode_Language = 1
)

// Enum value maps for ExecutableCode_Language.
var (
	ExecutableCode_Language_name = map[int32]string{
		0: "LANGUAGE_UNSPECIFIED",
		1: "PYTHON",
	}
	ExecutableCode_Language_value = map[string]int32{
		"LANGUAGE_UNSPECIFIED": 0,
		"PYTHON":               1,
	}
)

func (x ExecutableCode_Language) Enum() *ExecutableCode_Language {
	p := new(ExecutableCode_Language)
	*p = x
	return p
}

func (x ExecutableCode_Language) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutableCode_Language) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[2].Descriptor()
}

func (ExecutableCode_Language) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[2]
}

func (x ExecutableCode_Language) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutableCode_Language.Descriptor instead.
func (ExecutableCode_Language) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{6, 0}
}

// Enumeration of possible outcomes of the code execution.
type CodeExecutionResult_Outcome int32

const (
	// Unspecified status. This value should not be used.
	CodeExecutionResult_OUTCOME_UNSPECIFIED CodeExecutionResult_Outcome = 0
	// Code execution completed successfully.
	CodeExecutionResult_OUTCOME_OK CodeExecutionResult_Outcome = 1
	// Code execution finished but with a failure. `stderr` should contain the
	// reason.
	CodeExecutionResult_OUTCOME_FAILED CodeExecutionResult_Outcome = 2
	// Code execution ran for too long, and was cancelled. There may or may not
	// be a partial output present.
	CodeExecutionResult_OUTCOME_DEADLINE_EXCEEDED CodeExecutionResult_Outcome = 3
)

// Enum value maps for CodeExecutionResult_Outcome.
var (
	CodeExecutionResult_Outcome_name = map[int32]string{
		0: "OUTCOME_UNSPECIFIED",
		1: "OUTCOME_OK",
		2: "OUTCOME_FAILED",
		3: "OUTCOME_DEADLINE_EXCEEDED",
	}
	CodeExecutionResult_Outcome_value = map[string]int32{
		"OUTCOME_UNSPECIFIED":       0,
		"OUTCOME_OK":                1,
		"OUTCOME_FAILED":            2,
		"OUTCOME_DEADLINE_EXCEEDED": 3,
	}
)

func (x CodeExecutionResult_Outcome) Enum() *CodeExecutionResult_Outcome {
	p := new(CodeExecutionResult_Outcome)
	*p = x
	return p
}

func (x CodeExecutionResult_Outcome) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CodeExecutionResult_Outcome) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[3].Descriptor()
}

func (CodeExecutionResult_Outcome) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[3]
}

func (x CodeExecutionResult_Outcome) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CodeExecutionResult_Outcome.Descriptor instead.
func (CodeExecutionResult_Outcome) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{7, 0}
}

// The mode of the predictor to be used in dynamic retrieval.
type DynamicRetrievalConfig_Mode int32

const (
	// Always trigger retrieval.
	DynamicRetrievalConfig_MODE_UNSPECIFIED DynamicRetrievalConfig_Mode = 0
	// Run retrieval only when system decides it is necessary.
	DynamicRetrievalConfig_MODE_DYNAMIC DynamicRetrievalConfig_Mode = 1
)

// Enum value maps for DynamicRetrievalConfig_Mode.
var (
	DynamicRetrievalConfig_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "MODE_DYNAMIC",
	}
	DynamicRetrievalConfig_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"MODE_DYNAMIC":     1,
	}
)

func (x DynamicRetrievalConfig_Mode) Enum() *DynamicRetrievalConfig_Mode {
	p := new(DynamicRetrievalConfig_Mode)
	*p = x
	return p
}

func (x DynamicRetrievalConfig_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DynamicRetrievalConfig_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[4].Descriptor()
}

func (DynamicRetrievalConfig_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[4]
}

func (x DynamicRetrievalConfig_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DynamicRetrievalConfig_Mode.Descriptor instead.
func (DynamicRetrievalConfig_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{14, 0}
}

// Function calling mode.
type FunctionCallingConfig_Mode int32

const (
	// Unspecified function calling mode. This value should not be used.
	FunctionCallingConfig_MODE_UNSPECIFIED FunctionCallingConfig_Mode = 0
	// Default model behavior, model decides to predict either function calls
	// or natural language response.
	FunctionCallingConfig_AUTO FunctionCallingConfig_Mode = 1
	// Model is constrained to always predicting function calls only.
	// If [allowed_function_names][FunctionCallingConfig.allowed_function_names]
	// are set, the predicted function calls will be limited to any one of
	// `allowed_function_names`, else the predicted function calls will be any
	// one of the provided [FunctionDeclaration].
	FunctionCallingConfig_ANY FunctionCallingConfig_Mode = 2
	// Model will not predict any function calls. Model behavior is same as when
	// not passing any function declarations.
	FunctionCallingConfig_NONE FunctionCallingConfig_Mode = 3
	// Model is constrained to predict either function calls or natural language
	// response.
	// If [allowed_function_names][FunctionCallingConfig.allowed_function_names]
	// are set, the predicted function calls will be limited to any one of
	// `allowed_function_names`, else the predicted function calls will be any
	// one of the provided [FunctionDeclaration].
	FunctionCallingConfig_VALIDATED FunctionCallingConfig_Mode = 5
)

// Enum value maps for FunctionCallingConfig_Mode.
var (
	FunctionCallingConfig_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "AUTO",
		2: "ANY",
		3: "NONE",
		5: "VALIDATED",
	}
	FunctionCallingConfig_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"AUTO":             1,
		"ANY":              2,
		"NONE":             3,
		"VALIDATED":        5,
	}
)

func (x FunctionCallingConfig_Mode) Enum() *FunctionCallingConfig_Mode {
	p := new(FunctionCallingConfig_Mode)
	*p = x
	return p
}

func (x FunctionCallingConfig_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FunctionCallingConfig_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[5].Descriptor()
}

func (FunctionCallingConfig_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes[5]
}

func (x FunctionCallingConfig_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FunctionCallingConfig_Mode.Descriptor instead.
func (FunctionCallingConfig_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{16, 0}
}

// Tool details that the model may use to generate response.
//
// A `Tool` is a piece of code that enables the system to interact with
// external systems to perform an action, or set of actions, outside of
// knowledge and scope of the model. A Tool object should contain exactly
// one type of Tool (e.g FunctionDeclaration, Retrieval or
// GoogleSearchRetrieval).
type Tool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Function tool type.
	// One or more function declarations to be passed to the model along with the
	// current user query. Model may decide to call a subset of these functions
	// by populating
	// [FunctionCall][google.cloud.aiplatform.v1beta1.Part.function_call] in the
	// response. User should provide a
	// [FunctionResponse][google.cloud.aiplatform.v1beta1.Part.function_response]
	// for each function call in the next turn. Based on the function responses,
	// Model will generate the final response back to the user.
	// Maximum 128 function declarations can be provided.
	FunctionDeclarations []*FunctionDeclaration `protobuf:"bytes,1,rep,name=function_declarations,json=functionDeclarations,proto3" json:"function_declarations,omitempty"`
	// Optional. Retrieval tool type.
	// System will always execute the provided retrieval tool(s) to get external
	// knowledge to answer the prompt. Retrieval results are presented to the
	// model for generation.
	Retrieval *Retrieval `protobuf:"bytes,2,opt,name=retrieval,proto3" json:"retrieval,omitempty"`
	// Optional. GoogleSearch tool type.
	// Tool to support Google Search in Model. Powered by Google.
	GoogleSearch *Tool_GoogleSearch `protobuf:"bytes,7,opt,name=google_search,json=googleSearch,proto3" json:"google_search,omitempty"`
	// Optional. GoogleSearchRetrieval tool type.
	// Specialized retrieval tool that is powered by Google search.
	GoogleSearchRetrieval *GoogleSearchRetrieval `protobuf:"bytes,3,opt,name=google_search_retrieval,json=googleSearchRetrieval,proto3" json:"google_search_retrieval,omitempty"`
	// Optional. GoogleMaps tool type.
	// Tool to support Google Maps in Model.
	GoogleMaps *GoogleMaps `protobuf:"bytes,5,opt,name=google_maps,json=googleMaps,proto3" json:"google_maps,omitempty"`
	// Optional. Tool to support searching public web data, powered by Vertex AI
	// Search and Sec4 compliance.
	EnterpriseWebSearch *EnterpriseWebSearch `protobuf:"bytes,6,opt,name=enterprise_web_search,json=enterpriseWebSearch,proto3" json:"enterprise_web_search,omitempty"`
	// Optional. CodeExecution tool type.
	// Enables the model to execute code as part of generation.
	CodeExecution *Tool_CodeExecution `protobuf:"bytes,4,opt,name=code_execution,json=codeExecution,proto3" json:"code_execution,omitempty"`
	// Optional. Tool to support URL context retrieval.
	UrlContext *UrlContext `protobuf:"bytes,8,opt,name=url_context,json=urlContext,proto3" json:"url_context,omitempty"`
	// Optional. Tool to support the model interacting directly with the computer.
	// If enabled, it automatically populates computer-use specific Function
	// Declarations.
	ComputerUse *Tool_ComputerUse `protobuf:"bytes,11,opt,name=computer_use,json=computerUse,proto3" json:"computer_use,omitempty"`
}

func (x *Tool) Reset() {
	*x = Tool{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool) ProtoMessage() {}

func (x *Tool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool.ProtoReflect.Descriptor instead.
func (*Tool) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{0}
}

func (x *Tool) GetFunctionDeclarations() []*FunctionDeclaration {
	if x != nil {
		return x.FunctionDeclarations
	}
	return nil
}

func (x *Tool) GetRetrieval() *Retrieval {
	if x != nil {
		return x.Retrieval
	}
	return nil
}

func (x *Tool) GetGoogleSearch() *Tool_GoogleSearch {
	if x != nil {
		return x.GoogleSearch
	}
	return nil
}

func (x *Tool) GetGoogleSearchRetrieval() *GoogleSearchRetrieval {
	if x != nil {
		return x.GoogleSearchRetrieval
	}
	return nil
}

func (x *Tool) GetGoogleMaps() *GoogleMaps {
	if x != nil {
		return x.GoogleMaps
	}
	return nil
}

func (x *Tool) GetEnterpriseWebSearch() *EnterpriseWebSearch {
	if x != nil {
		return x.EnterpriseWebSearch
	}
	return nil
}

func (x *Tool) GetCodeExecution() *Tool_CodeExecution {
	if x != nil {
		return x.CodeExecution
	}
	return nil
}

func (x *Tool) GetUrlContext() *UrlContext {
	if x != nil {
		return x.UrlContext
	}
	return nil
}

func (x *Tool) GetComputerUse() *Tool_ComputerUse {
	if x != nil {
		return x.ComputerUse
	}
	return nil
}

// Tool to support URL context.
type UrlContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UrlContext) Reset() {
	*x = UrlContext{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UrlContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UrlContext) ProtoMessage() {}

func (x *UrlContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UrlContext.ProtoReflect.Descriptor instead.
func (*UrlContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{1}
}

// A single example of the tool usage.
type ToolUseExample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target tool to use.
	//
	// Types that are assignable to Target:
	//
	//	*ToolUseExample_ExtensionOperation_
	//	*ToolUseExample_FunctionName
	Target isToolUseExample_Target `protobuf_oneof:"Target"`
	// Required. The display name for example.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Query that should be routed to this tool.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Request parameters used for executing this tool.
	RequestParams *structpb.Struct `protobuf:"bytes,3,opt,name=request_params,json=requestParams,proto3" json:"request_params,omitempty"`
	// Response parameters generated by this tool.
	ResponseParams *structpb.Struct `protobuf:"bytes,4,opt,name=response_params,json=responseParams,proto3" json:"response_params,omitempty"`
	// Summary of the tool response to the user query.
	ResponseSummary string `protobuf:"bytes,5,opt,name=response_summary,json=responseSummary,proto3" json:"response_summary,omitempty"`
}

func (x *ToolUseExample) Reset() {
	*x = ToolUseExample{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolUseExample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolUseExample) ProtoMessage() {}

func (x *ToolUseExample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolUseExample.ProtoReflect.Descriptor instead.
func (*ToolUseExample) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{2}
}

func (m *ToolUseExample) GetTarget() isToolUseExample_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *ToolUseExample) GetExtensionOperation() *ToolUseExample_ExtensionOperation {
	if x, ok := x.GetTarget().(*ToolUseExample_ExtensionOperation_); ok {
		return x.ExtensionOperation
	}
	return nil
}

func (x *ToolUseExample) GetFunctionName() string {
	if x, ok := x.GetTarget().(*ToolUseExample_FunctionName); ok {
		return x.FunctionName
	}
	return ""
}

func (x *ToolUseExample) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ToolUseExample) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *ToolUseExample) GetRequestParams() *structpb.Struct {
	if x != nil {
		return x.RequestParams
	}
	return nil
}

func (x *ToolUseExample) GetResponseParams() *structpb.Struct {
	if x != nil {
		return x.ResponseParams
	}
	return nil
}

func (x *ToolUseExample) GetResponseSummary() string {
	if x != nil {
		return x.ResponseSummary
	}
	return ""
}

type isToolUseExample_Target interface {
	isToolUseExample_Target()
}

type ToolUseExample_ExtensionOperation_ struct {
	// Extension operation to call.
	ExtensionOperation *ToolUseExample_ExtensionOperation `protobuf:"bytes,10,opt,name=extension_operation,json=extensionOperation,proto3,oneof"`
}

type ToolUseExample_FunctionName struct {
	// Function name to call.
	FunctionName string `protobuf:"bytes,11,opt,name=function_name,json=functionName,proto3,oneof"`
}

func (*ToolUseExample_ExtensionOperation_) isToolUseExample_Target() {}

func (*ToolUseExample_FunctionName) isToolUseExample_Target() {}

// Structured representation of a function declaration as defined by the
// [OpenAPI 3.0 specification](https://spec.openapis.org/oas/v3.0.3). Included
// in this declaration are the function name, description, parameters and
// response type. This FunctionDeclaration is a representation of a block of
// code that can be used as a `Tool` by the model and executed by the client.
type FunctionDeclaration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function to call.
	// Must start with a letter or an underscore.
	// Must be a-z, A-Z, 0-9, or contain underscores, dots and dashes, with a
	// maximum length of 64.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Description and purpose of the function.
	// Model uses it to decide how and whether to call the function.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Describes the parameters to this function in JSON Schema Object
	// format. Reflects the Open API 3.03 Parameter Object. string Key: the name
	// of the parameter. Parameter names are case sensitive. Schema Value: the
	// Schema defining the type used for the parameter. For function with no
	// parameters, this can be left unset. Parameter names must start with a
	// letter or an underscore and must only contain chars a-z, A-Z, 0-9, or
	// underscores with a maximum length of 64. Example with 1 required and 1
	// optional parameter: type: OBJECT properties:
	//
	//	param1:
	//	  type: STRING
	//	param2:
	//	  type: INTEGER
	//
	// required:
	//   - param1
	Parameters *Schema `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Optional. Describes the parameters to the function in JSON Schema format.
	// The schema must describe an object where the properties are the parameters
	// to the function. For example:
	//
	// ```
	//
	//	{
	//	  "type": "object",
	//	  "properties": {
	//	    "name": { "type": "string" },
	//	    "age": { "type": "integer" }
	//	  },
	//	  "additionalProperties": false,
	//	  "required": ["name", "age"],
	//	  "propertyOrdering": ["name", "age"]
	//	}
	//
	// ```
	//
	// This field is mutually exclusive with `parameters`.
	ParametersJsonSchema *structpb.Value `protobuf:"bytes,5,opt,name=parameters_json_schema,json=parametersJsonSchema,proto3" json:"parameters_json_schema,omitempty"`
	// Optional. Describes the output from this function in JSON Schema format.
	// Reflects the Open API 3.03 Response Object. The Schema defines the type
	// used for the response value of the function.
	Response *Schema `protobuf:"bytes,4,opt,name=response,proto3" json:"response,omitempty"`
	// Optional. Describes the output from this function in JSON Schema format.
	// The value specified by the schema is the response value of the function.
	//
	// This field is mutually exclusive with `response`.
	ResponseJsonSchema *structpb.Value `protobuf:"bytes,6,opt,name=response_json_schema,json=responseJsonSchema,proto3" json:"response_json_schema,omitempty"`
}

func (x *FunctionDeclaration) Reset() {
	*x = FunctionDeclaration{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FunctionDeclaration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionDeclaration) ProtoMessage() {}

func (x *FunctionDeclaration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionDeclaration.ProtoReflect.Descriptor instead.
func (*FunctionDeclaration) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{3}
}

func (x *FunctionDeclaration) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FunctionDeclaration) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *FunctionDeclaration) GetParameters() *Schema {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *FunctionDeclaration) GetParametersJsonSchema() *structpb.Value {
	if x != nil {
		return x.ParametersJsonSchema
	}
	return nil
}

func (x *FunctionDeclaration) GetResponse() *Schema {
	if x != nil {
		return x.Response
	}
	return nil
}

func (x *FunctionDeclaration) GetResponseJsonSchema() *structpb.Value {
	if x != nil {
		return x.ResponseJsonSchema
	}
	return nil
}

// A predicted [FunctionCall] returned from the model that contains a string
// representing the [FunctionDeclaration.name] and a structured JSON object
// containing the parameters and their values.
type FunctionCall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique id of the function call. If populated, the client to
	// execute the `function_call` and return the response with the matching `id`.
	Id string `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// Required. The name of the function to call.
	// Matches [FunctionDeclaration.name].
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Required. The function parameters and values in JSON object
	// format. See [FunctionDeclaration.parameters] for parameter details.
	Args *structpb.Struct `protobuf:"bytes,2,opt,name=args,proto3" json:"args,omitempty"`
}

func (x *FunctionCall) Reset() {
	*x = FunctionCall{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FunctionCall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionCall) ProtoMessage() {}

func (x *FunctionCall) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionCall.ProtoReflect.Descriptor instead.
func (*FunctionCall) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{4}
}

func (x *FunctionCall) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *FunctionCall) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FunctionCall) GetArgs() *structpb.Struct {
	if x != nil {
		return x.Args
	}
	return nil
}

// The result output from a [FunctionCall] that contains a string representing
// the [FunctionDeclaration.name] and a structured JSON object containing any
// output from the function is used as context to the model. This should contain
// the result of a [FunctionCall] made based on model prediction.
type FunctionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The id of the function call this response is for. Populated by
	// the client to match the corresponding function call `id`.
	Id string `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// Required. The name of the function to call.
	// Matches [FunctionDeclaration.name] and [FunctionCall.name].
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The function response in JSON object format.
	// Use "output" key to specify function output and "error" key to specify
	// error details (if any). If "output" and "error" keys are not specified,
	// then whole "response" is treated as function output.
	Response *structpb.Struct `protobuf:"bytes,2,opt,name=response,proto3" json:"response,omitempty"`
}

func (x *FunctionResponse) Reset() {
	*x = FunctionResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FunctionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionResponse) ProtoMessage() {}

func (x *FunctionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionResponse.ProtoReflect.Descriptor instead.
func (*FunctionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{5}
}

func (x *FunctionResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *FunctionResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FunctionResponse) GetResponse() *structpb.Struct {
	if x != nil {
		return x.Response
	}
	return nil
}

// Code generated by the model that is meant to be executed, and the result
// returned to the model.
//
// Generated when using the [FunctionDeclaration] tool and
// [FunctionCallingConfig] mode is set to [Mode.CODE].
type ExecutableCode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Programming language of the `code`.
	Language ExecutableCode_Language `protobuf:"varint,1,opt,name=language,proto3,enum=google.cloud.aiplatform.v1beta1.ExecutableCode_Language" json:"language,omitempty"`
	// Required. The code to be executed.
	Code string `protobuf:"bytes,2,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *ExecutableCode) Reset() {
	*x = ExecutableCode{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecutableCode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutableCode) ProtoMessage() {}

func (x *ExecutableCode) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutableCode.ProtoReflect.Descriptor instead.
func (*ExecutableCode) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{6}
}

func (x *ExecutableCode) GetLanguage() ExecutableCode_Language {
	if x != nil {
		return x.Language
	}
	return ExecutableCode_LANGUAGE_UNSPECIFIED
}

func (x *ExecutableCode) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

// Result of executing the [ExecutableCode].
//
// Always follows a `part` containing the [ExecutableCode].
type CodeExecutionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Outcome of the code execution.
	Outcome CodeExecutionResult_Outcome `protobuf:"varint,1,opt,name=outcome,proto3,enum=google.cloud.aiplatform.v1beta1.CodeExecutionResult_Outcome" json:"outcome,omitempty"`
	// Optional. Contains stdout when code execution is successful, stderr or
	// other description otherwise.
	Output string `protobuf:"bytes,2,opt,name=output,proto3" json:"output,omitempty"`
}

func (x *CodeExecutionResult) Reset() {
	*x = CodeExecutionResult{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CodeExecutionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CodeExecutionResult) ProtoMessage() {}

func (x *CodeExecutionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CodeExecutionResult.ProtoReflect.Descriptor instead.
func (*CodeExecutionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{7}
}

func (x *CodeExecutionResult) GetOutcome() CodeExecutionResult_Outcome {
	if x != nil {
		return x.Outcome
	}
	return CodeExecutionResult_OUTCOME_UNSPECIFIED
}

func (x *CodeExecutionResult) GetOutput() string {
	if x != nil {
		return x.Output
	}
	return ""
}

// Defines a retrieval tool that model can call to access external knowledge.
type Retrieval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the retrieval.
	//
	// Types that are assignable to Source:
	//
	//	*Retrieval_VertexAiSearch
	//	*Retrieval_VertexRagStore
	Source isRetrieval_Source `protobuf_oneof:"source"`
	// Optional. Deprecated. This option is no longer supported.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/tool.proto.
	DisableAttribution bool `protobuf:"varint,3,opt,name=disable_attribution,json=disableAttribution,proto3" json:"disable_attribution,omitempty"`
}

func (x *Retrieval) Reset() {
	*x = Retrieval{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Retrieval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Retrieval) ProtoMessage() {}

func (x *Retrieval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Retrieval.ProtoReflect.Descriptor instead.
func (*Retrieval) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{8}
}

func (m *Retrieval) GetSource() isRetrieval_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Retrieval) GetVertexAiSearch() *VertexAISearch {
	if x, ok := x.GetSource().(*Retrieval_VertexAiSearch); ok {
		return x.VertexAiSearch
	}
	return nil
}

func (x *Retrieval) GetVertexRagStore() *VertexRagStore {
	if x, ok := x.GetSource().(*Retrieval_VertexRagStore); ok {
		return x.VertexRagStore
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/tool.proto.
func (x *Retrieval) GetDisableAttribution() bool {
	if x != nil {
		return x.DisableAttribution
	}
	return false
}

type isRetrieval_Source interface {
	isRetrieval_Source()
}

type Retrieval_VertexAiSearch struct {
	// Set to use data source powered by Vertex AI Search.
	VertexAiSearch *VertexAISearch `protobuf:"bytes,2,opt,name=vertex_ai_search,json=vertexAiSearch,proto3,oneof"`
}

type Retrieval_VertexRagStore struct {
	// Set to use data source powered by Vertex RAG store.
	// User data is uploaded via the VertexRagDataService.
	VertexRagStore *VertexRagStore `protobuf:"bytes,4,opt,name=vertex_rag_store,json=vertexRagStore,proto3,oneof"`
}

func (*Retrieval_VertexAiSearch) isRetrieval_Source() {}

func (*Retrieval_VertexRagStore) isRetrieval_Source() {}

// Retrieve from Vertex RAG Store for grounding.
type VertexRagStore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Deprecated. Please use rag_resources instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/tool.proto.
	RagCorpora []string `protobuf:"bytes,1,rep,name=rag_corpora,json=ragCorpora,proto3" json:"rag_corpora,omitempty"`
	// Optional. The representation of the rag source. It can be used to specify
	// corpus only or ragfiles. Currently only support one corpus or multiple
	// files from one corpus. In the future we may open up multiple corpora
	// support.
	RagResources []*VertexRagStore_RagResource `protobuf:"bytes,4,rep,name=rag_resources,json=ragResources,proto3" json:"rag_resources,omitempty"`
	// Optional. Number of top k results to return from the selected corpora.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/tool.proto.
	SimilarityTopK *int32 `protobuf:"varint,2,opt,name=similarity_top_k,json=similarityTopK,proto3,oneof" json:"similarity_top_k,omitempty"`
	// Optional. Only return results with vector distance smaller than the
	// threshold.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/tool.proto.
	VectorDistanceThreshold *float64 `protobuf:"fixed64,3,opt,name=vector_distance_threshold,json=vectorDistanceThreshold,proto3,oneof" json:"vector_distance_threshold,omitempty"`
	// Optional. The retrieval config for the Rag query.
	RagRetrievalConfig *RagRetrievalConfig `protobuf:"bytes,6,opt,name=rag_retrieval_config,json=ragRetrievalConfig,proto3" json:"rag_retrieval_config,omitempty"`
	// Optional. Currently only supported for Gemini Multimodal Live API.
	//
	// In Gemini Multimodal Live API, if `store_context` bool is
	// true, Gemini will leverage it to automatically memorize the
	// interactions between the client and Gemini, and retrieve context when
	// needed to augment the response generation for users' ongoing and future
	// interactions.
	StoreContext bool `protobuf:"varint,7,opt,name=store_context,json=storeContext,proto3" json:"store_context,omitempty"`
}

func (x *VertexRagStore) Reset() {
	*x = VertexRagStore{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VertexRagStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VertexRagStore) ProtoMessage() {}

func (x *VertexRagStore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VertexRagStore.ProtoReflect.Descriptor instead.
func (*VertexRagStore) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{9}
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/tool.proto.
func (x *VertexRagStore) GetRagCorpora() []string {
	if x != nil {
		return x.RagCorpora
	}
	return nil
}

func (x *VertexRagStore) GetRagResources() []*VertexRagStore_RagResource {
	if x != nil {
		return x.RagResources
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/tool.proto.
func (x *VertexRagStore) GetSimilarityTopK() int32 {
	if x != nil && x.SimilarityTopK != nil {
		return *x.SimilarityTopK
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/tool.proto.
func (x *VertexRagStore) GetVectorDistanceThreshold() float64 {
	if x != nil && x.VectorDistanceThreshold != nil {
		return *x.VectorDistanceThreshold
	}
	return 0
}

func (x *VertexRagStore) GetRagRetrievalConfig() *RagRetrievalConfig {
	if x != nil {
		return x.RagRetrievalConfig
	}
	return nil
}

func (x *VertexRagStore) GetStoreContext() bool {
	if x != nil {
		return x.StoreContext
	}
	return false
}

// Retrieve from Vertex AI Search datastore or engine for grounding.
// datastore and engine are mutually exclusive.
// See https://cloud.google.com/products/agent-builder
type VertexAISearch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Fully-qualified Vertex AI Search data store resource ID.
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
	Datastore string `protobuf:"bytes,1,opt,name=datastore,proto3" json:"datastore,omitempty"`
	// Optional. Fully-qualified Vertex AI Search engine resource ID.
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
	Engine string `protobuf:"bytes,2,opt,name=engine,proto3" json:"engine,omitempty"`
	// Optional. Number of search results to return per query.
	// The default value is 10.
	// The maximumm allowed value is 10.
	MaxResults int32 `protobuf:"varint,3,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Optional. Filter strings to be passed to the search API.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Specifications that define the specific DataStores to be searched, along
	// with configurations for those data stores. This is only considered for
	// Engines with multiple data stores.
	// It should only be set if engine is used.
	DataStoreSpecs []*VertexAISearch_DataStoreSpec `protobuf:"bytes,5,rep,name=data_store_specs,json=dataStoreSpecs,proto3" json:"data_store_specs,omitempty"`
}

func (x *VertexAISearch) Reset() {
	*x = VertexAISearch{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VertexAISearch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VertexAISearch) ProtoMessage() {}

func (x *VertexAISearch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VertexAISearch.ProtoReflect.Descriptor instead.
func (*VertexAISearch) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{10}
}

func (x *VertexAISearch) GetDatastore() string {
	if x != nil {
		return x.Datastore
	}
	return ""
}

func (x *VertexAISearch) GetEngine() string {
	if x != nil {
		return x.Engine
	}
	return ""
}

func (x *VertexAISearch) GetMaxResults() int32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *VertexAISearch) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *VertexAISearch) GetDataStoreSpecs() []*VertexAISearch_DataStoreSpec {
	if x != nil {
		return x.DataStoreSpecs
	}
	return nil
}

// Tool to retrieve public web data for grounding, powered by Google.
type GoogleSearchRetrieval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the dynamic retrieval configuration for the given source.
	DynamicRetrievalConfig *DynamicRetrievalConfig `protobuf:"bytes,2,opt,name=dynamic_retrieval_config,json=dynamicRetrievalConfig,proto3" json:"dynamic_retrieval_config,omitempty"`
}

func (x *GoogleSearchRetrieval) Reset() {
	*x = GoogleSearchRetrieval{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoogleSearchRetrieval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleSearchRetrieval) ProtoMessage() {}

func (x *GoogleSearchRetrieval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleSearchRetrieval.ProtoReflect.Descriptor instead.
func (*GoogleSearchRetrieval) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{11}
}

func (x *GoogleSearchRetrieval) GetDynamicRetrievalConfig() *DynamicRetrievalConfig {
	if x != nil {
		return x.DynamicRetrievalConfig
	}
	return nil
}

// Tool to retrieve public maps data for grounding, powered by Google.
type GoogleMaps struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, include the widget context token in the response.
	EnableWidget bool `protobuf:"varint,1,opt,name=enable_widget,json=enableWidget,proto3" json:"enable_widget,omitempty"`
}

func (x *GoogleMaps) Reset() {
	*x = GoogleMaps{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoogleMaps) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleMaps) ProtoMessage() {}

func (x *GoogleMaps) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleMaps.ProtoReflect.Descriptor instead.
func (*GoogleMaps) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{12}
}

func (x *GoogleMaps) GetEnableWidget() bool {
	if x != nil {
		return x.EnableWidget
	}
	return false
}

// Tool to search public web data, powered by Vertex AI Search and Sec4
// compliance.
type EnterpriseWebSearch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. List of domains to be excluded from the search results.
	// The default limit is 2000 domains.
	ExcludeDomains []string `protobuf:"bytes,1,rep,name=exclude_domains,json=excludeDomains,proto3" json:"exclude_domains,omitempty"`
	// Optional. Sites with confidence level chosen & above this value will be
	// blocked from the search results.
	BlockingConfidence *Tool_PhishBlockThreshold `protobuf:"varint,4,opt,name=blocking_confidence,json=blockingConfidence,proto3,enum=google.cloud.aiplatform.v1beta1.Tool_PhishBlockThreshold,oneof" json:"blocking_confidence,omitempty"`
}

func (x *EnterpriseWebSearch) Reset() {
	*x = EnterpriseWebSearch{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnterpriseWebSearch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnterpriseWebSearch) ProtoMessage() {}

func (x *EnterpriseWebSearch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnterpriseWebSearch.ProtoReflect.Descriptor instead.
func (*EnterpriseWebSearch) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{13}
}

func (x *EnterpriseWebSearch) GetExcludeDomains() []string {
	if x != nil {
		return x.ExcludeDomains
	}
	return nil
}

func (x *EnterpriseWebSearch) GetBlockingConfidence() Tool_PhishBlockThreshold {
	if x != nil && x.BlockingConfidence != nil {
		return *x.BlockingConfidence
	}
	return Tool_PHISH_BLOCK_THRESHOLD_UNSPECIFIED
}

// Describes the options to customize dynamic retrieval.
type DynamicRetrievalConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mode of the predictor to be used in dynamic retrieval.
	Mode DynamicRetrievalConfig_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.aiplatform.v1beta1.DynamicRetrievalConfig_Mode" json:"mode,omitempty"`
	// Optional. The threshold to be used in dynamic retrieval.
	// If not set, a system default value is used.
	DynamicThreshold *float32 `protobuf:"fixed32,2,opt,name=dynamic_threshold,json=dynamicThreshold,proto3,oneof" json:"dynamic_threshold,omitempty"`
}

func (x *DynamicRetrievalConfig) Reset() {
	*x = DynamicRetrievalConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DynamicRetrievalConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicRetrievalConfig) ProtoMessage() {}

func (x *DynamicRetrievalConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicRetrievalConfig.ProtoReflect.Descriptor instead.
func (*DynamicRetrievalConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{14}
}

func (x *DynamicRetrievalConfig) GetMode() DynamicRetrievalConfig_Mode {
	if x != nil {
		return x.Mode
	}
	return DynamicRetrievalConfig_MODE_UNSPECIFIED
}

func (x *DynamicRetrievalConfig) GetDynamicThreshold() float32 {
	if x != nil && x.DynamicThreshold != nil {
		return *x.DynamicThreshold
	}
	return 0
}

// Tool config. This config is shared for all tools provided in the request.
type ToolConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Function calling config.
	FunctionCallingConfig *FunctionCallingConfig `protobuf:"bytes,1,opt,name=function_calling_config,json=functionCallingConfig,proto3" json:"function_calling_config,omitempty"`
	// Optional. Retrieval config.
	RetrievalConfig *RetrievalConfig `protobuf:"bytes,2,opt,name=retrieval_config,json=retrievalConfig,proto3" json:"retrieval_config,omitempty"`
}

func (x *ToolConfig) Reset() {
	*x = ToolConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolConfig) ProtoMessage() {}

func (x *ToolConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolConfig.ProtoReflect.Descriptor instead.
func (*ToolConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{15}
}

func (x *ToolConfig) GetFunctionCallingConfig() *FunctionCallingConfig {
	if x != nil {
		return x.FunctionCallingConfig
	}
	return nil
}

func (x *ToolConfig) GetRetrievalConfig() *RetrievalConfig {
	if x != nil {
		return x.RetrievalConfig
	}
	return nil
}

// Function calling config.
type FunctionCallingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Function calling mode.
	Mode FunctionCallingConfig_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.aiplatform.v1beta1.FunctionCallingConfig_Mode" json:"mode,omitempty"`
	// Optional. Function names to call. Only set when the Mode is ANY. Function
	// names should match [FunctionDeclaration.name]. With mode set to ANY, model
	// will predict a function call from the set of function names provided.
	AllowedFunctionNames []string `protobuf:"bytes,2,rep,name=allowed_function_names,json=allowedFunctionNames,proto3" json:"allowed_function_names,omitempty"`
}

func (x *FunctionCallingConfig) Reset() {
	*x = FunctionCallingConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FunctionCallingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionCallingConfig) ProtoMessage() {}

func (x *FunctionCallingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionCallingConfig.ProtoReflect.Descriptor instead.
func (*FunctionCallingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{16}
}

func (x *FunctionCallingConfig) GetMode() FunctionCallingConfig_Mode {
	if x != nil {
		return x.Mode
	}
	return FunctionCallingConfig_MODE_UNSPECIFIED
}

func (x *FunctionCallingConfig) GetAllowedFunctionNames() []string {
	if x != nil {
		return x.AllowedFunctionNames
	}
	return nil
}

// Retrieval config.
type RetrievalConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location of the user.
	LatLng *latlng.LatLng `protobuf:"bytes,1,opt,name=lat_lng,json=latLng,proto3,oneof" json:"lat_lng,omitempty"`
	// The language code of the user.
	LanguageCode *string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3,oneof" json:"language_code,omitempty"`
}

func (x *RetrievalConfig) Reset() {
	*x = RetrievalConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrievalConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrievalConfig) ProtoMessage() {}

func (x *RetrievalConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrievalConfig.ProtoReflect.Descriptor instead.
func (*RetrievalConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{17}
}

func (x *RetrievalConfig) GetLatLng() *latlng.LatLng {
	if x != nil {
		return x.LatLng
	}
	return nil
}

func (x *RetrievalConfig) GetLanguageCode() string {
	if x != nil && x.LanguageCode != nil {
		return *x.LanguageCode
	}
	return ""
}

// Specifies the context retrieval config.
type RagRetrievalConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The number of contexts to retrieve.
	TopK int32 `protobuf:"varint,1,opt,name=top_k,json=topK,proto3" json:"top_k,omitempty"`
	// Optional. Config for Hybrid Search.
	HybridSearch *RagRetrievalConfig_HybridSearch `protobuf:"bytes,2,opt,name=hybrid_search,json=hybridSearch,proto3" json:"hybrid_search,omitempty"`
	// Optional. Config for filters.
	Filter *RagRetrievalConfig_Filter `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Config for ranking and reranking.
	Ranking *RagRetrievalConfig_Ranking `protobuf:"bytes,4,opt,name=ranking,proto3" json:"ranking,omitempty"`
}

func (x *RagRetrievalConfig) Reset() {
	*x = RagRetrievalConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagRetrievalConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagRetrievalConfig) ProtoMessage() {}

func (x *RagRetrievalConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagRetrievalConfig.ProtoReflect.Descriptor instead.
func (*RagRetrievalConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{18}
}

func (x *RagRetrievalConfig) GetTopK() int32 {
	if x != nil {
		return x.TopK
	}
	return 0
}

func (x *RagRetrievalConfig) GetHybridSearch() *RagRetrievalConfig_HybridSearch {
	if x != nil {
		return x.HybridSearch
	}
	return nil
}

func (x *RagRetrievalConfig) GetFilter() *RagRetrievalConfig_Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *RagRetrievalConfig) GetRanking() *RagRetrievalConfig_Ranking {
	if x != nil {
		return x.Ranking
	}
	return nil
}

// GoogleSearch tool type.
// Tool to support Google Search in Model. Powered by Google.
type Tool_GoogleSearch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. List of domains to be excluded from the search results.
	// The default limit is 2000 domains.
	// Example: ["amazon.com", "facebook.com"].
	ExcludeDomains []string `protobuf:"bytes,3,rep,name=exclude_domains,json=excludeDomains,proto3" json:"exclude_domains,omitempty"`
	// Optional. Sites with confidence level chosen & above this value will be
	// blocked from the search results.
	BlockingConfidence *Tool_PhishBlockThreshold `protobuf:"varint,4,opt,name=blocking_confidence,json=blockingConfidence,proto3,enum=google.cloud.aiplatform.v1beta1.Tool_PhishBlockThreshold,oneof" json:"blocking_confidence,omitempty"`
}

func (x *Tool_GoogleSearch) Reset() {
	*x = Tool_GoogleSearch{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_GoogleSearch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_GoogleSearch) ProtoMessage() {}

func (x *Tool_GoogleSearch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_GoogleSearch.ProtoReflect.Descriptor instead.
func (*Tool_GoogleSearch) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Tool_GoogleSearch) GetExcludeDomains() []string {
	if x != nil {
		return x.ExcludeDomains
	}
	return nil
}

func (x *Tool_GoogleSearch) GetBlockingConfidence() Tool_PhishBlockThreshold {
	if x != nil && x.BlockingConfidence != nil {
		return *x.BlockingConfidence
	}
	return Tool_PHISH_BLOCK_THRESHOLD_UNSPECIFIED
}

// Tool that executes code generated by the model, and automatically returns
// the result to the model.
//
// See also [ExecutableCode]and [CodeExecutionResult] which are input and
// output to this tool.
type Tool_CodeExecution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Tool_CodeExecution) Reset() {
	*x = Tool_CodeExecution{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_CodeExecution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_CodeExecution) ProtoMessage() {}

func (x *Tool_CodeExecution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_CodeExecution.ProtoReflect.Descriptor instead.
func (*Tool_CodeExecution) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{0, 1}
}

// Tool to support computer use.
type Tool_ComputerUse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The environment being operated.
	Environment Tool_ComputerUse_Environment `protobuf:"varint,1,opt,name=environment,proto3,enum=google.cloud.aiplatform.v1beta1.Tool_ComputerUse_Environment" json:"environment,omitempty"`
}

func (x *Tool_ComputerUse) Reset() {
	*x = Tool_ComputerUse{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_ComputerUse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_ComputerUse) ProtoMessage() {}

func (x *Tool_ComputerUse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_ComputerUse.ProtoReflect.Descriptor instead.
func (*Tool_ComputerUse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Tool_ComputerUse) GetEnvironment() Tool_ComputerUse_Environment {
	if x != nil {
		return x.Environment
	}
	return Tool_ComputerUse_ENVIRONMENT_UNSPECIFIED
}

// Identifies one operation of the extension.
type ToolUseExample_ExtensionOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the extension.
	Extension string `protobuf:"bytes,1,opt,name=extension,proto3" json:"extension,omitempty"`
	// Required. Operation ID of the extension.
	OperationId string `protobuf:"bytes,2,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
}

func (x *ToolUseExample_ExtensionOperation) Reset() {
	*x = ToolUseExample_ExtensionOperation{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolUseExample_ExtensionOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolUseExample_ExtensionOperation) ProtoMessage() {}

func (x *ToolUseExample_ExtensionOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolUseExample_ExtensionOperation.ProtoReflect.Descriptor instead.
func (*ToolUseExample_ExtensionOperation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ToolUseExample_ExtensionOperation) GetExtension() string {
	if x != nil {
		return x.Extension
	}
	return ""
}

func (x *ToolUseExample_ExtensionOperation) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

// The definition of the Rag resource.
type VertexRagStore_RagResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. RagCorpora resource name.
	// Format:
	// `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
	RagCorpus string `protobuf:"bytes,1,opt,name=rag_corpus,json=ragCorpus,proto3" json:"rag_corpus,omitempty"`
	// Optional. rag_file_id. The files should be in the same rag_corpus set in
	// rag_corpus field.
	RagFileIds []string `protobuf:"bytes,2,rep,name=rag_file_ids,json=ragFileIds,proto3" json:"rag_file_ids,omitempty"`
}

func (x *VertexRagStore_RagResource) Reset() {
	*x = VertexRagStore_RagResource{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VertexRagStore_RagResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VertexRagStore_RagResource) ProtoMessage() {}

func (x *VertexRagStore_RagResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VertexRagStore_RagResource.ProtoReflect.Descriptor instead.
func (*VertexRagStore_RagResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{9, 0}
}

func (x *VertexRagStore_RagResource) GetRagCorpus() string {
	if x != nil {
		return x.RagCorpus
	}
	return ""
}

func (x *VertexRagStore_RagResource) GetRagFileIds() []string {
	if x != nil {
		return x.RagFileIds
	}
	return nil
}

// Define data stores within engine to filter on in a search call and
// configurations for those data stores. For more information, see
// https://cloud.google.com/generative-ai-app-builder/docs/reference/rpc/google.cloud.discoveryengine.v1#datastorespec
type VertexAISearch_DataStoreSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full resource name of DataStore, such as
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
	DataStore string `protobuf:"bytes,1,opt,name=data_store,json=dataStore,proto3" json:"data_store,omitempty"`
	// Optional. Filter specification to filter documents in the data store
	// specified by data_store field. For more information on filtering, see
	// [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *VertexAISearch_DataStoreSpec) Reset() {
	*x = VertexAISearch_DataStoreSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VertexAISearch_DataStoreSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VertexAISearch_DataStoreSpec) ProtoMessage() {}

func (x *VertexAISearch_DataStoreSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VertexAISearch_DataStoreSpec.ProtoReflect.Descriptor instead.
func (*VertexAISearch_DataStoreSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{10, 0}
}

func (x *VertexAISearch_DataStoreSpec) GetDataStore() string {
	if x != nil {
		return x.DataStore
	}
	return ""
}

func (x *VertexAISearch_DataStoreSpec) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Config for Hybrid Search.
type RagRetrievalConfig_HybridSearch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Alpha value controls the weight between dense and sparse vector
	// search results. The range is [0, 1], while 0 means sparse vector search
	// only and 1 means dense vector search only. The default value is 0.5 which
	// balances sparse and dense vector search equally.
	Alpha *float32 `protobuf:"fixed32,1,opt,name=alpha,proto3,oneof" json:"alpha,omitempty"`
}

func (x *RagRetrievalConfig_HybridSearch) Reset() {
	*x = RagRetrievalConfig_HybridSearch{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagRetrievalConfig_HybridSearch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagRetrievalConfig_HybridSearch) ProtoMessage() {}

func (x *RagRetrievalConfig_HybridSearch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagRetrievalConfig_HybridSearch.ProtoReflect.Descriptor instead.
func (*RagRetrievalConfig_HybridSearch) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{18, 0}
}

func (x *RagRetrievalConfig_HybridSearch) GetAlpha() float32 {
	if x != nil && x.Alpha != nil {
		return *x.Alpha
	}
	return 0
}

// Config for filters.
type RagRetrievalConfig_Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Filter contexts retrieved from the vector DB based on either vector
	// distance or vector similarity.
	//
	// Types that are assignable to VectorDbThreshold:
	//
	//	*RagRetrievalConfig_Filter_VectorDistanceThreshold
	//	*RagRetrievalConfig_Filter_VectorSimilarityThreshold
	VectorDbThreshold isRagRetrievalConfig_Filter_VectorDbThreshold `protobuf_oneof:"vector_db_threshold"`
	// Optional. String for metadata filtering.
	MetadataFilter string `protobuf:"bytes,2,opt,name=metadata_filter,json=metadataFilter,proto3" json:"metadata_filter,omitempty"`
}

func (x *RagRetrievalConfig_Filter) Reset() {
	*x = RagRetrievalConfig_Filter{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagRetrievalConfig_Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagRetrievalConfig_Filter) ProtoMessage() {}

func (x *RagRetrievalConfig_Filter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagRetrievalConfig_Filter.ProtoReflect.Descriptor instead.
func (*RagRetrievalConfig_Filter) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{18, 1}
}

func (m *RagRetrievalConfig_Filter) GetVectorDbThreshold() isRagRetrievalConfig_Filter_VectorDbThreshold {
	if m != nil {
		return m.VectorDbThreshold
	}
	return nil
}

func (x *RagRetrievalConfig_Filter) GetVectorDistanceThreshold() float64 {
	if x, ok := x.GetVectorDbThreshold().(*RagRetrievalConfig_Filter_VectorDistanceThreshold); ok {
		return x.VectorDistanceThreshold
	}
	return 0
}

func (x *RagRetrievalConfig_Filter) GetVectorSimilarityThreshold() float64 {
	if x, ok := x.GetVectorDbThreshold().(*RagRetrievalConfig_Filter_VectorSimilarityThreshold); ok {
		return x.VectorSimilarityThreshold
	}
	return 0
}

func (x *RagRetrievalConfig_Filter) GetMetadataFilter() string {
	if x != nil {
		return x.MetadataFilter
	}
	return ""
}

type isRagRetrievalConfig_Filter_VectorDbThreshold interface {
	isRagRetrievalConfig_Filter_VectorDbThreshold()
}

type RagRetrievalConfig_Filter_VectorDistanceThreshold struct {
	// Optional. Only returns contexts with vector distance smaller than the
	// threshold.
	VectorDistanceThreshold float64 `protobuf:"fixed64,3,opt,name=vector_distance_threshold,json=vectorDistanceThreshold,proto3,oneof"`
}

type RagRetrievalConfig_Filter_VectorSimilarityThreshold struct {
	// Optional. Only returns contexts with vector similarity larger than the
	// threshold.
	VectorSimilarityThreshold float64 `protobuf:"fixed64,4,opt,name=vector_similarity_threshold,json=vectorSimilarityThreshold,proto3,oneof"`
}

func (*RagRetrievalConfig_Filter_VectorDistanceThreshold) isRagRetrievalConfig_Filter_VectorDbThreshold() {
}

func (*RagRetrievalConfig_Filter_VectorSimilarityThreshold) isRagRetrievalConfig_Filter_VectorDbThreshold() {
}

// Config for ranking and reranking.
type RagRetrievalConfig_Ranking struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Config options for ranking. Currently only Rank Service is supported.
	//
	// Types that are assignable to RankingConfig:
	//
	//	*RagRetrievalConfig_Ranking_RankService_
	//	*RagRetrievalConfig_Ranking_LlmRanker_
	RankingConfig isRagRetrievalConfig_Ranking_RankingConfig `protobuf_oneof:"ranking_config"`
}

func (x *RagRetrievalConfig_Ranking) Reset() {
	*x = RagRetrievalConfig_Ranking{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagRetrievalConfig_Ranking) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagRetrievalConfig_Ranking) ProtoMessage() {}

func (x *RagRetrievalConfig_Ranking) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagRetrievalConfig_Ranking.ProtoReflect.Descriptor instead.
func (*RagRetrievalConfig_Ranking) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{18, 2}
}

func (m *RagRetrievalConfig_Ranking) GetRankingConfig() isRagRetrievalConfig_Ranking_RankingConfig {
	if m != nil {
		return m.RankingConfig
	}
	return nil
}

func (x *RagRetrievalConfig_Ranking) GetRankService() *RagRetrievalConfig_Ranking_RankService {
	if x, ok := x.GetRankingConfig().(*RagRetrievalConfig_Ranking_RankService_); ok {
		return x.RankService
	}
	return nil
}

func (x *RagRetrievalConfig_Ranking) GetLlmRanker() *RagRetrievalConfig_Ranking_LlmRanker {
	if x, ok := x.GetRankingConfig().(*RagRetrievalConfig_Ranking_LlmRanker_); ok {
		return x.LlmRanker
	}
	return nil
}

type isRagRetrievalConfig_Ranking_RankingConfig interface {
	isRagRetrievalConfig_Ranking_RankingConfig()
}

type RagRetrievalConfig_Ranking_RankService_ struct {
	// Optional. Config for Rank Service.
	RankService *RagRetrievalConfig_Ranking_RankService `protobuf:"bytes,1,opt,name=rank_service,json=rankService,proto3,oneof"`
}

type RagRetrievalConfig_Ranking_LlmRanker_ struct {
	// Optional. Config for LlmRanker.
	LlmRanker *RagRetrievalConfig_Ranking_LlmRanker `protobuf:"bytes,3,opt,name=llm_ranker,json=llmRanker,proto3,oneof"`
}

func (*RagRetrievalConfig_Ranking_RankService_) isRagRetrievalConfig_Ranking_RankingConfig() {}

func (*RagRetrievalConfig_Ranking_LlmRanker_) isRagRetrievalConfig_Ranking_RankingConfig() {}

// Config for Rank Service.
type RagRetrievalConfig_Ranking_RankService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The model name of the rank service.
	// Format: `semantic-ranker-512@latest`
	ModelName *string `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3,oneof" json:"model_name,omitempty"`
}

func (x *RagRetrievalConfig_Ranking_RankService) Reset() {
	*x = RagRetrievalConfig_Ranking_RankService{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagRetrievalConfig_Ranking_RankService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagRetrievalConfig_Ranking_RankService) ProtoMessage() {}

func (x *RagRetrievalConfig_Ranking_RankService) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagRetrievalConfig_Ranking_RankService.ProtoReflect.Descriptor instead.
func (*RagRetrievalConfig_Ranking_RankService) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{18, 2, 0}
}

func (x *RagRetrievalConfig_Ranking_RankService) GetModelName() string {
	if x != nil && x.ModelName != nil {
		return *x.ModelName
	}
	return ""
}

// Config for LlmRanker.
type RagRetrievalConfig_Ranking_LlmRanker struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The model name used for ranking.
	// Format: `gemini-1.5-pro`
	ModelName *string `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3,oneof" json:"model_name,omitempty"`
}

func (x *RagRetrievalConfig_Ranking_LlmRanker) Reset() {
	*x = RagRetrievalConfig_Ranking_LlmRanker{}
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagRetrievalConfig_Ranking_LlmRanker) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagRetrievalConfig_Ranking_LlmRanker) ProtoMessage() {}

func (x *RagRetrievalConfig_Ranking_LlmRanker) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagRetrievalConfig_Ranking_LlmRanker.ProtoReflect.Descriptor instead.
func (*RagRetrievalConfig_Ranking_LlmRanker) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP(), []int{18, 2, 1}
}

func (x *RagRetrievalConfig_Ranking_LlmRanker) GetModelName() string {
	if x != nil && x.ModelName != nil {
		return *x.ModelName
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_tool_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_tool_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x61,
	0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xea, 0x0b, 0x0a, 0x04, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x6e, 0x0a, 0x15, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x14, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x63,
	0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x09, 0x72, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x12, 0x5c, 0x0a, 0x0d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x73, 0x0a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61,
	0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x12, 0x51, 0x0a, 0x0b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x12, 0x6d,
	0x0a, 0x15, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x5f, 0x77, 0x65, 0x62,
	0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x57, 0x65, 0x62, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x57, 0x65, 0x62, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x5f, 0x0a,
	0x0e, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x43, 0x6f, 0x64,
	0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0d, 0x63, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51,
	0x0a, 0x0b, 0x75, 0x72, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x72, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x72, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x59, 0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x73,
	0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x55, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x55, 0x73, 0x65, 0x1a, 0xca, 0x01, 0x0a,
	0x0c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x2c, 0x0a,
	0x0f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x74, 0x0a, 0x13, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e,
	0x50, 0x68, 0x69, 0x73, 0x68, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01,
	0x01, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0x0f, 0x0a, 0x0d, 0x43, 0x6f, 0x64,
	0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xb8, 0x01, 0x0a, 0x0b, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x55, 0x73, 0x65, 0x12, 0x64, 0x0a, 0x0b, 0x65, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x55,
	0x73, 0x65, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0x43, 0x0a, 0x0b, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13,
	0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x42, 0x52, 0x4f, 0x57,
	0x53, 0x45, 0x52, 0x10, 0x01, 0x22, 0xe5, 0x01, 0x0a, 0x13, 0x50, 0x68, 0x69, 0x73, 0x68, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x25, 0x0a,
	0x21, 0x50, 0x48, 0x49, 0x53, 0x48, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x54, 0x48, 0x52,
	0x45, 0x53, 0x48, 0x4f, 0x4c, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4c, 0x4f,
	0x57, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x42, 0x4f, 0x56, 0x45, 0x10, 0x1e, 0x12, 0x1a, 0x0a,
	0x16, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x5f, 0x41, 0x4e,
	0x44, 0x5f, 0x41, 0x42, 0x4f, 0x56, 0x45, 0x10, 0x28, 0x12, 0x18, 0x0a, 0x14, 0x42, 0x4c, 0x4f,
	0x43, 0x4b, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x42, 0x4f, 0x56,
	0x45, 0x10, 0x32, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x48, 0x49, 0x47,
	0x48, 0x45, 0x52, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x42, 0x4f, 0x56, 0x45, 0x10, 0x37, 0x12,
	0x1d, 0x0a, 0x19, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x48, 0x49,
	0x47, 0x48, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x42, 0x4f, 0x56, 0x45, 0x10, 0x3c, 0x12, 0x1d,
	0x0a, 0x19, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x5f, 0x45, 0x58, 0x54,
	0x52, 0x45, 0x4d, 0x45, 0x4c, 0x59, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x64, 0x22, 0x0c, 0x0a,
	0x0a, 0x55, 0x72, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0xaf, 0x04, 0x0a, 0x0e,
	0x54, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x75,
	0x0a, 0x13, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f,
	0x6f, 0x6c, 0x55, 0x73, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2e, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x12, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0d, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x3e, 0x0a, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x52, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12,
	0x40, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x73, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x1a, 0x84, 0x01, 0x0a,
	0x12, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x8f, 0x03,
	0x0a, 0x13, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x51, 0x0a, 0x16, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x14, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x4a, 0x73, 0x6f, 0x6e,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x48, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x4d, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6a, 0x73, 0x6f,
	0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4a, 0x73, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22,
	0x6e, 0x0a, 0x0c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x12,
	0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a,
	0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x22,
	0x7a, 0x0a, 0x10, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x02, 0x69, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x38, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb6, 0x01, 0x0a, 0x0e,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x59,
	0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x2e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x63, 0x6f,
	0x64, 0x65, 0x22, 0x30, 0x0a, 0x08, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x18,
	0x0a, 0x14, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x59, 0x54, 0x48,
	0x4f, 0x4e, 0x10, 0x01, 0x22, 0xf6, 0x01, 0x0a, 0x13, 0x43, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5b, 0x0a, 0x07,
	0x6f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x4f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x6f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0x65, 0x0a, 0x07, 0x4f, 0x75, 0x74, 0x63, 0x6f, 0x6d,
	0x65, 0x12, 0x17, 0x0a, 0x13, 0x4f, 0x55, 0x54, 0x43, 0x4f, 0x4d, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4f, 0x55,
	0x54, 0x43, 0x4f, 0x4d, 0x45, 0x5f, 0x4f, 0x4b, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x4f, 0x55,
	0x54, 0x43, 0x4f, 0x4d, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1d,
	0x0a, 0x19, 0x4f, 0x55, 0x54, 0x43, 0x4f, 0x4d, 0x45, 0x5f, 0x44, 0x45, 0x41, 0x44, 0x4c, 0x49,
	0x4e, 0x45, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x22, 0x87, 0x02,
	0x0a, 0x09, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x12, 0x5b, 0x0a, 0x10, 0x76,
	0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x61, 0x69, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x49,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x00, 0x52, 0x0e, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78,
	0x41, 0x69, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x5b, 0x0a, 0x10, 0x76, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x36, 0x0a, 0x13, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x12, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0x0a,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x91, 0x05, 0x0a, 0x0e, 0x56, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x4e, 0x0a, 0x0b, 0x72, 0x61,
	0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x2d, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x18, 0x01, 0x52, 0x0a,
	0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12, 0x65, 0x0a, 0x0d, 0x72, 0x61,
	0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x52, 0x61, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x61, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x34, 0x0a, 0x10, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x05, 0xe0, 0x41, 0x01,
	0x18, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79,
	0x54, 0x6f, 0x70, 0x4b, 0x88, 0x01, 0x01, 0x12, 0x46, 0x0a, 0x19, 0x76, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18,
	0x01, 0x48, 0x01, 0x52, 0x17, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x6a, 0x0a, 0x14, 0x72, 0x61, 0x67, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x61, 0x67, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x72, 0x61, 0x67, 0x52, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x1a, 0x80, 0x01, 0x0a, 0x0b, 0x52, 0x61, 0x67, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x61, 0x67,
	0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x09, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75,
	0x73, 0x12, 0x25, 0x0a, 0x0c, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x72, 0x61,
	0x67, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x73, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x73, 0x69, 0x6d,
	0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x42, 0x1c, 0x0a,
	0x1a, 0x5f, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22, 0xc9, 0x02, 0x0a, 0x0e,
	0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x49, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x21,
	0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x12, 0x1b, 0x0a, 0x06, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x24,
	0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x67, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x65,
	0x72, 0x74, 0x65, 0x78, 0x41, 0x49, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x73, 0x1a, 0x4b, 0x0a, 0x0d, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1d, 0x0a, 0x0a, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8a, 0x01, 0x0a, 0x15, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61,
	0x6c, 0x12, 0x71, 0x0a, 0x18, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x64, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x36, 0x0a, 0x0a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x4d, 0x61,
	0x70, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x69, 0x64,
	0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x22, 0xd1, 0x01, 0x0a,
	0x13, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x57, 0x65, 0x62, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x73, 0x12, 0x74, 0x0a, 0x13, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x50, 0x68, 0x69, 0x73, 0x68, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x12, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x22, 0xe7, 0x01, 0x0a, 0x16, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x35, 0x0a,
	0x11, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x10, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x88, 0x01, 0x01, 0x22, 0x2e, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x59, 0x4e, 0x41, 0x4d,
	0x49, 0x43, 0x10, 0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22, 0xe3, 0x01, 0x0a, 0x0a, 0x54,
	0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x73, 0x0a, 0x17, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60,
	0x0a, 0x10, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xf8, 0x01, 0x0a, 0x15, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x04, 0x6d, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x12, 0x39, 0x0a, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x4e, 0x0a, 0x04, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x55, 0x54,
	0x4f, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4e, 0x59, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04,
	0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41,
	0x54, 0x45, 0x44, 0x10, 0x05, 0x22, 0x04, 0x08, 0x04, 0x10, 0x04, 0x22, 0x8c, 0x01, 0x0a, 0x0f,
	0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x31, 0x0a, 0x07, 0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c,
	0x61, 0x74, 0x4c, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x06, 0x6c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x88,
	0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08,
	0x5f, 0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x22, 0xed, 0x07, 0x0a, 0x12, 0x52,
	0x61, 0x67, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x18, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x6f, 0x70, 0x4b, 0x12, 0x6a, 0x0a, 0x0d, 0x68,
	0x79, 0x62, 0x72, 0x69, 0x64, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61,
	0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x68, 0x79, 0x62, 0x72, 0x69,
	0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x57, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x52, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x5a, 0x0a, 0x07, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x1a, 0x38, 0x0a, 0x0c,
	0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x1e, 0x0a, 0x05,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x05, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06,
	0x5f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0xd7, 0x01, 0x0a, 0x06, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x41, 0x0a, 0x19, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x17, 0x76, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x12, 0x45, 0x0a, 0x1b, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73,
	0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x19, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69,
	0x74, 0x79, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x15, 0x0a, 0x13, 0x76, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x5f, 0x64, 0x62, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x1a, 0x87, 0x03, 0x0a, 0x07, 0x52, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x71, 0x0a, 0x0c,
	0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61,
	0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x2e,
	0x52, 0x61, 0x6e, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x0b, 0x72, 0x61, 0x6e, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x6b, 0x0a, 0x0a, 0x6c, 0x6c, 0x6d, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76,
	0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67,
	0x2e, 0x4c, 0x6c, 0x6d, 0x52, 0x61, 0x6e, 0x6b, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x09, 0x6c, 0x6c, 0x6d, 0x52, 0x61, 0x6e, 0x6b, 0x65, 0x72, 0x1a, 0x45, 0x0a, 0x0b,
	0x52, 0x61, 0x6e, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x0a, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4e, 0x61, 0x6d,
	0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x1a, 0x43, 0x0a, 0x09, 0x4c, 0x6c, 0x6d, 0x52, 0x61, 0x6e, 0x6b, 0x65, 0x72,
	0x12, 0x27, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x72, 0x61, 0x6e, 0x6b,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0xe0, 0x01, 0x0a, 0x23, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x42, 0x09, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56,
	0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_tool_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_tool_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes = make([]protoimpl.MessageInfo, 30)
var file_google_cloud_aiplatform_v1beta1_tool_proto_goTypes = []any{
	(Tool_PhishBlockThreshold)(0),                  // 0: google.cloud.aiplatform.v1beta1.Tool.PhishBlockThreshold
	(Tool_ComputerUse_Environment)(0),              // 1: google.cloud.aiplatform.v1beta1.Tool.ComputerUse.Environment
	(ExecutableCode_Language)(0),                   // 2: google.cloud.aiplatform.v1beta1.ExecutableCode.Language
	(CodeExecutionResult_Outcome)(0),               // 3: google.cloud.aiplatform.v1beta1.CodeExecutionResult.Outcome
	(DynamicRetrievalConfig_Mode)(0),               // 4: google.cloud.aiplatform.v1beta1.DynamicRetrievalConfig.Mode
	(FunctionCallingConfig_Mode)(0),                // 5: google.cloud.aiplatform.v1beta1.FunctionCallingConfig.Mode
	(*Tool)(nil),                                   // 6: google.cloud.aiplatform.v1beta1.Tool
	(*UrlContext)(nil),                             // 7: google.cloud.aiplatform.v1beta1.UrlContext
	(*ToolUseExample)(nil),                         // 8: google.cloud.aiplatform.v1beta1.ToolUseExample
	(*FunctionDeclaration)(nil),                    // 9: google.cloud.aiplatform.v1beta1.FunctionDeclaration
	(*FunctionCall)(nil),                           // 10: google.cloud.aiplatform.v1beta1.FunctionCall
	(*FunctionResponse)(nil),                       // 11: google.cloud.aiplatform.v1beta1.FunctionResponse
	(*ExecutableCode)(nil),                         // 12: google.cloud.aiplatform.v1beta1.ExecutableCode
	(*CodeExecutionResult)(nil),                    // 13: google.cloud.aiplatform.v1beta1.CodeExecutionResult
	(*Retrieval)(nil),                              // 14: google.cloud.aiplatform.v1beta1.Retrieval
	(*VertexRagStore)(nil),                         // 15: google.cloud.aiplatform.v1beta1.VertexRagStore
	(*VertexAISearch)(nil),                         // 16: google.cloud.aiplatform.v1beta1.VertexAISearch
	(*GoogleSearchRetrieval)(nil),                  // 17: google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval
	(*GoogleMaps)(nil),                             // 18: google.cloud.aiplatform.v1beta1.GoogleMaps
	(*EnterpriseWebSearch)(nil),                    // 19: google.cloud.aiplatform.v1beta1.EnterpriseWebSearch
	(*DynamicRetrievalConfig)(nil),                 // 20: google.cloud.aiplatform.v1beta1.DynamicRetrievalConfig
	(*ToolConfig)(nil),                             // 21: google.cloud.aiplatform.v1beta1.ToolConfig
	(*FunctionCallingConfig)(nil),                  // 22: google.cloud.aiplatform.v1beta1.FunctionCallingConfig
	(*RetrievalConfig)(nil),                        // 23: google.cloud.aiplatform.v1beta1.RetrievalConfig
	(*RagRetrievalConfig)(nil),                     // 24: google.cloud.aiplatform.v1beta1.RagRetrievalConfig
	(*Tool_GoogleSearch)(nil),                      // 25: google.cloud.aiplatform.v1beta1.Tool.GoogleSearch
	(*Tool_CodeExecution)(nil),                     // 26: google.cloud.aiplatform.v1beta1.Tool.CodeExecution
	(*Tool_ComputerUse)(nil),                       // 27: google.cloud.aiplatform.v1beta1.Tool.ComputerUse
	(*ToolUseExample_ExtensionOperation)(nil),      // 28: google.cloud.aiplatform.v1beta1.ToolUseExample.ExtensionOperation
	(*VertexRagStore_RagResource)(nil),             // 29: google.cloud.aiplatform.v1beta1.VertexRagStore.RagResource
	(*VertexAISearch_DataStoreSpec)(nil),           // 30: google.cloud.aiplatform.v1beta1.VertexAISearch.DataStoreSpec
	(*RagRetrievalConfig_HybridSearch)(nil),        // 31: google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
	(*RagRetrievalConfig_Filter)(nil),              // 32: google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter
	(*RagRetrievalConfig_Ranking)(nil),             // 33: google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking
	(*RagRetrievalConfig_Ranking_RankService)(nil), // 34: google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
	(*RagRetrievalConfig_Ranking_LlmRanker)(nil),   // 35: google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
	(*structpb.Struct)(nil),                        // 36: google.protobuf.Struct
	(*Schema)(nil),                                 // 37: google.cloud.aiplatform.v1beta1.Schema
	(*structpb.Value)(nil),                         // 38: google.protobuf.Value
	(*latlng.LatLng)(nil),                          // 39: google.type.LatLng
}
var file_google_cloud_aiplatform_v1beta1_tool_proto_depIdxs = []int32{
	9,  // 0: google.cloud.aiplatform.v1beta1.Tool.function_declarations:type_name -> google.cloud.aiplatform.v1beta1.FunctionDeclaration
	14, // 1: google.cloud.aiplatform.v1beta1.Tool.retrieval:type_name -> google.cloud.aiplatform.v1beta1.Retrieval
	25, // 2: google.cloud.aiplatform.v1beta1.Tool.google_search:type_name -> google.cloud.aiplatform.v1beta1.Tool.GoogleSearch
	17, // 3: google.cloud.aiplatform.v1beta1.Tool.google_search_retrieval:type_name -> google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval
	18, // 4: google.cloud.aiplatform.v1beta1.Tool.google_maps:type_name -> google.cloud.aiplatform.v1beta1.GoogleMaps
	19, // 5: google.cloud.aiplatform.v1beta1.Tool.enterprise_web_search:type_name -> google.cloud.aiplatform.v1beta1.EnterpriseWebSearch
	26, // 6: google.cloud.aiplatform.v1beta1.Tool.code_execution:type_name -> google.cloud.aiplatform.v1beta1.Tool.CodeExecution
	7,  // 7: google.cloud.aiplatform.v1beta1.Tool.url_context:type_name -> google.cloud.aiplatform.v1beta1.UrlContext
	27, // 8: google.cloud.aiplatform.v1beta1.Tool.computer_use:type_name -> google.cloud.aiplatform.v1beta1.Tool.ComputerUse
	28, // 9: google.cloud.aiplatform.v1beta1.ToolUseExample.extension_operation:type_name -> google.cloud.aiplatform.v1beta1.ToolUseExample.ExtensionOperation
	36, // 10: google.cloud.aiplatform.v1beta1.ToolUseExample.request_params:type_name -> google.protobuf.Struct
	36, // 11: google.cloud.aiplatform.v1beta1.ToolUseExample.response_params:type_name -> google.protobuf.Struct
	37, // 12: google.cloud.aiplatform.v1beta1.FunctionDeclaration.parameters:type_name -> google.cloud.aiplatform.v1beta1.Schema
	38, // 13: google.cloud.aiplatform.v1beta1.FunctionDeclaration.parameters_json_schema:type_name -> google.protobuf.Value
	37, // 14: google.cloud.aiplatform.v1beta1.FunctionDeclaration.response:type_name -> google.cloud.aiplatform.v1beta1.Schema
	38, // 15: google.cloud.aiplatform.v1beta1.FunctionDeclaration.response_json_schema:type_name -> google.protobuf.Value
	36, // 16: google.cloud.aiplatform.v1beta1.FunctionCall.args:type_name -> google.protobuf.Struct
	36, // 17: google.cloud.aiplatform.v1beta1.FunctionResponse.response:type_name -> google.protobuf.Struct
	2,  // 18: google.cloud.aiplatform.v1beta1.ExecutableCode.language:type_name -> google.cloud.aiplatform.v1beta1.ExecutableCode.Language
	3,  // 19: google.cloud.aiplatform.v1beta1.CodeExecutionResult.outcome:type_name -> google.cloud.aiplatform.v1beta1.CodeExecutionResult.Outcome
	16, // 20: google.cloud.aiplatform.v1beta1.Retrieval.vertex_ai_search:type_name -> google.cloud.aiplatform.v1beta1.VertexAISearch
	15, // 21: google.cloud.aiplatform.v1beta1.Retrieval.vertex_rag_store:type_name -> google.cloud.aiplatform.v1beta1.VertexRagStore
	29, // 22: google.cloud.aiplatform.v1beta1.VertexRagStore.rag_resources:type_name -> google.cloud.aiplatform.v1beta1.VertexRagStore.RagResource
	24, // 23: google.cloud.aiplatform.v1beta1.VertexRagStore.rag_retrieval_config:type_name -> google.cloud.aiplatform.v1beta1.RagRetrievalConfig
	30, // 24: google.cloud.aiplatform.v1beta1.VertexAISearch.data_store_specs:type_name -> google.cloud.aiplatform.v1beta1.VertexAISearch.DataStoreSpec
	20, // 25: google.cloud.aiplatform.v1beta1.GoogleSearchRetrieval.dynamic_retrieval_config:type_name -> google.cloud.aiplatform.v1beta1.DynamicRetrievalConfig
	0,  // 26: google.cloud.aiplatform.v1beta1.EnterpriseWebSearch.blocking_confidence:type_name -> google.cloud.aiplatform.v1beta1.Tool.PhishBlockThreshold
	4,  // 27: google.cloud.aiplatform.v1beta1.DynamicRetrievalConfig.mode:type_name -> google.cloud.aiplatform.v1beta1.DynamicRetrievalConfig.Mode
	22, // 28: google.cloud.aiplatform.v1beta1.ToolConfig.function_calling_config:type_name -> google.cloud.aiplatform.v1beta1.FunctionCallingConfig
	23, // 29: google.cloud.aiplatform.v1beta1.ToolConfig.retrieval_config:type_name -> google.cloud.aiplatform.v1beta1.RetrievalConfig
	5,  // 30: google.cloud.aiplatform.v1beta1.FunctionCallingConfig.mode:type_name -> google.cloud.aiplatform.v1beta1.FunctionCallingConfig.Mode
	39, // 31: google.cloud.aiplatform.v1beta1.RetrievalConfig.lat_lng:type_name -> google.type.LatLng
	31, // 32: google.cloud.aiplatform.v1beta1.RagRetrievalConfig.hybrid_search:type_name -> google.cloud.aiplatform.v1beta1.RagRetrievalConfig.HybridSearch
	32, // 33: google.cloud.aiplatform.v1beta1.RagRetrievalConfig.filter:type_name -> google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Filter
	33, // 34: google.cloud.aiplatform.v1beta1.RagRetrievalConfig.ranking:type_name -> google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking
	0,  // 35: google.cloud.aiplatform.v1beta1.Tool.GoogleSearch.blocking_confidence:type_name -> google.cloud.aiplatform.v1beta1.Tool.PhishBlockThreshold
	1,  // 36: google.cloud.aiplatform.v1beta1.Tool.ComputerUse.environment:type_name -> google.cloud.aiplatform.v1beta1.Tool.ComputerUse.Environment
	34, // 37: google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.rank_service:type_name -> google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.RankService
	35, // 38: google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.llm_ranker:type_name -> google.cloud.aiplatform.v1beta1.RagRetrievalConfig.Ranking.LlmRanker
	39, // [39:39] is the sub-list for method output_type
	39, // [39:39] is the sub-list for method input_type
	39, // [39:39] is the sub-list for extension type_name
	39, // [39:39] is the sub-list for extension extendee
	0,  // [0:39] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_tool_proto_init() }
func file_google_cloud_aiplatform_v1beta1_tool_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_tool_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_openapi_proto_init()
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[2].OneofWrappers = []any{
		(*ToolUseExample_ExtensionOperation_)(nil),
		(*ToolUseExample_FunctionName)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[8].OneofWrappers = []any{
		(*Retrieval_VertexAiSearch)(nil),
		(*Retrieval_VertexRagStore)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[9].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[13].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[14].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[17].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[19].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[25].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[26].OneofWrappers = []any{
		(*RagRetrievalConfig_Filter_VectorDistanceThreshold)(nil),
		(*RagRetrievalConfig_Filter_VectorSimilarityThreshold)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[27].OneofWrappers = []any{
		(*RagRetrievalConfig_Ranking_RankService_)(nil),
		(*RagRetrievalConfig_Ranking_LlmRanker_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[28].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes[29].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_tool_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   30,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_tool_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_tool_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_tool_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_tool_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_tool_proto = out.File
	file_google_cloud_aiplatform_v1beta1_tool_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_tool_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_tool_proto_depIdxs = nil
}
