// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MultiBucketReplication multi bucket replication
//
// swagger:model multiBucketReplication
type MultiBucketReplication struct {

	// access key
	// Required: true
	// Min Length: 3
	AccessKey *string `json:"accessKey"`

	// bandwidth
	Bandwidth int64 `json:"bandwidth,omitempty"`

	// buckets relation
	// Required: true
	BucketsRelation []*MultiBucketsRelation `json:"bucketsRelation"`

	// health check period
	HealthCheckPeriod int32 `json:"healthCheckPeriod,omitempty"`

	// prefix
	Prefix string `json:"prefix,omitempty"`

	// priority
	Priority int32 `json:"priority,omitempty"`

	// region
	Region string `json:"region,omitempty"`

	// replicate delete markers
	ReplicateDeleteMarkers bool `json:"replicateDeleteMarkers,omitempty"`

	// replicate deletes
	ReplicateDeletes bool `json:"replicateDeletes,omitempty"`

	// replicate existing objects
	ReplicateExistingObjects bool `json:"replicateExistingObjects,omitempty"`

	// replicate metadata
	ReplicateMetadata bool `json:"replicateMetadata,omitempty"`

	// secret key
	// Required: true
	// Min Length: 8
	SecretKey *string `json:"secretKey"`

	// storage class
	StorageClass string `json:"storageClass,omitempty"`

	// sync mode
	// Enum: ["async","sync"]
	SyncMode *string `json:"syncMode,omitempty"`

	// tags
	Tags string `json:"tags,omitempty"`

	// target URL
	// Required: true
	TargetURL *string `json:"targetURL"`
}

// Validate validates this multi bucket replication
func (m *MultiBucketReplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccessKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBucketsRelation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecretKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSyncMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTargetURL(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiBucketReplication) validateAccessKey(formats strfmt.Registry) error {

	if err := validate.Required("accessKey", "body", m.AccessKey); err != nil {
		return err
	}

	if err := validate.MinLength("accessKey", "body", *m.AccessKey, 3); err != nil {
		return err
	}

	return nil
}

func (m *MultiBucketReplication) validateBucketsRelation(formats strfmt.Registry) error {

	if err := validate.Required("bucketsRelation", "body", m.BucketsRelation); err != nil {
		return err
	}

	for i := 0; i < len(m.BucketsRelation); i++ {
		if swag.IsZero(m.BucketsRelation[i]) { // not required
			continue
		}

		if m.BucketsRelation[i] != nil {
			if err := m.BucketsRelation[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("bucketsRelation" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("bucketsRelation" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MultiBucketReplication) validateSecretKey(formats strfmt.Registry) error {

	if err := validate.Required("secretKey", "body", m.SecretKey); err != nil {
		return err
	}

	if err := validate.MinLength("secretKey", "body", *m.SecretKey, 8); err != nil {
		return err
	}

	return nil
}

var multiBucketReplicationTypeSyncModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["async","sync"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		multiBucketReplicationTypeSyncModePropEnum = append(multiBucketReplicationTypeSyncModePropEnum, v)
	}
}

const (

	// MultiBucketReplicationSyncModeAsync captures enum value "async"
	MultiBucketReplicationSyncModeAsync string = "async"

	// MultiBucketReplicationSyncModeSync captures enum value "sync"
	MultiBucketReplicationSyncModeSync string = "sync"
)

// prop value enum
func (m *MultiBucketReplication) validateSyncModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, multiBucketReplicationTypeSyncModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MultiBucketReplication) validateSyncMode(formats strfmt.Registry) error {
	if swag.IsZero(m.SyncMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateSyncModeEnum("syncMode", "body", *m.SyncMode); err != nil {
		return err
	}

	return nil
}

func (m *MultiBucketReplication) validateTargetURL(formats strfmt.Registry) error {

	if err := validate.Required("targetURL", "body", m.TargetURL); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this multi bucket replication based on the context it is used
func (m *MultiBucketReplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBucketsRelation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiBucketReplication) contextValidateBucketsRelation(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.BucketsRelation); i++ {

		if m.BucketsRelation[i] != nil {

			if swag.IsZero(m.BucketsRelation[i]) { // not required
				return nil
			}

			if err := m.BucketsRelation[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("bucketsRelation" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("bucketsRelation" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *MultiBucketReplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MultiBucketReplication) UnmarshalBinary(b []byte) error {
	var res MultiBucketReplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
