package insights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// EventType enumerates the values for event type.
type EventType string

const (
	// All ...
	All EventType = "$all"
	// AvailabilityResults ...
	AvailabilityResults EventType = "availabilityResults"
	// BrowserTimings ...
	BrowserTimings EventType = "browserTimings"
	// CustomEvents ...
	CustomEvents EventType = "customEvents"
	// CustomMetrics ...
	CustomMetrics EventType = "customMetrics"
	// Dependencies ...
	Dependencies EventType = "dependencies"
	// Exceptions ...
	Exceptions EventType = "exceptions"
	// PageViews ...
	PageViews EventType = "pageViews"
	// PerformanceCounters ...
	PerformanceCounters EventType = "performanceCounters"
	// Requests ...
	Requests EventType = "requests"
	// Traces ...
	Traces EventType = "traces"
)

// PossibleEventTypeValues returns an array of possible values for the EventType const type.
func PossibleEventTypeValues() []EventType {
	return []EventType{All, AvailabilityResults, BrowserTimings, CustomEvents, CustomMetrics, Dependencies, Exceptions, PageViews, PerformanceCounters, Requests, Traces}
}

// MetadataColumnDataType enumerates the values for metadata column data type.
type MetadataColumnDataType string

const (
	// Bool ...
	Bool MetadataColumnDataType = "bool"
	// Datetime ...
	Datetime MetadataColumnDataType = "datetime"
	// Dynamic ...
	Dynamic MetadataColumnDataType = "dynamic"
	// Int ...
	Int MetadataColumnDataType = "int"
	// Long ...
	Long MetadataColumnDataType = "long"
	// Real ...
	Real MetadataColumnDataType = "real"
	// String ...
	String MetadataColumnDataType = "string"
)

// PossibleMetadataColumnDataTypeValues returns an array of possible values for the MetadataColumnDataType const type.
func PossibleMetadataColumnDataTypeValues() []MetadataColumnDataType {
	return []MetadataColumnDataType{Bool, Datetime, Dynamic, Int, Long, Real, String}
}

// MetricID enumerates the values for metric id.
type MetricID string

const (
	// AvailabilityResultsavailabilityPercentage ...
	AvailabilityResultsavailabilityPercentage MetricID = "availabilityResults/availabilityPercentage"
	// AvailabilityResultsduration ...
	AvailabilityResultsduration MetricID = "availabilityResults/duration"
	// BillingtelemetryCount ...
	BillingtelemetryCount MetricID = "billing/telemetryCount"
	// ClientnetworkDuration ...
	ClientnetworkDuration MetricID = "client/networkDuration"
	// ClientprocessingDuration ...
	ClientprocessingDuration MetricID = "client/processingDuration"
	// ClientreceiveDuration ...
	ClientreceiveDuration MetricID = "client/receiveDuration"
	// ClientsendDuration ...
	ClientsendDuration MetricID = "client/sendDuration"
	// ClienttotalDuration ...
	ClienttotalDuration MetricID = "client/totalDuration"
	// CustomEventscount ...
	CustomEventscount MetricID = "customEvents/count"
	// Dependenciescount ...
	Dependenciescount MetricID = "dependencies/count"
	// Dependenciesduration ...
	Dependenciesduration MetricID = "dependencies/duration"
	// Dependenciesfailed ...
	Dependenciesfailed MetricID = "dependencies/failed"
	// Exceptionsbrowser ...
	Exceptionsbrowser MetricID = "exceptions/browser"
	// Exceptionscount ...
	Exceptionscount MetricID = "exceptions/count"
	// Exceptionsserver ...
	Exceptionsserver MetricID = "exceptions/server"
	// PageViewscount ...
	PageViewscount MetricID = "pageViews/count"
	// PageViewsduration ...
	PageViewsduration MetricID = "pageViews/duration"
	// PerformanceCountersexceptionsPerSecond ...
	PerformanceCountersexceptionsPerSecond MetricID = "performanceCounters/exceptionsPerSecond"
	// PerformanceCountersmemoryAvailableBytes ...
	PerformanceCountersmemoryAvailableBytes MetricID = "performanceCounters/memoryAvailableBytes"
	// PerformanceCountersprocessCPUPercentage ...
	PerformanceCountersprocessCPUPercentage MetricID = "performanceCounters/processCpuPercentage"
	// PerformanceCountersprocessIOBytesPerSecond ...
	PerformanceCountersprocessIOBytesPerSecond MetricID = "performanceCounters/processIOBytesPerSecond"
	// PerformanceCountersprocessorCPUPercentage ...
	PerformanceCountersprocessorCPUPercentage MetricID = "performanceCounters/processorCpuPercentage"
	// PerformanceCountersprocessPrivateBytes ...
	PerformanceCountersprocessPrivateBytes MetricID = "performanceCounters/processPrivateBytes"
	// PerformanceCountersrequestExecutionTime ...
	PerformanceCountersrequestExecutionTime MetricID = "performanceCounters/requestExecutionTime"
	// PerformanceCountersrequestsInQueue ...
	PerformanceCountersrequestsInQueue MetricID = "performanceCounters/requestsInQueue"
	// PerformanceCountersrequestsPerSecond ...
	PerformanceCountersrequestsPerSecond MetricID = "performanceCounters/requestsPerSecond"
	// Requestscount ...
	Requestscount MetricID = "requests/count"
	// Requestsduration ...
	Requestsduration MetricID = "requests/duration"
	// Requestsfailed ...
	Requestsfailed MetricID = "requests/failed"
	// Sessionscount ...
	Sessionscount MetricID = "sessions/count"
	// Usersauthenticated ...
	Usersauthenticated MetricID = "users/authenticated"
	// Userscount ...
	Userscount MetricID = "users/count"
)

// PossibleMetricIDValues returns an array of possible values for the MetricID const type.
func PossibleMetricIDValues() []MetricID {
	return []MetricID{AvailabilityResultsavailabilityPercentage, AvailabilityResultsduration, BillingtelemetryCount, ClientnetworkDuration, ClientprocessingDuration, ClientreceiveDuration, ClientsendDuration, ClienttotalDuration, CustomEventscount, Dependenciescount, Dependenciesduration, Dependenciesfailed, Exceptionsbrowser, Exceptionscount, Exceptionsserver, PageViewscount, PageViewsduration, PerformanceCountersexceptionsPerSecond, PerformanceCountersmemoryAvailableBytes, PerformanceCountersprocessCPUPercentage, PerformanceCountersprocessIOBytesPerSecond, PerformanceCountersprocessorCPUPercentage, PerformanceCountersprocessPrivateBytes, PerformanceCountersrequestExecutionTime, PerformanceCountersrequestsInQueue, PerformanceCountersrequestsPerSecond, Requestscount, Requestsduration, Requestsfailed, Sessionscount, Usersauthenticated, Userscount}
}

// MetricsAggregation enumerates the values for metrics aggregation.
type MetricsAggregation string

const (
	// Avg ...
	Avg MetricsAggregation = "avg"
	// Count ...
	Count MetricsAggregation = "count"
	// Max ...
	Max MetricsAggregation = "max"
	// Min ...
	Min MetricsAggregation = "min"
	// Sum ...
	Sum MetricsAggregation = "sum"
	// Unique ...
	Unique MetricsAggregation = "unique"
)

// PossibleMetricsAggregationValues returns an array of possible values for the MetricsAggregation const type.
func PossibleMetricsAggregationValues() []MetricsAggregation {
	return []MetricsAggregation{Avg, Count, Max, Min, Sum, Unique}
}

// MetricsSegment enumerates the values for metrics segment.
type MetricsSegment string

const (
	// ApplicationBuild ...
	ApplicationBuild MetricsSegment = "applicationBuild"
	// ApplicationVersion ...
	ApplicationVersion MetricsSegment = "applicationVersion"
	// AuthenticatedOrAnonymousTraffic ...
	AuthenticatedOrAnonymousTraffic MetricsSegment = "authenticatedOrAnonymousTraffic"
	// Browser ...
	Browser MetricsSegment = "browser"
	// BrowserVersion ...
	BrowserVersion MetricsSegment = "browserVersion"
	// City ...
	City MetricsSegment = "city"
	// CloudRoleName ...
	CloudRoleName MetricsSegment = "cloudRoleName"
	// CloudServiceName ...
	CloudServiceName MetricsSegment = "cloudServiceName"
	// Continent ...
	Continent MetricsSegment = "continent"
	// CountryOrRegion ...
	CountryOrRegion MetricsSegment = "countryOrRegion"
	// DeploymentID ...
	DeploymentID MetricsSegment = "deploymentId"
	// DeploymentUnit ...
	DeploymentUnit MetricsSegment = "deploymentUnit"
	// DeviceType ...
	DeviceType MetricsSegment = "deviceType"
	// Environment ...
	Environment MetricsSegment = "environment"
	// HostingLocation ...
	HostingLocation MetricsSegment = "hostingLocation"
	// InstanceName ...
	InstanceName MetricsSegment = "instanceName"
)

// PossibleMetricsSegmentValues returns an array of possible values for the MetricsSegment const type.
func PossibleMetricsSegmentValues() []MetricsSegment {
	return []MetricsSegment{ApplicationBuild, ApplicationVersion, AuthenticatedOrAnonymousTraffic, Browser, BrowserVersion, City, CloudRoleName, CloudServiceName, Continent, CountryOrRegion, DeploymentID, DeploymentUnit, DeviceType, Environment, HostingLocation, InstanceName}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAvailabilityResult ...
	TypeAvailabilityResult Type = "availabilityResult"
	// TypeBrowserTiming ...
	TypeBrowserTiming Type = "browserTiming"
	// TypeCustomEvent ...
	TypeCustomEvent Type = "customEvent"
	// TypeCustomMetric ...
	TypeCustomMetric Type = "customMetric"
	// TypeDependency ...
	TypeDependency Type = "dependency"
	// TypeEventsResultData ...
	TypeEventsResultData Type = "eventsResultData"
	// TypeException ...
	TypeException Type = "exception"
	// TypePageView ...
	TypePageView Type = "pageView"
	// TypePerformanceCounter ...
	TypePerformanceCounter Type = "performanceCounter"
	// TypeRequest ...
	TypeRequest Type = "request"
	// TypeTrace ...
	TypeTrace Type = "trace"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAvailabilityResult, TypeBrowserTiming, TypeCustomEvent, TypeCustomMetric, TypeDependency, TypeEventsResultData, TypeException, TypePageView, TypePerformanceCounter, TypeRequest, TypeTrace}
}
