package kubernetesconfiguration

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ComplianceState enumerates the values for compliance state.
type ComplianceState string

const (
	// Compliant ...
	Compliant ComplianceState = "Compliant"
	// Failed ...
	Failed ComplianceState = "Failed"
	// Installed ...
	Installed ComplianceState = "Installed"
	// Noncompliant ...
	Noncompliant ComplianceState = "Noncompliant"
	// Pending ...
	Pending ComplianceState = "Pending"
)

// PossibleComplianceStateValues returns an array of possible values for the ComplianceState const type.
func PossibleComplianceStateValues() []ComplianceState {
	return []ComplianceState{Compliant, Failed, Installed, Noncompliant, Pending}
}

// EnableHelmOperator enumerates the values for enable helm operator.
type EnableHelmOperator string

const (
	// False ...
	False EnableHelmOperator = "false"
	// True ...
	True EnableHelmOperator = "true"
)

// PossibleEnableHelmOperatorValues returns an array of possible values for the EnableHelmOperator const type.
func PossibleEnableHelmOperatorValues() []EnableHelmOperator {
	return []EnableHelmOperator{False, True}
}

// MessageLevel enumerates the values for message level.
type MessageLevel string

const (
	// Error ...
	Error MessageLevel = "Error"
	// Information ...
	Information MessageLevel = "Information"
	// Warning ...
	Warning MessageLevel = "Warning"
)

// PossibleMessageLevelValues returns an array of possible values for the MessageLevel const type.
func PossibleMessageLevelValues() []MessageLevel {
	return []MessageLevel{Error, Information, Warning}
}

// OperatorScope enumerates the values for operator scope.
type OperatorScope string

const (
	// Cluster ...
	Cluster OperatorScope = "cluster"
	// Namespace ...
	Namespace OperatorScope = "namespace"
)

// PossibleOperatorScopeValues returns an array of possible values for the OperatorScope const type.
func PossibleOperatorScopeValues() []OperatorScope {
	return []OperatorScope{Cluster, Namespace}
}

// OperatorType enumerates the values for operator type.
type OperatorType string

const (
	// Flux ...
	Flux OperatorType = "Flux"
)

// PossibleOperatorTypeValues returns an array of possible values for the OperatorType const type.
func PossibleOperatorTypeValues() []OperatorType {
	return []OperatorType{Flux}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateAccepted ...
	ProvisioningStateAccepted ProvisioningState = "Accepted"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateRunning ...
	ProvisioningStateRunning ProvisioningState = "Running"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateAccepted, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateRunning, ProvisioningStateSucceeded}
}
