package virtualmachineimagebuilder

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VirtualMachineImageTemplateClient is the azure Virtual Machine Image Builder Client
type VirtualMachineImageTemplateClient struct {
	BaseClient
}

// NewVirtualMachineImageTemplateClient creates an instance of the VirtualMachineImageTemplateClient client.
func NewVirtualMachineImageTemplateClient(subscriptionID string) VirtualMachineImageTemplateClient {
	return NewVirtualMachineImageTemplateClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVirtualMachineImageTemplateClientWithBaseURI creates an instance of the VirtualMachineImageTemplateClient client
// using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign
// clouds, Azure stack).
func NewVirtualMachineImageTemplateClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineImageTemplateClient {
	return VirtualMachineImageTemplateClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate create or Update a Virtual Machine Image Template
// Parameters:
// parameters - parameters supplied to the Create Image Template
// resourceGroupName - the name of the resource group.
// imageTemplateName - the name of the image Template
func (client VirtualMachineImageTemplateClient) CreateOrUpdate(ctx context.Context, parameters ImageTemplate, resourceGroupName string, imageTemplateName string) (result VirtualMachineImageTemplateCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImageTemplateClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ImageTemplateProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.ImageTemplateProperties.Distribute", Name: validation.Null, Rule: true, Chain: nil}}}}},
		{TargetValue: imageTemplateName,
			Constraints: []validation.Constraint{{Target: "imageTemplateName", Name: validation.Pattern, Rule: `^[A-Za-z0-9-_]{1,64}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, parameters, resourceGroupName, imageTemplateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "CreateOrUpdate", nil, "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client VirtualMachineImageTemplateClient) CreateOrUpdatePreparer(ctx context.Context, parameters ImageTemplate, resourceGroupName string, imageTemplateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"imageTemplateName": autorest.Encode("path", imageTemplateName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VirtualMachineImages/imageTemplates/{imageTemplateName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImageTemplateClient) CreateOrUpdateSender(req *http.Request) (future VirtualMachineImageTemplateCreateOrUpdateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client VirtualMachineImageTemplateClient) (it ImageTemplate, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("virtualmachineimagebuilder.VirtualMachineImageTemplateCreateOrUpdateFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		it.Response.Response, err = future.GetResult(sender)
		if it.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateCreateOrUpdateFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && it.Response.Response.StatusCode != http.StatusNoContent {
			it, err = client.CreateOrUpdateResponder(it.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateCreateOrUpdateFuture", "Result", it.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client VirtualMachineImageTemplateClient) CreateOrUpdateResponder(resp *http.Response) (result ImageTemplate, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete Virtual Machine Image Template
// Parameters:
// resourceGroupName - the name of the resource group.
// imageTemplateName - the name of the image Template
func (client VirtualMachineImageTemplateClient) Delete(ctx context.Context, resourceGroupName string, imageTemplateName string) (result VirtualMachineImageTemplateDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImageTemplateClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: imageTemplateName,
			Constraints: []validation.Constraint{{Target: "imageTemplateName", Name: validation.Pattern, Rule: `^[A-Za-z0-9-_]{1,64}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, imageTemplateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Delete", nil, "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client VirtualMachineImageTemplateClient) DeletePreparer(ctx context.Context, resourceGroupName string, imageTemplateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"imageTemplateName": autorest.Encode("path", imageTemplateName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VirtualMachineImages/imageTemplates/{imageTemplateName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImageTemplateClient) DeleteSender(req *http.Request) (future VirtualMachineImageTemplateDeleteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client VirtualMachineImageTemplateClient) (ar autorest.Response, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateDeleteFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("virtualmachineimagebuilder.VirtualMachineImageTemplateDeleteFuture")
			return
		}
		ar.Response = future.Response()
		return
	}
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client VirtualMachineImageTemplateClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get Information about Virtual Machine Image Template
// Parameters:
// resourceGroupName - the name of the resource group.
// imageTemplateName - the name of the image Template
func (client VirtualMachineImageTemplateClient) Get(ctx context.Context, resourceGroupName string, imageTemplateName string) (result ImageTemplate, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImageTemplateClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: imageTemplateName,
			Constraints: []validation.Constraint{{Target: "imageTemplateName", Name: validation.Pattern, Rule: `^[A-Za-z0-9-_]{1,64}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, imageTemplateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client VirtualMachineImageTemplateClient) GetPreparer(ctx context.Context, resourceGroupName string, imageTemplateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"imageTemplateName": autorest.Encode("path", imageTemplateName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VirtualMachineImages/imageTemplates/{imageTemplateName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImageTemplateClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client VirtualMachineImageTemplateClient) GetResponder(resp *http.Response) (result ImageTemplate, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRunOutput get the specified run output for the specified Template resource
// Parameters:
// resourceGroupName - the name of the resource group.
// imageTemplateName - the name of the image Template
// runOutputName - the name of the run output
func (client VirtualMachineImageTemplateClient) GetRunOutput(ctx context.Context, resourceGroupName string, imageTemplateName string, runOutputName string) (result RunOutput, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImageTemplateClient.GetRunOutput")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: imageTemplateName,
			Constraints: []validation.Constraint{{Target: "imageTemplateName", Name: validation.Pattern, Rule: `^[A-Za-z0-9-_]{1,64}$`, Chain: nil}}},
		{TargetValue: runOutputName,
			Constraints: []validation.Constraint{{Target: "runOutputName", Name: validation.Pattern, Rule: `^[A-Za-z0-9-_]{1,64}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "GetRunOutput", err.Error())
	}

	req, err := client.GetRunOutputPreparer(ctx, resourceGroupName, imageTemplateName, runOutputName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "GetRunOutput", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRunOutputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "GetRunOutput", resp, "Failure sending request")
		return
	}

	result, err = client.GetRunOutputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "GetRunOutput", resp, "Failure responding to request")
		return
	}

	return
}

// GetRunOutputPreparer prepares the GetRunOutput request.
func (client VirtualMachineImageTemplateClient) GetRunOutputPreparer(ctx context.Context, resourceGroupName string, imageTemplateName string, runOutputName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"imageTemplateName": autorest.Encode("path", imageTemplateName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"runOutputName":     autorest.Encode("path", runOutputName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VirtualMachineImages/imageTemplates/{imageTemplateName}/runOutputs/{runOutputName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRunOutputSender sends the GetRunOutput request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImageTemplateClient) GetRunOutputSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetRunOutputResponder handles the response to the GetRunOutput request. The method always
// closes the http.Response Body.
func (client VirtualMachineImageTemplateClient) GetRunOutputResponder(resp *http.Response) (result RunOutput, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List gets information about the VM image templates associated with the subscription.
func (client VirtualMachineImageTemplateClient) List(ctx context.Context) (result ImageTemplateListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImageTemplateClient.List")
		defer func() {
			sc := -1
			if result.itlr.Response.Response != nil {
				sc = result.itlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.itlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "List", resp, "Failure sending request")
		return
	}

	result.itlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "List", resp, "Failure responding to request")
		return
	}
	if result.itlr.hasNextLink() && result.itlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client VirtualMachineImageTemplateClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.VirtualMachineImages/imageTemplates", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImageTemplateClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client VirtualMachineImageTemplateClient) ListResponder(resp *http.Response) (result ImageTemplateListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client VirtualMachineImageTemplateClient) listNextResults(ctx context.Context, lastResults ImageTemplateListResult) (result ImageTemplateListResult, err error) {
	req, err := lastResults.imageTemplateListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client VirtualMachineImageTemplateClient) ListComplete(ctx context.Context) (result ImageTemplateListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImageTemplateClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// ListByResourceGroup gets information about the VM image templates associated with the specified resource group.
// Parameters:
// resourceGroupName - the name of the resource group.
func (client VirtualMachineImageTemplateClient) ListByResourceGroup(ctx context.Context, resourceGroupName string) (result ImageTemplateListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImageTemplateClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.itlr.Response.Response != nil {
				sc = result.itlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.itlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.itlr, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "ListByResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.itlr.hasNextLink() && result.itlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client VirtualMachineImageTemplateClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VirtualMachineImages/imageTemplates", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImageTemplateClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client VirtualMachineImageTemplateClient) ListByResourceGroupResponder(resp *http.Response) (result ImageTemplateListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client VirtualMachineImageTemplateClient) listByResourceGroupNextResults(ctx context.Context, lastResults ImageTemplateListResult) (result ImageTemplateListResult, err error) {
	req, err := lastResults.imageTemplateListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client VirtualMachineImageTemplateClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result ImageTemplateListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImageTemplateClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName)
	return
}

// ListRunOutputs list all run outputs for the specified Image Template resource
// Parameters:
// resourceGroupName - the name of the resource group.
// imageTemplateName - the name of the image Template
func (client VirtualMachineImageTemplateClient) ListRunOutputs(ctx context.Context, resourceGroupName string, imageTemplateName string) (result RunOutputCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImageTemplateClient.ListRunOutputs")
		defer func() {
			sc := -1
			if result.roc.Response.Response != nil {
				sc = result.roc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: imageTemplateName,
			Constraints: []validation.Constraint{{Target: "imageTemplateName", Name: validation.Pattern, Rule: `^[A-Za-z0-9-_]{1,64}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "ListRunOutputs", err.Error())
	}

	result.fn = client.listRunOutputsNextResults
	req, err := client.ListRunOutputsPreparer(ctx, resourceGroupName, imageTemplateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "ListRunOutputs", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRunOutputsSender(req)
	if err != nil {
		result.roc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "ListRunOutputs", resp, "Failure sending request")
		return
	}

	result.roc, err = client.ListRunOutputsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "ListRunOutputs", resp, "Failure responding to request")
		return
	}
	if result.roc.hasNextLink() && result.roc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListRunOutputsPreparer prepares the ListRunOutputs request.
func (client VirtualMachineImageTemplateClient) ListRunOutputsPreparer(ctx context.Context, resourceGroupName string, imageTemplateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"imageTemplateName": autorest.Encode("path", imageTemplateName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VirtualMachineImages/imageTemplates/{imageTemplateName}/runOutputs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListRunOutputsSender sends the ListRunOutputs request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImageTemplateClient) ListRunOutputsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListRunOutputsResponder handles the response to the ListRunOutputs request. The method always
// closes the http.Response Body.
func (client VirtualMachineImageTemplateClient) ListRunOutputsResponder(resp *http.Response) (result RunOutputCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listRunOutputsNextResults retrieves the next set of results, if any.
func (client VirtualMachineImageTemplateClient) listRunOutputsNextResults(ctx context.Context, lastResults RunOutputCollection) (result RunOutputCollection, err error) {
	req, err := lastResults.runOutputCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "listRunOutputsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListRunOutputsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "listRunOutputsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListRunOutputsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "listRunOutputsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListRunOutputsComplete enumerates all values, automatically crossing page boundaries as required.
func (client VirtualMachineImageTemplateClient) ListRunOutputsComplete(ctx context.Context, resourceGroupName string, imageTemplateName string) (result RunOutputCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImageTemplateClient.ListRunOutputs")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListRunOutputs(ctx, resourceGroupName, imageTemplateName)
	return
}

// Run create artifacts from a existing Image Template
// Parameters:
// resourceGroupName - the name of the resource group.
// imageTemplateName - the name of the image Template
func (client VirtualMachineImageTemplateClient) Run(ctx context.Context, resourceGroupName string, imageTemplateName string) (result VirtualMachineImageTemplateRunFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImageTemplateClient.Run")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: imageTemplateName,
			Constraints: []validation.Constraint{{Target: "imageTemplateName", Name: validation.Pattern, Rule: `^[A-Za-z0-9-_]{1,64}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Run", err.Error())
	}

	req, err := client.RunPreparer(ctx, resourceGroupName, imageTemplateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Run", nil, "Failure preparing request")
		return
	}

	result, err = client.RunSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Run", nil, "Failure sending request")
		return
	}

	return
}

// RunPreparer prepares the Run request.
func (client VirtualMachineImageTemplateClient) RunPreparer(ctx context.Context, resourceGroupName string, imageTemplateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"imageTemplateName": autorest.Encode("path", imageTemplateName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VirtualMachineImages/imageTemplates/{imageTemplateName}/run", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RunSender sends the Run request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImageTemplateClient) RunSender(req *http.Request) (future VirtualMachineImageTemplateRunFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client VirtualMachineImageTemplateClient) (ar autorest.Response, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateRunFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("virtualmachineimagebuilder.VirtualMachineImageTemplateRunFuture")
			return
		}
		ar.Response = future.Response()
		return
	}
	return
}

// RunResponder handles the response to the Run request. The method always
// closes the http.Response Body.
func (client VirtualMachineImageTemplateClient) RunResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Update update the tags for this Virtual Machine Image Template
// Parameters:
// parameters - additional parameters for Image Template update.
// resourceGroupName - the name of the resource group.
// imageTemplateName - the name of the image Template
func (client VirtualMachineImageTemplateClient) Update(ctx context.Context, parameters ImageTemplateUpdateParameters, resourceGroupName string, imageTemplateName string) (result ImageTemplate, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualMachineImageTemplateClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: imageTemplateName,
			Constraints: []validation.Constraint{{Target: "imageTemplateName", Name: validation.Pattern, Rule: `^[A-Za-z0-9-_]{1,64}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, parameters, resourceGroupName, imageTemplateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplateClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client VirtualMachineImageTemplateClient) UpdatePreparer(ctx context.Context, parameters ImageTemplateUpdateParameters, resourceGroupName string, imageTemplateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"imageTemplateName": autorest.Encode("path", imageTemplateName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VirtualMachineImages/imageTemplates/{imageTemplateName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualMachineImageTemplateClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client VirtualMachineImageTemplateClient) UpdateResponder(resp *http.Response) (result ImageTemplate, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
