---
title: "Announcing Atlas v0.3.0: A UI-powered schema migration experience"
date: "2022-01-19"
author: Hila Kashai
authorURL: "https://github.com/hilakashai"
authorImageURL: "https://avatars.githubusercontent.com/u/73284641?v=4"
authorTwitter: HilaKash
url: /atlas-v030/
image: https://blog.ariga.io/uploads/images/posts/atlas-v0.3.0/atlas-post-save.png
---

Earlier this week we released [v0.3.0](https://github.com/ariga/atlas/releases/tag/v0.3.0) of the
Atlas CLI. This version features a ton of improvements to database inspection, diffing and migration planning.
You can read about those in the release notes page, but we wanted to take the time and introduce
the biggest feature in this release, the _Atlas Management UI_.

To recap, [Atlas](https://atlasgo.io/) is an open source CLI tool that helps developers manage their database schemas.
Contrary to existing tools, Atlas intelligently plans schema migrations for you, based on your desired state.
Atlas currently has two main commands: `inspect` and `apply`. The `inspect` command inspects your database, generating an Atlas HCL document.
The `apply` command allows you to migrate your schema from its current state in the database to your desired state by providing an HCL file with the relevant schema.

In this post we will showcase the latest addition to the CLI's feature set, the Management UI. Until now,
you could use Atlas to manage your schemas via your terminal. While this is the common interface for
many infrastructure management workflows, we believe that a visual, integrated environment can be
beneficial in many use-cases.

### Inspecting our database using the Atlas UI

Let's see how we can use the Atlas UI to inspect our database.

For the purpose of demonstration let's assume that you have a locally running MySQL database.
If you want to follow along, check out the [Setting Up](https://atlasgo.io/cli/getting-started/setting-up)
tutorial on the Atlas website for instructions on starting up a MySQL database locally using Docker.

We will be working with a MySQL database that has the following tables:

```sql
CREATE table users (
    id int PRIMARY KEY,
    name varchar(100)
);
CREATE TABLE blog_posts (
    id int PRIMARY KEY,
    title varchar(100),
    body text,
    author_id int,
    FOREIGN KEY (author_id) REFERENCES users(id)
);
```

To inspect the database, we can use the <code>[atlas schema inspect](https://atlasgo.io/cli-reference#atlas-schema-inspect)</code>
command. Starting with this version, we can add the `-w` flag to open the (local) web UI:

```text
atlas schema inspect -u "mysql://root:pass@localhost:3306/example" -w
```

Our browser will open automatically, and we should see this output in the CLI:
```text
Atlas UI available at: http://127.0.0.1:5800/projects/25769803777/schemas/1
Press Ctrl+C to stop
```

![inspect_image](https://blog.ariga.io/uploads/images/posts/atlas-v0.3.0/atlas-post-ui.png)

We can see that our schema has been inspected, and that it's currently synced. On the bottom-left
part of the screen the UI displays an ERD (Entity-relation Diagram) showing the different tables
and the connections between them (via foreign-keys). On the bottom-right, we can see the current
schema, described using the Atlas DDL.  In addition, on the top-right, we see the "Activity & History"
panel that holds an audit history for all changes to our schema.


### Migrating our database schema with the Atlas Management UI

Visualizing the current schema of the database is great, let's now see how we can use the UI
to initiate a change (migration) to our schema.

Click on the `Edit Schema` button in the top-right corner and add the following two tables to our schema:

```hcl
table "categories" {
  schema = schema.example
  column "id" {
    null = false
    type = int
  }
  column "name" {
    null = true
    type = varchar(100)
  }
  primary_key {
    columns = [table.categories.column.id, ]
  }
}

table "post_categories" {
    schema = schema.example
    column "post_id" {
        type = int
    }
    column "category_id" {
        type = int
    }
    foreign_key "post_category_post" {
        columns     = [table.post_categories.column.post_id, ]
        ref_columns = [table.blog_posts.column.id, ]
    }
    foreign_key "post_category_category" {
        columns     = [table.post_categories.column.category_id, ]
        ref_columns = [table.categories.column.id, ]
    }
}
```

Click the `Save` button and go back to the schema page. Observe that a few things changed on the screen:

![The UI after saving](https://blog.ariga.io/uploads/images/posts/atlas-v0.3.0/atlas-post-save.png)

First, we can see that the UI states that our schema is "Out of Sync". This is because there is a difference
between our *desired schema*, the one we are currently working on, and the *inspected schema*, which
is the actual, current schema of our database.

Second, we can  see that our ERD has changed reflecting the addition of the `categories` and `post_categories`
tables to our schema. These two tables that have been added are now shown in green. By clicking the "expand"
icon on the top-right corner of the ERD panel, we can open a more detailed view of our schema.

![ERD displaying diff](https://blog.ariga.io/uploads/images/posts/atlas-v0.3.0/atlas-post-erd.png)

Going back to our schema page, click the "Migrate Schema" to initiate a migration to apply the changes
we want to make to our schema. Next, Atlas will setup the migration. Click "Plan Migration" to see the migration
plan to get to the desired schema:

![Migration Prep](https://blog.ariga.io/uploads/images/posts/atlas-v0.3.0/atlas-migration-prep.png)

Atlas displays the diff in the schema in HCL on the left pane, and the planned SQL statements on the right.
Click "Apply Migration" to begin executing the plan.

![Migration Plan](https://blog.ariga.io/uploads/images/posts/atlas-v0.3.0/atlas-migration-plan.png)

In the final screen of the migration flow, Atlas displays informative logs about the migration process.
In this case, our migration completed successfully! Let's click "Done" to return to the schema detail
page.

![Applying Migration](https://blog.ariga.io/uploads/images/posts/atlas-v0.3.0/atlas-migration-apply.png)

As expected, after executing our migration plan, our database and desired schema are now synced!

![Post Migrations](https://blog.ariga.io/uploads/images/posts/atlas-v0.3.0/atlas-migration-post.png)

### Wrapping Up

In this post, we've introduced the Atlas Management UI and showed one of the possible workflows
that are supported in it. There's much more inside, and we invite you to [install it today](https://atlasgo.io/cli/getting-started/setting-up)
and give it a try.

### What next?
* Follow the [Getting Started](https://atlasgo.io/cli/getting-started/setting-up) guide.
* Join our [Discord Server](https://discord.gg/zZ6sWVg6NT).
* Follow us [on Twitter](https://twitter.com/ariga_io).
