//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by defaulter-gen. DO NOT EDIT.

package wholepkg

import (
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// RegisterDefaults adds defaulters functions to the given scheme.
// Public to allow building arbitrary schemes.
// All generated defaulters are covering - they call all nested defaulters.
func RegisterDefaults(scheme *runtime.Scheme) error {
	scheme.AddTypeDefaultingFunc(&StructEverything{}, func(obj interface{}) { SetObjectDefaults_StructEverything(obj.(*StructEverything)) })
	scheme.AddTypeDefaultingFunc(&StructPointer{}, func(obj interface{}) { SetObjectDefaults_StructPointer(obj.(*StructPointer)) })
	scheme.AddTypeDefaultingFunc(&StructPrimitives{}, func(obj interface{}) { SetObjectDefaults_StructPrimitives(obj.(*StructPrimitives)) })
	scheme.AddTypeDefaultingFunc(&StructSlices{}, func(obj interface{}) { SetObjectDefaults_StructSlices(obj.(*StructSlices)) })
	scheme.AddTypeDefaultingFunc(&StructStructPrimitives{}, func(obj interface{}) { SetObjectDefaults_StructStructPrimitives(obj.(*StructStructPrimitives)) })
	return nil
}

func SetObjectDefaults_StructEverything(in *StructEverything) {
	SetObjectDefaults_StructPointer(&in.PointerStructField)
	SetObjectDefaults_StructSlices(&in.SlicesStructField)
}

func SetObjectDefaults_StructPointer(in *StructPointer) {
	SetObjectDefaults_StructPrimitives(&in.PointerStructPrimitivesField)
	if in.PointerPointerStructPrimitivesField != nil {
		SetObjectDefaults_StructPrimitives(in.PointerPointerStructPrimitivesField)
	}
	SetObjectDefaults_StructStructPrimitives(&in.PointerStructStructPrimitives)
	if in.PointerPointerStructStructPrimitives != nil {
		SetObjectDefaults_StructStructPrimitives(in.PointerPointerStructStructPrimitives)
	}
}

func SetObjectDefaults_StructPrimitives(in *StructPrimitives) {
	SetDefaults_StructPrimitives(in)
}

func SetObjectDefaults_StructSlices(in *StructSlices) {
	for i := range in.SliceStructPrimitivesField {
		a := &in.SliceStructPrimitivesField[i]
		SetObjectDefaults_StructPrimitives(a)
	}
	for i := range in.SlicePointerStructPrimitivesField {
		a := in.SlicePointerStructPrimitivesField[i]
		if a != nil {
			SetObjectDefaults_StructPrimitives(a)
		}
	}
	for i := range in.SliceStructStructPrimitives {
		a := &in.SliceStructStructPrimitives[i]
		SetObjectDefaults_StructStructPrimitives(a)
	}
	for i := range in.SlicePointerStructStructPrimitives {
		a := in.SlicePointerStructStructPrimitives[i]
		if a != nil {
			SetObjectDefaults_StructStructPrimitives(a)
		}
	}
}

func SetObjectDefaults_StructStructPrimitives(in *StructStructPrimitives) {
	SetObjectDefaults_StructPrimitives(&in.StructField)
}
