/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.RpcTokenException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.AbstractRemoteServiceServlet;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyClient;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteServiceServlet
extends AbstractRemoteServiceServlet
implements SerializationPolicyProvider {
    private static final SerializationPolicyClient CODE_SERVER_CLIENT = new SerializationPolicyClient(5000, 5000);
    private final Map<String, SerializationPolicy> serializationPolicyCache = new HashMap<String, SerializationPolicy>();
    private final Object delegate;
    private int codeServerPort = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SerializationPolicy loadSerializationPolicy(HttpServlet servlet, HttpServletRequest request, String moduleBaseURL, String strongName) {
        String contextPath = request.getContextPath();
        String modulePath = null;
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                servlet.log("Malformed moduleBaseURL: " + moduleBaseURL, (Throwable)ex);
            }
        }
        SerializationPolicy serializationPolicy = null;
        if (modulePath == null || !modulePath.startsWith(contextPath)) {
            String message = "ERROR: The module path requested, " + modulePath + ", is not in the same web application as this servlet, " + contextPath + ".  Your module may not be properly configured or your client and server code maybe out of date.";
            servlet.log(message);
        } else {
            String contextRelativePath = modulePath.substring(contextPath.length());
            String serializationPolicyFilePath = SerializationPolicyLoader.getSerializationPolicyFileName(contextRelativePath + strongName);
            InputStream is = servlet.getServletContext().getResourceAsStream(serializationPolicyFilePath);
            try {
                if (is != null) {
                    try {
                        serializationPolicy = SerializationPolicyLoader.loadFromStream(is, null);
                    }
                    catch (ParseException e) {
                        servlet.log("ERROR: Failed to parse the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                    catch (IOException e) {
                        servlet.log("ERROR: Could not read the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                } else {
                    String message = "ERROR: The serialization policy file '" + serializationPolicyFilePath + "' was not found; did you forget to include it in this deployment?";
                    servlet.log(message);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return serializationPolicy;
    }

    public RemoteServiceServlet() {
        this.delegate = this;
    }

    public RemoteServiceServlet(Object delegate) {
        this.delegate = delegate;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.codeServerPort = this.getCodeServerPort();
    }

    private int getCodeServerPort() throws ServletException {
        String value = System.getProperty("gwt.codeserver.port");
        if (value == null) {
            return 0;
        }
        try {
            int port = Integer.parseInt(value);
            if (port >= 0 && port < 65536) {
                return port;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new ServletException("Invalid value of gwt.codeserver.port system property; expected an integer in the range [1-65535] but got: " + value);
    }

    protected String getRequestModuleBasePath() {
        try {
            String contextPath;
            String header = this.getThreadLocalRequest().getHeader("X-GWT-Module-Base");
            if (header == null) {
                return null;
            }
            String path = new URL(header).getPath();
            if (!path.startsWith(contextPath = this.getThreadLocalRequest().getContextPath())) {
                return null;
            }
            return path.substring(contextPath.length());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public final SerializationPolicy getSerializationPolicy(String moduleBaseURL, String strongName) {
        String url;
        SerializationPolicy serializationPolicy = this.getCachedSerializationPolicy(moduleBaseURL, strongName);
        if (serializationPolicy != null) {
            return serializationPolicy;
        }
        serializationPolicy = this.doGetSerializationPolicy(this.getThreadLocalRequest(), moduleBaseURL, strongName);
        if (serializationPolicy == null && (url = this.getCodeServerPolicyUrl(strongName)) != null) {
            serializationPolicy = this.loadPolicyFromCodeServer(url);
        }
        if (serializationPolicy == null) {
            this.log("WARNING: Failed to get the SerializationPolicy '" + strongName + "' for module '" + moduleBaseURL + "'; a legacy, 1.3.3 compatible, serialization policy will be used.  You may experience SerializationExceptions as a result.");
            serializationPolicy = RPC.getDefaultSerializationPolicy();
        }
        this.putCachedSerializationPolicy(moduleBaseURL, strongName, serializationPolicy);
        return serializationPolicy;
    }

    public String processCall(String payload) throws SerializationException {
        RPCRequest rpcRequest;
        this.checkPermutationStrongName();
        try {
            rpcRequest = RPC.decodeRequest(payload, this.delegate.getClass(), this);
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.log("An IncompatibleRemoteServiceException was thrown while processing this call.", ex);
            return RPC.encodeResponseForFailedRequest(null, ex);
        }
        return this.processCall(rpcRequest);
    }

    public String processCall(RPCRequest rpcRequest) throws SerializationException {
        try {
            this.onAfterRequestDeserialized(rpcRequest);
            return RPC.invokeAndEncodeResponse(this.delegate, rpcRequest.getMethod(), rpcRequest.getParameters(), rpcRequest.getSerializationPolicy(), rpcRequest.getFlags());
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.log("An IncompatibleRemoteServiceException was thrown while processing this call.", ex);
            return RPC.encodeResponseForFailedRequest(rpcRequest, ex);
        }
        catch (RpcTokenException tokenException) {
            this.log("An RpcTokenException was thrown while processing this call.", tokenException);
            return RPC.encodeResponseForFailedRequest(rpcRequest, tokenException);
        }
    }

    @Override
    public final void processPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, SerializationException {
        String requestPayload = this.readContent(request);
        this.onBeforeRequestDeserialized(requestPayload);
        String responsePayload = this.processCall(requestPayload);
        this.onAfterResponseSerialized(responsePayload);
        this.writeResponse(request, response, responsePayload);
    }

    protected void checkPermutationStrongName() throws SecurityException {
        if (this.getPermutationStrongName() == null) {
            throw new SecurityException("Blocked request without GWT permutation header (XSRF attack?)");
        }
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        return RemoteServiceServlet.loadSerializationPolicy(this, request, moduleBaseURL, strongName);
    }

    protected String getCodeServerPolicyUrl(String strongName) {
        if (this.codeServerPort <= 0) {
            return null;
        }
        return "http://localhost:" + this.codeServerPort + "/policies/" + strongName + ".gwt.rpc";
    }

    protected SerializationPolicy loadPolicyFromCodeServer(String url) {
        SerializationPolicyClient.Logger adapter = new SerializationPolicyClient.Logger(){

            @Override
            public void logInfo(String message) {
                RemoteServiceServlet.this.log(message);
            }

            @Override
            public void logError(String message, Throwable throwable) {
                RemoteServiceServlet.this.log(message, throwable);
            }
        };
        return CODE_SERVER_CLIENT.loadPolicy(url, adapter);
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
    }

    protected void onBeforeRequestDeserialized(String serializedRequest) {
    }

    protected boolean shouldCompressResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) {
        return RPCServletUtils.exceedsUncompressedContentLengthLimit(responsePayload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerializationPolicy getCachedSerializationPolicy(String moduleBaseURL, String strongName) {
        Map<String, SerializationPolicy> map = this.serializationPolicyCache;
        synchronized (map) {
            return this.serializationPolicyCache.get(moduleBaseURL + strongName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedSerializationPolicy(String moduleBaseURL, String strongName, SerializationPolicy serializationPolicy) {
        Map<String, SerializationPolicy> map = this.serializationPolicyCache;
        synchronized (map) {
            this.serializationPolicyCache.put(moduleBaseURL + strongName, serializationPolicy);
        }
    }

    private void writeResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) throws IOException {
        boolean gzipEncode = RPCServletUtils.acceptsGzipEncoding(request) && this.shouldCompressResponse(request, response, responsePayload);
        RPCServletUtils.writeResponse(this.getServletContext(), response, responsePayload, gzipEncode);
    }
}

