// nolint
package bce

import (
	"bytes"
	"fmt"
	"io"
	"testing"
)

func TestTeeReadNopCloser(t *testing.T) {
	text := "test-string"
	buf := bytes.NewReader([]byte(text))
	read1 := NewTeeReadNopCloser(io.NopCloser(buf))
	teeRead, _ := read1.(*TeeReadNopCloser)
	ExpectEqual(t, fmt.Errorf("Mark/Reset not support"), teeRead.Reset())
	read2 := NewTeeReadNopCloser(buf)
	teeRead, _ = read2.(*TeeReadNopCloser)
	ExpectEqual(t, fmt.Errorf("Mark is not called yet"), teeRead.Reset())

	var wrBuf bytes.Buffer
	var writers []io.Writer
	var nilErr error = nil
	writers = append(writers, &wrBuf)
	read3 := NewTeeReadNopCloser(buf)
	for _, wr := range writers {
		read3.(*TeeReadNopCloser).AddWriter(wr)
	}
	teeRead, _ = read3.(*TeeReadNopCloser)
	teeRead.Mark()
	rdBuf := make([]byte, len(text))
	n, err := teeRead.Read(rdBuf)
	ExpectEqual(t, nilErr, err)
	ExpectEqual(t, len(text), n)
	ExpectEqual(t, wrBuf.String(), text)
	ExpectEqual(t, nilErr, teeRead.Reset())
	ExpectEqual(t, true, teeRead.IsSeekable())
	offset, err := teeRead.Seek(0, io.SeekStart)
	ExpectEqual(t, err, nil)
	ExpectEqual(t, 0, offset)
	ExpectEqual(t, nil, teeRead.Close())
}

// TestTeeReadNopCloser_Seek_NilReader 是用于测试 TeeReadNopCloser_Seek_NilReader
// generated by Comate
func TestTeeReadNopCloser_Seek_NilReader(t *testing.T) {
	tee := &TeeReadNopCloser{reader: nil}

	// 调用Seek方法，期望返回(0, nil)
	offset, err := tee.Seek(0, io.SeekStart)
	if err != nil {
		t.Errorf("Expected no error, but got %v", err)
	}
	if offset != 0 {
		t.Errorf("Expected offset 0, but got %d", offset)
	}
}
