// Copyright 2018-2020 opcua authors. All rights reserved.
// Use of this source code is governed by a MIT-style license that can be
// found in the LICENSE file.

package uasc

import (
	"testing"
)

func TestAsymmetricSecurityHeader(t *testing.T) {
	cases := []CodecTestCase{
		{
			Name: "normal",
			Struct: NewAsymmetricSecurityHeader(
				"http://gopcua.example/OPCUA/SecurityPolicy#Foo",
				[]byte{0xde, 0xad},
				[]byte{0xbe, 0xef},
				//[]byte{0xde, 0xad, 0xbe, 0xef},
			),
			Bytes: []byte{
				// SecurityPolicyURILength
				0x2e, 0x00, 0x00, 0x00,
				// SecurityPolicyURI
				0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x67,
				0x6f, 0x70, 0x63, 0x75, 0x61, 0x2e, 0x65, 0x78,
				0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x4f, 0x50,
				0x43, 0x55, 0x41, 0x2f, 0x53, 0x65, 0x63, 0x75,
				0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69,
				0x63, 0x79, 0x23, 0x46, 0x6f, 0x6f,
				// SenderCertificate
				0x02, 0x00, 0x00, 0x00, 0xde, 0xad,
				// ReceiverCertificateThumbprint
				0x02, 0x00, 0x00, 0x00, 0xbe, 0xef,
				// dummy Payload
				//0xde, 0xad, 0xbe, 0xef,
			},
		},
		{
			Name: "no-uri",
			Struct: NewAsymmetricSecurityHeader(
				"",
				[]byte{0xde, 0xad},
				[]byte{0xbe, 0xef},
				//[]byte{0xde, 0xad, 0xbe, 0xef},
			),
			Bytes: []byte{
				// SecurityPolicyURILength
				0xff, 0xff, 0xff, 0xff,
				// SenderCertificate
				0x02, 0x00, 0x00, 0x00, 0xde, 0xad,
				// ReceiverCertificateThumbprint
				0x02, 0x00, 0x00, 0x00, 0xbe, 0xef,
				// dummy Payload
				//0xde, 0xad, 0xbe, 0xef,
			},
		},
		{
			Name: "no-cert",
			Struct: NewAsymmetricSecurityHeader(
				"http://gopcua.example/OPCUA/SecurityPolicy#Foo",
				nil,
				[]byte{0xbe, 0xef},
				//[]byte{0xde, 0xad, 0xbe, 0xef},
			),
			Bytes: []byte{
				// SecurityPolicyURILength
				0x2e, 0x00, 0x00, 0x00,
				// SecurityPolicyURI
				0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x67,
				0x6f, 0x70, 0x63, 0x75, 0x61, 0x2e, 0x65, 0x78,
				0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x4f, 0x50,
				0x43, 0x55, 0x41, 0x2f, 0x53, 0x65, 0x63, 0x75,
				0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69,
				0x63, 0x79, 0x23, 0x46, 0x6f, 0x6f,
				// SenderCertificate
				0xff, 0xff, 0xff, 0xff,
				// ReceiverCertificateThumbprint
				0x02, 0x00, 0x00, 0x00, 0xbe, 0xef,
				// dummy Payload
				//0xde, 0xad, 0xbe, 0xef,
			},
		},
		{
			Name: "no-thumb",
			Struct: NewAsymmetricSecurityHeader(
				"http://gopcua.example/OPCUA/SecurityPolicy#Foo",
				[]byte{0xde, 0xad},
				nil,
				//[]byte{0xde, 0xad, 0xbe, 0xef},
			),
			Bytes: []byte{
				// SecurityPolicyURILength
				0x2e, 0x00, 0x00, 0x00,
				// SecurityPolicyURI
				0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x67,
				0x6f, 0x70, 0x63, 0x75, 0x61, 0x2e, 0x65, 0x78,
				0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x4f, 0x50,
				0x43, 0x55, 0x41, 0x2f, 0x53, 0x65, 0x63, 0x75,
				0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69,
				0x63, 0x79, 0x23, 0x46, 0x6f, 0x6f,
				// SenderCertificate
				0x02, 0x00, 0x00, 0x00, 0xde, 0xad,
				// ReceiverCertificateThumbprint
				0xff, 0xff, 0xff, 0xff,
				// dummy Payload
				//0xde, 0xad, 0xbe, 0xef,
			},
		},
		{
			Name: "no-payload",
			Struct: NewAsymmetricSecurityHeader(
				"http://gopcua.example/OPCUA/SecurityPolicy#Foo",
				[]byte{0xde, 0xad},
				[]byte{0xbe, 0xef},
				//nil,
			),
			Bytes: []byte{
				// SecurityPolicyURILength
				0x2e, 0x00, 0x00, 0x00,
				// SecurityPolicyURI
				0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x67,
				0x6f, 0x70, 0x63, 0x75, 0x61, 0x2e, 0x65, 0x78,
				0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2f, 0x4f, 0x50,
				0x43, 0x55, 0x41, 0x2f, 0x53, 0x65, 0x63, 0x75,
				0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69,
				0x63, 0x79, 0x23, 0x46, 0x6f, 0x6f,
				// SenderCertificate
				0x02, 0x00, 0x00, 0x00, 0xde, 0xad,
				// ReceiverCertificateThumbprint
				0x02, 0x00, 0x00, 0x00, 0xbe, 0xef,
			},
		},
		{
			Name: "nothing",
			Struct: NewAsymmetricSecurityHeader(
				"",
				nil,
				nil,
				//nil,
			),
			Bytes: []byte{
				// SecurityPolicyURILength
				0xff, 0xff, 0xff, 0xff,
				// SenderCertificate
				0xff, 0xff, 0xff, 0xff,
				// ReceiverCertificateThumbprint
				0xff, 0xff, 0xff, 0xff,
			},
		},
	}
	RunCodecTest(t, cases)
}
