/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.OID;

public class Null
extends AbstractVariable {
    private static final long serialVersionUID = 6907924131098190092L;
    private int syntax = 5;
    public static final Null noSuchObject = new Null(128);
    public static final Null noSuchInstance = new Null(129);
    public static final Null endOfMibView = new Null(130);
    public static final Null instance = new Null(5);

    public Null() {
    }

    public Null(int n) {
        this.setSyntax(n);
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        BER.decodeNull(bERInputStream, mutableByte);
        this.syntax = mutableByte.getValue() & 0xFF;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public int hashCode() {
        return this.getSyntax();
    }

    public int getBERLength() {
        return 2;
    }

    public boolean equals(Object object) {
        if (object instanceof Null) {
            return ((Null)object).getSyntax() == this.getSyntax();
        }
        return false;
    }

    public int compareTo(Object object) {
        return this.getSyntax() - ((Null)object).getSyntax();
    }

    public String toString() {
        switch (this.getSyntax()) {
            case 128: {
                return "noSuchObject";
            }
            case 129: {
                return "noSuchInstance";
            }
            case 130: {
                return "endOfMibView";
            }
        }
        return "Null";
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeHeader(outputStream, (byte)this.getSyntax(), 0);
    }

    public void setSyntax(int n) {
        if (n != 5 && !Null.isExceptionSyntax(n)) {
            throw new IllegalArgumentException("Syntax " + n + " is incompatible with Null type");
        }
        this.syntax = n;
    }

    public Object clone() {
        return new Null(this.syntax);
    }

    public static boolean isExceptionSyntax(int n) {
        switch (n) {
            case 128: 
            case 129: 
            case 130: {
                return true;
            }
        }
        return false;
    }

    public final int toInt() {
        return this.getSyntax();
    }

    public final long toLong() {
        return this.getSyntax();
    }

    public OID toSubIndex(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void fromSubIndex(OID oID, boolean bl) {
        throw new UnsupportedOperationException();
    }
}

